ORCA/M Asm65816 2.1.0

0001 0000                       print push
0002 0000                       print off
0003 0000
0004 0000                       string asis
0005 0000
0006 0000                       include 'common.equ.src'
0007 0000
0008 0000              ;------------------------------------------
0009 0000              ;
0010 0000              ; Equates from procedure 
0011 0000              ;
0012 0000              ;------------------------------------------
0013 0000              CallStringToText equ 1                  ;conditional code for JudgeName, 14-Apr-91 DAL
0014 0000              AllowLCPeriods equ 0                    ;conditional code allowing blanks in names, 7-Aug-91 DAL
0015 0000                                                      ;(0 = no blanks allowed, 12-Aug-91 GAB)
0016 0000
0017 0000              debug_on equ   00                       ;00 = debug off, <>0 = debug on
0018 0000              word     equ   02                       ;two bytes for a word
0019 0000              blk_size equ   512                      ;standard size of a prodos block
0020 0000              delimiter equ   $3A                     ;pathname delimiter = ":"
0021 0000              min_send_cnt equ   $21                  ;If read < 33 bytes use local routine
0022 0000
0023 0000              vcr_main equ   vcr_dev+2
0024 0000              vol_reserved equ   $0000                ;8 bytes of reserved field from disk
0025 0000              vol_mod  equ   vol_reserved+2           ;volume mod date
0026 0000              vol_create equ   vol_reserved+8         ;create date/time from header
0027 0000              vol_version equ   vol_create+4          ;version of OS that created file
0028 0000              vol_min_version equ   vol_version+1     ;minimum version of OS that can access
0029 0000              vol_access equ   vol_min_version+1      ;access for a file
0030 0000              vol_entry_len equ   vol_access+1        ;entry length of each entry
0031 0000              vol_entries equ   vol_entry_len+1       ;number of entries per block
0032 0000              vol_file_count equ   vol_entries+1      ;number of files in volume directory
0033 0000              vol_bitmap_addr equ   vol_file_count+2  ;starting block of bitmap
0034 0000              vol_total_blks equ   vol_bitmap_addr+2  ;total number of blocks on disk
0035 0000
0036 0000              num_bitmap_blks equ   vol_total_blks+2  ;total number of bitmap blocks
0037 0000              end_bitmap equ   num_bitmap_blks+2      ;1st byte that starts all zeros
0038 0000              avail_bitmap equ   end_bitmap+2         ;1st bitmap block(rel)  with free space
0039 0000              curr_bitmap equ   avail_bitmap+2        ;current bitmap(rel) block in memory
0040 0000              bitmap_dirty equ   curr_bitmap+2        ;0 = bitmap clean, <> 0 = bitmap dirty
0041 0000              free_blocks equ   bitmap_dirty+2        ;Free blocks on volume,$FFFF = unknown
0042 0000              vol_damaged equ   free_blocks+2         ;stops writing to bad disk if <> 00
0043 0000              dirty_file_cnt equ   vol_damaged+2      ;number of files that are open for writing and are dirty
0044 0000              bitmap_start equ   dirty_file_cnt+4+vcr_main
0045 0000              pro_vcr_size equ   bitmap_start+$200
0046 0000              bitmap_mod equ   $FFFF
0047 0000              bitmap_unknown equ   $FFFF
0048 0000              vcr_entry_length equ $000F 
0049 0000
0050 0000              fcr_res_num equ   $0000                 ;resource number of this file
0051 0000              fcr_storage equ   fcr_res_num+2         ;real storage type on disk
0052 0000              fcr_entry_type equ   fcr_storage+2      ;storage type from directory entry
0053 0000              fcr_file_id equ   fcr_entry_type+2      ;used to ID duplicate files
0054 0000              fcr_file_type equ   fcr_file_id+2       ;file type
0055 0000              fcr_key_blk equ   fcr_file_Type+1       ;key block of the file
0056 0000              fcr_blks_used equ   fcr_key_blk+2       ;number of blocks used
0057 0000              fcr_eof  equ   fcr_blks_used+2          ;current end of file
0058 0000              fcr_create equ   fcr_eof+3              ;create date/time ProDOS
0059 0000              fcr_vers equ   fcr_create+4             ;version of o/s that made file
0060 0000              fcr_min_vers equ   fcr_vers+1           ;min version of o/s allowed
0061 0000              fcr_disk_acc equ   fcr_min_vers+1       ;file access
0062 0000              fcr_aux_type equ   fcr_disk_acc+1       ;aux type for this file
0063 0000              fcr_modified equ   fcr_aux_type+2       ;modified date of file
0064 0000              fcr_header_ptr equ   fcr_modified+4     ;key block of dir owner
0065 0000              fcr_status equ   fcr_header_ptr+2       ;offset: current status of file
0066 0000              gde_entry_num equ   fcr_status+2        ;current entry for Get_Dir_Entry
0067 0000              gde_offset equ   gde_entry_num+2        ;current offset to entry
0068 0000              gde_curr_blk equ   gde_offset+2         ;current directory block loaded
0069 0000              gde_tot_files equ   gde_curr_blk+2      ;total files in directory
0070 0000              fcr_curr_mark equ   gde_tot_files+2     ;current file mark
0071 0000              fcr_blks_alloc equ   fcr_curr_mark+4    ;current number of blks alloc
0072 0000              fcr_curr_eof equ   fcr_blks_alloc+2     ;current end of file
0073 0000              fcr_parent equ   fcr_curr_eof+4         ;block number of directory block
0074 0000              fcr_entry_offs equ   fcr_parent+2       ;index to entry within parent block
0075 0000              data_blk_num equ   fcr_entry_offs+2     ;block number of current data block
0076 0000              index_blk_num equ   data_blk_num+2      ;block number of current index block
0077 0000              master_blk_num equ   index_blk_num+2    ;block number of master index block
0078 0000
0079 0000              clr_global_clean equ   $7FFF            ;clear the global clean bit
0080 0000              set_global_clean equ   $8000            ;set the file clean in the FCR
0081 0000              set_access_res equ   $4000              ;set the resource fork bit in the FCR
0082 0000              ClrAllButAccess equ $3FFF               ;clear the resource bit from access word.
0083 0000
0084 0000              fcr_fst_ptr equ   fcr_access+2
0085 0000              fcr_io_start equ   master_blk_num+2+fcr_fst_ptr
0086 0000              fcr_data_size equ   fcr_io_start+$200
0087 0000              fcr_index_size equ   fcr_io_start+$400
0088 0000              fcr_master_size equ   fcr_io_start+$600
0089 0000
0090 0000
0091 0000              my_pblk_ptr equ   fst_start
0092 0000              my_vcr_ptr equ   my_pblk_ptr+4
0093 0000              prodos_vcr_ptr equ   my_vcr_ptr+4
0094 0000              my_fcr_ptr equ   prodos_vcr_ptr+4
0095 0000              pro_fcr_ptr equ   my_fcr_ptr+4
0096 0000              gbuf_ptr equ   pro_fcr_ptr+4
0097 0000              temp_ptr equ   gbuf_ptr+4
0098 0000              temp2_ptr equ   temp_ptr+4
0099 0000              temp3_ptr equ   temp2_ptr+4
0100 0000              temp4_ptr equ   temp3_ptr+4
0101 0000              temp5_ptr equ   temp4_ptr+4
0102 0000              math_temp equ   temp5_ptr+4
0103 0000              data_ptr equ   math_temp+4
0104 0000              index_ptr equ   data_ptr+4
0105 0000              master_ptr equ   index_ptr+4
0106 0000              bitmap   equ   master_ptr+4
0107 0000              users_buf_ptr equ   bitmap+4
0108 0000              sparse_ptr equ   users_buf_ptr+4
0109 0000              newline_ptr equ   sparse_ptr+4
0110 0000              pro_id   equ   $0001                    ;identifies prodos fst
0111 0000              prodos_version equ   $0005              ;current version of the PRODOS.
0112 0000              path1_mask equ   $4000                  ;used to determine if path1 is avail.
0113 0000              path2_mask equ   $0040                  ;used to determine if path2 is avail.
0114 0000              carry    equ   $01                      ;used to set the carry
0115 0000              overflow equ   $40                      ;used to set the overflow flag
0116 0000              in_cache equ   $8002
0117 0000              user_cache_val equ   $0001
0118 0000              class_mask equ   $E000
0119 0000              disk_protect equ   $0004                ;bit to see if disk is protected
0120 0000              max_base equ   $0003
0121 0000              pcount1  equ   1
0122 0000              pcount2  equ   2
0123 0000              pcount3  equ   3
0124 0000              pcount4  equ   4
0125 0000              pcount5  equ   5
0126 0000              pcount6  equ   6
0127 0000              pcount7  equ   7
0128 0000              pcount8  equ   8
0129 0000              pcount9  equ   9
0130 0000              write_call equ   $13
0131 0000
0132 0000              read_enabled equ   $0001                ;1=Read Enabled
0133 0000              write_enabled equ   $0002               ;1=Write Enabled
0134 0000              backup_enabled equ   $0020              ;1=Needs to be backed up
0135 0000              rename_enabled equ   $0040              ;1=Rename allowed
0136 0000              destroy_enabled equ   $0080             ;1=Destroy is enabled
0137 0000              read_access equ   $01
0138 0000              write_access equ   $02
0139 0000              invis_bit equ   $04
0140 0000              read_write_acc equ   $03
0141 0000
0142 0000              seedling_type equ   $0010               ;$0000000 < EOF < $0000201
0143 0000              sapling_type equ   $0020                ;$0000200 < EOF < $0020001
0144 0000              tree_type equ   $0030                   ;$0020000 < EOF < $1000000
0145 0000              pascal_area equ   $0040                 ;Area set aside for Pascal
0146 0000              resource_type equ   $0050               ;Special type for resource files
0147 0000              purge_dir equ   $0060                   ;directory that contains pugred files
0148 0000              subdir_type equ   $00D0                 ;Subdirectory
0149 0000              subdir_header equ   $00E0               ;First entry in sudbirectory
0150 0000              volume_header equ   $00F0               ;First entry in the volume directory
0151 0000              vol_dir_start equ   $0002               ;start of the volume directory
0152 0000              bitmap_strt_blk equ   $0006             ;start of the volume bitmap
0153 0000              entry_length equ   $0027
0154 0000              entries_per_block equ $000D 
0155 0000              parent_index equ   $0027
0156 0000              par_entry_num equ   $0029
0157 0000              res_header equ   08                     ;number of bytes in a header
0158 0000              res_map_size equ   382                  ;size of map for info call
0159 0000              purge_index equ   $0019                 ;index to flag indicating purge files.
0160 0000              purgable_index equ   $0029              ;index to total blocks
0161 0000              purge_flag equ   $00FE
0162 0000              purge_verify equ   $0004
0163 0000              header_file_cnt equ   $0025             ;number of files in a directory
0164 0000              backup_on equ   $20
0165 0000              backup_off equ   $DF
0166 0000              file_type_index equ   $10               ;look at page 168 (ProDOS 8 manual)
0167 0000              key_blk_index equ   $11                 ;index into disk entry
0168 0000              blks_used_index equ   $13
0169 0000              eof_index equ   $15
0170 0000              create_index equ   $18
0171 0000              version_index equ   $1C
0172 0000              min_version equ   $1D
0173 0000              access_index equ   $1E
0174 0000              aux_type_index equ   $1F
0175 0000              last_mod_index equ   $21
0176 0000              header_ptr_index equ $25   
0177 0000              no_root  equ   $8000                    ;indicates root level name is invalid
0178 0000              no_dup   equ   $4000                    ;indicates duplicates are not valid
0179 0000              root_only equ   $2000                   ;allow only the root level in pathname
0180 0000
0181 0000              vol_mod_offset equ   $16                ;offset to the volume mod date field
0182 0000              vol_acc_offset equ   $22                ;offset to the volume access field
0183 0000
0184 0000              dir_file_type equ   $0F
0185 0000              tool_locator equ   $E10000
0186 0000              misc_tools equ   $0003
0187 0000              read_time_hex equ   $000D               ;read the clock via misc_tools
0188 0000
0189 0000              set_time_stamp equ   $0001
0190 0000              get_time_stamp equ   set_time_stamp+$8000
0191 0000              set_upper_case equ   $0002
0192 0000              get_upper_case equ   set_upper_case+$8000
0193 0000
0194 0000              debugger_cmnd equ   $0002
0195 0000              debugger_status equ   debugger_cmnd+$8000
0196 0000
0197 0000              file_dirty equ   $8000                  ;ora masks to active field
0198 0000              data_active equ   $4000
0199 0000              index_active equ   $2000
0200 0000              master_active equ   $1000
0201 0000
0202 0000              file_clean equ   $7FFF                  ;and masks to deactivate field
0203 0000              data_inactive equ   $BFFB
0204 0000              index_inactive equ   $DFFD
0205 0000              master_inactive equ   $EFFE
0206 0000
0207 0000              dirEntry_dirty equ   $0008
0208 0000              dirEntry_clean equ   ÅdirEntry_dirty    ;'Å' is the assembler's one's complement operator
0209 0000              data_dirty equ   $0004
0210 0000              data_clean equ   $FFFB
0211 0000              index_dirty equ   $0002
0212 0000              index_clean equ   $FFFD
0213 0000              master_dirty equ   $0001
0214 0000              master_clean equ   $FFFE
0215 0000
0216 0000              hfs_id   equ   $0006                    ;HFS FST ID
0217 0000              ashare_id equ   $000D                   ;AppleShare FST ID
0218 0000              finfo_type equ   1                      ;HFS FInfo entry type
0219 0000              xfinfo_type equ   2                     ;HFS xFInfo entry type
0220 0000
0221 0000              ;------------------------------------------
0222 0000              ;
0223 0000              ; Equates from procedure data
0224 0000              ;
0225 0000              ;------------------------------------------
0226 0000              drvr_bytes equ   $1A                    ;start at byte $1A and $1B
0227 0000              path_used equ   $0100
0228 0000              vcr_used equ   $0200
0229 0000              fcr_used equ   $0400
0230 0000              io_used  equ   $0800
0231 0000              clr_io_used equ   $F7FF
0232 0000              flush_1st equ   $1000
0233 0000              damage   equ   $2000
0234 0000              max_class1 equ   $0020
0235 0000              max_class2 equ   $0040
0236 0000              max_class3 equ   $0060
0237 0000              max_class4 equ   $0080
0238 0000              max_class5 equ   $00A0
0239 0000              max_class6 equ   $00C0
0240 0000              max_class7 equ   $00E0
0241 0000              max_pcnt1 equ   1+1
0242 0000              max_pcnt2 equ   2+1
0243 0000              max_pcnt3 equ   3+1
0244 0000              max_pcnt4 equ   4+1
0245 0000              max_pcnt5 equ   5+1
0246 0000              max_pcnt6 equ   6+1
0247 0000              max_pcnt7 equ   7+1
0248 0000              max_pcnt8 equ   8+1
0249 0000              max_pcnt9 equ   9+1
0250 0000              max_pcnt10 equ   10+1
0251 0000              max_pcnt11 equ   11+1
0252 0000              max_pcnt12 equ   12+1
0253 0000              max_pcnt13 equ   13+1
0254 0000              max_pcnt14 equ   14+1
0255 0000              max_pcnt15 equ   15+1
0256 0000              max_pcnt16 equ   16+1
0257 0000              max_pcnt17 equ   17+1
0258 0000              do_dirty equ   $4000
0259 0000
0260 0000
0261 0000              ;-----------------------------------------------
0262 0000              ;
0263 0000              ;   Forward addresses and entries
0264 0000              ;
0265 0000              ;-----------------------------------------------
0266 0000
0267 0000                       ENTRY abs_to_rel
0268 0000                       ENTRY activate_vcr
0269 0000                       ENTRY add_free_blk
0270 0000                       ENTRY add_index
0271 0000                       ENTRY appl_call
0272 0000                       ENTRY bitmap_changed
0273 0000                       ENTRY bitmap_corrupt
0274 0000                       ENTRY build_path
0275 0000                       ENTRY build_the_fcr
0276 0000                       ENTRY build_vcr
0277 0000                       ENTRY calc_curr_mark
0278 0000                       ENTRY change_path
0279 0000                       ENTRY check_base
0280 0000                       ENTRY check_dup
0281 0000                       ENTRY check_vcr_first
0282 0000                       ENTRY chk_allocation
0283 0000                       ENTRY chk_vol_syntax
0284 0000                       ENTRY clear_backup
0285 0000                       ENTRY clear_index
0286 0000                       ENTRY close
0287 0000                       ENTRY clr_fcr_status
0288 0000                       ENTRY clr_to_boundary
0289 0000                       ENTRY cmd_error
0290 0000                       ENTRY cmd_tbl
0291 0000                       ENTRY create
0292 0000                       ENTRY damaged_message
0293 0000
0294 0000              IF debug_on<>0 THEN  
0295 0000                       ENTRY debugger
0296 0000              ENDIF     
0297 0000                       ENTRY dec_blk_count
0298 0000                       ENTRY deferred_flush
0299 0000                       ENTRY destroy
0300 0000                       ENTRY dev_with_mount
0301 0000                       ENTRY device_call
0302 0000                       ENTRY dow_convert
0303 0000                       ENTRY end_read_write
0304 0000                       ENTRY entry_to_gstr
0305 0000                       ENTRY eof_to_blks
0306 0000                       ENTRY erase_disk
0307 0000                       ENTRY fast_read
0308 0000                       ENTRY fill_io_buf
0309 0000                       ENTRY find_file
0310 0000                       ENTRY find_resource
0311 0000                       ENTRY find_volume
0312 0000                       ENTRY flush
0313 0000                       ENTRY flush_blocks
0314 0000                       ENTRY flush_data_blk
0315 0000                       ENTRY flush_file
0316 0000                       ENTRY flush_index
0317 0000                       ENTRY force_bitmap
0318 0000                       ENTRY format_disk
0319 0000                       ENTRY fst_specific
0320 0000                       ENTRY get_bit_block
0321 0000                       ENTRY get_data_num
0322 0000                       ENTRY get_dev_num
0323 0000                       ENTRY get_dir_entry
0324 0000                       ENTRY get_eof
0325 0000                       ENTRY get_file_info
0326 0000                       ENTRY get_index_blk
0327 0000                       ENTRY get_mark
0328 0000                       ENTRY get_next_fcr
0329 0000                       ENTRY get_time
0330 0000                       ENTRY get_write_blk
0331 0000                       ENTRY id_disk
0332 0000                       ENTRY issue_mount
0333 0000                       ENTRY judge_name
0334 0000                       ENTRY kill_bitmap
0335 0000                       ENTRY load_data
0336 0000                       ENTRY load_index
0337 0000                       ENTRY make_entry_num
0338 0000                       ENTRY mount_volume
0339 0000                       ENTRY move_dir_entry
0340 0000                       ENTRY move_vol_entry
0341 0000                       ENTRY num_seq_blks
0342 0000                       ENTRY open
0343 0000                       ENTRY range_error
0344 0000                       ENTRY read
0345 0000                       ENTRY read_block
0346 0000                       ENTRY read_with_cache
0347 0000                       ENTRY reset_vcr
0348 0000                       ENTRY sapling_seed
0349 0000                       ENTRY save_curr_mark
0350 0000                       ENTRY send_partial
0351 0000                       ENTRY send_sparse_blk
0352 0000                       ENTRY send_time
0353 0000                       ENTRY set_eof
0354 0000                       ENTRY set_fcr_status
0355 0000                       ENTRY set_file_info
0356 0000                       ENTRY set_mark
0357 0000                       ENTRY set_user_cache
0358 0000                       ENTRY setup_bitmap_ptr
0359 0000                       ENTRY setup_curr_eof
0360 0000                       ENTRY setup_curr_mark
0361 0000                       ENTRY setup_io_buf
0362 0000                       ENTRY setup_io_ptrs
0363 0000                       ENTRY setup_my_fcr
0364 0000                       ENTRY setup_my_vcr
0365 0000                       ENTRY setup_name
0366 0000                       ENTRY setup_vol_mesg
0367 0000                       ENTRY show_damage
0368 0000                       ENTRY shutdown
0369 0000                       ENTRY slug_ripple
0370 0000                       ENTRY standard_req
0371 0000                       ENTRY startup
0372 0000                       ENTRY sub_free_blk
0373 0000                       ENTRY sys_remove_vol
0374 0000                       ENTRY sys_tbl
0375 0000                       ENTRY system_call
0376 0000                       ENTRY tree_sapling
0377 0000                       ENTRY update_key_blk
0378 0000                       ENTRY update_mark_eof
0379 0000                       ENTRY vol_to_buffer
0380 0000                       ENTRY volume
0381 0000                       ENTRY write
0382 0000                       ENTRY write_block
0383 0000                       ENTRY Chk_Dirty_Flag
0384 0000                       ENTRY dirty_flags
0385 0000
0386 0000                       print pop
0387 0000              ;======================================================================
0388 0000              ;
0389 0000              ;ProDOS File System Translator for GS/OS
0390 0000              ;
0391 0000              ;Created:   Feb 25, 1987
0392 0000              ;Modified:  Mar 16, 1988
0393 0000              ;Author:    Rob Turner
0394 0000              ;
0395 0000              ;
0396 0000              ;Copyright Apple Computer Inc. 1987-92  ALL RIGHTS RESERVED
0397 0000              ;
0398 0000              ;======================================================================
0399 0000
0400 0000                       PRINT GEN
0401 0000                       msb   off
0402 0000                       longa on
0403 0000                       longi on
0404 0000
0405 0000              ;equates for the read call.
0406 0000
0407 0000              pblk_12_ref equ   $0000                 ;index to the reference number
0408 0000              pblk_12_buf equ   pblk_12_ref+2         ;index to user's buffer pointer
0409 0000              pblk_12_req equ   pblk_12_buf+4         ;index to request count
0410 0000              pblk_12_tran equ   pblk_12_req+4        ;index to transfer count
0411 0000              pblk_12_cache equ   pblk_12_tran+4      ;index to user provided cache priority
0412 0000
0413 0000              max_read_pcnt equ   $0005
0414 0000
0415 0000              ;equates used by open
0416 0000
0417 0000              pblk_10_access equ   $000A
0418 0000              pblk_10_ftype equ   pblk_10_access+2
0419 0000              pblk_10_aux equ   pblk_10_ftype+2
0420 0000              pblk_10_storage equ   pblk_10_aux+4
0421 0000              pblk_10_eof equ   pblk_10_storage+2
0422 0000              pblk_10_num_res equ   pblk_10_eof+4
0423 0000              pblk_10_create equ   pblk_10_num_res+2
0424 0000              pblk_10_mod equ   pblk_10_create+8
0425 0000              pblk_10_blks equ   pblk_10_mod+8
0426 0000              pblk_10_map equ   pblk_10_blks+4
0427 0000
0428 0000              ;equates used by set_mark
0429 0000
0430 0000              pblk_16_base equ   $0002
0431 0000              pblk_16_disp equ   pblk_16_base+2
0432 0000
0433 0000              ;equates used by get_mark
0434 0000
0435 0000              pblk_17_pos equ   $0002
0436 0000
0437 0000              ;equates used by get_eof
0438 0000
0439 0000              pblk_19_eof equ   $0002
0440 0000
0441 0000              ;equates used by send_info
0442 0000
0443 0000              pblk_s_access equ   $0000
0444 0000              pblk_s_ftype equ   pblk_s_access+2
0445 0000              pblk_s_aux equ   pblk_s_ftype+2
0446 0000              pblk_s_storage equ   pblk_s_aux+4
0447 0000              pblk_s_create equ   pblk_s_storage+2
0448 0000              pblk_s_mod equ   pblk_s_create+8
0449 0000              pblk_s_opt equ   pblk_s_mod+8
0450 0000              pblk_s_eof equ   pblk_s_opt+4
0451 0000              pblk_s_blks equ   pblk_s_eof+4
0452 0000              pblk_s_res_eof equ   pblk_s_blks+4
0453 0000              pblk_s_res_blk equ   pblk_s_res_eof+4
0454 0000
0455 0000              ;equates used by volume
0456 0000
0457 0000              pblk_08_vol equ   $0004
0458 0000              pblk_08_tot equ   pblk_08_vol+4
0459 0000              pblk_08_free equ   pblk_08_tot+4
0460 0000              pblk_08_id equ   pblk_08_free+4
0461 0000              pblk_08_size equ   pblk_08_id+2
0462 0000              pblk_08_purge equ   pblk_08_size+2
0463 0000
0464 0000              ;equates used by set_file_info
0465 0000
0466 0000              pblk_05_accs equ   $0004
0467 0000              pblk_05_ftype equ   pblk_05_accs+2
0468 0000              pblk_05_aux equ   pblk_05_ftype+2
0469 0000              pblk_05_create equ   pblk_05_aux+6
0470 0000              pblk_05_mod equ   pblk_05_create+8
0471 0000              pblk_05_opt equ   pblk_05_mod+8
0472 0000
0473 0000              ;equates used by get_file_info
0474 0000
0475 0000              pblk_06_map equ   $0028
0476 0000
0477 0000              ;equates used by set_eof
0478 0000
0479 0000              pblk_18_odisp equ   $0002
0480 0000              pblk_18_base equ   $0002
0481 0000              pblk_18_disp equ   pblk_18_base+2
0482 0000
0483 0000              ;equates used by create
0484 0000
0485 0000              pblk_01_accs equ   $0004
0486 0000              pblk_01_ftype equ   pblk_01_accs+2
0487 0000              pblk_01_aux equ   pblk_01_ftype+2
0488 0000              pblk_01_stype equ   pblk_01_aux+4
0489 0000              pblk_01_eof1 equ   pblk_01_stype+2
0490 0000              pblk_01_eof2 equ   pblk_01_eof1+4
0491 0000
0492 0000              pblk_01_old_time equ   $000E
0493 0000
0494 0000              ;equates used by get dir entry
0495 0000
0496 0000              pblk_1c_extend equ   $0002
0497 0000              pblk_1c_disp equ   $0002
0498 0000              pblk_1c_name equ   pblk_1c_disp+2
0499 0000              pblk_1c_entry equ   pblk_1c_name+4
0500 0000              pblk_1c_ftype equ   pblk_1c_entry+2
0501 0000              pblk_1c_eof equ   pblk_1c_ftype+2
0502 0000              pblk_1c_blks equ   pblk_1c_eof+4
0503 0000              pblk_1c_create equ   pblk_1c_blks+4
0504 0000              pblk_1c_mod equ   pblk_1c_create+8
0505 0000              pblk_1c_access equ   pblk_1c_mod+8
0506 0000              pblk_1c_aux equ   pblk_1c_access+2
0507 0000              pblk_1c_id equ   pblk_1c_aux+4
0508 0000              pblk_1c_opt equ   pblk_1c_id+2
0509 0000              pblk_1c_res_eof equ   pblk_1c_opt+4
0510 0000              pblk_1c_res_blks equ pblk_1c_res_eof+4 
0511 0000
0512 0000              gde_max_base equ   $0002
0513 0000              bad_file_format equ   $004a
0514 0000
0515 0000              ;equates used by judge_name             1/22/91 CAE
0516 0000
0517 0000              pblk_07_ntype equ   $0002
0518 0000              pblk_07_syntax equ   pblk_07_ntype+2
0519 0000              pblk_07_max_len equ   pblk_07_syntax+4
0520 0000              pblk_07_name equ   pblk_07_max_len+2
0521 0000              pblk_07_nflags equ   pblk_07_name+4
0522 0000
0523 0000              ;equates used by change_path            5-Dec-91 MSD
0524 0000
0525 0000              pblk_04_src equ   $0000                 ; (long) source pathname
0526 0000              pblk_04_dest equ   $0004                ; (long) destination pathname
0527 0000              pblk_04_flags equ   $0008               ; (word) $8000 = assume source is duplicate volume
0528 0000
0529 0000              ; Revisions have been moved to the file "pro.fst.revisions" in the ProDOS project
0530 0000              ; by Monte Benaresh on 6/21/90
0531 0000
0532 0000              ;======================================================================
0533 0000              ;Below is the FST header definition used by GS/OS at boot time
0534 0000              ;======================================================================
0535 0000
0536 0000                       EXPORT fst_header
0537 0000              fst_header PROC 
0538 0000                       EXPORT code_start
0539 0000              code_start              
0540 0000
0541 0000 46 53 54 20           DC B:'FST '                    ;Says I'm a FST
0542 0004 72 00 02 00           DC L:appl_call                 ;Process a normal application call
0543 0008 3F 01 02 00           DC L:system_call               ;Process a FST system call
0544 000C 01 00                 DC W:Pro_ID                    ;My ID number (ProDOS)
0545 000E                       Export fst_attr
0546 000E 03 30        fst_attr DC W:$3003                     ;(Uppercase pathnames if enabled), formattable, strip high bit.
0547 0010 02 04                 DC W:$0402                     ;Version 4.02 final
0548 0012 00 02                 DC W:512                       ;block size
0549 0014 00 00 01 00           DC L:$10000                    ;Max Blocks (32 meg)
0550 0018 07 00 00 00           DC L:$0007                     ;Min Blocks
0551 001C 00 00 00 01           DC L:$01000000                 ;max file size
0552 0020 00 00 00 00           DC L:$0000                     ;reserved
0553 0024 06                    DC B:6
0554 0025 50 72 6F 44           DC B:'ProDOS'
0555 002B
0556 002B                       string pascal
0557 002B 1C 50 72 6F           DC B:'ProDOS FST            v04.02'
0558 0048
0559 0048 00 00                 DC W:0000                      ;reserved field
0560 004A 27 50 72 6F           DC B:'ProDOS FST written by Rob Turner. V4.02'
0561 0072                       string asis
0562 0072
0563 0072                       ENDP 
0564 0072
0565 0072              ;======================================================================
0566 0072              ;Below is the main entry point for ALL standard operating system calls.
0567 0072              ;
0568 0072              ;Input:         X = Call number * 2
0569 0072              ;               Y = Class number * 2
0570 0072              ;               A = undefined
0571 0072
0572 0072                       longa on
0573 0072                       longi on
0574 0072
0575 0072                       EXPORT appl_call
0576 0072              appl_call PROC 
0577 0072                       import max_call
0578 0072                       import write_occurred
0579 0072                       import write_dev_num
0580 0072                       import cp_device_flag
0581 0072                       import fake_name_str
0582 0072                       import error_priority
0583 0072
0584 0072 4B                    phk                            ;setup our bank register
0585 0073 AB                    plb   
0586 0074 C2 30                 rep   #$30
0587 0076
0588 0076 E0 67 00              cpx   #max_call+1              ;check command number
0589 0079 B0 03                 bcs   cmd_error
0590 007B 7C 4B 01              jmp   (cmd_tbl-2,x)            ;call the function
0591 007E
0592 007E                       EXPORT cmd_error
0593 007E              cmd_error  
0594 007E A9 01 00              lda   #bad_system_call
0595 0081                       EXPORT error_exit
0596 0081              error_exit  
0597 0081 38                    sec   
0598 0082                       EXPORT main_exit
0599 0082              main_exit  
0600 0082                       IMPORT flags
0601 0082
0602 0082              ; If we're reporting an error, then check cp_device_flag to see if we were
0603 0082              ; renaming a duplicate volume.  If so, we built a vcr with a fake name.  Since we 
0604 0082              ; got an error at some point in the process, we need to find the vcr with the fake
0605 0082              ; name and release it if it still exists.  1/22/91 CAE
0606 0082
0607 0082 48                    pha                            ;save the error code
0608 0083 08                    php                            ;save error flag
0609 0084 90 22                 bcc   @cont                    ;branch if no error
0610 0086 AD E5 05              lda   cp_device_flag           ;did we build a vcr with a fake name?
0611 0089 10 1D                 bpl   @cont                    ;no - so no need to clean up
0612 008B
0613 008B A2 E5 01              ldx   #fake_name_str           ;get pointer to fake name string
0614 008E A0 02 00              ldy   #^fake_name_str
0615 0091 A9 00 00              lda   #0000                    ;search by name
0616 0094 22 48 FC 01           jsl   find_vcr
0617 0098 B0 0E                 bcs   @cont                    ;didn't find the vcr so we're ok
0618 009A 22 38 FC 01           jsl   deref                    ;dereference vcr pointer
0619 009E 86 98                 stx   <temp_ptr
0620 00A0 84 9A                 sty   <temp_ptr+2
0621 00A2 A7 98                 lda   [temp_ptr]               ;get vcr id 
0622 00A4 22 28 FC 01           jsl   release_vcr              ;release the vcr
0623 00A8              @cont     
0624 00A8 22 6C FC 01           jsl   unlock_mem               ;unlock the used handles
0625 00AC 28                    plp   
0626 00AD 08                    php   
0627 00AE 90 2C                 bcc   no_damage
0628 00B0
0629 00B0 A3 02                 lda   2,s                      ;get access to the error code
0630 00B2 29 FF 00              and   #$00FF                   ;clear the garbage from the high byte please
0631 00B5 C9 2D 00              cmp   #drvr_bad_block          ;the disk is probably bad
0632 00B8 F0 0A                 beq   mark_damaged             ;mark the volume as damaged
0633 00BA C9 5A 00              cmp   #damaged_bitmap
0634 00BD F0 05                 beq   mark_damaged
0635 00BF C9 51 00              cmp   #dir_error
0636 00C2 D0 18                 bne   no_damage                ;the disk is still ok
0637 00C4
0638 00C4              mark_damaged  
0639 00C4 A5 88                 lda   prodos_vcr_ptr           ;make sure there is a vcr
0640 00C6 05 8A                 ora   prodos_vcr_ptr+2
0641 00C8 F0 12                 beq   no_damage
0642 00CA
0643 00CA A0 23 00              ldy   #vol_damaged             ;mark the VCR please
0644 00CD B7 88                 lda   [prodos_vcr_ptr],y
0645 00CF 1A                    inc   a                        ;see if we have already told the user about the damage
0646 00D0 F0 0A                 beq   no_damage                ;we have told the user so skip the message
0647 00D2
0648 00D2 A9 FF FF              lda   #$FFFF
0649 00D5 97 88                 sta   [prodos_vcr_ptr],y
0650 00D7 A3 01                 lda   1,s                      ;tell the user about the problem
0651 00D9 20 42 17              jsr   show_damage
0652 00DC
0653 00DC              no_damage  
0654 00DC              ;
0655 00DC              ;Now we need to set the Global Clean Flag if we need to
0656 00DC              ;
0657 00DC A5 90                 lda   pro_fcr_ptr              ;make sure there is a fcr
0658 00DE 05 92                 ora   pro_fcr_ptr+2
0659 00E0 F0 3D                 beq   @no_fcr                  ;don't worry about it
0660 00E2
0661 00E2 AD 3A 06              lda   flags                    ;There is a FCR now make sure it was used during the call.
0662 00E5 29 00 04              and   #fcr_used
0663 00E8 F0 35                 beq   @no_fcr                  ;no FCR is used by the call
0664 00EA
0665 00EA A0 1F 00              ldy   #fcr_status              ;get the status out of the File Control Record
0666 00ED B7 90                 lda   [pro_fcr_ptr],y
0667 00EF              ;
0668 00EF              ;If my bit (15) is set then the file is dirty so we must clear the Global_Clean Bit.
0669 00EF              ;
0670 00EF 29 00 80              and   #file_dirty              ;clear all but the file dirty bit 15
0671 00F2 49 00 80              eor   #set_global_clean
0672 00F5 85 AC                 sta   math_temp
0673 00F7
0674 00F7 A0 14 00              ldy   #fcr_access
0675 00FA B7 8C                 lda   [my_fcr_ptr],y
0676 00FC 29 FF 7F              and   #clr_global_clean
0677 00FF 05 AC                 ora   math_temp
0678 0101 97 8C                 sta   [my_fcr_ptr],y
0679 0103              ;
0680 0103              ;Now we need to see if we should check if the file has become dirty during the call
0681 0103              ;
0682 0103 AD DD 05              lda   chk_dirty_flag
0683 0106 F0 17                 beq   @no_fcr                  ;This call does not require processing
0684 0108              ;
0685 0108              ;Now lets see if the file was dirty at the beginning of the call.  If it was then just
0686 0108              ;exit.  Otherwise update the dirty_file count in the VCR
0687 0108              ;
0688 0108 AD D9 05              lda   dirty_flags
0689 010B D0 12                 bne   @no_fcr                  ;the file was dirty at the beginning
0690 010D
0691 010D A0 1F 00              ldy   #fcr_status              ;get the status out of the File Control Record
0692 0110 B7 90                 lda   [pro_fcr_ptr],y
0693 0112 29 07 80              and   #file_dirty+data_dirty+index_dirty+master_dirty
0694 0115 F0 08                 beq   @no_fcr                  ;The file is still clean
0695 0117              ;
0696 0117              ;Now we must update the dirty file count
0697 0117              ;
0698 0117 A0 25 00              ldy   #dirty_file_cnt          ;get the original count
0699 011A B7 88                 lda   [prodos_vcr_ptr],y
0700 011C 1A                    inc   a
0701 011D 97 88                 sta   [prodos_vcr_ptr],y
0702 011F              @no_fcr   
0703 011F AD 07 03              lda   write_occurred           ;see if a volume was modified during the call
0704 0122 F0 12                 beq   @no_write                ;no write occurred
0705 0124
0706 0124 A5 30                 lda   call_number              ;the call that was made by application
0707 0126 48                    pha   
0708 0127 AE 09 03              ldx   write_dev_num            ;push the device number
0709 012A DA                    phx   
0710 012B 5A                    phy                            ;we do not care about Y
0711 012C
0712 012C A9 40 00              lda   #volume_change           ;this is the event code
0713 012F A2 00 00              ldx   #^volume_change
0714 0132 22 C4 FC 01           jsl   post_os_event            ;post the event please
0715 0136              @no_write  
0716 0136 28                    plp                            ;restore error flag
0717 0137 68                    pla                            ;restore error code
0718 0138 0D 0D 06              ora   error_priority           ;put error priority in hi byte  3/5/91 CAE
0719 013B
0720 013B              IF debug_on<>0 THEN  
0721 013B                       phx                            ;save X and Y please
0722 013B                       phy   
0723 013B                       pha   
0724 013B                       php   
0725 013B                       jsr   debugger
0726 013B                       plp   
0727 013B                       pla   
0728 013B                       ply   
0729 013B                       plx   
0730 013B
0731 013B              ENDIF     
0732 013B 5C 40 FC 01           jml   sys_exit
0733 013F                       ENDP 
0734 013F
0735 013F              ;======================================================================
0736 013F              ;Below is the main entry point for ALL FST system calls
0737 013F              ;
0738 013F              ;Input:     X = Call number * 2
0739 013F              ;           Y = Class number * 2
0740 013F              ;           A = undefined
0741 013F
0742 013F                       EXPORT system_call
0743 013F              system_call PROC 
0744 013F                       import max_sys
0745 013F
0746 013F 4B                    phk                            ;setup our bank register
0747 0140 AB                    plb   
0748 0141
0749 0141 E0 09 00              cpx   #max_sys+1               ;maximum system calls
0750 0144 B0 03                 bcs   sys_err
0751 0146 7C B1 01              jmp   (sys_tbl-2,x)            ;call system routine
0752 0149
0753 0149              sys_err                                 ;
0754 0149 A9 01 00              lda   #bad_system_call
0755 014C 6B                    rtl                            ;return error to Jim and Mike
0756 014D                       ENDP 
0757 014D
0758 014D              IF debug_on<>0 THEN  
0759 014D                       include 'debugger'
0760 014D              ENDIF     
0761 014D
0762 014D              ;======================================================================
0763 014D              ;Below are my dispatch tables for application and system calls
0764 014D
0765 014D                       EXPORT dispatch_tables
0766 014D              dispatch_tables PROC 
0767 014D
0768 014D                       EXPORT cmd_tbl
0769 014D 78 22        cmd_tbl  DC W:create                    ;create a file call
0770 014F B0 2A                 DC W:destroy                   ;delete a file
0771 0151 7E 00                 DC W:cmd_error
0772 0153 51 2D                 DC W:change_path               ;rename or move a file or subdir
0773 0155 60 33                 DC W:set_file_info             ;alter directory info on a file
0774 0157 2F 36                 DC W:get_file_info             ;return directory info on a file
0775 0159 89 37                 DC W:judge_name                ;judge a name
0776 015B 67 39                 DC W:volume                    ;return information on a volume
0777 015D 7E 00                 DC W:cmd_error                 ;we don't handle 'Set_Prefix'
0778 015F 7E 00                 DC W:cmd_error                 ;we also don't handle 'Get_Prefix'
0779 0161 B0 3A                 DC W:clear_backup              ;clear the backup bit on a file
0780 0163 7E 00                 DC W:cmd_error                 ;RESERVED
0781 0165 7E 00                 DC W:cmd_error                 ;RESERVED
0782 0167 7E 00                 DC W:cmd_error                 ;RESERVED
0783 0169 7E 00                 DC W:cmd_error
0784 016B EB 3A                 DC W:open                      ;open a file or subdirectory
0785 016D 7E 00                 DC W:cmd_error                 ;we don't handle newline
0786 016F B8 3F                 DC W:read                      ;read 'n' bytes from a file
0787 0171 C7 45                 DC W:write                     ;write 'n' bytes to a file
0788 0173 43 4D                 DC W:close                     ;close a file or subdirectoy
0789 0175 57 4D                 DC W:flush                     ;flush a file(s)
0790 0177 80 4D                 DC W:set_mark                  ;set a file marker
0791 0179 43 4E                 DC W:get_mark                  ;return file marker
0792 017B 5E 4E                 DC W:set_eof                   ;change EOF of a file
0793 017D EB 51                 DC W:get_eof                   ;return EOF of a file
0794 017F 7E 00                 DC W:cmd_error                 ;system call
0795 0181 7E 00                 DC W:cmd_error                 ;system call
0796 0183 06 52                 DC W:get_dir_entry             ;return a entry from a directory
0797 0185 7E 00                 DC W:cmd_error                 ;RESERVED
0798 0187 7E 00                 DC W:cmd_error                 ;RESERVED
0799 0189 7E 00                 DC W:cmd_error                 ;RESERVED
0800 018B 2D 56                 DC W:get_dev_num               ;Get_Dev_Num
0801 018D 7E 00                 DC W:cmd_error                 ;GS/OS handles 'Get_Last_Dev'
0802 018F 5A 56                 DC W:read_block                ;read Block only in ProDOS fst
0803 0191 5F 56                 DC W:write_block               ;write Block only in ProDOS fst
0804 0193 FC 56                 DC W:format_disk               ;format media and build directory
0805 0195 13 57                 DC W:erase_disk                ;build directory structure
0806 0197 7E 00                 DC W:cmd_error                 ;reserved
0807 0199 7E 00                 DC W:cmd_error                 ;get name
0808 019B 7E 00                 DC W:cmd_error                 ;get boot vol
0809 019D 7E 00                 DC W:cmd_error                 ;quit
0810 019F 7E 00                 DC W:cmd_error                 ;get version
0811 01A1 7E 00                 DC W:cmd_error                 ;get fst info
0812 01A3 7E 00                 DC W:cmd_error                 ;device info
0813 01A5 7E 00                 DC W:cmd_error                 ;device status
0814 01A7 7E 00                 DC W:cmd_error                 ;device control
0815 01A9 7E 00                 DC W:cmd_error                 ;device read
0816 01AB 7E 00                 DC W:cmd_error                 ;device write
0817 01AD 7E 00                 DC W:cmd_error                 ;alloc int
0818 01AF 7E 00                 DC W:cmd_error                 ;dealloc int
0819 01B1 23 59                 DC W:fst_specific              ;FST Specific
0820 01B3                       EXPORT end_tbl
0821 01B3              end_tbl   
0822 01B3                       EXPORT Max_call:EQU
0823 01B3              Max_call equ   end_tbl-cmd_tbl          ;Last valid call I support
0824 01B3
0825 01B3
0826 01B3                       EXPORT sys_tbl
0827 01B3 E2 21        sys_tbl  DC W:startup                   ;set ready for work
0828 01B5 EE 21                 DC W:shutdown                  ;get ready to quit
0829 01B7 F0 21                 DC W:sys_remove_vol            ;remove local data from VCR
0830 01B9 F2 21                 DC W:deferred_flush            ;flush deferred blocks.
0831 01BB                       EXPORT max_sys:equ
0832 01BB              max_sys  equ   *-sys_tbl
0833 01BB                       ENDP 
0834 01BB
0835 01BB
0836 01BB              ;
0837 01BB              ; 22-Jan-92 MSD: Moved all non-zero items in the data to the start of
0838 01BB              ; the proc so that all of the zero bytes would be contiguous.  This
0839 01BB              ; should help the FST sparsify itself (and reduce disk space).
0840 01BB              ;
0841 01BB
0842 01BB              ;======================================================================
0843 01BB              ;below are virtual pointers returned by GS/OS.  Init these to zero
0844 01BB              ;on startup 
0845 01BB                       EXPORT data
0846 01BB              data     PROC 
0847 01BB
0848 01BB                       Export dummy_name
0849 01BB 63 61 6E 74  dummy_name DC B:'cant.find.me'          ;used to calculate the latest mod date
0850 01C7 00 00                 DC W:00
0851 01C9                       EXPORT time_stamp_opt
0852 01C9 02 00        time_stamp_opt DC W:02                  ;0 = files
0853 01CB              ;                                       ;1 = files + subdirs
0854 01CB              ;                                       ;2 = files + subdirs + subdirs to root
0855 01CB              ;
0856 01CB                       EXPORT dir_offset_tbl
0857 01CB 04 00        dir_offset_tbl DC W:$0004               ;offsets to directory entries within
0858 01CD 2B 00                 DC W:$002b                     ;a directory block
0859 01CF 52 00                 DC W:$0052
0860 01D1 79 00                 DC W:$0079
0861 01D3 A0 00                 DC W:$00A0
0862 01D5 C7 00                 DC W:$00C7
0863 01D7 EE 00                 DC W:$00EE
0864 01D9 15 01                 DC W:$0115
0865 01DB 3C 01                 DC W:$013C
0866 01DD 63 01                 DC W:$0163
0867 01DF 8A 01                 DC W:$018A
0868 01E1 B1 01                 DC W:$01B1
0869 01E3 D8 01                 DC W:$01D8
0870 01E5
0871 01E5                       export fake_name_str
0872 01E5 03 00        fake_name_str DC W:3                    ;fake name string for VCR
0873 01E7 0C                    DC B:$C
0874 01E8 0A                    DC B:$A
0875 01E9 0E                    DC B:$E
0876 01EA 00                    DC B:$00
0877 01EB
0878 01EB                       export syntax_str
0879 01EB 78           syntax_str DC B:end_text-start_text
0880 01EC 50 72 6F 44  start_text DC B:'ProDOS names must begin with a letter. '
0881 0213 54 68 65 79           DC B:'They may be up to 15 characters long and may contain '
0882 0248 6C 65 74 74           DC B:'letters, digits'
0883 0257              if AllowLCPeriods then                  ;added 7-Aug-91 DAL
0884 0257 20 61 6E 64           DC B:', spaces'
0885 025F              endif                                   ;end 7-Aug-91 DAL
0886 025F 69 6F 64 73           DC B:' and periods.'
0887 026C              end_text  
0888 026C
0889 026C                       EXPORT format_header
0890 026C              format_header                           ;
0891 026C 00 00                 DC W:$0000                     ;backword link is nill
0892 026E 00 00                 DC W:$0003                     ;forward link to block three
0893 0270                       EXPORT new_vol_name
0894 0270 00           new_vol_name DC B:00                    ;length plus storage type
0895 0271 00 00 00 00           DS B:15                        ;fifteen bytes for the name
0896 0280 00 00                 DS B:2                         ;eight bytes reserved
0897 0282                       Export new_vol_mod
0898 0282 00 00 05 00  new_vol_mod DS B:4                      ;four byte for the Mod time
0899 0286 C3 27                 DS B:2                         ;2 bytes for the case bits
0900 0288                       EXPORT new_vol_date
0901 0288 0D 00 00 06  new_vol_date DS B:4                     ;create date for the volume
0902 028C 00                    DC B:prodos_version
0903 028D 00                    DC B:00                        ;minimum version (back to SOS 1.0)
0904 028E 00                    DC B:$C3                       ;access
0905 028F 0E                    DC B:$27                       ;entry length  (39)
0906 0290 00                    DC B:$0D                       ;entries per block (13)
0907 0291 41 70                 DC W:$0000                     ;file count is nill
0908 0293 70 6C                 DC W:$0006                     ;bitmap pointer
0909 0295                       EXPORT new_tot_blks
0910 0295 65 5F        new_tot_blks DC W:$0000                 ;total number of blocks on the volume
0911 0297
0912 0297                       EXPORT control_list
0913 0297              control_list                            ;partion string
0914 0297 50 52                 DC W:$0E                       ;length increased by 2 7/26/90, see below
0915 0299 4F 44 4F 53           DC B:'Apple_PRODOS'
0916 02A5                       dc.b 0,0                       ;terminator nulls added 7/26/90 for compatibility with
0917 02A5                                                      ;Macintosh-side FSM, by Matt Gulick, Monte Benaresh
0918 02A5
0919 02A5                       Export key_blk_changed
0920 02A5 00 00        key_blk_changed DC W:00                 ;used by set EOF to indicate that the file changed structure
0921 02A7
0922 02A7              ;======================================================================
0923 02A7              ;below is the startup tables for each call. The table contains the
0924 02A7              ;following data:
0925 02A7              ;
0926 02A7              ;               1) Max PCount for the call
0927 02A7              ;               2) Max Class for the call
0928 02A7              ;               3) Pathnames used by call
0929 02A7              ;               4) volume control record used
0930 02A7              ;               5) file control record used.
0931 02A7              ;               6) io buffer used (data_ptr,Index_ptr,master_ptr)
0932 02A7              ;               7) flush file before call
0933 02A7              ;               8) damaged disk protect
0934 02A7              ;               9) Check Dirty Flag.
0935 02A7              ;
0936 02A7              ;            |9|8|7|6|5|4|3|  2  |    1    |
0937 02A7              ;           _|_|_|_|_|_|_|_|_____|_________|
0938 02A7              ;          | | | | | | | | | | | | | | | | |
0939 02A7              ;          |_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|
0940 02A7              ;          |               |               |
0941 02A7              ;         1 6             0 8             0 0
0942 02A7
0943 02A7
0944 02A7                       EXPORT start_tbl
0945 02A7              start_tbl  
0946 02A7 24 21                 DC W:max_pcnt7+max_class1+path_used+damage                             ;Create
0947 02A9 2D 21                 DC W:max_pcnt1+max_class1+path_used+damage                             ;Destroy
0948 02AB 2D 01                 DC W:0000
0949 02AD 27 00                 DC W:max_pcnt3+max_class1+path_used+damage                             ;ChangePath
0950 02AF                                                                                              ; set max pCount=3 (5-Dec-91 MSD)
0951 02AF 27 00                 DC W:max_pcnt12+max_class1+path_used+damage                            ;SetFileInfo
0952 02B1 00 00                 DC W:max_pcnt12+max_class1+path_used                                   ;GetFileInfo
0953 02B3 00 00                 DC W:max_pcnt6+max_class1                                              ;JudgeName
0954 02B5 22 21                 DC W:max_pcnt6+max_class1                                              ;Volume
0955 02B7 00 00                 DC W:0000
0956 02B9 00 00                 DC W:0000
0957 02BB 00 00                 DC W:max_pcnt1+max_class1+path_used+damage                             ;ClearBackup
0958 02BD 00 00                 DC W:0000
0959 02BF 30 01                 DC W:0000
0960 02C1 00 00                 DC W:0000
0961 02C3 26 0E                 DC W:0000
0962 02C5 26 6E                 DC W:max_pcnt15+max_class1+path_used                                   ;Open
0963 02C7 22 0E                 DC W:0000
0964 02C9 23 2E                 DC W:max_pcnt5+max_class1+vcr_used+fcr_used+io_used                    ;Read
0965 02CB 25 0E                 DC W:max_pcnt5+max_class1+vcr_used+fcr_used+io_used+damage+do_dirty    ;Write
0966 02CD 23 04                 DC W:max_pcnt1+max_class1+vcr_used+fcr_used+io_used                    ;Close
0967 02CF 24 7E                 DC W:max_pcnt2+max_class1+vcr_used+fcr_used+io_used+damage             ;Flush
0968 02D1 23 04                 DC W:max_pcnt4+max_class1+vcr_used+fcr_used+io_used                    ;SetMark
0969 02D3 00 00                 DC W:max_pcnt2+max_class1+fcr_used                                     ;GetMark
0970 02D5 00 00                 DC W:max_pcnt3+max_class1+vcr_used+fcr_used+flush_1st+io_used+damage+do_dirty ;SetEof
0971 02D7 32 0E                 DC W:max_pcnt2+max_class1+fcr_used                                     ;GetEof
0972 02D9 00 00                 DC W:0000
0973 02DB 00 00                 DC W:0000
0974 02DD 00 00                 DC W:max_pcnt17+max_class1+vcr_used+fcr_used+io_used                   ;GetDirEntry
0975 02DF 23 01                 DC W:0000
0976 02E1 00 00                 DC W:0000
0977 02E3 00 00                 DC W:0000
0978 02E5 00 00                 DC W:max_pcnt2+max_class1+path_used                                    ;GetDevNum
0979 02E7 27 01                 DC W:0000
0980 02E9 27 01                 DC W:0000                                                              ;ReadBlock
0981 02EB 00 00                 DC W:0000                                                              ;WriteBlock
0982 02ED 00 00                 DC W:max_pcnt6+max_class1+path_used                                    ;Format
0983 02EF 00 00                 DC W:max_pcnt6+max_class1+path_used                                    ;Erase
0984 02F1
0985 02F1                       EXPORT gbuf_addr
0986 02F1 00 00 00 00  gbuf_addr DC L:0                        ;pointer to general I/O buffer
0987 02F5                       EXPORT virtual
0988 02F5 00 00 00 00  virtual  DC L:0                         ;pointer to virtual memory after
0989 02F9              ;                                       ;a call to 'Get_Segment'
0990 02F9                       EXPORT virtual2
0991 02F9 00 00 00 00  virtual2 DC L:00
0992 02FD
0993 02FD              ;======================================================================
0994 02FD              ;data storage used
0995 02FD                       EXPORT hours
0996 02FD 00 00        hours    DC W:00
0997 02FF                       EXPORT minutes
0998 02FF 00 00        minutes  DC W:00
0999 0301                       EXPORT year
1000 0301 00 00        year     DC W:00
1001 0303                       EXPORT month
1002 0303 00 00        month    DC W:00
1003 0305                       EXPORT day
1004 0305 00 00        day      DC W:00
1005 0307                       EXPORT day_of_week
1006 0307 00 00        day_of_week DC W:00
1007 0309                       EXPORT pro_time
1008 0309 00 00 00 00  pro_time DC L:00
1009 030D
1010 030D                       Export write_occurred
1011 030D 00 00        write_occurred DC W:00                  ;IF non-zero on exit then a write occurred
1012 030F                       Export write_dev_num           ;device number that was written too
1013 030F 00 00        write_dev_num DC W:00
1014 0311
1015 0311                       Export curr_mod_date
1016 0311 00 00 00 00  curr_mod_date DC L:00
1017 0315
1018 0315                       Export case_bits               ;case bits for the last pathname
1019 0315 00 00        case_bits DC W:00
1020 0317                       Export case_bit_pattern
1021 0317              case_bit_pattern dc.w 00 
1022 0317
1023 0317                       EXPORT src_dev_num
1024 0317 00 00        src_dev_num DC W:00                     ;used by change path
1025 0319                       EXPORT src_start_blk
1026 0319 00 00        src_start_blk DC W:00                   ;''
1027 031B                       EXPORT src_dir_blk
1028 031B 00 00        src_dir_blk DC W:00                     ;''
1029 031D                       EXPORT src_offset
1030 031D 00 00        src_offset DC W:00
1031 031F
1032 031F                       EXPORT slug_block
1033 031F 00 00        slug_block DC W:00                      ;for slug ripple 'to root time stamp'
1034 0321                       EXPORT slug_offset
1035 0321 00 00        slug_offset DC W:00
1036 0323                       EXPORT close_flag
1037 0323 00 00        close_flag DC W:00                      ;used to determine if we should call
1038 0325              ;                                       ;slug_ripple from flush_file
1039 0325              ;
1040 0325                       EXPORT src_slug_blk
1041 0325 00 00        src_slug_blk DC W:00                    ;used by change_path
1042 0327                       EXPORT src_slug_offset
1043 0327 00 00        src_slug_offset DC W:00
1044 0329                       EXPORT dest_slug_blk
1045 0329 00 00        dest_slug_blk DC W:00
1046 032B                       EXPORT dest_slug_offset
1047 032B              dest_slug_offset DC.W 00 
1048 032B
1049 032B
1050 032B                       EXPORT dest_dev_num
1051 032B 00 00        dest_dev_num DC W:00                    ;used by change path
1052 032D                       EXPORT dest_start_blk
1053 032D 00 00        dest_start_blk DC W:00                  ;''
1054 032F                       EXPORT dest_dir_blk
1055 032F 00 00        dest_dir_blk DC W:00                    ;''
1056 0331                       EXPORT dest_offset
1057 0331 00 00        dest_offset DC W:00
1058 0333                       EXPORT vol_rename_flag
1059 0333 00 00        vol_rename_flag DC W:00                 ;''
1060 0335
1061 0335                       EXPORT direct_page
1062 0335 00 00 00 00  direct_page DS B:$4C                    ;used when we must mount a volume
1063 0381                       EXPORT my_direct
1064 0381 00 00 00 00  my_direct DS B:$78                      ;''
1065 03F9                       EXPORT world_flag
1066 03F9 00 00        world_flag DC W:00                      ;detect re-entrent code
1067 03FB
1068 03FB                       EXPORT def_dir_page
1069 03FB 00 00 00 00  def_dir_page DS B:$4C                   ;used when we flush deferred blocks
1070 0447                       EXPORT def_my_direct
1071 0447 00 00 00 00  def_my_direct DS B:$78                  ;''
1072 04BF                       EXPORT def_vol_name
1073 04BF 00 00 00 00  def_vol_name DS B:20
1074 04D3                       EXPORT alloc_chk_flag
1075 04D3 00 00        alloc_chk_flag DC W:00                  ;used by write routine
1076 04D5                       EXPORT seq_write_start
1077 04D5 00 00 00 00  seq_write_start DC L:00                 ;pointer used by write routine
1078 04D9                       EXPORT seq_write_cnt
1079 04D9 00 00        seq_write_cnt DC W:00                   ;sequential block counter
1080 04DB                       EXPORT seq_write_blk
1081 04DB 00 00        seq_write_blk DC W:00                   ;starting block for sequential write
1082 04DD
1083 04DD                       EXPORT path_searched
1084 04DD 00 00        path_searched DC W:00                   ;set by find file.
1085 04DF              ;
1086 04DF                       EXPORT last_blk
1087 04DF 00 00        last_blk DC W:0                         ;used by find_file to verify
1088 04E1              ;                                       ;directory structure
1089 04E1              ;
1090 04E1              ;
1091 04E1                       EXPORT search_flag
1092 04E1 00 00        search_flag DC W:00                     ;flag used by process path
1093 04E3              ;                                       ; bit 15 = volume name not allowed
1094 04E3              ;                                       ; bit 14 = search for new entry
1095 04E3              ;                                       ; bit 13 = volume only allowed
1096 04E3              ;
1097 04E3                       EXPORT dir_start_blk
1098 04E3 00 00        dir_start_blk DC W:00                   ;starting block of a directory
1099 04E5                       EXPORT dir_last_blk
1100 04E5 00 00        dir_last_blk DC W:00                    ;last block read by find file
1101 04E7                       EXPORT free_dir_blk
1102 04E7 00 00        free_dir_blk DC W:00                    ;1st dir block with a free entry
1103 04E9                       EXPORT free_dir_offset
1104 04E9 00 00        free_dir_offset DC W:00                 ;offset to free entry in dir block
1105 04EB                       EXPORT searching_free
1106 04EB 00 00        searching_free DC W:00                  ;flag that is used by Find_File
1107 04ED
1108 04ED                       EXPORT blks_used1
1109 04ED 00 00        blks_used1 DC W:00                      ;blks needed for data fork. (create)
1110 04EF                       EXPORT blks_used2
1111 04EF 00 00        blks_used2 DC W:00                      ;blks needed for res. fork. (create)
1112 04F1                       EXPORT blocks_needed
1113 04F1 00 00        blocks_needed DC W:00                   ;total blocks needed for files. (create)
1114 04F3                       EXPORT data_storage
1115 04F3 00 00        data_storage DC W:00                    ;storage type for data fork
1116 04F5                       EXPORT res_storage
1117 04F5 00 00        res_storage DC W:00                     ;storage type for resource fork
1118 04F7                       EXPORT res_tot_blks
1119 04F7 00 00        res_tot_blks DC W:00                    ;used by create
1120 04F9                       EXPORT res_key_blk
1121 04F9 00 00        res_key_blk DC W:00                     ;''
1122 04FB                       EXPORT some_free
1123 04FB 00 00        some_free DC W:00                       ;used by find_free_blks
1124 04FD
1125 04FD                       EXPORT volume_name
1126 04FD 00 00 00 00  volume_name DS B:20                     ;holds the volume name of an input str
1127 0511                       EXPORT gstring
1128 0511 00 00 00 00  gstring  DS B:20                        ;holds gstrings
1129 0525
1130 0525                       EXPORT search_length
1131 0525 00 00        search_length DC W:00                   ;used by 'find_file' routine
1132 0527                       EXPORT search_name
1133 0527 00 00 00 00  search_name DS B:17
1134 0538
1135 0538
1136 0538                       EXPORT fcr_wanted
1137 0538 00 00        fcr_wanted DC W:00                      ;used by check_dup routine
1138 053A                       EXPORT key_block
1139 053A 00 00        key_block DC W:00                       ;used by check_dup routine
1140 053C
1141 053C                       EXPORT find_this_entry
1142 053C 00 00        find_this_entry DC W:00                 ;used by get dir entry
1143 053E
1144 053E                       EXPORT entry_sto_type
1145 053E 00 00        entry_sto_type DC W:00
1146 0540                       EXPORT storage_type
1147 0540 00 00        storage_type DC W:00                    ;used by open
1148 0542                       EXPORT alloc_entry
1149 0542 00           alloc_entry DC B:00                     ;used to give entry name a length word
1150 0543                       EXPORT one_entry
1151 0543 00 00 00 00  one_entry DS B:40                       ;holds one directory entry
1152 056B                       EXPORT files_key_block
1153 056B 00 00        files_key_block DC W:00                 ;used by open
1154 056D
1155 056D                       EXPORT hold_path_ptr
1156 056D 00 00        hold_path_ptr DC W:00
1157 056F
1158 056F                       EXPORT data_eof
1159 056F 00 00 00 00  data_eof DC L:00                        ;used by create
1160 0573                       EXPORT res_eof
1161 0573 00 00 00 00  res_eof  DC L:00                        ;used by create
1162 0577                       EXPORT tree_key_blk
1163 0577 00 00        tree_key_blk DC W:00                    ;used by create
1164 0579                       EXPORT tree_blks
1165 0579 00 00        tree_blks DC W:00                       ;used by create
1166 057B
1167 057B                       EXPORT parent_blk
1168 057B 00 00        parent_blk DC W:00                      ;used by the open routine
1169 057D                       EXPORT entry_offset
1170 057D 00 00        entry_offset DC W:00                    ;used by the open routine
1171 057F
1172 057F                       EXPORT num_of_res
1173 057F 00 00        num_of_res DC W:00                      ;used by open
1174 0581
1175 0581                       EXPORT newline_len
1176 0581 00 00        newline_len DC W:00
1177 0583                       EXPORT newline_mask
1178 0583 00 00        newline_mask DC W:00
1179 0585                       EXPORT newline_char
1180 0585 00 00        newline_char DC W:00
1181 0587
1182 0587                       EXPORT base
1183 0587 00 00        base     DC W:00                        ;used with calls that have base param
1184 0589                       EXPORT displacement
1185 0589 00 00 00 00  displacement DC L:00                    ;used with calls that have displacement
1186 058D
1187 058D                       EXPORT purge_addr
1188 058D 00 00        purge_addr DC W:00                      ;block address of purgable files
1189 058F                       EXPORT new_last
1190 058F 00 00        new_last DC W:00                        ;used to cut back eof (SET_EOF)
1191 0591
1192 0591                       EXPORT bitmap_blks
1193 0591 00 00        bitmap_blks DC W:00                     ;used to calc_free_blks
1194 0593                       EXPORT last_bitmap
1195 0593 00 00        last_bitmap DC W:00                     ;''                  ''
1196 0595                       EXPORT first_free
1197 0595 00 00        first_free DC W:00                      ;''                  ''
1198 0597                       EXPORT bits
1199 0597 00 00        bits     DC W:00                        ;used to count bits in calc_free_blks
1200 0599                       EXPORT alloc_count
1201 0599 00 00        alloc_count DC W:00                     ;used by find_free_blks
1202 059B                       EXPORT alloc_start
1203 059B 00 00        alloc_start DC W:00                     ;''
1204 059D                       EXPORT byte_offset
1205 059D 00 00        byte_offset DC W:00                     ;''
1206 059F
1207 059F                       EXPORT mark_changed
1208 059F 00 00        mark_changed DC W:00                    ;used by fill_io_buf (setmark=EOF case)
1209 05A1                       EXPORT user_cache
1210 05A1 00 00        user_cache DC W:00                      ;default cache value for file reads
1211 05A3
1212 05A3                       EXPORT create_time
1213 05A3 00 00 00 00  create_time DC L:00                     ;used by set_file_info
1214 05A7                       EXPORT mod_time
1215 05A7 00 00 00 00  mod_time DC L:00                        ;used by set_file_info
1216 05AB
1217 05AB                       EXPORT first_free_bm
1218 05AB 00 00        first_free_bm DC W:00
1219 05AD
1220 05AD                       EXPORT index_blks
1221 05AD 00 00        index_blks DC W:00                      ;number of indexes needed for tree files
1222 05AF                       EXPORT data_indexes
1223 05AF 00 00        data_indexes DC W:00                    ;used by create
1224 05B1                       EXPORT res_indexes
1225 05B1 00 00        res_indexes DC W:00                     ;used by create.
1226 05B3
1227 05B3                       EXPORT entries_blk_num
1228 05B3 00 00        entries_blk_num DC W:00
1229 05B5                       EXPORT files_examined
1230 05B5 00 00        files_examined DC W:00
1231 05B7                       EXPORT files_in_dir
1232 05B7 00 00        files_in_dir DC W:00
1233 05B9                       EXPORT pcount
1234 05B9 00 00        pcount   DC W:00
1235 05BB                       EXPORT resource_num
1236 05BB 00 00        resource_num DC W:00
1237 05BD                       EXPORT access
1238 05BD 00 00        access   DC W:00
1239 05BF                       EXPORT and_mask
1240 05BF 00 00        and_mask DC W:00
1241 05C1                       EXPORT curr_mark
1242 05C1 00 00 00 00  curr_mark DC L:00
1243 05C5                       EXPORT curr_eof
1244 05C5 00 00 00 00  curr_eof DC L:00
1245 05C9                       EXPORT tran_cnt
1246 05C9 00 00 00 00  tran_cnt DC L:00
1247 05CD                       EXPORT user_req_cnt
1248 05CD 00 00 00 00  user_req_cnt DC L:00
1249 05D1                       EXPORT entries_checked
1250 05D1 00 00        entries_checked DC W:00
1251 05D3                       EXPORT chars_checked
1252 05D3 00 00        chars_checked DC W:00
1253 05D5                       EXPORT name_length
1254 05D5 00 00        name_length DC W:00
1255 05D7                       EXPORT flush_entry
1256 05D7 00 00        flush_entry DC W:00                     ;allows us to flush only the I/O buffer
1257 05D9                       EXPORT Users_access
1258 05D9 00 00        users_access DC W:00                    ;used during the open call
1259 05DB
1260 05DB                       Export dirty_flags             ;flags at the beginning of the call
1261 05DB 00 00        dirty_flags DC W:00
1262 05DD                       Export flush_flags
1263 05DD 00 00        flush_flags DC W:00                     ;used by the flush routines
1264 05DF
1265 05DF                       export chk_dirty_flag          ;flag used to indicate that the call can cause dirty blocks
1266 05DF 00 00        chk_dirty_flag DC W:00
1267 05E1                       export dirty_cnt_changed
1268 05E1              dirty_cnt_changed dc.w 00               ;indicates that we have changed the dirty_cnt once
1269 05E1
1270 05E1                       export new_eof
1271 05E1 00 00 00 00  new_eof  DC L:00                        ;used by set EOF
1272 05E5
1273 05E5                       export cp_device_flag
1274 05E5 00 00        cp_device_flag DC W:00                  ;1 = ChangePath using device name, else 0
1275 05E7
1276 05E7                       export cp_flags                ;Added 5-Dec-91 MSD
1277 05E7 00 00        cp_flags DC W:00                        ;$8000 = assume source is duplicate volume
1278 05E9
1279 05E9                       export cp_to_child             ; non-zero if ChangePath trying to move an item
1280 05E9 00 00        cp_to_child DC W:00                     ; into its own child (i.e. :A:B to :A:B:C).
1281 05EB
1282 05EB                       export hfs_flag
1283 05EB 00 00        hfs_flag DC W:00                        ;1 = we have HFS Finder Info, else 0
1284 05ED
1285 05ED                       export hfs_finfo
1286 05ED 00 00 00 00  hfs_finfo DS B:32                       ;storage area for HFS Finder Info
1287 060D
1288 060D                       export error_priority
1289 060D 00 00        error_priority DC W:00                  ;storage for error priority
1290 060F
1291 060F
1292 060F              ;======================================================================
1293 060F              ;Data used by Format and Erase disk calls
1294 060F
1295 060F                       EXPORT format_ctrl
1296 060F 00 00        format_ctrl DC W:00                     ;length of control list
1297 0611
1298 0611                       EXPORT status_list
1299 0611 00 00        status_list DC W:00                     ;status code
1300 0613                       EXPORT return_blks
1301 0613 00 00 00 00  return_blks DC L:00000                  ;number of blocks on device
1302 0617
1303 0617                       EXPORT entries_offset
1304 0617 00 00        entries_offset DC W:00                  ;offset to directory entry
1305 0619                       export gde_temp
1306 0619 00 00        gde_temp DC W:00                        ; temp used by GetDirEntry
1307 061B
1308 061B              ;driver save area
1309 061B
1310 061B                       EXPORT drvr_save
1311 061B 00 00 00 00  drvr_save DS B:$1b                      ;save room for direct page
1312 0636
1313 0636              ;equates used by 'setup_params'
1314 0636
1315 0636                       EXPORT class
1316 0636 00 00        class    DC W:00
1317 0638                       EXPORT max_pcount
1318 0638 00 00        max_pcount DC W:00
1319 063A                       EXPORT flags
1320 063A 00 00        flags    DC W:00
1321 063C
1322 063C              *** added 28-Feb-92 DAL
1323 063C              ;
1324 063C              ; Used by chk_disk_protect to save the first 512 bytes of GBUF
1325 063C              ;
1326 063C                       export chk_protect_gbuf 
1327 063C 00 00 00 00  chk_protect_gbuf DS B:512
1328 083C              *** end 28-Feb-92 DAL
1329 083C
1330 083C                       ENDP 
1331 083C
1332 083C              expand_record Record 
1333 083C 00 00        expand_flag DC W:00
1334 083E 00 00        expand_file DC W:00                     ;used to indicate we are extending a file
1335 0840 00 00        expand_storage DC W:00                  ;storage type of the data fork on extension
1336 0842 00 00        expand_key_blk DC W:00
1337 0844 00 00        expand_blks_used DC W:00
1338 0846 00 00 00 00  expand_eof DC L:00
1339 084A
1340 084A                       endr 
1341 084A
1342 084A              ;==========================================================================
1343 084A              ; Prodos universal boot loader.  This is the second stage boot
1344 084A              ; for all apple manufactured Apple II disk drives.
1345 084A              ; It is located at block zero (0) of a ProDOS formatted disk(ette).
1346 084A              ; Support for Apple /// has been removed to save space.
1347 084A              ;
1348 084A              ;Rev History:
1349 084A              ;
1350 084A              ;Jan 12, 1988   By Rob Turner
1351 084A              ;
1352 084A              ;               Removed Apple /// (SOS) support and converted source to APW
1353 084A              ;
1354 084A              ;Jun 02, 1988   By Rob Turner
1355 084A              ;
1356 084A              ;               Changed the boot code to handle a sparse ProDOS file.
1357 084A              ;
1358 084A              ;==========================================================================
1359 084A
1360 084A              boot_code_start proc 
1361 084A                       endp 
1362 084A
1363 084A                       msb   off
1364 084A                       longa off
1365 084A                       longi off
1366 084A                       MACHINE M6502
1367 084A
1368 084A                       EXPORT boot_code
1369 084A              boot_code PROC temporg $000800
1370 084A
1371 084A              dcmd     equ   $42                      ;disk command (=1 for read)
1372 084A              unit     equ   $43                      ;(16*slot)+(128*(drive-1))
1373 084A              buff     equ   $44                      ;ram address
1374 084A              blok     equ   $46                      ;disk address
1375 084A
1376 084A              dent     equ   $48                      ;device call entry address.
1377 084A              idxl     equ   $4a                      ;pointer to low page of index block
1378 084A              idxh     equ   $4c                      ;pointer to high page of index block
1379 084A              idxp     equ   $4e                      ;index byte pointer.
1380 084A              iobuff   equ   $60
1381 084A
1382 084A              ; the following are for disk ii only:
1383 084A
1384 084A              dbuf     equ   $26
1385 084A              slotz    equ   $2b
1386 084A              oddbits  equ   $3c
1387 084A              sector   equ   $3d
1388 084A              trktmp   equ   $40
1389 084A              track    equ   $41
1390 084A              prior    equ   $50
1391 084A              trkn     equ   $51
1392 084A              rtrycnt  equ   $52
1393 084A              curtrk   equ   $53
1394 084A              trkcnt   equ   $54
1395 084A              *
1396 084A              q6l      equ   $c08c
1397 084A              motoron  equ   $c089
1398 084A              motoroff equ   $c088
1399 084A              phaseoff equ   $c080
1400 084A              nbuf1    equ   $300
1401 084A              dnib     equ   $2d6
1402 084A
1403 084A              * directory dependent stuff...
1404 084A
1405 084A              clrscrn  equ   $fc58
1406 084A              scrn     equ   $5b1                     ;5ae
1407 084A              dostyp   equ   $ff
1408 084A              sosid    equ   $c00
1409 084A              entlen   equ   sosid+$23
1410 084A              kernel   equ   $2000
1411 084A
1412 084A
1413 084A              zzstart  equ   $09F2
1414 084A              rd1      equ   $09F2
1415 084A              rd1a     equ   $09F7
1416 084A              mod1     equ   $0008
1417 084A              chg1     equ   $FFF4
1418 084A              rd2      equ   $09FB
1419 084A              rd3      equ   $0A05
1420 084A              mod2     equ   $001E
1421 084A              chg2     equ   $FFD7
1422 084A              mod3     equ   $0024
1423 084A              rdhd0    equ   $0A15
1424 084A              chg3     equ   $FFD1
1425 084A              rdhd1    equ   $0A17
1426 084A              rdhd2    equ   $0A19
1427 084A              rdhd3    equ   $0A1B
1428 084A              rdhd4    equ   $0A23
1429 084A              mod4     equ   $003F
1430 084A              chg4     equ   $FFB6
1431 084A              mod5     equ   $0045
1432 084A              chg5a    equ   $0A38
1433 084A              mod6     equ   $0047
1434 084A              chg6     equ   $FFB4
1435 084A              rddt1    equ   $0A3A
1436 084A              rddt1a   equ   $0A3C
1437 084A              rddt2    equ   $0A3E
1438 084A              rddt3    equ   $0A4E
1439 084A              rddt4    equ   $0A50
1440 084A              rdchk    equ   $0A5F
1441 084A              mod7     equ   $0076
1442 084A              chg7     equ   $FFAC
1443 084A              nxttwo   equ   $0A6B
1444 084A              twobit   equ   $0A6D
1445 084A              zzzend   equ   $0A7F
1446 084A              chg5     equ   $004B
1447 084A              goseek   equ   $0A83
1448 084A
1449 084A
1450 084A              ;==========================================================================
1451 084A              ;Main Entry Point For Booting Apple II Computer.
1452 084A              ;==========================================================================
1453 084A
1454 084A 01           xboot    DC B:$01                       ;(prodos boot id)
1455 084B 38           entry    sec                            ;(apple iii enters xboot 'ora $38')
1456 084C B0 03                 bcs   entry1                   ;branch if not apple iii native mode.
1457 084E 4C 1C 09              jmp   booterr                  ;Apple /// Boot.
1458 0851
1459 0851 78           entry1   sei                            ;disable interupts so we can boot on the IIGS with debugger
1460 0852 86 43                 stx   unit                     ;save unit number.
1461 0854 C9 03                 cmp   #$03                     ;for disk ii.
1462 0856 08                    php                            ;save result, it may be irrelevent.
1463 0857 8A                    txa                            ;find out if disk ii.
1464 0858 29 70                 and   #$70                     ;strip drive # if any.
1465 085A 4A                    lsr   a
1466 085B 4A                    lsr   a                        ;get slot address.
1467 085C 4A                    lsr   a
1468 085D 4A                    lsr   a
1469 085E 09 C0                 ora   #$c0
1470 0860 85 49                 sta   dent+1
1471 0862 A0 FF                 ldy   #$ff                     ;look at last byte.
1472 0864 84 48                 sty   dent
1473 0866 28                    plp                            ;restore carry (if disk ii & sect 0&2 read carry set).
1474 0867 C8                    iny                            ;make y=0
1475 0868 B1 48                 lda   (dent),y                 ;get device entry addr.
1476 086A D0 3A                 bne   ndsk2                    ;branch if not disk ii (16 sector).
1477 086C B0 0E                 bcs   isdsk2                   ;branch if it is disk ii, but block 0 read.
1478 086E A9 03                 lda   #3                       ;make rom read only sector 2
1479 0870 8D 00 08              sta   xboot                    ;to complete block 0 
1480 0873 E6 3D                 inc   sector                   ;(was = 1)
1481 0875 A5 49                 lda   dent+1                   ;do rts to re-enter rom.
1482 0877 48                    pha   
1483 0878 A9 5B                 lda   #$5b
1484 087A 48                    pha   
1485 087B 60                    rts                            ;go read sector 2 into $900.
1486 087C
1487 087C 85 40        isdsk2   sta   trktmp                   ;make sure previous track =0
1488 087E 85 48                 sta   dent                     ;and dent points at beginning of slot
1489 0880 A0 5E                 ldy   #$5e                     ;move code from card to ram
1490 0882 B1 48        mvboot   lda   (dent),y
1491 0884 99 94 09              sta   zzstart-$5e,y
1492 0887 C8                    iny   
1493 0888 C0 EB                 cpy   #$eb                     ;have we moved enough?
1494 088A D0 F6                 bne   mvboot
1495 088C A2 06                 ldx   #6                       ;now modify code to handle errors.
1496 088E BC 32 09     modboot  ldy   mods,x
1497 0891 BD 39 09              lda   chgs,x
1498 0894 99 F2 09              sta   zzstart,y
1499 0897 BD 40 09              lda   endcode,x
1500 089A 9D 7F 0A              sta   zzzend,x
1501 089D CA                    dex   
1502 089E 10 EE                 bpl   modboot
1503 08A0 A9 09                 lda   #>d2io                   ;reset device entry
1504 08A2 85 49                 sta   dent+1                   ; to point at disk ii routines.
1505 08A4 A9 86                 lda   #<d2io                   ;get low addr (must be <$80)
1506 08A6 A0 00        ndsk2    ldy   #0                       ;make sure y=0 again.
1507 08A8 C9 F9                 cmp   #$f9
1508 08AA B0 2F                 bcs   bterr1                   ;branch if not bootable device.
1509 08AC 85 48                 sta   dent                     ;save low adr of device call entry.
1510 08AE 84 60                 sty   iobuff
1511 08B0 84 4A                 sty   idxl
1512 08B2 84 4C                 sty   idxh                     ;(y=0)
1513 08B4 84 4E                 sty   idxp
1514 08B6 84 47                 sty   blok+1
1515 08B8 C8                    iny   
1516 08B9 84 42                 sty   dcmd                     ;set read command.
1517 08BB C8                    iny   
1518 08BC 84 46                 sty   blok                     ; to read directory blocks 
1519 08BE A9 0C                 lda   #$c                      ; 2-5 at $c00 
1520 08C0 85 61                 sta   iobuff+1
1521 08C2 85 4B                 sta   idxl+1
1522 08C4
1523 08C4 20 27 09     rddir    jsr   goread                   ;call read block routine.
1524 08C7 B0 66                 bcs   bterr2                   ;give up on error.
1525 08C9 E6 61                 inc   iobuff+1
1526 08CB E6 61                 inc   iobuff+1
1527 08CD E6 46                 inc   blok
1528 08CF A5 46                 lda   blok                     ;have all directory blocks been read?
1529 08D1 C9 06                 cmp   #6
1530 08D3 90 EF                 bcc   rddir                    ;loop if not.
1531 08D5
1532 08D5 AD 00 0C              lda   sosid                    ;is it a prodos (sos) directory?
1533 08D8 0D 01 0C              ora   sosid+1
1534 08DB D0 52        bterr1   bne   bterr2                   ;booterr                ;branch if not.
1535 08DD A9 04                 lda   #4                       ;begin look-up with first entry past header.
1536 08DF D0 02                 bne   nxdent1                  ;branch always
1537 08E1 A5 4A        nxdent   lda   idxl
1538 08E3 18           nxdent1  clc   
1539 08E4 6D 23 0C              adc   entlen                   ;bump to next directory entry.
1540 08E7 A8                    tay                            ;save in y for now.
1541 08E8 90 0D                 bcc   nxdent2                  ;branch if not a page cross.
1542 08EA E6 4B                 inc   idxl+1
1543 08EC A5 4B                 lda   idxl+1                   ;check for new block.
1544 08EE 4A                    lsr   a                        ;if even then new block.
1545 08EF B0 06                 bcs   nxdent2
1546 08F1 C9 0A                 cmp   #$a                      ;have all file names been compared?
1547 08F3 F0 71                 beq   nopro                    ;branch if no pro.kernel.
1548 08F5 A0 04                 ldy   #4                       ;else, begin at block beginning.
1549 08F7 84 4A        nxdent2  sty   idxl                     ;note: this method treats garbage at
1550 08F9 AD 20 09              lda   sysname                  ; the end of the dir block as an entry.
1551 08FC 29 0F                 and   #$f                      ;get target name length.
1552 08FE A8                    tay   
1553 08FF B1 4A        lookpro  lda   (idxl),y                 ;look for matching name.
1554 0901 D9 20 09              cmp   sysname,y                ;last to first method.
1555 0904 D0 DB                 bne   nxdent                   ;branch if no match.
1556 0906 88                    dey                            ;else check all characters.
1557 0907 10 F6                 bpl   lookpro                  ;including length/storage type.
1558 0909
1559 0909 A0 16                 ldy   #$16                     ;convert eof to blks.
1560 090B B1 4A                 lda   (idxl),y
1561 090D 4A                    lsr   a                        ;convert to blocks
1562 090E 6D 1F 09              adc   blk_count
1563 0911 8D 1F 09              sta   blk_count
1564 0914
1565 0914              ;	ldy	#$10	;get file type & index block addr.
1566 0914              ;	lda	(idxl),y
1567 0914              ;	cmp	#dostyp	;is it a system file?
1568 0914              ;	bne	booterr
1569 0914              ;	iny
1570 0914
1571 0914 A0 11                 ldy   #$11                     ;starting block of the file
1572 0916 B1 4A                 lda   (idxl),y
1573 0918 85 46                 sta   blok
1574 091A C8                    iny   
1575 091B B1 4A                 lda   (idxl),y
1576 091D 85 47                 sta   blok+1
1577 091F A9 00                 lda   #0                       ;now set up to read kernel.
1578 0921 85 4A                 sta   idxl
1579 0923 A0 1E                 ldy   #$1e                     ;read index block at $1e00 and
1580 0925 84 4B                 sty   idxl+1                   ; kernel at $2000
1581 0927 84 61                 sty   iobuff+1
1582 0929 C8                    iny   
1583 092A 84 4D                 sty   idxh+1
1584 092C 20 27 09     rdkernl  jsr   goread                   ;read index block.
1585 092F B0 35        bterr2   bcs   booterr
1586 0931
1587 0931 E6 61                 inc   iobuff+1                 ;setup pointer for the next block please
1588 0933 E6 61                 inc   iobuff+1
1589 0935              @sparse_return  
1590 0935 A4 4E                 ldy   idxp                     ;get index pointer
1591 0937 E6 4E                 inc   idxp                     ;bump for next time.
1592 0939
1593 0939 B1 4A                 lda   (idxl),y
1594 093B 85 46                 sta   blok
1595 093D B1 4C                 lda   (idxh),y                 ;high disk addr.
1596 093F 85 47                 sta   blok+1
1597 0941 11 4A                 ora   (idxl),y                 ;if both=0 then done. (This was changed to handle sparse)
1598 0943 D0 18                 bne   not_sparse
1599 0945
1600 0945 A2 01                 ldx   #$01
1601 0947 A9 00                 lda   #$00                     ;clear the block please
1602 0949 A8                    tay   
1603 094A 91 60        @1       sta   (ioBuff),y
1604 094C C8                    iny   
1605 094D D0 FB                 bne   @1                       ;clear the low page
1606 094F E6 61                 inc   ioBuff+1                 ;bump to the next page
1607 0951 EA                    nop   
1608 0952 EA                    nop                            ;keep things aligned please
1609 0953 CA                    dex   
1610 0954 10 F4                 bpl   @1                       ;clear the high page
1611 0956 CE 1F 09              dec   blk_count
1612 0959 F0 07                 beq   go_kernel
1613 095B D0 D8                 bne   @sparse_return
1614 095D              not_sparse  
1615 095D CE 1F 09              dec   blk_count                ;are we done yet
1616 0960 D0 CA                 bne   rdkernl                  ;branch if more to read.
1617 0962              go_kernel  
1618 0962 58                    cli                            ;enable interupts before calling ProDOS
1619 0963 4C 00 20              jmp   kernel                   ;go execute kernel code.
1620 0966
1621 0966              nopro    equ   *
1622 0966              booterr  equ   *
1623 0966 4C 47 09              jmp   quitmes
1624 0969
1625 0969 02           blk_count DC B:02
1626 096A                       msb   off
1627 096A 26           sysname  DC B:$26
1628 096B 50 52 4F 44           DC B:'PRODOS'
1629 0971
1630 0971 A5 60        goread   lda   iobuff
1631 0973 85 44                 sta   buff
1632 0975 A5 61                 lda   iobuff+1
1633 0977 85 45                 sta   buff+1
1634 0979 6C 48 00              jmp   (dent)
1635 097C              *
1636 097C 08 1E 24 3F  mods     DC B:mod1,mod2,mod3,mod4
1637 0980 45 47 76              DC B:mod5,mod6,mod7
1638 0983              *
1639 0983 F4 D7 D1 B6  chgs     DC B:chg1**$FF,chg2**$FF,chg3**$FF,chg4**$FF
1640 0987 4B B4 AC              DC B:chg5**$FF,chg6**$FF,chg7**$FF
1641 098A              *
1642 098A
1643 098A              endcode  equ   *
1644 098A A6 2B                 ldx   slotz
1645 098C 18                    clc   
1646 098D 60                    rts   
1647 098E 4C BC 09              jmp   seek
1648 0991              *
1649 0991 20 58 FC     quitmes  jsr   clrscrn                  ;clear video.
1650 0994 A0 14                 ldy   #meslen                  ;print message centered on screen.
1651 0996 B9 58 09     prmess   lda   errmess,y
1652 0999 99 B1 05              sta   scrn,y
1653 099C 88                    dey   
1654 099D 10 F7                 bpl   prmess
1655 099F 4C 55 09     hang     jmp   hang
1656 09A2              *
1657 09A2                       msb   on
1658 09A2              meslen   equ   20
1659 09A2 D5 CE C1 C2  errmess  DC B:'UNABLE TO LOAD PRODOS'
1660 09B7
1661 09B7
1662 09B7              ********************************************************************************
1663 09B7              * This code MUST be aligned to $16D ($96D Absolute) relative address. Otherwise
1664 09B7              * disk][s will not work. This is a major pain in the butt.
1665 09B7              ********************************************************************************
1666 09B7
1667 09B7 A5 53        setphase lda   curtrk                   ;get current track
1668 09B9 29 03        clrphase and   #3                       ;mask for 1 of 4 phases
1669 09BB 2A                    rol   a                        ;double for phaseon/off index
1670 09BC 05 2B                 ora   slotz
1671 09BE AA                    tax   
1672 09BF BD 80 C0              lda   phaseoff,x               ;turn on/off one phase
1673 09C2 A9 2C                 lda   #$2c
1674 09C4              **************************
1675 09C4              *                        *
1676 09C4              *   mswait subroutine    *
1677 09C4              *                        *
1678 09C4              **************************
1679 09C4 A2 11        mswait   ldx   #$11
1680 09C6 CA           msw1     dex                            ;delay 86 usec.
1681 09C7 D0 FD                 bne   msw1
1682 09C9 E9 01                 sbc   #$1                      ;done 'n' intervals?
1683 09CB D0 F7                 bne   mswait                   ;(a-reg counts)
1684 09CD A6 2B                 ldx   slotz                    ;restore x-reg
1685 09CF 60                    rts   
1686 09D0              *
1687 09D0              *
1688 09D0 A5 46        d2io     lda   blok                     ;figure out track & sector.
1689 09D2 29 07                 and   #7                       ;strip track for now.
1690 09D4 C9 04                 cmp   #4
1691 09D6 29 03                 and   #3
1692 09D8 08                    php   
1693 09D9 0A                    asl   a
1694 09DA 28                    plp   
1695 09DB 2A                    rol   a                        ;now we have the first sector of block.
1696 09DC 85 3D                 sta   sector
1697 09DE A5 47                 lda   blok+1                   ;get high block #
1698 09E0 4A                    lsr   a                        ;shift hi addr to carry.
1699 09E1 A5 46                 lda   blok                     ;now figure track #
1700 09E3 6A                    ror   a
1701 09E4 4A                    lsr   a
1702 09E5 4A                    lsr   a
1703 09E6 85 41                 sta   track
1704 09E8 0A                    asl   a
1705 09E9 85 51                 sta   trkn
1706 09EB A5 45                 lda   buff+1
1707 09ED 85 27                 sta   dbuf+1
1708 09EF A6 2B                 ldx   slotz
1709 09F1 BD 89 C0              lda   motoron,x
1710 09F4 20 BC 09              jsr   rdsector                 ;go read sector.
1711 09F7 E6 27                 inc   dbuf+1                   ;bump address
1712 09F9 E6 3D                 inc   sector
1713 09FB E6 3D                 inc   sector                   ;and sector #
1714 09FD B0 03                 bcs   quitrd                   ;branch if error.
1715 09FF 20 BC 09              jsr   rdsector
1716 0A02 BC 88 C0     quitrd   ldy   motoroff,x
1717 0A05 60           erretrn  rts                            ;return error status in carry.
1718 0A06              *
1719 0A06              rdsector equ   *                        ;do seek then read sector.
1720 0A06              *
1721 0A06 A5 40        seek     lda   trktmp                   ;get track we're on.
1722 0A08 0A                    asl   a
1723 0A09 85 53                 sta   curtrk
1724 0A0B A9 00                 lda   #$0
1725 0A0D 85 54                 sta   trkcnt                   ;halftrack count.
1726 0A0F A5 53        seek2    lda   curtrk                   ;save curtrk for
1727 0A11 85 50                 sta   prior                    ;delayed turnoff.
1728 0A13 38                    sec   
1729 0A14 E5 51                 sbc   trkn                     ;delta-tracks.
1730 0A16 F0 14                 beq   seekend                  ;br if curtrk=destination
1731 0A18 B0 04                 bcs   out                      ;(move out, not in)
1732 0A1A E6 53                 inc   curtrk                   ;incr current track (in).
1733 0A1C 90 02                 bcc   skin                     ;(always taken)
1734 0A1E C6 53        out      dec   curtrk                   ;decr current track (out).
1735 0A20 38           skin     sec   
1736 0A21 20 6D 09     step2    jsr   setphase
1737 0A24 A5 50                 lda   prior
1738 0A26 18                    clc                            ;for phaseoff
1739 0A27 20 6F 09              jsr   clrphase                 ;de-energize previous phase.
1740 0A2A D0 E3                 bne   seek2                    ;(always taken)
1741 0A2C              seekend  equ   *
1742 0A2C              *
1743 0A2C A0 7F        rdsect1  ldy   #$7f                     ;allow 127 mistakes.
1744 0A2E 84 52                 sty   rtrycnt
1745 0A30 08                    php   
1746 0A31              *
1747 0A31 28           tryread  plp                            ;fix stack.
1748 0A32
1749 0A32 38           rdhead   sec                            ;anticipate error.
1750 0A33 C6 52                 dec   rtrycnt                  ;if = 0 then give up!
1751 0A35 F0 CE                 beq   erretrn                  ;branch if can't fine/read sector.
1752 0A37 18                    clc                            ;indicate reading header.
1753 0A38 08           rddata   php                            ;carry set if reading sector.
1754 0A39 88           rd0      dey                            ;every time y=0 decrement find count.
1755 0A3A F0 F5                 beq   tryread
1756 0A3C
1757 0A3C                       MACHINE M65816                 ;start using 65816 code again
1758 0A3C                       msb   off
1759 0A3C                       longa on
1760 0A3C                       longi on
1761 0A3C
1762 0A3C                       export boot_size:equ           ;export the equate for Max
1763 0A3C              boot_size equ   *-xboot
1764 0A3C                       ENDP 
1765 0A3C
1766 0A3C              ;======================================================================
1767 0A3C              ;Pack_Time:  This routine will read the time from the GS Clock and
1768 0A3C              ;            convert it to packed ProDOS disk format
1769 0A3C              ; 
1770 0A3C              ;Input:         A = undefined
1771 0A3C              ;               X = undefined
1772 0A3C              ;               Y = undefined
1773 0A3C              ;               P = nvmxdizc
1774 0A3C              ;                   ..000..0
1775 0A3C              ;               b = k
1776 0A3C              ;
1777 0A3C              ;Output:        A = undefined
1778 0A3C              ;               X = low word of time
1779 0A3C              ;               Y = High word of time
1780 0A3C              ;
1781 0A3C              ;               time is also stored at Pro_Time and Pro_Time+2 
1782 0A3C              ;
1783 0A3C              ;Format of time:
1784 0A3C              ; 
1785 0A3C              ; |<-------- X Register --------->|<-------- Y Register --------->|
1786 0A3C              ; |                               |                               | 
1787 0A3C              ; |<--high Byte-->|<--low  Byte-->|<--high Byte-->|<--low  Byte-->| 
1788 0A3C              ;  _______________________________________________________________
1789 0A3C              ; | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | |
1790 0A3C              ; |    year     | month |   day   |0 0 0|  hour   |0 0|   minute  |
1791 0A3C              ; |_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|
1792 0A3C              ; 
1793 0A3C              ; 
1794 0A3C              ;               P = nvmxdizc
1795 0A3C              ;                   ..000...
1796 0A3C              ;               b = k
1797 0A3C              ;
1798 0A3C              ;Uses:          all register
1799 0A3C              ;               get_time                (Subroutine that reads time)
1800 0A3C              ;               hours,minutes           (data words)
1801 0A3C              ;               year,month,day
1802 0A3C              ; 
1803 0A3C
1804 0A3C                       longa on
1805 0A3C                       longi on
1806 0A3C
1807 0A3C                       EXPORT pack_time
1808 0A3C              pack_time PROC 
1809 0A3C
1810 0A3C 9C 03 03              stz   pro_time
1811 0A3F 9C 05 03              stz   pro_time+2
1812 0A42
1813 0A42 20 44 0B              jsr   get_time                 ;read the time from tool set
1814 0A45
1815 0A45              ;We call this entry point if the time parameters are setup and need
1816 0A45              ;only to be convert to the ProDOS format.
1817 0A45
1818 0A45                       EXPORT convert_time
1819 0A45              convert_time  
1820 0A45 AD FF 02              lda   day
1821 0A48 8D 03 03              sta   pro_time                 ;save the day in prodos format
1822 0A4B AD FD 02              lda   month
1823 0A4E 0A                    asl   a
1824 0A4F 0A                    asl   a
1825 0A50 0A                    asl   a
1826 0A51 0A                    asl   a
1827 0A52 0A                    asl   a                        ;shift to correct position
1828 0A53 0D 03 03              ora   pro_time                 ;month is now happy
1829 0A56 8D 03 03              sta   pro_time
1830 0A59 AD FB 02              lda   year
1831 0A5C
1832 0A5C              ; 27-Jan-92 MSD: Years outside the range 1940..2039 will be converted
1833 0A5C              ; to "unknown" (i.e. all zeroes).
1834 0A5C C9 28 00              cmp   #40                      ; less than 1940?
1835 0A5F 90 29                 blt   @bad_year
1836 0A61 C9 8C 00              cmp   #140                     ; 2040 or greater?
1837 0A64 B0 24                 bge   @bad_year
1838 0A66 C9 64 00              cmp   #100                     ; 2000..2039?
1839 0A69 90 03                 blt   @got_year                ; no, so leave as is
1840 0A6B E9 64 00              sbc   #100                     ; convert 2000..2039 to 0..39
1841 0A6E              @got_year  
1842 0A6E              ; End 27-Jan-92 MSD
1843 0A6E
1844 0A6E EB                    xba   
1845 0A6F 0A                    asl   a                        ;shift year to upper 7 bits
1846 0A70 0D 03 03              ora   pro_time
1847 0A73 8D 03 03              sta   pro_time
1848 0A76 AA                    tax                            ;return in X register too
1849 0A77 AD F9 02              lda   minutes
1850 0A7A 8D 05 03              sta   pro_time+2
1851 0A7D AD F7 02              lda   hours
1852 0A80 EB                    xba   
1853 0A81 0D 05 03              ora   pro_time+2
1854 0A84 8D 05 03              sta   pro_time+2
1855 0A87 A8                    tay                            ;return in Y register
1856 0A88 18                    clc                            ; 27-Jan-92 MSD: valid date/time
1857 0A89 60                    rts   
1858 0A8A
1859 0A8A              @bad_year                               ; year was bad, set date/time
1860 0A8A A2 00 00              ldx   #0                       ; to "unknown" (all zeroes).
1861 0A8D 9B                    txy   
1862 0A8E 8E 03 03              stx   pro_time
1863 0A91 8C 05 03              sty   pro_time+2
1864 0A94 38                    sec                            ; 27-Jan-92 MSD: invalid date/time
1865 0A95 60                    rts   
1866 0A96
1867 0A96                       ENDP 
1868 0A96
1869 0A96              ;======================================================================
1870 0A96              ;unpack_time:   This routine will unpack a prodos time into a GS/OS time.
1871 0A96              ;
1872 0A96              ;Input:         A = undefined
1873 0A96              ;
1874 0A96              ;Format of time:
1875 0A96              ; 
1876 0A96              ; |<-------- X Register --------->|<-------- Y Register --------->|
1877 0A96              ; |                               |                               | 
1878 0A96              ; |<--high Byte-->|<--low  Byte-->|<--high Byte-->|<--low  Byte-->| 
1879 0A96              ;  _______________________________________________________________
1880 0A96              ; | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | |
1881 0A96              ; |    year     | month |   day   |x x x|  hour   |x x|   minute  |
1882 0A96              ; |_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|
1883 0A96              ; 
1884 0A96              ;               P = nvmxdizc
1885 0A96              ;                   ..000..0
1886 0A96              ;               b = k
1887 0A96              ;
1888 0A96              ;Output:        A = undefined
1889 0A96              ;               X = undefined
1890 0A96              ;               Y = undefined
1891 0A96              ;               P = nvmxdizc
1892 0A96              ;                   ..000...
1893 0A96              ;               b = k
1894 0A96              ;               hours                   (Times are all hex format)
1895 0A96              ;               minutes
1896 0A96              ;               year
1897 0A96              ;               month
1898 0A96              ;               day
1899 0A96              ;               day_of_week 
1900 0A96              ;
1901 0A96              ;Uses:          all register
1902 0A96              ;               dow_convert             (Subroutine)
1903 0A96              ;
1904 0A96                       longa on
1905 0A96                       longi on
1906 0A96
1907 0A96                       EXPORT unpack_time
1908 0A96              unpack_time PROC 
1909 0A96
1910 0A96 8E 03 03              stx   pro_time
1911 0A99 8C 05 03              sty   pro_time+2
1912 0A9C
1913 0A9C              ;Init time to zero (unknown)
1914 0A9C
1915 0A9C 20 FC 0A              jsr   zero_date
1916 0A9F
1917 0A9F 8A                    txa   
1918 0AA0 0D 05 03              ora   pro_time+2
1919 0AA3 F0 69                 beq   end_unpack
1920 0AA5
1921 0AA5 AD 03 03              lda   pro_time
1922 0AA8 29 1F 00              and   #$001F                   ;isolate day
1923 0AAB 8D FF 02              sta   day
1924 0AAE C9 20 00              cmp   #32                      ;valid days are 01 to 31
1925 0AB1 B0 49                 bcs   zero_date                ;sorry bud you get unknown
1926 0AB3
1927 0AB3 A8                    tay                            ;save for DOW convert
1928 0AB4 8A                    txa                            ;get year/month/day again (X is still valid here)
1929 0AB5 4A                    lsr   a
1930 0AB6 4A                    lsr   a
1931 0AB7 4A                    lsr   a
1932 0AB8 4A                    lsr   a
1933 0AB9 4A                    lsr   a
1934 0ABA 29 0F 00              and   #$000F                   ;isolate month
1935 0ABD 8D FD 02              sta   month
1936 0AC0 C9 0D 00              cmp   #13                      ;is the month 13 or >?
1937 0AC3 B0 37                 bcs   zero_date
1938 0AC5
1939 0AC5 AA                    tax   
1940 0AC6 AD 03 03              lda   pro_time
1941 0AC9 EB                    xba   
1942 0ACA 4A                    lsr   a
1943 0ACB 29 7F 00              and   #$007F                   ;isolate the year
1944 0ACE C9 28 00              cmp   #40                      ;year = 40-99?
1945 0AD1 B0 03                 bcs   @store_it                ;yes, must be 1940-1999
1946 0AD3 69 64 00              adc   #100                     ;else must be 2000-2039, adjust
1947 0AD6              @store_it  
1948 0AD6 8D FB 02              sta   year
1949 0AD9 20 0F 0B              jsr   dow_convert              ;go ahead and calculate the day of week
1950 0ADC 8D 01 03              sta   day_of_week
1951 0ADF AD 05 03              lda   pro_time+2
1952 0AE2 29 3F 00              and   #$003F                   ;isolate minutes
1953 0AE5 8D F9 02              sta   minutes
1954 0AE8 C9 3C 00              cmp   #60
1955 0AEB B0 0F                 bcs   zero_date
1956 0AED
1957 0AED AD 05 03              lda   pro_time+2
1958 0AF0 EB                    xba   
1959 0AF1 29 1F 00              and   #$001F                   ;isolate hours
1960 0AF4 8D F7 02              sta   hours
1961 0AF7 C9 18 00              cmp   #24
1962 0AFA 90 12                 bcc   end_unpack
1963 0AFC
1964 0AFC              zero_date                               ;indicate that the date is unknown
1965 0AFC 9C F7 02              stz   hours
1966 0AFF 9C F9 02              stz   minutes
1967 0B02 9C FB 02              stz   year
1968 0B05 9C FD 02              stz   month
1969 0B08 9C FF 02              stz   day
1970 0B0B 9C 01 03              stz   day_of_week
1971 0B0E 60           end_unpack rts   
1972 0B0F                       ENDP 
1973 0B0F
1974 0B0F
1975 0B0F              ;======================================================================
1976 0B0F              ;DOW_Convert:This routine convert Month,Day,Year into day of week
1977 0B0F              ;
1978 0B0F              ;Input:         A = Year
1979 0B0F              ;               X = Month
1980 0B0F              ;               Y = Day
1981 0B0F              ;               P = saved
1982 0B0F              ;               b = k
1983 0B0F              ;
1984 0B0F              ;Output:        A = day of week
1985 0B0F              ;               X = undefined
1986 0B0F              ;               Y = undefined
1987 0B0F              ;               P = restored
1988 0B0F              ;               b = k
1989 0B0F              ;
1990 0B0F              ;Uses:          all register
1991 0B0F              ;               local temps 
1992 0B0F              ;
1993 0B0F                       longa off
1994 0B0F                       longi off
1995 0B0F
1996 0B0F                       EXPORT dow_convert
1997 0B0F              dow_convert PROC 
1998 0B0F 08                    php   
1999 0B10 E2 30                 sep   #$30
2000 0B12 5A                    phy   
2001 0B13 A8                    tay   
2002 0B14
2003 0B14              ;Figure the number of leap years since 1900
2004 0B14
2005 0B14 4A                    lsr   a
2006 0B15 4A                    lsr   a
2007 0B16 8D 37 0B              sta   dow_temp
2008 0B19
2009 0B19              ;If it's a leap year and it's Jan or Feb subtract 1 from the total
2010 0B19
2011 0B19 98                    tya                            ;get the year back
2012 0B1A 29 03                 and   #%00000011
2013 0B1C D0 05                 bne   stim015
2014 0B1E E0 03                 cpx   #03
2015 0B20 B0 01                 bcs   stim015
2016 0B22 88                    dey   
2017 0B23
2018 0B23              ;add the number of leap years elapsed, the year, a constant for the
2019 0B23              ;month, and the day
2020 0B23
2021 0B23              stim015   
2022 0B23 18                    clc   
2023 0B24 98                    tya                            ;get the year again
2024 0B25 6D 37 0B              adc   dow_temp                 ;# of leap years since 1900
2025 0B28 7D 37 0B              adc   wkmon-1,x
2026 0B2B 63 01                 adc   1,s
2027 0B2D 7A                    ply                            ;clean the stack
2028 0B2E
2029 0B2E              ;Now mod the result by seven, but exit in the range [1..7]
2030 0B2E
2031 0B2E 38                    sec   
2032 0B2F              stim016                                 ;
2033 0B2F E9 07                 sbc   #07
2034 0B31 C9 08                 cmp   #08
2035 0B33 B0 FA                 bcs   stim016
2036 0B35 28                    plp                            ;restore mode
2037 0B36 60                    rts   
2038 0B37
2039 0B37 00           dow_temp DC B:0
2040 0B38
2041 0B38 08 0B 0B 07  wkmon    DC B:$08,$0B,$0B,$07,$09,$0C,$07,$0A,$0D,$08,$0B,$0D
2042 0B44
2043 0B44                       ENDP 
2044 0B44
2045 0B44              ;======================================================================
2046 0B44              ;get_time:   This routine will read the time from the GS Clock.
2047 0B44              ;
2048 0B44              ; 
2049 0B44              ;Input:         A = undefined
2050 0B44              ;               X = undefined
2051 0B44              ;               Y = undefined
2052 0B44              ;               P = nvmxdizc
2053 0B44              ;                   ..000..0
2054 0B44              ;               b = k
2055 0B44              ;
2056 0B44              ;Output:        A = undefined
2057 0B44              ;               X = undefined
2058 0B44              ;               Y = undefined
2059 0B44              ;               P = nvmxdizc
2060 0B44              ;                   ..000...
2061 0B44              ;               b = k
2062 0B44              ;
2063 0B44              ;               hours,minutes
2064 0B44              ;               year,month,day          ;all are setup with the time
2065 0B44              ;               day_of_week
2066 0B44              ;
2067 0B44              ;uses:          Misc tools              ;(Gets hex time)
2068 0B44              ; 
2069 0B44              ;======================================================================
2070 0B44
2071 0B44                       longa on
2072 0B44                       longi on
2073 0B44
2074 0B44                       EXPORT get_time
2075 0B44              get_time PROC 
2076 0B44
2077 0B44 A9 00 00              lda   #0000                    ;setup default time to zero
2078 0B47 48                    pha                            ;minutes,seconds result
2079 0B48 48                    pha                            ;year,hour results
2080 0B49 48                    pha                            ;month,day results
2081 0B4A 48                    pha                            ;weekday,null results
2082 0B4B
2083 0B4B A2 03 0D              ldx   #(read_time_hex*$100)+misc_tools 
2084 0B4E 22 00 00 E1           jsl   tool_locator
2085 0B52
2086 0B52                       longa off
2087 0B52 E2 20                 sep   #$20
2088 0B54 68                    pla                            ;disregard seconds
2089 0B55 68                    pla   
2090 0B56 8D F9 02              sta   minutes
2091 0B59 68                    pla   
2092 0B5A 8D F7 02              sta   hours
2093 0B5D 68                    pla   
2094 0B5E 8D FB 02              sta   year
2095 0B61 68                    pla   
2096 0B62
2097 0B62 B0 01                 bcs   no_inc1
2098 0B64 1A                    inc   a
2099 0B65 8D FF 02     no_inc1  sta   day                      ;convert 0 to 30 ->  1 to 31
2100 0B68
2101 0B68 68                    pla   
2102 0B69 B0 01                 bcs   no_inc2
2103 0B6B 1A                    inc   a
2104 0B6C 8D FD 02     no_inc2  sta   month                    ;convert 0 to 11 ->  1 to 12
2105 0B6F
2106 0B6F 68                    pla                            ;null field
2107 0B70 68                    pla   
2108 0B71 8D 01 03              sta   day_of_week
2109 0B74                       longa on
2110 0B74 C2 30                 rep   #$30
2111 0B76 60                    rts   
2112 0B77                       ENDP 
2113 0B77
2114 0B77
2115 0B77              ;============================================================================
2116 0B77              ;
2117 0B77              ;Calc_Bit:      This routine will convert a 16 bit block number into
2118 0B77              ;               the correct index into the bitmap block, the correct pattern
2119 0B77              ;               to indicate which bit it is, and which relative block in the
2120 0B77              ;               bitmap contains the bit
2121 0B77              ;
2122 0B77              ;Input:         X = Block number to convert
2123 0B77              ;               m = 0
2124 0B77              ;               x = 0
2125 0B77              ;               b = k
2126 0B77              ;
2127 0B77              ;Output:        A = Bit Pattern (Which bit that needs to be changed)
2128 0B77              ;               Y = Byte offset into bitmap block that contains bit
2129 0B77              ;               X = Relative Block number of the bitmap that contains the bit
2130 0B77              ;               Carry Clr
2131 0B77              ;               All other flags undefined
2132 0B77              ;
2133 0B77              ;Uses:          Local Table
2134 0B77              ;               All registers
2135 0B77              ;
2136 0B77
2137 0B77                       EXPORT calc_bit
2138 0B77              calc_bit PROC 
2139 0B77
2140 0B77 8A                    txa                            ;X=Block number
2141 0B78 29 07 00              and   #$0007                   ;isolate bit index
2142 0B7B A8                    tay   
2143 0B7C B9 9C 0B              lda   bit_table,y              ;get the bit pattern
2144 0B7F 29 FF 00              and   #$00FF                   ;table is a byte table
2145 0B82 48                    pha   
2146 0B83 8A                    txa                            ;now isolate byte index
2147 0B84 29 F8 0F              and   #$0FF8
2148 0B87 4A                    lsr   a
2149 0B88 4A                    lsr   a
2150 0B89 4A                    lsr   a
2151 0B8A A8                    tay                            ;Y=Offset into bitmap block
2152 0B8B 20 90 0B              jsr   abs_to_rel               ;absolute to relative block number
2153 0B8E 68                    pla                            ;A=Bit pattern
2154 0B8F 60                    rts   
2155 0B90
2156 0B90                       EXPORT abs_to_rel
2157 0B90              abs_to_rel  
2158 0B90 18                    clc   
2159 0B91 8A                    txa                            ;now isolate relative block number
2160 0B92 29 00 F0              and   #$F000
2161 0B95 2A                    rol   a
2162 0B96 2A                    rol   a
2163 0B97 2A                    rol   a
2164 0B98 2A                    rol   a
2165 0B99 2A                    rol   a
2166 0B9A AA                    tax                            ;X=Relative block number in bitmap
2167 0B9B 60                    rts   
2168 0B9C
2169 0B9C 80 40 20 10  bit_table DC B:$80,$40,$20,$10,$08,$04,$02,$01
2170 0BA4                       ENDP 
2171 0BA4
2172 0BA4              ;============================================================================
2173 0BA4              ;Alloc_block    This routine will allocate a block in the bitmap.
2174 0BA4              ;               If the block is not in memory then it will load it.
2175 0BA4              ;
2176 0BA4              ;Input:         X = Block number that you want to allocate
2177 0BA4              ;               m = 0
2178 0BA4              ;               x = 0
2179 0BA4              ;               b = k
2180 0BA4              ;               prodos_vcr_ptr
2181 0BA4              ;
2182 0BA4              ;Output:        carry clr = no error
2183 0BA4              ;               carry set = could not allocate
2184 0BA4              ;               A = error code if carry set
2185 0BA4              ;                       01 = User would not mount the volume
2186 0BA4              ;               all flags undefined
2187 0BA4              ;
2188 0BA4              ;Uses:          All Registers
2189 0BA4              ;               Calc_bit        (Subroutine)
2190 0BA4              ;               Get_Bit_block   (Subroutine)
2191 0BA4              ;               bitmap_changed  (Subroutine)
2192 0BA4              ;
2193 0BA4
2194 0BA4                       EXPORT alloc_block
2195 0BA4              alloc_block PROC 
2196 0BA4
2197 0BA4 20 77 0B              jsr   calc_bit                 ;calculate bit(A),byte(Y),block(X)
2198 0BA7 48                    pha   
2199 0BA8 5A                    phy   
2200 0BA9 20 14 0C              jsr   get_bit_block            ;load the correct block if needed
2201 0BAC 7A                    ply   
2202 0BAD 68                    pla   
2203 0BAE AA                    tax                            ;save mask
2204 0BAF B0 12                 bcs   done                     ;could not load block from disk
2205 0BB1 37 BC                 and   [bitmap],y               ;is the block already allocated?
2206 0BB3 F0 0F                 beq   bitmap_corrupt           ;the bitmap is in bad shape, sorry.
2207 0BB5 8A                    txa                            ;restore the AND mask
2208 0BB6 49 FF FF              eor   #$FFFF                   ;we need to flip the patterns
2209 0BB9 37 BC                 and   [Bitmap],y               ;clear the correct bit
2210 0BBB 97 BC                 sta   [bitmap],y
2211 0BBD 20 FF 0B              jsr   bitmap_changed           ;update bitmap flags
2212 0BC0 20 C9 0B              jsr   sub_free_blk             ;adjust free block count
2213 0BC3 60           done     rts   
2214 0BC4
2215 0BC4                       EXPORT bitmap_corrupt
2216 0BC4              bitmap_corrupt                          ;we get here if the bitmap is corrupt
2217 0BC4 A9 5A 00              lda   #damaged_bitmap
2218 0BC7 38                    sec   
2219 0BC8 60                    rts                            ;return the error
2220 0BC9
2221 0BC9                       EXPORT sub_free_blk
2222 0BC9              sub_free_blk  
2223 0BC9 A0 21 00              ldy   #free_blocks
2224 0BCC B7 88                 lda   [prodos_vcr_ptr],y
2225 0BCE 1A                    inc   a
2226 0BCF F0 04                 beq   who_knows
2227 0BD1 3A                    dec   a                        ;$FFFF = major problem
2228 0BD2 3A                    dec   a
2229 0BD3 97 88                 sta   [prodos_vcr_ptr],y
2230 0BD5              who_knows  
2231 0BD5 18                    clc   
2232 0BD6 60                    rts   
2233 0BD7
2234 0BD7                       ENDP 
2235 0BD7
2236 0BD7              ;============================================================================
2237 0BD7              ;DeAlloc_block  This routine will deallocate a block in the bitmap.
2238 0BD7              ;               If the bitmap block is not in memory then it will load it.
2239 0BD7              ;               The routine will also update the free block count if needed
2240 0BD7              ;
2241 0BD7              ;Input:         X = Block number that you want to deallocate
2242 0BD7              ;               m = 0
2243 0BD7              ;               x = 0
2244 0BD7              ;               b = k
2245 0BD7              ;               prodos_vcr_ptr          (must be setup)
2246 0BD7              ;               my_vcr_ptr              (must be setup)
2247 0BD7              ;
2248 0BD7              ;Output:        carry clr = no error
2249 0BD7              ;               carry set = could not allocate
2250 0BD7              ;               A = error code if carry set
2251 0BD7              ;                       01 = User would not mount the volume
2252 0BD7              ;               all flags undefined
2253 0BD7              ;
2254 0BD7              ;Uses:          All Registers
2255 0BD7              ;               Calc_bit        (Subroutine)
2256 0BD7              ;               Get_Bit_block   (Subroutine)
2257 0BD7              ;
2258 0BD7
2259 0BD7                       EXPORT dealloc_block
2260 0BD7              dealloc_block PROC 
2261 0BD7
2262 0BD7 20 77 0B              jsr   calc_bit                 ;calculate bit(A),byte(Y),block(X)
2263 0BDA DA                    phx   
2264 0BDB 48                    pha   
2265 0BDC 5A                    phy   
2266 0BDD 20 14 0C              jsr   get_bit_block            ;load the correct block if needed
2267 0BE0 7A                    ply   
2268 0BE1 68                    pla   
2269 0BE2 FA                    plx   
2270 0BE3 B0 23                 bcs   done                     ;could not load block from disk
2271 0BE5 48                    pha                            ;save the mask please
2272 0BE6 37 BC                 and   [bitmap],y               ;is the block already deallocated?
2273 0BE8 F0 03                 beq   no_prob                  ;the block is currently allocated
2274 0BEA 68                    pla                            ;fix the stack
2275 0BEB 80 D7                 bra   bitmap_corrupt           ;return the error please
2276 0BED
2277 0BED              no_prob                                 ;
2278 0BED 68                    pla                            ;restore the mask please
2279 0BEE 17 BC                 ora   [bitmap],y               ;set the correct bit
2280 0BF0 97 BC                 sta   [bitmap],y
2281 0BF2
2282 0BF2              ;We have just deallocated some blocks so lets make sure the first bitmap block
2283 0BF2              ;that contains available space is correct for the current VCR
2284 0BF2
2285 0BF2 A0 1B 00              ldy   #avail_bitmap
2286 0BF5 8A                    txa                            ;relative block number
2287 0BF6 D7 88                 cmp   [prodos_vcr_ptr],y
2288 0BF8              ;
2289 0BF8              ; 2/3/90        Mensch, Hauser,Benaresh
2290 0BF8              ;
2291 0BF8              ; Rob says that avail_bitmap should *ALWAYS* be equal to the lowest bitmap
2292 0BF8              ; block that has space in it. So, the branch that was a BEQ should really be
2293 0BF8              ; a BCS (BGE) this way, so it will work right.
2294 0BF8              ;
2295 0BF8
2296 0BF8 B0 02                 bge   go_changed               ;the relative block num is the same
2297 0BFA
2298 0BFA              ;If we freed up a block in a previously full bitmap then lets update the VCR
2299 0BFA
2300 0BFA 97 88                 sta   [prodos_vcr_ptr],y
2301 0BFC
2302 0BFC              go_changed  
2303 0BFC 20 09 0C              jsr   add_free_blk
2304 0BFF                       EXPORT bitmap_changed
2305 0BFF              bitmap_changed  
2306 0BFF 18                    clc   
2307 0C00
2308 0C00              ;==========================================================================
2309 0C00              ;This routine will mark the current bitmap block dirty.  NOTE: This routine
2310 0C00              ;must not change the state of the carry.
2311 0C00
2312 0C00 A0 1F 00              ldy   #bitmap_dirty
2313 0C03 A9 FF FF              lda   #bitmap_mod              ;bitmap modified
2314 0C06 97 88                 sta   [prodos_vcr_ptr],y
2315 0C08 60           done     rts   
2316 0C09
2317 0C09              ;==========================================================================
2318 0C09              ;This routine will add one to the free block count for a volume.  If the
2319 0C09              ;number of free blocks is unknown then the routine will just exit.
2320 0C09
2321 0C09                       EXPORT add_free_blk
2322 0C09              add_free_blk  
2323 0C09 A0 21 00              ldy   #free_blocks
2324 0C0C B7 88                 lda   [prodos_vcr_ptr],y
2325 0C0E 1A                    inc   a                        ;$FFFF = free block count unknown
2326 0C0F F0 02                 beq   end_free                 ;free block count is not known
2327 0C11 97 88                 sta   [prodos_vcr_ptr],y
2328 0C13              end_free  
2329 0C13 60                    rts   
2330 0C14
2331 0C14                       ENDP 
2332 0C14
2333 0C14
2334 0C14              ;==========================================================================
2335 0C14              ;get_bit_block: This routine will load in the correct bitmap block from
2336 0C14              ;               disk.  If the correct block is already loaded then the
2337 0C14              ;               routine will just exit.
2338 0C14              ;
2339 0C14              ;Input:         A = undefined
2340 0C14              ;               X = relative block number to load
2341 0C14              ;               Y = undefined
2342 0C14              ;               P = nvmxdizc
2343 0C14              ;                   ..000...
2344 0C14              ;               b = k
2345 0C14              ;
2346 0C14              ;               prodos_vcr_ptr          (must be setup correctly)
2347 0C14              ;
2348 0C14              ;Output:        A = error code if carry set
2349 0C14              ;               X = undefined
2350 0C14              ;               Y = undefined
2351 0C14              ;               P = nvmxdizc
2352 0C14              ;                   ..000..1 = error
2353 0C14              ;                          0 = no error
2354 0C14              ;               b = k
2355 0C14              ;
2356 0C14              ;               bitmap                  (points to bitmap buffer)
2357 0C14              ;               drvr_buf_ptr            (same as bitmap)
2358 0C14              ;
2359 0C14              ;Uses:          All registers
2360 0C14              ;               device_call
2361 0C14              ;               drvr_call_num
2362 0C14              ;
2363 0C14
2364 0C14                       longa on
2365 0C14                       longi on
2366 0C14
2367 0C14                       EXPORT get_bit_block
2368 0C14              get_bit_block PROC 
2369 0C14
2370 0C14 DA                    phx                            ;save the block number
2371 0C15
2372 0C15 20 1A 16              jsr   setup_bitmap_ptr
2373 0C18
2374 0C18 86 04                 stx   drvr_buf_ptr
2375 0C1A 86 BC                 stx   bitmap
2376 0C1C 84 06                 sty   drvr_buf_ptr+2
2377 0C1E 84 BE                 sty   bitmap+2
2378 0C20
2379 0C20 68                    pla                            ;retore relative block number
2380 0C21 85 AC                 sta   math_temp
2381 0C23 A0 1D 00              ldy   #curr_bitmap
2382 0C26 D7 88                 cmp   [prodos_vcr_ptr],y
2383 0C28 F0 22                 beq   good_exit
2384 0C2A
2385 0C2A 48                    pha   
2386 0C2B
2387 0C2B              ;force dirty bitmap block back to disk if needed.
2388 0C2B
2389 0C2B 20 02 18              jsr   force_bitmap             ;force the bitmap to disk
2390 0C2E 90 02                 bcc   flushed
2391 0C30 FA                    plx   
2392 0C31 60                    rts   
2393 0C32
2394 0C32              flushed   
2395 0C32
2396 0C32              ;If we get here we have to calculate the right block to read into memory
2397 0C32
2398 0C32 68                    pla   
2399 0C33 18                    clc   
2400 0C34 A0 13 00              ldy   #vol_bitmap_addr
2401 0C37 77 88                 adc   [prodos_vcr_ptr],y
2402 0C39 85 10                 sta   drvr_blk_num
2403 0C3B 20 95 17              jsr   read_with_cache
2404 0C3E 90 05                 bcc   read_ok
2405 0C40 20 35 0D              jsr   kill_bitmap
2406 0C43 38                    sec   
2407 0C44 60                    rts                            ;return the error
2408 0C45
2409 0C45              read_ok   
2410 0C45
2411 0C45              ;Now we need to update the current bitmap
2412 0C45
2413 0C45 A0 1D 00              ldy   #curr_bitmap
2414 0C48 A5 AC                 lda   math_temp
2415 0C4A 97 88                 sta   [prodos_vcr_ptr],y
2416 0C4C
2417 0C4C              good_exit  
2418 0C4C 18                    clc   
2419 0C4D 60                    rts   
2420 0C4E
2421 0C4E                       ENDP 
2422 0C4E
2423 0C4E              ;==========================================================================
2424 0C4E              ;calc_free_blks This routine will calculate the number of blocks that are
2425 0C4E              ;               free on a volume.
2426 0C4E              ;
2427 0C4E              ;Input:         A = undefined
2428 0C4E              ;               X = undefined
2429 0C4E              ;               Y = undefined
2430 0C4E              ;               P = nvmxdizc
2431 0C4E              ;                   ..000...
2432 0C4E              ;               b = k
2433 0C4E              ;
2434 0C4E              ;               prodos_vcr_ptr          (must be setup correctly)
2435 0C4E              ;               drvr_dev_num            (must be setup up)
2436 0C4E              ;
2437 0C4E              ;Output:        A = error code if carry set otherwise total blocks free
2438 0C4E              ;               X = undefined
2439 0C4E              ;               Y = undefined
2440 0C4E              ;               P = nvmxdizc
2441 0C4E              ;                   ..000..1 = error
2442 0C4E              ;                          0 = no error
2443 0C4E              ;               b = k
2444 0C4E              ;
2445 0C4E              ;Uses:          All registers
2446 0C4E              ;               device_call
2447 0C4E              ;               I/O buffer
2448 0C4E              ;
2449 0C4E
2450 0C4E                       longa on
2451 0C4E                       longi on
2452 0C4E
2453 0C4E                       EXPORT calc_free_blks
2454 0C4E              calc_free_blks PROC 
2455 0C4E
2456 0C4E              ;before we start going to disk lets see if we already know the number of
2457 0C4E              ;free blocks.   IF free_blocks = $FFFF then free blocks are unknown.
2458 0C4E
2459 0C4E A0 21 00              ldy   #free_blocks
2460 0C51 B7 88                 lda   [prodos_vcr_ptr],y
2461 0C53 1A                    inc   a
2462 0C54 F0 03                 beq   go_figure                ;we need to calculate it
2463 0C56 3A                    dec   a                        ;A = total blocks
2464 0C57 18                    clc   
2465 0C58 60                    rts   
2466 0C59
2467 0C59              go_figure  
2468 0C59 20 02 18              jsr   force_bitmap             ;flush the bitmap if needed
2469 0C5C
2470 0C5C              ;setup the buffer pointer to the general I/O buffer provided by GS/OS shell
2471 0C5C
2472 0C5C 9C A9 05              stz   first_free_bm            ;indicate that we do not know free cnt
2473 0C5F
2474 0C5F              ;First lets see if there is already a bitmap buffer allocated.  If so
2475 0C5F              ;lets use it as our I/O buffer.
2476 0C5F
2477 0C5F 20 1A 16              jsr   setup_bitmap_ptr
2478 0C62 86 04                 stx   drvr_buf_ptr
2479 0C64 84 06                 sty   drvr_buf_ptr+2
2480 0C66
2481 0C66              ;read 512 bytes from the disk.
2482 0C66
2483 0C66 20 8D 15              jsr   standard_req
2484 0C69
2485 0C69              ;go do a run on the bitmap calculating the number of blocks free
2486 0C69
2487 0C69 64 AC                 stz   math_temp                ;counts the free blocks
2488 0C6B
2489 0C6B A0 13 00              ldy   #vol_bitmap_addr
2490 0C6E B7 88                 lda   [prodos_vcr_ptr],y
2491 0C70 85 10                 sta   drvr_blk_num             ;starting block number of bitmap
2492 0C72
2493 0C72 A0 17 00              ldy   #num_bitmap_blks
2494 0C75 B7 88                 lda   [prodos_vcr_ptr],y
2495 0C77 8D 8F 05              sta   bitmap_blks              ;number of blocks in the bitmap
2496 0C7A
2497 0C7A A0 19 00              ldy   #end_bitmap              ;first byte that should be all zeros
2498 0C7D B7 88                 lda   [prodos_vcr_ptr],y
2499 0C7F 8D 91 05              sta   last_bitmap
2500 0C82
2501 0C82 A0 1B 00              ldy   #avail_bitmap
2502 0C85 B7 88                 lda   [prodos_vcr_ptr],y
2503 0C87 1A                    inc   a
2504 0C88 F0 12                 beq   block_loop
2505 0C8A 3A                    dec   a
2506 0C8B A8                    tay                            ;save start
2507 0C8C 18                    clc   
2508 0C8D 65 10                 adc   drvr_blk_num             ;adjust the starting block number
2509 0C8F 85 10                 sta   drvr_blk_num
2510 0C91
2511 0C91 5A                    phy   
2512 0C92 38                    sec   
2513 0C93 AD 8F 05              lda   bitmap_blks              ;number of blocks to scan
2514 0C96 E3 01                 sbc   1,s                      ;subtract start block number
2515 0C98 8D 8F 05              sta   bitmap_blks
2516 0C9B 68                    pla   
2517 0C9C
2518 0C9C              block_loop  
2519 0C9C 20 95 17              jsr   read_with_cache          ;read in a block
2520 0C9F 90 0A                 bcc   read_ok
2521 0CA1 20 35 0D              jsr   kill_bitmap
2522 0CA4 38                    sec   
2523 0CA5 60                    rts                            ;we should not get any errors
2524 0CA6
2525 0CA6 A9 5A 00     bad_bitmap lda   #damaged_bitmap
2526 0CA9 38                    sec   
2527 0CAA 60                    rts   
2528 0CAB
2529 0CAB              read_ok   
2530 0CAB
2531 0CAB              ;update the current bitmap in memory field.
2532 0CAB 38                    sec   
2533 0CAC A0 13 00              ldy   #vol_bitmap_addr
2534 0CAF A5 10                 lda   drvr_blk_num
2535 0CB1 F7 88                 sbc   [prodos_vcr_ptr],y
2536 0CB3 A0 1D 00              ldy   #curr_bitmap
2537 0CB6 97 88                 sta   [prodos_vcr_ptr],y
2538 0CB8
2539 0CB8              ;if this is the last block of the bitmap then verify ending with zeros.
2540 0CB8
2541 0CB8 CE 8F 05              dec   bitmap_blks
2542 0CBB D0 1F                 bne   not_last
2543 0CBD AC 91 05              ldy   last_bitmap              ;starting location that must be zero
2544 0CC0 F0 1A                 beq   not_last                 ;don't bother
2545 0CC2
2546 0CC2              zero_loop  
2547 0CC2 C0 FF 01              cpy   #$01FF                   ;are we near the end of the block?
2548 0CC5 B0 08                 bcs   setup_index              ;If we are this close the end
2549 0CC7 B7 04                 lda   [drvr_buf_ptr],y
2550 0CC9 D0 DB                 bne   bad_bitmap
2551 0CCB C8                    iny   
2552 0CCC C8                    iny   
2553 0CCD 80 F3                 bra   zero_loop
2554 0CCF
2555 0CCF              setup_index  
2556 0CCF AC 91 05              ldy   last_bitmap
2557 0CD2 98                    tya   
2558 0CD3 4A                    lsr   a                        ;is it an even value?
2559 0CD4 90 09                 bcc   word_loop                ;Yes, so fall into loop
2560 0CD6 C8                    iny                            ;make it even if it is not
2561 0CD7 C0 FE 01              cpy   #$01FE                   ;is it now greater then one block
2562 0CDA 90 03                 bcc   word_loop                ;no so fall into the loop
2563 0CDC
2564 0CDC              not_last  
2565 0CDC A0 FE 01              ldy   #$01FE                   ;start scanning the block
2566 0CDF
2567 0CDF              word_loop  
2568 0CDF B7 04                 lda   [drvr_buf_ptr],y
2569 0CE1 D0 0D                 bne   count_bits
2570 0CE3 88           return_loop dey   
2571 0CE4 88                    dey   
2572 0CE5 10 F8                 bpl   word_loop                ;keep scanning the block please
2573 0CE7
2574 0CE7 AD 8F 05              lda   bitmap_blks              ;see if we are done
2575 0CEA F0 3D                 beq   calc_done                ;we are done
2576 0CEC E6 10                 inc   drvr_blk_num             ;read next block please
2577 0CEE 80 AC                 bra   block_loop
2578 0CF0
2579 0CF0              ;Check to see if we already know the first bitmap block that contains
2580 0CF0              ;free blocks.  IF we do then just count the blocks free
2581 0CF0
2582 0CF0              count_bits  
2583 0CF0 8D 95 05              sta   bits                     ;save bitmap word
2584 0CF3
2585 0CF3 AD A9 05              lda   first_free_bm
2586 0CF6 D0 12                 bne   cont_count
2587 0CF8
2588 0CF8              ;We now know the first bitmap block that contains available blocks, so lets
2589 0CF8              ;save it please.
2590 0CF8
2591 0CF8 5A                    phy   
2592 0CF9 38                    sec   
2593 0CFA A0 13 00              ldy   #vol_bitmap_addr
2594 0CFD A5 10                 lda   drvr_blk_num
2595 0CFF 8D A9 05              sta   first_free_bm
2596 0D02 F7 88                 sbc   [prodos_vcr_ptr],y
2597 0D04 A0 1B 00              ldy   #avail_bitmap
2598 0D07 97 88                 sta   [prodos_vcr_ptr],y
2599 0D09 7A                    ply   
2600 0D0A
2601 0D0A              cont_count  
2602 0D0A A2 10 00              ldx   #16                      ;cycle thru word 16 times
2603 0D0D AD 95 05              lda   bits                     ;get the bit count back
2604 0D10 1A                    inc   a                        ;special case $FFFF to speed calc
2605 0D11 F0 0C                 beq   add_16
2606 0D13
2607 0D13              bit_loop  
2608 0D13 CA                    dex   
2609 0D14 30 CD                 bmi   return_loop              ;we have scanned the word
2610 0D16 4E 95 05              lsr   bits
2611 0D19 90 F8                 bcc   bit_loop
2612 0D1B E6 AC                 inc   math_temp                ;advance the count please
2613 0D1D 80 F4                 bra   bit_loop
2614 0D1F
2615 0D1F              add_16    
2616 0D1F 18                    clc   
2617 0D20 A5 AC                 lda   math_temp
2618 0D22 69 10 00              adc   #$0010                   ;$FFFF = 16 blocks free
2619 0D25 85 AC                 sta   math_temp
2620 0D27 80 BA                 bra   return_loop
2621 0D29
2622 0D29              ;When we get here we have counted all the blocks that are marked as free.
2623 0D29              ;Now we need to see if there are any blocks marked as purgable.
2624 0D29
2625 0D29              calc_done  
2626 0D29 A5 AC                 lda   math_temp                ;number of blocks free
2627 0D2B
2628 0D2B              ;Now lets update the VCR to indicate that we know the number of free blocks
2629 0D2B
2630 0D2B              save_and_exit  
2631 0D2B A0 21 00              ldy   #free_blocks
2632 0D2E 97 88                 sta   [prodos_vcr_ptr],y       ;total free count
2633 0D30
2634 0D30 20 FC 10              jsr   set_user_cache           ;restore cache ('A' and 'P' preserved)
2635 0D33 18                    clc   
2636 0D34 60                    rts   
2637 0D35
2638 0D35                       EXPORT kill_bitmap
2639 0D35              kill_bitmap  
2640 0D35 48                    pha   
2641 0D36 A9 FF FF              lda   #bitmap_unknown          ;flag bitmap as unknown
2642 0D39 A0 1D 00              ldy   #curr_bitmap
2643 0D3C 97 88                 sta   [prodos_vcr_ptr],y
2644 0D3E 68                    pla   
2645 0D3F 60                    rts   
2646 0D40                       ENDP 
2647 0D40
2648 0D40
2649 0D40              ;==========================================================================
2650 0D40              ;find_free_blks This routine will scan the bitmap looking for a sequence
2651 0D40              ;               of blocks that are marked as free.  The routine will always
2652 0D40              ;               try to allocate the blocks in one large group.  If a group
2653 0D40              ;               cannot be found to satisfy the request count then this
2654 0D40              ;               routine will allocate the first available block.
2655 0D40              ;               At least one block MUST be free for allocation!!!!!!!!!!
2656 0D40              ;
2657 0D40              ;Input:         A = number of blocks to allocate. ( 'n' blocks)
2658 0D40              ;               X = starting block number for search. (might be minus 7 blks)
2659 0D40              ;               prodos_vcr_ptr          (must be setup)
2660 0D40              ;                       ^avail_bitmap   (must be valid)
2661 0D40              ;
2662 0D40              ;output:        A = error or number of blocks allocated. (1 or 'n')
2663 0D40              ;               X = starting block number of allocated blocks
2664 0D40              ;               P = nvmxdizc
2665 0D40              ;                   ..000..1 = no blocks allocated (error)
2666 0D40              ;                          0 = allocated
2667 0D40              ;
2668 0D40              ;uses:          calc_bits
2669 0D40              ;               math_temp
2670 0D40              ;
2671 0D40
2672 0D40                       longa on
2673 0D40                       longi on
2674 0D40
2675 0D40                       EXPORT find_free_blks
2676 0D40              find_free_blks PROC 
2677 0D40
2678 0D40 8D 97 05              sta   alloc_count              ;number of blocks to allocate
2679 0D43 8E 99 05              stx   alloc_start              ;starting block number for search
2680 0D46 8E 93 05              stx   first_free
2681 0D49
2682 0D49 20 77 0B              jsr   calc_bit                 ;absolute blk to relative blk.
2683 0D4C              ;
2684 0D4C              ; calc_bit results:
2685 0D4C              ;
2686 0D4C              ;A = bit mask $80 $40 $20 $10 $08 $04 $02 $01
2687 0D4C              ;Y = byte offset in the bitmap buffer
2688 0D4C              ;X = relative block number that contains the block number passed as input
2689 0D4C              ;
2690 0D4C 8C 9B 05              sty   byte_offset              ;starting byte in block
2691 0D4F EB                    xba   
2692 0D50              align_loop                              ; ;set blk num to byte boundary
2693 0D50 0A                    asl   a                        ;check bit position of user block num
2694 0D51 B0 05                 bcs   chk_avail                ;ok here
2695 0D53 CE 93 05              dec   first_free
2696 0D56 80 F8                 bra   align_loop               ;check next bit
2697 0D58
2698 0D58              chk_avail  
2699 0D58 AD 9B 05              lda   byte_offset              ;are we word aligned?
2700 0D5B 4A                    lsr   a
2701 0D5C 90 0D                 bcc   aligned                  ;yes we are OK
2702 0D5E
2703 0D5E CE 9B 05              dec   byte_offset              ;now set starting block to word boundary
2704 0D61 38                    sec   
2705 0D62 AD 93 05              lda   first_free
2706 0D65 E9 08 00              sbc   #$0008
2707 0D68 8D 93 05              sta   first_free               ;everything should be word aligned now.
2708 0D6B
2709 0D6B              aligned   
2710 0D6B 8A                    txa   
2711 0D6C A0 1B 00              ldy   #avail_bitmap            ;see if start is >= first free
2712 0D6F D7 88                 cmp   [prodos_vcr_ptr],y
2713 0D71 B0 0F                 bcs   start_ok                 ;start is >= first free
2714 0D73 B7 88                 lda   [prodos_vcr_ptr],y
2715 0D75 AA                    tax   
2716 0D76 6A                    ror   a
2717 0D77 6A                    ror   a
2718 0D78 6A                    ror   a
2719 0D79 6A                    ror   a
2720 0D7A 6A                    ror   a                        ;calc starting block number
2721 0D7B 8D 93 05              sta   first_free               ;ex. rel blk #1 = blk #4096 or $1000
2722 0D7E 8A                    txa   
2723 0D7F 9C 9B 05              stz   byte_offset
2724 0D82
2725 0D82              start_ok  
2726 0D82 9C DD 04              stz   last_blk                 ;starting block for caller
2727 0D85 64 AC                 stz   math_temp                ;reset the free block counter
2728 0D87
2729 0D87 AA                    tax                            ;now load in the bitmap block
2730 0D88              next_blk  
2731 0D88 A5 AC                 lda   math_temp
2732 0D8A 48                    pha                            ;save temp count
2733 0D8B 20 14 0C              jsr   get_bit_block
2734 0D8E 90 02                 bcc   got_block
2735 0D90 7A                    ply                            ;fix the stack
2736 0D91 60                    rts                            ;return error please
2737 0D92
2738 0D92              got_block  
2739 0D92 68                    pla                            ;reset temp count
2740 0D93 85 AC                 sta   math_temp
2741 0D95 9C F9 04              stz   some_free                ;indicates if ANY blocks are free!
2742 0D98
2743 0D98 AC 9B 05              ldy   byte_offset              ;start looking here for 1st free block
2744 0D9B C0 FF 01              cpy   #$01FF                   ;are we near then end?
2745 0D9E 90 03                 bcc   next_word
2746 0DA0 A0 FE 01              ldy   #$01FE
2747 0DA3
2748 0DA3              next_word  
2749 0DA3 A2 10 00              ldx   #16                      ;scan all 16 bits
2750 0DA6 B7 BC                 lda   [bitmap],y               ;get a bitmap word (16 blocks)
2751 0DA8 D0 07                 bne   check_16                 ;sorry no bits here.
2752 0DAA
2753 0DAA 64 AC                 stz   math_temp                ;reset the counter please.
2754 0DAC 9C DD 04              stz   last_blk
2755 0DAF 80 24                 bra   no_change
2756 0DB1
2757 0DB1              check_16  
2758 0DB1 EB                    xba                            ;put bits in the right order
2759 0DB2
2760 0DB2 8D 95 05              sta   bits
2761 0DB5 8D F9 04              sta   some_free                ;there are free blocks in this dir.
2762 0DB8 1A                    inc   a                        ;check 16 please
2763 0DB9 D0 26                 bne   scan_loop
2764 0DBB              ;
2765 0DBB              ;special case of all sixteen blocks allocated
2766 0DBB              ;
2767 0DBB 18                    clc   
2768 0DBC A5 AC                 lda   math_temp
2769 0DBE 69 10 00              adc   #16                      ;easy case
2770 0DC1 85 AC                 sta   math_temp
2771 0DC3 AD DD 04              lda   last_blk                 ;do we have the starting blk yet?
2772 0DC6 D0 06                 bne   chk_req_cnt              ;we already have start block
2773 0DC8 AD 93 05              lda   first_free
2774 0DCB 8D DD 04              sta   last_blk
2775 0DCE
2776 0DCE              chk_req_cnt  
2777 0DCE A5 AC                 lda   math_temp                ;see if we are done
2778 0DD0 CD 97 05              cmp   alloc_count
2779 0DD3 B0 66                 bcs   req_filled               ;request filled. We are done!!!
2780 0DD5
2781 0DD5              no_change  
2782 0DD5 18                    clc   
2783 0DD6 AD 93 05              lda   first_free
2784 0DD9 69 10 00              adc   #16                      ;bump block number
2785 0DDC 8D 93 05              sta   first_free
2786 0DDF 80 2D                 bra   bump_index               ;go get the next word
2787 0DE1
2788 0DE1              scan_loop  
2789 0DE1 A5 AC                 lda   math_temp                ;see if we are done
2790 0DE3 CD 97 05              cmp   alloc_count
2791 0DE6 B0 53                 bcs   req_filled               ;request filled. We are done!!!
2792 0DE8
2793 0DE8 0E 95 05              asl   bits                     ;see if this block is available
2794 0DEB 90 0F                 bcc   reset_count              ;a used block
2795 0DED E6 AC                 inc   math_temp                ;add one to block count
2796 0DEF AD DD 04              lda   last_blk
2797 0DF2 D0 0D                 bne   next_bit
2798 0DF4 AD 93 05              lda   first_free
2799 0DF7 8D DD 04              sta   last_blk                 ;update start block
2800 0DFA 80 05                 bra   next_bit
2801 0DFC
2802 0DFC              reset_count  
2803 0DFC 64 AC                 stz   math_temp                ;reset the counter
2804 0DFE 9C DD 04              stz   last_blk                 ;reset start block
2805 0E01              next_bit                                ; 
2806 0E01 EE 93 05              inc   first_free               ;bump the block number
2807 0E04 CA                    dex   
2808 0E05 D0 DA                 bne   scan_loop
2809 0E07
2810 0E07 A5 AC                 lda   math_temp                ;see if we are done
2811 0E09 CD 97 05              cmp   alloc_count
2812 0E0C B0 2D                 bcs   req_filled               ;request filled. We are done!!!
2813 0E0E
2814 0E0E              bump_index  
2815 0E0E C8                    iny   
2816 0E0F C8                    iny   
2817 0E10 C0 FF 01              cpy   #$01FF                   ;are we done?
2818 0E13 90 8E                 bcc   next_word                ;not yet
2819 0E15
2820 0E15 A0 1D 00              ldy   #curr_bitmap             ;current loaded bitmap block
2821 0E18 B7 88                 lda   [prodos_vcr_ptr],y
2822 0E1A 1A                    inc   a                        ;convert 0 to 'n' to 1 to 'n'+1
2823 0E1B A0 17 00              ldy   #num_bitmap_blks
2824 0E1E D7 88                 cmp   [prodos_vcr_ptr],y
2825 0E20 B0 0F                 bcs   find_one                 ;no more bitmap blocks to search!
2826 0E22
2827 0E22 20 57 0E              jsr   bump_1st_free            ;bump to next block if needed.
2828 0E25
2829 0E25 9C 9B 05              stz   byte_offset              ;reset byte offset
2830 0E28 AE 93 05              ldx   first_free
2831 0E2B 20 90 0B              jsr   abs_to_rel               ;calc relative block number
2832 0E2E 4C 88 0D              jmp   next_blk                 ;load in the next block
2833 0E31
2834 0E31              find_one                                ; ;allocate one block only
2835 0E31 A9 01 00              lda   #$0001
2836 0E34 A2 00 00              ldx   #$0000                   ;start at block 0
2837 0E37 20 40 0D              jsr   find_free_blks
2838 0E3A 60                    rts   
2839 0E3B
2840 0E3B              ;now we need to update the bitmap blocks!
2841 0E3B
2842 0E3B              req_filled  
2843 0E3B AE DD 04              ldx   last_blk
2844 0E3E AC 97 05              ldy   alloc_count
2845 0E41 88                    dey                            ;convert 1 to 'n' -> 0 to 'n-1'
2846 0E42              alloc_loop                              ; 
2847 0E42 5A                    phy                            ;number of blocks wanted
2848 0E43 DA                    phx                            ;block number to allocate
2849 0E44 20 A4 0B              jsr   alloc_block              ;mark the block as used!
2850 0E47 FA                    plx   
2851 0E48 7A                    ply   
2852 0E49 B0 0B                 bcs   bad_news
2853 0E4B E8                    inx                            ;allocate the next block
2854 0E4C 88                    dey   
2855 0E4D 10 F3                 bpl   alloc_loop
2856 0E4F AD 97 05              lda   alloc_count              ;user request satisfied
2857 0E52 AE DD 04              ldx   last_blk                 ;starting block for allocation
2858 0E55 18                    clc                            ;no error
2859 0E56
2860 0E56              bad_news  
2861 0E56 60                    rts   
2862 0E57
2863 0E57              bump_1st_free  
2864 0E57 AD F9 04              lda   some_free                ;is this block empty?
2865 0E5A D0 FA                 bne   bad_news                 ;no...
2866 0E5C
2867 0E5C A0 1B 00              ldy   #avail_bitmap            ;bump avail to next block if needed
2868 0E5F B7 88                 lda   [prodos_vcr_ptr],y
2869 0E61 A0 1D 00              ldy   #curr_bitmap
2870 0E64 D7 88                 cmp   [prodos_vcr_ptr],y
2871 0E66 D0 EE                 bne   bad_news
2872 0E68
2873 0E68 A0 1B 00              ldy   #avail_bitmap
2874 0E6B B7 88                 lda   [prodos_vcr_ptr],y
2875 0E6D 1A                    inc   a
2876 0E6E 97 88                 sta   [prodos_vcr_ptr],y
2877 0E70 60                    rts   
2878 0E71
2879 0E71                       ENDP 
2880 0E71
2881 0E71              ;======================================================================
2882 0E71              ;free_vcr:      This routine will free all memory associated with a
2883 0E71              ;               volume control record.
2884 0E71              ;
2885 0E71              ;Input:         A = undefined
2886 0E71              ;               X = undefined
2887 0E71              ;               Y = undefined
2888 0E71              ;               P = nvmxdizc
2889 0E71              ;                   ..000...
2890 0E71              ;               b = k
2891 0E71              ;
2892 0E71              ;               my_vcr_ptr              (Points to main VCR)
2893 0E71              ;
2894 0E71              ;Output:        A = undefined
2895 0E71              ;               X = undefined
2896 0E71              ;               Y = undefined
2897 0E71              ;               P = nvmxdizc
2898 0E71
2899 0E71              ;                   ..000...
2900 0E71              ;               b = k
2901 0E71              ;
2902 0E71              ;
2903 0E71              ;Uses:          All registers
2904 0E71              ;               release_seg             (system routine to release a vcr)
2905 0E71              ; 
2906 0E71              ;======================================================================
2907 0E71                       longa on
2908 0E71                       longi on
2909 0E71
2910 0E71                       EXPORT free_vcr
2911 0E71              free_vcr PROC 
2912 0E71
2913 0E71 A7 84                 lda   [my_vcr_ptr]             ;get the volume ID
2914 0E73 22 28 FC 01           jsl   release_vcr              ;and call the systems nuke vcr routine
2915 0E77 60                    rts   
2916 0E78                       ENDP 
2917 0E78
2918 0E78
2919 0E78              ;======================================================================
2920 0E78              ;Remove_fcr:    This routine will remove a FCR
2921 0E78              ;
2922 0E78              ;Input:         A = undefined
2923 0E78              ;               X = undefined
2924 0E78              ;               Y = undefined
2925 0E78              ;               P = nvmxdizc
2926 0E78              ;                   ..000...
2927 0E78              ;               b = k
2928 0E78              ;
2929 0E78              ;               my_fcr_ptr              (must be setup)
2930 0E78              ;
2931 0E78              ;Output:        A = undefined
2932 0E78              ;               X = undefined
2933 0E78              ;               Y = undefined
2934 0E78              ;               P = nvmxdizc
2935 0E78              ;                   ..000...
2936 0E78              ;               b = k
2937 0E78              ;
2938 0E78              ;
2939 0E78              ;Uses:          All registers
2940 0E78              ;
2941 0E78              ;======================================================================
2942 0E78                       longa on
2943 0E78                       longi on
2944 0E78
2945 0E78                       EXPORT remove_fcr
2946 0E78              remove_fcr PROC 
2947 0E78
2948 0E78 A0 25 00              ldy   #dirty_file_cnt          ;check if bitmap needs to be flushed
2949 0E7B B7 88                 lda   [prodos_vcr_ptr],y
2950 0E7D 3A                    dec   a
2951 0E7E D0 05                 bne   @did_flush               ;we do not need to flush the bitmap
2952 0E80 20 02 18              jsr   force_bitmap             ;force a dirty block to disk
2953 0E83 B0 11                 bcs   @error                   ;we have to be able to flush
2954 0E85              @did_flush  
2955 0E85 A0 08 00              ldy   #vcr_open_cnt            ;subtract one from the open count
2956 0E88 B7 84                 lda   [my_vcr_ptr],y
2957 0E8A 3A                    dec   a
2958 0E8B 30 0A                 bmi   die_die_die              ;the system is very sick
2959 0E8D 97 84                 sta   [my_vcr_ptr],y           ;Update the open count in the VCR
2960 0E8F
2961 0E8F A7 8C                 lda   [my_fcr_ptr]             ;reference number to remove
2962 0E91 22 30 FC 01           jsl   release_fcr              ;nuke the puppy
2963 0E95 18                    clc                            ;we are very happy now
2964 0E96              @error    
2965 0E96 60                    rts   
2966 0E97
2967 0E97              die_die_die  
2968 0E97 A9 4B 53              lda   #'SK'
2969 0E9A 5C 44 FC 01           jml   sys_death
2970 0E9E
2971 0E9E                       ENDP 
2972 0E9E
2973 0E9E              ;======================================================================
2974 0E9E              ;setup_params   This routine is called at the beginning of each system
2975 0E9E              ;               call.  It will setup parameters and verify certain fields
2976 0E9E              ;               of the os call.  If a VCR is used and the media is swapped
2977 0E9E              ;               out of the system then the system mount routine will be called
2978 0E9E              ;
2979 0E9E              ;Input:         A = undefined
2980 0E9E              ;               X = two times the call number
2981 0E9E              ;               Y = two times the class
2982 0E9E              ;               P = nvmxdizc
2983 0E9E              ;                   ..000...
2984 0E9E              ;               b = k
2985 0E9E              ;
2986 0E9E              ;
2987 0E9E              ;Output:        A = class of call/2     (MUST be last instruction before RTS!!)
2988 0E9E              ;               X = undefined
2989 0E9E              ;               Y = undefined
2990 0E9E              ;               P = nvmxdizc
2991 0E9E              ;                   ..000...
2992 0E9E              ;               b = k
2993 0E9E              ;
2994 0E9E              ;               pcount                  (contains pcount for call. 0=class0)
2995 0E9E              ;               my_pblk_ptr             (points past pcount to first param)
2996 0E9E              ;               my_vcr_ptr              (if available)
2997 0E9E              ;                       prodos_vcr_ptr
2998 0E9E              ;               my_fcr_ptr              (if available)
2999 0E9E              ;                       pro_fcr_ptr
3000 0E9E              ;
3001 0E9E              ;Uses:          All registers
3002 0E9E              ;               math_temp
3003 0E9E              ;               pcount
3004 0E9E              ;
3005 0E9E              ;What the table looks like and what fields we verify.
3006 0E9E              ;
3007 0E9E              ;               1) Max PCount for the call
3008 0E9E              ;               2) Max Class for the call
3009 0E9E              ;               3) Pathnames used by call
3010 0E9E              ;               4) volume control record used
3011 0E9E              ;               5) file control record used.
3012 0E9E              ;               6) io buffer used.
3013 0E9E              ;               7) flush file to disk
3014 0E9E              ;               8) damaged disk protect
3015 0E9E              ;
3016 0E9E              ;              |8|7|6|5|4|3|  2  |    1    |
3017 0E9E              ;           ___|_|_|_|_|_|_|_____|_________|
3018 0E9E              ;          | | | | | | | | | | | | | | | | |
3019 0E9E              ;          |_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|
3020 0E9E              ;          |               |               |
3021 0E9E              ;         1 6             0 8             0 0
3022 0E9E              ;
3023 0E9E                       longa on
3024 0E9E                       longi on
3025 0E9E
3026 0E9E                       EXPORT setup_params
3027 0E9E              setup_params PROC 
3028 0E9E
3029 0E9E              ;First we load the flags from the start table and save them for later
3030 0E9E              ;use.
3031 0E9E
3032 0E9E AD EB 02              lda   gbuf_addr                ;setup the general buffer pointer
3033 0EA1 85 94                 sta   gbuf_ptr
3034 0EA3 AD ED 02              lda   gbuf_addr+2
3035 0EA6 85 96                 sta   gbuf_ptr+2
3036 0EA8
3037 0EA8 64 18                 stz   drvr_vol_id              ;zero the volume ID(for Mike).  Allow each call to set it up
3038 0EAA 9C DF 04              stz   search_flag              ;indicate normal find file
3039 0EAD 64 88                 stz   prodos_vcr_ptr
3040 0EAF 64 8A                 stz   prodos_vcr_ptr+2
3041 0EB1 64 84                 stz   my_vcr_ptr
3042 0EB3 64 86                 stz   my_vcr_ptr+2
3043 0EB5 64 90                 stz   pro_fcr_ptr
3044 0EB7 64 92                 stz   pro_fcr_ptr+2
3045 0EB9
3046 0EB9 9C 0F 03              stz   case_bits                ;indicate that the case is all upper.
3047 0EBC
3048 0EBC 9C 1B 03              stz   slug_block               ;indicate no slug_ripple
3049 0EBF 9C 1F 03              stz   close_flag               ;indicate that 'flush_file' will not
3050 0EC2              ;                                       ;call slug_ripple
3051 0EC2 9C 3E 08              stz   expand_record.expand_file
3052 0EC5 9C 3C 08              stz   expand_record.expand_flag
3053 0EC8 9C DD 05              stz   chk_dirty_flag           ;do not check the VCR to see if the file is dirty
3054 0ECB 9C D9 05              stz   dirty_flags
3055 0ECE 9C DF 05              stz   dirty_cnt_changed
3056 0ED1 9C 07 03              stz   write_occurred           ;If non-zero a write occurred to the disk.
3057 0ED4
3058 0ED4 9C E5 05              stz   cp_device_flag           ;indicate normal ChangePath     1/22/91 CAE
3059 0ED7 9C E7 05              stz   cp_flags                 ;assume not a duplicate volume  5-Dec-91 MSD
3060 0EDA 9C 0D 06              stz   error_priority           ;error priority is 0            3/05/91 CAE
3061 0EDD
3062 0EDD BD 9F 02              lda   start_tbl-2,x            ;get the flags for the call
3063 0EE0 8D 3A 06              sta   flags
3064 0EE3 29 1F 00              and   #$001F
3065 0EE6 8D 38 06              sta   max_pcount
3066 0EE9
3067 0EE9              ;Go ahead and setup the default parameters.
3068 0EE9
3069 0EE9 9C B7 05              stz   pcount
3070 0EEC
3071 0EEC              ;Now verify the max class of the call.
3072 0EEC              ;
3073 0EEC              ;To do this we divide class by two and compare to the calls max class
3074 0EEC
3075 0EEC 98                    tya   
3076 0EED 4A                    lsr   a
3077 0EEE 8D 36 06              sta   class
3078 0EF1 F0 34                 beq   class0                   ;this is a OLD style call
3079 0EF3
3080 0EF3 AD 3A 06              lda   flags
3081 0EF6 29 E0 00              and   #$00E0                   ;clear other flags please
3082 0EF9 0A                    asl   a
3083 0EFA 0A                    asl   a
3084 0EFB 0A                    asl   a
3085 0EFC EB                    xba   
3086 0EFD CD 36 06              cmp   class
3087 0F00 B0 05                 bcs   good_class
3088 0F02 A9 62 00              lda   #invalid_class
3089 0F05 80 0A                 bra   error_out
3090 0F07
3091 0F07              good_class  
3092 0F07
3093 0F07              ;Now we need to verify the max pcount for the new class calls
3094 0F07
3095 0F07 A7 32                 lda   [param_blk_ptr]
3096 0F09 CD 38 06              cmp   max_pcount
3097 0F0C 90 06                 bcc   good_pcount
3098 0F0E
3099 0F0E A9 04 00              lda   #invalid_pcount
3100 0F11
3101 0F11              ;Carry has to be set before calling error_out!!
3102 0F11
3103 0F11              error_out  
3104 0F11 4C 82 00              jmp   main_exit
3105 0F14
3106 0F14              good_pcount  
3107 0F14
3108 0F14              ;We get here if the pcount is good.  We also get here with a 'BCC'
3109 0F14              ;so if this changes we must add a CLC to the following 'ADD'
3110 0F14
3111 0F14 8D B7 05              sta   pcount
3112 0F17
3113 0F17 A5 32                 lda   param_blk_ptr            ;CARRY CLEAR on entry!!!!
3114 0F19 69 02 00              adc   #$0002
3115 0F1C 85 80                 sta   my_pblk_ptr
3116 0F1E A5 34                 lda   param_blk_ptr+2
3117 0F20 69 00 00              adc   #$0000
3118 0F23 85 82                 sta   my_pblk_ptr+2
3119 0F25 80 08                 bra   cont01
3120 0F27
3121 0F27              class0    
3122 0F27 A5 32                 lda   param_blk_ptr
3123 0F29 85 80                 sta   my_pblk_ptr
3124 0F2B A5 34                 lda   param_blk_ptr+2
3125 0F2D 85 82                 sta   my_pblk_ptr+2
3126 0F2F
3127 0F2F              cont01    
3128 0F2F
3129 0F2F A2 01 00              ldx   #pro_id                  ;setup FST number for our FST.
3130 0F32 86 16                 stx   drvr_fst_num
3131 0F34
3132 0F34 22 68 FC 01           jsl   lock_mem                 ;make sure data blocks do not move
3133 0F38
3134 0F38
3135 0F38 A5 36                 lda   dev_num                  ;move the device number to driver
3136 0F3A 85 00                 sta   drvr_dev_num             ;direct page area
3137 0F3C
3138 0F3C              ;when we get here we know that both class and pcount are valid.
3139 0F3C              ;now we need to check if a VCR or FCR is used by the call.
3140 0F3C
3141 0F3C AD 3A 06              lda   flags
3142 0F3F 29 00 02              and   #vcr_used
3143 0F42
3144 0F42 F0 4F                 beq   check_fcr                ;no VCR is used by the call
3145 0F44
3146 0F44              ;setup my pointer to the VCR and deref VP to my local data.
3147 0F44
3148 0F44 A6 3E                 ldx   vcr_ptr
3149 0F46 A4 40                 ldy   vcr_ptr+2
3150 0F48 22 38 FC 01           jsl   deref
3151 0F4C 86 84                 stx   my_vcr_ptr
3152 0F4E 84 86                 sty   my_vcr_ptr+2
3153 0F50 20 95 15              jsr   setup_my_vcr
3154 0F53 86 88                 stx   prodos_vcr_ptr
3155 0F55 84 8A                 sty   prodos_vcr_ptr+2
3156 0F57
3157 0F57 AD 3A 06              lda   flags                    ;do we need to check damage?
3158 0F5A 29 00 20              and   #damage
3159 0F5D F0 0F                 beq   vol_ok                   ;this must be a read only call.
3160 0F5F
3161 0F5F A0 23 00              ldy   #vol_damaged             ;is this volume damaged??
3162 0F62 B7 88                 lda   [prodos_vcr_ptr],y
3163 0F64 1A                    inc   a                        ;Have I already showed the error message
3164 0F65 D0 07                 bne   vol_ok                   ;the disk is not damaged
3165 0F67 38                    sec   
3166 0F68 A9 4E 00              lda   #invalid_access          ;get the error code please
3167 0F6B 4C 82 00              jmp   main_exit
3168 0F6E
3169 0F6E              vol_ok                                  ; 
3170 0F6E A0 06 00              ldy   #vcr_status              ;see if the volume is swapped out
3171 0F71 B7 84                 lda   [my_vcr_ptr],y
3172 0F73 29 00 40              and   #vcr_swapped
3173 0F76 F0 1B                 beq   check_fcr                ;the volume is online.
3174 0F78
3175 0F78 A5 30                 lda   call_number              ;see if this is a close call.
3176 0F7A 29 FF DF              and   #$DFFF                   ;get rid of the class please
3177 0F7D C9 14 00              cmp   #$0014                   ;Compare class zero close call number
3178 0F80 D0 0E                 bne   @do_mount                ;we must do a mount message
3179 0F82
3180 0F82 A0 1F 00              ldy   #bitmap_dirty            ;See if the Bitmap is dirty
3181 0F85 B7 88                 lda   [prodos_vcr_ptr],y
3182 0F87 D0 07                 bne   @do_mount                ;we need the disk bad!!!
3183 0F89
3184 0F89 A0 25 00              ldy   #dirty_file_cnt          ;see if there open files on disk that are dirty?
3185 0F8C B7 88                 lda   [prodos_vcr_ptr],y
3186 0F8E F0 03                 beq   check_fcr                ;no open dirty files so skip mount.
3187 0F90              @do_mount  
3188 0F90 20 2E 14              jsr   mount_volume             ;force the user to put our disk online
3189 0F93              check_fcr   
3190 0F93 AD 3A 06              lda   flags
3191 0F96 29 00 04              and   #fcr_used
3192 0F99 F0 3B                 beq   check_path               ;no FCR is used by the call
3193 0F9B
3194 0F9B              ;setup my pointer to the FCR and deref VP to my local data.
3195 0F9B
3196 0F9B A6 3A                 ldx   fcr_ptr
3197 0F9D A4 3C                 ldy   fcr_ptr+2
3198 0F9F 22 38 FC 01           jsl   deref
3199 0FA3 86 8C                 stx   my_fcr_ptr
3200 0FA5 84 8E                 sty   my_fcr_ptr+2
3201 0FA7
3202 0FA7 20 A3 15              jsr   setup_my_fcr             ;build pointer to local data
3203 0FAA 86 90                 stx   pro_fcr_ptr
3204 0FAC 84 92                 sty   pro_fcr_ptr+2
3205 0FAE
3206 0FAE AD 3A 06              lda   flags                    ;do we need to flush the file?
3207 0FB1 29 00 10              and   #flush_1st
3208 0FB4 F0 20                 beq   check_path               ;no flush needed
3209 0FB6
3210 0FB6 A0 1F 00              ldy   #fcr_status              ;see if the file is dirty
3211 0FB9 B7 90                 lda   [pro_fcr_ptr],y
3212 0FBB 29 00 80              and   #file_dirty
3213 0FBE F0 16                 beq   check_path               ;file is clean!
3214 0FC0
3215 0FC0 20 B1 15              jsr   setup_io_ptrs
3216 0FC3 20 64 18              jsr   flush_file               ;force dirty blocks to disk
3217 0FC6 AA                    tax   
3218 0FC7 AD 3A 06              lda   flags                    ;clear IO needed bit
3219 0FCA 29 FF F7              and   #clr_io_used
3220 0FCD 8D 3A 06              sta   flags
3221 0FD0 8A                    txa   
3222 0FD1 90 03                 bcc   check_path
3223 0FD3 4C 82 00              jmp   main_exit
3224 0FD6
3225 0FD6              ;Moved the check_path code into a seperate routine and we now
3226 0FD6              ;only check for bad spans after we have located the target vol
3227 0FD6              ;and determined that it is indeed a ProDOS volume.
3228 0FD6              ;                                       10/10/91 JEV
3229 0FD6              check_path  
3230 0FD6              ;	lda	flags
3231 0FD6              ;	and	#path_used
3232 0FD6              ;	beq	check_io_buf	;no pathname is used
3233 0FD6
3234 0FD6              ;See if there are any pathnames available
3235 0FD6
3236 0FD6              ;	lda	path_flag
3237 0FD6              ;	and	#path1_mask
3238 0FD6              ;	beq	check_path2
3239 0FD6
3240 0FD6              ;	lda	span1
3241 0FD6              ;	beq	bad_span	;added 11/12/90 CAE
3242 0FD6              ;	cmp	#$0010
3243 0FD6              ;	bcc	check_path2
3244 0FD6
3245 0FD6              ;bad_span	sec		;added 11/12/90 CAE
3246 0FD6              ;backup		lda	#bad_path_syntax
3247 0FD6              ;	brl	error_out
3248 0FD6
3249 0FD6              ;check_path2			;
3250 0FD6
3251 0FD6              ;We don't check span2 here if we are doing a change path call
3252 0FD6              ;we need to do some preprocessing first so that error priority
3253 0FD6              ;gets setup properly for the change path call.. added 8/21/91 JEV
3254 0FD6
3255 0FD6              ;	lda	call_number	;see if this is a changepath call.
3256 0FD6              ;	and	#$DFFF	;get rid of the class please
3257 0FD6              ;	cmp	#$0004	;Compare with changepath call number
3258 0FD6              ;	beq	check_io_buf	;just continue
3259 0FD6
3260 0FD6              ;	lda	path_flag
3261 0FD6              ;	and	#path2_mask
3262 0FD6              ;	beq	check_io_buf
3263 0FD6
3264 0FD6              ;	lda	span2
3265 0FD6              ;	beq	bad_span	;added 11/12/90 CAE
3266 0FD6              ;	cmp	#$0010
3267 0FD6              ;	bcs	backup
3268 0FD6
3269 0FD6              check_io_buf                            ;
3270 0FD6 AD 3A 06              lda   flags
3271 0FD9 29 00 08              and   #io_used
3272 0FDC F0 03                 beq   end_buf_setup
3273 0FDE
3274 0FDE              ;now we need to setup real pointers to the I/O buffer.  There is only
3275 0FDE              ;one I/O buffer for a file.  However, the I/O buffer varies in it's size
3276 0FDE              ;and structure.
3277 0FDE
3278 0FDE 20 B1 15              jsr   setup_io_ptrs
3279 0FE1
3280 0FE1              end_buf_setup  
3281 0FE1 AD 3A 06              lda   flags                    ;see if we need to check for file dirty
3282 0FE4 29 00 40              and   #do_dirty
3283 0FE7 F0 0E                 beq   @exit
3284 0FE9 8D DD 05              sta   chk_dirty_flag           ; 00 = do not check
3285 0FEC A0 1F 00              ldy   #fcr_status              ;get the status out of the File Control Record
3286 0FEF B7 90                 lda   [pro_fcr_ptr],y
3287 0FF1 29 07 80              and   #file_dirty+data_dirty+index_dirty+master_dirty
3288 0FF4 8D D9 05              sta   dirty_flags              ;save the flags
3289 0FF7              @exit     
3290 0FF7 AD 36 06              lda   class
3291 0FFA 60                    rts   
3292 0FFB
3293 0FFB                       ENDP 
3294 0FFB
3295 0FFB              ;======================================================================
3296 0FFB              ;check_spans    This routine is called when a pathname is used and we
3297 0FFB              ;               we need to verify that the spans are valid.  If they
3298 0FFB              ;               are incorrect then we bail out.
3299 0FFB              ;
3300 0FFB              ;Input:         A = undefined
3301 0FFB              ;               X = undefined
3302 0FFB              ;               Y = undefined
3303 0FFB              ;               P = nvmxdizc
3304 0FFB              ;                   ..000...
3305 0FFB              ;               b = k
3306 0FFB              ;
3307 0FFB              ;
3308 0FFB              ;Output:        A = error code
3309 0FFB              ;               X = undefined
3310 0FFB              ;               Y = undefined
3311 0FFB              ;               P = nvmxdizc
3312 0FFB              ;                   ..000..1 = error
3313 0FFB              ;                          0 = no error
3314 0FFB              ;
3315 0FFB                       EXPORT check_spans
3316 0FFB              check_spans PROC 
3317 0FFB
3318 0FFB A5 42                 lda   path_flag
3319 0FFD 29 00 40              and   #path1_mask
3320 1000 F0 10                 beq   check_path2
3321 1002
3322 1002 A5 44                 lda   span1
3323 1004 F0 05                 beq   bad_span
3324 1006 C9 10 00              cmp   #$0010
3325 1009 90 07                 bcc   check_path2
3326 100B
3327 100B 38           bad_span sec   
3328 100C A9 40 00     backup   lda   #bad_path_syntax
3329 100F 4C 82 00              jmp   main_exit
3330 1012
3331 1012              check_path2                             ;
3332 1012 A5 42                 lda   path_flag
3333 1014 29 40 00              and   #path2_mask
3334 1017 F0 09                 beq   @spans_ok
3335 1019
3336 1019 A5 46                 lda   span2
3337 101B F0 EE                 beq   bad_span
3338 101D C9 10 00              cmp   #$0010
3339 1020 B0 EA                 bcs   backup
3340 1022              @spans_ok  
3341 1022 60                    rts   
3342 1023                       ENDP 
3343 1023
3344 1023
3345 1023              ;======================================================================
3346 1023              ;process_path   This routine is called when a pathname needs to be
3347 1023              ;               processed and located on the disk.  If the pathname is
3348 1023              ;               not a prodos name then we bail out.
3349 1023              ;
3350 1023              ;Input:         A = undefined
3351 1023              ;               X = undefined
3352 1023              ;               Y = undefined
3353 1023              ;               P = nvmxdizc
3354 1023              ;                   ..000...
3355 1023              ;               b = k
3356 1023              ;
3357 1023              ;
3358 1023              ;Output:        A = error code
3359 1023              ;               X = undefined
3360 1023              ;               Y = undefined
3361 1023              ;               P = nvmxdizc
3362 1023              ;                   ..000..1 = error
3363 1023              ;                          0 = no error
3364 1023              ;               b = k
3365 1023              ;
3366 1023              ;               drvr_buf_ptr            (points to the file entry)
3367 1023              ;               entry_offset            (offset to entry within I/O buffer)
3368 1023              ;               parent_blk              (entries parent block address)
3369 1023              ;
3370 1023              ;Uses:          All registers
3371 1023              ;               math_temp
3372 1023              ;               pcount
3373 1023              ;
3374 1023                       longa on
3375 1023                       longi on
3376 1023
3377 1023                       EXPORT process_path
3378 1023              process_path PROC 
3379 1023
3380 1023 A9 02 80              lda   #in_cache                ;put directories in the cache
3381 1026 85 1A                 sta   drvr_cache
3382 1028
3383 1028 A9 00 40              lda   #path1_mask              ;and mask for path_flag
3384 102B A6 3A                 ldx   path1_ptr
3385 102D A4 3C                 ldy   path1_ptr+2
3386 102F 20 A4 14              jsr   build_path
3387 1032 90 03                 bcc   @chk_root_only
3388 1034 82 8D 00              brl   dev_or_vol               ;No path just a device # or vol. name
3389 1037
3390 1037              @chk_root_only  
3391 1037 AD DF 04              lda   search_flag              ;do we allow a pathname?
3392 103A 29 00 20              and   #root_only
3393 103D F0 05                 beq   @path_ok
3394 103F A9 40 00              lda   #bad_path_syntax
3395 1042 38                    sec   
3396 1043 60                    rts                            ;return error to caller
3397 1044
3398 1044              @path_ok  
3399 1044
3400 1044              ;If we fall thru then we know that there is a pathname to find.
3401 1044              ;We also know that there is either a volume name or device.
3402 1044
3403 1044 8E 6B 05              stx   hold_path_ptr
3404 1047 8C 6D 05              sty   hold_path_ptr+2
3405 104A
3406 104A A5 36                 lda   dev_num                  ;There is a device number
3407 104C F0 0C                 beq   cont01                   ;Find Volume Name
3408 104E 85 00                 sta   drvr_dev_num
3409 1050
3410 1050              ;next call removed 2/26/90 by Monte Benaresh
3411 1050              ;leaving the call in doesn't let the user swap a new volume…
3412 1050              ;…into a device and specify a device name in the path
3413 1050
3414 1050              ;	jsr	check_vcr_first	;see if we have a vcr for it
3415 1050              ;	bcc	find_path	;we do?
3416 1050
3417 1050              ;Look on a specific device
3418 1050
3419 1050              go_id_disk  
3420 1050 A5 00                 lda   drvr_dev_num
3421 1052 20 D9 1C              jsr   id_disk                  ;go and find out if it is our disk
3422 1055                                                      ;this also allocates a VCR if needed
3423 1055 90 0E                 bcc   find_path                ;I own the disk. 
3424 1057 4C 82 00              jmp   main_exit                ;return error to GS/OS
3425 105A
3426 105A              cont01                                  ;
3427 105A 20 DF 14              jsr   vol_to_buffer
3428 105D 20 96 1E              jsr   find_volume              ;locate the volume
3429 1060 90 03                 bcc   find_path
3430 1062 4C 82 00              jmp   main_exit
3431 1065
3432 1065 A9 00 80     find_path lda   #$8000                  ;indicate that we found the volume     3/5/91 CAE
3433 1068 8D 0D 06              sta   error_priority           ;and it's a ProDOS volume              3/5/91 CAE
3434 106B
3435 106B              ;So it's one of our volumes, now check to see if we are using paths, and
3436 106B              ;the spans are ok.                                                             10/10/91 JEV
3437 106B AD 3A 06              lda   flags
3438 106E 29 00 01              and   #path_used
3439 1071 F0 03                 beq   check_damage             ;no pathname is used
3440 1073 20 FB 0F              jsr   check_spans              ;so check them
3441 1076
3442 1076 AD 3A 06     check_damage lda   flags                ;is this a call to check the disk
3443 1079 29 00 20              and   #damage
3444 107C F0 14                 beq   vol_good
3445 107E
3446 107E 20 95 15              jsr   setup_my_vcr             ;setup the pointer first
3447 1081 86 88                 stx   prodos_vcr_ptr
3448 1083 84 8A                 sty   prodos_vcr_ptr+2
3449 1085
3450 1085 A0 23 00              ldy   #vol_damaged             ;see if the volume is damaged
3451 1088 B7 88                 lda   [prodos_vcr_ptr],y
3452 108A F0 06                 beq   vol_good
3453 108C A9 51 00              lda   #dir_error               ;write protected
3454 108F 4C 34 17              jmp   damaged_message
3455 1092
3456 1092              vol_good                                ;
3457 1092 A5 00                 lda   drvr_dev_num
3458 1094 AE 6B 05              ldx   hold_path_ptr
3459 1097 AC 6D 05              ldy   hold_path_ptr+2
3460 109A 20 7C 1F              jsr   find_file                ;try to locate the file
3461 109D 90 15                 bcc   save_parent
3462 109F C9 2E 00              cmp   #drvr_disk_sw            ;was the media switched?
3463 10A2 F0 AC                 beq   go_id_disk
3464 10A4
3465 10A4 2C DF 04              bit   search_flag              ;is 'file not found' ok for this call?
3466 10A7 50 07                 bvc   not_ok                   ;no, tell caller about the error
3467 10A9 C9 46 00              cmp   #file_not_found
3468 10AC D0 02                 bne   not_ok                   ;this error cannot be handled!
3469 10AE 38                    sec   
3470 10AF 60                    rts                            ;tell caller that an error occured.
3471 10B0
3472 10B0              not_ok                                  ;
3473 10B0 38                    sec   
3474 10B1 4C 82 00              jmp   main_exit
3475 10B4
3476 10B4              save_parent                             ;
3477 10B4 8D 7B 05              sta   entry_offset             ;offset to the entry within the blk
3478 10B7 A5 10                 lda   drvr_blk_num             ;block number of parent
3479 10B9 8D 79 05              sta   parent_blk
3480 10BC
3481 10BC 86 04        cont02   stx   drvr_buf_ptr             ;save pointer to name
3482 10BE 84 06                 sty   drvr_buf_ptr+2
3483 10C0              process_exit                            ;
3484 10C0 20 FC 10              jsr   set_user_cache
3485 10C3 60                    rts   
3486 10C4
3487 10C4              ;If we get here we know that there is no pathname to process.
3488 10C4              ;We also know if there is no device number then 'volume_name' contains
3489 10C4              ;a volume name that I am suppose to open.
3490 10C4
3491 10C4              dev_or_vol                              ;
3492 10C4 A5 36                 lda   dev_num
3493 10C6 F0 2C                 beq   use_vol_name             ;we must have a volume name.
3494 10C8 20 D9 1C              jsr   id_disk                  ;go and find out if it is our disk
3495 10CB B0 0F                 bcs   to_main_exit
3496 10CD
3497 10CD              ;Before we check to see if the volume name is legal we must see if the
3498 10CD              ;volume is online.  The reason we do this is to be compatible with P16.
3499 10CD              ;
3500 10CD              ;Example:
3501 10CD              ;               Create '/VOLUME'        ;If '/VOLUME' is online then
3502 10CD              ;                                       ;the error returned is 'BadPath'
3503 10CD              ;               Create '/VOLUME'        ;If '/VOLUME' is offline then
3504 10CD              ;                                       ;the error returned is 'VolNotFound'
3505 10CD              ;
3506 10CD
3507 10CD A9 00 80     its_mine lda   #$8000                   ;indicate that we found the volume     3/5/91 CAE
3508 10D0 8D 0D 06              sta   error_priority           ;and it's a ProDOS volume              3/5/91 CAE
3509 10D3
3510 10D3 2C DF 04     check_root bit   search_flag            ;is a root level valid?
3511 10D6 10 07                 bpl   continue1                ;no problem with root level.
3512 10D8
3513 10D8 A9 40 00              lda   #bad_path_syntax
3514 10DB 38                    sec   
3515 10DC              to_main_exit                            ;
3516 10DC 4C 82 00              jmp   main_exit                ;return error to M.A. and J.J.
3517 10DF
3518 10DF              continue1                               ;
3519 10DF A7 04                 lda   [drvr_buf_ptr]           ;points to volume name
3520 10E1 09 F0 00              ora   #volume_header           ;add back in the storage type
3521 10E4 87 04                 sta   [drvr_buf_ptr]
3522 10E6
3523 10E6 A9 02 00              lda   #vol_dir_start
3524 10E9 8D 79 05              sta   parent_blk
3525 10EC A9 04 00              lda   #$0004
3526 10EF 8D 7B 05              sta   entry_offset
3527 10F2 80 CC                 bra   process_exit
3528 10F4
3529 10F4              use_vol_name                            ;
3530 10F4 20 96 1E              jsr   find_volume              ;locate the volume
3531 10F7 90 D4                 bcc   its_mine
3532 10F9 4C 82 00              jmp   main_exit
3533 10FC
3534 10FC                       EXPORT set_user_cache
3535 10FC              set_user_cache                          ;
3536 10FC 48                    pha                            ;save entry offset
3537 10FD AD 9F 05              lda   user_cache               ;set cache to user setting
3538 1100 85 1A                 sta   drvr_cache
3539 1102 68                    pla   
3540 1103 60                    rts   
3541 1104
3542 1104                       ENDP 
3543 1104
3544 1104              ;======================================================================
3545 1104              ;send_info      This routine is called when we need to return the
3546 1104              ;               informational parameters from a directory entry.
3547 1104              ;               This routine is called by 'OPEN' and 'GET_FILE_INFO'
3548 1104              ;WARNING:
3549 1104              ;               This routine assumes parameters are in a certain order.
3550 1104              ;               I did this so I could use that same routine across several
3551 1104              ;               calls!
3552 1104              ;
3553 1104              ;Input:         A = number of entries to send
3554 1104              ;               X = low word pointer to start of parameters
3555 1104              ;               Y = high word pointer to start of parameters
3556 1104              ;               P = nvmxdizc
3557 1104              ;                   ..000...
3558 1104              ;               b = k
3559 1104              ;
3560 1104              ;               one_entry               (contians the info to send)
3561 1104              ;               drvr_buf_ptr            (points to resource header block)
3562 1104              ;
3563 1104              ;Output:        A = undefined
3564 1104              ;               X = undefined
3565 1104
3566 1104              ;               Y = undefined
3567 1104              ;               P = nvmxdizc
3568 1104              ;                   ..000...
3569 1104              ;               b = k
3570 1104              ;
3571 1104              ;
3572 1104              ;Uses:          All registers
3573 1104              ;               math_temp
3574 1104              ;               temp_ptr
3575 1104              ;               one_entry
3576 1104              ;               time_routines
3577 1104              ;
3578 1104                       longa on
3579 1104                       longi on
3580 1104
3581 1104                       EXPORT send_info
3582 1104              send_info PROC 
3583 1104
3584 1104 86 98                 stx   temp_ptr
3585 1106 84 9A                 sty   temp_ptr+2
3586 1108
3587 1108              ;Save the number of entries the user wants.
3588 1108
3589 1108 85 AC                 sta   math_temp
3590 110A AA                    tax   
3591 110B D0 01                 bne   continue
3592 110D 60                    rts   
3593 110E
3594 110E              ;First we return the access as it is stored on disk.
3595 110E
3596 110E              continue                                ;
3597 110E A5 30                 lda   call_number              ;is this a class one call?
3598 1110 29 00 20              and   #$2000
3599 1113 F0 16                 beq   class0
3600 1115
3601 1115 AD 41 05              lda   one_entry                ;is this a volume entry?
3602 1118 29 F0 00              and   #$00F0                   ;isolate the storage type
3603 111B C9 F0 00              cmp   #volume_header
3604 111E D0 03                 bne   not_vol
3605 1120
3606 1120 9C 60 05              stz   one_entry+aux_type_index
3607 1123
3608 1123              not_vol                                 ;
3609 1123 C9 D0 00              cmp   #subdir_type             ;is it a subdir or volume?
3610 1126 90 03                 bcc   class0                   ;no
3611 1128
3612 1128 9C 54 05              stz   one_entry+blks_used_index
3613 112B
3614 112B              class0                                  ;
3615 112B A0 00 00              ldy   #pblk_s_access
3616 112E AD 5F 05              lda   one_entry+access_index
3617 1131 29 E7 00              and   #$00E7
3618 1134 97 98                 sta   [temp_ptr],y
3619 1136 C6 AC                 dec   math_temp
3620 1138 D0 02                 bne   send_two
3621 113A              end_send1  
3622 113A 18                    clc   
3623 113B 60                    rts   
3624 113C
3625 113C              ;If we are here then we know the user wants the file type as well
3626 113C
3627 113C              send_two                                ;
3628 113C A0 02 00              ldy   #pblk_s_ftype
3629 113F AD 51 05              lda   one_entry+file_type_index
3630 1142 29 FF 00              and   #$00FF
3631 1145 97 98                 sta   [temp_ptr],y
3632 1147 C6 AC                 dec   math_temp
3633 1149 F0 EF                 beq   end_send1
3634 114B
3635 114B              ;Now the user wants the aux type!
3636 114B
3637 114B A0 04 00              ldy   #pblk_s_aux
3638 114E AD 60 05              lda   one_entry+aux_type_index
3639 1151 97 98                 sta   [temp_ptr],y
3640 1153 C8                    iny   
3641 1154 C8                    iny   
3642 1155 A9 00 00              lda   #$0000
3643 1158 97 98                 sta   [temp_ptr],y
3644 115A C6 AC                 dec   math_temp
3645 115C F0 DC                 beq   end_send1
3646 115E
3647 115E              ;Also send the storage type of the file
3648 115E
3649 115E A0 08 00              ldy   #pblk_s_storage
3650 1161 AD 41 05              lda   one_entry
3651 1164 29 F0 00              and   #$00F0
3652 1167 4A                    lsr   a
3653 1168 4A                    lsr   a
3654 1169 4A                    lsr   a
3655 116A 4A                    lsr   a
3656 116B 97 98                 sta   [temp_ptr],y
3657 116D C6 AC                 dec   math_temp
3658 116F F0 C9                 beq   end_send1
3659 1171
3660 1171              ;Now convert the create date and send it to.
3661 1171
3662 1171              send_five                               ;
3663 1171
3664 1171 AE 59 05              ldx   one_entry+create_index
3665 1174 AC 5B 05              ldy   one_entry+create_index+2
3666 1177 20 96 0A              jsr   unpack_time
3667 117A A0 0A 00              ldy   #pblk_s_create
3668 117D 20 26 13              jsr   send_time
3669 1180 C6 AC                 dec   math_temp
3670 1182 F0 B6                 beq   end_send1
3671 1184
3672 1184              ;Now convert the modification data and time
3673 1184
3674 1184 AE 62 05              ldx   one_entry+last_mod_index
3675 1187 AC 64 05              ldy   one_entry+last_mod_index+2
3676 118A 20 96 0A              jsr   unpack_time
3677 118D A0 12 00              ldy   #pblk_s_mod
3678 1190 20 26 13              jsr   send_time
3679 1193 C6 AC                 dec   math_temp
3680 1195 F0 4F                 beq   @go_to_end
3681 1197
3682 1197              ; We now store the ProDOS FST ID in the 5th byte of the option list buffer
3683 1197
3684 1197 A0 1A 00              ldy   #pblk_s_opt              ;index to option list pointer
3685 119A B7 98                 lda   [temp_ptr],y             ;get the address of the option list buffer
3686 119C AA                    tax   
3687 119D C8                    iny   
3688 119E C8                    iny   
3689 119F B7 98                 lda   [temp_ptr],y
3690 11A1 A8                    tay   
3691 11A2 D0 03                 bne   @save_fst_id
3692 11A4 8A                    txa   
3693 11A5 F0 3D                 beq   @skip_save
3694 11A7              @save_fst_id  
3695 11A7 D4 98                 pei   temp_ptr                 ;save the working temp_ptr since I am going to use it
3696 11A9 D4 9A                 pei   temp_ptr+2               ;to handle the option list pointer
3697 11AB
3698 11AB 86 98                 stx   temp_ptr
3699 11AD 84 9A                 sty   temp_ptr+2
3700 11AF              ;
3701 11AF              ;Now I need to verify the option list length.  I need at least 6 bytes.
3702 11AF              ;
3703 11AF A7 98                 lda   [temp_ptr]               ;get the length of the option list
3704 11B1 C9 04 00              cmp   #$0004                   ;is the minimum count OK
3705 11B4 90 79                 bcc   opt_range_err            ;the user doesn't even have the minimum size>>>>
3706 11B6
3707 11B6 AA                    tax                            ;save the count for data area check
3708 11B7 A9 02 00              lda   #$0002                   ;length of the ProDOS FST ID.
3709 11BA A8                    tay   
3710 11BB 97 98                 sta   [temp_ptr],y             ;save the number of bytes stored
3711 11BD 8A                    txa   
3712 11BE C9 06 00              cmp   #$0006
3713 11C1 90 77                 bcc   opt_size_error
3714 11C3 C8                    iny   
3715 11C4 C8                    iny   
3716 11C5 A9 01 00              lda   #pro_id
3717 11C8 97 98                 sta   [temp_ptr],y
3718 11CA                                                      ;new code added 2/13/91 CAE
3719 11CA 8A                    txa   
3720 11CB C9 26 00              cmp   #6+32                    ;is buffer big enough to hold HFS Finder Info?
3721 11CE 90 0E                 bcc   @no_info                 ;no
3722 11D0 AD 41 05              lda   one_entry                ;yes - so check storage type
3723 11D3 29 F0 00              and   #$00F0
3724 11D6 C9 50 00              cmp   #resource_type           ;is it a resource file?
3725 11D9 D0 03                 bne   @no_info                 ;no - so no HFS info
3726 11DB 20 A9 12              jsr   get_hfs_info             ;yes - so get the HFS info if we have it
3727 11DE              @no_info  
3728 11DE                                                      ;end of new code
3729 11DE 68                    pla   
3730 11DF 85 9A                 sta   temp_ptr+2               ;restore
3731 11E1 68                    pla   
3732 11E2 85 98                 sta   temp_ptr
3733 11E4              @skip_save  
3734 11E4 C6 AC                 dec   math_temp                ;Option List is included in PCount
3735 11E6 F0 45        @go_to_end beq   end_send
3736 11E8
3737 11E8              ;Give the EOF as well. If the storage type is a resource file then I will
3738 11E8              ;get the EOF info from the resource block instead of the directory entry
3739 11E8
3740 11E8 A0 08 00              ldy   #pblk_s_storage
3741 11EB AD 41 05              lda   one_entry
3742 11EE 29 F0 00              and   #$00F0
3743 11F1 C9 50 00              cmp   #resource_type
3744 11F4 F0 4F                 beq   send_res_eof
3745 11F6
3746 11F6 A0 1E 00              ldy   #pblk_s_eof              ;send the EOF for the file
3747 11F9 AD 58 05              lda   one_entry+eof_index+2
3748 11FC 29 FF 00              and   #$00FF
3749 11FF AA                    tax   
3750 1200 AD 56 05              lda   one_entry+eof_index
3751 1203 20 1B 13              jsr   store_longword
3752 1206 C6 AC                 dec   math_temp
3753 1208 F0 23                 beq   end_send
3754 120A
3755 120A A0 22 00              ldy   #pblk_s_blks             ;send the number of blocks used
3756 120D AD 54 05              lda   one_entry+blks_used_index
3757 1210 A2 00 00              ldx   #$0000
3758 1213 20 1B 13              jsr   store_longword
3759 1216 C6 AC                 dec   math_temp
3760 1218 F0 13                 beq   end_send
3761 121A
3762 121A A0 26 00              ldy   #pblk_s_res_eof          ;send the resource eof
3763 121D              backup                                  ;
3764 121D A9 00 00              lda   #$0000
3765 1220 AA                    tax   
3766 1221 20 1B 13              jsr   store_longword
3767 1224 C6 AC                 dec   math_temp
3768 1226 F0 05                 beq   end_send
3769 1228
3770 1228 A0 2A 00              ldy   #pblk_s_res_blk          ;send the number of blocks used by res
3771 122B 80 F0                 bra   backup                   ;please send a zero Mr. ProDOS.
3772 122D
3773 122D 18           end_send clc   
3774 122E 60                    rts   
3775 122F
3776 122F              opt_range_err  
3777 122F 68                    pla   
3778 1230 85 9A                 sta   temp_ptr+2               ;restore
3779 1232 68                    pla   
3780 1233 85 98                 sta   temp_ptr
3781 1235
3782 1235 A9 53 00              lda   #parm_range_err
3783 1238 38                    sec   
3784 1239 60                    rts   
3785 123A
3786 123A              opt_size_error  
3787 123A 68                    pla   
3788 123B 85 9A                 sta   temp_ptr+2               ;restore
3789 123D 68                    pla   
3790 123E 85 98                 sta   temp_ptr
3791 1240
3792 1240 A9 4F 00              lda   #buff_too_small
3793 1243 38                    sec   
3794 1244 60                    rts   
3795 1245
3796 1245              ;Send the EOF and blocks used from the header block.
3797 1245
3798 1245              send_res_eof                            ;
3799 1245 A0 00 00              ldy   #$0000                   ;go get the info please from fork 1
3800 1248 20 80 12              jsr   get_res_info             ;A/X = EOF, Y = Blocks Used
3801 124B 5A                    phy                            ;save the blocks used field
3802 124C A0 1E 00              ldy   #pblk_s_eof              ;send the EOF for the file
3803 124F 20 1B 13              jsr   store_longword
3804 1252 A0 22 00              ldy   #pblk_s_blks             ;send the Blocks used
3805 1255
3806 1255 68                    pla                            ;restore the Blocks used field
3807 1256 C6 AC                 dec   math_temp                ;now see if they want blocks used.
3808 1258 F0 25                 beq   end_res_send             ;not today kind sir.
3809 125A
3810 125A A2 00 00              ldx   #$0000
3811 125D 20 1B 13              jsr   store_longword
3812 1260 C6 AC                 dec   math_temp                ;are we done
3813 1262 F0 1B                 beq   end_res_send
3814 1264
3815 1264 A0 00 01              ldy   #$0100                   ;go get the info please from fork 2
3816 1267 20 80 12              jsr   get_res_info             ;A/X = EOF, Y = Blocks Used
3817 126A 5A                    phy   
3818 126B A0 26 00              ldy   #pblk_s_res_eof          ;send the EOF for the file
3819 126E 20 1B 13              jsr   store_longword
3820 1271 A0 2A 00              ldy   #pblk_s_res_blk          ;send the Blocks used
3821 1274
3822 1274 68                    pla                            ;restore the Blocks used field
3823 1275 C6 AC                 dec   math_temp                ;are we done
3824 1277 F0 06                 beq   end_res_send
3825 1279
3826 1279 A2 00 00              ldx   #$0000                   ;send the blocks used by the res. fork
3827 127C 20 1B 13              jsr   store_longword
3828 127F
3829 127F              end_res_send                            ;
3830 127F 60                    rts   
3831 1280
3832 1280              ;==========================================================================
3833 1280              ;Grab the information from the resource block.  first fork starts at
3834 1280              ;offset $0000 in the header block.  The second fork starts at offset $0100
3835 1280              ;in the resource header block.
3836 1280              ;
3837 1280              ;format:        storage_type            (1 byte)
3838 1280              ;               key_block               (2 bytes)
3839 1280              ;               blocks_used             (2 bytes)
3840 1280              ;               eof                     (3 bytes)
3841 1280
3842 1280              get_res_info                            ;
3843 1280 B7 04                 lda   [drvr_buf_ptr],y
3844 1282 29 03 00              and   #$0003                   ;check the storage type
3845 1285 F0 1B                 beq   file_dead                ;this file is DOA
3846 1287 C9 04 00              cmp   #(tree_type/$10)+1
3847 128A B0 16                 bcs   file_dead
3848 128C C8                    iny                            ;point to Key Block
3849 128D
3850 128D C8                    iny   
3851 128E C8                    iny                            ;point to Blocks used
3852 128F B7 04                 lda   [drvr_buf_ptr],y
3853 1291 48                    pha                            ;save blocks used for later
3854 1292
3855 1292 C8                    iny   
3856 1293 C8                    iny                            ;point to EOF
3857 1294 B7 04                 lda   [drvr_buf_ptr],y
3858 1296 48                    pha                            ;save EOF low
3859 1297 C8                    iny   
3860 1298 C8                    iny   
3861 1299 B7 04                 lda   [drvr_buf_ptr],y
3862 129B 29 FF 00              and   #$00FF                   ;clear any garbage
3863 129E AA                    tax                            ;save EOF high
3864 129F 68                    pla                            ;A = EOF Low
3865 12A0 7A                    ply                            ;Y = Blocks used
3866 12A1 60                    rts                            ;A/X = EOF (A = Low) Y = Blocks Used
3867 12A2
3868 12A2              file_dead                               ;
3869 12A2 38                    sec                            ;sorry bad news
3870 12A3 A9 4B 00              lda   #bad_store_type
3871 12A6 4C 82 00              jmp   main_exit                ;no escape now!
3872 12A9
3873 12A9
3874 12A9              ;==========================================================================
3875 12A9              ;Get the HFS Finder Info if it has been stored in the resource block.  
3876 12A9              ;The Finder Info is stored immediately after the mini-entry for the data fork,
3877 12A9              ;so it begins at offset $0008 in the block. 
3878 12A9              ;
3879 12A9              ;format:        entry size              (1 byte)
3880 12A9              ;               entry type              (1 byte)
3881 12A9              ;               HFS Finder Info         (16 bytes)
3882 12A9              ;               entry size              (1 byte)
3883 12A9              ;               entry type              (1 byte)
3884 12A9              ;               HFS Finder Info         (16 bytes)
3885 12A9              ;
3886 12A9              ; entry_size = 18
3887 12A9              ; entry_type = 1 for first 16 bytes of Finder Info (FInfo)
3888 12A9              ;              2 for second 16 bytes of Finder Info (xFInfo)
3889 12A9              ;
3890 12A9              ;Note - the ProDOS FSM which runs on the Mac, has the ability to store only
3891 12A9              ;       the first 16 bytes of Finder Info or only the second 16 bytes. So, we
3892 12A9              ;       can't assume that both entries exist, or that they exist in a specific
3893 12A9              ;       order.
3894 12A9              ;==========================================================================
3895 12A9                       entry get_hfs_info
3896 12A9              get_hfs_info                            ;added 2/13/91 CAE
3897 12A9 9C EB 05              stz   hfs_flag                 ;indicate that we have no HFS info
3898 12AC
3899 12AC A2 1E 00              ldx   #30
3900 12AF 9E ED 05     @zero_loop stz   hfs_finfo,x            ;zero out storage area for HFS info
3901 12B2 CA                    dex                            ;since we may only find 1 entry
3902 12B3 CA                    dex   
3903 12B4 10 F9                 bpl   @zero_loop
3904 12B6
3905 12B6 A0 08 00              ldy   #8
3906 12B9 B7 04        @loop    lda   [drvr_buf_ptr],y         ;get entry size from resource block
3907 12BB 29 FF 00              and   #$00ff                   ;only want 1 byte
3908 12BE C9 12 00              cmp   #18                      ;is it the right size for HFS info?
3909 12C1 D0 20                 bne   @done                    ;no - so we're done
3910 12C3 C8                    iny   
3911 12C4 B7 04                 lda   [drvr_buf_ptr],y         ;yes - so get the entry type
3912 12C6 29 FF 00              and   #$00ff                   ;only want 1 byte
3913 12C9 C9 01 00              cmp   #finfo_type              ;is it the first 16 bytes of HFS info?
3914 12CC D0 08                 bne   @cont                    ;no
3915 12CE A2 00 00              ldx   #0                       ;yes - so init index into storage area
3916 12D1 20 05 13              jsr   get_finfo                ;and get the info
3917 12D4 80 E3                 bra   @loop                    ;loop
3918 12D6
3919 12D6 C9 02 00     @cont    cmp   #xfinfo_type             ;is it the second 16 bytes of HFS info?
3920 12D9 D0 08                 bne   @done                    ;no - so we're done
3921 12DB A2 10 00              ldx   #16                      ;yes - so init index into storage area
3922 12DE 20 05 13              jsr   get_finfo                ;and get the info
3923 12E1 80 D6                 bra   @loop                    ;loop
3924 12E3
3925 12E3 AD EB 05     @done    lda   hfs_flag                 ;did we find any HFS info?
3926 12E6 F0 1C                 beq   @exit                    ;no - so nothing to copy
3927 12E8
3928 12E8 A2 00 00              ldx   #0                       ;init offsets
3929 12EB A0 06 00              ldy   #6
3930 12EE BD ED 05     @copy_loop lda   hfs_finfo,x            ;copy the HFS Finder Info into the
3931 12F1 97 98                 sta   [temp_ptr],y             ;option list buffer
3932 12F3 C8                    iny   
3933 12F4 C8                    iny   
3934 12F5 E8                    inx   
3935 12F6 E8                    inx   
3936 12F7 E0 20 00              cpx   #32
3937 12FA 90 F2                 bcc   @copy_loop
3938 12FC
3939 12FC A0 02 00              ldy   #2
3940 12FF A9 22 00              lda   #2+32
3941 1302 97 98                 sta   [temp_ptr],y             ;adjust the # of bytes stored
3942 1304
3943 1304 60           @exit    rts                            ;return
3944 1305
3945 1305
3946 1305 C8           get_finfo iny                           ;adjust offset
3947 1306 A9 08 00              lda   #8                       ;we're going to copy 8 words
3948 1309 48           @loop    pha                            ;save counter
3949 130A B7 04                 lda   [drvr_buf_ptr],y         ;copy HFS Finder Info
3950 130C 9D ED 05              sta   hfs_finfo,x              ;into storage area
3951 130F C8                    iny                            ;adjust offsets
3952 1310 C8                    iny   
3953 1311 E8                    inx   
3954 1312 E8                    inx   
3955 1313 68                    pla                            ;retrieve counter
3956 1314 3A                    dec   a
3957 1315 D0 F2                 bne   @loop                    ;loop until done
3958 1317 EE EB 05              inc   hfs_flag                 ;indicate that we found some HFS info
3959 131A 60                    rts                            ;and return
3960 131B
3961 131B
3962 131B              ;==========================================================================
3963 131B
3964 131B              store_longword                          ;
3965 131B 97 98                 sta   [temp_ptr],y             ;store low order 16 bits of EOF
3966 131D C8                    iny   
3967 131E C8                    iny   
3968 131F 8A                    txa                            ;now store the upper 16 bits
3969 1320 29 FF 00              and   #$00FF
3970 1323 97 98                 sta   [temp_ptr],y
3971 1325 60                    rts   
3972 1326
3973 1326
3974 1326              ;======================================================================
3975 1326              ;This routine will store the time into the user's parameters block
3976 1326
3977 1326                       EXPORT send_time
3978 1326              send_time                               ;
3979 1326 AD F9 02              lda   minutes
3980 1329 EB                    xba                            ;swap minutes and seconds
3981 132A 97 98                 sta   [temp_ptr],y
3982 132C C8                    iny   
3983 132D C8                    iny   
3984 132E AD F7 02              lda   hours
3985 1331 97 98                 sta   [temp_ptr],y
3986 1333 C8                    iny   
3987 1334 AD FB 02              lda   year
3988 1337 97 98                 sta   [temp_ptr],y
3989 1339 C8                    iny   
3990 133A AD FF 02              lda   day
3991 133D F0 01                 beq   zero_day                 ;the day is unknown
3992 133F 3A                    dec   a                        ;convert to misc. tools hex format
3993 1340              zero_day                                ;
3994 1340 97 98                 sta   [temp_ptr],y
3995 1342 C8                    iny   
3996 1343 AD FD 02              lda   month
3997 1346 F0 01                 beq   zero_month
3998 1348 3A                    dec   a                        ;convert to misc. tools hex format
3999 1349              zero_month                              ;
4000 1349 97 98                 sta   [temp_ptr],y
4001 134B C8                    iny   
4002 134C AD 01 03              lda   day_of_week
4003 134F EB                    xba                            ;swap day of week and null byte
4004 1350 97 98                 sta   [temp_ptr],y
4005 1352 60                    rts   
4006 1353
4007 1353                       ENDP 
4008 1353
4009 1353              ;======================================================================
4010 1353              ;chk_protected: This routine will see if a volume is write protected.
4011 1353              ;
4012 1353              ;
4013 1353              ;Input:         A = undefined
4014 1353              ;               X = undefined
4015 1353              ;               Y = undefined
4016 1353              ;               P = nvmxdizc
4017 1353              ;                   ..000...
4018 1353              ;               b = k
4019 1353              ;
4020 1353              ;               drvr_dev_num            ;must be setup.
4021 1353              ;
4022 1353              ;Output:        A = status Word         ;see if driver ERS
4023 1353              ;               X = undefined
4024 1353              ;               Y = undefined
4025 1353              ;               P = nvmxdizc
4026 1353              ;                   ..000..1 = error
4027 1353              ;                          0 = no error
4028 1353              ;
4029 1353              ;               b = k
4030 1353              ;
4031 1353              ;
4032 1353              ;Uses:          All registers
4033 1353              ;
4034 1353                       longa on
4035 1353                       longi on
4036 1353
4037 1353                       EXPORT chk_protected
4038 1353              chk_protected PROC 
4039 1353
4040 1353 20 83 13              jsr   save_drvr
4041 1356
4042 1356 A9 05 00              lda   #drvr_status             ;issue a status call to the device
4043 1359 85 02                 sta   drvr_call_num
4044 135B
4045 135B A9 02 00              lda   #^status_list            ;setup a pointer to the status list
4046 135E 85 06                 sta   drvr_slist_ptr+2
4047 1360 A9 11 06              lda   #status_list
4048 1363 85 04                 sta   drvr_slist_ptr
4049 1365
4050 1365 A9 06 00              lda   #$0006                   ;a six byte request count
4051 1368 85 08                 sta   drvr_req_cnt
4052 136A 64 0A                 stz   drvr_req_cnt+2
4053 136C A9 00 02              lda   #blk_size
4054 136F 85 14                 sta   drvr_blk_size
4055 1371
4056 1371 64 16                 stz   drvr_stat_code           ;issue a 'driver status' call.
4057 1373 20 D0 17              jsr   device_call              ;blast off!!
4058 1376 B0 03                 bcs   status_error             ;An error?
4059 1378
4060 1378 AD 11 06              lda   status_list              ;get the return status
4061 137B 08           status_error php   
4062 137C 48                    pha   
4063 137D 20 8F 13              jsr   restore_drvr
4064 1380 68                    pla   
4065 1381 28                    plp   
4066 1382 60                    rts   
4067 1383
4068 1383 A2 1A 00     save_drvr ldx   #drvr_bytes             ;number of bytes to save
4069 1386 B5 00        save_it  lda   drvr_dev_num,x
4070 1388 9D 1B 06              sta   drvr_save,x
4071 138B CA                    dex   
4072 138C 10 F8                 bpl   save_it
4073 138E 60                    rts   
4074 138F
4075 138F A2 1A 00     restore_drvr ldx   #drvr_bytes
4076 1392 BD 1B 06     restore_it lda   drvr_save,x
4077 1395 95 00                 sta   drvr_dev_num,x
4078 1397 CA                    dex   
4079 1398 10 F8                 bpl   restore_it
4080 139A 60                    rts   
4081 139B
4082 139B                       EXPORT chk_disk_protect
4083 139B              chk_disk_protect  
4084 139B 9C 2C 14              stz   chk_prot_swap            ; haven't got disk switched yet (20-Dec-91 MSD)
4085 139E
4086 139E A5 84                 lda   my_vcr_ptr               ;see if we have a VCR
4087 13A0 05 86                 ora   my_vcr_ptr+2
4088 13A2 F0 0B                 beq   do_chk                   ;go ahead and do the check
4089 13A4
4090 13A4 A0 06 00              ldy   #vcr_status              ;do I need to status the disk?
4091 13A7 B7 84                 lda   [my_vcr_ptr],y
4092 13A9 29 00 20              and   #vcr_wr_enable
4093 13AC F0 01                 beq   do_chk                   ;yes we need to check the media
4094 13AE 60                    rts                            ;just return to the caller
4095 13AF
4096 13AF              do_chk                                  ;
4097 13AF 20 53 13              jsr   chk_protected            ;is the disk protected?
4098 13B2 B0 28                 bcs   big_problem
4099 13B4 AA                    tax   
4100 13B5 29 10 00              and   #$0010                   ;is the disk offline?
4101 13B8 F0 25                 beq   not_in_drive             ;there is no disk!!!
4102 13BA 8A                    txa   
4103 13BB 29 01 00              and   #$0001                   ;disk switched??
4104 13BE D0 1F                 bne   not_in_drive             ;disk has been switched!
4105 13C0 8A                    txa   
4106 13C1 29 04 00              and   #disk_protect
4107 13C4 D0 12                 bne   is_protected
4108 13C6
4109 13C6 A5 84                 lda   my_vcr_ptr               ;see if we have a VCR
4110 13C8 05 86                 ora   my_vcr_ptr+2
4111 13CA F0 0A                 beq   no_change                ;go ahead and set the vcr status flag
4112 13CC
4113 13CC A0 06 00              ldy   #vcr_status              ;set the 'No Status' bit
4114 13CF B7 84                 lda   [my_vcr_ptr],y
4115 13D1 09 00 20              ora   #vcr_wr_enable           ;no need to do the status next time
4116 13D4 97 84                 sta   [my_vcr_ptr],y
4117 13D6
4118 13D6 8A           no_change txa                           ;restore original status word
4119 13D7 60                    rts   
4120 13D8
4121 13D8
4122 13D8 38           is_protected sec   
4123 13D9 A9 2B 00              lda   #drvr_wr_prot            ;return write protect error to caller
4124 13DC
4125 13DC 4C 82 00     big_problem jmp   main_exit
4126 13DF
4127 13DF              not_in_drive  
4128 13DF              ;
4129 13DF              ; Begin 20-Dec-91 MSD
4130 13DF              ;
4131 13DF              ; We got a disk switched status, so try to find the volume (ask the user if necessary).
4132 13DF              ; This will force a new VCR to be built, and my_vcr_ptr will point to it.
4133 13DF              ;
4134 13DF AD 2C 14              lda   chk_prot_swap            ; already switched once?
4135 13E2 D0 42                 bne   do_disk_sw               ; yes, so return disk switched error
4136 13E4
4137 13E4 EE 2C 14              inc   chk_prot_swap            ; found one disk swithced status
4138 13E7
4139 13E7              *** added 28-Feb-92 DAL and GAB -- Save GBUF and important direct page stuff
4140 13E7 20 83 13              jsr   save_drvr
4141 13EA D4 96                 pei   <gbuf_ptr+2
4142 13EC D4 94                 pei   <gbuf_ptr
4143 13EE F4 02 00              pea   chk_protect_gbuf>>16
4144 13F1 F4 3C 06              pea   chk_protect_gbuf
4145 13F4 F4 00 00              pea   0
4146 13F7 F4 00 02              pea   $0200                    ; move 512 bytes
4147 13FA F4 05 08              pea   move_sinc_dinc
4148 13FD 22 70 FC 01           jsl   move_info
4149 1401              *** end 28-Feb-92, part one
4150 1401
4151 1401 20 2E 14              jsr   mount_volume             ; find the volume and build a VCR for it
4152 1404
4153 1404              *** added 28-Feb-92 DAL and GAB -- Restore GBUF and important direct-page stuff
4154 1404 08                    php   
4155 1405 48                    pha   
4156 1406 20 8F 13              jsr   restore_drvr
4157 1409 F4 02 00              pea   chk_protect_gbuf>>16
4158 140C F4 3C 06              pea   chk_protect_gbuf
4159 140F D4 96                 pei   <gbuf_ptr+2
4160 1411 D4 94                 pei   <gbuf_ptr
4161 1413 F4 00 00              pea   0
4162 1416 F4 00 02              pea   $0200                    ; move 512 bytes
4163 1419 F4 05 08              pea   move_sinc_dinc
4164 141C 22 70 FC 01           jsl   move_info
4165 1420 68                    pla   
4166 1421 28                    plp   
4167 1422              *** end 28-Feb-92, part two
4168 1422 B0 B8                 bcs   big_problem              ; better not be an error (we already found the path)
4169 1424
4170 1424 80 89                 bra   do_chk                   ; try the status again
4171 1426
4172 1426              do_disk_sw  
4173 1426 38                    sec   
4174 1427 A9 2E 00              lda   #drvr_disk_sw            ; give up, 2 consecutive disk switched statuses
4175 142A 80 B0                 bra   big_problem
4176 142C
4177 142C              ;
4178 142C              ; End 20-Dec-91 MSD
4179 142C              ;
4180 142C              ; The following code was commented out because we should really retry the status call.
4181 142C              ;
4182 142C              ;	ldy	#vcr_dev	;update the VCR status please
4183 142C              ;	lda	[my_vcr_ptr],y
4184 142C              ;	cmp	drvr_dev_num	;is this the same device?
4185 142C              ;	bne	just_exit	;no
4186 142C              ;	ldy	#vcr_status	;mark volume swapped
4187 142C              ;	lda	[my_vcr_ptr],y
4188 142C              ;	ora	#vcr_swapped	;disk has been removed from drive
4189 142C              ;	sta	[my_vcr_ptr],y
4190 142C              ;just_exit			;
4191 142C              ;	txa		;original status word
4192 142C              ;	rts
4193 142C
4194 142C 00 00        chk_prot_swap DC W:0                    ; flag for disk switched (20-Dec-91 MSD)
4195 142E
4196 142E                       ENDP 
4197 142E              ;======================================================================
4198 142E              ;Mount_volume:  This routine is called when we need to force the user
4199 142E              ;               To give us our disk back.
4200 142E              ;
4201 142E              ;
4202 142E              ;Input:         A = undefined
4203 142E              ;               X = undefined
4204 142E              ;               Y = undefined
4205 142E              ;               P = nvmxdizc
4206 142E              ;                   ..000...
4207 142E              ;               b = k
4208 142E              ;
4209 142E              ;               my_vcr_ptr              (points to needed VCR)
4210 142E              ;
4211 142E              ;Output:        A = error code if carry set
4212 142E              ;               X = undefined
4213 142E              ;               Y = undefined
4214 142E              ;               P = nvmxdizc
4215 142E              ;                   ..000..1 = error
4216 142E              ;               b = k
4217 142E              ;
4218 142E              ;
4219 142E              ;Uses:          All registers
4220 142E              ;               find_volume
4221 142E              ;
4222 142E                       longa on
4223 142E                       longi on
4224 142E
4225 142E                       EXPORT mount_volume
4226 142E              mount_volume PROC 
4227 142E
4228 142E 20 5A 14              jsr   save_the_world           ;save alot of data.
4229 1431 20 67 17              jsr   setup_vol_mesg           ;move the VCR name to local buffer
4230 1434
4231 1434 20 96 1E     try_again jsr   find_volume             ;go get the volume
4232 1437 90 09                 bcc   volume_online            ;go and update everything
4233 1439 20 0E 17              jsr   issue_mount              ;issue a mount request
4234 143C 90 F6                 bcc   try_again                ;user said volume is now online
4235 143E 20 7E 14              jsr   restore_world            ;restore everything please
4236 1441 60                    rts   
4237 1442
4238 1442 A5 00        volume_online lda   drvr_dev_num        ;where the volume was found
4239 1444 20 7E 14              jsr   restore_world            ;A is saved
4240 1447 85 00                 sta   drvr_dev_num
4241 1449
4242 1449 A0 0C 00              ldy   #vcr_dev                 ;update with the new device number
4243 144C 97 84                 sta   [my_vcr_ptr],y
4244 144E A0 06 00              ldy   #vcr_status              ;indicate that the volume is online
4245 1451 B7 84                 lda   [my_vcr_ptr],y
4246 1453 29 FF BF              and   #vcr_swapped_in
4247 1456 97 84                 sta   [my_vcr_ptr],y
4248 1458 18                    clc   
4249 1459 60                    rts                            ;volume is back on-line
4250 145A
4251 145A 08           save_the_world php   
4252 145B 5A                    phy   
4253 145C DA                    phx   
4254 145D 48                    pha   
4255 145E
4256 145E AD F7 03              lda   world_flag               ;see if data already saved
4257 1461 D0 3D                 bne   to_sys_death             ;debug
4258 1463 EE F7 03              inc   world_flag
4259 1466
4260 1466 A2 4A 00              ldx   #$004A                   ;save the direct page data
4261 1469 B5 00        save_direct lda   drvr_dev_num,x
4262 146B 9D 33 03              sta   direct_page,x
4263 146E CA                    dex   
4264 146F 10 F8                 bpl   save_direct
4265 1471
4266 1471 A2 52 00              ldx   #$0052                   ;save my direct page
4267 1474 B5 80        save_my_direct lda   fst_start,x
4268 1476 9D 7F 03              sta   my_direct,x
4269 1479 CA                    dex   
4270 147A 10 F8                 bpl   save_my_direct
4271 147C
4272 147C 80 1D                 bra   save_rest_exit
4273 147E
4274 147E 08           restore_world php   
4275 147F 5A                    phy   
4276 1480 DA                    phx   
4277 1481 48                    pha   
4278 1482
4279 1482 A2 4A 00              ldx   #$004A                   ;save the direct page data
4280 1485 BD 33 03     restore_direct lda   direct_page,x
4281 1488 95 00                 sta   drvr_dev_num,x
4282 148A CA                    dex   
4283 148B 10 F8                 bpl   restore_direct
4284 148D
4285 148D A2 52 00              ldx   #$0052                   ;save my direct page
4286 1490 BD 7F 03     restore_dp lda   my_direct,x
4287 1493 95 80                 sta   fst_start,x
4288 1495 CA                    dex   
4289 1496 10 F8                 bpl   restore_dp
4290 1498
4291 1498 CE F7 03              dec   world_flag
4292 149B
4293 149B 68           save_rest_exit pla   
4294 149C FA                    plx   
4295 149D 7A                    ply   
4296 149E 28                    plp   
4297 149F 60                    rts   
4298 14A0
4299 14A0
4300 14A0 22 44 FC 01  to_sys_death jsl   sys_death
4301 14A4
4302 14A4
4303 14A4                       ENDP 
4304 14A4
4305 14A4              ;======================================================================
4306 14A4              ;build_path:    This procedure will parse off the volume name out of a
4307 14A4              ;               pathname if needed.
4308 14A4              ;
4309 14A4              ;Input:         A = AND mask used on path_flag ($BFFF or $FFBF)
4310 14A4              ;               X = low word pointer to pathname
4311 14A4              ;               Y = high word pointer to pathname
4312 14A4              ;               P = nvmxdizc
4313 14A4              ;                   ..000...
4314 14A4              ;               b = k
4315 14A4              ;
4316 14A4              ;               path_flag               ;GS/OS parameter (See common equates)
4317 14A4              ;               dev_num                 ;GS/OS parameter
4318 14A4              ; 
4319 14A4              ;Output:        A = undefined
4320 14A4              ;               X = low word pointer to pathname
4321 14A4              ;               Y = high word pointer to pathname
4322 14A4              ;               P = nvmxdizc
4323 14A4              ;                   ..000..1 = no pathname (device # or vol name only)
4324 14A4              ;                          0 = X and Y contain a pathname pointer
4325 14A4              ;               b = k
4326 14A4              ;
4327 14A4              ;               volume_name             ;if volume name is available
4328 14A4
4329 14A4              ;                                       ;e.g. no device number is given          
4330 14A4              ;
4331 14A4              ;Uses:          All registers
4332 14A4              ;               temp_ptr
4333 14A4              ;               path_flag
4334 14A4              ;               dev_num 
4335 14A4              ;               and_mask
4336 14A4              ;
4337 14A4                       longa on
4338 14A4                       longi on
4339 14A4
4340 14A4                       EXPORT build_path
4341 14A4              build_path PROC 
4342 14A4
4343 14A4 8D BD 05              sta   and_mask                 ;setup by caller
4344 14A7
4345 14A7              ;now adjust the pointer to point past the length word
4346 14A7
4347 14A7 E8                    inx   
4348 14A8 D0 01                 bne   do_again
4349 14AA C8                    iny   
4350 14AB E8           do_again inx   
4351 14AC D0 01                 bne   cont
4352 14AE C8                    iny   
4353 14AF
4354 14AF              cont      
4355 14AF 86 98                 stx   temp_ptr
4356 14B1 84 9A                 sty   temp_ptr+2               ;pointer to pathname
4357 14B3
4358 14B3 A5 42                 lda   path_flag                ;see if there is a pathname to process
4359 14B5 2D BD 05              and   and_mask
4360 14B8 D0 02                 bne   proc_path                ;there is a pathname so handle it
4361 14BA 38                    sec   
4362 14BB 60                    rts                            ;device number the only thing available
4363 14BC
4364 14BC              proc_path                               ;
4365 14BC A5 36                 lda   dev_num                  ;see if there is a device
4366 14BE F0 05                 beq   no_device                ;no device so isolate volume name
4367 14C0                                                      ;tell caller device # and pathname
4368 14C0              done      
4369 14C0 20 18 15              jsr   set_case_bits            ;save the case bits as needed please and convert to upper case
4370 14C3 18                    clc   
4371 14C4 60                    rts   
4372 14C5
4373 14C5              no_device                               ;
4374 14C5 20 DF 14              jsr   vol_to_buffer            ;out: A = terminator Y = length
4375 14C8 48                    pha                            ;save termination reason
4376 14C9 C8                    iny   
4377 14CA C8                    iny   
4378 14CB 98                    tya                            ;length of name +1
4379 14CC A4 9A                 ldy   temp_ptr+2
4380 14CE 18                    clc   
4381 14CF 65 98                 adc   temp_ptr
4382 14D1 AA                    tax   
4383 14D2 90 01                 bcc   do_end
4384 14D4 C8                    iny                            ;adjust high word
4385 14D5              do_end    
4386 14D5 68                    pla                            ;restore terminator
4387 14D6 D0 E8                 bne   done                     ;tell caller volume name and pathname!
4388 14D8 48                    pha   
4389 14D9 20 18 15              jsr   set_case_bits            ;set the case of the last path please
4390 14DC 68                    pla   
4391 14DD 38                    sec                            ;tell caller volume name only!
4392 14DE 60                    rts   
4393 14DF
4394 14DF                       EXPORT vol_to_buffer
4395 14DF              vol_to_buffer                           ;'build_path' has setup temp_ptr
4396 14DF A0 01 00              ldy   #$0001                   ;to point past '/' in volume name
4397 14E2              vol_name_loop  
4398 14E2 B7 98                 lda   [temp_ptr],y
4399 14E4 29 FF 00              and   #$00FF
4400 14E7 F0 22                 beq   loop_end                 ;we have hit the last character
4401 14E9 C9 3A 00              cmp   #delimiter               ;see if it is a seperator
4402 14EC F0 1D                 beq   loop_end
4403 14EE
4404 14EE
4405 14EE              if AllowLCPeriods then                  ;added 7-Aug-91 DAL
4406 14EE C9 61 00              cmp   #$0020
4407 14F1                       bne   @not_blank
4408 14F1                       lda   #$002E                   ;make a blank into a period
4409 14F1              @not_blank  
4410 14F1              endif                                   ;end 7-Aug-91 DAL
4411 14F1
4412 14F1                       cmp   #$0061                   ;check if we need to convert to upper case. "a"
4413 14F1 90 08                 bcc   @no_upper
4414 14F3 C9 7B 00              cmp   #$007B                   ;check "z"+1
4415 14F6 B0 03                 bcs   @no_upper
4416 14F8 29 DF 00              and   #$00DF                   ;convert to upper case
4417 14FB              @no_upper  
4418 14FB 99 FC 04              sta   volume_name+1,y          ;store name in buffer
4419 14FE C8                    iny   
4420 14FF C0 11 00              cpy   #$0011                   ;is length > 15 characters? -- 1/12/92 AEN
4421 1502 90 DE                 bcc   vol_name_loop            ;no, keep copying
4422 1504 A9 40 00              lda   #bad_path_syntax         ;else we've got a bad pathname
4423 1507 38                    sec   
4424 1508 4C 82 00              jmp   main_exit
4425 150B
4426 150B              loop_end  
4427 150B AA                    tax                            ;save the terminating reason
4428 150C A9 00 00              lda   #$0000                   ;terminate the string with a null byte
4429 150F 99 FC 04              sta   volume_name+1,y
4430 1512 88                    dey                            ;adjust string length
4431 1513 8C FB 04              sty   volume_name
4432 1516 8A                    txa   
4433 1517 60                    rts   
4434 1518              ;
4435 1518              ;This routine will save the case bits for the last piece of the pathname and
4436 1518              ;will convert the input string to all uppercase.
4437 1518              ;
4438 1518                       Export set_case_bits
4439 1518              set_case_bits  
4440 1518 48                    pha   
4441 1519 DA                    phx   
4442 151A 5A                    phy   
4443 151B
4444 151B
4445 151B A0 00 00              ldy   #$0000                   ;start at the first character please
4446 151E              @outter_loop  
4447 151E A9 00 40              lda   #$4000                   ;arm the case bit mask please
4448 1521 8D 11 03              sta   case_bit_pattern
4449 1524 9C 0F 03              stz   case_bits
4450 1527              @inner_loop  
4451 1527 B7 98                 lda   [temp_ptr],y             ;get the user's input character please
4452 1529 29 FF 00              and   #$00FF                   ;now check delimiters
4453 152C F0 2C                 beq   @end_of_string
4454 152E C9 3A 00              cmp   #delimiter
4455 1531 F0 24                 beq   @next_part               ;do the next part of the path please
4456 1533
4457 1533              if AllowLCPeriods then                  ;added 7-Aug-91 DAL
4458 1533 C9 61 00              cmp   #' '
4459 1536                       bne   @not_a_blank
4460 1536                       lda   #'.'
4461 1536                       bra   @was_a_blank
4462 1536              @not_a_blank  
4463 1536              endif                                   ;end 7-Aug-91 DAL
4464 1536
4465 1536                       cmp   #$0061                   ;check if we need to convert to upper case. "a"
4466 1536 90 13                 bcc   @no_upper
4467 1538 C9 7B 00              cmp   #$007B                   ;check "z"+1
4468 153B B0 0E                 bcs   @no_upper
4469 153D 29 DF 00              and   #$00DF                   ;convert to upper case
4470 1540 AA           @was_a_blank tax                        ;save the character please
4471 1541 AD 11 03              lda   case_bit_pattern
4472 1544 0D 0F 03              ora   case_bits
4473 1547 8D 0F 03              sta   case_bits                ;save the case bit for this character
4474 154A 8A                    txa   
4475 154B              @no_upper  
4476 154B E2 20                 sep   #$20                     ;8 Bit store
4477 154D 97 98                 sta   [temp_ptr],y             ;save the character back please
4478 154F C2 20                 rep   #$20                     ;back to 16 bit mode
4479 1551 4E 11 03              lsr   case_bit_pattern
4480 1554 C8                    iny                            ;move to the next position please
4481 1555 80 D0                 bra   @inner_loop
4482 1557
4483 1557              @next_part  
4484 1557 C8                    iny                            ;advance to the next part of the pathname
4485 1558 80 C4                 bra   @outter_loop
4486 155A
4487 155A              @end_of_string  
4488 155A 7A                    ply   
4489 155B FA                    plx   
4490 155C 68                    pla   
4491 155D 60                    rts   
4492 155E                       ENDP 
4493 155E
4494 155E              ;==========================================================================
4495 155E              ;Move_vol_name: This routine will move the volume name pointed to by
4496 155E              ;               drvr_buf_ptr into the buffer pointed to by the address
4497 155E              ;               in the X and Y registers
4498 155E              ;
4499 155E              ;Input:         A = undefined
4500 155E              ;               X = low word pointer to the destination buffer
4501 155E              ;               Y = high word pointer to the destination buffer
4502 155E              ;               P = nvmxdizc
4503 155E              ;                   ..000...
4504 155E              ;               b = k
4505 155E              ;
4506 155E              ;               drvr_buf_ptr            ;points to the volume header in blk two
4507 155E              ;
4508 155E              ;Output:        A = undefined
4509 155E              ;               X = undefined
4510 155E              ;               Y = undefined
4511 155E              ;               P = nvmxdizc
4512 155E              ;                   ..000...
4513 155E              ;               b = k
4514 155E              ;
4515 155E              ;Uses:          All registers
4516 155E              ;               temp_ptr
4517 155E              ;
4518 155E                       longa on
4519 155E                       longi on
4520 155E
4521 155E                       EXPORT move_vol_name
4522 155E              move_vol_name PROC 
4523 155E
4524 155E 86 98                 stx   temp_ptr
4525 1560 84 9A                 sty   temp_ptr+2
4526 1562
4527 1562 A7 04                 lda   [drvr_buf_ptr]
4528 1564 29 0F 00              and   #$000F                   ;isolate name length
4529 1567 87 98                 sta   [temp_ptr]               ;save the length in word format
4530 1569 A8                    tay   
4531 156A
4532 156A 18                    clc   
4533 156B A5 98                 lda   temp_ptr
4534 156D 69 02 00              adc   #$0002
4535 1570 85 98                 sta   temp_ptr
4536 1572 90 02                 bcc   ar1
4537 1574 E6 9A                 inc   temp_ptr+2
4538 1576              ar1                                     ;
4539 1576
4540 1576                       longa off
4541 1576 E2 20                 sep   #$20
4542 1578              move_loop                               ;
4543 1578 B7 04                 lda   [drvr_buf_ptr],y
4544 157A 97 98                 sta   [temp_ptr],y
4545 157C 88                    dey   
4546 157D D0 F9                 bne   move_loop
4547 157F
4548 157F                       longa on
4549 157F C2 20                 rep   #$20
4550 1581 60                    rts   
4551 1582
4552 1582                       ENDP 
4553 1582
4554 1582              ;==========================================================================
4555 1582              ;set_default_buf:       sets up the default buffer pointer
4556 1582              ;
4557 1582              ;
4558 1582              ;Enter:         jsr
4559 1582              ;
4560 1582              ;Input:         A = undefined
4561 1582              ;               X = undefined
4562 1582              ;               Y = undefined
4563 1582              ;               P = nvmxdizc
4564 1582              ;                   ..000...
4565 1582              ;               b = k
4566 1582              ;
4567 1582              ;Output:        A = undefined
4568 1582              ;               X = undefined
4569 1582              ;               Y = undefined
4570 1582              ;               P = nvmxdizc
4571 1582              ;                   ..000...
4572 1582              ;               b = k
4573 1582              ;
4574 1582              ;Uses:          A register
4575 1582              ;
4576 1582                       longa on
4577 1582                       longi on
4578 1582
4579 1582                       EXPORT set_default_buf
4580 1582              set_default_buf PROC 
4581 1582
4582 1582 AD EB 02              lda   gbuf_addr                ;setup the general I/O buffer
4583 1585 85 04                 sta   drvr_buf_ptr
4584 1587 AD ED 02              lda   gbuf_addr+2
4585 158A 85 06                 sta   drvr_buf_ptr+2
4586 158C 60                    rts   
4587 158D
4588 158D                       EXPORT standard_req
4589 158D              standard_req                            ;
4590 158D A9 00 02              lda   #blk_size
4591 1590 85 08                 sta   drvr_req_cnt
4592 1592 64 0A                 stz   drvr_req_cnt+2
4593 1594 60                    rts   
4594 1595                       ENDP 
4595 1595
4596 1595              ;======================================================================
4597 1595              ;setup_my_vcr:  this routine sets up a pointer to the prodos specific
4598 1595              ;               volume control record.
4599 1595              ;
4600 1595              ;Input:         A = undefined
4601 1595              ;               X = undefined
4602 1595              ;               Y = undefined
4603 1595              ;               P = nvmxdizc
4604 1595              ;                   ..000...
4605 1595              ;               b = k
4606 1595              ;
4607 1595              ;               my_vcr_ptr              (Points to main VCR)
4608 1595              ;
4609 1595              ;Output:        A = undefined
4610 1595              ;               X = low word of prodos vcr
4611 1595              ;               Y = high word of prodos vcr
4612 1595              ;               P = nvmxdizc
4613 1595              ;                   ..000...
4614 1595              ;               b = k
4615 1595              ;
4616 1595              ;
4617 1595              ;Uses:          All registers
4618 1595              ;               my_vcr_ptr
4619 1595              ; 
4620 1595                       longa on
4621 1595                       longi on
4622 1595
4623 1595                       EXPORT setup_my_vcr
4624 1595              setup_my_vcr PROC 
4625 1595
4626 1595 18                    clc   
4627 1596 A5 84                 lda   my_vcr_ptr
4628 1598 69 0E 00              adc   #vcr_dev+2               ;start of local data for vcr
4629 159B AA                    tax   
4630 159C A5 86                 lda   my_vcr_ptr+2
4631 159E 69 00 00              adc   #$0000
4632 15A1 A8                    tay   
4633 15A2 60                    rts   
4634 15A3
4635 15A3                       ENDP 
4636 15A3
4637 15A3
4638 15A3              ;======================================================================
4639 15A3              ;setup_my_fcr:  this routine sets up a pointer to the prodos specific
4640 15A3              ;               file control record data.
4641 15A3              ;
4642 15A3              ;Input:         A = undefined
4643 15A3              ;               X = undefined
4644 15A3              ;               Y = undefined
4645 15A3              ;               P = nvmxdizc
4646 15A3              ;                   ..000...
4647 15A3              ;               b = k
4648 15A3              ;
4649 15A3              ;               my_fcr_ptr              (Points to main FCR)
4650 15A3              ;
4651 15A3              ;Output:        A = undefined
4652 15A3              ;               X = low word of prodos fcr
4653 15A3              ;               Y = high word of prodos fcr
4654 15A3              ;               P = nvmxdizc
4655 15A3              ;                   ..000...
4656 15A3              ;               b = k
4657 15A3              ;
4658 15A3              ;
4659 15A3              ;Uses:          All registers
4660 15A3              ;               my_fcr_ptr
4661 15A3              ; 
4662 15A3                       longa on
4663 15A3                       longi on
4664 15A3
4665 15A3                       EXPORT setup_my_fcr
4666 15A3              setup_my_fcr PROC 
4667 15A3
4668 15A3 18                    clc   
4669 15A4 A5 8C                 lda   my_fcr_ptr
4670 15A6 69 16 00              adc   #fcr_access+2            ;start of local data for fcr
4671 15A9 AA                    tax   
4672 15AA A5 8E                 lda   my_fcr_ptr+2
4673 15AC 69 00 00              adc   #$0000
4674 15AF A8                    tay   
4675 15B0 60                    rts   
4676 15B1                       ENDP 
4677 15B1
4678 15B1              ;======================================================================
4679 15B1              ;setup_io_ptrs  this routine sets up pointers to the active data buffers
4680 15B1              ;
4681 15B1              ;Input:         A = undefined
4682 15B1              ;               X = undefined
4683 15B1              ;               Y = undefined
4684 15B1              ;               P = nvmxdizc
4685 15B1              ;                   ..000...
4686 15B1              ;               b = k
4687 15B1              ;
4688 15B1              ;               my_fcr_ptr              (Points to main FCR)
4689 15B1              ;               pro_fcr_ptr             (points to specific data)
4690 15B1              ;
4691 15B1              ;Output:        A = undefined
4692 15B1              ;               X = low word of prodos vcr
4693 15B1              ;               Y = high word of prodos vcr
4694 15B1              ;               P = nvmxdizc
4695 15B1              ;                   ..000...
4696 15B1              ;               b = k
4697 15B1              ;
4698 15B1              ;
4699 15B1              ;Uses:          All registers
4700 15B1              ;               my_fcr_ptr
4701 15B1              ;               math_temp
4702 15B1              ;
4703 15B1                       longa on
4704 15B1                       longi on
4705 15B1
4706 15B1                       EXPORT setup_io_ptrs
4707 15B1              setup_io_ptrs PROC 
4708 15B1
4709 15B1 64 B0                 stz   data_ptr                 ;init the pointers
4710 15B3 64 B4                 stz   index_ptr
4711 15B5 64 B8                 stz   master_ptr
4712 15B7 64 B2                 stz   data_ptr+2
4713 15B9 64 B6                 stz   index_ptr+2
4714 15BB 64 BA                 stz   master_ptr+2
4715 15BD
4716 15BD A9 53 00              lda   #fcr_io_start
4717 15C0 85 AC                 sta   math_temp                ;save the start of the I/O buffer
4718 15C2
4719 15C2 A0 1F 00              ldy   #fcr_status              ;see if master index is active
4720 15C5 B7 90                 lda   [pro_fcr_ptr],y
4721 15C7 29 00 10              and   #master_active
4722 15CA F0 11                 beq   no_master                ;there is no master index block
4723 15CC
4724 15CC 18                    clc   
4725 15CD A5 8C                 lda   my_fcr_ptr
4726 15CF 65 AC                 adc   math_temp
4727 15D1 85 B8                 sta   master_ptr
4728 15D3 A5 8E                 lda   my_fcr_ptr+2
4729 15D5 69 00 00              adc   #$0000
4730 15D8 85 BA                 sta   master_ptr+2
4731 15DA 20 11 16              jsr   next_block               ;bump the pointer to the next block
4732 15DD
4733 15DD              no_master                               ;
4734 15DD A0 1F 00              ldy   #fcr_status              ;see if there is an index block
4735 15E0 B7 90                 lda   [pro_fcr_ptr],y
4736 15E2 29 00 20              and   #index_active
4737 15E5 F0 11                 beq   no_index                 ;there is no index block
4738 15E7
4739 15E7 18                    clc   
4740 15E8 A5 8C                 lda   my_fcr_ptr
4741 15EA 65 AC                 adc   math_temp
4742 15EC 85 B4                 sta   index_ptr
4743 15EE A5 8E                 lda   my_fcr_ptr+2
4744 15F0 69 00 00              adc   #$0000
4745 15F3 85 B6                 sta   index_ptr+2
4746 15F5 20 11 16              jsr   next_block               ;bump the pointer to the next block
4747 15F8
4748 15F8              no_index                                ;
4749 15F8 A0 1F 00              ldy   #fcr_status              ;see if there is a data block
4750 15FB B7 90                 lda   [pro_fcr_ptr],y
4751 15FD 29 00 40              and   #data_active
4752 1600 F0 0E                 beq   end_io_setup             ;there is no data block
4753 1602
4754 1602 18                    clc   
4755 1603 A5 8C                 lda   my_fcr_ptr
4756 1605 65 AC                 adc   math_temp
4757 1607 85 B0                 sta   data_ptr
4758 1609 A5 8E                 lda   my_fcr_ptr+2
4759 160B 69 00 00              adc   #$0000
4760 160E 85 B2                 sta   data_ptr+2
4761 1610
4762 1610              end_io_setup                            ;
4763 1610 60                    rts   
4764 1611
4765 1611              next_block                              ;
4766 1611 18                    clc   
4767 1612 A5 AC                 lda   math_temp
4768 1614 69 00 02              adc   #blk_size
4769 1617 85 AC                 sta   math_temp
4770 1619 60                    rts   
4771 161A
4772 161A                       ENDP 
4773 161A
4774 161A              ;======================================================================
4775 161A              ;setup_bitmap_ptr: This routine will return a pointer to the bitmap
4776 161A              ;               buffer and setup 'bitmap' to point to the bitmap buffer
4777 161A              ;
4778 161A              ;Input:         A = undefined
4779 161A              ;               X = undefined
4780 161A              ;               Y = undefined
4781 161A              ;               P = nvmxdizc
4782 161A              ;                   ..000...
4783 161A              ;               b = k
4784 161A              ;
4785 161A              ;               my_vcr_ptr              (Points to main VCR)
4786 161A              ;
4787 161A              ;Output:        A = undefined
4788 161A              ;               X = low word of bitmap
4789 161A              ;               Y = high word of bitmap
4790 161A              ;               P = nvmxdizc
4791 161A              ;                   ..000...
4792 161A              ;               b = k
4793 161A              ;
4794 161A              ;               bitmap                  (bitmap pointer is setup)
4795 161A              ;
4796 161A              ;Uses:          All registers
4797 161A              ;               my_vcr_ptr
4798 161A              ; 
4799 161A                       longa on
4800 161A                       longi on
4801 161A
4802 161A                       EXPORT setup_bitmap_ptr 
4803 161A              setup_bitmap_ptr PROC  
4804 161A
4805 161A 18                    clc   
4806 161B A5 84                 lda   my_vcr_ptr
4807 161D 69 37 00              adc   #bitmap_start            ;starting location of bitmap
4808 1620 85 BC                 sta   bitmap
4809 1622 AA                    tax   
4810 1623 A5 86                 lda   my_vcr_ptr+2
4811 1625 69 00 00              adc   #$0000
4812 1628 85 BE                 sta   bitmap+2
4813 162A A8                    tay   
4814 162B 60                    rts   
4815 162C                       ENDP 
4816 162C
4817 162C              ;======================================================================
4818 162C              ;clear_gbuf_low This routine will zero the lower half of the general
4819 162C              ;               buffer.
4820 162C              ;
4821 162C              ;Input:         A = undefined
4822 162C              ;               X = undefined
4823 162C              ;               Y = undefined
4824 162C              ;               P = nvmxdizc
4825 162C              ;                   ..000...
4826 162C              ;               b = k
4827 162C              ;
4828 162C              ;               gbuf_ptr
4829 162C              ;
4830 162C              ;Output:        A = undefined
4831 162C              ;               X = undefined
4832 162C              ;               Y = undefined
4833 162C              ;               P = nvmxdizc
4834 162C              ;                   ..000...
4835 162C              ;               b = k
4836 162C              ;
4837 162C              ;
4838 162C              ;Uses:          All registers
4839 162C              ;               gbuf_ptr
4840 162C              ; 
4841 162C                       longa on
4842 162C                       longi on
4843 162C
4844 162C                       EXPORT clear_gbuf_low
4845 162C              clear_gbuf_low PROC 
4846 162C
4847 162C A9 00 00              lda   #$0000
4848 162F 80 03                 bra   do_clear
4849 1631                       EXPORT fill_gbuf_low
4850 1631              fill_gbuf_low                           ;
4851 1631 A9 FF FF              lda   #$FFFF
4852 1634
4853 1634              do_clear                                ;
4854 1634 A0 FE 01              ldy   #$01FE
4855 1637              clear                                   ;
4856 1637 97 94                 sta   [gbuf_ptr],y
4857 1639 88                    dey   
4858 163A 88                    dey   
4859 163B 10 FA                 bpl   clear
4860 163D
4861 163D 60                    rts   
4862 163E                       ENDP 
4863 163E
4864 163E              ;======================================================================
4865 163E              ;clear_gbuf_hi. This routine will zero the upper half of the general
4866 163E              ;               buffer.
4867 163E              ;
4868 163E              ;Input:         A = undefined
4869 163E              ;               X = undefined
4870 163E              ;               Y = undefined
4871 163E              ;               P = nvmxdizc
4872 163E              ;                   ..000...
4873 163E              ;               b = k
4874 163E              ;
4875 163E              ;               gbuf_ptr
4876 163E              ;
4877 163E              ;Output:        A = undefined
4878 163E              ;               X = undefined
4879 163E              ;               Y = undefined
4880 163E              ;               P = nvmxdizc
4881 163E              ;                   ..000...
4882 163E              ;               b = k
4883 163E              ;
4884 163E              ;
4885 163E              ;Uses:          All registers
4886 163E              ;               gbuf_ptr
4887 163E              ;               temp3_ptr
4888 163E              ; 
4889 163E                       longa on
4890 163E                       longi on
4891 163E
4892 163E                       EXPORT clear_gbuf_high
4893 163E              clear_gbuf_high PROC 
4894 163E
4895 163E 18                    clc   
4896 163F A5 94                 lda   gbuf_ptr
4897 1641 69 00 02              adc   #$0200
4898 1644 85 A0                 sta   temp3_ptr
4899 1646 A5 96                 lda   gbuf_ptr+2
4900 1648 69 00 00              adc   #$0000
4901 164B 85 A2                 sta   temp3_ptr+2
4902 164D
4903 164D A0 FE 01              ldy   #$01FE
4904 1650 A9 00 00              lda   #$0000
4905 1653              clear                                   ;
4906 1653 97 A0                 sta   [temp3_ptr],y
4907 1655 88                    dey   
4908 1656 88                    dey   
4909 1657 10 FA                 bpl   clear
4910 1659
4911 1659 60                    rts   
4912 165A                       ENDP 
4913 165A
4914 165A
4915 165A              ;======================================================================
4916 165A              ;read_write_setup:
4917 165A              ;               this routine sets up common parameters between read/write
4918 165A              ;
4919 165A              ;Input:         A = undefined
4920 165A              ;               X = undefined
4921 165A              ;               Y = undefined
4922 165A              ;               P = nvmxdizc
4923 165A              ;                   ..000...
4924 165A              ;               b = k
4925 165A              ;
4926 165A              ;               pcount                  ;for cache check
4927 165A              ;               my_pblk_ptr             ;must be setup
4928 165A              ;
4929 165A              ;Output:        A = undefined
4930 165A              ;               X = undefined
4931 165A              ;               Y = undefined
4932 165A              ;               P = nvmxdizc
4933 165A              ;                   ..000...
4934 165A              ;               b = k
4935 165A              ;
4936 165A              ;               user_buf_ptr
4937 165A              ;               user_req_cnt
4938 165A              ;               drvr_cache
4939 165A              ;               tran_cnt                ;set to zero
4940 165A              ;
4941 165A              ;Uses:          All registers
4942 165A              ;
4943 165A                       longa on
4944 165A                       longi on
4945 165A
4946 165A                       EXPORT read_write_setup 
4947 165A              read_write_setup PROC  
4948 165A
4949 165A              ;Start code by turning off disk caching and setting up other parameters
4950 165A AD 9F 05              lda   user_cache
4951 165D 85 1A                 sta   drvr_cache
4952 165F 9C C7 05              stz   tran_cnt
4953 1662 9C C9 05              stz   tran_cnt+2
4954 1665
4955 1665 AD B7 05              lda   pcount                   ;is cache priority avail?
4956 1668 C9 05 00              cmp   #$0005
4957 166B D0 10                 bne   no_cache
4958 166D
4959 166D              ;If we get here then the user has provided a cache priority for the file.
4960 166D              ;So we must verify that it is a legal value for caching.
4961 166D
4962 166D              get_priority                            ;
4963 166D A0 0E 00              ldy   #pblk_12_cache
4964 1670 B7 80                 lda   [my_pblk_ptr],y
4965 1672 F0 09                 beq   no_cache                 ;same as mine
4966 1674 C9 01 00              cmp   #user_cache_val
4967 1677 F0 02                 beq   good_cache
4968 1679 80 33                 bra   param_err
4969 167B
4970 167B              good_cache                              ;
4971 167B 85 1A                 sta   drvr_cache
4972 167D
4973 167D              ;Setup a pointer to the user's buffer.
4974 167D
4975 167D              no_cache                                ;
4976 167D
4977 167D A0 02 00              ldy   #pblk_12_buf
4978 1680 B7 80                 lda   [my_pblk_ptr],y
4979 1682 85 C0                 sta   users_buf_ptr
4980 1684 C8                    iny   
4981 1685 C8                    iny   
4982 1686 B7 80                 lda   [my_pblk_ptr],y
4983 1688 29 FF 00              and   #$00FF
4984 168B 85 C2                 sta   users_buf_ptr+2
4985 168D
4986 168D              ;Go ahead and zero the user's transfer count.
4987 168D
4988 168D A0 0A 00              ldy   #pblk_12_tran            ;zero the transfer count
4989 1690 A9 00 00              lda   #$0000
4990 1693 97 80                 sta   [my_pblk_ptr],y
4991 1695 C8                    iny   
4992 1696 C8                    iny   
4993 1697 97 80                 sta   [my_pblk_ptr],y
4994 1699
4995 1699              ;Now lets get the user's request count.
4996 1699
4997 1699 A0 06 00              ldy   #pblk_12_req
4998 169C B7 80                 lda   [my_pblk_ptr],y
4999 169E 8D CB 05              sta   user_req_cnt
5000 16A1 C8                    iny   
5001 16A2 C8                    iny   
5002 16A3 B7 80                 lda   [my_pblk_ptr],y
5003 16A5 8D CD 05              sta   user_req_cnt+2
5004 16A8 AA                    tax   
5005 16A9 29 00 FF              and   #$FF00                   ;is high byte zero?
5006 16AC F0 06                 beq   good_cnt
5007 16AE
5008 16AE              param_err                               ;
5009 16AE 38                    sec   
5010 16AF A9 53 00              lda   #parm_range_err
5011 16B2 80 07                 bra   to_scm
5012 16B4
5013 16B4              ;Handle the easy case of a request count of zero first.
5014 16B4
5015 16B4              good_cnt                                ;
5016 16B4 8A                    txa   
5017 16B5 0D CB 05              ora   user_req_cnt
5018 16B8 D0 04                 bne   not_zero
5019 16BA 18                    clc   
5020 16BB              to_scm                                  ;
5021 16BB 4C 82 00              jmp   main_exit
5022 16BE
5023 16BE              not_zero                                ;
5024 16BE 60                    rts   
5025 16BF                       ENDP 
5026 16BF
5027 16BF
5028 16BF                       EXPORT rw_adjust
5029 16BF              rw_adjust PROC                          ;read/write adjust
5030 16BF
5031 16BF              ;==========================================================================
5032 16BF              ;adjust the buffer pointer by the number of bytes read
5033 16BF              ;
5034 16BF              ;IMPORTANT NOTES:
5035 16BF              ;               drvr_req_cnt is always =< $0001FE00
5036 16BF              ;               users_buf_ptr is always < $00FFFFFF
5037 16BF              ;
5038 16BF 18                    clc   
5039 16C0 A5 C0                 lda   users_buf_ptr
5040 16C2 65 08                 adc   drvr_req_cnt
5041 16C4 85 C0                 sta   users_buf_ptr
5042 16C6 A5 C2                 lda   users_buf_ptr+2
5043 16C8 65 0A                 adc   drvr_req_cnt+2
5044 16CA 85 C2                 sta   users_buf_ptr+2
5045 16CC
5046 16CC              ;==========================================================================
5047 16CC              ;adjust the total number of bytes read from file
5048 16CC              ;
5049 16CC              ;IMPORTANT NOTES:
5050 16CC              ;               tran_cnt is always =< $00FFFFFF
5051 16CC              ;               drvr_req_cnt is always =< $0001FE00
5052 16CC              ;
5053 16CC              ;Carry is clear from the above addition.
5054 16CC
5055 16CC AD C7 05              lda   tran_cnt
5056 16CF 65 08                 adc   drvr_req_cnt
5057 16D1 8D C7 05              sta   tran_cnt
5058 16D4 AD C9 05              lda   tran_cnt+2
5059 16D7 65 0A                 adc   drvr_req_cnt+2
5060 16D9 8D C9 05              sta   tran_cnt+2
5061 16DC
5062 16DC              ;==========================================================================
5063 16DC              ;adjust the current file marker
5064 16DC              ;
5065 16DC              ;IMPORTANT NOTES:
5066 16DC              ;               curr_mark is always =< $00FFFFFF
5067 16DC              ;               drvr_req_cnt is always =< $0001FE00
5068 16DC              ;
5069 16DC
5070 16DC AD BF 05              lda   curr_mark
5071 16DF 65 08                 adc   drvr_req_cnt
5072 16E1 8D BF 05              sta   curr_mark
5073 16E4 AD C1 05              lda   curr_mark+2
5074 16E7 65 0A                 adc   drvr_req_cnt+2
5075 16E9 8D C1 05              sta   curr_mark+2
5076 16EC
5077 16EC              ;adjust the number of bytes remaining to send
5078 16EC
5079 16EC 38                    sec   
5080 16ED AD CB 05              lda   user_req_cnt
5081 16F0 E5 08                 sbc   drvr_req_cnt
5082 16F2 8D CB 05              sta   user_req_cnt
5083 16F5 AD CD 05              lda   user_req_cnt+2
5084 16F8 E5 0A                 sbc   drvr_req_cnt+2
5085 16FA 8D CD 05              sta   user_req_cnt+2
5086 16FD 60                    rts   
5087 16FE                       ENDP 
5088 16FE
5089 16FE              ;==========================================================================
5090 16FE              ;entry_to_offset This routine will convert the data from a directory
5091 16FE              ;               header to an offset.
5092 16FE              ;
5093 16FE              ;Input:         A = entry_number
5094 16FE              ;               X = undefined
5095 16FE              ;               Y = undefined
5096 16FE              ;               P = nvmxdizc
5097 16FE              ;                   ..000...
5098 16FE              ;               b = k
5099 16FE              ;
5100 16FE              ;
5101 16FE              ;Output:        A = entry_offset
5102 16FE              ;               X = undefined
5103 16FE              ;               Y = undefined
5104 16FE              ;               P = nvmxdizc
5105 16FE              ;                   ..000..1 = error
5106 16FE              ;                          0 = no error
5107 16FE              ;               b = k
5108 16FE              ;
5109 16FE              ;
5110 16FE              ;Uses:          All registers
5111 16FE
5112 16FE                       longa on
5113 16FE                       longi on
5114 16FE                       EXPORT entry_to_offset
5115 16FE              entry_to_offset PROC 
5116 16FE
5117 16FE 29 FF 00              and   #$00FF
5118 1701 3A                    dec   a
5119 1702 C9 0D 00              cmp   #$000D                   ;is it out of range?
5120 1705 B0 06                 bcs   error
5121 1707 0A                    asl   a
5122 1708 A8                    tay   
5123 1709 B9 CB 01              lda   dir_offset_tbl,y
5124 170C 18                    clc   
5125 170D              error                                   ;
5126 170D 60                    rts   
5127 170E
5128 170E                       ENDP 
5129 170E
5130 170E              ;======================================================================
5131 170E              ;Issue Mount:calls the Mount_Message Routine with a pointer to the name
5132 170E              ;            stored in Volume_name.
5133 170E              ;
5134 170E              ;Input:         A = undefined
5135 170E              ;               X = undefined
5136 170E              ;               Y = undefined
5137 170E              ;               P = nvmxdizc
5138 170E              ;                   ..000...
5139 170E              ;               b = k
5140 170E              ;
5141 170E              ;               volume_name             ;must be setup
5142 170E              ;
5143 170E              ;Output:        A = error code if carry set
5144 170E              ;               X = undefined
5145 170E              ;               Y = undefined
5146 170E              ;               P = nvmxdizc
5147 170E              ;                   ..000..1 = error
5148 170E              ;                          0 = no error
5149 170E              ;               b = k
5150 170E              ; 
5151 170E              ;Uses:          All registers
5152 170E              ;               Mount_Message
5153 170E              ;
5154 170E
5155 170E                       EXPORT issue_mount
5156 170E              issue_mount PROC 
5157 170E
5158 170E AD FB 04              lda   volume_name
5159 1711 EB                    xba   
5160 1712 8D FB 04              sta   volume_name
5161 1715
5162 1715 F4 02 00              pea   volume_name>>16
5163 1718 F4 FC 04              pea   volume_name+1            ;push a pointer to the volume name
5164 171B A9 01 00              lda   #$0001                   ;1 = manditory mount!
5165 171E 22 98 FC 01           jsl   mount_message
5166 1722 AA                    tax                            ;get the result code
5167 1723 AD FB 04              lda   volume_name
5168 1726 EB                    xba   
5169 1727 8D FB 04              sta   volume_name
5170 172A 8A                    txa                            ;restore result code 0 = ok 1 = cancel
5171 172B D0 02                 bne   cancel_mount
5172 172D
5173 172D 18                    clc                            ;user selected OK
5174 172E 60                    rts   
5175 172F
5176 172F              cancel_mount                            ;
5177 172F 38                    sec                            ;return volume not found error to user
5178 1730 A9 45 00              lda   #vol_not_found
5179 1733 60                    rts   
5180 1734                       ENDP 
5181 1734
5182 1734
5183 1734              ;======================================================================
5184 1734              ;Damaged_message: This routine will tell the user that the disk cannot
5185 1734              ;               be written too.  The routine will also jmp to the
5186 1734              ;               main exit routine.
5187 1734              ;
5188 1734              ;Input:         A = undefined
5189 1734              ;               X = undefined
5190 1734              ;               Y = undefined
5191 1734              ;               P = nvmxdizc
5192 1734              ;                   ..000...
5193 1734              ;               b = k
5194 1734              ;
5195 1734              ;
5196 1734              ;Output:        A = error code if carry set
5197 1734              ;               X = undefined
5198 1734              ;               Y = undefined
5199 1734              ;               P = nvmxdizc
5200 1734              ;                   ..000..1 = error
5201 1734              ;                          0 = no error
5202 1734              ;               b = k
5203 1734              ; 
5204 1734              ;Uses:          All registers
5205 1734              ;
5206 1734
5207 1734                       EXPORT damaged_message
5208 1734              damaged_message PROC 
5209 1734
5210 1734 48                    pha   
5211 1735 20 42 17              jsr   show_damage
5212 1738 22 6C FC 01           jsl   unlock_mem               ;release any memory
5213 173C 38                    sec   
5214 173D 68                    pla                            ;get the error code please
5215 173E 5C 40 FC 01           jml   sys_exit
5216 1742
5217 1742                       EXPORT show_damage
5218 1742              show_damage                             ;
5219 1742 20 67 17              jsr   setup_vol_mesg           ;move the name from the VCR to buffer
5220 1745
5221 1745 AD FB 04              lda   volume_name              ;make Gstring a Pstring
5222 1748 EB                    xba   
5223 1749 8D FB 04              sta   volume_name
5224 174C
5225 174C F4 03 00              pea   $0003                    ;message number three
5226 174F F4 02 00              pea   volume_name>>16
5227 1752 F4 FC 04              pea   volume_name+1            ;push a pointer to the volume name.
5228 1755 F4 00 00              pea   $0000
5229 1758 F4 00 00              pea   $0000                    ;push dummy space.
5230 175B 22 94 FC 01           jsl   report_error
5231 175F
5232 175F AD FB 04              lda   volume_name              ;make Pstring a Gstring
5233 1762 EB                    xba   
5234 1763 8D FB 04              sta   volume_name
5235 1766 60                    rts   
5236 1767
5237 1767                       EXPORT setup_vol_mesg
5238 1767              setup_vol_mesg                          ;
5239 1767 A0 02 00              ldy   #vcr_name                ;index to Name VP
5240 176A B7 84                 lda   [my_vcr_ptr],y
5241 176C AA                    tax   
5242 176D C8                    iny   
5243 176E C8                    iny   
5244 176F B7 84                 lda   [my_vcr_ptr],y
5245 1771 A8                    tay   
5246 1772 22 38 FC 01           jsl   deref                    ;make a real pointer to vol name
5247 1776 86 98                 stx   temp_ptr
5248 1778 84 9A                 sty   temp_ptr+2
5249 177A
5250 177A A7 98                 lda   [temp_ptr]               ;get the length of the string
5251 177C A8                    tay   
5252 177D C8                    iny   
5253 177E              move_loop                               ;
5254 177E B7 98                 lda   [temp_ptr],y
5255 1780 99 FB 04              sta   volume_name,y
5256 1783 88                    dey   
5257 1784 10 F8                 bpl   move_loop
5258 1786 60                    rts   
5259 1787
5260 1787                       ENDP 
5261 1787
5262 1787              ;======================================================================
5263 1787              ;read_with_mount:
5264 1787              ;               This routine with make a device read call and if an
5265 1787              ;               error occurs (other then the I/O error) the mount
5266 1787              ;               volume routine will be called.
5267 1787              ;
5268 1787              ;Input:         A = undefined
5269 1787              ;               X = undefined
5270 1787              ;               Y = undefined
5271 1787              ;               P = nvmxdizc
5272 1787              ;                   ..000...
5273 1787              ;               b = k
5274 1787              ;
5275 1787              ;               all parameters for the driver must be setup.
5276 1787              ;
5277 1787              ;Output:        A = error code if carry set
5278 1787              ;               X = undefined
5279 1787              ;               Y = undefined
5280 1787              ;               P = nvmxdizc
5281 1787              ;                   ..000..1 = error
5282 1787              ;                          0 = no error
5283 1787              ;               b = k
5284 1787              ; 
5285 1787              ;Uses:          All registers
5286 1787              ;               Device Dispatcher  (subroutine)
5287 1787              ;               device_call
5288 1787
5289 1787                       EXPORT read_with_mount
5290 1787              read_with_mount PROC 
5291 1787
5292 1787 A9 02 00              lda   #drvr_read
5293 178A 80 03                 bra   do_call
5294 178C
5295 178C                       EXPORT write_with_mount
5296 178C              write_with_mount  
5297 178C A9 03 00              lda   #drvr_write
5298 178F
5299 178F              do_call   
5300 178F 85 02                 sta   drvr_call_num
5301 1791 20 B8 17              jsr   dev_with_mount
5302 1794 60                    rts   
5303 1795                       ENDP 
5304 1795
5305 1795              ;======================================================================
5306 1795              ;read_with_cache:
5307 1795              ;write_with_cache:
5308 1795              ;               This routine with make a device read/write call and
5309 1795              ;               store the data in the system cache. error occurs
5310 1795              ;               (other then the I/O error) the mount volume routine
5311 1795              ;               will be called.
5312 1795              ;
5313 1795              ;Input:         A = undefined
5314 1795              ;               X = undefined
5315 1795              ;               Y = undefined
5316 1795              ;               P = nvmxdizc
5317 1795              ;                   ..000...
5318 1795              ;               b = k
5319 1795              ;
5320 1795              ;               all parameters for the driver must be setup.
5321 1795              ;
5322 1795              ;Output:        A = error code if carry set
5323 1795              ;               X = undefined
5324 1795              ;               Y = undefined
5325 1795              ;               P = nvmxdizc
5326 1795              ;                   ..000..1 = error
5327 1795              ;                          0 = no error
5328 1795              ;               b = k
5329 1795              ; 
5330 1795              ;Uses:          All registers
5331 1795              ;               Device Dispatcher  (subroutine)
5332 1795              ;               device_call
5333 1795
5334 1795                       EXPORT read_with_cache
5335 1795              read_with_cache PROC 
5336 1795
5337 1795 A9 02 00              lda   #drvr_read
5338 1798 80 03                 bra   continue
5339 179A
5340 179A                       EXPORT write_with_cache
5341 179A              write_with_cache                        ;
5342 179A A9 03 00              lda   #drvr_write
5343 179D
5344 179D              continue                                ;
5345 179D 85 02                 sta   drvr_call_num
5346 179F
5347 179F A7 84                 lda   [my_vcr_ptr]             ;setup the Volume ID field
5348 17A1 85 18                 sta   drvr_vol_id
5349 17A3
5350 17A3 A5 1A                 lda   drvr_cache               ;save current cache setting
5351 17A5 48                    pha   
5352 17A6 A9 02 80              lda   #in_cache                ;store this block in the cache
5353 17A9 85 1A                 sta   drvr_cache
5354 17AB
5355 17AB 20 B8 17              jsr   dev_with_mount
5356 17AE 08                    php                            ;save processor status 'A' = error code
5357 17AF AA                    tax                            ;save any error code
5358 17B0 A3 02                 lda   2,s                      ;restore old cache value
5359 17B2 85 1A                 sta   drvr_cache
5360 17B4 8A                    txa   
5361 17B5 28                    plp                            ;restore carry bit
5362 17B6 FA                    plx                            ;fix the stack
5363 17B7 60                    rts   
5364 17B8
5365 17B8                       ENDP 
5366 17B8
5367 17B8
5368 17B8              ;======================================================================
5369 17B8              ;dev_with_mount This routine with make a device call and if an
5370 17B8              ;               error occurs (other then the I/O error) the mount
5371 17B8              ;               volume routine will be called.
5372 17B8              ;
5373 17B8              ;Input:         A = undefined
5374 17B8              ;               X = undefined
5375 17B8              ;               Y = undefined
5376 17B8              ;               P = nvmxdizc
5377 17B8              ;                   ..000...
5378 17B8              ;               b = k
5379 17B8              ;
5380 17B8              ;               all parameters for the driver must be setup.
5381 17B8              ;
5382 17B8              ;Output:        A = error code if carry set
5383 17B8              ;               X = undefined
5384 17B8              ;               Y = undefined
5385 17B8              ;               P = nvmxdizc
5386 17B8              ;                   ..000..1 = error
5387 17B8              ;                          0 = no error
5388 17B8              ;               b = k
5389 17B8              ; 
5390 17B8              ;Uses:          All registers
5391 17B8              ;               Device Dispatcher  (subroutine)
5392 17B8              ;               device_call
5393 17B8
5394 17B8                       EXPORT dev_with_mount
5395 17B8              dev_with_mount PROC 
5396 17B8
5397 17B8 20 D0 17              jsr   device_call
5398 17BB B0 01                 bcs   check_err
5399 17BD 60                    rts   
5400 17BE              check_err  
5401 17BE C9 2E 00              cmp   #drvr_disk_sw            ;is this a disk switch error?
5402 17C1 F0 07                 beq   do_find                  ;go and find the volume please
5403 17C3 C9 2F 00              cmp   #drvr_off_line           ;is the volume off-line?
5404 17C6 F0 02                 beq   do_find
5405 17C8 38                    sec   
5406 17C9 60                    rts                            ;This is some real error from the user
5407 17CA              do_find   
5408 17CA 20 2E 14              jsr   mount_volume
5409 17CD 90 E9                 bcc   dev_with_mount           ;re-issue the original call please.
5410 17CF 60                    rts                            ;return the error please
5411 17D0
5412 17D0                       ENDP 
5413 17D0
5414 17D0              ;======================================================================
5415 17D0              ;Device_call:calls the dispatcher and trys to read or write.  If the
5416 17D0              ;            call returns a disk switched error then the routine will
5417 17D0              ;            re-read the disk again. 
5418 17D0              ;
5419 17D0              ;Input:         A = undefined
5420 17D0              ;               X = undefined
5421 17D0              ;               Y = undefined
5422 17D0              ;               P = nvmxdizc
5423 17D0              ;                   ..000...
5424 17D0              ;               b = k
5425 17D0              ;
5426 17D0              ;               all parameters for the driver must be setup except for
5427 17D0              ;               drvr_blk_size and drvr_fst_num, these are setup by the
5428 17D0              ;               call. (ONLY if the call is a READ or WRITE) 
5429 17D0              ;          
5430 17D0              ;Output:        A = error code if carry set
5431 17D0              ;               X = undefined
5432 17D0              ;               Y = undefined
5433 17D0              ;               P = nvmxdizc
5434 17D0              ;                   ..000..1 = error
5435 17D0              ;                          0 = no error
5436 17D0              ;               b = k
5437 17D0              ; 
5438 17D0              ;Uses:          All registers
5439 17D0              ;               Device Dispatcher  (subroutine)
5440 17D0              ;
5441 17D0
5442 17D0                       EXPORT device_call
5443 17D0              device_call PROC 
5444 17D0
5445 17D0 A5 02                 lda   drvr_call_num
5446 17D2 C9 05 00              cmp   #drvr_status
5447 17D5 B0 1D                 bcs   to_device                ;just call the device
5448 17D7
5449 17D7 C9 03 00              cmp   #drvr_write
5450 17DA F0 09                 beq   is_write
5451 17DC
5452 17DC A5 1A                 lda   drvr_cache
5453 17DE 29 FF 7F              and   #$7FFF                   ;clear the deferred bit if not a write
5454 17E1 85 1A                 sta   drvr_cache
5455 17E3 80 08                 bra   do_it
5456 17E5              is_write  
5457 17E5 8D 07 03              sta   write_occurred           ;indicate that a write occured during this call
5458 17E8 A5 00                 lda   drvr_dev_num             ;save the device number that I have written too.
5459 17EA 8D 09 03              sta   write_dev_num
5460 17ED              do_it     
5461 17ED A9 00 02              lda   #blk_size
5462 17F0 85 14                 sta   drvr_blk_size
5463 17F2 64 12                 stz   drvr_blk_num+2
5464 17F4
5465 17F4              to_device  
5466 17F4 22 00 FC 01           jsl   dev_dispatcher           ;call the read routine
5467 17F8 60                    rts   
5468 17F9
5469 17F9                       ENDP 
5470 17F9
5471 17F9
5472 17F9              ;======================================================================
5473 17F9              ;flush_bitmap:  This routine forces a dirty bitmap to be written to
5474 17F9              ;               disk.  The bitmap will be written to disk only if the
5475 17F9              ;               file counter is equal to zero.
5476 17F9              ;
5477 17F9              ;force_bitmap:  same as flush_bitmap except the bitmap block is ALWAYS
5478 17F9              ;               flushed.
5479 17F9              ;
5480 17F9              ;Input:         A = undefined
5481 17F9              ;               X = undefined
5482 17F9              ;               Y = undefined
5483 17F9              ;               P = nvmxdizc
5484 17F9              ;                   ..000...
5485 17F9              ;               b = k
5486 17F9              ;
5487 17F9              ;               prodos_vcr_ptr
5488 17F9              ;               my_vcr_ptr
5489 17F9              ;
5490 17F9              ;Output:        A = error code if carry set
5491 17F9              ;               X = undefined
5492 17F9              ;               Y = undefined
5493 17F9              ;               P = nvmxdizc
5494 17F9              ;                   ..000..1 = error
5495 17F9              ;                          0 = no error
5496 17F9              ;               b = k
5497 17F9              ; 
5498 17F9              ;Uses:          All registers
5499 17F9              ;               drvr_buf_ptr
5500 17F9              ;               dev_with_mount
5501 17F9              ;
5502 17F9
5503 17F9                       longa on
5504 17F9                       longi on
5505 17F9
5506 17F9                       EXPORT flush_bitmap
5507 17F9              flush_bitmap PROC 
5508 17F9
5509 17F9 A0 25 00              ldy   #dirty_file_cnt          ;see if there open files on disk?
5510 17FC B7 88                 lda   [prodos_vcr_ptr],y
5511 17FE F0 02                 beq   force_bitmap             ;no open files so do flush.
5512 1800 18                    clc   
5513 1801 60                    rts                            ;just exit.
5514 1802
5515 1802                       EXPORT force_bitmap
5516 1802              force_bitmap                            ;This entry point force block to disk
5517 1802
5518 1802 A0 1F 00              ldy   #bitmap_dirty
5519 1805 B7 88                 lda   [prodos_vcr_ptr],y
5520 1807 F0 59                 beq   no_change
5521 1809
5522 1809              ;Get the device number first
5523 1809
5524 1809 A0 0C 00              ldy   #vcr_dev
5525 180C B7 84                 lda   [my_vcr_ptr],y
5526 180E 85 00                 sta   drvr_dev_num
5527 1810
5528 1810              ;We need to update the disk since the bitmap is corrupt
5529 1810              ;First we calculate the block number of the block to write
5530 1810
5531 1810 A0 13 00              ldy   #vol_bitmap_addr
5532 1813 B7 88                 lda   [prodos_vcr_ptr],y
5533 1815 A0 1D 00              ldy   #curr_bitmap
5534 1818 18                    clc   
5535 1819 77 88                 adc   [prodos_vcr_ptr],y
5536 181B 85 10                 sta   drvr_blk_num
5537 181D 64 12                 stz   drvr_blk_num+2
5538 181F
5539 181F              ;Get the address of where the bitmap block is located.
5540 181F              ;setup drvr_buf_ptr to point to the bitmap buffer
5541 181F
5542 181F 20 1A 16              jsr   setup_bitmap_ptr
5543 1822 86 04                 stx   drvr_buf_ptr
5544 1824 84 06                 sty   drvr_buf_ptr+2
5545 1826
5546 1826              ;setup the call to do a write
5547 1826
5548 1826              ;Force the request count to 512 bytes
5549 1826
5550 1826 A9 00 02              lda   #blk_size
5551 1829 85 08                 sta   drvr_req_cnt
5552 182B 64 0A                 stz   drvr_req_cnt+2
5553 182D
5554 182D              ;Call the device.
5555 182D 20 9A 17              jsr   write_with_cache
5556 1830 90 01                 bcc   clear_dirty
5557 1832 60                    rts   
5558 1833
5559 1833              clear_dirty                             ;
5560 1833 A0 1F 00              ldy   #bitmap_dirty
5561 1836 A9 00 00              lda   #$0000
5562 1839 97 88                 sta   [prodos_vcr_ptr],y
5563 183B
5564 183B A0 1D 00              ldy   #curr_bitmap             ;see if this is first free block.
5565 183E B7 88                 lda   [prodos_vcr_ptr],y
5566 1840
5567 1840 A0 1B 00              ldy   #avail_bitmap
5568 1843 D7 88                 cmp   [prodos_vcr_ptr],y
5569 1845 D0 1B                 bne   no_change
5570 1847 1A                    inc   a                        ;see if this is the last bitmap blk.
5571 1848 A0 17 00              ldy   #num_bitmap_blks
5572 184B D7 88                 cmp   [prodos_vcr_ptr],y
5573 184D B0 13                 bcs   no_change                ;this is the last bitmap block
5574 184F
5575 184F A0 FE 01              ldy   #$01FE                   ;we must check first free
5576 1852              chk_first_free                          ;
5577 1852 B7 04                 lda   [drvr_buf_ptr],y
5578 1854 D0 0C                 bne   no_change
5579 1856 88                    dey   
5580 1857 88                    dey   
5581 1858 10 F8                 bpl   chk_first_free           ;check the entire block please.
5582 185A
5583 185A A0 1B 00              ldy   #avail_bitmap            ;bump avail to next block please
5584 185D B7 88                 lda   [prodos_vcr_ptr],y
5585 185F 1A                    inc   a
5586 1860 97 88                 sta   [prodos_vcr_ptr],y
5587 1862
5588 1862              no_change                               ;
5589 1862 18                    clc   
5590 1863 60                    rts   
5591 1864                       ENDP 
5592 1864
5593 1864              ;==========================================================================
5594 1864              ;flush_file:    This routine will write any modified blocks to disk.
5595 1864              ;
5596 1864              ;Input:         A = dev_number
5597 1864              ;               X = undefined
5598 1864              ;               Y = undefined
5599 1864              ;               P = nvmxdizc
5600 1864              ;                   ..000...
5601 1864              ;               b = k
5602 1864              ;
5603 1864              ;               pro_fcr_ptr             (points to data to write)
5604 1864              ;               my_vcr_ptr              (points to main VCR)
5605 1864              ;
5606 1864              ;Output:        A = undefined
5607 1864              ;               X = undefined
5608 1864              ;               Y = undefined
5609 1864              ;               P = nvmxdizc
5610 1864              ;                   ..000...
5611 1864              ;               b = k
5612 1864              ;
5613 1864              ;Uses:          All registers
5614 1864
5615 1864                       longa on
5616 1864                       longi on
5617 1864
5618 1864
5619 1864                       EXPORT flush_file
5620 1864              flush_file PROC 
5621 1864 9C D5 05              stz   flush_entry              ;indicate that we should flush everything
5622 1867 80 0B                 bra   cont_flush
5623 1869
5624 1869                       Entry do_fast_flush            ;entry point used by the fast version of the flush call
5625 1869              do_fast_flush  
5626 1869 A9 01 00              lda   #1                       ;set flag
5627 186C 80 03                 bra   stuffit
5628 186E
5629 186E                       EXPORT flush_io_Buffer
5630 186E              flush_io_buffer  
5631 186E A9 FF FF              lda   #$FFFF                   ;do not flush the directory entry
5632 1871              stuffit   
5633 1871 8D D5 05              sta   flush_entry
5634 1874              cont_flush  
5635 1874 20 8D 15              jsr   standard_req
5636 1877
5637 1877              ;First lets call flush bitmap which will update the bitmap for us
5638 1877 20 F9 17              jsr   flush_bitmap
5639 187A B0 0E                 bcs   error_return             ;return the error directly
5640 187C
5641 187C              ;No we need to flush the file itself.  We only flush blocks that need to
5642 187C              ;be flushed.  We will always update the file entry.
5643 187C
5644 187C              flushed                                 ;
5645 187C
5646 187C A0 1F 00              ldy   #fcr_status              ;get the status bits
5647 187F B7 90                 lda   [pro_fcr_ptr],y
5648 1881 8D DB 05              sta   flush_flags
5649 1884 89 00 80              bit   #file_dirty              ;see if there is anything to update
5650 1887 D0 02                 bne   do_update
5651 1889 18                    clc   
5652 188A              error_return  
5653 188A 60                    rts                            ;file does not need to be updated
5654 188B
5655 188B              ;First lets see if we need to update the master index block.
5656 188B
5657 188B              do_update  
5658 188B 89 01 00              bit   #master_dirty
5659 188E F0 18                 beq   check_index
5660 1890
5661 1890 A0 3B 00              ldy   #master_blk_num          ;get the block number
5662 1893 B7 90                 lda   [pro_fcr_ptr],y
5663 1895 85 10                 sta   drvr_blk_num
5664 1897 F0 09                 beq   clear_master             ;master block is sparse so do not update disk
5665 1899
5666 1899 A6 B8                 ldx   master_ptr
5667 189B A4 BA                 ldy   master_ptr+2
5668 189D 20 B0 1A              jsr   flush_block
5669 18A0 B0 E8                 bcs   error_return             ;return the error code
5670 18A2
5671 18A2              clear_master                            ;
5672 18A2 A9 FE FF              lda   #master_clean
5673 18A5 20 C0 1A              jsr   clr_fcr_status           ;mark master block as clean
5674 18A8
5675 18A8              ;Update the index block if needed
5676 18A8
5677 18A8              check_index                             ;
5678 18A8 AD DB 05              lda   flush_flags
5679 18AB 89 02 00              bit   #index_dirty             ;is the index block dirty
5680 18AE F0 05                 beq   check_data
5681 18B0 20 B8 19              jsr   flush_index
5682 18B3 B0 D5                 bcs   error_return
5683 18B5
5684 18B5              ;Update the data block if needed.
5685 18B5
5686 18B5              check_data                              ;
5687 18B5 AD DB 05              lda   flush_flags
5688 18B8 89 04 00              bit   #data_dirty              ;is the data block dirty
5689 18BB F0 05                 beq   update_entry
5690 18BD 20 D2 19              jsr   flush_data_blk
5691 18C0 B0 C8                 bcs   error_return
5692 18C2
5693 18C2              update_entry  
5694 18C2 AD D5 05              lda   flush_entry              ;do we update the directory entry?
5695 18C5 F0 0F                 beq   @do_entry                ;yup, update the whole thing
5696 18C7 30 0B                 bmi   @just_data               ;no, just flush the data blocks
5697 18C9              ; else we're doing a fast flush call here.  flush dirty bitmap and
5698 18C9              ; dirty directory ('dirty' meaning that anything besides mod date
5699 18C9              ; and backup-bit have been changed).
5700 18C9 20 02 18              jsr   force_bitmap             ;force the bitmap update
5701 18CC AD DB 05              lda   flush_flags              ;is the directory dirty?
5702 18CF 89 08 00              bit   #dirEntry_dirty
5703 18D2 D0 02                 bne   @do_entry                ;yes, so just go ahead and do the full flush
5704 18D4              @just_data  
5705 18D4 18                    clc   
5706 18D5 60                    rts   
5707 18D6              @do_entry  
5708 18D6 A9 FF 7F              lda   #file_clean
5709 18D9 20 C0 1A              jsr   clr_fcr_status           ;mark master block as clean
5710 18DC              ;
5711 18DC              ;Now lets update the VCR count to indicate that the file is clean
5712 18DC              ;
5713 18DC AD DF 05              lda   dirty_cnt_changed
5714 18DF D0 12                 bne   @changed_once            ;have we adjusted the number already?
5715 18E1
5716 18E1 EE DF 05              inc   dirty_cnt_changed
5717 18E4 A0 25 00              ldy   #dirty_file_cnt
5718 18E7 B7 88                 lda   [prodos_vcr_ptr],y
5719 18E9 F0 08                 beq   @major_error
5720 18EB 3A                    dec   a
5721 18EC 97 88                 sta   [prodos_vcr_ptr],y
5722 18EE 20 F9 17              jsr   flush_bitmap             ;now go and update the bitmap
5723 18F1 B0 0C                 bcs   go_cannot_update
5724 18F3              @major_error  
5725 18F3              @changed_once  
5726 18F3 20 82 15              jsr   set_default_buf          ;use the system buffer
5727 18F6 20 8D 15              jsr   standard_req
5728 18F9 20 5C 1A              jsr   update_mod_time          ;make sure we use the correct time
5729 18FC
5730 18FC 20 6C 1A              jsr   get_parent               ;load the I/O buffer with directory blk
5731 18FF              go_cannot_update  
5732 18FF B0 7A                 bcs   to_cannot_update
5733 1901 20 8B 1A              jsr   verify_storage           ;verify storage type
5734 1904              ;
5735 1904              ;Change for final release 8/16/88
5736 1904              ;
5737 1904              ;
5738 1904              ; First we update the File Control Record to indicate the correct backup state
5739 1904              ;
5740 1904 A0 16 00              ldy   #fcr_disk_acc            ;update fcr along with dir entry
5741 1907 B7 90                 lda   [pro_fcr_ptr],y
5742 1909 09 20 00              ora   #backup_on
5743 190C 97 90                 sta   [pro_fcr_ptr],y
5744 190E              ;
5745 190E              ;Now we update the directory entry to indicate the correct backup state
5746 190E              ;
5747 190E A0 1E 00              ldy   #access_index            ;index to the access byte in a dir entry
5748 1911 B7 98                 lda   [temp_ptr],y
5749 1913 09 20 00              ora   #backup_on               ;set the backup bit before update of disk
5750 1916 97 98                 sta   [temp_ptr],y
5751 1918
5752 1918 B0 61                 bcs   to_cannot_update
5753 191A
5754 191A              ;If the file is a resource file then only update the modification time.
5755 191A              ;Otherwise update the entire directory entry.
5756 191A
5757 191A A0 06 00              ldy   #fcr_file_id
5758 191D B7 90                 lda   [pro_fcr_ptr],y
5759 191F A0 09 00              ldy   #fcr_key_blk
5760 1922 D7 90                 cmp   [pro_fcr_ptr],y
5761 1924 F0 1E                 beq   entry_ok                 ;file is not a resource file
5762 1926 20 ED 19              jsr   update_resource          ;update the resource header
5763 1929 B0 50                 bcs   to_cannot_update         ;cannot write info to disk!
5764 192B 20 82 15              jsr   set_default_buf          ;restore buffer pointer
5765 192E
5766 192E A0 19 00              ldy   #fcr_modified            ;index into FCR
5767 1931 B7 90                 lda   [pro_fcr_ptr],y
5768 1933 A0 21 00              ldy   #last_mod_index          ;index into directory block
5769 1936 97 98                 sta   [temp_ptr],y             ;update the directory entry
5770 1938 A0 1B 00              ldy   #fcr_modified+2
5771 193B B7 90                 lda   [pro_fcr_ptr],y
5772 193D A0 23 00              ldy   #last_mod_index+2
5773 1940 97 98                 sta   [temp_ptr],y
5774 1942 80 34                 bra   update_disk              ;now update the directory
5775 1944
5776 1944              ;Move the entire directory info then write the block back to disk.
5777 1944
5778 1944              entry_ok                                ;
5779 1944 A0 02 00              ldy   #fcr_storage
5780 1947 A7 98                 lda   [temp_ptr]
5781 1949 29 0F FF              and   #$FF0F                   ;clear current storage type
5782 194C 17 90                 ora   [pro_fcr_ptr],y          ;adjust the storage type
5783 194E 87 98                 sta   [temp_ptr]
5784 1950
5785 1950 A2 0D 00              ldx   #fcr_eof
5786 1953 A0 2F 00              ldy   #fcr_curr_eof            ;move the current EOF to disk EOF
5787 1956 B7 90                 lda   [pro_fcr_ptr],y
5788 1958 5A                    phy   
5789 1959 9B                    txy   
5790 195A 97 90                 sta   [pro_fcr_ptr],y
5791 195C E8                    inx   
5792 195D 7A                    ply   
5793 195E C8                    iny   
5794 195F B7 90                 lda   [pro_fcr_ptr],y
5795 1961 9B                    txy   
5796 1962 97 90                 sta   [pro_fcr_ptr],y
5797 1964
5798 1964 A0 1D 00              ldy   #fcr_header_ptr          ;start at the end
5799 1967 A2 25 00              ldx   #header_ptr_index
5800 196A
5801 196A              blast_loop                              ;
5802 196A B7 90                 lda   [pro_fcr_ptr],y
5803 196C 5A                    phy   
5804 196D 9B                    txy   
5805 196E 97 98                 sta   [temp_ptr],y
5806 1970 CA                    dex   
5807 1971 7A                    ply   
5808 1972 88                    dey   
5809 1973 C0 08 00              cpy   #fcr_file_type
5810 1976 D0 F2                 bne   blast_loop
5811 1978
5812 1978              update_disk   
5813 1978 20 9A 17              jsr   write_with_cache
5814 197B              to_cannot_update  
5815 197B B0 3A                 bcs   cannot_update
5816 197D
5817 197D A9 F7 FF              lda   #dirEntry_clean
5818 1980 20 C0 1A              jsr   clr_fcr_status           ;mark directory entry as clean
5819 1983
5820 1983 AD 1F 03              lda   close_flag               ;should we update the directories?
5821 1986 0D C9 01              ora   time_stamp_opt           ;check user's option for time stamp too
5822 1989 0D DB 05              ora   flush_flags              ;and which type of flush we're doing
5823 198C F0 28                 beq   dont_bother              ;no directory updates please
5824 198E
5825 198E A0 25 00              ldy   #header_ptr_index
5826 1991 B7 98                 lda   [temp_ptr],y
5827 1993 85 10                 sta   drvr_blk_num
5828 1995 C9 02 00              cmp   #vol_dir_start
5829 1998 F0 1C                 beq   dont_bother
5830 199A
5831 199A 20 95 17              jsr   read_with_cache
5832 199D B0 18                 bcs   cannot_update
5833 199F A0 27 00              ldy   #parent_index            ;get the parent block number
5834 19A2 B7 04                 lda   [drvr_buf_ptr],y
5835 19A4 8D 1B 03              sta   slug_block               ;save the block number
5836 19A7 A0 29 00              ldy   #par_entry_num
5837 19AA B7 04                 lda   [drvr_buf_ptr],y
5838 19AC 20 FE 16              jsr   entry_to_offset
5839 19AF 8D 1D 03              sta   slug_offset
5840 19B2 20 C8 1A              jsr   slug_ripple              ;do the slug ripple
5841 19B5 60                    rts   
5842 19B6
5843 19B6              dont_bother                             ;
5844 19B6 18                    clc   
5845 19B7              cannot_update                           ;
5846 19B7 60                    rts   
5847 19B8
5848 19B8                       EXPORT flush_index
5849 19B8              flush_index                             ;
5850 19B8 A0 39 00              ldy   #index_blk_num           ;get the block number
5851 19BB B7 90                 lda   [pro_fcr_ptr],y
5852 19BD 85 10                 sta   drvr_blk_num
5853 19BF F0 0A                 beq   clear_index              ;the block is sparse so don't write it!
5854 19C1 A6 B4                 ldx   index_ptr
5855 19C3 A4 B6                 ldy   index_ptr+2
5856 19C5 20 B0 1A              jsr   flush_block
5857 19C8 90 01                 bcc   clear_index
5858 19CA 60                    rts                            ;return the error code
5859 19CB
5860 19CB              clear_index                             ;
5861 19CB A9 FD FF              lda   #index_clean
5862 19CE 20 C0 1A              jsr   clr_fcr_status           ;mark master block as clean
5863 19D1 60                    rts   
5864 19D2
5865 19D2
5866 19D2                       EXPORT flush_data_blk
5867 19D2              flush_data_blk                          ;
5868 19D2 A0 37 00              ldy   #data_blk_num            ;get the block number
5869 19D5 B7 90                 lda   [pro_fcr_ptr],y
5870 19D7 85 10                 sta   drvr_blk_num
5871 19D9 F0 0A                 beq   clear_data               ;the block is sparse so don't write it to disk
5872 19DB
5873 19DB A6 B0                 ldx   data_ptr
5874 19DD A4 B2                 ldy   data_ptr+2
5875 19DF 20 B8 1A              jsr   flush_block2
5876 19E2 90 01                 bcc   clear_data
5877 19E4 60                    rts                            ;return the error code
5878 19E5
5879 19E5              clear_data                              ;
5880 19E5 A9 FB FF              lda   #data_clean
5881 19E8 20 C0 1A              jsr   clr_fcr_status           ;mark master block as clean
5882 19EB 18                    clc   
5883 19EC 60                    rts   
5884 19ED
5885 19ED              ;If we get here then we are updating a resource file.  So we need to update
5886 19ED              ;the resource header block with the following information.
5887 19ED              ;
5888 19ED              ;               Storage Type
5889 19ED              ;               key_block
5890 19ED              ;               blocks used
5891 19ED              ;               eof
5892 19ED              ;
5893 19ED
5894 19ED              update_resource                         ;
5895 19ED A5 10                 lda   drvr_blk_num             ;save the block number please
5896 19EF 48                    pha   
5897 19F0
5898 19F0 20 8D 15              jsr   standard_req
5899 19F3 20 82 15              jsr   set_default_buf
5900 19F6 E6 05                 inc   drvr_buf_ptr+1
5901 19F8 E6 05                 inc   drvr_buf_ptr+1           ;use the high block of the buffer!!!
5902 19FA
5903 19FA A0 06 00              ldy   #fcr_file_id             ;index to header block
5904 19FD B7 90                 lda   [pro_fcr_ptr],y
5905 19FF 85 10                 sta   drvr_blk_num             ;read in the block please
5906 1A01 20 95 17              jsr   read_with_cache
5907 1A04 B0 52                 bcs   end_res_update
5908 1A06
5909 1A06 A0 00 00              ldy   #fcr_res_num             ;which resource are we updating?
5910 1A09 B7 90                 lda   [pro_fcr_ptr],y
5911 1A0B EB                    xba                            ;make an index $0000 or $0100
5912 1A0C AA                    tax                            ;point to start of header
5913 1A0D
5914 1A0D A0 02 00              ldy   #fcr_storage             ;stoarge type of file
5915 1A10 B7 90                 lda   [pro_fcr_ptr],y
5916 1A12 4A                    lsr   a                        ;convert $10,$20,$30 -> $1,$2,$3
5917 1A13 4A                    lsr   a
5918 1A14 4A                    lsr   a
5919 1A15 4A                    lsr   a
5920 1A16 9B                    txy                            ;index to storage type
5921 1A17 97 04                 sta   [drvr_buf_ptr],y
5922 1A19 E8                    inx                            ;advance to key block
5923 1A1A
5924 1A1A A0 09 00              ldy   #fcr_key_blk
5925 1A1D B7 90                 lda   [pro_fcr_ptr],y
5926 1A1F 9B                    txy   
5927 1A20 97 04                 sta   [drvr_buf_ptr],y
5928 1A22 E8                    inx   
5929 1A23 E8                    inx                            ;advance to blocks used
5930 1A24
5931 1A24 A0 0B 00              ldy   #fcr_blks_used
5932 1A27 B7 90                 lda   [pro_fcr_ptr],y
5933 1A29 9B                    txy   
5934 1A2A 97 04                 sta   [drvr_buf_ptr],y
5935 1A2C E8                    inx   
5936 1A2D E8                    inx                            ;advance to EOF
5937 1A2E
5938 1A2E A0 2F 00              ldy   #fcr_curr_eof
5939 1A31 B7 90                 lda   [pro_fcr_ptr],y
5940 1A33 9B                    txy   
5941 1A34 97 04                 sta   [drvr_buf_ptr],y
5942 1A36 E8                    inx   
5943 1A37 A0 30 00              ldy   #fcr_curr_eof+1
5944 1A3A B7 90                 lda   [pro_fcr_ptr],y
5945 1A3C 9B                    txy   
5946 1A3D 97 04                 sta   [drvr_buf_ptr],y
5947 1A3F
5948 1A3F 20 9A 17              jsr   write_with_cache         ;Update the disk
5949 1A42 B0 14                 bcs   end_res_update
5950 1A44
5951 1A44 18                    clc   
5952 1A45 A0 03 00              ldy   #$0003                   ;index to the blocks used data
5953 1A48 B7 04                 lda   [drvr_buf_ptr],y
5954 1A4A A0 03 01              ldy   #$0103                   ;index to blocks used resource
5955 1A4D 77 04                 adc   [drvr_buf_ptr],y
5956 1A4F 69 01 00              adc   #$0001                   ;add in the header block
5957 1A52
5958 1A52 A0 13 00              ldy   #blks_used_index         ;index into directory block
5959 1A55 97 98                 sta   [temp_ptr],y             ;update the directory entry
5960 1A57 18                    clc   
5961 1A58              end_res_update  
5962 1A58 FA                    plx                            ;restore the block number
5963 1A59 86 10                 stx   drvr_blk_num
5964 1A5B 60                    rts   
5965 1A5C
5966 1A5C              ;==========================================================================
5967 1A5C              ;This routine reads the GS clock and stores the time in the modification
5968 1A5C              ;field of the current FCR.
5969 1A5C
5970 1A5C              update_mod_time                         ;
5971 1A5C 20 3C 0A              jsr   pack_time                ;time for mod date (X=low Y=high)
5972 1A5F 5A                    phy                            ;save high word
5973 1A60 A0 19 00              ldy   #fcr_modified
5974 1A63 8A                    txa   
5975 1A64 97 90                 sta   [pro_fcr_ptr],y
5976 1A66 C8                    iny   
5977 1A67 C8                    iny   
5978 1A68 68                    pla   
5979 1A69 97 90                 sta   [pro_fcr_ptr],y          ;update high word
5980 1A6B 60                    rts   
5981 1A6C
5982 1A6C              ;==========================================================================
5983 1A6C              ;This routine will read in the parent block for a FCR and update the
5984 1A6C              ;modification date.
5985 1A6C              ;
5986 1A6C              ;input:         pro_fcr_ptr             ;MUST be setup
5987 1A6C              ;
5988 1A6C              ;output:        carry = error
5989 1A6C              ;               temp_ptr                ;points to the file entry
5990 1A6C
5991 1A6C              get_parent                              ;
5992 1A6C A0 33 00              ldy   #fcr_parent
5993 1A6F B7 90                 lda   [pro_fcr_ptr],y          ;get the address of the directory blk
5994 1A71 85 10                 sta   drvr_blk_num
5995 1A73 20 95 17              jsr   read_with_cache          ;get the directory block please
5996 1A76 90 01                 bcc   block_loaded
5997 1A78 60                    rts   
5998 1A79
5999 1A79              block_loaded                            ;
6000 1A79 A0 35 00              ldy   #fcr_entry_offs          ;offset to directory entry
6001 1A7C B7 90                 lda   [pro_fcr_ptr],y
6002 1A7E 65 04                 adc   drvr_buf_ptr
6003 1A80 85 98                 sta   temp_ptr
6004 1A82 A9 00 00              lda   #$0000
6005 1A85 65 06                 adc   drvr_buf_ptr+2
6006 1A87 85 9A                 sta   temp_ptr+2
6007 1A89 18                    clc   
6008 1A8A 60                    rts   
6009 1A8B
6010 1A8B              ;==========================================================================
6011 1A8B              ;This routine verifies that the entry pointed to by 'temp_ptr' is a valid
6012 1A8B              ;ProDOS entry.  It verifies this by looking at the storage type.
6013 1A8B
6014 1A8B              verify_storage                          ;
6015 1A8B A7 98                 lda   [temp_ptr]               ;get stoarge/length byte
6016 1A8D 29 F0 00              and   #$00F0                   ;verify the storage type please
6017 1A90 C9 50 00              cmp   #resource_type
6018 1A93 F0 19                 beq   good_entry
6019 1A95 C9 10 00              cmp   #seedling_type
6020 1A98 F0 14                 beq   good_entry
6021 1A9A C9 20 00              cmp   #sapling_type
6022 1A9D F0 0F                 beq   good_entry
6023 1A9F C9 30 00              cmp   #tree_type
6024 1AA2 F0 0A                 beq   good_entry
6025 1AA4 C9 D0 00              cmp   #subdir_type
6026 1AA7 F0 05                 beq   good_entry
6027 1AA9
6028 1AA9 A9 51 00              lda   #dir_error               ;the directory must be damaged
6029 1AAC 38                    sec   
6030 1AAD 60                    rts   
6031 1AAE
6032 1AAE 18           good_entry clc   
6033 1AAF 60                    rts   
6034 1AB0
6035 1AB0              ;Force the block to disk
6036 1AB0
6037 1AB0              flush_block                             ;
6038 1AB0 86 04                 stx   drvr_buf_ptr
6039 1AB2 84 06                 sty   drvr_buf_ptr+2
6040 1AB4 20 9A 17              jsr   write_with_cache
6041 1AB7 60                    rts   
6042 1AB8              flush_block2                            ;
6043 1AB8 86 04                 stx   drvr_buf_ptr
6044 1ABA 84 06                 sty   drvr_buf_ptr+2
6045 1ABC 20 8C 17              jsr   write_with_mount
6046 1ABF 60                    rts   
6047 1AC0
6048 1AC0                       EXPORT clr_fcr_status
6049 1AC0              clr_fcr_status                          ;
6050 1AC0 A0 1F 00              ldy   #fcr_status
6051 1AC3 37 90                 and   [pro_fcr_ptr],y
6052 1AC5 97 90                 sta   [pro_fcr_ptr],y
6053 1AC7 60                    rts   
6054 1AC8
6055 1AC8                       ENDP 
6056 1AC8
6057 1AC8              ;==========================================================================
6058 1AC8              ;slug_ripple:   This routine will time stamp the parent directories for ALL
6059 1AC8              ;               operations that require writing to the directory.  This
6060 1AC8              ;               routine is SLOW and is very stupid on our type of system.
6061 1AC8              ;               It is put here for compatability only.
6062 1AC8              ;
6063 1AC8              ;Input:         A = undefined
6064 1AC8              ;               X = undefined
6065 1AC8              ;               Y = undefined
6066 1AC8              ;               P = nvmxdizc
6067 1AC8              ;                   ..000...
6068 1AC8              ;               b = k
6069 1AC8              ;
6070 1AC8              ;               drvr_buf_ptr            (points to the directory entry)
6071 1AC8              ;
6072 1AC8              ;Output:        A = error code if carry set
6073 1AC8              ;               X = undefined
6074 1AC8              ;               Y = undefined
6075 1AC8              ;               P = nvmxdizc
6076 1AC8              ;                   ..000...
6077 1AC8              ;               b = k
6078 1AC8              ;
6079 1AC8              ;Uses:          All registers
6080 1AC8              ;               device_dispatcher
6081 1AC8              ;
6082 1AC8                       longa on
6083 1AC8                       longi on
6084 1AC8
6085 1AC8                       EXPORT slug_ripple
6086 1AC8              slug_ripple PROC 
6087 1AC8
6088 1AC8 AD C9 01              lda   time_stamp_opt           ;are we time stamping at all?
6089 1ACB D0 02                 bne   do_stamp
6090 1ACD 18                    clc   
6091 1ACE 60                    rts   
6092 1ACF              do_stamp  
6093 1ACF A5 10                 lda   drvr_blk_num
6094 1AD1 48                    pha   
6095 1AD2 A5 04                 lda   drvr_buf_ptr
6096 1AD4 48                    pha   
6097 1AD5 A5 06                 lda   drvr_buf_ptr+2
6098 1AD7 48                    pha   
6099 1AD8
6100 1AD8 20 3C 0A              jsr   pack_time                ;get the time please
6101 1ADB
6102 1ADB 18                    clc   
6103 1ADC AD EB 02              lda   gbuf_addr
6104 1ADF 69 00 02              adc   #blk_size
6105 1AE2 85 04                 sta   drvr_buf_ptr
6106 1AE4 AD ED 02              lda   gbuf_addr+2
6107 1AE7 69 00 00              adc   #$0000
6108 1AEA 85 06                 sta   drvr_buf_ptr+2
6109 1AEC
6110 1AEC AD 1B 03              lda   slug_block               ;setup the block
6111 1AEF D0 03                 bne   @around
6112 1AF1 82 7E 00              brl   do_volume_mod            ;no slug block, so time stamp the volume please
6113 1AF4
6114 1AF4 85 10        @around  sta   drvr_blk_num
6115 1AF6
6116 1AF6              slug_loop  
6117 1AF6 20 95 17              jsr   read_with_cache          ;read in the block please
6118 1AF9 B0 6D                 bcs   end_slug_err
6119 1AFB
6120 1AFB AC 1D 03              ldy   slug_offset              ;offset to the entry
6121 1AFE B7 04                 lda   [drvr_buf_ptr],y
6122 1B00 29 F0 00              and   #$00F0                   ;check the storage type
6123 1B03 C9 D0 00              cmp   #subdir_type
6124 1B06 D0 5A                 bne   bad_slug_dir             ;sorry bud
6125 1B08
6126 1B08 98                    tya   
6127 1B09 18                    clc   
6128 1B0A 69 21 00              adc   #last_mod_index
6129 1B0D A8                    tay                            ;index to the last mod field
6130 1B0E AD 03 03              lda   pro_time                 ;Get the time we are going to stamp with
6131 1B11 97 04                 sta   [drvr_buf_ptr],y
6132 1B13 AD 05 03              lda   pro_time+2
6133 1B16 C8                    iny   
6134 1B17 C8                    iny   
6135 1B18 97 04                 sta   [drvr_buf_ptr],y
6136 1B1A
6137 1B1A                                                      ;new code added 3/15/91 CAE
6138 1B1A AC 1D 03              ldy   slug_offset              ;offset to the entry
6139 1B1D 98                    tya   
6140 1B1E 18                    clc   
6141 1B1F 69 1E 00              adc   #access_index
6142 1B22 A8                    tay                            ;index to the access field
6143 1B23 B7 04                 lda   [drvr_buf_ptr],y
6144 1B25 09 20 00              ora   #backup_on               ;set the backup bit
6145 1B28 97 04                 sta   [drvr_buf_ptr],y
6146 1B2A                                                      ;end of new code
6147 1B2A
6148 1B2A 20 9A 17              jsr   write_with_cache
6149 1B2D B0 39                 bcs   end_slug_err             ;a major error
6150 1B2F
6151 1B2F
6152 1B2F AD C9 01              lda   time_stamp_opt           ;are we walking to root?
6153 1B32 3A                    dec   a
6154 1B33 F0 32                 beq   end_slug                 ;not today.
6155 1B35
6156 1B35 18                    clc   
6157 1B36 AD 1D 03              lda   slug_offset              ;offset to the entry
6158 1B39 69 25 00              adc   #header_ptr_index        ;point to the header pointer please
6159 1B3C A8                    tay   
6160 1B3D B7 04                 lda   [drvr_buf_ptr],y
6161 1B3F C9 02 00              cmp   #vol_dir_start           ;is this the root?
6162 1B42 F0 2E                 beq   do_volume_mod            ;set the volume modification date
6163 1B44
6164 1B44 C5 10                 cmp   drvr_blk_num             ;is the block already loaded?
6165 1B46 F0 07                 beq   block_loaded             ;you bet-cha
6166 1B48 85 10                 sta   drvr_blk_num             ;next block to read
6167 1B4A 20 95 17              jsr   read_with_cache
6168 1B4D B0 19                 bcs   end_slug_err             ;sorry bud major error
6169 1B4F
6170 1B4F              block_loaded   
6171 1B4F A0 27 00              ldy   #parent_index
6172 1B52 B7 04                 lda   [drvr_buf_ptr],y
6173 1B54 85 10                 sta   drvr_blk_num             ;new block number
6174 1B56 C8                    iny   
6175 1B57 C8                    iny                            ;get the entry number
6176 1B58 B7 04                 lda   [drvr_buf_ptr],y
6177 1B5A 20 FE 16              jsr   entry_to_offset
6178 1B5D 8D 1D 03              sta   slug_offset              ;the new offset
6179 1B60 80 94                 bra   slug_loop                ;ripple to the top.
6180 1B62
6181 1B62              bad_slug_dir   
6182 1B62 A9 51 00              lda   #dir_error
6183 1B65 80 01                 bra   end_slug_err
6184 1B67
6185 1B67              end_slug   
6186 1B67 18                    clc   
6187 1B68
6188 1B68              end_slug_err  
6189 1B68 FA                    plx   
6190 1B69 86 06                 stx   drvr_buf_ptr+2
6191 1B6B FA                    plx   
6192 1B6C 86 04                 stx   drvr_buf_ptr
6193 1B6E FA                    plx   
6194 1B6F 86 10                 stx   drvr_blk_num
6195 1B71 60                    rts   
6196 1B72              ;
6197 1B72              ;Now lets go and time stamp the volume please
6198 1B72              ;
6199 1B72              do_volume_mod  
6200 1B72 A9 02 00              lda   #vol_dir_start           ;Setup the block number for the Root
6201 1B75 85 10                 sta   drvr_blk_num
6202 1B77 20 95 17              jsr   read_with_cache          ;read in the block please
6203 1B7A B0 EC                 bcs   end_slug_err             ;I hate it with this happens
6204 1B7C
6205 1B7C A0 16 00              ldy   #vol_mod_offset          ;offset to the Mod time field for the volume
6206 1B7F AD 03 03              lda   pro_time
6207 1B82 97 04                 sta   [drvr_buf_ptr],y
6208 1B84 C8                    iny   
6209 1B85 C8                    iny   
6210 1B86 AD 05 03              lda   pro_time+2
6211 1B89 97 04                 sta   [drvr_buf_ptr],y         ;store the time
6212 1B8B
6213 1B8B                                                      ;new code added 3/15/91 CAE
6214 1B8B A0 22 00              ldy   #vol_acc_offset          ;offset to the access field
6215 1B8E B7 04                 lda   [drvr_buf_ptr],y
6216 1B90 09 20 00              ora   #backup_on               ;set the backup bit on disk
6217 1B93 97 04                 sta   [drvr_buf_ptr],y
6218 1B95                                                      ;end of new code
6219 1B95
6220 1B95 A0 02 00              ldy   #vol_mod                 ;update the VCR as well as the disk
6221 1B98 AD 03 03              lda   pro_time
6222 1B9B 97 88                 sta   [prodos_vcr_ptr],y
6223 1B9D C8                    iny   
6224 1B9E C8                    iny   
6225 1B9F AD 05 03              lda   pro_time+2
6226 1BA2 97 88                 sta   [prodos_vcr_ptr],y
6227 1BA4
6228 1BA4                                                      ;new code added 4/4/91 CAE
6229 1BA4 A0 0E 00              ldy   #vol_access              ;offset to the access field
6230 1BA7 B7 88                 lda   [prodos_vcr_ptr],y
6231 1BA9 09 20 00              ora   #backup_on               ;set the backup bit in the VCR
6232 1BAC 97 88                 sta   [prodos_vcr_ptr],y       ;so that the disk and VCR match
6233 1BAE                                                      ;end of new code
6234 1BAE
6235 1BAE 20 9A 17              jsr   write_with_cache
6236 1BB1 B0 B5                 bcs   end_slug_err             ;a major error
6237 1BB3 80 B2                 bra   end_slug                 ;no error, all is wonderful
6238 1BB5                       ENDP 
6239 1BB5
6240 1BB5              ;==========================================================================
6241 1BB5              ;extend_subdir  This routine will extend a directory if needed.
6242 1BB5              ;
6243 1BB5              ;input:         free_dir_blk            ;dir blk with a empty entry.
6244 1BB5              ;               dir_start_blk           ;starting block of the directory
6245 1BB5              ;               dir_last_blk            ;last block of the directory
6246 1BB5              ;
6247 1BB5              ;output:        free_dir_blk            ;dir blk with a empty entry.
6248 1BB5              ;               free_dir_offset         ;offset to directory entry within block
6249 1BB5              ;               dir_start_blk           ;starting block of the directory
6250 1BB5              ;               dir_last_blk            ;last block of the directory
6251 1BB5              ;
6252 1BB5
6253 1BB5                       longa on
6254 1BB5                       longi on
6255 1BB5
6256 1BB5                       EXPORT extend_subdir
6257 1BB5              extend_subdir PROC 
6258 1BB5                       with expand_record
6259 1BB5
6260 1BB5 2C 3E 08              bit   expand_file              ;are we adding a directory entry?
6261 1BB8 30 40                 bmi   good_exit                ;if we are expanding a file we donot need to extend the
6262 1BBA                                                      ;directory
6263 1BBA
6264 1BBA AD E5 04              lda   free_dir_blk             ;is there a free entry for this file?
6265 1BBD D0 3B                 bne   good_exit                ;do not extend the directory
6266 1BBF
6267 1BBF AD E1 04              lda   dir_start_blk
6268 1BC2 C9 02 00              cmp   #vol_dir_start           ;is this the root directory?
6269 1BC5 D0 05                 bne   not_root
6270 1BC7
6271 1BC7 A9 49 00              lda   #vol_dir_full            ;return an error please
6272 1BCA 38                    sec   
6273 1BCB 60                    rts   
6274 1BCC
6275 1BCC              not_root                                ;
6276 1BCC A9 01 00              lda   #$0001                   ;allocate one block for directory.
6277 1BCF AE E3 04              ldx   dir_last_blk             ;start looking here for next block
6278 1BD2 20 40 0D              jsr   find_Free_blks           ;go and get one
6279 1BD5 B0 24                 bcs   error_out                ;error out
6280 1BD7 86 10                 stx   drvr_blk_num             ;this is the new directory block
6281 1BD9
6282 1BD9 8E E5 04              stx   free_dir_blk             ;new block number
6283 1BDC A9 04 00              lda   #$0004                   ;index to first free entry
6284 1BDF 8D E7 04              sta   free_dir_offset
6285 1BE2
6286 1BE2 20 82 15              jsr   set_default_buf          ;use the genaral buffer
6287 1BE5 20 8D 15              jsr   standard_req             ;512 byte write
6288 1BE8 20 9A 1C              jsr   clear_dir_buf            ;clear the 512 byte general buffer
6289 1BEB 20 91 1C              jsr   append_last_blk
6290 1BEE B0 0B                 bcs   error_out                ;major problem
6291 1BF0 20 77 1C              jsr   update_forw_lnk          ;update forward link to new block
6292 1BF3 B0 06                 bcs   error_out
6293 1BF5 20 FC 1B              jsr   update_parent            ;update parents blocks used count
6294 1BF8 B0 01                 bcs   error_out
6295 1BFA              good_exit                               ;
6296 1BFA 18                    clc   
6297 1BFB              error_out                               ;
6298 1BFB 60                    rts                            ;extend complete
6299 1BFC
6300 1BFC              ;==========================================================================
6301 1BFC              ;Update_parent: This routine will update the blocks used and last mod date
6302 1BFC              ;               of the parent entry for the directory.
6303 1BFC
6304 1BFC              update_parent                           ;
6305 1BFC AD E1 04              lda   dir_start_blk
6306 1BFF 85 10                 sta   drvr_blk_num             ;key block for directory
6307 1C01 20 95 17              jsr   read_with_cache
6308 1C04 B0 6B                 bcs   exit_update
6309 1C06
6310 1C06 A0 27 00              ldy   #parent_index
6311 1C09 B7 94                 lda   [gbuf_ptr],y             ;get the parent block number
6312 1C0B 85 10                 sta   drvr_blk_num
6313 1C0D
6314 1C0D A0 29 00              ldy   #par_entry_num
6315 1C10 B7 94                 lda   [gbuf_ptr],y
6316 1C12 29 FF 00              and   #$00FF                   ;get the number
6317 1C15 3A                    dec   a
6318 1C16 C9 0D 00              cmp   #$000D                   ;number of entries
6319 1C19 B0 57                 bcs   bad_dir_bud
6320 1C1B 0A                    asl   a                        ;times 2 for a word table
6321 1C1C A8                    tay   
6322 1C1D B9 CB 01              lda   dir_offset_tbl,y
6323 1C20 8D 7B 05              sta   entry_offset             ;save offset to dir entry
6324 1C23
6325 1C23 20 95 17              jsr   read_with_cache          ;read in the parent block
6326 1C26 B0 49                 bcs   exit_update
6327 1C28 AC 7B 05              ldy   entry_offset
6328 1C2B B7 94                 lda   [gbuf_ptr],y
6329 1C2D 29 F0 00              and   #$00F0                   ;is this a subdir entry?
6330 1C30 C9 D0 00              cmp   #subdir_type
6331 1C33 D0 3D                 bne   bad_dir_bud
6332 1C35
6333 1C35 BB                    tyx   
6334 1C36
6335 1C36 18                    clc   
6336 1C37 98                    tya   
6337 1C38 69 13 00              adc   #$0013                   ;index to blocks used for file
6338 1C3B A8                    tay   
6339 1C3C B7 94                 lda   [gbuf_ptr],y
6340 1C3E 1A                    inc   a
6341 1C3F 97 94                 sta   [gbuf_ptr],y
6342 1C41 C8                    iny   
6343 1C42 C8                    iny                            ;point to EOF
6344 1C43
6345 1C43 18                    clc   
6346 1C44 B7 94                 lda   [gbuf_ptr],y
6347 1C46 69 00 02              adc   #blk_size
6348 1C49 97 94                 sta   [gbuf_ptr],y             ;add 512 to the EOF field
6349 1C4B 90 0B                 bcc   good_eof
6350 1C4D C8                    iny   
6351 1C4E C8                    iny                            ;point to the third byte of EOF
6352 1C4F                       longa off
6353 1C4F E2 20                 sep   #$20                     ;short A
6354 1C51 B7 94                 lda   [gbuf_ptr],y
6355 1C53 1A                    inc   a
6356 1C54 97 94                 sta   [gbuf_ptr],y
6357 1C56                       longa on
6358 1C56 C2 20                 rep   #$20
6359 1C58
6360 1C58              good_eof                                ;
6361 1C58 18                    clc   
6362 1C59 8A                    txa   
6363 1C5A 69 21 00              adc   #$0021                   ;index to mod time
6364 1C5D 48                    pha   
6365 1C5E 20 3C 0A              jsr   pack_time
6366 1C61 7A                    ply                            ;index
6367 1C62 AD 03 03              lda   pro_time
6368 1C65 97 94                 sta   [gbuf_ptr],y             ;update mod time
6369 1C67 C8                    iny   
6370 1C68 C8                    iny   
6371 1C69 AD 05 03              lda   pro_time+2
6372 1C6C 97 94                 sta   [gbuf_ptr],y
6373 1C6E
6374 1C6E 20 9A 17              jsr   write_with_cache
6375 1C71              exit_update                             ;
6376 1C71 60                    rts   
6377 1C72
6378 1C72              bad_dir_bud                             ;
6379 1C72 A9 51 00              lda   #dir_error               ;bad directory block
6380 1C75 38                    sec   
6381 1C76 60                    rts   
6382 1C77
6383 1C77
6384 1C77              ;==========================================================================
6385 1C77              ;update_forw..  This routine will link the new directory block just
6386 1C77              ;               allocated to the current last block of the directory.
6387 1C77
6388 1C77              update_forw_lnk                         ;
6389 1C77 AD E3 04              lda   dir_last_blk
6390 1C7A 85 10                 sta   drvr_blk_num             ;now read in the directory block.
6391 1C7C 20 95 17              jsr   read_with_cache
6392 1C7F B0 0F                 bcs   forw_exit                ;major problems. sorry about droppings!
6393 1C81
6394 1C81 A0 02 00              ldy   #$0002                   ;index to next pointer
6395 1C84 B7 94                 lda   [gbuf_ptr],y
6396 1C86 D0 EA                 bne   bad_dir_bud
6397 1C88 AD E5 04              lda   free_dir_blk             ;forward link directory block.
6398 1C8B 97 94                 sta   [gbuf_ptr],y
6399 1C8D 20 9A 17              jsr   write_with_cache
6400 1C90 60           forw_exit rts   
6401 1C91
6402 1C91              ;==========================================================================
6403 1C91              ;append_last..  This routine will link the new block to the previous
6404 1C91              ;               block in the directory.
6405 1C91
6406 1C91              append_last_blk                         ;
6407 1C91 AD E3 04              lda   dir_last_blk             ;setup the backward link
6408 1C94 87 94                 sta   [gbuf_ptr]
6409 1C96 20 9A 17              jsr   write_with_cache
6410 1C99 60                    rts   
6411 1C9A
6412 1C9A              clear_dir_buf                           ;
6413 1C9A A0 FE 01              ldy   #$01FE                   ;clear the general work buffer
6414 1C9D A9 00 00              lda   #$0000
6415 1CA0
6416 1CA0              clear_dir                               ;
6417 1CA0 97 94                 sta   [gbuf_ptr],y
6418 1CA2 88                    dey   
6419 1CA3 88                    dey   
6420 1CA4 10 FA                 bpl   clear_dir                ;every body happy now!
6421 1CA6 60                    rts   
6422 1CA7
6423 1CA7                       ENDP 
6424 1CA7
6425 1CA7
6426 1CA7              ;==========================================================================
6427 1CA7              ;Chk_swapped:   This routine will determine if the volume has been swapped
6428 1CA7              ;               If the volume has been swapped then we will request the
6429 1CA7              ;               user to put the volume back online.
6430 1CA7              ;
6431 1CA7              ;Input:         A = undefined
6432 1CA7              ;               X = undefined
6433 1CA7              ;               Y = undefined
6434 1CA7              ;               P = nvmxdizc
6435 1CA7              ;                   ..000...
6436 1CA7              ;               b = k
6437 1CA7              ;
6438 1CA7              ;               my_vcr_ptr              ;pointer to vcr
6439 1CA7              ;
6440 1CA7              ;Output:        A = error code if carry set
6441 1CA7              ;               X = undefined
6442 1CA7              ;               Y = undefined
6443 1CA7              ;               P = nvmxdizc
6444 1CA7              ;                   ..000..1 = error
6445 1CA7              ;                          0 = no error
6446 1CA7              ;               b = k
6447 1CA7              ; 
6448 1CA7              ;Uses:          All registers
6449 1CA7              ;               temp_ptr
6450 1CA7              ;               volume_name
6451 1CA7              ;               find_volume
6452 1CA7              ;
6453 1CA7                       longa on
6454 1CA7                       longi on
6455 1CA7
6456 1CA7                       EXPORT chk_swapped
6457 1CA7              chk_swapped PROC 
6458 1CA7
6459 1CA7              ;Now we have all of our data setup for the read.  Now we need to see if
6460 1CA7              ;the volume has been swapped out.  If it has then we must go and find
6461 1CA7              ;it again.
6462 1CA7
6463 1CA7 A0 06 00              ldy   #vcr_status
6464 1CAA B7 84                 lda   [my_vcr_ptr],y
6465 1CAC 29 00 40              and   #vcr_swapped             ;disk logged out?
6466 1CAF F0 26                 beq   disk_back
6467 1CB1
6468 1CB1              ;Little Bo-Peep-Show has lost her disk and doesn't know where to find it!
6469 1CB1              ;Therefore we will go and find it for her.
6470 1CB1
6471 1CB1 A0 02 00              ldy   #vcr_name
6472 1CB4 B7 84                 lda   [my_vcr_ptr],y
6473 1CB6 AA                    tax   
6474 1CB7 C8                    iny   
6475 1CB8 C8                    iny   
6476 1CB9 B7 84                 lda   [my_vcr_ptr],y
6477 1CBB A8                    tay   
6478 1CBC 22 38 FC 01           jsl   deref
6479 1CC0 86 98                 stx   temp_ptr
6480 1CC2 84 9A                 sty   temp_ptr+2
6481 1CC4
6482 1CC4              ;Now we have a pointer to the name but we must move it to 'volume_name'
6483 1CC4
6484 1CC4 A7 98                 lda   [temp_ptr]
6485 1CC6 29 0F 00              and   #$000F
6486 1CC9 A8                    tay   
6487 1CCA 88                    dey   
6488 1CCB
6489 1CCB              move_name                               ;
6490 1CCB B7 98                 lda   [temp_ptr],y
6491 1CCD 99 FB 04              sta   volume_name,y
6492 1CD0 88                    dey   
6493 1CD1 10 F8                 bpl   move_name
6494 1CD3
6495 1CD3              ;Now that we have moved the name to volume_name buffer we need to call
6496 1CD3              ;'find_volume' and let it look for it.
6497 1CD3
6498 1CD3 20 2E 14              jsr   mount_volume
6499 1CD6 60                    rts   
6500 1CD7
6501 1CD7              disk_back                               ;
6502 1CD7 18                    clc   
6503 1CD8 60                    rts   
6504 1CD9                       ENDP 
6505 1CD9              ;======================================================================
6506 1CD9              ;ID.Disk:       This file contains the code that will id the media
6507 1CD9              ;               to determine if the media is in ProDOS/SOS format.
6508 1CD9              ;               If the disk is a ProDOS disk and there is no VCR then
6509 1CD9              ;               a new VCR will be generated for that disk.  If there is
6510 1CD9              ;               a VCR then it is marked active.
6511 1CD9              ;
6512 1CD9              ;Input:         A = device number
6513 1CD9              ;               X = undefined
6514 1CD9              ;               Y = undefined
6515 1CD9              ;               P = nvmxdizc
6516 1CD9              ;                   ..000...
6517 1CD9              ;               b = k
6518 1CD9              ;
6519 1CD9              ;Output:        A = error code if carry set
6520 1CD9              ;               X = undefined
6521 1CD9              ;               Y = undefined
6522 1CD9              ;               P = nvmxdizc
6523 1CD9              ;                   ..000..1 = error
6524 1CD9              ;                          0 = no error
6525 1CD9              ;               b = k
6526 1CD9              ;
6527 1CD9              ;               drvr_buf_ptr            ;points to storage/vol name field
6528 1CD9              ;                                       ;with storage type removed
6529 1CD9              ;Uses:          All registers
6530 1CD9              ;               Device Dispatcher  (subroutine)
6531 1CD9              ;               General I/O Buffer (1K buffer, I read 512 bytes)
6532 1CD9              ;
6533 1CD9              ;Diagram of pointers and memory segments
6534 1CD9              ;
6535 1CD9              ; (I/O Buffer)
6536 1CD9              ;  ___________
6537 1CD9              ; |           | <--- pointed to by 'drvr_buf_ptr'
6538 1CD9              ; |           | <---               'drvr_buf_ptr' later points to volume name
6539 1CD9              ; |___________|    |
6540 1CD9              ;                  |____ 'temp3_ptr' points to data AFTER volume name area
6541 1CD9              ;
6542 1CD9              ;
6543 1CD9              ;  (vcr)
6544 1CD9              ;  ___________ <-- pointed to by 'my_vcr_ptr'
6545 1CD9              ; |           |         ___________________
6546 1CD9              ; | vol name -|------> |___________________| <-- pointed to by 'Temp2_Ptr'
6547 1CD9              ; |           |
6548 1CD9              ; |           | 
6549 1CD9              ; |           |
6550 1CD9              ; |           | <-- pointed to by 'prodos_vcr_ptr'
6551 1CD9              ; |___________|
6552 1CD9              ;
6553 1CD9                       longa on
6554 1CD9                       longi on
6555 1CD9
6556 1CD9                       EXPORT id_disk
6557 1CD9              id_disk  PROC 
6558 1CD9
6559 1CD9 85 00                 sta   drvr_dev_num             ;driver number
6560 1CDB A9 02 00              lda   #drvr_read
6561 1CDE 85 02                 sta   drvr_call_num
6562 1CE0 A9 02 00              lda   #vol_dir_start           ;starting block of directory
6563 1CE3 85 10                 sta   drvr_blk_num
6564 1CE5 64 12                 stz   drvr_blk_num+2
6565 1CE7 20 8D 15              jsr   standard_req
6566 1CEA
6567 1CEA AE EB 02              ldx   gbuf_addr                ;setup pointer to general I/O buffer
6568 1CED AC ED 02              ldy   gbuf_addr+2
6569 1CF0 86 04                 stx   drvr_buf_ptr
6570 1CF2 84 06                 sty   drvr_buf_ptr+2
6571 1CF4
6572 1CF4 20 D0 17     try_again jsr   device_call             ;make a system call to drive
6573 1CF7 90 0C                 bcc   id_no_error
6574 1CF9              ;                                       ;error code in X already but it may
6575 1CF9              ;                                       ;change in the future.  currently
6576 1CF9              ;                                       ;all code is cast in jello 
6577 1CF9 29 FF 00              and   #$00FF                   ;clear the dispatcher error code
6578 1CFC F0 07                 beq   id_no_error              ;Dispatcher returning disk switched
6579 1CFE C9 2E 00              cmp   #drvr_disk_sw            ;was the disk switched?
6580 1D01 F0 F1                 beq   try_again
6581 1D03 38                    sec                            ;swapped out by device call routine
6582 1D04 60                    rts                            ;if the disk was switched 
6583 1D05
6584 1D05              ;======================================================================
6585 1D05              ;ID method used to determine disk is ProDOS format:
6586 1D05              ;
6587 1D05              ;(1)            read in block two (First directory block)
6588 1D05              ;(2)            backward link must be zero (first word)
6589 1D05              ;(3)            storage type must be $F (high nibble: byte $04)
6590 1D05              ;(4)            name length must be > $0 (low nibble: byte $04)
6591 1D05              ;(5)            name must be valid syntax
6592 1D05              ;(6)            minimum version must be $00 (byte $21)
6593 1D05              ;(7)            entry length must be $27 (SOS/ProDOS size)
6594 1D05              ;(8)            entries per block must be $0D
6595 1D05              ; 
6596 1D05              ;If the above information causes problems with other disks then I will
6597 1D05              ;read in the second block of the directory and verify that the link
6598 1D05              ;fields are correct.  This may cause a problem if there is no second
6599 1D05              ;block in the directory.  If this is the case then I will check the
6600 1D05              ;bitmap allocation for correctness.  If this fails then forget it.
6601 1D05              ;
6602 1D05              ;======================================================================
6603 1D05
6604 1D05 A7 04        id_no_error lda   [drvr_buf_ptr]        ;load backward link
6605 1D07 D0 55                 bne   bad_format
6606 1D09 A0 21 00              ldy   #$0021                   ;offset to minimum version
6607 1D0C B7 04                 lda   [drvr_buf_ptr],y
6608 1D0E 29 FF 00              and   #$00FF
6609 1D11 D0 4B                 bne   bad_format
6610 1D13
6611 1D13
6612 1D13              ;Now that we have checked both the backward link and version we now
6613 1D13              ;need to adjust the pointer to point to the storage/name length field
6614 1D13              ;within the block.
6615 1D13
6616 1D13 18                    clc   
6617 1D14 A5 04                 lda   drvr_buf_ptr
6618 1D16 69 04 00              adc   #$0004
6619 1D19 85 04                 sta   drvr_buf_ptr
6620 1D1B 90 02                 bcc   ar
6621 1D1D E6 06                 inc   drvr_buf_ptr+2
6622 1D1F
6623 1D1F              ar                                      ;
6624 1D1F A7 04                 lda   [drvr_buf_ptr]           ;load storage/name length
6625 1D21 A8                    tay   
6626 1D22 29 F0 00              and   #$00F0
6627 1D25 C9 F0 00              cmp   #$00F0                   ;is it a volume directory type?
6628 1D28 D0 34                 bne   bad_format
6629 1D2A 98                    tya   
6630 1D2B 29 0F 00              and   #$000F                   ;isolate file name length
6631 1D2E F0 2E                 beq   bad_format               ;must be $01 to $0F
6632 1D30 A8                    tay   
6633 1D31              ;
6634 1D31              ;Now we need to verify that the name is a valid ProDOS filename
6635 1D31              ;
6636 1D31
6637 1D31              loop      
6638 1D31 B7 04                 lda   [drvr_buf_ptr],y
6639 1D33 29 FF 00              and   #$00FF
6640 1D36 C9 41 00              cmp   #'A'
6641 1D39 90 16                 bcc   numeric
6642 1D3B C9 5B 00              cmp   #'Z'+1
6643 1D3E B0 1E                 bcs   bad_format
6644 1D40 88                    dey   
6645 1D41 D0 EE                 bne   loop
6646 1D43
6647 1D43              ;If we get here then we need to check both the entry length and
6648 1D43              ;entries per block.  If everything is OK then we will call a routine
6649 1D43              ;that will build a new vcr or mark the vcr as active
6650 1D43
6651 1D43              its_mine                                ;
6652 1D43 A0 1F 00              ldy   #$0023-4                 ;index to entry length
6653 1D46 B7 04                 lda   [drvr_buf_ptr],y
6654 1D48 C9 27 0D              cmp   #$0D27                   ;both entry length and entry per blk
6655 1D4B D0 11                 bne   bad_format
6656 1D4D 20 6A 1D              jsr   build_vcr                ;build a volume control record
6657 1D50 60                    rts                            ;note: error set be build_vcr
6658 1D51
6659 1D51              numeric                                 ;
6660 1D51 C9 30 00              cmp   #'0'
6661 1D54 90 0D                 bcc   period
6662 1D56 C9 3A 00              cmp   #'9'+1
6663 1D59 B0 03                 bcs   bad_format
6664 1D5B 88           continue dey   
6665 1D5C D0 D3                 bne   loop
6666 1D5E
6667 1D5E              bad_format                              ;
6668 1D5E A9 52 00              lda   #unknown_vol             ;I don't know what this disk is
6669 1D61 38                    sec   
6670 1D62 60                    rts   
6671 1D63
6672 1D63 C9 2E 00     period   cmp   #'.'
6673 1D66 D0 F6                 bne   bad_format
6674 1D68 80 F1                 bra   continue
6675 1D6A
6676 1D6A                       ENDP 
6677 1D6A
6678 1D6A              ;======================================================================
6679 1D6A              ;Build_VCR:     This routine will add a new VCR if one is currently not
6680 1D6A              ;               allocated, if the VCR is allocated then it will be
6681 1D6A              ;               marked as active.
6682 1D6A              ; 
6683 1D6A              ;Input:         A = undefined
6684 1D6A              ;               X = undefined
6685 1D6A              ;               Y = undefined
6686 1D6A              ;               P = nvmxdizc
6687 1D6A              ;                   ..000...
6688 1D6A              ;               b = k
6689 1D6A              ;
6690 1D6A              ;               drvr_buf_ptr            (points to volume header) 
6691 1D6A              ;               cp_device_flag = 1 if doing a ChangePath call and source is device #
6692 1D6A              ;
6693 1D6A              ;Output:        A = error code if carry set
6694 1D6A              ;               X = undefined
6695 1D6A              ;               Y = undefined
6696 1D6A              ;               P = nvmxdizc
6697 1D6A              ;                   ..000..1 = error
6698 1D6A              ;                          0 = no error
6699 1D6A              ;               b = k
6700 1D6A              ;
6701 1D6A              ;
6702 1D6A              ;Uses:          All registers
6703 1D6A              ;               find_vcr                (system subroutine)
6704 1D6A              ;               alloc_vcr               (system subroutine) 
6705 1D6A              ;               General I/O Buffer      (1K buffer, I read 512 bytes)
6706 1D6A              ; 
6707 1D6A                       longa on
6708 1D6A                       longi on
6709 1D6A
6710 1D6A                       EXPORT build_vcr
6711 1D6A              build_vcr PROC 
6712 1D6A
6713 1D6A 20 16 3E              jsr   move_vol_entry           ;move the entry to the work area
6714 1D6D 20 7C 1E              jsr   entry_to_gstr
6715 1D70
6716 1D70              ;
6717 1D70              ; If bit 15 of cp_flag is set, assume the source disk is a duplicate volume
6718 1D70              ; and fall into the code that handles duplicate volumes with open files.
6719 1D70              ; Since cp_device_flag is already set, it will cause a fake VCR to be allocated.
6720 1D70              ;                                       5-Dec-91 MSD
6721 1D70              ;
6722 1D70 2C E7 05              bit   cp_flags                 ; should we assume the disk is a duplicate?
6723 1D73 10 03                 bpl   @not_dup                 ; no, so do the usual
6724 1D75 82 54 00              brl   is_open                  ; yes, pretend duplicate volume with open files
6725 1D78              @not_dup  
6726 1D78
6727 1D78              ; End of 5-Dec-91 MSD change.
6728 1D78
6729 1D78              ;Call system routine to see if it can find a vcr with the same volume
6730 1D78              ;name.  If the accum contains a zero then the routine will will
6731 1D78              ;use x and y as a pointer to a volume name.  If the accum contains
6732 1D78              ;a non zero value then the routine will try to find a vcr with
6733 1D78              ;the same volume id.
6734 1D78
6735 1D78 A2 0F 05              ldx   #gstring                 ;pointer to the volume name
6736 1D7B A0 02 00              ldy   #^gstring
6737 1D7E A9 00 00              lda   #0000                    ;0000=search for vcr by name
6738 1D81 22 48 FC 01           jsl   find_vcr
6739 1D85 B0 5B                 bcs   no_vcr                   ;this name is not in any VCR
6740 1D87
6741 1D87 22 38 FC 01           jsl   deref                    ;convert virtual to real
6742 1D8B 86 84                 stx   my_vcr_ptr
6743 1D8D 84 86                 sty   my_vcr_ptr+2             ;setup pointer to VCR
6744 1D8F
6745 1D8F A0 0A 00              ldy   #vcr_fst_id
6746 1D92 B7 84                 lda   [my_vcr_ptr],y
6747 1D94 C9 01 00              cmp   #pro_id                  ;is this my vcr
6748 1D97 D0 2C                 bne   check_active             ;if not, can we kick it out?
6749 1D99
6750 1D99 20 95 15              jsr   setup_my_vcr             ;make a pointer to my vcr stuff
6751 1D9C 86 88                 stx   prodos_vcr_ptr
6752 1D9E 84 8A                 sty   prodos_vcr_ptr+2
6753 1DA0
6754 1DA0 24 16                 bit   drvr_fst_num             ;are we looking at name only?
6755 1DA2 30 0D                 bmi   name_only                ;yes.
6756 1DA4
6757 1DA4 A0 15 00              ldy   #entry_length-18
6758 1DA7 B9 51 05     compare_loop lda   one_entry+16,y       ;we add 16 so we pass the name field
6759 1DAA D7 88                 cmp   [prodos_vcr_ptr],y
6760 1DAC D0 17                 bne   check_active
6761 1DAE 88                    dey   
6762 1DAF 10 F6                 bpl   compare_loop
6763 1DB1
6764 1DB1              name_only                               ;
6765 1DB1 A0 0C 00              ldy   #vcr_dev                 ;update the last known device
6766 1DB4 A5 00                 lda   drvr_dev_num
6767 1DB6 97 84                 sta   [my_vcr_ptr],y
6768 1DB8
6769 1DB8 20 71 1E              jsr   activate_vcr             ;mark the vcr as swapped in
6770 1DBB 20 CC 56              jsr   reset_vcr                ;reset blocks free etc.
6771 1DBE 18                    clc   
6772 1DBF 60                    rts   
6773 1DC0
6774 1DC0              sorry_dup                               ;
6775 1DC0 A9 57 00              lda   #dup_volume              ;duplicate volume online
6776 1DC3 38                    sec   
6777 1DC4 60                    rts   
6778 1DC5
6779 1DC5              ;If we get here it means that the volume name already exist in vcr.
6780 1DC5              ;So I need to see if there are any open files on the volume.  If there
6781 1DC5              ;are no open files then I can kick the current vcr out of memory and
6782 1DC5              ;build a new one.  If there are open files then I will return a
6783 1DC5              ;duplicate volume error.  Note:  I check to make sure that the volume
6784 1DC5              ;header has not changed.  This protects me from marking a volume as
6785 1DC5              ;being swapped in and writing to it blindly if it has the same name.
6786 1DC5
6787 1DC5              ; Note - If we get a duplicate volume error and cp_device_flag = 1 then ignore
6788 1DC5              ;        the error since we are doing a ChangePath call with a device # as the source.
6789 1DC5              ;        1/22/91 CAE
6790 1DC5
6791 1DC5              check_active                            ;
6792 1DC5              ;	ldy	#vcr_open_cnt
6793 1DC5              ;	lda	[my_vcr_ptr],y
6794 1DC5              ;	bne	sorry_dup	;files open so don't log in new volume
6795 1DC5              ;	jsr	free_vcr	;free vcr pointed to by 'my_vcr_ptr'
6796 1DC5
6797 1DC5 A0 08 00              ldy   #vcr_open_cnt
6798 1DC8 B7 84                 lda   [my_vcr_ptr],y           ;any open files?
6799 1DCA F0 13                 beq   not_open                 ;no
6800 1DCC              is_open                                 ;Added 5-Dec-91 MSD
6801 1DCC AD E5 05              lda   cp_device_flag           ;are we doing a special ChangePath call?
6802 1DCF F0 EF                 beq   sorry_dup                ;no - so report a duplicate volume error
6803 1DD1 09 00 80              ora   #$8000                   ;yes - so indicate we got a dup vol error
6804 1DD4 8D E5 05              sta   cp_device_flag
6805 1DD7 A5 00                 lda   <drvr_dev_num            ; 5-Feb-92 MSD: Force other VCR's for this
6806 1DD9 22 34 FC 01           jsl   swap_out                 ; 5-Feb-92 MSD: to be swapped out.
6807 1DDD 80 03                 bra   no_vcr                   ;and continue
6808 1DDF
6809 1DDF 20 71 0E     not_open jsr   free_vcr                 ;free vcr pointed to by 'my_vcr_ptr'
6810 1DE2
6811 1DE2              ;below begins the grunt work.  we now have to allocate a new vcr and
6812 1DE2              ;setup all are fields. 
6813 1DE2
6814 1DE2              ; Note - If cp_device_flag = $8001 then we need to use a fake name for the VCR 
6815 1DE2              ;        since we got a duplicate volume error.  1/22/91 CAE
6816 1DE2
6817 1DE2 A2 0F 05     no_vcr   ldx   #gstring                 ;pointer to the name
6818 1DE5 A0 02 00              ldy   #^gstring
6819 1DE8 AD E5 05              lda   cp_device_flag           ;do we need to use fake name for vcr?
6820 1DEB 10 06                 bpl   @cont                    ;no
6821 1DED A2 E5 01              ldx   #fake_name_str           ;yes - so point to fake name string
6822 1DF0 A0 02 00              ldy   #^fake_name_str
6823 1DF3 A9 37 02     @cont    lda   #pro_vcr_size            ;number of bytes to allocate
6824 1DF6 22 24 FC 01           jsl   alloc_vcr
6825 1DFA 90 01                 bcc   alloc_ok
6826 1DFC 60                    rts                            ;exit with the error
6827 1DFD
6828 1DFD              alloc_ok                                ; ;now build my data structures
6829 1DFD 22 38 FC 01           jsl   deref                    ;convert virtual to real address
6830 1E01 86 84                 stx   my_vcr_ptr
6831 1E03 84 86                 sty   my_vcr_ptr+2
6832 1E05 20 95 15              jsr   setup_my_vcr             ;setup pointer to my data
6833 1E08 86 88                 stx   prodos_vcr_ptr
6834 1E0A 84 8A                 sty   prodos_vcr_ptr+2
6835 1E0C
6836 1E0C A0 0A 00              ldy   #vcr_fst_id              ;indicate that this vcr is owned by me.
6837 1E0F A9 01 00              lda   #pro_id
6838 1E12 97 84                 sta   [my_vcr_ptr],y
6839 1E14
6840 1E14 A0 0C 00              ldy   #vcr_dev                 ;convert to INY,INY
6841 1E17 A5 00                 lda   drvr_dev_num
6842 1E19 97 84                 sta   [my_vcr_ptr],y
6843 1E1B
6844 1E1B A0 06 00              ldy   #vcr_status
6845 1E1E A9 00 00              lda   #0000                    ;zero the status word
6846 1E21 97 84                 sta   [my_vcr_ptr],y
6847 1E23
6848 1E23 A0 17 00              ldy   #entry_length-16
6849 1E26 B9 51 05     entry_loop lda   one_entry+16,y
6850 1E29 97 88                 sta   [prodos_vcr_ptr],y
6851 1E2B 88                    dey   
6852 1E2C 10 F8                 bpl   entry_loop               ;move the entire directory entry
6853 1E2E
6854 1E2E              ;warning: if the 'BPL' instruction above changes, then the accum will
6855 1E2E              ;         have to be loaded with $FFFF directly.
6856 1E2E
6857 1E2E 98                    tya                            ;now init free blocks to $FFFF.  This
6858 1E2F A0 21 00              ldy   #free_blocks             ;indicates that free blks is unknown
6859 1E32 97 88                 sta   [prodos_vcr_ptr],y
6860 1E34 A0 1B 00              ldy   #avail_bitmap
6861 1E37 97 88                 sta   [prodos_vcr_ptr],y
6862 1E39 A0 1D 00              ldy   #curr_bitmap             ;indicate we don't know about these
6863 1E3C 97 88                 sta   [prodos_vcr_ptr],y
6864 1E3E
6865 1E3E              ;Now we need to calculate the number of bitmap blocks that are on
6866 1E3E              ;the volume.  We also calculate how many bytes in the last block must
6867 1E3E              ;by zero.  If these bytes are not zero then the bitmap is damaged 
6868 1E3E
6869 1E3E 64 AC                 stz   math_temp                ;setup for even multiple of 4K
6870 1E40 A0 15 00              ldy   #vol_total_blks          ;convert total blocks to number of
6871 1E43              ;                                       ;bitmap blocks on volume 
6872 1E43 B7 88                 lda   [prodos_vcr_ptr],y
6873 1E45 AA                    tax                            ;save total block count
6874 1E46 29 FF 0F              and   #$0FFF
6875 1E49 F0 02                 beq   calc_bitmap
6876 1E4B E6 AC                 inc   math_temp
6877 1E4D
6878 1E4D              calc_bitmap                             ;
6879 1E4D 8A                    txa   
6880 1E4E 29 00 F0              and   #$F000                   ;clear unwanted garbage
6881 1E51 2A                    rol   a
6882 1E52 2A                    rol   a
6883 1E53 2A                    rol   a
6884 1E54 2A                    rol   a
6885 1E55 2A                    rol   a
6886 1E56 65 AC                 adc   math_temp                ;add in for odd block size
6887 1E58 A0 17 00              ldy   #num_bitmap_blks
6888 1E5B 97 88                 sta   [prodos_vcr_ptr],y
6889 1E5D
6890 1E5D              even_bit                                ;
6891 1E5D 8A                    txa   
6892 1E5E 29 07 00              and   #$0007
6893 1E61 F0 03                 beq   found_even_bit           ;this is the block number we want
6894 1E63 E8                    inx                            ;add one to the block count
6895 1E64 80 F7                 bra   even_bit                 ;keep trying to find byte boundary
6896 1E66
6897 1E66              found_even_bit                          ;
6898 1E66 20 77 0B              jsr   calc_bit                 ;'Y' will equal byte index into blk
6899 1E69 98                    tya   
6900 1E6A A0 19 00              ldy   #end_bitmap              ;first byte in the bitmap that must be
6901 1E6D 97 88                 sta   [prodos_vcr_ptr],y
6902 1E6F              ;                                       ;set to zero in the last blk of bitmap
6903 1E6F 18                    clc   
6904 1E70 60                    rts   
6905 1E71                       ENDP 
6906 1E71
6907 1E71              ;======================================================================
6908 1E71              ;activate_vcr:  This routine will mark the vcr as being logged in
6909 1E71              ;
6910 1E71              ;Input:         A = undefined
6911 1E71              ;               X = undefined
6912 1E71              ;               Y = undefined
6913 1E71              ;               P = nvmxdizc
6914 1E71              ;                   ..000...
6915 1E71              ;               b = k
6916 1E71              ;
6917 1E71              ;               my_vcr_ptr              (Points to main VCR)
6918 1E71              ;
6919 1E71              ;Output:        A = undefined
6920 1E71              ;               X = undefined
6921 1E71              ;               Y = undefined
6922 1E71              ;               P = nvmxdizc
6923 1E71              ;                   ..000...
6924 1E71              ;               b = k
6925 1E71              ;                                       (the VCR is logged in)
6926 1E71              ;
6927 1E71              ;Uses:          All registers
6928 1E71              ;               my_vcr_ptr
6929 1E71              ; 
6930 1E71                       longa on
6931 1E71                       longi on
6932 1E71
6933 1E71                       EXPORT activate_vcr
6934 1E71              activate_vcr PROC 
6935 1E71
6936 1E71 A0 06 00              ldy   #vcr_status
6937 1E74 B7 84                 lda   [my_vcr_ptr],y
6938 1E76 29 FF BF              and   #vcr_swapped_in
6939 1E79 97 84                 sta   [my_vcr_ptr],y
6940 1E7B 60                    rts   
6941 1E7C                       ENDP 
6942 1E7C
6943 1E7C              ;======================================================================
6944 1E7C              ;Enrty_to_gstr  This routine moves the name from the alloc_entry to
6945 1E7C              ;               gstring buffer. It will also append a null.
6946 1E7C              ;
6947 1E7C              ;
6948 1E7C              ;Input:         A = undefined
6949 1E7C              ;               X = undefined
6950 1E7C              ;               Y = undefined
6951 1E7C              ;               P = nvmxdizc
6952 1E7C              ;                   ..000...
6953 1E7C              ;               b = k
6954 1E7C              ;
6955 1E7C              ;               alloc_entry             (contains the volume name)
6956 1E7C              ;
6957 1E7C              ;Output:        A = error code if carry set
6958 1E7C              ;               X = undefined
6959 1E7C              ;               Y = undefined
6960 1E7C              ;               P = nvmxdizc
6961 1E7C              ;                   ..000..1 = error
6962 1E7C              ;                          0 = no error
6963 1E7C              ;               b = k
6964 1E7C              ;
6965 1E7C              ;               gstring                 (contains gstring)
6966 1E7C              ;
6967 1E7C              ;Uses:          All registers
6968 1E7C              ;
6969 1E7C                       longa on
6970 1E7C                       longi on
6971 1E7C
6972 1E7C                       EXPORT entry_to_gstr
6973 1E7C              entry_to_gstr PROC 
6974 1E7C
6975 1E7C AC 40 05              ldy   alloc_entry              ;the length of the string
6976 1E7F C8                    iny   
6977 1E80 C8                    iny                            ;point to null field
6978 1E81 A9 00 00              lda   #$0000
6979 1E84 99 0F 05              sta   gstring,y                ;store the null
6980 1E87 88                    dey   
6981 1E88
6982 1E88 08                    php                            ;save current mode
6983 1E89                       longa off
6984 1E89 E2 20                 sep   #$20
6985 1E8B              loop                                    ; 
6986 1E8B B9 40 05              lda   alloc_entry,y
6987 1E8E 99 0F 05              sta   gstring,y
6988 1E91 88                    dey   
6989 1E92 10 F7                 bpl   loop
6990 1E94 28                    plp   
6991 1E95 60                    rts   
6992 1E96                       ENDP 
6993 1E96
6994 1E96
6995 1E96              ;======================================================================
6996 1E96              ;Find_volume:   This routine will locate a volume using the ID routine.
6997 1E96              ;
6998 1E96              ;
6999 1E96              ;Input:         A = undefined
7000 1E96              ;               X = undefined
7001 1E96              ;               Y = undefined
7002 1E96              ;               P = nvmxdizc
7003 1E96              ;                   ..000...
7004 1E96              ;               b = k
7005 1E96              ;
7006 1E96              ;               volume_name             (contains the volume name to find)
7007 1E96              ;
7008 1E96              ;Output:        A = error code if carry set
7009 1E96              ;               X = undefined
7010 1E96              ;               Y = undefined
7011 1E96              ;               P = nvmxdizc
7012 1E96              ;                   ..000..1 = error
7013 1E96              ;                          0 = no error
7014 1E96              ;               b = k
7015 1E96              ;
7016 1E96              ;
7017 1E96              ;Uses:          All registers
7018 1E96              ;               find_vcr                (system subroutine)
7019 1E96              ;               id_disk                 (subroutine)
7020 1E96              ;               General I/O Buffer      (1K buffer, I read 512 bytes)
7021 1E96              ;               volume_name
7022 1E96              ;               drvr_buf_ptr 
7023 1E96
7024 1E96                       longa on
7025 1E96                       longi on
7026 1E96
7027 1E96                       EXPORT find_volume
7028 1E96              find_volume PROC 
7029 1E96
7030 1E96 A9 01 00              lda   #$0001                   ;start with device number 1
7031 1E99 8D 78 1F              sta   search_device
7032 1E9C 9C 7A 1F              stz   skip_dev
7033 1E9F
7034 1E9F 20 21 1F              jsr   chk_vol_syntax
7035 1EA2
7036 1EA2 A2 FB 04              ldx   #volume_name             ;try to find the volume in a vcr
7037 1EA5 A0 02 00              ldy   #^volume_name
7038 1EA8 A9 00 00              lda   #$0000
7039 1EAB 22 48 FC 01           jsl   find_vcr
7040 1EAF B0 24                 bcs   check_drive
7041 1EB1
7042 1EB1              ;check to see if this vcr is mine
7043 1EB1
7044 1EB1 22 38 FC 01           jsl   deref                    ;convert to real pointer
7045 1EB5 86 84                 stx   my_vcr_ptr
7046 1EB7 84 86                 sty   my_vcr_ptr+2
7047 1EB9
7048 1EB9 A0 0A 00              ldy   #vcr_fst_id
7049 1EBC B7 84                 lda   [my_vcr_ptr],y
7050 1EBE C9 01 00              cmp   #pro_id
7051 1EC1 F0 05                 beq   get_device
7052 1EC3 A9 52 00              lda   #unknown_vol             ;tell caller its another fsts
7053 1EC6 38                    sec   
7054 1EC7 60                    rts                            ;return
7055 1EC8
7056 1EC8              ;setup the device number to check first
7057 1EC8
7058 1EC8              get_device  
7059 1EC8 A0 0C 00              ldy   #vcr_dev
7060 1ECB B7 84                 lda   [my_vcr_ptr],y
7061 1ECD 8D 78 1F              sta   search_device
7062 1ED0 8D 7A 1F              sta   skip_dev                 ;indicate we are starting in the middle 
7063 1ED3 80 08                 bra   do_id
7064 1ED5
7065 1ED5              check_drive  
7066 1ED5 AD 78 1F              lda   search_device
7067 1ED8 CD 7A 1F              cmp   skip_dev                 ;do I need to skip this one?
7068 1EDB F0 16                 beq   next_dev
7069 1EDD 20 D9 1C     do_id    jsr   id_disk
7070 1EE0 90 16                 bcc   compare_vol
7071 1EE2
7072 1EE2 C9 11 00              cmp   #invalid_dev_num         ;have we looked at all the devices?
7073 1EE5 F0 07                 beq   vol_not_avail
7074 1EE7 C9 57 00              cmp   #dup_volume              ;is the volume a duplicate?
7075 1EEA F0 05                 beq   abort_search
7076 1EEC 80 26                 bra   check_search             ;go ahead and try another drive.
7077 1EEE
7078 1EEE              vol_not_avail  
7079 1EEE A9 45 00              lda   #vol_not_found
7080 1EF1
7081 1EF1              abort_search  
7082 1EF1 38                    sec   
7083 1EF2 60                    rts                            ;sorry not today
7084 1EF3
7085 1EF3              next_dev  
7086 1EF3 EE 78 1F              inc   search_device
7087 1EF6 80 DD                 bra   check_drive
7088 1EF8
7089 1EF8              compare_vol  
7090 1EF8 A7 04                 lda   [drvr_buf_ptr]           ;get the length
7091 1EFA 29 0F 00              and   #$000F
7092 1EFD CD FB 04              cmp   volume_name              ;sixteen bit name length
7093 1F00 D0 12                 bne   check_search             ;Cannot be the same
7094 1F02
7095 1F02 A8                    tay                            ;save the length
7096 1F03 08                    php   
7097 1F04                       longa off
7098 1F04 E2 20                 sep   #$20                     ;short accum for string compare
7099 1F06
7100 1F06              comp_loop  
7101 1F06              if AllowLCPeriods then                  ;added 7-Aug-91 DAL
7102 1F06 B7 04                 lda   volume_name+1,y
7103 1F08 D9 FC 04              cmp   #' '
7104 1F0B D0 06                 bne   @not_blank
7105 1F0D                       lda   #'.'
7106 1F0D              @not_blank cmp   [drvr_buf_ptr],y
7107 1F0D              else                                    ;original code
7108 1F0D                       lda   [drvr_buf_ptr],y
7109 1F0D                       cmp   volume_name+1,y
7110 1F0D              endif                                   ;end 7-Aug-91 DAL
7111 1F0D
7112 1F0D
7113 1F0D                       bne   not_same
7114 1F0D 88                    dey   
7115 1F0E D0 F6                 bne   comp_loop
7116 1F10                       longa on                       ;keep the assembler in line
7117 1F10 28                    plp   
7118 1F11 18                    clc   
7119 1F12 60                    rts                            ;this is it.
7120 1F13
7121 1F13              not_same                                ;
7122 1F13 28                    plp   
7123 1F14              check_search                            ;
7124 1F14 AD 7A 1F              lda   skip_dev
7125 1F17 CD 78 1F              cmp   search_device            ;are we looking at a default drive?
7126 1F1A D0 D7                 bne   next_dev                 ;no we are not.
7127 1F1C 9C 78 1F              stz   search_device            ;start the search from the beginning
7128 1F1F 80 D2                 bra   next_dev
7129 1F21
7130 1F21
7131 1F21                       EXPORT chk_vol_syntax
7132 1F21              chk_vol_syntax                          ;check the syntax of the volume name
7133 1F21                       longa off
7134 1F21                       longi off
7135 1F21 E2 30                 sep   #$30
7136 1F23 AC FB 04              ldy   volume_name              ;get the length word
7137 1F26                                                      ;check the length first         10/10/91 JEV
7138 1F26 C0 10                 cpy   #$10
7139 1F28 90 02                 bcc   vol_syntax_loop
7140 1F2A 80 19                 bra   syntax_death
7141 1F2C
7142 1F2C              vol_syntax_loop                         ;
7143 1F2C B9 FC 04              lda   volume_name+1,y
7144 1F2F
7145 1F2F C0 01                 cpy   #$0001                   ;is this the first character
7146 1F31 D0 21                 bne   not_first
7147 1F33 C9 61                 cmp   #'a'
7148 1F35 90 06                 bcc   not_lower
7149 1F37 C9 7B                 cmp   #'z'+1
7150 1F39 B0 0A                 bcs   syntax_death
7151 1F3B 29 DF                 and   #$DF
7152 1F3D
7153 1F3D              not_lower                               ;
7154 1F3D C9 41                 cmp   #'A'
7155 1F3F 90 04                 bcc   syntax_death
7156 1F41 C9 5B                 cmp   #'Z'+1
7157 1F43 90 09                 bcc   good_syntax
7158 1F45
7159 1F45              syntax_death                            ;
7160 1F45                       longa on
7161 1F45                       longi on
7162 1F45 C2 30                 rep   #$30
7163 1F47 A9 40 00              lda   #bad_path_syntax
7164 1F4A 38                    sec   
7165 1F4B 4C 82 00              jmp   main_exit
7166 1F4E
7167 1F4E              good_syntax                             ;
7168 1F4E 88                    dey   
7169 1F4F D0 DB                 bne   vol_syntax_loop
7170 1F51 C2 30                 rep   #$30
7171 1F53 60                    rts   
7172 1F54
7173 1F54                       longa off
7174 1F54                       longi off
7175 1F54              not_first                               ;
7176 1F54 C9 61                 cmp   #'a'
7177 1F56 90 06                 bcc   not_lower2
7178 1F58 C9 7B                 cmp   #'z'+1
7179 1F5A B0 E9                 bcs   syntax_death
7180 1F5C 29 DF                 and   #$DF
7181 1F5E
7182 1F5E              not_lower2                              ;
7183 1F5E
7184 1F5E C9 41                 cmp   #'A'
7185 1F60 90 06                 bcc   check_num
7186 1F62 C9 5B                 cmp   #'Z'+1
7187 1F64 B0 DF                 bcs   syntax_death
7188 1F66 80 E6                 bra   good_syntax
7189 1F68
7190 1F68              check_num                               ;
7191 1F68 C9 30                 cmp   #'0'
7192 1F6A 90 06                 bcc   check_period
7193 1F6C C9 3A                 cmp   #'9'+1
7194 1F6E B0 D5                 bcs   syntax_death
7195 1F70 80 DC                 bra   good_syntax
7196 1F72
7197 1F72              check_period                            ;
7198 1F72              if AllowLCPeriods then                  ;added 7-Aug-91 DAL
7199 1F72 C9 2E                 cmp   #' '
7200 1F74 D0 CF                 bne   @not_blank
7201 1F76                       lda   #'.'
7202 1F76                       sta   volume_name+1,y
7203 1F76 80 D6                 bra   good_syntax
7204 1F78              @not_blank  
7205 1F78              endif                                   ;end 7-Aug-91 DAL
7206 1F78
7207 1F78                       cmp   #'.'
7208 1F78                       bne   syntax_death
7209 1F78                       bra   good_syntax
7210 1F78
7211 1F78              ;local data for find volume
7212 1F78
7213 1F78 00 00        search_device DC W:00
7214 1F7A 00 00        skip_dev DC W:00
7215 1F7C
7216 1F7C                       ENDP 
7217 1F7C              ;======================================================================
7218 1F7C              ;Find_File:     This file contains the code that will locate a file on
7219 1F7C              ;               disk.
7220 1F7C              ;
7221 1F7C              ;revisions:
7222 1F7C              ;               apr 09 1987             ;added forward/backward link verify 
7223 1F7C              ;               apr 09 1987             ;changed routine to read a block
7224 1F7C              ;                                       ;at a time instead of 1K
7225 1F7C              ;               apr 10 1987             ;added additional check for path
7226 1F7C              ;                                       ;searching.
7227 1F7C              ;               apr 27 1987             ;changed code to handle 'C' strings
7228 1F7C              ;               may 02 1987             ;added memory based tree routines
7229 1F7C              ;                                       ;so all accessed directories will
7230 1F7C              ;                                       ;be added into a b-tree. 
7231 1F7C              ;               sep 14 1987             ;added support for searching for
7232 1F7C              ;                                       ;blank entries in the directory
7233 1F7C              ;
7234 1F7C              ;Input:         A = device number
7235 1F7C              ;               X = low word: pointer to name
7236 1F7C              ;               Y = high word: pointer to name
7237 1F7C              ;               P = nvmxdizc
7238 1F7C              ;                   ..000...
7239 1F7C              ;               b = k
7240 1F7C              ;
7241 1F7C              ;               drvr_vol_id
7242 1F7C              ;               my_vcr_ptr
7243 1F7C              ;               prodos_vcr_ptr
7244 1F7C              ;               search_flag             ;IF bit 14 = 1 then search for blank
7245 1F7C              ;                                       ;blank entry in directory, as well
7246 1F7C              ;                                       ;as checking for duplicate file error.
7247 1F7C              ;
7248 1F7C              ;Format of pathname:
7249 1F7C              ;               1) volume name is NOT part of the pathname
7250 1F7C              ;               2) pathname begins with a length byte
7251 1F7C              ;               3) each part of the pathname is seperated with a colon char.
7252 1F7C              ;               4) pathname MUST end with a NULL char.
7253 1F7C              ; 
7254 1F7C              ;Output:        A = error code or offset to entry within the I/O buffer
7255 1F7C              ;               X = pointer to name (low word)
7256 1F7C              ;               Y = pointer to name (high word)
7257 1F7C              ;               P = nvmxdizc
7258 1F7C              ;                   ..000..1 = error
7259 1F7C              ;                          0 = no error
7260 1F7C              ;               b = k
7261 1F7C              ;
7262 1F7C              ;               dir_start_blk           ;starting block of last dir searched
7263 1F7C              ;               free_dir_blk            ;first block with a blank entry
7264 1F7C              ;               free_dir_offset         ;offset to first free entry within blk
7265 1F7C              ;               dir_last_blk            ;block number that contains found file.
7266 1F7C              ;            or drvr_blk_num            ;or the last block of the directory.
7267 1F7C              ;               path_searched           ;if + then entire path NOT searched
7268 1F7C              ;                                       ;if - then the entire path was searched
7269 1F7C              ;               slug_block              ;block number of the entry
7270 1F7C              ;               slug_offset             ;offset to the entry.
7271 1F7C              ;
7272 1F7C              ;Uses:          All registers
7273 1F7C              ;               Device Dispatcher  (subroutine)
7274 1F7C              ;               General I/O Buffer (1K buffer, I read 1K bytes)
7275 1F7C              ;               temp_ptr
7276 1F7C              ;               gbuf_ptr 
7277 1F7C              ;               path_level
7278 1F7C              ;
7279 1F7C                       longa on
7280 1F7C                       longi on
7281 1F7C
7282 1F7C                       EXPORT find_file
7283 1F7C              find_file PROC 
7284 1F7C
7285 1F7C 85 00                 sta   drvr_dev_num             ;device number to search on
7286 1F7E 86 98                 stx   temp_ptr                 ;pointer to the name
7287 1F80 84 9A                 sty   temp_ptr+2
7288 1F82
7289 1F82 AD EB 02              lda   gbuf_addr
7290 1F85 85 94                 sta   gbuf_ptr
7291 1F87 85 04                 sta   drvr_buf_ptr
7292 1F89 AD ED 02              lda   gbuf_addr+2
7293 1F8C 85 96                 sta   gbuf_ptr+2
7294 1F8E 85 06                 sta   drvr_buf_ptr+2
7295 1F90
7296 1F90 9C 0B 03              stz   curr_mod_date            ;zero the latest mod date field
7297 1F93 9C 0D 03              stz   curr_mod_date+2
7298 1F96
7299 1F96 A9 02 00              lda   #vol_dir_start           ;default starting block
7300 1F99 8D E1 04              sta   dir_start_blk            ;starting block for current directory
7301 1F9C 8D E3 04              sta   dir_last_blk             ;last block read by find file
7302 1F9F 85 10                 sta   drvr_blk_num
7303 1FA1 64 12                 stz   drvr_blk_num+2
7304 1FA3              vcr_not_alloc  
7305 1FA3 20 8D 15              jsr   standard_req
7306 1FA6
7307 1FA6 A9 02 00              lda   #drvr_read               ;setup for reading
7308 1FA9 85 02                 sta   drvr_call_num
7309 1FAB
7310 1FAB 9C D1 05              stz   chars_checked
7311 1FAE 9C DB 04              stz   path_searched            ;indicates if entire path searched
7312 1FB1 20 6C 21              jsr   setup_name               ;setup first part to look for
7313 1FB4 9C B1 05              stz   entries_blk_num          ;block that contains the entry
7314 1FB7              outter_loop                             ;
7315 1FB7 9C DD 04              stz   last_blk                 ;used to verify directory structure
7316 1FBA 9C E5 04              stz   free_dir_blk             ;indicate no free dir entry
7317 1FBD 9C E7 04              stz   free_dir_offset
7318 1FC0 9C E9 04              stz   searching_free           ;we are looking for free entries
7319 1FC3
7320 1FC3              search_loop                             ;
7321 1FC3 20 95 17              jsr   read_with_cache          ;issue the read command
7322 1FC6 B0 56                 bcs   error_leave              ;some error has occured
7323 1FC8
7324 1FC8 20 73 20              jsr   verify_dir               ;verify forward/backward links
7325 1FCB B0 51                 bcs   error_leave              ;get out of here, links disagree
7326 1FCD
7327 1FCD 9C CF 05              stz   entries_checked          ;reset file counter
7328 1FD0 A0 04 00              ldy   #0004                    ;pass the link pointers
7329 1FD3 20 B0 20              jsr   check_block              ;see if name is in the block
7330 1FD6 90 4C                 bcc   found
7331 1FD8
7332 1FD8 2C E9 04              bit   searching_free           ;are we looking for a free entry?
7333 1FDB 10 0C                 bpl   check_active             ;no we are looking for the file.
7334 1FDD AD E5 04              lda   free_dir_blk             ;Have we found a free entry yet?
7335 1FE0 F0 11                 beq   load_next                ;No, so load the next block
7336 1FE2 2C DB 04              bit   path_searched            ;are we looking for the last name?
7337 1FE5 10 0C                 bpl   load_next                ;No.
7338 1FE7 80 27                 bra   no_more_blks             ;yes, so return data
7339 1FE9
7340 1FE9              check_active                            ;
7341 1FE9 AD B5 05              lda   files_in_dir             ;subtract off active entries checked
7342 1FEC ED B3 05              sbc   files_examined
7343 1FEF 90 2E                 bcc   dir_damaged              ;the directory count does not match
7344 1FF1 F0 0E                 beq   not_found                ;we have looked at all the files.
7345 1FF3
7346 1FF3              load_next                               ;
7347 1FF3 A0 02 00              ldy   #0002                    ;check next link field
7348 1FF6 B7 94                 lda   [gbuf_ptr],y             ;get the forward link
7349 1FF8 F0 16                 beq   no_more_blks             ;cannot check any further
7350 1FFA 85 10                 sta   drvr_blk_num             ;read this block next
7351 1FFC 8D E3 04              sta   dir_last_blk             ;save last block read
7352 1FFF 80 C2                 bra   search_loop
7353 2001
7354 2001              not_found                               ;
7355 2001 2C DF 04              bit   search_flag              ;are we suppose to find a free entry?
7356 2004 50 0A                 bvc   no_more_blks             ;no we are not
7357 2006 AD E5 04              lda   free_dir_blk             ;do we already have a free entry?
7358 2009 D0 05                 bne   no_more_blks             ;yes we do!
7359 200B CE E9 04              dec   searching_free
7360 200E 80 E3                 bra   load_next                ;continue to look for a blank entry.
7361 2010
7362 2010              no_more_blks                            ;
7363 2010 AD DB 04              lda   path_searched            ;was the entire path searched?
7364 2013 D0 05                 bne   file_err                 ;yes the entire path was searched
7365 2015 A9 44 00              lda   #path_not_found          ;a subdirectory was not found
7366 2018 38                    sec   
7367 2019 60                    rts   
7368 201A              file_err                                ;
7369 201A A9 46 00              lda   #file_not_found          ;you guessed it, no file today
7370 201D 38                    sec                            ;sorry no file by that name
7371 201E 60           error_leave rts   
7372 201F
7373 201F              ;we get here if the total number of active files is greater then the
7374 201F              ;total number of files in the directory
7375 201F
7376 201F              dir_damaged                             ;
7377 201F A9 51 00              lda   #dir_error               ;this is a bad directory
7378 2022 38                    sec   
7379 2023 60                    rts   
7380 2024
7381 2024              ;If we get here then we have found the name we were looking for.
7382 2024              ;Now we need to see if there is anymore pathname to process.  If there
7383 2024              ;is nothing left to process then we exit all happy.  If there is more
7384 2024              ;to process then we make sure that the entry we just found is a
7385 2024              ;subdirectory.  If it is not then we exit with file not found. 
7386 2024
7387 2024              found                                   ;
7388 2024 A5 10                 lda   drvr_blk_num             ;block number that contains entry
7389 2026 8D B1 05              sta   entries_blk_num          ;block number that contains the entry
7390 2029 8D E3 04              sta   dir_last_blk             ;last block read
7391 202C 8C 17 06              sty   entries_offset           ;offset to the entry
7392 202F
7393 202F BB                    tyx   
7394 2030 AC D1 05              ldy   chars_checked
7395 2033 88                    dey   
7396 2034 B7 98                 lda   [temp_ptr],y             ;see if we are done
7397 2036 29 FF 00              and   #$00FF
7398 2039 F0 29                 beq   find_success             ;yes we have succeeded
7399 203B
7400 203B 9B                    txy   
7401 203C B7 94                 lda   [gbuf_ptr],y             ;see if type is directory
7402 203E 29 F0 00              and   #$00F0
7403 2041 C9 D0 00              cmp   #$00D0                   ;it is a directory
7404 2044 D0 BB                 bne   not_found                ;can not go any further
7405 2046
7406 2046 A5 10                 lda   drvr_blk_num             ;save the entries block number for
7407 2048 8D 1B 03              sta   slug_block               ;slug ripple routine.
7408 204B 8C 1D 03              sty   slug_offset              ;offset to file entry.
7409 204E
7410 204E 98                    tya   
7411 204F 18                    clc   
7412 2050 69 11 00              adc   #$0011                   ;make index to key block pointer
7413 2053 A8                    tay   
7414 2054 B7 94                 lda   [gbuf_ptr],y
7415 2056 85 10                 sta   drvr_blk_num
7416 2058 8D E1 04              sta   dir_start_blk            ;starting block for next directory
7417 205B 8D E3 04              sta   dir_last_blk             ;save last block read
7418 205E 20 6C 21              jsr   setup_name               ;setup next partial to find
7419 2061
7420 2061 4C B7 1F              jmp   outter_loop
7421 2064
7422 2064              ;Below is a happy place to be.  This means that we have found the
7423 2064              ;file that we were commissioned to find.  So we will setup a pointer
7424 2064              ;to the name and return to the caller.  Isnt' that special. 
7425 2064
7426 2064 8A           find_success txa                        ;we have located the name
7427 2065 48                    pha                            ;save the offset 
7428 2066 18                    clc   
7429 2067 65 94                 adc   gbuf_ptr                 ;adjust buffer pointer
7430 2069 AA                    tax   
7431 206A A9 00 00              lda   #0000
7432 206D 65 96                 adc   gbuf_ptr+2
7433 206F A8                    tay   
7434 2070
7435 2070 68                    pla                            ;offset (0 to 512)
7436 2071 18                    clc   
7437 2072 60                    rts                            ;X,Y contains a pointer to the name
7438 2073
7439 2073              ;==========================================================================
7440 2073              ;verify dir:    This routine will verify that the forward and backward
7441 2073              ;               links of the subdirectory agree with each other.  If
7442 2073              ;               they do not then we will return a dir_error.  The
7443 2073              ;               routine also makes sure that the parent pointer,
7444 2073              ;               entry length and entries per block are also correct. 
7445 2073              ;
7446 2073              ;input:         last_blk                ;contains previous dir block
7447 2073              ;               entries_blk_num         ;parents block number 
7448 2073              ;               drvr_blk_num            ;contains current block number
7449 2073              ;
7450 2073              ;output:        A = error if carry set otherwise no error 
7451 2073
7452 2073              verify_dir   
7453 2073 AD DD 04              lda   last_blk                 ;the previous directory block
7454 2076 F0 10                 beq   verify_parent            ;this is a special case since
7455 2078                                                      ;no previous block has been read
7456 2078 C7 94                 cmp   [gbuf_ptr]
7457 207A F0 05                 beq   dir_ok                   ;this is the way it should be
7458 207C              bad_dir                                 ;
7459 207C A9 51 00              lda   #dir_error               ;this is a bad directory
7460 207F 38                    sec   
7461 2080 60                    rts   
7462 2081              dir_ok    
7463 2081 A5 10                 lda   drvr_blk_num             ;setup last block for next time
7464 2083 8D DD 04              sta   last_blk
7465 2086 18                    clc   
7466 2087 60                    rts   
7467 2088
7468 2088              verify_parent                           ;
7469 2088 AD B1 05              lda   entries_blk_num          ;skip check if zero
7470 208B F0 07                 beq   pass_parent              ;don't bother checking parent
7471 208D
7472 208D A0 27 00              ldy   #$0027                   ;index to parent pointer
7473 2090 D7 94                 cmp   [gbuf_ptr],y             ;compare to childs parent
7474 2092 D0 E8                 bne   bad_dir                  ;parent/child don't match
7475 2094
7476 2094 A0 23 00     pass_parent ldy   #$0023                ;index to entry length/entries per blk
7477 2097 B7 94                 lda   [gbuf_ptr],y
7478 2099 C9 27 0D              cmp   #$0D27
7479 209C D0 0D                 bne   bad_directory            ;this is something I don't know about
7480 209E
7481 209E A0 25 00              ldy   #$0025                   ;index to total files in directory
7482 20A1 B7 94                 lda   [gbuf_ptr],y
7483 20A3 8D B5 05              sta   files_in_dir
7484 20A6 9C B3 05              stz   files_examined           ;reset files examined
7485 20A9 80 D6                 bra   dir_ok
7486 20AB              bad_directory  
7487 20AB A9 4A 00              lda   #version_error           ;I don't know about this disk
7488 20AE 38                    sec   
7489 20AF 60                    rts   
7490 20B0
7491 20B0              ;==========================================================================
7492 20B0              ;The following routine will look at all the entries within a directory
7493 20B0              ;block.  The entry is skipped if it is a volume header, subdirectory
7494 20B0              ;header or an inactive entry.  If an entry is found that is active then
7495 20B0              ;it is checked against the name we are looking for.  If the name is
7496 20B0              ;found then we exit indicating that we have found the file.  We
7497 20B0              ;continue to look for the name until we have looked at all the entries
7498 20B0              ;or the file is found. 
7499 20B0
7500 20B0 AD CF 05     check_block lda   entries_checked
7501 20B3 C9 0D 00              cmp   #entries_per_block
7502 20B6 F0 40                 beq   check_done
7503 20B8 1A                    inc   a
7504 20B9 8D CF 05              sta   entries_checked
7505 20BC
7506 20BC B7 94                 lda   [gbuf_ptr],y             ;get the storage type
7507 20BE AA                    tax   
7508 20BF 29 F0 00              and   #$00F0                   ;check for directories
7509 20C2 C9 F0 00              cmp   #$00F0                   ;is this the volume Entry????
7510 20C5 D0 05                 bne   @chK_sub                 ;no it is not
7511 20C7
7512 20C7 20 FA 20              jsr   save_vol_mod             ;save the volume modification if possible
7513 20CA 80 24                 bra   next_entry
7514 20CC              @chk_sub  
7515 20CC C9 E0 00              cmp   #$00E0
7516 20CF B0 1F                 bcs   next_entry               ;skip headers
7517 20D1 8A                    txa   
7518 20D2 29 0F 00              and   #$000F                   ;isolate name length
7519 20D5 F0 0C                 beq   chk_need_free            ;the entry is not active.
7520 20D7 EE B3 05              inc   files_examined           ;advance the number of active files
7521 20DA 20 10 21              jsr   save_latest_mod          ;save the lastest mod date
7522 20DD 20 45 21              jsr   check_name
7523 20E0 B0 0E                 bcs   next_entry
7524 20E2 60                    rts                            ;we have found it
7525 20E3
7526 20E3              chk_need_free                           ;
7527 20E3 AD E5 04              lda   free_dir_blk             ;block that contains a free entry
7528 20E6 D0 08                 bne   next_entry
7529 20E8 A5 10                 lda   drvr_blk_num
7530 20EA 8D E5 04              sta   free_dir_blk             ;save directory block number
7531 20ED 8C E7 04              sty   free_dir_offset          ;save offset to free entry
7532 20F0
7533 20F0              next_entry  
7534 20F0 98                    tya   
7535 20F1 18                    clc   
7536 20F2 69 27 00              adc   #entry_length            ;adjust pointer to next entry
7537 20F5 A8                    tay   
7538 20F6 80 B8                 bra   check_block
7539 20F8
7540 20F8 38           check_done sec                          ;sorry entry not found
7541 20F9 60                    rts   
7542 20FA
7543 20FA              save_vol_mod  
7544 20FA 5A                    phy                            ;save directory entry index
7545 20FB DA                    phx   
7546 20FC 48                    pha   
7547 20FD
7548 20FD A0 16 00              ldy   #vol_mod_offset          ;get the mod date from the volume header
7549 2100 B7 94                 lda   [gbuf_ptr],y
7550 2102 8D 0B 03              sta   curr_mod_date
7551 2105 C8                    iny   
7552 2106 C8                    iny   
7553 2107 B7 94                 lda   [gbuf_ptr],y
7554 2109 8D 0D 03              sta   curr_mod_date+2
7555 210C
7556 210C 68                    pla   
7557 210D FA                    plx   
7558 210E 7A                    ply   
7559 210F 60                    rts   
7560 2110
7561 2110              ;Save_lastest_mod will save the lastest mod date that we find.  The reason
7562 2110              ;we do this is to allow the mod date to be returned for the volume header.
7563 2110
7564 2110              save_latest_mod  
7565 2110 5A                    phy                            ;save directory entry index
7566 2111 DA                    phx   
7567 2112 48                    pha   
7568 2113
7569 2113 98                    tya   
7570 2114 18                    clc   
7571 2115 69 21 00              adc   #last_mod_index
7572 2118 A8                    tay   
7573 2119 B7 94                 lda   [gbuf_ptr],y
7574 211B AA                    tax   
7575 211C CD 0B 03              cmp   curr_mod_date            ;see if the date is greater
7576 211F 90 20                 bcc   @not_greater
7577 2121 F0 0C                 beq   @check_time
7578 2123 C8                    iny   
7579 2124 C8                    iny   
7580 2125 B7 94                 lda   [gbuf_ptr],y             ;get the minutes etc.
7581 2127 8D 0D 03              sta   curr_mod_date+2
7582 212A 8E 0B 03              stx   curr_mod_date            ;save the new latest date
7583 212D 80 12                 bra   @not_greater             ;just exit
7584 212F              @check_time  
7585 212F C8                    iny   
7586 2130 C8                    iny   
7587 2131 B7 94                 lda   [gbuf_ptr],y             ;get the minutes etc.
7588 2133 29 3F 1F              and   #$1F3F                   ;clear unused bits
7589 2136 CD 0D 03              cmp   curr_mod_date+2
7590 2139 90 06                 bcc   @not_greater
7591 213B 8D 0D 03              sta   curr_mod_date+2
7592 213E 8E 0B 03              stx   curr_mod_date            ;save the new latest date
7593 2141
7594 2141              @not_greater  
7595 2141 68                    pla   
7596 2142 FA                    plx   
7597 2143 7A                    ply   
7598 2144 60                    rts   
7599 2145
7600 2145              ;==========================================================================
7601 2145              ;Check name will examine the name to see if it is the one that
7602 2145              ;we are looking for.  If it is not then we return with carry set
7603 2145              ;otherwise we return with carry clear. 
7604 2145
7605 2145              check_name   
7606 2145 CD 23 05              cmp   search_length
7607 2148 D0 20                 bne   noway
7608 214A 8D D3 05              sta   name_length
7609 214D 5A                    phy                            ;save y during search
7610 214E C8                    iny   
7611 214F
7612 214F A2 00 00              ldx   #0000
7613 2152
7614 2152                       longa off
7615 2152 E2 20                 sep   #$20
7616 2154              name_loop   
7617 2154
7618 2154 B7 94                 lda   [gbuf_ptr],y
7619 2156 DD 25 05              cmp   search_name,x
7620 2159 D0 0C                 bne   not_it
7621 215B E8                    inx   
7622 215C C8                    iny   
7623 215D CE D3 05              dec   name_length
7624 2160 D0 F2                 bne   name_loop
7625 2162 C2 30                 rep   #$30
7626 2164 7A                    ply   
7627 2165 18                    clc   
7628 2166 60                    rts   
7629 2167
7630 2167                       longa on
7631 2167              not_it    
7632 2167 C2 30                 rep   #$30
7633 2169 7A                    ply   
7634 216A 38           noway    sec   
7635 216B 60                    rts   
7636 216C
7637 216C              ;==========================================================================
7638 216C              ;The following routine when called, will isolate the next name to
7639 216C              ;locate.  It does this by looking for the delimiter(delimiter = ':')
7640 216C              ;The last delimiter is a null character.
7641 216C
7642 216C                       EXPORT setup_name
7643 216C              setup_name  
7644 216C 5A                    phy   
7645 216D AC D1 05              ldy   chars_checked            ;index into source name
7646 2170 B7 98                 lda   [temp_ptr],y             ;are we done yet
7647 2172 29 FF 00              and   #$00FF
7648 2175 D0 06                 bne   more_names
7649 2177 CE DB 04              dec   path_searched            ;the entire path has been searched
7650 217A 7A                    ply   
7651 217B 38                    sec                            ;indicate we are thru
7652 217C 60                    rts   
7653 217D              more_names   
7654 217D                       longa off
7655 217D                       longi on
7656 217D E2 20                 sep   #$20                     ;short accumulator please
7657 217F
7658 217F A2 00 00              ldx   #$0000
7659 2182              looper    
7660 2182 B7 98                 lda   [temp_ptr],y
7661 2184 F0 4D                 beq   end_path                 ;end of name and end of string
7662 2186 C9 3A                 cmp   #delimiter
7663 2188 F0 4C                 beq   end_name                 ;we found a delimiter
7664 218A 9D 25 05              sta   search_name,x
7665 218D E0 00 00              cpx   #$0000                   ;is this the first character?
7666 2190 D0 1B                 bne   not_first
7667 2192
7668 2192 C9 61                 cmp   #'a'
7669 2194 90 06                 bcc   not_lower1
7670 2196 C9 7B                 cmp   #'z'+1
7671 2198 B0 0A                 bcs   syntax_prob
7672 219A 29 DF                 and   #$DF
7673 219C              not_lower1  
7674 219C C9 41                 cmp   #'A'
7675 219E 90 04                 bcc   syntax_prob
7676 21A0 C9 5B                 cmp   #'Z'+1
7677 21A2 90 1B                 bcc   good_syntax
7678 21A4              syntax_prob  
7679 21A4                       longa on
7680 21A4                       longi on
7681 21A4 C2 20                 rep   #$20
7682 21A6 A9 40 00              lda   #bad_path_syntax
7683 21A9 38                    sec   
7684 21AA 4C 82 00              jmp   main_exit                ;return to Jim with the error
7685 21AD
7686 21AD                       longa off
7687 21AD                       longi on
7688 21AD              not_first   
7689 21AD C9 61                 cmp   #'a'
7690 21AF 90 06                 bcc   not_lower2
7691 21B1 C9 7B                 cmp   #'z'+1
7692 21B3 B0 EF                 bcs   syntax_prob
7693 21B5 29 DF                 and   #$DF
7694 21B7              not_lower2   
7695 21B7 C9 41                 cmp   #'A'
7696 21B9 90 08                 bcc   check_num
7697 21BB C9 5B                 cmp   #'Z'+1
7698 21BD B0 E5                 bcs   syntax_prob
7699 21BF              good_syntax  
7700 21BF E8                    inx   
7701 21C0 C8                    iny   
7702 21C1 80 BF                 bra   looper
7703 21C3              check_num  
7704 21C3 C9 30                 cmp   #'0'
7705 21C5 90 06                 bcc   check_period
7706 21C7 C9 3A                 cmp   #'9'+1
7707 21C9 B0 D9                 bcs   syntax_prob
7708 21CB 80 F2                 bra   good_syntax
7709 21CD              check_period  
7710 21CD              if AllowLCPeriods then                  ;added 7-Aug-91 DAL
7711 21CD C9 2E                 cmp   #' '
7712 21CF                       beq   good_syntax
7713 21CF              endif                                   ;end 7-Aug-91 DAL
7714 21CF
7715 21CF                       cmp   #'.'
7716 21CF D0 D3                 bne   syntax_prob
7717 21D1 80 EC                 bra   good_syntax
7718 21D3              end_path  
7719 21D3 CE DC 04              dec   path_searched+1          ;the entire path has been searched
7720 21D6              end_name  
7721 21D6 C8                    iny   
7722 21D7 8C D1 05              sty   chars_checked
7723 21DA 8E 23 05              stx   search_length
7724 21DD
7725 21DD                       longa on
7726 21DD                       longi on
7727 21DD C2 30                 rep   #$30
7728 21DF 7A                    ply   
7729 21E0 18                    clc   
7730 21E1 60                    rts   
7731 21E2
7732 21E2                       ENDP 
7733 21E2
7734 21E2              ;======================================================================
7735 21E2              ;init the ProDOS fst
7736 21E2
7737 21E2                       longa on
7738 21E2                       longi on
7739 21E2
7740 21E2                       EXPORT startup
7741 21E2              startup  PROC 
7742 21E2
7743 21E2 22 3C FC 01           jsl   get_sys_gbuf             ;get the systems general buffer
7744 21E6
7745 21E6              good                                    ;
7746 21E6 8E EB 02              stx   gbuf_addr
7747 21E9 8C ED 02              sty   gbuf_addr+2              ;save pointer to general work buffer
7748 21EC
7749 21EC 18                    clc   
7750 21ED 6B                    rtl   
7751 21EE
7752 21EE                       ENDP 
7753 21EE                       EXPORT shutdown
7754 21EE              shutdown PROC 
7755 21EE 18                    clc   
7756 21EF 6B                    rtl   
7757 21F0                       ENDP 
7758 21F0
7759 21F0              ;======================================================================
7760 21F0              ;Sys_Remove_vol This file contains code that is called by the system
7761 21F0              ;               to remove a volume control record (VCR).
7762 21F0              ;
7763 21F0              ;Input:         A = undefined
7764 21F0              ;               X = (call number * 2)
7765 21F0              ;               Y = undefined
7766 21F0              ;               P = nvmxdizc
7767 21F0              ;                   ..000...
7768 21F0              ;               b = k
7769 21F0              ;
7770 21F0              ;Output:        A = undefined
7771 21F0              ;               X = undefined
7772 21F0              ;               Y = undefined
7773 21F0              ;               P = nvmxdizc
7774 21F0              ;                   ..000..0 = no error
7775 21F0              ;               b = k
7776 21F0              ;
7777 21F0              ;Uses:          All registers
7778 21F0              ;
7779 21F0                       longa on
7780 21F0                       longi on
7781 21F0
7782 21F0                       EXPORT sys_remove_vol
7783 21F0              sys_remove_vol PROC 
7784 21F0
7785 21F0 18                    clc   
7786 21F1 6B                    rtl   
7787 21F2
7788 21F2                       ENDP 
7789 21F2
7790 21F2              ;======================================================================
7791 21F2              ;deferred_flush This file contains code that flush any deferred blocks
7792 21F2              ;               blocks to disk. This routine is called when the stop
7793 21F2              ;               session call is issued, and when swapout is called.
7794 21F2              ;               Since the routine can be called from swapout it must
7795 21F2              ;               save most of the direct page and local buffers.
7796 21F2              ;
7797 21F2              ;Input:         A = undefined
7798 21F2              ;               X = (call number * 2)
7799 21F2              ;               Y = undefined
7800 21F2              ;               P = nvmxdizc
7801 21F2              ;                   ..000...
7802 21F2              ;               b = k
7803 21F2              ;
7804 21F2              ;Output:        A = undefined
7805 21F2              ;               X = undefined
7806 21F2              ;               Y = undefined
7807 21F2              ;               P = nvmxdizc
7808 21F2              ;                   ..000..0 = no error
7809 21F2              ;               b = k
7810 21F2              ;
7811 21F2              ;Uses:          All registers
7812 21F2              ;
7813 21F2              ;======================================================================
7814 21F2                       longa on
7815 21F2                       longi on
7816 21F2
7817 21F2                       EXPORT deferred_flush
7818 21F2              deferred_flush PROC 
7819 21F2              ;
7820 21F2              ;Save the world.  We do this in case we are called by SwapOut.
7821 21F2              ;
7822 21F2 20 25 22              jsr   save_def                 ;save the deferred envirnoment
7823 21F5 20 8D 15              jsr   standard_req             ;write 512 bytes
7824 21F8 A9 00 02              lda   #blk_size
7825 21FB 85 14                 sta   drvr_blk_size
7826 21FD
7827 21FD A6 3E                 ldx   vcr_ptr
7828 21FF A4 40                 ldy   vcr_ptr+2
7829 2201 86 84                 stx   my_vcr_ptr
7830 2203 84 86                 sty   my_vcr_ptr+2
7831 2205 20 95 15              jsr   setup_my_vcr
7832 2208 86 88                 stx   prodos_vcr_ptr
7833 220A 84 8A                 sty   prodos_vcr_ptr+2
7834 220C
7835 220C              ;
7836 220C              ;Setup ID_Disk routine to ID by volume name ONLY!!  This is important
7837 220C              ;since block two is deferred and we are reading block two from the disk.
7838 220C              ;Therefore the two blocks will problably not be the same.
7839 220C              ;
7840 220C
7841 220C A9 01 80              lda   #$8001                   ;set the high bit of FST_NUM
7842 220F 85 16                 sta   drvr_fst_num             ;to force device access
7843 2211
7844 2211              ;
7845 2211              ;Try to locate the volume we are trying to write too.  We do this by
7846 2211              ;calling 'find_Volume'.  More then likely the volume is still in the
7847 2211              ;same drive.
7848 2211              ;
7849 2211 20 2E 14              jsr   mount_volume             ;go and locate the volume please
7850 2214 B0 0A                 bcs   bad_bad_news             ;we our up the creek!
7851 2216
7852 2216              ;
7853 2216              ;After finding the volume I will call the 'cache_flsh_def' routine.  This
7854 2216              ;routine will write all the deferred blocks to disk.
7855 2216              ;
7856 2216 A7 84                 lda   [my_vcr_ptr]             ;setup the VOL ID
7857 2218 85 18                 sta   drvr_vol_id
7858 221A
7859 221A 22 54 FC 01           jsl   cache_flsh_def
7860 221E 90 00                 bcc   exit_deferred
7861 2220              ;
7862 2220              ;Now that we are here we must restore the world and return back to scm
7863 2220              ;via an RTL instruction.
7864 2220              ;
7865 2220
7866 2220              bad_bad_news                            ;
7867 2220
7868 2220              exit_deferred                           ;
7869 2220 20 4D 22              jsr   restore_def
7870 2223 18                    clc   
7871 2224 6B                    rtl   
7872 2225
7873 2225              save_def                                ;
7874 2225 08                    php   
7875 2226 5A                    phy   
7876 2227 DA                    phx   
7877 2228 48                    pha   
7878 2229
7879 2229 A2 4A 00              ldx   #$004A                   ;save the direct page data
7880 222C              save_direct                             ;
7881 222C B5 00                 lda   drvr_dev_num,x
7882 222E 9D F9 03              sta   def_dir_page,x
7883 2231 CA                    dex   
7884 2232 10 F8                 bpl   save_direct
7885 2234 A2 52 00              ldx   #$0052                   ;save my direct page
7886 2237              save_my_direct                          ;
7887 2237 B5 80                 lda   fst_start,x
7888 2239 9D 45 04              sta   def_my_direct,x
7889 223C CA                    dex   
7890 223D 10 F8                 bpl   save_my_direct
7891 223F A2 13 00              ldx   #19                      ;save the volume name buffers
7892 2242              save_def_vol                            ;
7893 2242 BD FB 04              lda   volume_name,x
7894 2245 9D BD 04              sta   def_vol_name,x
7895 2248 CA                    dex   
7896 2249 10 F7                 bpl   save_def_vol
7897 224B 80 26                 bra   save_rest_exit
7898 224D
7899 224D              ;======================================================================
7900 224D
7901 224D              restore_def                             ;
7902 224D 08                    php   
7903 224E 5A                    phy   
7904 224F DA                    phx   
7905 2250 48                    pha   
7906 2251
7907 2251 A2 4A 00              ldx   #$004A                   ;restore the direct page data
7908 2254              restore_direct                          ;
7909 2254 BD F9 03              lda   def_dir_page,x
7910 2257 95 00                 sta   drvr_dev_num,x
7911 2259 CA                    dex   
7912 225A 10 F8                 bpl   restore_direct
7913 225C A2 52 00              ldx   #$0052                   ;restore my direct page
7914 225F              restore_dp                              ;
7915 225F BD 45 04              lda   def_my_direct,x
7916 2262 95 80                 sta   fst_start,x
7917 2264 CA                    dex   
7918 2265 10 F8                 bpl   restore_dp
7919 2267 A2 13 00              ldx   #19                      ;restore the volume name buffers
7920 226A              restore_def_vol                         ;
7921 226A BD BD 04              lda   def_vol_name,x
7922 226D 9D FB 04              sta   volume_name,x
7923 2270 CA                    dex   
7924 2271 10 F7                 bpl   restore_def_vol
7925 2273
7926 2273              save_rest_exit                          ;
7927 2273 68                    pla   
7928 2274 FA                    plx   
7929 2275 7A                    ply   
7930 2276 28                    plp   
7931 2277 60                    rts   
7932 2278
7933 2278                       ENDP 
7934 2278
7935 2278              ;======================================================================
7936 2278              ;Create:        This file will create a new fresh file on disk.
7937 2278              ;
7938 2278              ;Input:         A = undefined
7939 2278              ;               X = (call number * 2)
7940 2278              ;               Y = (class number * 2)
7941 2278              ;               P = nvmxdizc
7942 2278              ;                   ..000...
7943 2278              ;               b = k
7944 2278              ;
7945 2278              ;Output:        A = error code if carry set (exit via system exit routine)
7946 2278              ;               X = undefined
7947 2278              ;               Y = undefined
7948 2278              ;               P = nvmxdizc
7949 2278              ;                   ..000..1 = error
7950 2278              ;                          0 = no error
7951 2278              ;               b = k
7952 2278              ;
7953 2278              ;Uses:          All registers
7954 2278              ;               Device Dispatcher       (subroutine)
7955 2278              ;               General I/O Buffer      (1K buffer, I read 512 bytes)
7956 2278              ;               find_file               (subroutine)
7957 2278              ;
7958 2278              ;Call Format:
7959 2278              ;
7960 2278              ;Class 0        Pathname Pointer        (4 Bytes)
7961 2278              ;               Access                  (2 Bytes)
7962 2278              ;               File Type               (2 Bytes)
7963 2278              ;               Aux Type                (4 Bytes)
7964 2278              ;               Storgae_type            (2 Bytes)
7965 2278              ;               Create Date/Time        (4 Bytes: ProDOS Format)
7966 2278              ;
7967 2278              ;Class 1        PCount                  (2 Bytes)
7968 2278              ;               Pathname Pointer        (4 Bytes)
7969 2278              ;               Access                  (2 Bytes: E3 if not supplied)
7970 2278              ;               File Type               (2 Bytes: 00 if not supplied)
7971 2278              ;               Aux Type                (4 Bytes: 00 if not supplied)
7972 2278              ;               Storage Type            (2 Bytes: 01 if not supplied)
7973 2278              ;               Size Data Fork          (4 Bytes: 00 if not supplied)
7974 2278              ;               Size Resource Fork      (4 Bytes: 00 if not supplied)
7975 2278              ;
7976 2278                       longa on
7977 2278                       longi on
7978 2278
7979 2278                       EXPORT create
7980 2278
7981 2278              create   PROC 
7982 2278                       with expand_record
7983 2278
7984 2278              ;Setup the defaults for the create call.
7985 2278
7986 2278 9C 6D 05              stz   data_eof
7987 227B 9C 6F 05              stz   data_eof+2
7988 227E 9C 71 05              stz   res_eof
7989 2281 9C 73 05              stz   res_eof+2
7990 2284
7991 2284 20 9E 0E              jsr   setup_params
7992 2287 08                    php   
7993 2288 20 5C 28              jsr   do_create_path
7994 228B 20 12 29              jsr   default_entry            ;Build a Entry with All defaults!
7995 228E 28                    plp   
7996 228F D0 28                 bne   class1                   ;this is a new wonder version
7997 2291
7998 2291 A9 05 00              lda   #$0005                   ;set PCount for common setup
7999 2294 8D B7 05              sta   pcount
8000 2297 20 53 29              jsr   create_common
8001 229A
8002 229A A0 0E 00              ldy   #pblk_01_old_time
8003 229D B7 80                 lda   [my_pblk_ptr],y          ;load the old format time
8004 229F AA                    tax   
8005 22A0 C8                    iny   
8006 22A1 C8                    iny   
8007 22A2 B7 80                 lda   [my_pblk_ptr],y
8008 22A4 D0 03                 bne   users_date               ;user has supplied the data
8009 22A6 9B                    txy   
8010 22A7 F0 13                 beq   both_classes             ;us the GS system clock for the time
8011 22A9
8012 22A9              users_date                              ;
8013 22A9 29 3F 1F              and   #$1F3F                   ;force the date to correct format.
8014 22AC F0 03                 beq   clock_time               ;use the GS clock time please
8015 22AE 8D 5B 05              sta   one_entry+create_index+2
8016 22B1              clock_time                              ;
8017 22B1 8A                    txa                            ;is the date field set?
8018 22B2 F0 08                 beq   both_classes             ;use GS clock Date
8019 22B4 8E 59 05              stx   one_entry+create_index
8020 22B7 80 03                 bra   both_classes
8021 22B9
8022 22B9              class1    
8023 22B9 20 53 29              jsr   create_common
8024 22BC
8025 22BC              both_classes  
8026 22BC 2C 3C 08              bit   expand_flag              ;are we expanding a current file?
8027 22BF 10 23                 bpl   @no_expansion
8028 22C1
8029 22C1 AD 62 05              lda   one_entry+last_mod_index
8030 22C4 48                    pha   
8031 22C5 AD 64 05              lda   one_entry+last_mod_index+2
8032 22C8 48                    pha   
8033 22C9 AD 3E 05              lda   storage_type
8034 22CC 48                    pha   
8035 22CD AD 41 05              lda   one_entry
8036 22D0 48                    pha   
8037 22D1 20 09 3E              jsr   move_dir_entry           ;copy the entry from the disk
8038 22D4 68                    pla   
8039 22D5 8D 41 05              sta   one_entry
8040 22D8 68                    pla   
8041 22D9 8D 3E 05              sta   storage_type
8042 22DC 68                    pla   
8043 22DD 8D 64 05              sta   one_entry+last_mod_index+2
8044 22E0 68                    pla   
8045 22E1 8D 62 05              sta   one_entry+last_mod_index
8046 22E4
8047 22E4              @no_expansion  
8048 22E4 20 FB 27              jsr   eof_to_blks              ;convert bytes to blocks
8049 22E7              ;
8050 22E7              ;Blocks needed := Data_fork_blks + Res_fork_blks + subdir_blks + storage
8051 22E7              ;
8052 22E7              chk_dir                                 ;
8053 22E7 A9 00 00              lda   #$0000                   ;assume zero
8054 22EA 2C 3E 08              bit   expand_file              ;are we adding a directory entry?
8055 22ED 30 06                 bmi   no_extend
8056 22EF AE E5 04              ldx   free_dir_blk             ;is there room for a dir entry?
8057 22F2 D0 01                 bne   no_extend                ;yes, so don't bump blks needed
8058 22F4 1A                    inc   a                        ;add one for directory block needed
8059 22F5              no_extend  
8060 22F5 18                    clc   
8061 22F6 6D EB 04              adc   blks_used1               ;blocks for data fork
8062 22F9 18                    clc   
8063 22FA 6D ED 04              adc   blks_used2               ;blocks for resource fork
8064 22FD 8D EF 04              sta   blocks_needed            ;save total blocks needed for file
8065 2300 B0 27                 bcs   @no_room
8066 2302
8067 2302 AD 3E 05              lda   storage_type             ;if the file is an extended file then add
8068 2305 C9 50 00              cmp   #resource_type           ;one block for the extended file header
8069 2308 D0 03                 bne   @not_extended
8070 230A EE EF 04              inc   blocks_needed            ;bump the blocks needed
8071 230D              @not_extended  
8072 230D 20 4E 0C              jsr   calc_free_blks           ;see if we have enough room for the file
8073 2310 B0 1A                 bcs   to_exit
8074 2312
8075 2312 2C 3C 08              bit   expand_flag              ;are we expanding a current file?
8076 2315 10 0D                 bpl   @chk_sum                 ;no, so check the sum of the blocks needed
8077 2317              ;
8078 2317              ;We now know that we are extending a file, so we must check the blocks free against the
8079 2317              ;number of blocks needed to add the resource fork.  The blocks needed for the resource
8080 2317              ;fork is equal to blks_used2 + 1 (for resource header blk).  To compensate for the extra
8081 2317              ;block needed, we will reduce the number of free blocks by 1, then compare against
8082 2317              ;blks_used2 (blocks needed for resource fork).
8083 2317              ;But first, we need to check if the number of free blocks is 0!!  CAE 11-6-90
8084 2317              ;
8085 2317 C9 00 00              cmp   #0                       ;is free blocks = 0?
8086 231A F0 0D                 beq   @no_room                 ;yes - so can't extend the file
8087 231C
8088 231C 3A                    dec   a                        ;free blocks := free blocks -1; (compensate for header)
8089 231D CD ED 04              cmp   blks_used2
8090 2320 B0 0E                 bcs   it_fits
8091 2322 80 05                 bra   @no_room                 ;sorry you cannot extend the file.
8092 2324
8093 2324              @chk_sum  
8094 2324 CD EF 04              cmp   blocks_needed            ;do we have enough?
8095 2327 B0 07                 bcs   it_fits                  ;yes we do.
8096 2329              @no_room  
8097 2329 A9 48 00              lda   #volume_full             ;no room on volume
8098 232C              to_exit   
8099 232C 38                    sec   
8100 232D 4C 82 00              jmp   main_exit
8101 2330
8102 2330              it_fits   
8103 2330 20 40 23              jsr   build_file               ;go and make the file
8104 2333 B0 08                 bcs   create_err
8105 2335 20 02 18              jsr   force_bitmap             ;make sure the bitmap is up to date
8106 2338 B0 03                 bcs   create_err
8107 233A 20 C8 1A              jsr   slug_ripple              ;time stamp previous
8108 233D              create_err  
8109 233D 4C 82 00              jmp   main_exit
8110 2340
8111 2340              ;===============END OF THE CREATE CALL
8112 2340
8113 2340
8114 2340              ;==========================================================================
8115 2340              ;Build_file     This routine will allocate all needed blocks and build
8116 2340              ;               the file.  It will also handle directory extending etc.
8117 2340              ;
8118 2340              ;input:         free_dir_blk            ;dir blk with a empty entry.
8119 2340              ;               dir_start_blk           ;starting block of the directory
8120 2340              ;               dir_last_blk            ;last block of the directory
8121 2340              ;               used_blks1              ;blocks needed for data fork
8122 2340              ;               used_blks2              ;blocks needed for resource fork
8123 2340              ;               stoarge_type            ;type of file to be created
8124 2340              ;               data_storage            ;storage type of data fork
8125 2340              ;               res_storage             ;storage type of resource fork
8126 2340              ;
8127 2340              ;Output:        A = error code if carry set
8128 2340              ;               X = undefined
8129 2340              ;               Y = undefined
8130 2340              ;               P = nvmxdizc
8131 2340              ;                   ..000..1 = error
8132 2340              ;                          0 = no error
8133 2340              ;               b = k
8134 2340              ;
8135 2340              ;Uses:          All registers
8136 2340              ;               Device Dispatcher       (subroutine)
8137 2340              ;               General I/O Buffer      (1K buffer, I read 512 bytes)
8138 2340
8139 2340              build_file                              ;
8140 2340 20 B5 1B              jsr   extend_subdir            ;extend the directory IF needed.
8141 2343 90 01                 bcc   chk_storage
8142 2345 60                    rts   
8143 2346
8144 2346              chk_storage                             ;
8145 2346 AD 3E 05              lda   storage_type             ;see what we are creating
8146 2349 C9 D0 00              cmp   #subdir_type
8147 234C D0 07                 bne   chk_next1
8148 234E 20 5F 26              jsr   create_subdir            ;make a subdirectory
8149 2351 B0 26                 bcs   build_failed
8150 2353 80 2A                 bra   write_dir_entry
8151 2355
8152 2355              chk_next1                               ;
8153 2355 C9 50 00              cmp   #resource_type
8154 2358 D0 07                 bne   chk_next2
8155 235A 20 4A 25              jsr   create_resource          ;make a resource file
8156 235D B0 1A                 bcs   build_failed
8157 235F 80 1E                 bra   write_dir_entry
8158 2361
8159 2361              chk_next2                               ;
8160 2361 C9 30 00              cmp   #tree_type
8161 2364 D0 07                 bne   chk_next3
8162 2366 20 A4 24              jsr   create_tree              ;make a tree file
8163 2369 B0 0E                 bcs   build_failed
8164 236B 80 12                 bra   write_dir_entry
8165 236D
8166 236D              chk_next3                               ;
8167 236D C9 20 00              cmp   #sapling_type
8168 2370 D0 08                 bne   do_seedling
8169 2372 20 35 24              jsr   create_sapling           ;make a sapling file
8170 2375 B0 02                 bcs   build_failed
8171 2377 80 06                 bra   write_dir_entry
8172 2379
8173 2379              build_failed                            ;
8174 2379 60                    rts   
8175 237A
8176 237A 20 15 24     do_seedling jsr   create_seedling
8177 237D B0 FA                 bcs   build_failed
8178 237F
8179 237F              write_dir_entry  
8180 237F
8181 237F 20 82 15              jsr   set_default_buf          ;get ready to write the dir entry.
8182 2382 20 8D 15              jsr   standard_req
8183 2385 AD E5 04              lda   free_dir_blk             ;where to store dir entry
8184 2388 85 10                 sta   drvr_blk_num
8185 238A 20 95 17              jsr   read_with_cache          ;read in the directory block
8186 238D B0 EA                 bcs   build_failed             ;this is real bad news! bitmap killed.
8187 238F
8188 238F AD E1 04              lda   dir_start_blk
8189 2392 8D 66 05              sta   one_entry+header_ptr_index
8190 2395              ;
8191 2395              ;now let's save the case state of the file please
8192 2395              ;
8193 2395 AD 0F 03              lda   case_bits                ;case bits for this file
8194 2398 F0 0E                 beq   @its_all_upper
8195 239A 2C 0E 00              bit   fst_attr                 ;If the user has set all upper then skip case code
8196 239D 30 09                 bmi   @its_all_upper
8197 239F 09 00 80              ora   #$8000                   ;set the case active bit.
8198 23A2 8D 0F 03              sta   case_bits
8199 23A5 8D 5D 05              sta   one_entry+version_index
8200 23A8              @its_all_upper  
8201 23A8 A2 01 00              ldx   #$0001
8202 23AB AC E7 04              ldy   free_dir_offset
8203 23AE AD 41 05              lda   one_entry
8204 23B1 97 94                 sta   [gbuf_ptr],y
8205 23B3 C8                    iny   
8206 23B4              move_it                                 ;
8207 23B4 BD 41 05              lda   one_entry,x              ;move in the directory entry.
8208 23B7 97 94                 sta   [gbuf_ptr],y
8209 23B9 C8                    iny   
8210 23BA C8                    iny   
8211 23BB E8                    inx   
8212 23BC E8                    inx   
8213 23BD E0 27 00              cpx   #entry_length
8214 23C0 90 F2                 bcc   move_it
8215 23C2
8216 23C2 A5 10                 lda   drvr_blk_num             ;is this 'dir_start_blk'
8217 23C4 CD E1 04              cmp   dir_start_blk            ;If yes then do not write twice
8218 23C7 F0 14                 beq   write_once
8219 23C9
8220 23C9 20 9A 17              jsr   write_with_cache
8221 23CC B0 AB                 bcs   build_failed             ;sorry, your disk is bad now
8222 23CE
8223 23CE 2C 3C 08              bit   expand_flag              ;are we expanding the file?
8224 23D1 30 2B                 bmi   chk_pcount               ;don't change the number of files in the directory
8225 23D3
8226 23D3 AD E1 04              lda   dir_start_blk            ;now update file count
8227 23D6 85 10                 sta   drvr_blk_num
8228 23D8 20 95 17              jsr   read_with_cache
8229 23DB B0 9C                 bcs   build_failed
8230 23DD
8231 23DD              write_once  
8232 23DD 2C 3C 08              bit   expand_flag              ;are we expanding the file? minus = yes
8233 23E0 30 17                 bmi   dont_update_vcr          ;don't change the number of files in the directory
8234 23E2
8235 23E2 A0 25 00              ldy   #header_file_cnt
8236 23E5 B7 94                 lda   [gbuf_ptr],y             ;load current file count
8237 23E7 1A                    inc   a                        ;bump it by one
8238 23E8 97 94                 sta   [gbuf_ptr],y
8239 23EA
8240 23EA A5 10                 lda   drvr_blk_num             ;see if this is the volume header
8241 23EC C9 02 00              cmp   #vol_dir_start
8242 23EF D0 08                 bne   dont_update_vcr
8243 23F1
8244 23F1 A0 11 00              ldy   #vol_file_count
8245 23F4 B7 88                 lda   [prodos_vcr_ptr],y
8246 23F6 1A                    inc   a                        ;bump file count in vcr also
8247 23F7 97 88                 sta   [prodos_vcr_ptr],y
8248 23F9
8249 23F9              dont_update_vcr                         ;
8250 23F9 20 9A 17              jsr   write_with_cache
8251 23FC B0 16                 bcs   no_store_type
8252 23FE AD B7 05     chk_pcount lda   pcount
8253 2401 C9 05 00              cmp   #$0005                   ;can we return the storage type
8254 2404 B0 01                 bcs   do_store
8255 2406 60                    rts   
8256 2407
8257 2407              do_store                                ;
8258 2407 A0 0C 00              ldy   #pblk_01_stype           ;set the user's storage type
8259 240A AD 3E 05              lda   storage_type
8260 240D 4A                    lsr   a
8261 240E 4A                    lsr   a
8262 240F 4A                    lsr   a
8263 2410 4A                    lsr   a
8264 2411 97 80                 sta   [my_pblk_ptr],y
8265 2413 18                    clc   
8266 2414              no_store_type                           ;
8267 2414 60                    rts                            ;exit with error / no error
8268 2415
8269 2415
8270 2415              ;==========================================================================
8271 2415              ;create_seed..  This routine will create a seedling file on disk.
8272 2415              ;
8273 2415              ;Input:         A = undefined
8274 2415              ;               X = undefined
8275 2415              ;               Y = undefined
8276 2415              ;               P = nvmxdizc
8277 2415              ;                   ..000...
8278 2415              ;               b = k
8279 2415              ;
8280 2415              ;
8281 2415              ;Output:        A = error code if carry set (exit via system exit routine)
8282 2415              ;               X = undefined
8283 2415              ;               Y = undefined
8284 2415              ;               P = nvmxdizc
8285 2415              ;                   ..000..1 = error
8286 2415              ;                          0 = no error
8287 2415              ;               b = k
8288 2415              ;
8289 2415              ;               one_entry               ;ready to be written to disk
8290 2415              ;
8291 2415              ;Uses:          All registers
8292 2415              ;               Device Dispatcher       (subroutine)
8293 2415              ;               General I/O Buffer      (1K buffer, I read 512 bytes)
8294 2415
8295 2415              create_seedling                         ;
8296 2415 A9 01 00              lda   #$0001                   ;allocate one block please
8297 2418 8D 54 05              sta   one_entry+blks_used_index
8298 241B              ;                                       ;setup in default entry
8299 241B A2 00 00              ldx   #$0000                   ;start from the beginning.
8300 241E 20 40 0D              jsr   find_free_blks           ;go and get it
8301 2421 B0 11                 bcs   end_seed                 ;sorry.
8302 2423 8E 52 05              stx   one_entry+key_blk_index
8303 2426 86 10                 stx   drvr_blk_num
8304 2428 20 82 15              jsr   set_default_buf
8305 242B 20 8D 15              jsr   standard_req             ;write 512 bytes please
8306 242E 20 2C 16              jsr   clear_gbuf_low           ;we must write zeros for seedling
8307 2431 20 9A 17              jsr   write_with_cache
8308 2434 60           end_seed rts   
8309 2435
8310 2435              ;==========================================================================
8311 2435              ;create_sapl..  This routine will create a sapling file one disk.
8312 2435              ;
8313 2435              ;Input:         A = undefined
8314 2435              ;               X = undefined
8315 2435              ;               Y = undefined
8316 2435              ;               P = nvmxdizc
8317 2435              ;                   ..000...
8318 2435              ;               b = k
8319 2435              ;
8320 2435              ;
8321 2435              ;Output:        A = error code if carry set (exit via system exit routine)
8322 2435              ;               X = undefined
8323 2435              ;               Y = undefined
8324 2435              ;               P = nvmxdizc
8325 2435              ;                   ..000..1 = error
8326 2435              ;                          0 = no error
8327 2435              ;               b = k
8328 2435              ;
8329 2435              ;               one_entry               ;ready to be written to disk
8330 2435              ;
8331 2435              ;Uses:          All registers
8332 2435              ;               Device Dispatcher       (subroutine)
8333 2435              ;               General I/O Buffer      (1K buffer, I read 512 bytes)
8334 2435
8335 2435              create_sapling                          ;
8336 2435 20 BA 27              jsr   setup_index_ptr          ;setup pointer for add index
8337 2438 20 3E 16              jsr   clear_gbuf_high          ;clear high 512 bytes of general buffer
8338 243B
8339 243B AD 41 05              lda   one_entry                ;adjust the storage type
8340 243E 29 0F FF              and   #$FF0F                   ;clear old stoarge type
8341 2441 09 20 00              ora   #sapling_type
8342 2444 8D 41 05              sta   one_entry
8343 2447
8344 2447 AD EB 04              lda   blks_used1               ;number of blocks needed for file
8345 244A 8D 54 05              sta   one_entry+blks_used_index
8346 244D A2 00 00              ldx   #$0000                   ;start from the beginning
8347 2450 20 40 0D              jsr   find_free_blks           ;see if I have enough room?
8348 2453 B0 26                 bcs   end_sapling
8349 2455 8E 52 05              stx   one_entry+key_blk_index
8350 2458 E8                    inx   
8351 2459 86 AC                 stx   math_temp
8352 245B CD EB 04              cmp   blks_used1               ;did we get all the blocks needed?
8353 245E F0 1C                 beq   big_sapling
8354 2460
8355 2460
8356 2460 9C 93 05              stz   first_free               ;start from the beginning
8357 2463 A0 00 00              ldy   #$0000                   ;starting index
8358 2466 AE EB 04              ldx   blks_used1
8359 2469 CA                    dex                            ;blocks to allocate
8360 246A              sapling_loop                            ;
8361 246A 20 CA 27              jsr   get_one_blk              ;allocate another block
8362 246D B0 0C                 bcs   end_sapling              ;major problems
8363 246F
8364 246F AD 93 05              lda   first_free               ;block number
8365 2472 20 E3 27              jsr   add_index
8366 2475 C8                    iny   
8367 2476 CA                    dex   
8368 2477 F0 17                 beq   write_sap_index
8369 2479 80 EF                 bra   sapling_loop
8370 247B
8371 247B              end_sapling                             ;
8372 247B 60                    rts   
8373 247C
8374 247C              big_sapling                             ;
8375 247C
8376 247C A0 00 00              ldy   #$0000                   ;starting index value
8377 247F AE EB 04              ldx   blks_used1               ;number of blocks allocated
8378 2482 CA                    dex                            ;minus one for index block
8379 2483              build_loop                              ;
8380 2483 A5 AC                 lda   math_temp                ;block number
8381 2485 20 E3 27              jsr   add_index                ;add block to the index
8382 2488 C8                    iny                            ;move to the next index
8383 2489 CA                    dex   
8384 248A F0 04                 beq   write_sap_index          ;write the block to disk
8385 248C E6 AC                 inc   math_temp                ;bump to the next block please
8386 248E 80 F3                 bra   build_loop
8387 2490
8388 2490              write_sap_index                         ;
8389 2490 A5 A4                 lda   temp4_ptr                ;pointer to index block
8390 2492 85 04                 sta   drvr_buf_ptr
8391 2494 A5 A6                 lda   temp4_ptr+2
8392 2496 85 06                 sta   drvr_buf_ptr+2
8393 2498
8394 2498 20 8D 15              jsr   standard_req             ;512 byte transfer
8395 249B
8396 249B AD 52 05              lda   one_entry+key_blk_index
8397 249E 85 10                 sta   drvr_blk_num             ;write the index
8398 24A0 20 9A 17              jsr   write_with_cache
8399 24A3 60                    rts   
8400 24A4
8401 24A4              ;==========================================================================
8402 24A4              ;create_tree..  This routine will create a tree file one disk.
8403 24A4              ;
8404 24A4              ;Input:         A = undefined
8405 24A4              ;               X = undefined
8406 24A4              ;               Y = undefined
8407 24A4              ;               P = nvmxdizc
8408 24A4              ;                   ..000...
8409 24A4              ;               b = k
8410 24A4              ;
8411 24A4              ;
8412 24A4              ;Output:        A = error code if carry set (exit via system exit routine)
8413 24A4              ;               X = undefined
8414 24A4              ;               Y = undefined
8415 24A4              ;               P = nvmxdizc
8416 24A4              ;                   ..000..1 = error
8417 24A4              ;                          0 = no error
8418 24A4              ;               b = k
8419 24A4              ;
8420 24A4              ;               one_entry               ;ready to be written to disk
8421 24A4              ;
8422 24A4              ;Uses:          All registers
8423 24A4              ;               Device Dispatcher       (subroutine)
8424 24A4              ;               General I/O Buffer      (1K buffer, I read 512 bytes)
8425 24A4
8426 24A4              create_tree                             ;
8427 24A4 38                    sec                            ;allocate a 512 byte buffer please
8428 24A5 A9 00 02              lda   #blk_size
8429 24A8 22 1C FC 01           jsl   alloc_seg
8430 24AC B0 7E                 bcs   end_tree                 ;sorry out of memory!!
8431 24AE 8E EF 02              stx   virtual
8432 24B1 8C F1 02              sty   virtual+2                ;save the VP for release seg
8433 24B4 22 38 FC 01           jsl   deref                    ;convert to a real pointer
8434 24B8 86 9C                 stx   temp2_ptr
8435 24BA 84 9E                 sty   temp2_ptr+2              ;save a pointer to buffer
8436 24BC
8437 24BC A9 01 00              lda   #$0001                   ;allocate one block for master index
8438 24BF A2 00 00              ldx   #$0000                   ;start from the beginning
8439 24C2 20 40 0D              jsr   find_free_blks
8440 24C5 B0 65                 bcs   end_tree
8441 24C7 8E 75 05              stx   tree_key_blk             ;save key block of tree file.
8442 24CA
8443 24CA AD EB 04              lda   blks_used1
8444 24CD 8D 38 05              sta   key_block                ;save total blocks please
8445 24D0
8446 24D0 38                    sec   
8447 24D1 AD EB 04              lda   blks_used1               ;remove overhead blocks from count
8448 24D4 ED AD 05              sbc   data_indexes             ;number of index blocks needed
8449 24D7 3A                    dec   a                        ;subtract one for master index block
8450 24D8 8D 77 05              sta   tree_blks
8451 24DB
8452 24DB A0 00 00              ldy   #$0000                   ;starting index for master block
8453 24DE              tree_loop                               ;
8454 24DE A2 00 01              ldx   #256                     ;number of blocks to allocate
8455 24E1 AD 77 05              lda   tree_blks
8456 24E4 C9 00 01              cmp   #256                     ;max blocks+1 in an index block
8457 24E7 B0 01                 bcs   use_max
8458 24E9 AA                    tax                            ;use the remaining blocks
8459 24EA              use_max                                 ;
8460 24EA E8                    inx                            ;add one for index block itself
8461 24EB 8E EB 04              stx   blks_used1               ;this is the amount to allocate
8462 24EE 5A                    phy   
8463 24EF 20 35 24              jsr   create_sapling           ;build a sapling index
8464 24F2 7A                    ply   
8465 24F3 B0 37                 bcs   end_tree                 ;major problems
8466 24F5 20 3B 25              jsr   add_master_index
8467 24F8 C8                    iny                            ;advance to next index please
8468 24F9 38                    sec   
8469 24FA AD 77 05              lda   tree_blks                ;number of blocks left
8470 24FD E9 00 01              sbc   #256
8471 2500 8D 77 05              sta   tree_blks
8472 2503 F0 02                 beq   write_tree
8473 2505 B0 D7                 bcs   tree_loop                ;do another index block
8474 2507
8475 2507              write_tree                              ;
8476 2507 AD 41 05              lda   one_entry
8477 250A 29 0F FF              and   #$FF0F                   ;change storage to tree type
8478 250D 09 30 00              ora   #tree_type
8479 2510 8D 41 05              sta   one_entry
8480 2513
8481 2513 AD 38 05              lda   key_block
8482 2516 8D 54 05              sta   one_entry+blks_used_index
8483 2519
8484 2519 A5 9C                 lda   temp2_ptr                ;setup pointer for write
8485 251B 85 04                 sta   drvr_buf_ptr
8486 251D A5 9E                 lda   temp2_ptr+2
8487 251F 85 06                 sta   drvr_buf_ptr+2
8488 2521
8489 2521 AD 75 05              lda   tree_key_blk
8490 2524 85 10                 sta   drvr_blk_num
8491 2526 8D 52 05              sta   one_entry+key_blk_index
8492 2529 20 9A 17              jsr   write_with_cache
8493 252C
8494 252C              end_tree   
8495 252C 08                    php                            ;save error flag
8496 252D 48                    pha                            ;save error if any
8497 252E AE EF 02              ldx   virtual
8498 2531 AC F1 02              ldy   virtual+2
8499 2534 22 20 FC 01           jsl   release_seg              ;give up the temp buffer
8500 2538 68                    pla   
8501 2539 28                    plp   
8502 253A 60                    rts                            ;return any error
8503 253B
8504 253B
8505 253B              add_master_index  
8506 253B
8507 253B A5 9C                 lda   temp2_ptr                ;setup pointer to master index block
8508 253D 85 A4                 sta   temp4_ptr
8509 253F A5 9E                 lda   temp2_ptr+2
8510 2541 85 A6                 sta   temp4_ptr+2
8511 2543
8512 2543 AD 52 05              lda   one_entry+key_blk_index
8513 2546 20 E3 27              jsr   add_index
8514 2549 60                    rts   
8515 254A
8516 254A
8517 254A              ;==========================================================================
8518 254A              ;create_res...  This routine will create a resource file.
8519 254A              ;
8520 254A              ;Input:         A = undefined
8521 254A              ;               X = undefined
8522 254A              ;               Y = undefined
8523 254A              ;               P = nvmxdizc
8524 254A              ;                   ..000...
8525 254A              ;               b = k
8526 254A              ;
8527 254A              ;
8528 254A              ;Output:        A = error code if carry set (exit via system exit routine)
8529 254A              ;               X = undefined
8530 254A              ;               Y = undefined
8531 254A              ;               P = nvmxdizc
8532 254A              ;                   ..000..1 = error
8533 254A              ;                          0 = no error
8534 254A              ;               b = k
8535 254A              ;
8536 254A              ;               one_entry               ;ready to be written to disk
8537 254A              ;
8538 254A              ;Uses:          All registers
8539 254A              ;               Device Dispatcher       (subroutine)
8540 254A              ;               General I/O Buffer      (1K buffer, I read 512 bytes)
8541 254A              ;               512 bytes additional mem
8542 254A
8543 254A              create_resource                         ;
8544 254A A9 05 05              lda   #prodos_version+(prodos_version*$100)
8545 254D 8D 5D 05              sta   one_entry+version_index
8546 2550
8547 2550 18                    clc   
8548 2551 AD EB 04              lda   blks_used1
8549 2554 6D ED 04              adc   blks_used2
8550 2557 1A                    inc   a                        ;add one for resource header
8551 2558 8D F5 04              sta   res_tot_blks
8552 255B
8553 255B 38                    sec                            ;allocate a 512 byte buffer please
8554 255C A9 00 02              lda   #blk_size
8555 255F 22 1C FC 01           jsl   alloc_seg
8556 2563 B0 17                 bcs   @to_end                  ;sorry out of memory!!
8557 2565 8E F3 02              stx   virtual2
8558 2568 8C F5 02              sty   virtual2+2               ;save the VP for release seg
8559 256B 22 38 FC 01           jsl   deref                    ;convert to a real pointer
8560 256F 86 A8                 stx   temp5_ptr                ;real pointer to buffer
8561 2571 84 AA                 sty   temp5_ptr+2
8562 2573
8563 2573 A9 01 00              lda   #$0001                   ;allocate one block for resource header
8564 2576 A2 00 00              ldx   #$0000                   ;start from the beginning
8565 2579 20 40 0D              jsr   find_free_blks
8566 257C B0 76        @to_end  bcs   end_resource
8567 257E 8E F7 04              stx   res_key_blk              ;save key block of resource file.
8568 2581
8569 2581 AD F1 04              lda   data_storage             ;go and create the correct data fork
8570 2584 20 03 26              jsr   make_fork
8571 2587 B0 6B                 bcs   end_resource             ;major problems
8572 2589 A0 00 00              ldy   #$0000
8573 258C AD F1 04              lda   data_storage
8574 258F 20 3E 26              jsr   save_fork_info
8575 2592              ;
8576 2592              ;Below is a hack.  Since the create call was written to add in a directory entry not update 
8577 2592              ;an entry, we have to full the update directory routine.  To do this I copy in the directory
8578 2592              ;block and entry offset into "free_dir_blk" and "free_dir_offset"  This will make the 
8579 2592              ;directory update routine work.  This is the way we make code do more then it was meant to do.
8580 2592              ;
8581 2592 2C 3E 08              bit   expand_file              ;are we extending the file?
8582 2595 10 0C                 bpl   @no_extend
8583 2597 AD E3 04              lda   dir_last_blk             ;block number of the directory
8584 259A 8D E5 04              sta   free_dir_blk
8585 259D AD 17 06              lda   entries_offset           ;offset to the entry within the dir block
8586 25A0 8D E7 04              sta   free_dir_offset
8587 25A3              @no_extend  
8588 25A3 9C 3E 08              stz   expand_file              ;we are now thru with the data fork so reset the expand flag
8589 25A6 9C 56 05              stz   one_entry+eof_index
8590 25A9 9C 57 05              stz   one_entry+eof_index+1
8591 25AC
8592 25AC AD ED 04              lda   blks_used2               ;setup for resource fork create
8593 25AF 8D EB 04              sta   blks_used1
8594 25B2 AD AF 05              lda   res_indexes
8595 25B5 8D AD 05              sta   data_indexes             ;used if we are creating a tree file.
8596 25B8
8597 25B8 AD F3 04              lda   res_storage              ;go and create the correct res fork
8598 25BB 20 03 26              jsr   make_fork
8599 25BE B0 34                 bcs   end_resource             ;major problems
8600 25C0
8601 25C0 A0 00 01              ldy   #$0100
8602 25C3 AD F3 04              lda   res_storage
8603 25C6 20 3E 26              jsr   save_fork_info
8604 25C9
8605 25C9              write_res   
8606 25C9 AD 41 05              lda   one_entry
8607 25CC 29 0F FF              and   #$FF0F                   ;change storage to resource type
8608 25CF 09 50 00              ora   #resource_type
8609 25D2 8D 41 05              sta   one_entry
8610 25D5
8611 25D5 AD F5 04              lda   res_tot_blks
8612 25D8 8D 54 05              sta   one_entry+blks_used_index
8613 25DB
8614 25DB A5 A8                 lda   temp5_ptr                ;setup pointer for write
8615 25DD 85 04                 sta   drvr_buf_ptr
8616 25DF A5 AA                 lda   temp5_ptr+2
8617 25E1 85 06                 sta   drvr_buf_ptr+2
8618 25E3
8619 25E3 AD F7 04              lda   res_key_blk
8620 25E6 85 10                 sta   drvr_blk_num
8621 25E8 8D 52 05              sta   one_entry+key_blk_index
8622 25EB A9 00 02              lda   #blk_size
8623 25EE 8D 56 05              sta   one_entry+eof_index
8624 25F1 20 9A 17              jsr   write_with_cache
8625 25F4
8626 25F4              end_resource   
8627 25F4 48                    pha   
8628 25F5 08                    php   
8629 25F6 AE F3 02              ldx   virtual2                 ;give back the 512 byte temp buffer
8630 25F9 AC F5 02              ldy   virtual2+2
8631 25FC 22 20 FC 01           jsl   release_seg
8632 2600 28                    plp   
8633 2601 68                    pla   
8634 2602 60                    rts   
8635 2603
8636 2603
8637 2603              make_fork                               ;A = storage type
8638 2603 2C 3E 08              bit   expand_file              ;are we expanding an existing file?
8639 2606 10 20                 bpl   @not_expanding
8640 2608              ;
8641 2608              ;If we are expanding an existing file I will setup the entry parameters as if I 
8642 2608              ;had just created the file.  This way we will just bypass the create call.
8643 2608              ;
8644 2608 AD 40 08              lda   expand_storage           ;move the real storage type
8645 260B 8D F1 04              sta   data_storage
8646 260E AD 42 08              lda   expand_key_blk           ;move the real key block of the file
8647 2611 8D 52 05              sta   one_entry+key_blk_index
8648 2614 AD 44 08              lda   expand_blks_used
8649 2617 8D 54 05              sta   one_entry+blks_used_index
8650 261A AD 46 08              lda   expand_eof
8651 261D 8D 56 05              sta   one_entry+eof_index
8652 2620 AD 47 08              lda   expand_eof+1
8653 2623 8D 57 05              sta   one_entry+eof_index+1
8654 2626 18                    clc   
8655 2627 60                    rts   
8656 2628
8657 2628              @not_expanding  
8658 2628 C9 10 00              cmp   #seedling_type
8659 262B D0 04                 bne   res_sap
8660 262D 20 15 24              jsr   create_seedling
8661 2630 60                    rts   
8662 2631
8663 2631              res_sap                                 ;
8664 2631 C9 20 00              cmp   #sapling_type
8665 2634 D0 04                 bne   res_tree
8666 2636 20 35 24              jsr   create_sapling
8667 2639 60                    rts   
8668 263A
8669 263A              res_tree                                ;
8670 263A 20 A4 24              jsr   create_tree
8671 263D 60                    rts   
8672 263E
8673 263E              save_fork_info                          ;A = storage, Y = index into header
8674 263E 4A                    lsr   a                        ;temp5_ptr = pointer to header
8675 263F 4A                    lsr   a
8676 2640 4A                    lsr   a
8677 2641 4A                    lsr   a
8678 2642 97 A8                 sta   [temp5_ptr],y
8679 2644 C8                    iny   
8680 2645 AD 52 05              lda   one_entry+key_blk_index
8681 2648 97 A8                 sta   [temp5_ptr],y
8682 264A C8                    iny   
8683 264B C8                    iny   
8684 264C AD 54 05              lda   one_entry+blks_used_index
8685 264F 97 A8                 sta   [temp5_ptr],y
8686 2651 C8                    iny   
8687 2652 C8                    iny   
8688 2653 AD 56 05              lda   one_entry+eof_index
8689 2656 97 A8                 sta   [temp5_ptr],y
8690 2658 C8                    iny   
8691 2659 AD 57 05              lda   one_entry+eof_index+1
8692 265C 97 A8                 sta   [temp5_ptr],y
8693 265E 60                    rts   
8694 265F
8695 265F
8696 265F              ;==========================================================================
8697 265F              ;create_subdir  This routine will create a new subdirectory on disk
8698 265F              ;
8699 265F              ;Input:         A = undefined
8700 265F              ;               X = undefined
8701 265F              ;               Y = undefined
8702 265F              ;               P = nvmxdizc
8703 265F              ;                   ..000...
8704 265F              ;               b = k
8705 265F              ;
8706 265F              ;
8707 265F              ;Output:        A = error code if carry set (exit via system exit routine)
8708 265F              ;               X = undefined
8709 265F              ;               Y = undefined
8710 265F              ;               P = nvmxdizc
8711 265F              ;                   ..000..1 = error
8712 265F              ;                          0 = no error
8713 265F              ;               b = k
8714 265F              ;
8715 265F              ;               one_entry               ;ready to be written to disk
8716 265F              ;
8717 265F              ;Uses:          All registers
8718 265F              ;               Device Dispatcher       (subroutine)
8719 265F              ;               General I/O Buffer      (1K buffer, I read 512 bytes)
8720 265F              ;
8721 265F
8722 265F              create_subdir                           ;
8723 265F 20 BA 27              jsr   setup_index_ptr          ;setup temp4_ptr to point to gbuf+$200
8724 2662 20 3E 16              jsr   clear_gbuf_high          ;clear high 512 bytes of general buffer
8725 2665
8726 2665 A9 0F 00              lda   #$000F                   ;force file type to subdirectory
8727 2668 8D 51 05              sta   one_entry+file_type_index
8728 266B
8729 266B AD EB 04              lda   blks_used1               ;number of blocks needed for subdir.
8730 266E 8D 54 05              sta   one_entry+blks_used_index
8731 2671 AA                    tax   
8732 2672 0A                    asl   a                        ;convert blocks to EOF
8733 2673 8D 57 05              sta   one_entry+eof_index+1
8734 2676
8735 2676 8A                    txa   
8736 2677 A2 00 00              ldx   #$0000                   ;start from the beginning
8737 267A 20 40 0D              jsr   find_free_blks           ;see if I have enough room?
8738 267D B0 52                 bcs   end_subdir               ;major problem my friend
8739 267F 8E 52 05              stx   one_entry+key_blk_index
8740 2682 8E 79 05              stx   parent_blk
8741 2685 E8                    inx   
8742 2686 86 AC                 stx   math_temp
8743 2688 48                    pha                            ;save number of blocks allocated
8744 2689 20 2B 27              jsr   make_sub_header          ;build the header block to disk
8745 268C 68                    pla   
8746 268D CD EB 04              cmp   blks_used1               ;did we get all the blocks needed?
8747 2690 F0 50                 beq   seq_subdir               ;yes we can make the directory seq
8748 2692
8749 2692 CE EB 04              dec   blks_used1
8750 2695
8751 2695              non_seq_loop                            ;
8752 2695 A9 01 00              lda   #$0001                   ;allocate one block
8753 2698 A2 00 00              ldx   #$0000                   ;start from the beginning
8754 269B 20 40 0D              jsr   find_free_blks
8755 269E B0 31                 bcs   end_subdir
8756 26A0 86 AC                 stx   math_temp                ;the new block.
8757 26A2 8A                    txa   
8758 26A3 AE 79 05              ldx   parent_blk               ;block that needs to be written
8759 26A6 20 18 27              jsr   update_forward
8760 26A9 B0 26                 bcs   end_subdir
8761 26AB
8762 26AB AD 52 05              lda   one_entry+key_blk_index
8763 26AE CD 79 05              cmp   parent_blk
8764 26B1 D0 03                 bne   no_clr
8765 26B3
8766 26B3 20 3E 16              jsr   clear_gbuf_high          ;clear high 512 bytes of general buffer
8767 26B6
8768 26B6              no_clr                                  ;
8769 26B6 AD 79 05              lda   parent_blk               ;update backward link please
8770 26B9 87 A4                 sta   [temp4_ptr]
8771 26BB A5 AC                 lda   math_temp                ;this is the new block to write
8772 26BD 8D 79 05              sta   parent_blk
8773 26C0 CE EB 04              dec   blks_used1               ;see if we are done
8774 26C3 D0 D0                 bne   non_seq_loop
8775 26C5 A9 00 00              lda   #$0000
8776 26C8 A6 AC                 ldx   math_temp
8777 26CA 20 18 27              jsr   update_forward
8778 26CD 90 02                 bcc   end_subdir
8779 26CF 60                    rts   
8780 26D0
8781 26D0              good_subdir  
8782 26D0 18                    clc   
8783 26D1
8784 26D1              end_subdir  
8785 26D1 08                    php                            ;save error flag
8786 26D2 48                    pha   
8787 26D3 AD 41 05              lda   one_entry
8788 26D6 29 0F FF              and   #$FF0F                   ;change storage to subdirectory
8789 26D9 09 D0 00              ora   #subdir_type
8790 26DC 8D 41 05              sta   one_entry
8791 26DF 68                    pla                            ;restore possible error code
8792 26E0 28                    plp                            ;restore error flag
8793 26E1 60                    rts   
8794 26E2
8795 26E2              seq_subdir                              ;
8796 26E2 A9 00 00              lda   #$0000                   ;default forward link
8797 26E5 AC EB 04              ldy   blks_used1
8798 26E8 88                    dey                            ;is there another block?
8799 26E9 F0 02                 beq   last_dir_blk
8800 26EB A5 AC                 lda   math_temp                ;forward link
8801 26ED
8802 26ED              last_dir_blk                            ;
8803 26ED AE 52 05              ldx   one_entry+key_blk_index  ;block to write to disk
8804 26F0 20 18 27              jsr   update_forward           ;write the block to disk
8805 26F3 B0 DC                 bcs   end_subdir               ;bad news
8806 26F5 20 3E 16              jsr   clear_gbuf_high          ;clear high 512 bytes of general buffer
8807 26F8
8808 26F8              seq_sub_loop                            ;
8809 26F8 CE EB 04              dec   blks_used1               ;see if we are done
8810 26FB F0 D3                 beq   good_subdir
8811 26FD
8812 26FD A5 10                 lda   drvr_blk_num             ;this is the backward link now
8813 26FF 87 A4                 sta   [temp4_ptr]
8814 2701
8815 2701 A9 00 00              lda   #$0000
8816 2704 AC EB 04              ldy   blks_used1               ;is there more blocks to write?
8817 2707 88                    dey   
8818 2708 F0 03                 beq   write_last               ;no this is the last one
8819 270A A5 AC                 lda   math_temp
8820 270C 1A                    inc   a                        ;make a forward link
8821 270D
8822 270D              write_last                              ;
8823 270D A6 AC                 ldx   math_temp                ;block number to write
8824 270F E6 AC                 inc   math_temp                ;bump to the next block
8825 2711 20 18 27              jsr   update_forward
8826 2714 90 E2                 bcc   seq_sub_loop
8827 2716 80 B9                 bra   end_subdir
8828 2718
8829 2718
8830 2718              ;==========================================================================
8831 2718              ;update_forward This routine will update the forward link of a directory
8832 2718              ;               block then write the block to disk.
8833 2718              ;
8834 2718              ;input:         A = forward link
8835 2718              ;               X = block number to write
8836 2718              ;
8837 2718              ;output:        A = error code if carry set
8838 2718              ;
8839 2718              update_forward                          ;
8840 2718 A0 02 00              ldy   #$0002                   ;forward link
8841 271B 97 A4                 sta   [temp4_ptr],y
8842 271D 86 10                 stx   drvr_blk_num             ;save block number to write
8843 271F
8844 271F A5 A4                 lda   temp4_ptr                ;setup pointer to block.
8845 2721 85 04                 sta   drvr_buf_ptr
8846 2723 A5 A6                 lda   temp4_ptr+2
8847 2725 85 06                 sta   drvr_buf_ptr+2
8848 2727
8849 2727 20 9A 17              jsr   write_with_cache
8850 272A 60                    rts                            ;update the disk!
8851 272B
8852 272B              ;==========================================================================
8853 272B              ;This routine will create the header block for the subdirectory.
8854 272B              ;
8855 272B              ;input:         X = header block +1
8856 272B              ;               temp4_ptr = pointer to work buffer
8857 272B
8858 272B              make_sub_header                         ;
8859 272B CA                    dex                            ;block number to write
8860 272C 86 10                 stx   drvr_blk_num
8861 272E 18                    clc   
8862 272F A5 A4                 lda   temp4_ptr
8863 2731 85 04                 sta   drvr_buf_ptr
8864 2733 69 04 00              adc   #$0004
8865 2736 85 98                 sta   temp_ptr
8866 2738 A5 A6                 lda   temp4_ptr+2              ;setup pointer for the write
8867 273A 85 06                 sta   drvr_buf_ptr+2
8868 273C 69 00 00              adc   #$0000
8869 273F 85 9A                 sta   temp_ptr+2               ;setup pointer to header
8870 2741
8871 2741 A0 26 00              ldy   #entry_length-1
8872 2744              move_header                             ;
8873 2744 B9 41 05              lda   one_entry,y
8874 2747 97 98                 sta   [temp_ptr],y
8875 2749 88                    dey   
8876 274A 88                    dey   
8877 274B 10 F7                 bpl   move_header              ;move the header into first block
8878 274D
8879 274D A0 1E 00              ldy   #access_index
8880 2750 B7 98                 lda   [temp_ptr],y
8881 2752 29 00 FF              and   #$FF00
8882 2755 09 C3 00              ora   #$00C3
8883 2758 97 98                 sta   [temp_ptr],y
8884 275A
8885 275A A7 98                 lda   [temp_ptr]
8886 275C 29 0F FF              and   #$FF0F
8887 275F 09 E0 00              ora   #subdir_header
8888 2762 87 98                 sta   [temp_ptr]
8889 2764
8890 2764 A0 1F 00              ldy   #$001F                   ;index to entry len and entries per blk
8891 2767 A9 27 0D              lda   #$0D27                   ;13 entries per blk and 39 byte entries
8892 276A 97 98                 sta   [temp_ptr],y
8893 276C C8                    iny   
8894 276D C8                    iny                            ;point to file count
8895 276E A9 00 00              lda   #$0000
8896 2771 97 98                 sta   [temp_ptr],y             ;no files yet
8897 2773 C8                    iny   
8898 2774 C8                    iny   
8899 2775 AD E5 04              lda   free_dir_blk             ;parent pointer
8900 2778 97 98                 sta   [temp_ptr],y
8901 277A C8                    iny   
8902 277B C8                    iny   
8903 277C 20 9E 27              jsr   make_entry_num
8904 277F 90 03                 bcc   go_on_please
8905 2781 4C 82 00              jmp   main_exit
8906 2784
8907 2784              go_on_please  
8908 2784 97 98                 sta   [temp_ptr],y
8909 2786
8910 2786 A0 10 00              ldy   #$0010                   ;clear reserved area
8911 2789 A9 00 00              lda   #$0000
8912 278C              clear_reserved  
8913 278C 97 98                 sta   [temp_ptr],y
8914 278E C8                    iny   
8915 278F C8                    iny   
8916 2790 C0 18 00              cpy   #$0018
8917 2793 90 F7                 bcc   clear_reserved
8918 2795
8919 2795 A0 10 00              ldy   #$0010                   ;setup for no 'HUSTON'
8920 2798 A9 76 00              lda   #$0076
8921 279B 97 98                 sta   [temp_ptr],y
8922 279D 60                    rts   
8923 279E
8924 279E                       EXPORT make_entry_num
8925 279E              make_entry_num  
8926 279E A2 18 00              ldx   #(12*2)                  ;index into offset table
8927 27A1 AD E7 04              lda   free_dir_offset
8928 27A4 DD CB 01     offset_loop cmp   dir_offset_tbl,x
8929 27A7 F0 09                 beq   found_offset
8930 27A9 CA                    dex   
8931 27AA CA                    dex   
8932 27AB 10 F7                 bpl   offset_loop
8933 27AD
8934 27AD A9 51 00              lda   #dir_error
8935 27B0 38                    sec   
8936 27B1 60                    rts   
8937 27B2
8938 27B2              found_offset  
8939 27B2
8940 27B2 8A                    txa   
8941 27B3 4A                    lsr   a                        ;divide by two
8942 27B4 1A                    inc   a                        ;add one to convert from zero based.
8943 27B5 09 00 27              ora   #$2700                   ;add in parent entry length
8944 27B8 18                    clc   
8945 27B9 60                    rts   
8946 27BA
8947 27BA              ;==========================================================================
8948 27BA              ;setup_index... This routine will setup temp4_ptr to point to the second
8949 27BA              ;               half of the general work buffer supplied by GS/OS.
8950 27BA              ;==========================================================================
8951 27BA              setup_index_ptr  
8952 27BA 18                    clc   
8953 27BB A5 94                 lda   gbuf_ptr                 ;set temp4_ptr to point to second
8954 27BD 69 00 02              adc   #$0200                   ;have of the general work buffer.
8955 27C0 85 A4                 sta   temp4_ptr
8956 27C2 A5 96                 lda   gbuf_ptr+2
8957 27C4 69 00 00              adc   #$0000
8958 27C7 85 A6                 sta   temp4_ptr+2
8959 27C9 60                    rts   
8960 27CA
8961 27CA              ;==========================================================================
8962 27CA              ;get_one_blk    This routine will allocate one block from disk
8963 27CA              ;
8964 27CA              ;Input:         A = undefined
8965 27CA              ;               X = undefined
8966 27CA              ;               Y = undefined
8967 27CA              ;               P = nvmxdizc
8968 27CA              ;                   ..000...
8969 27CA              ;               b = k
8970 27CA              ;
8971 27CA              ;               gbuf_ptr
8972 27CA              ;
8973 27CA              ;Output:        A = restored  or error code if carry set.
8974 27CA              ;               X = restored
8975 27CA              ;               Y = restored
8976 27CA              ;               P = nvmxdizc
8977 27CA              ;                   ..000..1 = error
8978 27CA              ;                          0 = no error
8979 27CA              ;               b = k
8980 27CA              ;
8981 27CA              ;               first_free              ;block number allocated
8982 27CA              ;
8983 27CA              ;Uses:          find_free_blks
8984 27CA              ;
8985 27CA              ;==========================================================================
8986 27CA
8987 27CA              get_one_blk  
8988 27CA 48                    pha   
8989 27CB DA                    phx   
8990 27CC 5A                    phy   
8991 27CD
8992 27CD A9 01 00              lda   #$0001                   ;allocate one block
8993 27D0 AE 93 05              ldx   first_free               ;start at the beginning
8994 27D3 20 40 0D              jsr   find_free_blks
8995 27D6 B0 05                 bcs   exit_with_err
8996 27D8 8E 93 05              stx   first_free
8997 27DB 80 02                 bra   exit_one_blk
8998 27DD
8999 27DD              exit_with_err  
9000 27DD 83 05                 sta   5,s                      ;store the error code on the stack!
9001 27DF
9002 27DF              exit_one_blk  
9003 27DF 7A                    ply   
9004 27E0 FA                    plx   
9005 27E1 68                    pla   
9006 27E2 60                    rts   
9007 27E3
9008 27E3              ;==========================================================================
9009 27E3              ;add_index      This routine will add in a block to an index buffer.
9010 27E3              ;
9011 27E3              ;Input:         A = block number
9012 27E3              ;               X = undefined
9013 27E3              ;               Y = index into buffer
9014 27E3              ;               P = nvmxdizc
9015 27E3              ;                   ..000...
9016 27E3              ;               b = k
9017 27E3              ;
9018 27E3              ;               temp4_ptr
9019 27E3              ;
9020 27E3              ;Output:        A = restored
9021 27E3              ;               X = restored
9022 27E3              ;               Y = restored
9023 27E3              ;               P = nvmxdizc
9024 27E3              ;                   ..000...
9025 27E3              ;               b = k
9026 27E3              ;
9027 27E3              ;
9028 27E3              ;Uses:          temp4_ptr
9029 27E3              ;
9030 27E3              ;==========================================================================
9031 27E3
9032 27E3                       EXPORT add_index
9033 27E3              add_index  
9034 27E3 DA                    phx   
9035 27E4 5A                    phy   
9036 27E5 48                    pha   
9037 27E6
9038 27E6 98                    tya   
9039 27E7 09 00 01              ora   #$0100                   ;index to second half of buffer
9040 27EA AA                    tax   
9041 27EB
9042 27EB A3 01                 lda   1,s
9043 27ED                       longa off
9044 27ED E2 20                 sep   #$20
9045 27EF 97 A4                 sta   [temp4_ptr],y            ;store the low byte please
9046 27F1 9B                    txy                            ;index to second half of buffer
9047 27F2 EB                    xba                            ;high word of the block number
9048 27F3 97 A4                 sta   [temp4_ptr],y
9049 27F5                       longa on
9050 27F5 C2 20                 rep   #$20
9051 27F7
9052 27F7 68                    pla                            ;restore A
9053 27F8 7A                    ply                            ;restore Y
9054 27F9 FA                    plx                            ;restore X
9055 27FA 60                    rts                            ;exit
9056 27FB
9057 27FB
9058 27FB              ;==========================================================================
9059 27FB              ;eof_to_blks    This routine will convert the size of the file into the
9060 27FB              ;               number of blocks needed to store the file on disk.  The
9061 27FB              ;               routine does NOT account for directory extension that is
9062 27FB              ;               handled elsewhere,  it does however account for storage
9063 27FB              ;               type.
9064 27FB              ;
9065 27FB              ;Input:         data_eof                ;size of data fork
9066 27FB              ;               res_eof                 ;size of resource fork
9067 27FB              ;
9068 27FB              ;output:        blks_used1              ;blocks needed for data fork/subdir
9069 27FB              ;               blks_used2              ;blocks needed for resource fork
9070 27FB              ;
9071 27FB              ;==========================================================================
9072 27FB                       EXPORT eof_to_blks
9073 27FB              eof_to_blks  
9074 27FB AD 3E 08              lda   expand_file              ;are we expanding a file or building a new one?
9075 27FE 10 08                 bpl   @its_new
9076 2800
9077 2800 AD 44 08              lda   expand_blks_used
9078 2803 8D EB 04              sta   blks_used1               ;set the number of blocks needed for current file
9079 2806 80 14                 bra   do_res                   ;now do the resource fork
9080 2808              @its_new  
9081 2808 AD 6E 05              lda   data_eof+1               ;convert bytes to blocks
9082 280B 4A                    lsr   a
9083 280C 8D EB 04              sta   blks_used1               ;blocks needed by data fork
9084 280F F0 08                 beq   bump_blks1               ;see if we need to round up
9085 2811 AD 6D 05              lda   data_eof                 ;see if size is < 512
9086 2814 29 FF 01              and   #$01FF
9087 2817 F0 03                 beq   do_res                   ;no need to bump
9088 2819              bump_blks1                              ;
9089 2819 EE EB 04              inc   blks_used1
9090 281C
9091 281C              do_res    
9092 281C AD 3E 05              lda   storage_type             ;do we need resources?
9093 281F C9 50 00              cmp   #resource_type
9094 2822 D0 14                 bne   end_eof_conv             ;not a resource file
9095 2824
9096 2824 AD 72 05              lda   res_eof+1                ;convert bytes to blocks
9097 2827 4A                    lsr   a
9098 2828 8D ED 04              sta   blks_used2               ;blocks needed by data fork
9099 282B F0 08                 beq   bump_blks2               ;see if we need to round up
9100 282D AD 71 05              lda   res_eof                  ;see if size is < 512
9101 2830 29 FF 01              and   #$01FF
9102 2833 F0 03                 beq   end_eof_conv             ;no need to bump resource size
9103 2835              bump_blks2                              ;
9104 2835 EE ED 04              inc   blks_used2               ;add for resource file
9105 2838
9106 2838              end_eof_conv  
9107 2838 AD 3E 08              lda   expand_file              ;are we expanding a file or building a new one?
9108 283B 30 0F                 bmi   @skip_adjust             ;since the blocks used is already the total skip adjust
9109 283D
9110 283D AD EB 04              lda   blks_used1               ;add any storage overhead for data fork
9111 2840 20 C9 28              jsr   adjust_storage
9112 2843 8D EB 04              sta   blks_used1
9113 2846 8C F1 04              sty   data_storage             ;storage type for data fork
9114 2849 8E AD 05              stx   data_indexes             ;number of index blocks
9115 284C              @skip_adjust  
9116 284C AD ED 04              lda   blks_used2               ;add any storage overhead for res. fork
9117 284F 20 C9 28              jsr   adjust_storage
9118 2852 8D ED 04              sta   blks_used2
9119 2855 8C F3 04              sty   res_storage              ;storage type for resource fork
9120 2858 8E AF 05              stx   res_indexes              ;number if inedx blocks
9121 285B 60                    rts   
9122 285C
9123 285C              ;==========================================================================
9124 285C              ;do_create_path This routine will setup the flags needed to process the
9125 285C              ;               input pathname. we only return from the subroutine if
9126 285C              ;               everything with the pathname is OK.
9127 285C              ;
9128 285C              ;input:         none
9129 285C              ;
9130 285C              ;output:        seach_name is still valid from find file.
9131 285C              ;
9132 285C              ;==========================================================================
9133 285C              do_create_path  
9134 285C A9 00 C0              lda   #no_root+no_dup          ;root level or duplciate is not valid.
9135 285F 8D DF 04              sta   search_flag
9136 2862 20 23 10              jsr   process_path
9137 2865 B0 59                 bcs   no_dup_problem           ;there is no duplicate file
9138 2867              ;
9139 2867              ;If the file already is on the disk we need to see if we are adding the resource
9140 2867              ;fork.  If we are adding the resource fork we will pull out the important information
9141 2867              ;from the current file entry (data fork) and save if so we can use it to build the
9142 2867              ;data fork of are new extended file
9143 2867              ;
9144 2867 A0 0C 00              ldy   #pblk_01_stype           ;see if we are adding a resource fork to the file
9145 286A B7 80                 lda   [my_pblk_ptr],y          ;get the input storage type
9146 286C C9 05 80              cmp   #(resource_type/$10)+$8000
9147 286F D0 47                 bne   @not_an_extend
9148 2871 8D 3E 08              sta   expand_file              ;set the flag indicating we are extending the file
9149 2874 8D 3C 08              sta   expand_flag              ;expand_flag lives thru the entire call, whereas expand_file
9150 2877                                                      ;only lives thru the create data fork portion of the call.
9151 2877              ;
9152 2877              ;now lets setup the important information:
9153 2877              ;       storage type
9154 2877              ;       key block
9155 2877              ;       blks_used
9156 2877              ;       eof
9157 2877              ;
9158 2877              ;Remember drvr_buf_ptr points to the prodos directory entry
9159 2877              ;
9160 2877 A7 04                 lda   [drvr_buf_ptr]           ;get the storage type please
9161 2879 29 F0 00              and   #$00F0                   ;clear the garbage
9162 287C C9 50 00              cmp   #resource_type           ;see if the resource fork is already here.
9163 287F F0 2B                 beq   @no_extend
9164 2881 C9 31 00              cmp   #tree_type+1             ;file must be a seedling sapling or tree
9165 2884 B0 2C                 bcs   @storage_err             ;we cannot extend this file
9166 2886 8D 40 08              sta   expand_storage
9167 2889 8D F1 04              sta   data_storage             ;this will be a 10,20 or 30 (seedling, sapling or tree)
9168 288C
9169 288C A0 11 00              ldy   #key_blk_index
9170 288F B7 04                 lda   [drvr_buf_ptr],y
9171 2891 8D 42 08              sta   expand_key_blk           ;save the key block for the data fork
9172 2894
9173 2894 A0 13 00              ldy   #blks_used_index
9174 2897 B7 04                 lda   [drvr_buf_ptr],y
9175 2899 8D 44 08              sta   expand_blks_used
9176 289C
9177 289C A0 15 00              ldy   #eof_index
9178 289F B7 04                 lda   [drvr_buf_ptr],y
9179 28A1 8D 46 08              sta   expand_eof
9180 28A4 C8                    iny   
9181 28A5 B7 04                 lda   [drvr_buf_ptr],y
9182 28A7 8D 47 08              sta   expand_eof+1
9183 28AA 80 14                 bra   no_dup_problem
9184 28AC              @no_extend  
9185 28AC A9 70 00              lda   #resource_exist          ;the resource already exist bud.
9186 28AF 38                    sec   
9187 28B0 80 0A                 bra   real_problem
9188 28B2              @storage_err  
9189 28B2 A9 71 00              lda   #res_add_err             ;the resource cannot be added to this type file
9190 28B5 38                    sec   
9191 28B6 80 04                 bra   real_problem
9192 28B8              @not_an_extend  
9193 28B8 38                    sec   
9194 28B9 A9 47 00              lda   #dup_pathname
9195 28BC              real_problem   
9196 28BC 38                    sec   
9197 28BD 4C 82 00              jmp   main_exit
9198 28C0
9199 28C0              no_dup_problem   
9200 28C0 2C DB 04              bit   path_searched            ;was the entire path searched?
9201 28C3 10 F7                 bpl   real_problem             ;no, only a portion.
9202 28C5 20 9B 13              jsr   chk_disk_protect         ;is the volume write protected?
9203 28C8 60                    rts                            ;If protected, routine will not return
9204 28C9
9205 28C9              ;==========================================================================
9206 28C9              ;adjust_storage This routine will add in the overhead of the storage type
9207 28C9              ;               to the blocks used for a file.
9208 28C9              ;
9209 28C9              ;input:         A = blocks
9210 28C9              ;
9211 28C9              ;output:        A = blocks + overhead
9212 28C9              ;               Y = storage type needed for size
9213 28C9              ;               X = number of index blocks needed (for tree only)
9214 28C9              ;
9215 28C9              ;uses:          math_temp
9216 28C9              ;
9217 28C9              ;Overhead:
9218 28C9              ;               subdirectories:         no overhead
9219 28C9              ;               seedling:               no overhead
9220 28C9              ;               sapling:                1 block of overhead
9221 28C9              ;               tree:                   ((blks div 256) + (blks mod 256)) + 1
9222 28C9              ;==========================================================================
9223 28C9
9224 28C9              adjust_storage  
9225 28C9 85 AC                 sta   math_temp                ;number of file blocks
9226 28CB 9C AB 05              stz   index_blks               ;no tree index blocks. (default)
9227 28CE
9228 28CE A0 D0 00              ldy   #subdir_type
9229 28D1 AE 3E 05              ldx   storage_type
9230 28D4 E0 D0 00              cpx   #subdir_type
9231 28D7 F0 33                 beq   end_overhead             ;no overhead for directories
9232 28D9
9233 28D9 A0 10 00              ldy   #seedling_type           ;this is a seedling type
9234 28DC
9235 28DC C9 02 00              cmp   #$0002
9236 28DF 90 2B                 bcc   end_overhead             ;no overhead
9237 28E1 C9 01 01              cmp   #$0101                   ;check high end of sapling
9238 28E4 B0 07                 bcs   data_tree                ;this is a tree file
9239 28E6 E6 AC                 inc   math_temp                ;add one for sapling overhead
9240 28E8 A0 20 00              ldy   #sapling_type
9241 28EB 80 1F                 bra   end_overhead
9242 28ED
9243 28ED              data_tree   
9244 28ED A5 AD                 lda   math_temp+1              ;see how many sapling blocks we need
9245 28EF 29 FF 00              and   #$00FF
9246 28F2 8D AB 05              sta   index_blks               ;number of index blocks needed
9247 28F5 18                    clc   
9248 28F6 65 AC                 adc   math_temp
9249 28F8 AA                    tax   
9250 28F9 A5 AC                 lda   math_temp
9251 28FB 29 FF 00              and   #$00FF
9252 28FE F0 06                 beq   no_extra
9253 2900 EE AB 05              inc   index_blks               ;add one to number of indexes needed
9254 2903 E8                    inx   
9255 2904 86 AC                 stx   math_temp                ;adjust for $xx01 thru $xxFF
9256 2906
9257 2906              no_extra  
9258 2906 E8                    inx   
9259 2907 86 AC                 stx   math_temp                ;add extra block for tree header.
9260 2909 A0 30 00              ldy   #tree_type
9261 290C
9262 290C              end_overhead  
9263 290C A5 AC                 lda   math_temp
9264 290E AE AB 05              ldx   index_blks               ;index blocks for the tree file.
9265 2911 60                    rts   
9266 2912
9267 2912              ;==========================================================================
9268 2912              ;Default_entry: This routine will fill 'one_entry' with the default
9269 2912              ;values for a file.
9270 2912              ;
9271 2912              ;               storage type            = seedling
9272 2912              ;               File Type               = unknown ($00)
9273 2912              ;               Blks Used               = $0001
9274 2912              ;               EOF                     = $000000
9275 2912              ;               Version                 = $05
9276 2912              ;               Minimum Version         = $00
9277 2912              ;               access                  = $E3
9278 2912              ;               create date/time        = Current Time
9279 2912              ;               mod date/time           = Current Time
9280 2912              ;               aux type                = $0000
9281 2912              ;
9282 2912              ;NOTE: The store operations happen in a certain order so as to not overwrite
9283 2912              ;      information already stored.
9284 2912              ;==========================================================================
9285 2912
9286 2912              default_entry   
9287 2912 A0 26 00              ldy   #$0026                   ;zero the entry
9288 2915 A9 00 00              lda   #$0000
9289 2918              clr_name  
9290 2918 99 41 05              sta   one_entry,y
9291 291B 88                    dey   
9292 291C 88                    dey   
9293 291D 10 F9                 bpl   clr_name
9294 291F
9295 291F A9 10 00              lda   #seedling_type           ;set the default storage type
9296 2922 8D 3E 05              sta   storage_type
9297 2925
9298 2925 9C 51 05              stz   one_entry+file_type_index
9299 2928 A9 01 00              lda   #$0001
9300 292B 8D 54 05              sta   one_entry+blks_used_index
9301 292E 9C 56 05              stz   one_entry+eof_index
9302 2931 9C 57 05              stz   one_entry+eof_index+1
9303 2934 20 3C 0A              jsr   pack_time                ;read the GS Clock and set the current time
9304 2937 8E 59 05              stx   one_entry+create_index
9305 293A 8C 5B 05              sty   one_entry+create_index+2
9306 293D 8E 62 05              stx   one_entry+last_mod_index
9307 2940 8C 64 05              sty   one_entry+last_mod_index+2
9308 2943 A9 05 00              lda   #prodos_version
9309 2946 8D 5D 05              sta   one_entry+version_index
9310 2949 A9 E3 00              lda   #$00E3
9311 294C 8D 5F 05              sta   one_entry+access_index
9312 294F 9C 60 05              stz   one_entry+aux_type_index
9313 2952 60                    rts   
9314 2953
9315 2953              ;==========================================================================
9316 2953              ;Create_Common: This routine will setup and verify parameters supplied
9317 2953              ;               by the caller. It will also move the file name into
9318 2953              ;               one_entry.
9319 2953              ;
9320 2953              ;input:         my_pblk_ptr             ;must point to pathname field
9321 2953              ;
9322 2953              ;output:        returns to caller or jmps to sys_exit with error
9323 2953              ;
9324 2953              ; Access Byte:
9325 2953              ;                _______________________________
9326 2953              ;               |   |   |   |   |   |   |   |   |
9327 2953              ;               | 1 | 1 | 1 |   |   | 1 | 1 | 1 |
9328 2953              ;               |___|___|___|___|___|___|___|___|
9329 2953              ;                ^    ^   ^           ^   ^   ^
9330 2953              ;                |    |   |           |   |   |
9331 2953              ;                |    |   |  Invisible    |    Read-Enabled
9332 2953              ;                |    |   |                Write-Enabled
9333 2953              ;                |    |    Backup-Enabled
9334 2953              ;                |     Rename-Enabled
9335 2953              ;                 Destroy-Enabled
9336 2953              ;
9337 2953              ;==========================================================================
9338 2953
9339 2953              create_common                           ;
9340 2953
9341 2953 AC 23 05              ldy   search_length            ;length of name to create
9342 2956                       longa off
9343 2956 E2 20                 sep   #$20
9344 2958 B9 24 05     name_loop lda   search_name-1,y         ;move name to directory entry
9345 295B 99 41 05              sta   one_entry,y
9346 295E 88                    dey   
9347 295F D0 F7                 bne   name_loop
9348 2961 AD 23 05              lda   search_length
9349 2964 0D 3E 05              ora   storage_type             ;add in the storage type
9350 2967 8D 41 05              sta   one_entry                ;store storage/length byte
9351 296A                       longa on
9352 296A C2 20                 rep   #$20
9353 296C
9354 296C AD B7 05              lda   pcount                   ;see if we are done
9355 296F 3A                    dec   a
9356 2970 D0 01                 bne   cont01
9357 2972 60                    rts   
9358 2973
9359 2973              cont01    
9360 2973 85 AC                 sta   math_temp
9361 2975
9362 2975 A0 04 00              ldy   #pblk_01_accs            ;check the access
9363 2978 B7 80                 lda   [my_pblk_ptr],y
9364 297A AA                    tax                            ;save access so we can verify range
9365 297B 29 18 FF              and   #$FF18                   ;Destroy,Rename,Backup,Invisible,Write,Read
9366 297E F0 07                 beq   good_access              ;no problem
9367 2980
9368 2980              not_in_range  
9369 2980 38                    sec   
9370 2981 A9 53 00              lda   #parm_range_err
9371 2984 4C 82 00              jmp   main_exit                ;no return from here
9372 2987
9373 2987              good_access                             ;WARNING zero is stored in half of aux.
9374 2987 8A                    txa   
9375 2988 09 20 00              ora   #backup_enabled          ;force the backup bit please.
9376 298B 8D 5F 05              sta   one_entry+access_index
9377 298E
9378 298E C6 AC                 dec   math_temp                ;see if any more fields?
9379 2990 F0 2F                 beq   to_end_common
9380 2992
9381 2992 A0 06 00              ldy   #pblk_01_ftype           ;get the user's file type
9382 2995 B7 80                 lda   [my_pblk_ptr],y
9383 2997 EB                    xba   
9384 2998 D0 E6                 bne   not_in_range
9385 299A EB                    xba                            ;put file type in low byte please
9386 299B E2 20                 sep   #$20                     ;08 bit accum
9387 299D 8D 51 05              sta   one_entry+file_type_index
9388 29A0 C2 20                 rep   #$20                     ;16 bit accum
9389 29A2
9390 29A2 C9 0F 00              cmp   #dir_file_type           ;set storage to SubDir incase PCount = 4
9391 29A5 D0 06                 bne   skip_storage             ;do not setup the storage type
9392 29A7
9393 29A7 A9 D0 00              lda   #subdir_type
9394 29AA 8D 3E 05              sta   storage_type
9395 29AD
9396 29AD              skip_storage  
9397 29AD
9398 29AD C6 AC                 dec   math_temp                ;are we done?
9399 29AF F0 7F                 beq   end_common
9400 29B1
9401 29B1 A0 0A 00              ldy   #pblk_01_aux+2           ;get the user's aux type
9402 29B4 B7 80                 lda   [my_pblk_ptr],y
9403 29B6 D0 C8                 bne   not_in_range             ;sorry bud
9404 29B8 88                    dey   
9405 29B9 88                    dey   
9406 29BA B7 80                 lda   [my_pblk_ptr],y
9407 29BC 8D 60 05              sta   one_entry+aux_type_index
9408 29BF
9409 29BF C6 AC                 dec   math_temp                ;are we done?
9410 29C1              to_end_common  
9411 29C1 F0 6D                 beq   end_common               ;yes
9412 29C3
9413 29C3 A0 0C 00              ldy   #pblk_01_stype           ;get the user's storage type
9414 29C6 B7 80                 lda   [my_pblk_ptr],y
9415 29C8 29 FF 7F              and   #$7FFF                   ;clear the expand file bit please
9416 29CB
9417 29CB F0 23                 beq   standard_file            ;seedling is the default
9418 29CD EB                    xba   
9419 29CE D0 B0                 bne   not_in_range             ;parameter not valid
9420 29D0
9421 29D0 EB                    xba   
9422 29D1 C9 04 00              cmp   #(tree_type/$10)+1
9423 29D4 90 1A                 bcc   standard_file            ;seedling is the default
9424 29D6 C9 05 00              cmp   #(resource_type/$10)
9425 29D9 F0 0D                 beq   force_resource
9426 29DB C9 0D 00              cmp   #(subdir_type/$10)
9427 29DE D0 A0                 bne   not_in_range
9428 29E0 A9 D0 00              lda   #subdir_type
9429 29E3 8D 3E 05              sta   storage_type             ;we are making a directory
9430 29E6 80 0E                 bra   next_parm
9431 29E8              force_resource   
9432 29E8 A9 50 00              lda   #resource_type
9433 29EB 8D 3E 05              sta   storage_type
9434 29EE 80 06                 bra   next_parm
9435 29F0
9436 29F0              standard_file  
9437 29F0 A9 10 00              lda   #seedling_type
9438 29F3 8D 3E 05              sta   storage_type
9439 29F6              next_parm  
9440 29F6 AD 3E 05              lda   storage_type             ;if storage is subdirectory then force filetype
9441 29F9 C9 D0 00              cmp   #subdir_type
9442 29FC D0 0A                 bne   @not_subdir
9443 29FE
9444 29FE A9 0F 00              lda   #dir_file_type           ;set file type to subdirectory
9445 2A01 E2 20                 sep   #$20
9446 2A03 8D 51 05              sta   one_entry+file_type_index
9447 2A06 C2 20                 rep   #$20                     ;16 bit accum
9448 2A08
9449 2A08              @not_subdir  
9450 2A08 C6 AC                 dec   math_temp                ;are we done?
9451 2A0A F0 24                 beq   end_common
9452 2A0C
9453 2A0C A0 10 00              ldy   #pblk_01_eof1+2          ;data fork EOF
9454 2A0F 20 31 2A              jsr   create_eof
9455 2A12 8E 6D 05              stx   data_eof
9456 2A15 8C 6F 05              sty   data_eof+2
9457 2A18
9458 2A18 C6 AC                 dec   math_temp                ;is there a resource eof.
9459 2A1A F0 14                 beq   end_common
9460 2A1C
9461 2A1C AD 3E 05              lda   storage_type             ;is this a resource file?
9462 2A1F C9 50 00              cmp   #resource_type
9463 2A22 D0 0C                 bne   end_common               ;don't bother checking
9464 2A24
9465 2A24 A0 14 00              ldy   #pblk_01_eof2+2
9466 2A27 20 31 2A              jsr   create_eof
9467 2A2A 8E 71 05              stx   res_eof
9468 2A2D 8C 73 05              sty   res_eof+2
9469 2A30
9470 2A30              end_common                              ;
9471 2A30 60                    rts   
9472 2A31
9473 2A31
9474 2A31              ;==========================================================================
9475 2A31              ;Create_Eof:    This routine returns the EOF supplied by the user
9476 2A31              ;
9477 2A31              ;Input:         my_pblk_ptr             (must be setup)
9478 2A31              ;               Y register              (index into parameter block)
9479 2A31              ;
9480 2A31              ;Output:        X register = low word of EOF
9481 2A31              ;               Y register = high word of EOF
9482 2A31              ;               storage_type adjusted for correct eof
9483 2A31              ;
9484 2A31              ;==========================================================================
9485 2A31
9486 2A31              create_eof                              ;
9487 2A31 B7 80                 lda   [my_pblk_ptr],y
9488 2A33 EB                    xba   
9489 2A34 D0 3F                 bne   not1_in_range            ;I cannot make a file this large
9490 2A36 EB                    xba   
9491 2A37 48                    pha   
9492 2A38 88                    dey   
9493 2A39 88                    dey   
9494 2A3A B7 80                 lda   [my_pblk_ptr],y          ;get the low word
9495 2A3C AA                    tax                            ;save low word of eof
9496 2A3D 7A                    ply                            ;save high word of eof
9497 2A3E
9498 2A3E AD 3E 05              lda   storage_type             ;adjust storage type as needed
9499 2A41 C9 50 00              cmp   #resource_type
9500 2A44 F0 2E                 beq   end_create_eof
9501 2A46 C9 D0 00              cmp   #subdir_type
9502 2A49 F0 31                 beq   entry_to_bytes
9503 2A4B
9504 2A4B 98                    tya                            ;see what type of file is needed
9505 2A4C 4A                    lsr   a
9506 2A4D F0 0F                 beq   not_tree                 ;this cannot be a tree file
9507 2A4F C9 02 00              cmp   #$0002                   ;still might be a sapling
9508 2A52 B0 03                 bcs   is_tree
9509 2A54 8A                    txa                            ;if low word is zero then its a sapl.
9510 2A55 F0 10                 beq   make_sap
9511 2A57              is_tree   
9512 2A57 A9 30 00              lda   #tree_type
9513 2A5A 8D 3E 05              sta   storage_type
9514 2A5D 60                    rts   
9515 2A5E              not_tree  
9516 2A5E 98                    tya                            ;See if EOF greater then 512
9517 2A5F D0 06                 bne   make_sap                 ;This file must be a sapling file!
9518 2A61 8A                    txa   
9519 2A62 C9 01 02              cmp   #$0201                   ;is the eof < 512
9520 2A65 90 07                 bcc   make_seedling
9521 2A67              make_sap                                ;
9522 2A67 A9 20 00              lda   #sapling_type
9523 2A6A 8D 3E 05              sta   storage_type
9524 2A6D 60                    rts   
9525 2A6E
9526 2A6E              make_seedling                           ;
9527 2A6E A9 10 00              lda   #seedling_type
9528 2A71 8D 3E 05              sta   storage_type
9529 2A74
9530 2A74              end_create_eof                          ;
9531 2A74 60                    rts                            ;exit to caller
9532 2A75
9533 2A75              not1_in_range                           ;
9534 2A75 38                    sec   
9535 2A76 A9 53 00              lda   #parm_range_err
9536 2A79 4C 82 00              jmp   main_exit
9537 2A7C
9538 2A7C              entry_to_bytes                          ; ;convert file entries to bytes
9539 2A7C 98                    tya                            ;check high byte of entries wanted
9540 2A7D D0 F6                 bne   not1_in_range
9541 2A7F E0 80 06              cpx   #1664                    ;no more then 1663 entries for subdirs.
9542 2A82 B0 F1                 bcs   not1_in_range
9543 2A84 8A                    txa                            ;convert entries to bytes
9544 2A85 48                    pha   
9545 2A86              ;
9546 2A86              ; Convert number of entries to bytes needed.
9547 2A86              ;
9548 2A86              ; Bytes := ((entries * 3) * 13 + ((entries / 13) + 5))
9549 2A86              ;
9550 2A86 18                    clc   
9551 2A87 0A                    asl   a                        ;times 2
9552 2A88 63 01                 adc   1,s                      ;times 3
9553 2A8A 83 01                 sta   1,s                      ;math_temp
9554 2A8C
9555 2A8C 0A                    asl   a                        ;times 2
9556 2A8D 0A                    asl   a                        ;times 4
9557 2A8E 63 01                 adc   1,s                      ;times 5
9558 2A90 63 01                 adc   1,s                      ;times 6
9559 2A92 0A                    asl   a                        ;times 12
9560 2A93 63 01                 adc   1,s                      ;times 13
9561 2A95
9562 2A95 69 0D 00              adc   #13                      ;add 13 for the header field needed
9563 2A98 48                    pha                            ;save partial
9564 2A99
9565 2A99              sub_loop                                ;
9566 2A99 8A                    txa                            ;restore number if entries left
9567 2A9A 38                    sec   
9568 2A9B E9 0D 00              sbc   #13                      ;subtract 13 entries
9569 2A9E F0 0D                 beq   sub_done                 ;we are done
9570 2AA0 90 0B                 bcc   sub_done
9571 2AA2 AA                    tax   
9572 2AA3 18                    clc   
9573 2AA4 A3 01                 lda   1,s                      ;get the partial
9574 2AA6 69 05 00              adc   #$0005                   ;add in block overhead for each block
9575 2AA9 83 01                 sta   1,s
9576 2AAB 80 EC                 bra   sub_loop
9577 2AAD
9578 2AAD FA           sub_done plx                            ;save bytes in X register
9579 2AAE 68                    pla                            ;clean up stack
9580 2AAF 60                    rts   
9581 2AB0
9582 2AB0
9583 2AB0                       ENDP 
9584 2AB0              ;==========================================================================
9585 2AB0              ;Destroy:       This routine will delete a file from the disk.
9586 2AB0              ;
9587 2AB0              ;Created:       may 28, 1987
9588 2AB0              ;Modified:      jun 04, 1987
9589 2AB0              ;Author:        Rob Turner
9590 2AB0              ;
9591 2AB0              ;Enter:         jml
9592 2AB0              ;
9593 2AB0              ;Input:         A = undefined
9594 2AB0              ;               X = call number times 2
9595 2AB0              ;               Y = class times 2
9596 2AB0              ;               P = nvmxdizc
9597 2AB0              ;                   ..000...
9598 2AB0              ;               b = k
9599 2AB0              ;
9600 2AB0              ;Output:        A = error code if carry set
9601 2AB0              ;               X = undefined
9602 2AB0              ;               Y = undefined
9603 2AB0              ;               P = nvmxdizc
9604 2AB0              ;                   ..000..1 = error
9605 2AB0              ;                          0 = no error
9606 2AB0              ;               b = k
9607 2AB0              ;
9608 2AB0              ;Uses:          All registers
9609 2AB0              ;               find_file
9610 2AB0              ;
9611 2AB0              ;Call Format:
9612 2AB0              ;
9613 2AB0              ;Class 0        Pathname Pointer        (4 Bytes)
9614 2AB0              ;
9615 2AB0              ;Class 1        PCount                  (2 Bytes)
9616 2AB0              ;               Pathname Pointer        (4 Bytes)
9617 2AB0              ;
9618 2AB0              ;==========================================================================
9619 2AB0                       longa on
9620 2AB0                       longi on
9621 2AB0
9622 2AB0                       EXPORT destroy
9623 2AB0              destroy  PROC 
9624 2AB0
9625 2AB0              ;==========================================================================
9626 2AB0              ;Go and setup the defaul parameters for the call.
9627 2AB0              ;==========================================================================
9628 2AB0
9629 2AB0 20 9E 0E              jsr   setup_params
9630 2AB3
9631 2AB3              ;==========================================================================
9632 2AB3              ;Process the file name and locate it.
9633 2AB3              ;==========================================================================
9634 2AB3
9635 2AB3 20 23 10              jsr   process_path
9636 2AB6 20 9B 13              jsr   chk_disk_protect
9637 2AB9
9638 2AB9              ;==========================================================================
9639 2AB9              ;Now that we have located the file we need to see if its OK to destroy it.
9640 2AB9              ;
9641 2AB9              ;We can delete any file except the volume header, or a file that is destroy
9642 2AB9              ;disabled.
9643 2AB9              ;==========================================================================
9644 2AB9
9645 2AB9 A7 04                 lda   [drvr_buf_ptr]
9646 2ABB 29 F0 00              and   #$00F0
9647 2ABE 85 AC                 sta   math_temp                ;save the storage type for later
9648 2AC0 C9 F0 00              cmp   #volume_header
9649 2AC3 D0 07                 bne   check_access
9650 2AC5
9651 2AC5              wrong_access  
9652 2AC5 A9 4E 00              lda   #invalid_access
9653 2AC8              destroy_error  
9654 2AC8 38                    sec   
9655 2AC9              destroy_exit  
9656 2AC9 4C 82 00              jmp   main_exit
9657 2ACC
9658 2ACC              check_access  
9659 2ACC 20 09 3E              jsr   move_dir_entry
9660 2ACF
9661 2ACF A0 1E 00              ldy   #access_index
9662 2AD2 B7 04                 lda   [drvr_buf_ptr],y
9663 2AD4 29 80 00              and   #destroy_enabled
9664 2AD7 F0 EC                 beq   wrong_access             ;file is marked as 'destory disabled'
9665 2AD9
9666 2AD9
9667 2AD9              ;==========================================================================
9668 2AD9              ;make sure the file that they are deleting is NOT open
9669 2AD9              ;==========================================================================
9670 2AD9
9671 2AD9 A0 11 00              ldy   #key_blk_index           ;see if the file is open
9672 2ADC B7 04                 lda   [drvr_buf_ptr],y
9673 2ADE 8D 69 05              sta   files_key_block
9674 2AE1 9C 36 05              stz   fcr_wanted               ;reset for search
9675 2AE4
9676 2AE4              look_loop  
9677 2AE4 20 E1 3D              jsr   get_next_fcr
9678 2AE7 B0 18                 bcs   not_open
9679 2AE9
9680 2AE9 A0 08 00              ldy   #fcr_vol_id
9681 2AEC B7 8C                 lda   [my_fcr_ptr],y           ;get the Volume ID so we can make sure the file is on
9682 2AEE C7 84                 cmp   [my_vcr_ptr]             ;the same volume.
9683 2AF0 D0 F2                 bne   look_loop                ;File is on another volume
9684 2AF2
9685 2AF2 A0 06 00              ldy   #fcr_file_id
9686 2AF5 B7 90                 lda   [pro_fcr_ptr],y          ;see if this is the same file
9687 2AF7 CD 69 05              cmp   files_key_block
9688 2AFA D0 E8                 bne   look_loop
9689 2AFC A9 50 00              lda   #file_busy
9690 2AFF 80 C7                 bra   destroy_error            ;cannot delete an open file
9691 2B01
9692 2B01              not_open  
9693 2B01
9694 2B01 AC 69 05              ldy   files_key_block
9695 2B04 A5 AC                 lda   math_temp                ;storage TYPE!!!
9696 2B06 C9 D0 00              cmp   #subdir_type
9697 2B09 D0 05                 bne   check_tree
9698 2B0B
9699 2B0B              ;==========================================================================
9700 2B0B              ;It's a directory so go ahead and try to delete it.  We can only delete
9701 2B0B              ;it if there are no files in the directory.  Y=key block of the file
9702 2B0B              ;==========================================================================
9703 2B0B 20 B1 2B              jsr   kill_dir                 ;Y=key block
9704 2B0E 80 2E                 bra   update_dir
9705 2B10
9706 2B10              check_tree                              ;
9707 2B10 C9 30 00              cmp   #tree_type
9708 2B13 D0 05                 bne   check_sapling
9709 2B15
9710 2B15              ;==========================================================================
9711 2B15              ;Go ahead and remove the tree file if you can.  Y=Key block of the file
9712 2B15              ;==========================================================================
9713 2B15 20 98 2C              jsr   kill_tree                ;Y=Key block of the file
9714 2B18 80 24                 bra   update_dir               ;update the directory now
9715 2B1A
9716 2B1A              check_sapling                           ;
9717 2B1A C9 20 00              cmp   #sapling_type
9718 2B1D D0 05                 bne   check_seedling
9719 2B1F
9720 2B1F              ;==========================================================================
9721 2B1F              ;it's a sapling file so remove it.  Y=key block of the file
9722 2B1F              ;==========================================================================
9723 2B1F
9724 2B1F 20 EF 2C              jsr   kill_sapling
9725 2B22 80 1A                 bra   update_dir
9726 2B24
9727 2B24              check_seedling                          ;
9728 2B24 C9 10 00              cmp   #seedling_type
9729 2B27 D0 05                 bne   check_res                ;it better be a resource file
9730 2B29
9731 2B29              ;==========================================================================
9732 2B29              ;This is a simple file to delete.  Y=data block that needs to be deleted
9733 2B29              ;==========================================================================
9734 2B29
9735 2B29 20 2F 2D              jsr   kill_seedling
9736 2B2C 80 10                 bra   update_dir
9737 2B2E
9738 2B2E              check_res  
9739 2B2E C9 50 00              cmp   #resource_type
9740 2B31 D0 05                 bne   wrong_type
9741 2B33
9742 2B33              ;==========================================================================
9743 2B33              ;This is the hardest of the files to delete, since it is made up of many
9744 2B33              ;files.  Y=key block of the file
9745 2B33              ;==========================================================================
9746 2B33
9747 2B33 20 08 2C              jsr   kill_resource
9748 2B36 80 06                 bra   update_dir
9749 2B38
9750 2B38              wrong_type   
9751 2B38 A9 4B 00              lda   #bad_store_type          ;I should NEVER get this error!
9752 2B3B 82 8A FF              brl   destroy_error
9753 2B3E
9754 2B3E
9755 2B3E              update_dir   
9756 2B3E 08                    php   
9757 2B3F 48                    pha                            ;save the error code and flag
9758 2B40
9759 2B40 20 F9 17              jsr   flush_bitmap             ;write out any left over bitmap changes
9760 2B43 B0 20                 bcs   piggy_back
9761 2B45
9762 2B45              ;==========================================================================
9763 2B45              ;at this point we have removed all the blocks of the file.  We now need
9764 2B45              ;to update the directory entry itself.  The following parameters better
9765 2B45              ;be setup correctly or death and destruction will occur.
9766 2B45              ;
9767 2B45              ;               entries_blk_num         (block number of the entry to delete)
9768 2B45              ;               entry_offset            (offset to entry within the block)
9769 2B45              ;               dir_start_blk           (header block for this directory)
9770 2B45              ;
9771 2B45              ;==========================================================================
9772 2B45
9773 2B45              ;==========================================================================
9774 2B45              ;Setup the buffer pointer and device parameters
9775 2B45              ;==========================================================================
9776 2B45
9777 2B45 20 82 15              jsr   set_default_buf
9778 2B48
9779 2B48              ;==========================================================================
9780 2B48              ;We want to load in the block that contains the files entry.
9781 2B48              ;==========================================================================
9782 2B48
9783 2B48 AD B1 05              lda   entries_blk_num
9784 2B4B 85 10                 sta   drvr_blk_num
9785 2B4D 20 95 17              jsr   read_with_cache
9786 2B50 B0 13                 bcs   piggy_back
9787 2B52
9788 2B52              ;==========================================================================
9789 2B52              ;We have loaded the block, now lets zap the entry to indicate that it's
9790 2B52              ;dead.
9791 2B52              ;==========================================================================
9792 2B52
9793 2B52 AC 7B 05              ldy   entry_offset
9794 2B55 B7 04                 lda   [drvr_buf_ptr],y
9795 2B57 29 00 FF              and   #$FF00                   ;clear storage type and name length
9796 2B5A 97 04                 sta   [drvr_buf_ptr],y
9797 2B5C
9798 2B5C              ;==========================================================================
9799 2B5C              ;before we write the block back to disk lets see if it is the key block
9800 2B5C              ;This way we save an extra write to disk
9801 2B5C              ;==========================================================================
9802 2B5C
9803 2B5C A7 04                 lda   [drvr_buf_ptr]           ;check the previous link
9804 2B5E F0 12                 beq   update_header            ;don't write block twice
9805 2B60
9806 2B60              ;==========================================================================
9807 2B60              ;write the entries block back to disk.
9808 2B60              ;==========================================================================
9809 2B60
9810 2B60 20 9A 17              jsr   write_with_cache
9811 2B63 90 03                 bcc   fix_header
9812 2B65 82 61 FF     piggy_back brl   destroy_exit           ;Major problems.
9813 2B68
9814 2B68              fix_header                              ;
9815 2B68
9816 2B68              ;==========================================================================
9817 2B68              ;Now lets go and update the header of this directory.
9818 2B68              ;==========================================================================
9819 2B68
9820 2B68 AD E1 04              lda   dir_start_blk
9821 2B6B 85 10                 sta   drvr_blk_num
9822 2B6D
9823 2B6D 20 95 17              jsr   read_with_cache
9824 2B70 B0 F3                 bcs   piggy_back
9825 2B72
9826 2B72              update_header  
9827 2B72 A7 04                 lda   [drvr_buf_ptr]
9828 2B74 D0 35                 bne   dir_damaged
9829 2B76
9830 2B76 A0 23 00              ldy   #$0023
9831 2B79 B7 04                 lda   [drvr_buf_ptr],y
9832 2B7B C9 27 0D              cmp   #$0D27
9833 2B7E D0 2B                 bne   dir_damaged
9834 2B80
9835 2B80 A0 25 00              ldy   #header_file_cnt
9836 2B83 B7 04                 lda   [drvr_buf_ptr],y
9837 2B85 3A                    dec   a
9838 2B86 30 23                 bmi   dir_damaged
9839 2B88 97 04                 sta   [drvr_buf_ptr],y
9840 2B8A
9841 2B8A A6 10                 ldx   drvr_blk_num             ;see if this is the root directory
9842 2B8C E0 02 00              cpx   #vol_dir_start
9843 2B8F D0 0E                 bne   not_root
9844 2B91
9845 2B91 48                    pha   
9846 2B92 20 95 15              jsr   setup_my_vcr
9847 2B95 86 88                 stx   prodos_vcr_ptr
9848 2B97 84 8A                 sty   prodos_vcr_ptr+2
9849 2B99 68                    pla   
9850 2B9A A0 11 00              ldy   #vol_file_count          ;update the file count in VCR also
9851 2B9D
9852 2B9D 97 88                 sta   [prodos_vcr_ptr],y
9853 2B9F
9854 2B9F              ;==========================================================================
9855 2B9F              ;write the header block back to disk.
9856 2B9F              ;==========================================================================
9857 2B9F
9858 2B9F              not_root                                ;
9859 2B9F 20 9A 17              jsr   write_with_cache
9860 2BA2 B0 C1                 bcs   piggy_back
9861 2BA4
9862 2BA4              ;==========================================================================
9863 2BA4              ;Now we need to ripple back.  This routine will time stamp all previous
9864 2BA4              ;subdirectory files with the current time.
9865 2BA4              ;==========================================================================
9866 2BA4
9867 2BA4              do_ripple                               ;
9868 2BA4 20 C8 1A              jsr   slug_ripple
9869 2BA7 68                    pla                            ;restore any error code
9870 2BA8 28                    plp                            ;restore error flag from delete
9871 2BA9 80 BA                 bra   piggy_back
9872 2BAB
9873 2BAB              dir_damaged                             ;
9874 2BAB A9 51 00              lda   #dir_error
9875 2BAE 82 17 FF              brl   destroy_error
9876 2BB1
9877 2BB1              ;==========================================================================
9878 2BB1              ;==========================================================================
9879 2BB1              ;=====  END of MAIN CODE FOR DESTROY ======================================
9880 2BB1              ;==========================================================================
9881 2BB1              ;==========================================================================
9882 2BB1
9883 2BB1              kill_dir                                ;
9884 2BB1
9885 2BB1              ;==========================================================================
9886 2BB1              ;This routine is called when we are deleting a directory.  Before we delete
9887 2BB1              ;the directory we must make sure that there are NO files in the directory.
9888 2BB1              ;
9889 2BB1              ;input:         Y = key block address of the directory
9890 2BB1              ;==========================================================================
9891 2BB1
9892 2BB1 84 10                 sty   drvr_blk_num
9893 2BB3 20 8D 15              jsr   standard_req             ;read of 512 bytes
9894 2BB6 20 82 15              jsr   set_default_buf          ;use GS/OS system work buffer
9895 2BB9
9896 2BB9 A5 04                 lda   drvr_buf_ptr
9897 2BBB 85 98                 sta   temp_ptr
9898 2BBD A5 06                 lda   drvr_buf_ptr+2
9899 2BBF 85 9A                 sta   temp_ptr+2
9900 2BC1
9901 2BC1 20 95 17              jsr   read_with_cache
9902 2BC4 B0 3F                 bcs   dir_err_exit
9903 2BC6
9904 2BC6 A7 04                 lda   [drvr_buf_ptr]           ;the previous link better be zero
9905 2BC8 D0 E1                 bne   dir_damaged
9906 2BCA A0 23 00              ldy   #$0023                   ;verify that this is a directory
9907 2BCD B7 04                 lda   [drvr_buf_ptr],y
9908 2BCF C9 27 0D              cmp   #$0D27
9909 2BD2 D0 D7                 bne   dir_damaged
9910 2BD4
9911 2BD4 A0 25 00              ldy   #header_file_cnt
9912 2BD7 B7 04                 lda   [drvr_buf_ptr],y
9913 2BD9 F0 03                 beq   remove_dir               ;it's ok to delete the directory
9914 2BDB 82 E7 FE              brl   wrong_access
9915 2BDE
9916 2BDE              remove_dir                              ;
9917 2BDE A7 04                 lda   [drvr_buf_ptr]
9918 2BE0 F0 04                 beq   first_block
9919 2BE2 C5 B0                 cmp   data_ptr
9920 2BE4 D0 C5                 bne   dir_damaged
9921 2BE6
9922 2BE6              first_block                             ;
9923 2BE6 A6 10                 ldx   drvr_blk_num
9924 2BE8 86 B0                 stx   data_ptr
9925 2BEA
9926 2BEA              dir_loop                                ;
9927 2BEA 20 D7 0B              jsr   dealloc_block            ;remove the block please
9928 2BED B0 16                 bcs   dir_err_exit
9929 2BEF
9930 2BEF A5 98                 lda   temp_ptr
9931 2BF1 85 04                 sta   drvr_buf_ptr
9932 2BF3 A5 9A                 lda   temp_ptr+2
9933 2BF5 85 06                 sta   drvr_buf_ptr+2
9934 2BF7
9935 2BF7              ;==========================================================================
9936 2BF7              ;Verify that the backward link is correct, and if it is then delete the blk
9937 2BF7              ;==========================================================================
9938 2BF7
9939 2BF7 A0 02 00              ldy   #$0002                   ;walk the forward links
9940 2BFA B7 04                 lda   [drvr_buf_ptr],y
9941 2BFC 85 10                 sta   drvr_blk_num
9942 2BFE F0 06                 beq   dir_done                 ;the forward link is nill so we are done
9943 2C00 20 95 17              jsr   read_with_cache
9944 2C03 90 D9                 bcc   remove_dir
9945 2C05
9946 2C05              dir_err_exit                            ;
9947 2C05 60                    rts   
9948 2C06
9949 2C06              dir_done  
9950 2C06 18                    clc   
9951 2C07 60                    rts   
9952 2C08
9953 2C08              kill_resource  
9954 2C08 84 10                 sty   drvr_blk_num
9955 2C0A 84 B0                 sty   data_ptr                 ;save key block of the file
9956 2C0C 20 8D 15              jsr   standard_req
9957 2C0F
9958 2C0F              ;==========================================================================
9959 2C0F              ;Allocate a one block buffer
9960 2C0F              ;==========================================================================
9961 2C0F
9962 2C0F 18                    clc   
9963 2C10 A9 00 02              lda   #blk_size
9964 2C13 22 1C FC 01           jsl   alloc_seg                ;allocate a one block buffer
9965 2C17 B0 56                 bcs   res_err_exit
9966 2C19 8E EF 02              stx   virtual
9967 2C1C 8E 87 05              stx   displacement
9968 2C1F 8C F1 02              sty   virtual+2                ;save the virtual pointer please
9969 2C22 8C 89 05              sty   displacement+2
9970 2C25
9971 2C25 22 38 FC 01           jsl   deref                    ;convert this to a real address
9972 2C29 86 04                 stx   drvr_buf_ptr             ;save the address of the buffer
9973 2C2B 86 9C                 stx   temp2_ptr
9974 2C2D 84 06                 sty   drvr_buf_ptr+2
9975 2C2F 84 9E                 sty   temp2_ptr+2
9976 2C31
9977 2C31 20 95 17              jsr   read_with_cache          ;read in the resource header block
9978 2C34 B0 39                 bcs   res_err_exit
9979 2C36
9980 2C36 A7 9C                 lda   [temp2_ptr]              ;get the storage type
9981 2C38 29 FF 00              and   #$00FF
9982 2C3B AA                    tax                            ;save storage type
9983 2C3C A0 01 00              ldy   #$0001
9984 2C3F B7 9C                 lda   [temp2_ptr],y
9985 2C41 F0 29                 beq   res_bad
9986 2C43 A8                    tay                            ;key block of the resource
9987 2C44 20 74 2C              jsr   zap_branch               ;delete the resource
9988 2C47 B0 26                 bcs   res_err_exit
9989 2C49
9990 2C49 A0 00 01              ldy   #$0100
9991 2C4C B7 9C                 lda   [temp2_ptr],y            ;get the storage type
9992 2C4E 29 FF 00              and   #$00FF
9993 2C51 AA                    tax                            ;save storage type
9994 2C52 C8                    iny   
9995 2C53 B7 9C                 lda   [temp2_ptr],y
9996 2C55 F0 15                 beq   res_bad
9997 2C57 A8                    tay                            ;key block of the resource
9998 2C58 20 74 2C              jsr   zap_branch               ;delete the resource
9999 2C5B B0 12                 bcs   res_err_exit
0000 2C5D
0001 2C5D              res_done  
0002 2C5D AE 87 05              ldx   displacement             ;release memory used by the call
0003 2C60 AC 89 05              ldy   displacement+2
0004 2C63 22 20 FC 01           jsl   release_seg              ;release the one block of head space
0005 2C67
0006 2C67 A4 B0                 ldy   data_ptr
0007 2C69 4C 2F 2D              jmp   kill_seedling            ;remove the last block now
0008 2C6C
0009 2C6C              ;==========================================================================
0010 2C6C              res_bad   
0011 2C6C A9 4D 00              lda   #out_of_range            ;resource block is screwed up
0012 2C6F              res_err_exit  
0013 2C6F 20 8B 2C              jsr   free_header_buf
0014 2C72 38                    sec   
0015 2C73 60                    rts   
0016 2C74              ;===========================================================================
0017 2C74              ;this routine will delete a resource branch.
0018 2C74              ;X = storage type
0019 2C74              ;Y = key block
0020 2C74              ;output : carry clear = no error
0021 2C74              ;
0022 2C74              zap_branch  
0023 2C74 CA                    dex   
0024 2C75 D0 04                 bne   not_seedling
0025 2C77 20 2F 2D              jsr   kill_seedling
0026 2C7A 60                    rts   
0027 2C7B              not_seedling  
0028 2C7B CA                    dex   
0029 2C7C D0 04                 bne   not_sapling
0030 2C7E 20 EF 2C              jsr   kill_sapling
0031 2C81 60                    rts   
0032 2C82 CA           not_sapling dex   
0033 2C83 D0 04                 bne   @res_error               ;file screwed up
0034 2C85 20 98 2C              jsr   kill_tree
0035 2C88 60                    rts   
0036 2C89              @res_error  
0037 2C89 38                    sec   
0038 2C8A 60                    rts   
0039 2C8B              ;==========================================================================
0040 2C8B
0041 2C8B              free_header_buf                         ;
0042 2C8B 48                    pha                            ;save the error code
0043 2C8C AE 87 05              ldx   displacement
0044 2C8F AC 89 05              ldy   displacement+2
0045 2C92 22 20 FC 01           jsl   release_seg              ;release the one block of head space
0046 2C96 68                    pla   
0047 2C97 60                    rts   
0048 2C98
0049 2C98              ;==========================================================================
0050 2C98              ;The following code will delete a tree file.  It will also flip the index
0051 2C98              ;block and write it back out to disk.
0052 2C98              ;
0053 2C98              ;input:         Y = key block of the file
0054 2C98              ;
0055 2C98              ;==========================================================================
0056 2C98              kill_tree                               ;
0057 2C98 84 10                 sty   drvr_blk_num
0058 2C9A 84 B8                 sty   master_ptr
0059 2C9C
0060 2C9C 18                    clc   
0061 2C9D AD EB 02              lda   gbuf_addr
0062 2CA0 69 00 02              adc   #blk_size
0063 2CA3 85 04                 sta   drvr_buf_ptr
0064 2CA5 85 A0                 sta   temp3_ptr
0065 2CA7 AD ED 02              lda   gbuf_addr+2
0066 2CAA 69 00 00              adc   #$0000
0067 2CAD 85 06                 sta   drvr_buf_ptr+2
0068 2CAF 85 A2                 sta   temp3_ptr+2
0069 2CB1 20 8D 15              jsr   standard_req
0070 2CB4
0071 2CB4 20 95 17              jsr   read_with_cache
0072 2CB7 B0 32                 bcs   master_error
0073 2CB9
0074 2CB9 A9 00 01              lda   #$0100                   ;start at the last entry
0075 2CBC 48                    pha   
0076 2CBD
0077 2CBD              master_loop                             ;
0078 2CBD A5 A0                 lda   temp3_ptr                ;restore pointer to I/O buffer
0079 2CBF 85 98                 sta   temp_ptr
0080 2CC1 A5 A2                 lda   temp3_ptr+2
0081 2CC3 85 9A                 sta   temp_ptr+2
0082 2CC5
0083 2CC5              inner_master                            ;
0084 2CC5 68                    pla                            ;get the current index
0085 2CC6 3A                    dec   a
0086 2CC7 30 13                 bmi   master_done
0087 2CC9 48                    pha   
0088 2CCA AA                    tax   
0089 2CCB 09 00 01              ora   #$0100
0090 2CCE A8                    tay   
0091 2CCF 20 3E 2D              jsr   get_and_flip             ;get and flip the index block number
0092 2CD2
0093 2CD2 A8                    tay   
0094 2CD3 F0 F0                 beq   inner_master
0095 2CD5
0096 2CD5 20 EF 2C              jsr   kill_sapling
0097 2CD8 B0 12                 bcs   master_pop
0098 2CDA 80 E1                 bra   master_loop
0099 2CDC
0100 2CDC              master_done                             ;
0101 2CDC A6 98                 ldx   temp_ptr
0102 2CDE A4 9A                 ldy   temp_ptr+2
0103 2CE0 A5 B8                 lda   master_ptr
0104 2CE2 20 34 2D              jsr   write_flipped            ;write master index block flipped
0105 2CE5 B0 04                 bcs   master_error
0106 2CE7
0107 2CE7 A4 B8                 ldy   master_ptr
0108 2CE9 80 44                 bra   kill_seedling
0109 2CEB
0110 2CEB              master_error                            ;
0111 2CEB 60                    rts   
0112 2CEC
0113 2CEC              master_pop                              ;
0114 2CEC 68                    pla   
0115 2CED 38                    sec   
0116 2CEE 60                    rts   
0117 2CEF
0118 2CEF              ;==========================================================================
0119 2CEF              ;The following code will delete a sapling file.  It will also flip the index
0120 2CEF              ;block and write it back out to disk.
0121 2CEF              ;
0122 2CEF              ;input:         Y = key block of the file
0123 2CEF              ;
0124 2CEF              ;==========================================================================
0125 2CEF              kill_sapling                            ;
0126 2CEF
0127 2CEF              ;==========================================================================
0128 2CEF              ;Now we need to read in the index block and deallocate all allocated blocks
0129 2CEF              ;==========================================================================
0130 2CEF
0131 2CEF 84 10                 sty   drvr_blk_num
0132 2CF1 84 B4                 sty   index_ptr                ;save for later delete
0133 2CF3
0134 2CF3 20 82 15              jsr   set_default_buf
0135 2CF6 A5 04                 lda   drvr_buf_ptr
0136 2CF8 85 98                 sta   temp_ptr
0137 2CFA A5 06                 lda   drvr_buf_ptr+2
0138 2CFC 85 9A                 sta   temp_ptr+2
0139 2CFE
0140 2CFE 20 8D 15              jsr   standard_req
0141 2D01 20 95 17              jsr   read_with_cache
0142 2D04 B0 26                 bcs   index_error
0143 2D06
0144 2D06 A9 00 01              lda   #$0100                   ;start at the last entry
0145 2D09 48                    pha   
0146 2D0A
0147 2D0A              index_loop                              ;
0148 2D0A 68                    pla                            ;get the current index
0149 2D0B 3A                    dec   a
0150 2D0C 30 13                 bmi   index_done
0151 2D0E 48                    pha   
0152 2D0F AA                    tax   
0153 2D10 09 00 01              ora   #$0100
0154 2D13 A8                    tay   
0155 2D14
0156 2D14 20 3E 2D              jsr   get_and_flip             ;get the block number from index buffer
0157 2D17
0158 2D17 AA                    tax   
0159 2D18 F0 F0                 beq   index_loop
0160 2D1A 20 D7 0B              jsr   dealloc_block            ;free the block up please
0161 2D1D 90 EB                 bcc   index_loop
0162 2D1F FA                    plx   
0163 2D20 60                    rts   
0164 2D21
0165 2D21              index_done                              ;
0166 2D21 A6 98                 ldx   temp_ptr
0167 2D23 A4 9A                 ldy   temp_ptr+2
0168 2D25 A5 B4                 lda   index_ptr
0169 2D27 20 34 2D              jsr   write_flipped
0170 2D2A 90 01                 bcc   kill_index
0171 2D2C 60           index_error rts   
0172 2D2D
0173 2D2D              kill_index                              ;
0174 2D2D A4 B4                 ldy   index_ptr                ;now release the last block please
0175 2D2F
0176 2D2F              ;==========================================================================
0177 2D2F              ;This routine will free up a seedling files block.
0178 2D2F              ;
0179 2D2F              ;input:         Y = key block of the file.
0180 2D2F              ;
0181 2D2F              ;==========================================================================
0182 2D2F
0183 2D2F              kill_seedling                           ;
0184 2D2F BB                    tyx   
0185 2D30 20 D7 0B              jsr   dealloc_block
0186 2D33 60                    rts                            ;return error
0187 2D34
0188 2D34
0189 2D34              ;==========================================================================
0190 2D34              ;this routine will write a flipped index block to disk
0191 2D34              ;
0192 2D34              ;input:
0193 2D34              ;               X = low word of buffer pointer
0194 2D34              ;               Y = high word ''''
0195 2D34              ;               A = block number
0196 2D34              ;
0197 2D34              ;Output:
0198 2D34              ;               A = error if carry set
0199 2D34              ;
0200 2D34              ;==========================================================================
0201 2D34
0202 2D34              write_flipped                           ;
0203 2D34 86 04                 stx   drvr_buf_ptr
0204 2D36 84 06                 sty   drvr_buf_ptr+2
0205 2D38 85 10                 sta   drvr_blk_num
0206 2D3A 20 9A 17              jsr   write_with_cache
0207 2D3D 60                    rts   
0208 2D3E
0209 2D3E              ;==========================================================================
0210 2D3E              ;This routine will flip the block number within an index block.
0211 2D3E              ;
0212 2D3E              ;input:
0213 2D3E              ;               X  =  Index into the lower half of the index block
0214 2D3E              ;               Y  =  Index into the higher half of the index block
0215 2D3E              ;        temp_ptr  =  pointer to the index block
0216 2D3E              ;
0217 2D3E              ;OutPut:
0218 2D3E              ;               A  =  Block number from index block
0219 2D3E              ;
0220 2D3E              ;==========================================================================
0221 2D3E              get_and_flip                            ;
0222 2D3E                       longa off
0223 2D3E E2 20                 sep   #$20
0224 2D40
0225 2D40 B7 98                 lda   [temp_ptr],y             ;grab the high block number
0226 2D42 EB                    xba                            ;put high block number in upper byte
0227 2D43 5A                    phy                            ;save high byte index
0228 2D44
0229 2D44 9B                    txy   
0230 2D45 B7 98                 lda   [temp_ptr],y             ;get the low block number
0231 2D47
0232 2D47 EB                    xba                            ;restore high block number
0233 2D48 97 98                 sta   [temp_ptr],y             ;store high block number in low half
0234 2D4A
0235 2D4A EB                    xba                            ;restore low block number
0236 2D4B 7A                    ply                            ;get high byte index
0237 2D4C 97 98                 sta   [temp_ptr],y             ;store low block number in high half
0238 2D4E
0239 2D4E                       longa on
0240 2D4E C2 20                 rep   #$20
0241 2D50 60                    rts   
0242 2D51                       ENDP 
0243 2D51              ;======================================================================
0244 2D51              ;Chnage_Path    This file will RENAME or MOVE a file to a new directory
0245 2D51              ;
0246 2D51              ;Created:       Nov 04, 1987
0247 2D51              ;Modified:      Nov 04, 1987
0248 2D51              ;Author:        Rob Turner
0249 2D51              ;
0250 2D51              ;Enter:         From GS/OS jmp table
0251 2D51              ;
0252 2D51              ;Input:         A = undefined
0253 2D51              ;               X = (call number * 2)
0254 2D51              ;               Y = (class number * 2)
0255 2D51              ;               P = nvmxdizc
0256 2D51              ;                   ..000...
0257 2D51              ;               b = k
0258 2D51              ;
0259 2D51              ;Output:        A = error code if carry set (exit via system exit routine)
0260 2D51              ;               X = undefined
0261 2D51              ;               Y = undefined
0262 2D51              ;               P = nvmxdizc
0263 2D51              ;                   ..000..1 = error
0264 2D51              ;                          0 = no error
0265 2D51              ;               b = k
0266 2D51              ;
0267 2D51              ;Uses:          All registers
0268 2D51              ;               Device Dispatcher       (subroutine)
0269 2D51              ;               General I/O Buffer      (1K buffer, I read 512 bytes)
0270 2D51              ;               find_file               (subroutine)
0271 2D51              ;
0272 2D51              ;Call Format:
0273 2D51              ;
0274 2D51              ;Class 0        Source Pathname Pointer (4 Bytes)
0275 2D51              ;               Destination Path Pointer(4 Bytes)
0276 2D51              ;
0277 2D51              ;Class 1        PCount                  (2 Bytes)
0278 2D51              ;               Source Pathname Pointer (4 Bytes)
0279 2D51              ;               Destination Path Pointer(4 Bytes)
0280 2D51              ;               Flags                   (2 Bytes)
0281 2D51              ;
0282 2D51              ;======================================================================
0283 2D51                       longa on
0284 2D51                       longi on
0285 2D51
0286 2D51                       EXPORT change_path
0287 2D51              change_path PROC 
0288 2D51
0289 2D51 20 9E 0E              jsr   setup_params
0290 2D54
0291 2D54              ; If the source is only a device # then set cp_device_flag to 1. 
0292 2D54              ; This is a special case so that the Finder can rename a volume whose current name 
0293 2D54              ; is a duplicate of another volume which has open files.  1/22/91 CAE
0294 2D54                        
0295 2D54 A5 42                 lda   <path_flag               ;get pathname flags
0296 2D56 29 00 40              and   #path1_mask              ;is pathname 1 defined?
0297 2D59 D0 17                 bne   @not_dev                 ;yes
0298 2D5B A5 36                 lda   <dev_num                 ;do we have a device #?
0299 2D5D F0 13                 beq   @not_dev                 ;no
0300 2D5F EE E5 05              inc   cp_device_flag           ;yes - so indicate source was a device #
0301 2D62
0302 2D62              ; If pCount was 3 or more, get the cp_flags from the parameter block.  5-Dec-91 MSD
0303 2D62
0304 2D62 AD B7 05              lda   pcount
0305 2D65 C9 03 00              cmp   #3                       ; did it include cp_flags?
0306 2D68 90 08                 blt   @not_dev                 ; no, so leave cp_flags set to 0.
0307 2D6A A0 08 00              ldy   #pblk_04_flags
0308 2D6D B7 80                 lda   [my_pblk_ptr],y          ; get flags from param block
0309 2D6F 8D E7 05              sta   cp_flags
0310 2D72
0311 2D72              ; End 5-Dec-91 MSD
0312 2D72
0313 2D72              @not_dev  
0314 2D72
0315 2D72 20 23 10              jsr   process_path             ;see if the source file exist also sets up priority bit
0316 2D75                                                      ;and now checks the spans.      10/10/91 JEV
0317 2D75
0318 2D75 20 34 32              jsr   valid_change
0319 2D78 B0 30                 bcs   end_change
0320 2D7A
0321 2D7A AD 1B 03              lda   slug_block               ;save for slug ripple routine
0322 2D7D 8D 21 03              sta   src_slug_blk
0323 2D80 AD 1D 03              lda   slug_offset
0324 2D83 8D 23 03              sta   src_slug_offset
0325 2D86
0326 2D86 20 9B 13              jsr   chk_disk_protect
0327 2D89 20 4D 31              jsr   save_src_parms
0328 2D8C 20 09 3E              jsr   move_dir_entry           ;move entry into one_entry
0329 2D8F 20 B4 2D              jsr   chk_open                 ;see if the file is currently open
0330 2D92 B0 16                 bcs   end_change
0331 2D94 20 7D 31              jsr   process_dest             ;find the destination name
0332 2D97 B0 11                 bcs   end_change
0333 2D99
0334 2D99              ; 27-Jan-92 MSD: We let valid_change see if the source path is a subset of the
0335 2D99              ; destination path (i.e. we're trying to move an item into its own child).  If
0336 2D99              ; that was the case, cp_to_child will be non-zero
0337 2D99
0338 2D99 AD E9 05              lda   cp_to_child              ; were we moving into our own child?
0339 2D9C F0 06                 beq   @not_subset              ; no, so do the move
0340 2D9E
0341 2D9E A9 40 00              lda   #bad_path_syntax         ; source path was a subset of destination path
0342 2DA1 38                    sec   
0343 2DA2 80 06                 bra   end_change
0344 2DA4
0345 2DA4              @not_subset  
0346 2DA4 20 65 31              jsr   save_dest_parms
0347 2DA7 20 DC 2D              jsr   rename_or_move
0348 2DAA
0349 2DAA              end_change                              ;
0350 2DAA 48                    pha                            ;save the error code
0351 2DAB 08                    php   
0352 2DAC 20 F9 17              jsr   flush_bitmap             ;make sure the bitmap is OK!
0353 2DAF 28                    plp                            ;restore error flag
0354 2DB0 68                    pla                            ;restore error code if any
0355 2DB1 4C 82 00              jmp   main_exit
0356 2DB4
0357 2DB4              ;======================================================================
0358 2DB4
0359 2DB4              chk_open  
0360 2DB4 9C 36 05              stz   fcr_wanted               ;start from the beginning
0361 2DB7 AD 52 05              lda   one_entry+key_blk_index
0362 2DBA 8D 38 05              sta   key_block
0363 2DBD              open_loop   
0364 2DBD 20 E1 3D              jsr   get_next_fcr
0365 2DC0 B0 18                 bcs   end_chk_open
0366 2DC2
0367 2DC2 A0 08 00              ldy   #fcr_vol_id
0368 2DC5 B7 8C                 lda   [my_fcr_ptr],y           ;get the Volume ID so we can make sure the file is on
0369 2DC7 C7 84                 cmp   [my_vcr_ptr]             ;the same volume.
0370 2DC9 D0 F2                 bne   open_loop                ;File is on another volume
0371 2DCB
0372 2DCB A0 06 00              ldy   #fcr_file_id
0373 2DCE B7 90                 lda   [pro_fcr_ptr],y
0374 2DD0 CD 38 05              cmp   key_block
0375 2DD3 D0 E8                 bne   open_loop
0376 2DD5
0377 2DD5 A9 50 00              lda   #file_busy
0378 2DD8 38                    sec   
0379 2DD9 60                    rts   
0380 2DDA
0381 2DDA              end_chk_open                            ; ;the file is not open
0382 2DDA 18                    clc   
0383 2DDB 60                    rts   
0384 2DDC
0385 2DDC              ;======================================================================
0386 2DDC
0387 2DDC              rename_or_move                          ; ;what will we do?
0388 2DDC AD 13 03              lda   src_dev_num
0389 2DDF CD 29 03              cmp   dest_dev_num
0390 2DE2 D0 10                 bne   bad_device               ;cannot rename on different devices
0391 2DE4 AD 15 03              lda   src_start_blk
0392 2DE7 CD 2B 03              cmp   dest_start_blk           ;is the file in the same directory?
0393 2DEA F0 04                 beq   do_rename                ;this can only be a rename
0394 2DEC              ;
0395 2DEC              ;IF here we are doing a change_path
0396 2DEC              ;
0397 2DEC 20 F7 2D              jsr   move_file                ;do a change_path please
0398 2DEF 60                    rts   
0399 2DF0
0400 2DF0              ;
0401 2DF0              ;IF here we are doing a simple rename
0402 2DF0              ;
0403 2DF0              do_rename  
0404 2DF0 20 81 2F              jsr   rename_file
0405 2DF3 60                    rts   
0406 2DF4
0407 2DF4              bad_device  
0408 2DF4 82 17 05              brl   bad_path
0409 2DF7
0410 2DF7              ;======================================================================
0411 2DF7              move_file   
0412 2DF7
0413 2DF7              ; First, we need to check the file/dir that we're moving to see if it's
0414 2DF7              ; 'rename enabled'.  If it isn't, then we need to make sure we're just
0415 2DF7              ; doing a move and not a 'move and rename'.
0416 2DF7              ; Added 3/15/91 CAE
0417 2DF7
0418 2DF7 20 8D 15              jsr   standard_req             ;read in 512 bytes
0419 2DFA 20 82 15              jsr   set_default_buf
0420 2DFD AD 13 03              lda   src_dev_num
0421 2E00 85 00                 sta   drvr_dev_num
0422 2E02 AD 17 03              lda   src_dir_blk              ;block that contains the entry
0423 2E05 85 10                 sta   drvr_blk_num
0424 2E07 20 95 17              jsr   read_with_cache
0425 2E0A B0 70                 bcs   to_end_move_file
0426 2E0C
0427 2E0C 18                    clc   
0428 2E0D AD 19 03              lda   src_offset
0429 2E10 69 1E 00              adc   #access_index
0430 2E13 A8                    tay   
0431 2E14 B7 04                 lda   [drvr_buf_ptr],y
0432 2E16 29 40 00              and   #rename_enabled          ;can we rename the file?
0433 2E19 D0 2A                 bne   @ok                      ;branch if rename is OK
0434 2E1B
0435 2E1B AC 19 03              ldy   src_offset               ;rename is not allowed so
0436 2E1E B7 04                 lda   [drvr_buf_ptr],y         ;get file's name length
0437 2E20 29 0F 00              and   #$000f                   ;strip off storage nibble and hi byte
0438 2E23 CD 23 05              cmp   search_length            ;same as dest name length?
0439 2E26 F0 07                 beq   @cont                    ;yes - so compare the names
0440 2E28
0441 2E28 C2 20        @uh_oh   rep   #$20                     ;ensure 16 bit mode
0442 2E2A 38                    sec   
0443 2E2B A9 4E 00              lda   #invalid_access          ;report an error
0444 2E2E 60                    rts   
0445 2E2F
0446 2E2F AA           @cont    tax                            ;calculate offset to end of dest name
0447 2E30 CA                    dex                            ;and put in X
0448 2E31 18                    clc   
0449 2E32 6D 19 03              adc   src_offset               ;calculate offset to end of file's name
0450 2E35 A8                    tay                            ;in the dir entry and put in Y
0451 2E36
0452 2E36                       longa off
0453 2E36 E2 20                 sep   #$20                     ;begin 8 bit mode
0454 2E38
0455 2E38 B7 04        @loop    lda   [drvr_buf_ptr],y         ;compare file's name
0456 2E3A DD 25 05              cmp   search_name,x            ;to dest name
0457 2E3D D0 E9                 bne   @uh_oh                   ;branch if mis-match
0458 2E3F 88                    dey   
0459 2E40 CA                    dex   
0460 2E41 10 F5                 bpl   @loop                    ;loop until done
0461 2E43
0462 2E43                       longa on
0463 2E43 C2 20                 rep   #$20                     ;begin 16 bit mode
0464 2E45              @ok       
0465 2E45
0466 2E45              ; End of new code.
0467 2E45
0468 2E45 AE E5 04              ldx   free_dir_blk             ;do we need to extend the directory?
0469 2E48 D0 1C                 bne   no_extend
0470 2E4A 20 4E 0C              jsr   calc_free_blks           ;do we have a free block
0471 2E4D B0 2D                 bcs   to_end_move_file         ;NO we have an error
0472 2E4F AA                    tax   
0473 2E50 D0 03                 bne   not_full
0474 2E52 82 82 00              brl   full_disk
0475 2E55              not_full  
0476 2E55 20 B5 1B              jsr   extend_subdir            ;grow the subdirectory
0477 2E58 B0 7C                 bcs   end_move_file
0478 2E5A
0479 2E5A AD E7 04              lda   free_dir_offset          ;offset to directory entry
0480 2E5D 8D 2F 03              sta   dest_offset
0481 2E60 AD E5 04              lda   free_dir_blk             ;block that contains entry
0482 2E63 8D 2D 03              sta   dest_dir_blk
0483 2E66
0484 2E66              no_extend  
0485 2E66 20 8D 15              jsr   standard_req             ;512 bytes
0486 2E69 20 82 15              jsr   set_default_buf          ;use the temp buffer
0487 2E6C
0488 2E6C AD 17 03              lda   src_dir_blk              ;move and delete the old entry
0489 2E6F 85 10                 sta   drvr_blk_num
0490 2E71 20 95 17              jsr   read_with_cache
0491 2E74 B0 60                 bcs   end_move_file
0492 2E76 20 4D 2F              jsr   delete_entry             ;move entry and delete it
0493 2E79 20 9A 17              jsr   write_with_cache
0494 2E7C              to_end_move_file   
0495 2E7C B0 58                 bcs   end_move_file
0496 2E7E
0497 2E7E AD 15 03              lda   src_start_blk
0498 2E81 85 10                 sta   drvr_blk_num
0499 2E83 20 95 17              jsr   read_with_cache
0500 2E86 B0 4E                 bcs   end_move_file
0501 2E88 20 26 2F              jsr   dec_file_cnt
0502 2E8B 20 9A 17              jsr   write_with_cache
0503 2E8E B0 46                 bcs   end_move_file
0504 2E90 20 DC 2E              jsr   do_src_slug
0505 2E93
0506 2E93 AD 2B 03              lda   dest_start_blk           ;new header pointer
0507 2E96 8D 66 05              sta   one_entry+header_ptr_index
0508 2E99 AD 2D 03              lda   dest_dir_blk             ;block
0509 2E9C 85 10                 sta   drvr_blk_num
0510 2E9E 20 95 17              jsr   read_with_cache
0511 2EA1 B0 33                 bcs   end_move_file
0512 2EA3 20 6A 2F              jsr   move_old_entry
0513 2EA6 AC 2F 03              ldy   dest_offset
0514 2EA9 20 89 30              jsr   move_new_name            ;rename the entry
0515 2EAC 20 9A 17              jsr   write_with_cache
0516 2EAF B0 25                 bcs   end_move_file
0517 2EB1
0518 2EB1 AD 2B 03              lda   dest_start_blk           ;now update the file count
0519 2EB4 85 10                 sta   drvr_blk_num
0520 2EB6 20 95 17              jsr   read_with_cache
0521 2EB9 B0 1B                 bcs   end_move_file
0522 2EBB 20 34 2F              jsr   inc_file_cnt
0523 2EBE 20 9A 17              jsr   write_with_cache
0524 2EC1 B0 13                 bcs   end_move_file
0525 2EC3 20 EA 2E              jsr   do_dest_slug
0526 2EC6
0527 2EC6 AD 3E 05              lda   storage_type
0528 2EC9 29 F0 00              and   #$00F0                   ;see if this is a subdirectory
0529 2ECC C9 D0 00              cmp   #subdir_type
0530 2ECF D0 04                 bne   move_done
0531 2ED1 20 FA 2E              jsr   fix_subdir
0532 2ED4 60                    rts   
0533 2ED5              move_done   
0534 2ED5 18                    clc   
0535 2ED6              end_move_file   
0536 2ED6 60                    rts   
0537 2ED7              full_disk   
0538 2ED7 A9 48 00              lda   #volume_full
0539 2EDA 38                    sec   
0540 2EDB 60                    rts   
0541 2EDC              do_src_slug  
0542 2EDC AD 21 03              lda   src_slug_blk
0543 2EDF 8D 1B 03              sta   slug_block
0544 2EE2 AD 23 03              lda   src_slug_offset
0545 2EE5 8D 1D 03              sta   slug_offset
0546 2EE8 80 0C                 bra   do_slug
0547 2EEA              do_dest_slug   
0548 2EEA AD 25 03              lda   dest_slug_blk
0549 2EED 8D 1B 03              sta   slug_block
0550 2EF0 AD 27 03              lda   dest_slug_offset
0551 2EF3 8D 1D 03              sta   slug_offset
0552 2EF6              do_slug   
0553 2EF6 20 C8 1A              jsr   slug_ripple
0554 2EF9 60                    rts   
0555 2EFA              fix_subdir   
0556 2EFA AD 52 05              lda   one_entry+key_blk_index
0557 2EFD 85 10                 sta   drvr_blk_num
0558 2EFF 20 95 17              jsr   read_with_cache          ;read in the key block
0559 2F02
0560 2F02 B0 21                 bcs   end_fix_subdir
0561 2F04 AD 2D 03              lda   dest_dir_blk             ;block number where entry is
0562 2F07 A0 27 00              ldy   #parent_index
0563 2F0A 97 04                 sta   [drvr_buf_ptr],y
0564 2F0C
0565 2F0C A9 E0 00              lda   #subdir_header
0566 2F0F 8D 3E 05              sta   storage_type
0567 2F12 A0 04 00              ldy   #$0004                   ;rename the subdirectory as well
0568 2F15 20 89 30              jsr   move_new_name
0569 2F18
0570 2F18 20 9E 27              jsr   make_entry_num
0571 2F1B B0 08                 bcs   end_fix_subdir
0572 2F1D A0 29 00              ldy   #parent_index+2
0573 2F20 97 04                 sta   [drvr_buf_ptr],y
0574 2F22 20 9A 17              jsr   write_with_cache
0575 2F25              end_fix_subdir   
0576 2F25 60                    rts   
0577 2F26
0578 2F26              dec_file_cnt   
0579 2F26 A0 25 00              ldy   #header_file_cnt
0580 2F29 B7 04                 lda   [drvr_buf_ptr],y
0581 2F2B 3A                    dec   a                        ;update the file count for directory
0582 2F2C 30 05                 bmi   end_dec
0583 2F2E 97 04                 sta   [drvr_buf_ptr],y
0584 2F30 20 40 2F              jsr   chk_vol_cnt              ;pass the new count in the accum
0585 2F33              end_dec   
0586 2F33 60                    rts   
0587 2F34
0588 2F34              inc_file_cnt  
0589 2F34 A0 25 00              ldy   #header_file_cnt
0590 2F37 B7 04                 lda   [drvr_buf_ptr],y
0591 2F39 1A                    inc   a                        ;update the file count for directory
0592 2F3A 97 04                 sta   [drvr_buf_ptr],y
0593 2F3C 20 40 2F              jsr   chk_vol_cnt              ;pass the new count in the accum
0594 2F3F 60                    rts   
0595 2F40              ;
0596 2F40              ;The new count is in the accumulator
0597 2F40              ;
0598 2F40              chk_vol_cnt  
0599 2F40 A4 10                 ldy   drvr_blk_num             ;our we updating the Root Level of the disk?
0600 2F42 C0 02 00              cpy   #vol_dir_start
0601 2F45 D0 05                 bne   @not_vol
0602 2F47              ;
0603 2F47              ;Now we need to update the VCR
0604 2F47              ;
0605 2F47 A0 11 00              ldy   #vol_file_count
0606 2F4A 97 88                 sta   [prodos_vcr_ptr],y
0607 2F4C              @not_vol  
0608 2F4C 60                    rts   
0609 2F4D
0610 2F4D              delete_entry                            ;
0611 2F4D A2 00 00              ldx   #$0000
0612 2F50 AC 19 03              ldy   src_offset
0613 2F53              delete_loop                             ; ;move the entry to one_entry
0614 2F53 B7 04                 lda   [drvr_buf_ptr],y
0615 2F55 9D 41 05              sta   one_entry,x
0616 2F58 C8                    iny   
0617 2F59 E8                    inx   
0618 2F5A E0 27 00              cpx   #entry_length
0619 2F5D D0 F4                 bne   delete_loop
0620 2F5F
0621 2F5F AC 19 03              ldy   src_offset
0622 2F62 B7 04                 lda   [drvr_buf_ptr],y
0623 2F64 29 00 FF              and   #$FF00                   ;clear storage/length field
0624 2F67 97 04                 sta   [drvr_buf_ptr],y
0625 2F69 60                    rts   
0626 2F6A
0627 2F6A              move_old_entry                          ;
0628 2F6A A2 00 00              ldx   #$0000
0629 2F6D AC 2F 03              ldy   dest_offset
0630 2F70                       longa off
0631 2F70 E2 20                 sep   #$20
0632 2F72              change_loop                             ;
0633 2F72 BD 41 05              lda   one_entry,x
0634 2F75 97 04                 sta   [drvr_buf_ptr],y
0635 2F77 C8                    iny   
0636 2F78 E8                    inx   
0637 2F79 E0 27 00              cpx   #entry_length
0638 2F7C D0 F4                 bne   change_loop
0639 2F7E                       longa on
0640 2F7E C2 20                 rep   #$20
0641 2F80 60                    rts   
0642 2F81
0643 2F81
0644 2F81              ;======================================================================
0645 2F81              rename_file                             ;
0646 2F81 20 8D 15              jsr   standard_req             ;read in 512 bytes
0647 2F84 20 82 15              jsr   set_default_buf
0648 2F87 AD 13 03              lda   src_dev_num
0649 2F8A 85 00                 sta   drvr_dev_num
0650 2F8C AD 17 03              lda   src_dir_blk              ;block that contains the entry
0651 2F8F 85 10                 sta   drvr_blk_num
0652 2F91 20 95 17              jsr   read_with_cache
0653 2F94 B0 74                 bcs   end_rename
0654 2F96
0655 2F96 18                    clc   
0656 2F97 AD 19 03              lda   src_offset
0657 2F9A 69 1E 00              adc   #access_index
0658 2F9D A8                    tay   
0659 2F9E B7 04                 lda   [drvr_buf_ptr],y
0660 2FA0 29 40 00              and   #rename_enabled          ;can we rename the file?
0661 2FA3 D0 05                 bne   @10                      ;rename is OK
0662 2FA5 38                    sec   
0663 2FA6 A9 4E 00              lda   #invalid_access          ;sorry bud
0664 2FA9 60                    rts                            ;return with the error please
0665 2FAA
0666 2FAA              @10       
0667 2FAA 18                    clc   
0668 2FAB AD 19 03              lda   src_offset               ;get the key block
0669 2FAE 69 11 00              adc   #key_blk_index
0670 2FB1 A8                    tay   
0671 2FB2 B7 04                 lda   [drvr_buf_ptr],y
0672 2FB4 8D 52 05              sta   one_entry+key_blk_index
0673 2FB7
0674 2FB7 AC 19 03              ldy   src_offset               ;offset the old name
0675 2FBA B7 04                 lda   [drvr_buf_ptr],y
0676 2FBC 29 F0 00              and   #$00F0                   ;isolate the storage type
0677 2FBF 8D 3E 05              sta   storage_type
0678 2FC2 C9 F0 00              cmp   #volume_header
0679 2FC5 F0 49                 beq   rename_vol
0680 2FC7 C9 D0 00              cmp   #subdir_type
0681 2FCA F0 14                 beq   type_ok
0682 2FCC C9 10 00              cmp   #seedling_type
0683 2FCF F0 0F                 beq   type_ok
0684 2FD1 C9 20 00              cmp   #sapling_type
0685 2FD4 F0 0A                 beq   type_ok
0686 2FD6 C9 30 00              cmp   #tree_type
0687 2FD9 F0 05                 beq   type_ok
0688 2FDB C9 50 00              cmp   #resource_type
0689 2FDE D0 2B                 bne   bad_type
0690 2FE0              type_ok                                 ;
0691 2FE0 AC 19 03              ldy   src_offset
0692 2FE3 20 89 30              jsr   move_new_name
0693 2FE6 20 9A 17              jsr   write_with_cache
0694 2FE9 B0 1F                 bcs   end_rename
0695 2FEB AD 3E 05              lda   storage_type
0696 2FEE 29 F0 00              and   #$00F0                   ;clear the garbage
0697 2FF1 C9 D0 00              cmp   #subdir_type
0698 2FF4 D0 11                 bne   end_rename_clr
0699 2FF6 AD 17 03              lda   src_dir_blk
0700 2FF9 8D 2D 03              sta   dest_dir_blk
0701 2FFC AD 19 03              lda   src_offset
0702 2FFF 8D E7 04              sta   free_dir_offset
0703 3002 20 FA 2E              jsr   fix_subdir
0704 3005 B0 03                 bcs   end_rename
0705 3007              end_rename_clr   
0706 3007 20 C8 1A              jsr   slug_ripple              ;ripple the time please
0707 300A              end_rename   
0708 300A 60                    rts   
0709 300B              bad_type   
0710 300B A9 4B 00              lda   #bad_store_type
0711 300E 38                    sec   
0712 300F 60                    rts   
0713 3010
0714 3010              ;Rename a volume.
0715 3010              ;
0716 3010              ;Note - if cp_device_flag is $8001 then we're renaming a duplicate volume. In this
0717 3010              ;       case, don't call chk_boot_vol since the duplicate volume could have the same
0718 3010              ;       name as the boot volume and we don't want to change the boot prefix.
0719 3010              ;       3/26/91 CAE
0720 3010
0721 3010              rename_vol   
0722 3010 D4 84                 pei   my_vcr_ptr
0723 3012 D4 86                 pei   my_vcr_ptr+2
0724 3014 20 54 30              jsr   Check_dup_dest           ;see if the destination name is an active VCR
0725 3017 7A                    ply   
0726 3018 84 86                 sty   my_vcr_ptr+2
0727 301A 7A                    ply   
0728 301B 84 84                 sty   my_vcr_ptr
0729 301D 90 01                 bcc   @not_active
0730 301F 60                    rts   
0731 3020              @not_active  
0732 3020 AC FB 04              ldy   volume_name              ;terminate the new name with a null
0733 3023 A9 00 00              lda   #$0000
0734 3026 99 FD 04              sta   volume_name+2,y
0735 3029
0736 3029              ;	jsr	chk_boot_vol	;moved after call to setup_name 3/26/91 CAE
0737 3029
0738 3029 A9 FB 04              lda   #volume_name             ;move the name to search_name and
0739 302C 85 98                 sta   temp_ptr                 ;do syntax checking on the name
0740 302E A9 02 00              lda   #^volume_name
0741 3031 85 9A                 sta   temp_ptr+2
0742 3033 A9 02 00              lda   #$0002                   ;starting index for check
0743 3036 8D D1 05              sta   chars_checked
0744 3039 20 6C 21              jsr   setup_name
0745 303C                                                      ;following 2 lines added 3/26/91 CAE
0746 303C AD E5 05              lda   cp_device_flag           ;are we renaming a duplicate volume?
0747 303F 30 03                 bmi   @skip_chk                ;yes - so don't change the boot prefix
0748 3041 20 DE 30              jsr   chk_boot_vol             ;change boot prefix if renaming boot volume
0749 3044              @skip_chk  
0750 3044 A7 84                 lda   [my_vcr_ptr]             ;get the VCR ID
0751 3046 A2 FB 04              ldx   #volume_name             ;pointer to the new name
0752 3049 A0 02 00              ldy   #^volume_name
0753 304C 22 58 FC 01           jsl   rename_vcr
0754 3050
0755 3050              @go_type_ok  
0756 3050 18                    clc   
0757 3051 82 8C FF              brl   type_ok
0758 3054
0759 3054              ;======================================================================
0760 3054              ;We need to make sure that the destination name is not an allocated
0761 3054              ;VCR with open files.  If we find a VCR with open files then we should
0762 3054              ;remove it or return duplicate volume error.
0763 3054              ;======================================================================
0764 3054              Check_dup_dest  
0765 3054 A7 84                 lda   [my_vcr_ptr]             ;get the VCR ID of the source
0766 3056 48                    pha   
0767 3057
0768 3057 A2 FB 04              ldx   #volume_name             ;pointer to the volume name
0769 305A A0 02 00              ldy   #^volume_name
0770 305D A9 00 00              lda   #0000                    ;0000=search for vcr by name
0771 3060 22 48 FC 01           jsl   find_vcr
0772 3064 90 03                 bcc   @handle_dup
0773 3066              @no_dup_error  
0774 3066 68                    pla                            ;just fix the stack
0775 3067 18                    clc   
0776 3068 60                    rts                            ;no problem
0777 3069              @handle_dup  
0778 3069 22 38 FC 01           jsl   deref                    ;convert virtual to real
0779 306D 86 84                 stx   my_vcr_ptr
0780 306F 84 86                 sty   my_vcr_ptr+2             ;setup pointer to VCR
0781 3071
0782 3071 A7 84                 lda   [my_vcr_ptr]             ;get the VCR ID of the destination.
0783 3073 C3 01                 cmp   1,s                      ;is source = dest?
0784 3075 F0 EF                 beq   @no_dup_error
0785 3077 68                    pla                            ;we must fix the stack
0786 3078
0787 3078 A0 08 00              ldy   #vcr_open_cnt
0788 307B B7 84                 lda   [my_vcr_ptr],y
0789 307D D0 05                 bne   @sorry_dup               ;files open so don't log in new volume
0790 307F 20 71 0E              jsr   free_vcr                 ;free vcr pointed to by 'my_vcr_ptr'
0791 3082 18                    clc   
0792 3083 60                    rts                            ;we are happy again!
0793 3084
0794 3084              @sorry_dup                              ;
0795 3084 A9 57 00              lda   #dup_volume              ;duplicate volume online
0796 3087 38                    sec   
0797 3088 60                    rts   
0798 3089
0799 3089
0800 3089              ;======================================================================
0801 3089
0802 3089              move_new_name   
0803 3089 5A                    phy   
0804 308A A2 0E 00              ldx   #14
0805 308D A9 00 00              lda   #$0000
0806 3090              clear_old  
0807 3090 97 04                 sta   [drvr_buf_ptr],y
0808 3092 C8                    iny   
0809 3093 CA                    dex   
0810 3094 10 FA                 bpl   clear_old
0811 3096 7A                    ply   
0812 3097
0813 3097 5A                    phy   
0814 3098 A2 00 00              ldx   #$0000                   ;index into new name
0815 309B                       longa off
0816 309B E2 20                 sep   #$20                     ;8 bit mode
0817 309D AD 3E 05              lda   storage_type
0818 30A0 0D 23 05              ora   search_length
0819 30A3 97 04                 sta   [drvr_buf_ptr],y
0820 30A5 C8                    iny   
0821 30A6              name_store                              ;
0822 30A6 BD 25 05              lda   search_name,x            ;first ascii character
0823 30A9 97 04                 sta   [drvr_buf_ptr],y
0824 30AB C8                    iny   
0825 30AC E8                    inx   
0826 30AD EC 23 05              cpx   search_length
0827 30B0 D0 F4                 bne   name_store               ;move the entire name
0828 30B2
0829 30B2                       longa on
0830 30B2 C2 20                 rep   #$20
0831 30B4 68                    pla                            ;get index to the storage type 
0832 30B5 18                    clc   
0833 30B6 69 1C 00              adc   #version_index
0834 30B9 A8                    tay   
0835 30BA
0836 30BA AD 3E 05              lda   storage_type
0837 30BD C9 F0 00              cmp   #volume_header
0838 30C0 F0 10                 beq   @skip_case_save
0839 30C2
0840 30C2 AD 0F 03     @do_both lda   case_bits                ;set the case bits please
0841 30C5 F0 08                 beq   @do_save                 ;the case is all upper
0842 30C7
0843 30C7 2C 0E 00              bit   fst_attr                 ;user does not want case info
0844 30CA 30 03                 bmi   @do_save
0845 30CC 09 00 80              ora   #$8000                   ;set the case on bit.
0846 30CF              @do_save  
0847 30CF 97 04                 sta   [drvr_buf_ptr],y
0848 30D1 60                    rts   
0849 30D2
0850 30D2
0851 30D2              @skip_case_save  
0852 30D2 A0 1A 00              ldy   #create_index+4-2        ;save the case bits please
0853 30D5 20 C2 30              jsr   @do_both
0854 30D8 A0 06 00              ldy   #vol_create-2
0855 30DB 97 88                 sta   [prodos_vcr_ptr],y
0856 30DD 60                    rts   
0857 30DE
0858 30DE              ;======================================================================
0859 30DE              chk_boot_vol                            ;change the boot prefix if needed
0860 30DE AC 19 03              ldy   src_offset               ;original name of volume
0861 30E1 B7 04                 lda   [drvr_buf_ptr],y
0862 30E3 29 0F 00              and   #$000F                   ;clear storage type etc.
0863 30E6 1A                    inc   a                        ;add one for leading ':'
0864 30E7 8D BD 04              sta   def_vol_name             ;length word
0865 30EA A9 3A 3A              lda   #'::'                    ;leading ':'
0866 30ED 8D BF 04              sta   def_vol_name+2
0867 30F0
0868 30F0 C8                    iny                            ;point to the first character
0869 30F1 A2 00 00              ldx   #$0000
0870 30F4              boot_loop                               ;
0871 30F4 B7 04                 lda   [drvr_buf_ptr],y
0872 30F6 9D C0 04              sta   def_vol_name+3,x
0873 30F9 C8                    iny   
0874 30FA E8                    inx   
0875 30FB E0 10 00              cpx   #16                      ;move the max number of characters
0876 30FE D0 F4                 bne   boot_loop
0877 3100
0878 3100 22 AC FC 01           jsl   get_boot_pfx             ;get the pointer to the current volume
0879 3104 86 98                 stx   temp_ptr
0880 3106 84 9A                 sty   temp_ptr+2
0881 3108
0882 3108 A7 98                 lda   [temp_ptr]               ;verify the length
0883 310A CD BD 04              cmp   def_vol_name
0884 310D D0 3B                 bne   not_same
0885 310F A8                    tay                            ;use as index
0886 3110 C8                    iny                            ;get the last character please
0887 3111
0888 3111                       longa off
0889 3111 E2 20                 sep   #$20
0890 3113              boot_loop2  
0891 3113 B7 98                 lda   [temp_ptr],y
0892 3115 C9 61                 cmp   #'a'
0893 3117 90 06                 bcc   @no_convert              ;The character cannot be lower case
0894 3119 C9 7B                 cmp   #'z'+1
0895 311B B0 02                 bcs   @no_convert
0896 311D 29 DF                 and   #$DF                     ;convert char to upper case for compare
0897 311F              @no_convert  
0898 311F D9 BD 04              cmp   def_vol_name,y
0899 3122 D0 26                 bne   not_same
0900 3124 88                    dey   
0901 3125 10 EC                 bpl   boot_loop2               ;check the entire volume name
0902 3127
0903 3127                       longa on
0904 3127 C2 20                 rep   #$20
0905 3129
0906 3129 AD FB 04              lda   volume_name              ;get the length word of the new name
0907 312C A8                    tay   
0908 312D 1A                    inc   a                        ;add one for leading ':'
0909 312E 8D BD 04              sta   def_vol_name
0910 3131 A9 3A 3A              lda   #'::'
0911 3134 8D BF 04              sta   def_vol_name+2
0912 3137              new_boot                                ;
0913 3137 B9 FC 04              lda   volume_name+1,y
0914 313A 99 BF 04              sta   def_vol_name+2,y
0915 313D 88                    dey   
0916 313E D0 F7                 bne   new_boot
0917 3140
0918 3140 A2 BD 04              ldx   #def_vol_name            ;pointer to the new name
0919 3143 A0 02 00              ldy   #^def_vol_name
0920 3146 22 B0 FC 01           jsl   set_boot_pfx
0921 314A              not_same  
0922 314A                       longa on
0923 314A C2 20                 rep   #$20
0924 314C 60                    rts   
0925 314D
0926 314D              ;======================================================================
0927 314D
0928 314D              save_src_parms                          ;
0929 314D A5 00                 lda   drvr_dev_num             ;save source info
0930 314F 8D 13 03              sta   src_dev_num
0931 3152 AD E1 04              lda   dir_start_blk            ;starting block of directory
0932 3155 8D 15 03              sta   src_start_blk
0933 3158 AD 7B 05              lda   entry_offset             ;offset to directory entry
0934 315B 8D 19 03              sta   src_offset
0935 315E AD 79 05              lda   parent_blk               ;block that contains entry
0936 3161 8D 17 03              sta   src_dir_blk
0937 3164 60                    rts   
0938 3165
0939 3165              save_dest_parms                         ;
0940 3165 A5 00                 lda   drvr_dev_num             ;save source info
0941 3167 8D 29 03              sta   dest_dev_num
0942 316A AD E1 04              lda   dir_start_blk            ;starting block of directory
0943 316D 8D 2B 03              sta   dest_start_blk
0944 3170 AD E7 04              lda   free_dir_offset          ;offset to directory entry
0945 3173 8D 2F 03              sta   dest_offset
0946 3176 AD E5 04              lda   free_dir_blk             ;block that contains entry
0947 3179 8D 2D 03              sta   dest_dir_blk
0948 317C 60                    rts   
0949 317D
0950 317D              ;======================================================================
0951 317D
0952 317D              process_dest                            ;
0953 317D A5 3A                 lda   path1_ptr                ;save pathname one pointer
0954 317F 8D BF 05              sta   curr_mark
0955 3182 A5 3C                 lda   path1_ptr+2
0956 3184 8D C1 05              sta   curr_mark+2              ;temp save area!!!!!!!!!!!!!!!
0957 3187 A5 36                 lda   dev1_num
0958 3189 8D C3 05              sta   curr_eof
0959 318C A5 42                 lda   path_flag
0960 318E 8D C5 05              sta   curr_eof+2               ;temp storage
0961 3191
0962 3191 A5 3E                 lda   path2_ptr                ;make path two appear as path one
0963 3193 85 3A                 sta   path1_ptr
0964 3195 A5 40                 lda   path2_ptr+2
0965 3197 85 3C                 sta   path1_ptr+2
0966 3199
0967 3199 A5 38                 lda   dev2_num
0968 319B 85 36                 sta   dev_num
0969 319D
0970 319D A5 42                 lda   path_flag
0971 319F 29 40 00              and   #path2_mask
0972 31A2 EB                    xba   
0973 31A3 85 42                 sta   path_flag
0974 31A5              ;
0975 31A5              ;IF vol_rename_flag = minus then we are renaming the volume
0976 31A5              ;
0977 31A5 2C 31 03              bit   vol_rename_flag
0978 31A8 10 26                 bpl   normal_rename
0979 31AA A9 00 40              lda   #path1_mask
0980 31AD
0981 31AD A6 3A                 ldx   path1_ptr
0982 31AF A4 3C                 ldy   path1_ptr+2
0983 31B1 20 A4 14              jsr   build_path
0984 31B4
0985 31B4 AD 13 03              lda   src_dev_num
0986 31B7 85 00                 sta   drvr_dev_num
0987 31B9 AD 15 03              lda   src_start_blk
0988 31BC 8D E1 04              sta   dir_start_blk
0989 31BF AD 17 03              lda   src_dir_blk
0990 31C2 8D E5 04              sta   free_dir_blk
0991 31C5 AD 19 03              lda   src_offset
0992 31C8 8D E7 04              sta   free_dir_offset
0993 31CB 20 1F 32              jsr   restore_path1
0994 31CE 18                    clc   
0995 31CF 60                    rts   
0996 31D0
0997 31D0              normal_rename                           ;
0998 31D0
0999 31D0 A9 00 40              lda   #no_dup                  ;duplicate not allowed
1000 31D3 8D DF 04              sta   search_flag
1001 31D6 20 23 10              jsr   process_path             ;find the destination
1002 31D9
1003 31D9 AE 1B 03              ldx   slug_block               ;save for slug_ripple routine
1004 31DC 8E 25 03              stx   dest_slug_blk
1005 31DF AE 1D 03              ldx   slug_offset
1006 31E2 8E 27 03              stx   dest_slug_offset
1007 31E5
1008 31E5 B0 2C                 bcs   no_dup_problem
1009 31E7
1010 31E7 A5 00                 lda   drvr_dev_num             ;did the user enter the same name?
1011 31E9 CD 13 03              cmp   src_dev_num
1012 31EC D0 1D                 bne   dup_prob                 ;duplicate filename
1013 31EE AD E1 04              lda   dir_start_blk
1014 31F1 CD 15 03              cmp   src_start_blk
1015 31F4 D0 15                 bne   dup_prob
1016 31F6 AD 79 05              lda   parent_blk               ;block that contains entry
1017 31F9 CD 17 03              cmp   src_dir_blk
1018 31FC D0 0D                 bne   dup_prob
1019 31FE AD 7B 05              lda   entry_offset             ;offset to directory entry
1020 3201 CD 19 03              cmp   src_offset
1021 3204 D0 05                 bne   dup_prob
1022 3206 20 1F 32              jsr   restore_path1
1023 3209 18                    clc   
1024 320A 60                    rts                            ;renaming the same file
1025 320B
1026 320B              dup_prob                                ;
1027 320B 20 1F 32              jsr   restore_path1
1028 320E A9 47 00              lda   #dup_pathname
1029 3211              real_problem                            ;
1030 3211 38                    sec   
1031 3212 60                    rts   
1032 3213
1033 3213              no_dup_problem                          ;
1034 3213 48                    pha   
1035 3214 20 1F 32              jsr   restore_path1
1036 3217 68                    pla   
1037 3218 2C DB 04              bit   path_searched            ;was the entire path searched?
1038 321B 10 F4                 bpl   real_problem
1039 321D 18                    clc   
1040 321E 60                    rts   
1041 321F
1042 321F              restore_path1                           ; ;restore path1 stuff
1043 321F AD BF 05              lda   curr_mark
1044 3222 85 3A                 sta   path1_ptr
1045 3224 AD C1 05              lda   curr_mark+2
1046 3227 85 3C                 sta   path1_ptr+2
1047 3229 AD C3 05              lda   curr_eof
1048 322C 85 36                 sta   dev_num
1049 322E AD C5 05              lda   curr_eof+2
1050 3231 85 42                 sta   path_flag
1051 3233 60                    rts   
1052 3234
1053 3234              ;======================================================================
1054 3234              ;Possible combinations of pathnames
1055 3234              ;
1056 3234              ;(1)            .DEV1                --> /FOO          (Rename)
1057 3234              ;(2)            /FOO1                --> /FOO          (Rename)
1058 3234              ;(3)            /FOO1/PATHNAME       --> /FOO1/NEWNAME (Rename)
1059 3234              ;(4)            /FOO1/SUB/FILE       --> /FOO1/FILE    (Change path)
1060 3234              ;(5)            .DEV1/FILE           --> /FOO/NEW.NAME (Rename)
1061 3234              ;(6)            .DEV1/FILE           --> /FOO/SUB/FILE (Change path)
1062 3234              ;(7)            /FOO/FILE            --> .DEV1/SUB/NEW (Change path)
1063 3234              ;(8)            /FOO/FILE            --> .DEV1/NEW     (rename)
1064 3234              ;
1065 3234              ;Invalid Pathnames:
1066 3234              ;
1067 3234              ;(1)            /FOO                 --> .DEV1
1068 3234              ;(2)            /FOO                 --> /FOO/FILE
1069 3234              ;(3)            /FOO/SUB/            --> /FOO/SUB/SUB1/SUB
1070 3234              ;(4)            /FOO/FILE            --> /FOO
1071 3234              ;(5)            /FOO/FILE            --> .DEV1
1072 3234              ;
1073 3234              ;======================================================================
1074 3234
1075 3234              valid_change  
1076 3234 9C E9 05              stz   cp_to_child              ; assume source is not a subset of dest
1077 3237 9C 31 03              stz   vol_rename_flag
1078 323A A5 42                 lda   path_flag
1079 323C 29 40 00              and   #path2_mask              ;there has to be a second pathname
1080 323F F0 1C                 beq   to_bad_path
1081 3241
1082 3241 20 4F 33              jsr   setup_path1              ;Path1_ptr --> temp_ptr
1083 3244 20 3E 33              jsr   setup_path2              ;Path2_ptr --> temp2_ptr
1084 3247
1085 3247              ;
1086 3247              ;IF (Path1 = device_name) THEN
1087 3247              ;   (Path2 must be a volume name only)
1088 3247              ;
1089 3247              ;
1090 3247 A5 42                 lda   path_flag                ;is path1 a device name only?
1091 3249 29 00 40              and   #path1_mask
1092 324C D0 12                 bne   not_device               ;not just a device name
1093 324E A5 38                 lda   dev2_num
1094 3250 D0 0B                 bne   to_bad_path              ;path2 cannot contain a device name
1095 3252 A6 9C                 ldx   temp2_ptr
1096 3254 A4 9E                 ldy   temp2_ptr+2
1097 3256 20 15 33              jsr   scan_pass_vol            ;pass the volume name IF possible
1098 3259 90 02                 bcc   to_bad_path              ;there is more then just a volume name
1099 325B              ;
1100 325B              ;We are doing the following:  '.DEV1' to '/FOO'
1101 325B              ;
1102 325B 80 24                 bra   volume_rename
1103 325D
1104 325D              to_bad_path                             ;
1105 325D 82 AE 00              brl   bad_path
1106 3260              ;
1107 3260              ; IF (Path1 = volume_only) THEN
1108 3260              ;    (Path2 must be volume only)
1109 3260              ;
1110 3260              not_device                              ;
1111 3260 A5 36                 lda   dev1_num                 ;IF dev <> 00 THEN not volume only
1112 3262 D0 22                 bne   chk_same_dev
1113 3264 A6 98                 ldx   temp_ptr                 ;pointer to path1
1114 3266 A4 9A                 ldy   temp_ptr+2
1115 3268 20 15 33              jsr   scan_pass_vol
1116 326B 90 21                 bcc   not_vol_only             ;path1 <> volume only
1117 326D              ;
1118 326D              ; IF (path1 - volume) and ((path2 = device) or (path2 = dev/vol)) THEN
1119 326D              ;    bad_path_syntax
1120 326D              ;
1121 326D A5 42                 lda   path_flag
1122 326F 29 40 00              and   #path2_mask
1123 3272 F0 E9                 beq   to_bad_path
1124 3274 A5 38                 lda   dev2_num                 ;is there a device name also?
1125 3276 D0 14                 bne   a_bad_path
1126 3278
1127 3278 A6 9C                 ldx   temp2_ptr
1128 327A A4 9E                 ldy   temp2_ptr+2
1129 327C 20 15 33              jsr   scan_pass_vol            ;pass the volume name IF possible
1130 327F 90 DC                 bcc   to_bad_path              ;path2 <> volume only
1131 3281              ;
1132 3281              ;We are doing the following:  '/FOO1' to '/FOO'
1133 3281              ;
1134 3281              volume_rename                           ;
1135 3281 CE 31 03              dec   vol_rename_flag
1136 3284 18                    clc   
1137 3285 60                    rts   
1138 3286              ;
1139 3286              ;IF (Path1 <> volume only) THEN
1140 3286              ;   (Path2 MUST be a pathname)
1141 3286              ;
1142 3286              chk_same_dev                            ;
1143 3286 A5 38                 lda   dev2_num                 ;is the rename on the same device?
1144 3288 F0 04                 beq   not_vol_only
1145 328A C5 36                 cmp   dev1_num
1146 328C D0 CF        a_bad_path bne   to_bad_path
1147 328E
1148 328E              not_vol_only                            ;
1149 328E A5 42                 lda   path_flag
1150 3290 29 40 00              and   #path2_mask              ;is there a pathname?
1151 3293
1152 3293              if AllowLCPeriods then                  ;added 7-Aug-91 DAL
1153 3293 F0 79                 beq   to_bad_path
1154 3295              else                                    ;original code
1155 3295                       beq   bad_path                 ;must be device name only
1156 3295              endif                                   ;end 7-Aug-91 DAL
1157 3295
1158 3295 A5 38                 lda   dev2_num                 ;IF (dev = true) and (path = true) THEN
1159 3297 D0 1E                 bne   path2_is_path            ;   (path2 = pathname)
1160 3299
1161 3299 A6 9C                 ldx   temp2_ptr
1162 329B A4 9E                 ldy   temp2_ptr+2
1163 329D 20 15 33              jsr   scan_pass_vol
1164 32A0 B0 6C                 bcs   bad_path                 ;Path2 = volume name only!
1165 32A2 86 9C                 stx   temp2_ptr
1166 32A4 84 9E                 sty   temp2_ptr+2
1167 32A6              ;
1168 32A6              ;IF (path2 = path2-volume_name) and (path1 = volume_name) THEN
1169 32A6              ;   Path1 := Path1-volume_name
1170 32A6              ;
1171 32A6 A5 36                 lda   dev1_num                 ;does path1 contain a volume name?
1172 32A8 D0 31                 bne   do_scan                  ;no it does not
1173 32AA A6 98                 ldx   temp_ptr
1174 32AC A4 9A                 ldy   temp_ptr+2
1175 32AE 20 15 33              jsr   scan_pass_vol            ;scan past the volume name
1176 32B1 86 98                 stx   temp_ptr
1177 32B3 84 9A                 sty   temp_ptr+2
1178 32B5 80 24                 bra   do_scan
1179 32B7
1180 32B7              ;
1181 32B7              ; When Here Path1 and Path2 are both pathnames!
1182 32B7              ;
1183 32B7              ; IF (Path1 = dev) and (path2 = vol) THEN
1184 32B7              ;    path2 := path2-volume name
1185 32B7              ;
1186 32B7              path2_is_path                           ;
1187 32B7 A5 36                 lda   dev1_num                 ;does path1 contain a device name?
1188 32B9 F0 11                 beq   path1_volume             ;NO
1189 32BB
1190 32BB A5 38                 lda   dev2_num                 ;does path2 contain a device name?
1191 32BD D0 1C                 bne   do_scan                  ;path1 and path2 contains device names
1192 32BF
1193 32BF A6 9C                 ldx   temp2_ptr
1194 32C1 A4 9E                 ldy   temp2_ptr+2              ;scan pass the volume name
1195 32C3 20 15 33              jsr   scan_pass_vol
1196 32C6 86 9C                 stx   temp2_ptr
1197 32C8 84 9E                 sty   temp2_ptr+2
1198 32CA 80 0F                 bra   do_scan                  ;everything is OK so far
1199 32CC
1200 32CC              ;
1201 32CC              ; IF (path1 = volume) and (path2 = dev) THEN
1202 32CC              ;    path1 := path1-volume_name
1203 32CC
1204 32CC              path1_volume                            ;
1205 32CC A5 38                 lda   dev2_num                 ;does path2 contain a
1206 32CE F0 0B                 beq   do_scan                  ;Path1 and path2 contain volume names
1207 32D0
1208 32D0              ;
1209 32D0              ; IF (path2 = dev) and (path1 = vol) THEN
1210 32D0              ;    path1 := path1-volume_name
1211 32D0              ;
1212 32D0              scan_path1                              ;
1213 32D0 A6 98                 ldx   temp_ptr                 ;path1
1214 32D2 A4 9A                 ldy   temp_ptr+2
1215 32D4 20 15 33              jsr   scan_pass_vol            ;pass the volume name
1216 32D7 86 98                 stx   temp_ptr
1217 32D9 84 9A                 sty   temp_ptr+2
1218 32DB
1219 32DB              ;The following code was moved into the changepath code so
1220 32DB              ;that ProDOS conforms to the way AppleShare and HFS do a 
1221 32DB              ;changepath.  The check to see if the path1 is a subset 
1222 32DB              ;of path2 should not be done until after we check to see 
1223 32DB              ;if the path2 allready exsists.               10/3/91 JEV
1224 32DB              ;
1225 32DB              ; IF (path1 is a subset of path2) THEN
1226 32DB              ;    set cp_to_child
1227 32DB
1228 32DB              ;The following code has been changed to do a case-insensitive
1229 32DB              ;compare in order to fix a bug which was allowing illegal moves
1230 32DB              ;if the case of the pathnames was different.  1/22/91 CAE
1231 32DB
1232 32DB              do_scan                                 ;
1233 32DB A0 00 00              ldy   #$0000                   ;start scan at beginning
1234 32DE                       longa off
1235 32DE E2 20                 sep   #$20
1236 32E0              subset_loop                             ;
1237 32E0              ;	lda	[temp_ptr],y	;source file
1238 32E0              ;	cmp	[temp2_ptr],y	;destination
1239 32E0              ;	bne	more_chk
1240 32E0              ;	iny
1241 32E0              ;	bra	subset_loop
1242 32E0
1243 32E0 B7 98                 lda   [temp_ptr],y             ;get source file char
1244 32E2              if AllowLCPeriods then                  ;added 7-Aug-91 DAL
1245 32E2 C9 61                 cmp   #' '
1246 32E4                       bne   @not_blank1
1247 32E4                       lda   #'.'
1248 32E4              @not_blank1  
1249 32E4              endif                                   ;end 7-Aug-91 DAL
1250 32E4
1251 32E4                       cmp   #'a'                     ;upper case?
1252 32E4 90 02                 bcc   @its_upper1              ;yes
1253 32E6 29 DF                 and   #$DF                     ;no - so convert to upper case
1254 32E8 48           @its_upper1 pha                         ;save char
1255 32E9 B7 9C                 lda   [temp2_ptr],y            ;get dest file char
1256 32EB
1257 32EB              if AllowLCPeriods then                  ;added 7-Aug-91 DAL
1258 32EB C9 61                 cmp   #' '
1259 32ED                       bne   @not_blank2
1260 32ED                       lda   #'.'
1261 32ED              @not_blank2  
1262 32ED              endif                                   ;end 7-Aug-91 DAL
1263 32ED
1264 32ED                       cmp   #'a'                     ;upper case?
1265 32ED 90 02                 bcc   @its_upper2              ;yes
1266 32EF 29 DF                 and   #$DF                     ;no - so convert to upper case
1267 32F1 C3 01        @its_upper2 cmp   1,s                   ;same as source file char?
1268 32F3 D0 04                 bne   @no_match                ;nope
1269 32F5 68                    pla                            ;yes - so clean up stack
1270 32F6 C8                    iny                            ;adjust index
1271 32F7 80 E7                 bra   subset_loop              ;and loop
1272 32F9 68           @no_match pla                           ;clean up stack
1273 32FA
1274 32FA              more_chk                                ;
1275 32FA B7 9C                 lda   [temp2_ptr],y            ;this cannot be a 'delimiter'
1276 32FC C9 3A                 cmp   #delimiter
1277 32FE                       longa on                       ;go ahead and fix the mode
1278 32FE C2 20                 rep   #$20
1279 3300 D0 0A                 bne   paths_ok
1280 3302 B7 98                 lda   [temp_ptr],y             ;is this the end of the source?
1281 3304 29 FF 00              and   #$00FF
1282 3307 D0 03                 bne   paths_ok                 ;not the end of source name
1283 3309
1284 3309 EE E9 05              inc   cp_to_child              ; source was subset of dest! 27-Jan-92 MSD
1285 330C
1286 330C 18           paths_ok clc   
1287 330D 60                    rts   
1288 330E
1289 330E              bad_path  
1290 330E A9 40 00              lda   #bad_path_syntax
1291 3311 38                    sec   
1292 3312 4C 82 00              jmp   main_exit
1293 3315
1294 3315              ;======================================================================
1295 3315
1296 3315              scan_pass_vol                           ;
1297 3315 86 A0                 stx   temp3_ptr                ;pointer to the string
1298 3317 84 A2                 sty   temp3_ptr+2
1299 3319 A0 01 00              ldy   #$0001
1300 331C                       longa off
1301 331C E2 20                 sep   #$20
1302 331E              scanner                                 ;
1303 331E B7 A0                 lda   [temp3_ptr],y
1304 3320 F0 16                 beq   scan_failed              ;sorry volume name only
1305 3322 C9 3A                 cmp   #delimiter
1306 3324 F0 03                 beq   scan_passed
1307 3326 C8                    iny   
1308 3327 80 F5                 bra   scanner
1309 3329
1310 3329              scan_passed                             ;
1311 3329              ; 27-Jan-92 MSD: This routine was returning a pointer to the character
1312 3329              ; before the pathname separator.  It should have been returning a pointer
1313 3329              ; to the character after the separator.  Removed the DEY and changed a
1314 3329              ; CLC to a SEC before adding (so it will add 1 to point past separator).
1315 3329              ;
1316 3329              ;	dey
1317 3329
1318 3329                       longa on
1319 3329 C2 20                 rep   #$20                     ;back to 16 bit mode
1320 332B 38                    sec                            ; 27-Jan-92 MSD (was CLC)
1321 332C 98                    tya   
1322 332D 65 A0                 adc   temp3_ptr
1323 332F AA                    tax   
1324 3330 A9 00 00              lda   #$0000
1325 3333 65 A2                 adc   temp3_ptr+2
1326 3335 A8                    tay   
1327 3336 18                    clc                            ;not just a volume name
1328 3337 60                    rts   
1329 3338
1330 3338              scan_failed                             ;
1331 3338                       longa on
1332 3338 C2 20                 rep   #$20
1333 333A              ;        ldx   temp3_ptr
1334 333A A4 A2                 ldy   temp3_ptr+2              ;restore X and Y
1335 333C 38                    sec   
1336 333D 60                    rts   
1337 333E
1338 333E              ;======================================================================
1339 333E
1340 333E              setup_path2                             ;
1341 333E A6 3E                 ldx   path2_ptr
1342 3340 A4 40                 ldy   path2_ptr+2
1343 3342 E8                    inx   
1344 3343 D0 01                 bne   do_again
1345 3345 C8                    iny   
1346 3346 E8           do_again inx   
1347 3347 D0 01                 bne   cont
1348 3349 C8                    iny   
1349 334A              cont                                    ;
1350 334A 86 9C                 stx   temp2_ptr                ;pointer to pathname two
1351 334C 84 9E                 sty   temp2_ptr+2
1352 334E 60                    rts   
1353 334F
1354 334F              ;======================================================================
1355 334F
1356 334F              setup_path1                             ;
1357 334F A6 3A                 ldx   path1_ptr
1358 3351 A4 3C                 ldy   path1_ptr+2
1359 3353 E8                    inx   
1360 3354 D0 01                 bne   do2_again
1361 3356 C8                    iny   
1362 3357 E8           do2_again inx   
1363 3358 D0 01                 bne   cont2
1364 335A C8                    iny   
1365 335B              cont2                                   ;
1366 335B 86 98                 stx   temp_ptr                 ;pointer to pathname one
1367 335D 84 9A                 sty   temp_ptr+2
1368 335F 60                    rts   
1369 3360
1370 3360                       ENDP 
1371 3360              ;==========================================================================
1372 3360              ;Set_file_info: This routine will alter information about a file on disk.
1373 3360              ;
1374 3360              ;Created:       may 26, 1987
1375 3360              ;Modified:      jan 06, 1987
1376 3360              ;Author:        Rob Turner
1377 3360              ;
1378 3360              ;Enter:         jml
1379 3360              ;
1380 3360              ;Input:         A = undefined
1381 3360              ;               X = call number times 2
1382 3360              ;               Y = class times 2
1383 3360              ;               P = nvmxdizc
1384 3360              ;                   ..000...
1385 3360              ;               b = k
1386 3360              ;
1387 3360              ;Output:        A = error code if carry set
1388 3360              ;               X = undefined
1389 3360              ;               Y = undefined
1390 3360              ;               P = nvmxdizc
1391 3360              ;                   ..000..1 = error
1392 3360              ;                          0 = no error
1393 3360              ;               b = k
1394 3360              ;
1395 3360              ;Uses:          All registers
1396 3360              ;               find_file
1397 3360              ;
1398 3360              ;Call Format:
1399 3360              ;
1400 3360              ;Class 0        Pathname Pointer        (4 Bytes)
1401 3360              ;               Access                  (2 Bytes: Disk Format)
1402 3360              ;               File Type               (2 Bytes)
1403 3360              ;               Aux Type                (4 Bytes)
1404 3360              ;               Null Field              (2 Bytes)
1405 3360              ;               Create Date/Time        (4 Bytes: ProDOS Format)
1406 3360              ;               Mod Date/Time           (4 Bytes: ProDOS Format)
1407 3360              ;
1408 3360              ;Class 1        PCount                  (2 Bytes)
1409 3360              ;               Pathname Pointer        (4 Bytes)
1410 3360              ;               Access                  (2 Bytes: Disk Format)
1411 3360              ;               File Type               (2 Bytes)
1412 3360              ;               Aux Type                (4 Bytes)
1413 3360              ;               Null Field              (2 Bytes)
1414 3360              ;               Create Date/Time        (8 Bytes: Misc. Tools Format)
1415 3360              ;               Mod Date/Time           (8 Bytes: Misc. Tools Format)
1416 3360              ;               Option List             (4 Bytes)
1417 3360              ;               Null Field              (4 Bytes)
1418 3360              ;               Null Field              (4 Bytes)
1419 3360              ;               Null Field              (4 Bytes)
1420 3360              ;               Null Field              (4 Bytes)
1421 3360              ;==========================================================================
1422 3360                       longa on
1423 3360                       longi on
1424 3360
1425 3360                       EXPORT set_file_info
1426 3360              set_file_info PROC 
1427 3360
1428 3360              ;==========================================================================
1429 3360              ;Indicate that we don't have any HFS Finder Info.
1430 3360              ;==========================================================================
1431 3360
1432 3360 9C EB 05              stz   hfs_flag
1433 3363
1434 3363              ;==========================================================================
1435 3363              ;Reset all time fields to zero.  This forces me to calculate the time if
1436 3363              ;needed.  However, if the create time is set to zero then the create date
1437 3363              ;and time fields will be left unchanged.
1438 3363              ;==========================================================================
1439 3363
1440 3363 9C A5 05              stz   mod_time
1441 3366 9C A7 05              stz   mod_time+2
1442 3369
1443 3369 9C A1 05              stz   create_time
1444 336C 9C A3 05              stz   create_time+2
1445 336F
1446 336F              ;==========================================================================
1447 336F              ;Go and setup the default parameters for the call.
1448 336F              ;==========================================================================
1449 336F
1450 336F 20 9E 0E              jsr   setup_params
1451 3372 08                    php                            ;save class state
1452 3373
1453 3373              ;==========================================================================
1454 3373              ;Process the file name and locate it.
1455 3373              ;==========================================================================
1456 3373
1457 3373 20 23 10              jsr   process_path
1458 3376 20 9B 13              jsr   chk_disk_protect
1459 3379
1460 3379              ;==========================================================================
1461 3379              ;See if this is a volume header.  If it is then return 'bad_path_syntax'
1462 3379              ;==========================================================================
1463 3379
1464 3379 A7 04                 lda   [drvr_buf_ptr]
1465 337B 29 F0 00              and   #$00F0
1466 337E C9 F0 00              cmp   #volume_header
1467 3381 D0 07                 bne   ok_to_change
1468 3383
1469 3383 A9 40 00              lda   #bad_path_syntax
1470 3386              set_info_err                            ;
1471 3386 38                    sec   
1472 3387              set_info_exit                           ;
1473 3387 4C 82 00              jmp   main_exit
1474 338A
1475 338A              ;==========================================================================
1476 338A              ;Move the directory entry into one entry please
1477 338A              ;==========================================================================
1478 338A
1479 338A              ok_to_change                            ;
1480 338A 20 09 3E              jsr   move_dir_entry
1481 338D
1482 338D AD 40 05              lda   alloc_entry              ;get the length word
1483 3390 0D 3E 05              ora   storage_type             ;add in the storage type
1484 3393 0D 41 05              ora   one_entry                ;add in the 1st char of name
1485 3396 8D 41 05              sta   one_entry
1486 3399
1487 3399 28                    plp                            ;restore class flag.
1488 339A F0 58                 beq   class0
1489 339C
1490 339C              ;==========================================================================
1491 339C              ;When we get here we know that this is a class one call.
1492 339C              ;So now we start processing the parameters supplied.
1493 339C              ;==========================================================================
1494 339C
1495 339C CE B7 05              dec   pcount
1496 339F CE B7 05              dec   pcount
1497 33A2
1498 33A2 20 BF 34              jsr   get_access               ;setup the access field
1499 33A5
1500 33A5 CE B7 05              dec   pcount
1501 33A8 30 16                 bmi   to_no_time_change
1502 33AA
1503 33AA              ;==========================================================================
1504 33AA              ;go and grab the file type that the user has provided.
1505 33AA              ;If the storage type is a directory then we must nake sure the file
1506 33AA              ;type field is $0F, which indicates that the file is a directory.
1507 33AA              ;==========================================================================
1508 33AA
1509 33AA 20 F0 34              jsr   get_ftype
1510 33AD 20 79 35              jsr   set_dir_type
1511 33B0 CE B7 05              dec   pcount
1512 33B3 30 0B                 bmi   to_no_time_change
1513 33B5
1514 33B5              ;==========================================================================
1515 33B5              ;The user's has also provided the aux type.
1516 33B5              ;==========================================================================
1517 33B5
1518 33B5 20 DB 34              jsr   get_aux_type
1519 33B8
1520 33B8              ;==========================================================================
1521 33B8              ;Skip all the  null fields
1522 33B8              ;==========================================================================
1523 33B8 CE B7 05              dec   pcount
1524 33BB CE B7 05              dec   pcount
1525 33BE 10 03                 bpl   cont
1526 33C0              to_no_time_change  
1527 33C0 82 8C 00              brl   no_time_change
1528 33C3              cont      
1529 33C3
1530 33C3              ;==========================================================================
1531 33C3              ;user's has also provided the create data.  Isn't that special!
1532 33C3              ;==========================================================================
1533 33C3
1534 33C3 A0 0E 00              ldy   #pblk_05_create
1535 33C6 20 04 35              jsr   get_pblk_time
1536 33C9 90 03                 bcc   @good1                   ; 27-Jan-92 MSD:
1537 33CB A0 00 80              ldy   #$8000                   ; invalid, but non-zero
1538 33CE              @good1    
1539 33CE 8E A1 05              stx   create_time
1540 33D1 8C A3 05              sty   create_time+2
1541 33D4
1542 33D4 CE B7 05              dec   pcount
1543 33D7 30 5F                 bmi   do_create_only
1544 33D9
1545 33D9              ;==========================================================================
1546 33D9              ;Holly Cow Batman the user's has even given us the modification date!
1547 33D9              ;==========================================================================
1548 33D9
1549 33D9 A0 16 00              ldy   #pblk_05_mod
1550 33DC 20 04 35              jsr   get_pblk_time
1551 33DF 90 03                 bcc   @good2                   ; 27-Jan-92 MSD:
1552 33E1 A0 00 80              ldy   #$8000                   ; invalid, but non-zero
1553 33E4              @good2    
1554 33E4 8E A5 05              stx   mod_time
1555 33E7 8C A7 05              sty   mod_time+2
1556 33EA                                                      ;new code added 2/13/91 CAE
1557 33EA CE B7 05              dec   pcount
1558 33ED 30 2E                 bmi   set_the_info
1559 33EF
1560 33EF              ;==========================================================================
1561 33EF              ;An option list was also provided
1562 33EF              ;==========================================================================
1563 33EF
1564 33EF 20 8B 35              jsr   get_option_list
1565 33F2                                                      ;end of new code
1566 33F2 80 29                 bra   set_the_info
1567 33F4
1568 33F4              class0    
1569 33F4              ;==========================================================================
1570 33F4              ;The old style call has to provide everything, So go ahead and get it.
1571 33F4              ;==========================================================================
1572 33F4
1573 33F4 20 BF 34              jsr   get_access
1574 33F7 20 F0 34              jsr   get_ftype
1575 33FA 20 79 35              jsr   set_dir_type
1576 33FD 20 DB 34              jsr   get_aux_type
1577 3400
1578 3400              ;==========================================================================
1579 3400              ;get the create date and time
1580 3400              ;==========================================================================
1581 3400
1582 3400 A0 0E 00              ldy   #$000E                   ;index to the create time
1583 3403 B7 80                 lda   [my_pblk_ptr],y
1584 3405 8D A1 05              sta   create_time
1585 3408 C8                    iny   
1586 3409 C8                    iny   
1587 340A B7 80                 lda   [my_pblk_ptr],y
1588 340C 8D A3 05              sta   create_time+2
1589 340F
1590 340F              ;==========================================================================
1591 340F              ;Get the modification date and time.
1592 340F              ;==========================================================================
1593 340F
1594 340F C8                    iny   
1595 3410 C8                    iny   
1596 3411 B7 80                 lda   [my_pblk_ptr],y
1597 3413 8D A5 05              sta   mod_time
1598 3416 C8                    iny   
1599 3417 C8                    iny   
1600 3418 B7 80                 lda   [my_pblk_ptr],y
1601 341A 8D A7 05              sta   mod_time+2
1602 341D
1603 341D              ;==========================================================================
1604 341D              ;We get to 'set_the_info' from both the class1 and class0 style calls.
1605 341D              ;==========================================================================
1606 341D
1607 341D              set_the_info  
1608 341D 20 3C 0A              jsr   pack_time                ;read the system clock please
1609 3420                                                      ;X & Y contain the date and time
1610 3420
1611 3420 AD A5 05              lda   mod_time                 ;did the user supply the date and time?
1612 3423 0D A7 05              ora   mod_time+2               ;(i.e. is the parameter != 0?)
1613 3426 F0 0A                 beq   @use_current             ;yes, use the current date and time
1614 3428 AE A5 05              ldx   mod_time                 ;else use the user supplied values
1615 342B AD A7 05              lda   mod_time+2
1616 342E 29 3F 1F              and   #$1F3F                   ;make sure parameters are in range
1617 3431 A8                    tay   
1618 3432              @use_current  
1619 3432 8E 62 05              stx   one_entry+last_mod_index
1620 3435 8C 64 05              sty   one_entry+last_mod_index+2
1621 3438
1622 3438              do_create_only  
1623 3438 AD A1 05              lda   create_time              ;did the user supply a creation date & time?
1624 343B 0D A3 05              ora   create_time+2
1625 343E F0 0F                 beq   no_time_change           ;no, just leave it alone
1626 3440 AD A1 05              lda   create_time              ;else copy user's values to entry
1627 3443 8D 59 05              sta   one_entry+create_index
1628 3446 AD A3 05              lda   create_time+2
1629 3449 29 3F 1F              and   #$1F3F                   ;make sure parameters are in range
1630 344C 8D 5B 05              sta   one_entry+create_index+2
1631 344F
1632 344F              no_time_change  
1633 344F A0 26 00              ldy   #entry_length-1
1634 3452              put_back                                ;
1635 3452 B9 41 05              lda   one_entry,y
1636 3455 97 04                 sta   [drvr_buf_ptr],y
1637 3457 88                    dey   
1638 3458 88                    dey   
1639 3459 10 F7                 bpl   put_back
1640 345B
1641 345B AD EB 02              lda   gbuf_addr
1642 345E 85 04                 sta   drvr_buf_ptr
1643 3460 AD ED 02              lda   gbuf_addr+2
1644 3463 85 06                 sta   drvr_buf_ptr+2
1645 3465
1646 3465 20 8D 15              jsr   standard_req
1647 3468
1648 3468 20 9A 17              jsr   write_with_cache
1649 346B B0 10                 bcs   all_done
1650 346D
1651 346D 20 80 34              jsr   fix_the_fcr              ;update the File Control Record if needed
1652 3470 20 C8 1A              jsr   slug_ripple
1653 3473 B0 08                 bcs   all_done
1654 3475                                                      ;new code code added 2/13/91 CAE
1655 3475 AD EB 05              lda   hfs_flag                 ;do we have any HFS info?
1656 3478 F0 03                 beq   all_done                 ;no - so we're done
1657 347A 20 E4 35              jsr   store_hfs_info           ;yes - so store it in the resource header
1658 347D                                                      ;end of new code
1659 347D 4C 87 33     all_done jmp   set_info_exit
1660 3480
1661 3480              ;==========================================================================
1662 3480              ;=============== END OF THE MAIN CODE FOR SET_FILE_INFO ===================
1663 3480              ;==========================================================================
1664 3480
1665 3480              ;==========================================================================
1666 3480              ;Below is the subroutines used by SET_FILE_INFO.
1667 3480              ;==========================================================================
1668 3480              ;==========================================================================
1669 3480              ;Now we see if the file is already open.  We do this by calling
1670 3480              ;get_next_fcr.  If this routine finds a ProDOS FCR then we see if the key
1671 3480              ;block is the same.  If it is then we also update the FCR along with the
1672 3480              ;disk
1673 3480              ;==========================================================================
1674 3480              fix_the_fcr  
1675 3480 9C 36 05              stz   fcr_wanted               ;reset counter for Get_Next_FCR
1676 3483
1677 3483              look_loop                               ;
1678 3483 20 E1 3D              jsr   get_next_fcr             ;go grab a FCR
1679 3486 B0 36                 bcs   no_fcr
1680 3488
1681 3488 A0 08 00              ldy   #fcr_vol_id
1682 348B B7 8C                 lda   [my_fcr_ptr],y           ;get the Volume ID so we can make sure the file is on
1683 348D C7 84                 cmp   [my_vcr_ptr]             ;the same volume.
1684 348F D0 F2                 bne   look_loop                ;File is on another volume
1685 3491
1686 3491 A0 06 00              ldy   #fcr_file_id
1687 3494 B7 90                 lda   [pro_fcr_ptr],y
1688 3496 CD 52 05              cmp   one_entry+key_blk_index
1689 3499 D0 E8                 bne   look_loop
1690 349B
1691 349B              ;==========================================================================
1692 349B              ;Save a modified Aux type please
1693 349B              ;==========================================================================
1694 349B
1695 349B A0 17 00              ldy   #fcr_aux_type            ;update the aux type please
1696 349E AD 60 05              lda   one_entry+aux_type_index
1697 34A1 97 90                 sta   [pro_fcr_ptr],y
1698 34A3
1699 34A3              ;==========================================================================
1700 34A3              ;Save file type please
1701 34A3              ;==========================================================================
1702 34A3
1703 34A3 A0 08 00              ldy   #fcr_file_type
1704 34A6 AD 51 05              lda   one_entry+file_type_index
1705 34A9 E2 20                 sep   #$20                     ;a short store
1706 34AB 97 90                 sta   [pro_fcr_ptr],y
1707 34AD C2 20                 rep   #$20
1708 34AF
1709 34AF              ;==========================================================================
1710 34AF              ;Save create time please
1711 34AF              ;==========================================================================
1712 34AF
1713 34AF A0 10 00              ldy   #fcr_create              ;update the create time
1714 34B2 AD 59 05              lda   one_entry+create_index
1715 34B5 97 90                 sta   [pro_fcr_ptr],y
1716 34B7 C8                    iny   
1717 34B8 C8                    iny   
1718 34B9 AD 5B 05              lda   one_entry+create_index+2
1719 34BC 97 90                 sta   [pro_fcr_ptr],y
1720 34BE
1721 34BE 60           no_fcr   rts   
1722 34BF
1723 34BF              ;==========================================================================
1724 34BF              ;Store the user's access field in the
1725 34BF              ;==========================================================================
1726 34BF              get_access  
1727 34BF              ;
1728 34BF A0 04 00              ldy   #pblk_05_accs
1729 34C2 B7 80                 lda   [my_pblk_ptr],y
1730 34C4 AA                    tax   
1731 34C5 29 18 FF              and   #$FF18                   ;clear the reserved bits
1732 34C8 D0 0B                 bne   bad_bits                 ;sorry bud you are out of range
1733 34CA                       longa off
1734 34CA E2 20                 sep   #$20
1735 34CC 8A                    txa   
1736 34CD 09 20                 ora   #backup_on               ;force the backup bit on
1737 34CF 8D 5F 05              sta   one_entry+access_index
1738 34D2                       longa on
1739 34D2 C2 20                 rep   #$20
1740 34D4 60                    rts   
1741 34D5
1742 34D5              bad_bits  
1743 34D5 A9 53 00              lda   #parm_range_err
1744 34D8 82 AB FE              brl   set_info_err
1745 34DB
1746 34DB              ;==========================================================================
1747 34DB              ;get_aux_type and store it
1748 34DB              ;==========================================================================
1749 34DB
1750 34DB              get_aux_type  
1751 34DB A0 0A 00              ldy   #pblk_05_aux+2
1752 34DE B7 80                 lda   [my_pblk_ptr],y
1753 34E0 D0 08                 bne   range_problem
1754 34E2 88                    dey   
1755 34E3 88                    dey   
1756 34E4 B7 80                 lda   [my_pblk_ptr],y
1757 34E6 8D 60 05              sta   one_entry+aux_type_index
1758 34E9 60                    rts   
1759 34EA
1760 34EA              range_problem  
1761 34EA A9 53 00              lda   #parm_range_err
1762 34ED 82 96 FE              brl   set_info_err
1763 34F0
1764 34F0              ;==========================================================================
1765 34F0              ;Get the file type
1766 34F0              ;==========================================================================
1767 34F0
1768 34F0              get_ftype   
1769 34F0 A0 06 00              ldy   #pblk_05_ftype
1770 34F3 B7 80                 lda   [my_pblk_ptr],y
1771 34F5 AA                    tax   
1772 34F6 29 00 FF              and   #$FF00
1773 34F9 D0 EF                 bne   range_problem
1774 34FB                       longa off
1775 34FB E2 20                 sep   #$20
1776 34FD 8A                    txa   
1777 34FE 8D 51 05              sta   one_entry+file_type_index
1778 3501                       longa on
1779 3501 C2 20                 rep   #$20
1780 3503 60                    rts   
1781 3504
1782 3504              ;==========================================================================
1783 3504              ;This routine is used to convert the extended date and time fields into
1784 3504              ;ProDOS data and time fields
1785 3504              ;==========================================================================
1786 3504
1787 3504              get_pblk_time  
1788 3504 B7 80                 lda   [my_pblk_ptr],y          ;Get the second field so I can range check it
1789 3506 29 FF 00              and   #$00FF                   ;clear the minutes field
1790 3509 C9 3C 00              cmp   #60
1791 350C B0 DC                 bcs   range_problem
1792 350E
1793 350E C8                    iny                            ;get the minutes field
1794 350F B7 80                 lda   [my_pblk_ptr],y
1795 3511 AA                    tax   
1796 3512 29 FF 00              and   #$00FF
1797 3515 C9 3C 00              cmp   #60                      ;minutes are 00 to 59
1798 3518 B0 D0                 bcs   range_problem
1799 351A 8D F9 02              sta   minutes                  ;save the minutes field
1800 351D 8A                    txa   
1801 351E EB                    xba   
1802 351F 29 FF 00              and   #$00FF
1803 3522 C9 18 00              cmp   #24                      ;hours are 00 to 23
1804 3525 B0 C3                 bcs   range_problem
1805 3527 8D F7 02              sta   hours                    ;save the hours field
1806 352A
1807 352A C8                    iny   
1808 352B C8                    iny   
1809 352C
1810 352C B7 80                 lda   [my_pblk_ptr],y
1811 352E AA                    tax   
1812 352F 29 FF 00              and   #$00FF
1813 3532 8D FB 02              sta   year                     ;save the year as well
1814 3535 8A                    txa   
1815 3536 EB                    xba   
1816 3537 29 FF 00              and   #$00FF
1817 353A C9 1F 00              cmp   #31                      ;days are 00 to 30
1818 353D B0 AB                 bcs   range_problem
1819 353F 8D FF 02              sta   day                      ;don't forget the day now.
1820 3542
1821 3542 C8                    iny   
1822 3543 C8                    iny   
1823 3544 B7 80                 lda   [my_pblk_ptr],y
1824 3546 29 FF 00              and   #$00FF
1825 3549 8D FD 02              sta   month
1826 354C C9 0C 00              cmp   #12                      ;month = 0 to 11
1827 354F B0 99                 bcs   range_problem
1828 3551
1829 3551 C8                    iny                            ;get the null/day of week field
1830 3552 B7 80                 lda   [my_pblk_ptr],y
1831 3554 EB                    xba                            ;put null in the high byte for easy compare
1832 3555 C9 08 00              cmp   #$0008                   ;max value is 7 for day of week
1833 3558 B0 90                 bcs   range_problem
1834 355A
1835 355A AD F7 02              lda   hours
1836 355D 0D F9 02              ora   minutes
1837 3560 0D FB 02              ora   year
1838 3563 0D FF 02              ora   day
1839 3566 0D FD 02              ora   month
1840 3569 F0 0A                 beq   use_clock
1841 356B
1842 356B EE FF 02              inc   day
1843 356E EE FD 02              inc   month                    ;comvert to ProDOS format
1844 3571 20 45 0A              jsr   convert_time             ;convert the time to ProDOS format
1845 3574 60                    rts   
1846 3575
1847 3575              use_clock                               ;
1848 3575 AA                    tax                            ;return 0000 so we use the current time
1849 3576 9B                    txy   
1850 3577 18                    clc                            ; 27-Jan-92 MSD: date was valid
1851 3578 60                    rts   
1852 3579
1853 3579              ;==========================================================================
1854 3579              ;This routine will change the file type to $0F if the storage type of the
1855 3579              ;file is a subdirectory
1856 3579              ;==========================================================================
1857 3579
1858 3579              set_dir_type                            ;
1859 3579 AD 3E 05              lda   storage_type             ;if storage is a directory only allow
1860 357C C9 D0 00              cmp   #subdir_type             ;file type of $0F please
1861 357F D0 09                 bne   norm_file
1862 3581
1863 3581                       longa off                      ;short mode for a second please
1864 3581 E2 20                 sep   #$20
1865 3583 A9 0F                 lda   #$000F                   ;File type for directories
1866 3585 8D 51 05              sta   one_entry+file_type_index
1867 3588                       longa on
1868 3588 C2 20                 rep   #$20                     ;back to 16 bit mode
1869 358A
1870 358A              norm_file                               ;
1871 358A 60                    rts   
1872 358B
1873 358B              ;==========================================================================
1874 358B              ;Get the option list info.
1875 358B              ;
1876 358B              ;The option list is structured as follows -
1877 358B              ;
1878 358B              ;       word - buffer size
1879 358B              ;       word - data size
1880 358B              ;       word - FST ID
1881 358B              ;       additional data (FST-specific)
1882 358B              ;==========================================================================
1883 358B
1884 358B              get_option_list                         ;added 2/13/91 CAE
1885 358B
1886 358B              ; If the file is not a resource file then skip the option list since there's
1887 358B              ; no place to store the info anyway.
1888 358B
1889 358B AD 3E 05              lda   storage_type             ;get storage type
1890 358E C9 50 00              cmp   #resource_type           ;is it a resource file?
1891 3591 D0 50                 bne   @done                    ;no - so skip option list
1892 3593
1893 3593              ; Store ptr to option list buffer on direct page.  Exit if ptr = 0.
1894 3593
1895 3593 A0 1E 00              ldy   #pblk_05_opt
1896 3596 B7 80                 lda   [my_pblk_ptr],y          ;get option list ptr
1897 3598 85 98                 sta   <temp_ptr                ;and store
1898 359A C8                    iny   
1899 359B C8                    iny   
1900 359C B7 80                 lda   [my_pblk_ptr],y
1901 359E 29 FF 00              and   #$00ff                   ;clear hi byte
1902 35A1 85 9A                 sta   <temp_ptr+2
1903 35A3 05 98                 ora   <temp_ptr                ;is ptr 0?
1904 35A5 F0 3C                 beq   @done                    ;yes - so done
1905 35A7                        
1906 35A7              ; Is the buffer big enough to contain what we expect (ie. HFS Finder Info)?
1907 35A7                        
1908 35A7 A7 98                 lda   [temp_ptr]               ;get buffer size
1909 35A9 C9 26 00              cmp   #6+32                    ;is it big enough?
1910 35AC 90 35                 bcc   @done                    ;no - so done
1911 35AE                        
1912 35AE              ; The buffer is big enough so now check the data size to see if the data is
1913 35AE              ; really there.  We expect a minimum of 34 bytes of data.
1914 35AE              ; NOTE - We need to check both the buffer size and the data size because in
1915 35AE              ;        previous releases of GS/OS, the data size field was undefined.
1916 35AE                        
1917 35AE A0 02 00              ldy   #2                       ;get offset to data size field
1918 35B1 B7 98                 lda   [temp_ptr],y             ;get data size
1919 35B3 C9 22 00              cmp   #34                      ;enough data?
1920 35B6 90 2B                 bcc   @done                    ;no - so done
1921 35B8
1922 35B8              ; Check the FST ID.  If it's not ProDOS, HFS or AppleShare then exit.
1923 35B8
1924 35B8 A0 04 00              ldy   #4                       ;get offset to fst id field
1925 35BB B7 98                 lda   [temp_ptr],y             ;get the fst id
1926 35BD C9 01 00              cmp   #pro_id                  ;is it prodos?
1927 35C0 F0 0A                 beq   @id_ok                   ;yes
1928 35C2 C9 06 00              cmp   #hfs_id                  ;is it hfs?
1929 35C5 F0 05                 beq   @id_ok                   ;yes
1930 35C7 C9 0D 00              cmp   #ashare_id               ;is it appleshare?
1931 35CA D0 17                 bne   @done                    ;no - so done
1932 35CC              @id_ok    
1933 35CC                        
1934 35CC              ; Copy the HFS Finder Info from the option list buffer into a storage area.
1935 35CC                        
1936 35CC A2 00 00              ldx   #0                       ;init offset into finfo storage
1937 35CF A0 06 00              ldy   #6                       ;init offset into option list buffer
1938 35D2 B7 98        @finfo_loop lda   [temp_ptr],y          ;get word of finder info 
1939 35D4 9D ED 05              sta   hfs_finfo,x              ;and save it in storage area
1940 35D7 C8                    iny                            ;adjust offsets
1941 35D8 C8                    iny   
1942 35D9 E8                    inx   
1943 35DA E8                    inx   
1944 35DB E0 20 00              cpx   #32
1945 35DE 90 F2                 bcc   @finfo_loop              ;loop until done
1946 35E0
1947 35E0 EE EB 05              inc   hfs_flag                 ;indicate that we have HFS info
1948 35E3 60           @done    rts                            ;and return
1949 35E4
1950 35E4              ;==========================================================================
1951 35E4              ;Store the HFS Finder Info in the resource header.  
1952 35E4              ;The Finder Info is stored immediately after the mini-entry for the data fork,
1953 35E4              ;so it begins at offset $0008 in the block. 
1954 35E4              ;
1955 35E4              ;format:        entry size              (1 byte)
1956 35E4              ;               entry type              (1 byte)
1957 35E4              ;               HFS Finder Info         (16 bytes)
1958 35E4              ;               entry size              (1 byte)
1959 35E4              ;               entry type              (1 byte)
1960 35E4              ;               HFS Finder Info         (16 bytes)
1961 35E4              ;
1962 35E4              ; entry_size = 18
1963 35E4              ; entry_type = 1 for first 16 bytes of Finder Info (FInfo)
1964 35E4              ;              2 for second 16 bytes of Finder Info (xFInfo)
1965 35E4              ;
1966 35E4              ;==========================================================================
1967 35E4
1968 35E4              store_hfs_info                          ;added 2/13/91 CAE
1969 35E4 20 82 15              jsr   set_default_buf
1970 35E7 20 8D 15              jsr   standard_req
1971 35EA AD 52 05              lda   one_entry+key_blk_index
1972 35ED 85 10                 sta   drvr_blk_num
1973 35EF 64 12                 stz   drvr_blk_num+2
1974 35F1 20 95 17              jsr   read_with_cache          ;get the resource header
1975 35F4 B0 38                 bcs   @error
1976 35F6
1977 35F6 A9 01 00              lda   #finfo_type              ;get entry type
1978 35F9 EB                    xba                            ;move it into the hi byte
1979 35FA 09 12 00              ora   #18                      ;put entry size in lo byte
1980 35FD A0 08 00              ldy   #8
1981 3600 97 04                 sta   [drvr_buf_ptr],y         ;and store in first entry
1982 3602
1983 3602 A9 02 00              lda   #xfinfo_type             ;get entry type
1984 3605 EB                    xba                            ;move it into the hi byte
1985 3606 09 12 00              ora   #18                      ;put entry size in lo byte
1986 3609 A0 1A 00              ldy   #8+18
1987 360C 97 04                 sta   [drvr_buf_ptr],y         ;and store in second entry
1988 360E
1989 360E A2 00 00              ldx   #0
1990 3611 A0 0A 00              ldy   #10
1991 3614 BD ED 05     @loop    lda   hfs_finfo,x              ;copy the HFS Finder Info into
1992 3617 97 04                 sta   [drvr_buf_ptr],y         ;the resource header
1993 3619 C8                    iny   
1994 361A C8                    iny   
1995 361B E8                    inx   
1996 361C E8                    inx   
1997 361D E0 20 00              cpx   #32                      ;at end of second entry?
1998 3620 F0 09                 beq   @loop_done               ;yes
1999 3622 E0 10 00              cpx   #16                      ;at end of first entry?
2000 3625 D0 ED                 bne   @loop                    ;no - so loop
2001 3627 C8                    iny                            ;yes - so skip over entry size
2002 3628 C8                    iny                            ;and entry type of second entry
2003 3629 80 E9                 bra   @loop                    ;loop
2004 362B              @loop_done  
2005 362B 20 9A 17              jsr   write_with_cache         ;write out the header
2006 362E 60           @error   rts                            ;and return
2007 362F
2008 362F                       ENDP 
2009 362F              ;==========================================================================
2010 362F              ;Get_file_info: This routine will return information about a file on disk.
2011 362F              ;               If the file is open and has been modified then the EOF
2012 362F              ;               and Blocks used fields come from the FCR.  I do not
2013 362F              ;               return the current time for the modification time, since
2014 362F              ;               This would require a call to the SLOW clock routines.
2015 362F              ;
2016 362F              ;
2017 362F              ;Created:       May 23, 1987
2018 362F              ;Modified:      Aug 26, 1987
2019 362F              ;Author:        Rob Turner
2020 362F              ;
2021 362F              ;Enter:         jml
2022 362F              ;
2023 362F              ;Input:         A = undefined
2024 362F              ;               X = call number times 2
2025 362F              ;               Y = class times 2
2026 362F              ;               P = nvmxdizc
2027 362F              ;                   ..000...
2028 362F              ;               b = k
2029 362F              ;
2030 362F              ;Output:        A = error code if carry set
2031 362F              ;               X = undefined
2032 362F              ;               Y = undefined
2033 362F              ;               P = nvmxdizc
2034 362F              ;                   ..000..1 = error
2035 362F              ;                          0 = no error
2036 362F              ;               b = k
2037 362F              ;
2038 362F              ;Uses:          All registers
2039 362F              ;               find_file
2040 362F              ;
2041 362F              ;Call Format:
2042 362F              ;
2043 362F              ;Class 0        Pathname Pointer        (4 Bytes)
2044 362F              ;               Access                  (2 Bytes: Disk Format)
2045 362F              ;               File Type               (2 Bytes)
2046 362F              ;               Aux Type                (4 Bytes)
2047 362F              ;               Storage Type            (2 Bytes)
2048 362F              ;               Create Date/Time        (4 Bytes: ProDOS Format)
2049 362F              ;               Mod Date/Time           (4 Bytes: ProDOS Format)
2050 362F              ;               Blocks Used             (4 Bytes)
2051 362F              ;
2052 362F              ;Class 1        PCount                  (2 Bytes)
2053 362F              ;               Pathname Pointer        (4 Bytes)
2054 362F              ;               Access                  (2 Bytes: Disk format)
2055 362F              ;               File Type               (2 Bytes)
2056 362F              ;               Aux Type                (4 Bytes)
2057 362F              ;               Storage Type            (2 Bytes)
2058 362F              ;               Create Date/Time        (8 Bytes: Misc. Tools Format)
2059 362F              ;               Mod Date/Time           (8 Bytes: Misc. Tools Format)
2060 362F              ;               Option List Pointer     (4 Bytes)
2061 362F              ;               EOF Data Fork           (4 Bytes)
2062 362F              ;               Blocks Used Data Fork   (4 Bytes)
2063 362F              ;               EOF Resource Fork       (4 Bytes)
2064 362F              ;               Blocks Used Res. Fork   (4 Bytes)
2065 362F              ;
2066 362F              ;==========================================================================
2067 362F                       longa on
2068 362F                       longi on
2069 362F
2070 362F                       EXPORT get_file_info
2071 362F              get_file_info PROC 
2072 362F
2073 362F              ;==========================================================================
2074 362F              ;Go and setup the defaul parameters for the call.
2075 362F              ;==========================================================================
2076 362F
2077 362F 20 9E 0E              jsr   setup_params
2078 3632
2079 3632              ;==========================================================================
2080 3632              ;Process the file name and locate it.
2081 3632              ;==========================================================================
2082 3632
2083 3632 20 23 10              jsr   process_path
2084 3635
2085 3635              ;==========================================================================
2086 3635              ;Move the directory entry into one entry please
2087 3635              ;==========================================================================
2088 3635
2089 3635 20 09 3E              jsr   move_dir_entry           ;move the entry to one_entry
2090 3638 AD 41 05              lda   one_entry                ;add in the storage type
2091 363B 0D 3E 05              ora   storage_type
2092 363E 8D 41 05              sta   one_entry
2093 3641
2094 3641              ;==========================================================================
2095 3641              ;If the file is a resource file then get the extended key block.
2096 3641              ;(This code used to be below 'loop_done'.  Moved here 3/13/91 CAE)
2097 3641              ;==========================================================================
2098 3641
2099 3641 AD 3E 05              lda   storage_type
2100 3644 C9 50 00              cmp   #resource_type
2101 3647 D0 19                 bne   @cont
2102 3649
2103 3649 AD EB 02              lda   gbuf_addr
2104 364C 85 04                 sta   drvr_buf_ptr
2105 364E AD ED 02              lda   gbuf_addr+2
2106 3651 85 06                 sta   drvr_buf_ptr+2
2107 3653
2108 3653 AD 52 05              lda   one_entry+key_blk_index
2109 3656 85 10                 sta   drvr_blk_num
2110 3658 64 12                 stz   drvr_blk_num+2
2111 365A 20 95 17              jsr   read_with_cache
2112 365D 90 03                 bcc   @cont
2113 365F 82 9C 00              brl   get_exit
2114 3662              @cont     
2115 3662
2116 3662              ;==========================================================================
2117 3662              ;Now we see if the file is already open.  We do this by calling
2118 3662              ;get_next_fcr.  If this routine finds a ProDOS FCR then we see if the key
2119 3662              ;block is the same.  If it is then we get the EOF and Number of blocks
2120 3662              ;used from the FCR instead of from disk.
2121 3662              ;(Modified to handle resource files correctly 3/13/91 CAE)
2122 3662              ;==========================================================================
2123 3662
2124 3662 9C 36 05              stz   fcr_wanted               ;reset counter for Get_Next_FCR
2125 3665              look_loop  
2126 3665 20 E1 3D              jsr   get_next_fcr             ;go grab a FCR
2127 3668 B0 53                 bcs   loop_done
2128 366A
2129 366A A0 08 00              ldy   #fcr_vol_id
2130 366D B7 8C                 lda   [my_fcr_ptr],y           ;get the Volume ID so we can make sure the file is on
2131 366F C7 84                 cmp   [my_vcr_ptr]             ;the same volume.
2132 3671 D0 F2                 bne   look_loop                ;File is on another volume
2133 3673
2134 3673 A0 06 00              ldy   #fcr_file_id
2135 3676 B7 90                 lda   [pro_fcr_ptr],y
2136 3678 CD 52 05              cmp   one_entry+key_blk_index
2137 367B D0 E8                 bne   look_loop
2138 367D
2139 367D              ;Check the status bit to see if the file info is different from the info on disk.
2140 367D              ;If not, then loop.
2141 367D
2142 367D A0 1F 00              ldy   #fcr_status
2143 3680 B7 90                 lda   [pro_fcr_ptr],y
2144 3682 10 E1                 bpl   look_loop
2145 3684
2146 3684              ;Get the current EOF and current number of blocks allocated by the file.
2147 3684
2148 3684 A0 2F 00              ldy   #fcr_curr_eof
2149 3687 B7 90                 lda   [pro_fcr_ptr],y
2150 3689 8D 56 05              sta   one_entry+eof_index
2151 368C C8                    iny   
2152 368D B7 90                 lda   [pro_fcr_ptr],y
2153 368F 8D 57 05              sta   one_entry+eof_index+1
2154 3692
2155 3692 A0 0B 00              ldy   #fcr_blks_used
2156 3695 B7 90                 lda   [pro_fcr_ptr],y
2157 3697 8D 54 05              sta   one_entry+blks_used_index
2158 369A
2159 369A              ;Check to see if we're dealing with a resource file.
2160 369A              ;If so, copy the EOF and blocks_used info into the extended key block so send_info will
2161 369A              ;use it.
2162 369A
2163 369A AD 3E 05              lda   storage_type
2164 369D C9 50 00              cmp   #resource_type           ;are we dealing with a resource file?
2165 36A0 D0 1B                 bne   loop_done                ;no - so we're done
2166 36A2
2167 36A2 A7 90                 lda   [pro_fcr_ptr]            ;get resource number
2168 36A4 EB                    xba                            ;convert $0000 or $0001 into
2169 36A5 A8                    tay                            ;$0000 or $0100
2170 36A6 C8                    iny   
2171 36A7 C8                    iny   
2172 36A8 C8                    iny   
2173 36A9
2174 36A9 AD 54 05              lda   one_entry+blks_used_index
2175 36AC 97 04                 sta   [drvr_buf_ptr],y
2176 36AE C8                    iny   
2177 36AF C8                    iny   
2178 36B0 AD 56 05              lda   one_entry+eof_index
2179 36B3 97 04                 sta   [drvr_buf_ptr],y
2180 36B5 C8                    iny   
2181 36B6 AD 57 05              lda   one_entry+eof_index+1
2182 36B9 97 04                 sta   [drvr_buf_ptr],y
2183 36BB
2184 36BB 80 A8                 bra   look_loop                ;loop until done
2185 36BD              loop_done  
2186 36BD
2187 36BD              ;==========================================================================
2188 36BD              ;Check to see if we're dealing with a volume header.
2189 36BD              ;==========================================================================
2190 36BD
2191 36BD AD 3E 05              lda   storage_type
2192 36C0 C9 F0 00              cmp   #volume_header
2193 36C3 D0 1D                 bne   go_send_info
2194 36C5
2195 36C5 20 5E 37              jsr   calc_last_mod            ;we need to calculate the last mod for the volume
2196 36C8 20 4E 0C              jsr   calc_free_blks           ;A = free blocks
2197 36CB 90 03                 bcc   have_free
2198 36CD 4C 82 00              jmp   main_exit                ;sorry there is an error
2199 36D0
2200 36D0              have_free  
2201 36D0 8D 54 05              sta   one_entry+blks_used_index
2202 36D3 A0 15 00              ldy   #vol_total_blks
2203 36D6 B7 88                 lda   [prodos_vcr_ptr],y
2204 36D8 8D 60 05              sta   one_entry+aux_type_index
2205 36DB 38                    sec   
2206 36DC ED 54 05              sbc   one_entry+blks_used_index
2207 36DF 8D 54 05              sta   one_entry+blks_used_index
2208 36E2
2209 36E2              go_send_info  
2210 36E2 AD B7 05              lda   pcount
2211 36E5 F0 1A                 beq   old_style_info
2212 36E7
2213 36E7 18                    clc   
2214 36E8 A5 80                 lda   my_pblk_ptr
2215 36EA 69 04 00              adc   #$0004
2216 36ED AA                    tax   
2217 36EE A5 82                 lda   my_pblk_ptr+2
2218 36F0 69 00 00              adc   #$0000
2219 36F3 A8                    tay   
2220 36F4 AD B7 05              lda   pcount
2221 36F7 3A                    dec   a
2222 36F8 20 04 11              jsr   send_info
2223 36FB B0 01                 bcs   get_exit
2224 36FD              clean_exit  
2225 36FD 18                    clc   
2226 36FE              get_exit   
2227 36FE 4C 82 00              jmp   main_exit
2228 3701
2229 3701              old_style_info   
2230 3701
2231 3701              ;==========================================================================
2232 3701              ;Just return the old style info for class 0 calls
2233 3701              ;firts field is ACCESS
2234 3701              ;==========================================================================
2235 3701 A0 04 00              ldy   #$0004
2236 3704 AD 5F 05              lda   one_entry+access_index
2237 3707 29 E7 00              and   #$00E7
2238 370A 97 80                 sta   [my_pblk_ptr],y
2239 370C
2240 370C              ;==========================================================================
2241 370C              ;now send the FILE TYPE
2242 370C              ;==========================================================================
2243 370C C8                    iny   
2244 370D C8                    iny   
2245 370E AD 51 05              lda   one_entry+file_type_index
2246 3711 29 FF 00              and   #$00FF
2247 3714 97 80                 sta   [my_pblk_ptr],y
2248 3716
2249 3716              ;==========================================================================
2250 3716              ;go ahead and give them the AUX TYPE
2251 3716              ;==========================================================================
2252 3716 C8                    iny   
2253 3717 C8                    iny   
2254 3718 AD 60 05              lda   one_entry+aux_type_index
2255 371B 97 80                 sta   [my_pblk_ptr],y
2256 371D C8                    iny   
2257 371E C8                    iny   
2258 371F A9 00 00              lda   #$0000
2259 3722 97 80                 sta   [my_pblk_ptr],y
2260 3724
2261 3724              ;==========================================================================
2262 3724              ;through in the storage type for good measure
2263 3724              ;==========================================================================
2264 3724 C8                    iny   
2265 3725 C8                    iny   
2266 3726 AD 41 05              lda   one_entry
2267 3729 29 F0 00              and   #$00F0
2268 372C 4A                    lsr   a
2269 372D 4A                    lsr   a
2270 372E 4A                    lsr   a
2271 372F 4A                    lsr   a
2272 3730 97 80                 sta   [my_pblk_ptr],y
2273 3732
2274 3732              ;==========================================================================
2275 3732              ;how about the CREATE DATE and TIME
2276 3732              ;==========================================================================
2277 3732 C8                    iny   
2278 3733 C8                    iny   
2279 3734 AD 59 05              lda   one_entry+create_index
2280 3737 97 80                 sta   [my_pblk_ptr],y
2281 3739 C8                    iny   
2282 373A C8                    iny   
2283 373B AD 5B 05              lda   one_entry+create_index+2
2284 373E 97 80                 sta   [my_pblk_ptr],y
2285 3740
2286 3740              ;==========================================================================
2287 3740              ;Send the last MODIFICATION DATE and TIME
2288 3740              ;==========================================================================
2289 3740 C8                    iny   
2290 3741 C8                    iny   
2291 3742 AD 62 05              lda   one_entry+last_mod_index
2292 3745 97 80                 sta   [my_pblk_ptr],y
2293 3747 C8                    iny   
2294 3748 C8                    iny   
2295 3749 AD 64 05              lda   one_entry+last_mod_index+2
2296 374C 97 80                 sta   [my_pblk_ptr],y
2297 374E
2298 374E              ;==========================================================================
2299 374E              ;and lastly, the number of blocks used.
2300 374E              ;==========================================================================
2301 374E C8                    iny   
2302 374F C8                    iny   
2303 3750 AD 54 05              lda   one_entry+blks_used_index
2304 3753 97 80                 sta   [my_pblk_ptr],y
2305 3755 C8                    iny   
2306 3756 C8                    iny   
2307 3757 A9 00 00              lda   #$0000
2308 375A 97 80                 sta   [my_pblk_ptr],y
2309 375C 80 9F                 bra   clean_exit
2310 375E
2311 375E              ;==========================================================================
2312 375E              ;Calculate the modification date for the volume.  We do this since the mod
2313 375E              ;date is not stored on the disk.  This should not be bad since the blocks
2314 375E              ;are stored in the cache.
2315 375E              ;
2316 375E              ;Enter:         jsr
2317 375E              ;
2318 375E              ;Input:         A = undefined
2319 375E              ;               X = undefined
2320 375E              ;               Y = undefined
2321 375E              ;               P = nvmxdizc
2322 375E              ;                   ..000...
2323 375E              ;               b = k
2324 375E              ;
2325 375E              ;Output:        A = undefined
2326 375E              ;               X = undefined
2327 375E              ;               Y = undefined
2328 375E              ;               P = nvmxdizc
2329 375E              ;                   ..000..1= error
2330 375E              ;               b = k
2331 375E              ;
2332 375E              ;               one_entry+last_mod_index        ;is setup with the date
2333 375E              ;
2334 375E              ;==========================================================================
2335 375E              ;	Export	calc_mod_date
2336 375E              calc_last_mod                 
2337 375E A5 00                 lda   drvr_dev_num             ;pass in the device number
2338 3760 A2 BB 01              ldx   #dummy_name              ; and a pointer to the name
2339 3763 A0 02 00              ldy   #^dummy_name
2340 3766 20 7C 1F              jsr   find_file                ;this will fail but we do not care
2341 3769
2342 3769 AD 0B 03              lda   curr_mod_date
2343 376C AA                    tax   
2344 376D 0D 0D 03              ora   curr_mod_date+2
2345 3770 F0 0A                 beq   @same_time               ;there are no files on the disk!
2346 3772
2347 3772 8E 62 05              stx   one_entry+last_mod_index
2348 3775 AD 0D 03              lda   curr_mod_date+2
2349 3778 8D 64 05              sta   one_entry+last_mod_index+2
2350 377B 60                    rts   
2351 377C              @same_time  
2352 377C AD 59 05              lda   one_entry+create_index
2353 377F 8D 62 05              sta   one_entry+last_mod_index
2354 3782 AD 5B 05              lda   one_entry+create_index+2
2355 3785 8D 64 05              sta   one_entry+last_mod_index+2
2356 3788 60                    rts   
2357 3789
2358 3789                       ENDP 
2359 3789
2360 3789              ;==========================================================================
2361 3789              ;Judge_name:    Returns information about ProDOS filename syntax.
2362 3789              ;               Modifies name (if supplied) to conform to ProDOS syntax.
2363 3789              ;
2364 3789              ;Note:          This is a class 1 call only.
2365 3789              ;
2366 3789              ;Created:       Jan 22, 1991
2367 3789              ;Author:        Cheryl Ewy
2368 3789              ;
2369 3789              ;Enter:         jml
2370 3789              ;
2371 3789              ;Input:         A = undefined
2372 3789              ;               X = call number times 2
2373 3789              ;               Y = class times 2
2374 3789              ;               P = nvmxdizc
2375 3789              ;                   ..000...
2376 3789              ;               b = k
2377 3789              ;
2378 3789              ;Output:        A = error code if carry set
2379 3789              ;               X = undefined
2380 3789              ;               Y = undefined
2381 3789              ;               P = nvmxdizc
2382 3789              ;                   ..000..1 = error
2383 3789              ;                          0 = no error
2384 3789              ;               b = k
2385 3789              ;
2386 3789              ;Uses:          All registers
2387 3789              ;               <temp_ptr
2388 3789              ;               <temp2_ptr
2389 3789              ;               <temp3_ptr
2390 3789              ;
2391 3789              ;Call Format:
2392 3789              ;
2393 3789              ;Class 1        PCount                  (2 Bytes)
2394 3789              ;               File System ID          (2 Bytes)
2395 3789              ;               Name Type               (2 Bytes)
2396 3789              ;               Syntax                  (4 Bytes)
2397 3789              ;               Max Len                 (2 Bytes)
2398 3789              ;               Name                    (4 Bytes)
2399 3789              ;               Name Flags              (2 Bytes)
2400 3789              ;
2401 3789              ;==========================================================================
2402 3789                       longa on
2403 3789                       longi on
2404 3789
2405 3789                       EXPORT judge_name
2406 3789              judge_name PROC 
2407 3789
2408 3789
2409 3789              name_flags equ   temp2_ptr              ;local equates
2410 3789              buf_size equ   temp2_ptr+2
2411 3789              temp_val equ   temp3_ptr
2412 3789              nul_flag equ   temp3_ptr+2
2413 3789
2414 3789              max_len  equ   15                       ;maximum name length
2415 3789
2416 3789              ; Setup the default parameters for the call.
2417 3789
2418 3789 20 9E 0E              jsr   setup_params
2419 378C
2420 378C              ; Init flags word to 0.
2421 378C
2422 378C 64 9C                 stz   <name_flags
2423 378E
2424 378E              ; Make sure the name_type input parameter is valid.
2425 378E
2426 378E A0 02 00              ldy   #pblk_07_ntype
2427 3791 B7 80                 lda   [my_pblk_ptr],y          ;get name_type input param
2428 3793 C9 04 00              cmp   #4                       ;is it < 4?
2429 3796 B0 69                 bcs   bad_param                ;no - so report error
2430 3798
2431 3798              ; Minimum pcount is 3 so we'll always return a ptr to the syntax string.
2432 3798
2433 3798 A9 EB 01              lda   #syntax_str              ;get lo word of ptr to string
2434 379B A0 04 00              ldy   #pblk_07_syntax
2435 379E 97 80                 sta   [my_pblk_ptr],y          ;store it in output param
2436 37A0 C8                    iny   
2437 37A1 C8                    iny   
2438 37A2 A9 02 00              lda   #^syntax_str             ;get hi word of ptr to string
2439 37A5 97 80                 sta   [my_pblk_ptr],y          ;store it in output param
2440 37A7
2441 37A7              ; Adjust the pcount to reflect the number of remaining parameters to deal with.
2442 37A7
2443 37A7 CE B7 05              dec   pcount                   ;done with file_sys_id param
2444 37AA CE B7 05              dec   pcount                   ;done with name_type param
2445 37AD CE B7 05              dec   pcount                   ;done with syntax param
2446 37B0
2447 37B0              ; Return the maximum name length if requested.
2448 37B0
2449 37B0 CE B7 05              dec   pcount
2450 37B3 30 48                 bmi   done
2451 37B5
2452 37B5 A9 0F 00              lda   #max_len                 ;get maximum name length
2453 37B8 A0 08 00              ldy   #pblk_07_max_len
2454 37BB 97 80                 sta   [my_pblk_ptr],y          ;store it in the max_len output param
2455 37BD
2456 37BD              ; Get the ptr to the name buffer if supplied.  The name buffer is a class 1 output buffer. 
2457 37BD              ; If the ptr is 0 then there's no name to judge.
2458 37BD
2459 37BD CE B7 05              dec   pcount
2460 37C0 30 3B                 bmi   done
2461 37C2
2462 37C2 A0 0A 00              ldy   #pblk_07_name
2463 37C5 B7 80                 lda   [my_pblk_ptr],y          ;get lo word of ptr to name buffer
2464 37C7 85 98                 sta   <temp_ptr                ;and store
2465 37C9 C8                    iny   
2466 37CA C8                    iny   
2467 37CB B7 80                 lda   [my_pblk_ptr],y          ;get hi word of ptr to name buffer
2468 37CD 29 FF 00              and   #$00ff                   ;mask off hi byte
2469 37D0 85 9A                 sta   <temp_ptr+2              ;and store
2470 37D2 05 98                 ora   <temp_ptr                ;is the ptr 0?
2471 37D4 F0 1B                 beq   do_flags                 ;yes - so there's no name to judge
2472 37D6
2473 37D6              ; Check the name buffer size to make sure the buffer is large enough to contain
2474 37D6              ; the maximum size name.  If not, return an error.
2475 37D6
2476 37D6 A7 98                 lda   [temp_ptr]               ;get buffer size
2477 37D8 C9 13 00              cmp   #max_len+4               ;is the buffer big enough?
2478 37DB 90 2B                 bcc   buf_err                  ;no - so return an error
2479 37DD 85 9E                 sta   <buf_size                ;yes - so save buffer size
2480 37DF
2481 37DF              ; Adjust <temp_ptr so that it points to the length word of the name string instead of
2482 37DF              ; to the buffer size word.  
2483 37DF
2484 37DF 18                    clc   
2485 37E0 A5 98                 lda   <temp_ptr                ;adjust ptr to point to the name length
2486 37E2 69 02 00              adc   #2
2487 37E5 85 98                 sta   <temp_ptr
2488 37E7 A5 9A                 lda   <temp_ptr+2
2489 37E9 69 00 00              adc   #0
2490 37EC 85 9A                 sta   <temp_ptr+2
2491 37EE
2492 37EE              ; Judge the name.
2493 37EE
2494 37EE 20 0F 38              jsr   judge_it
2495 37F1
2496 37F1              ; Return the name_flags parameter if requested.
2497 37F1
2498 37F1 CE B7 05     do_flags dec   pcount
2499 37F4 30 07                 bmi   done
2500 37F6
2501 37F6 A5 9C                 lda   <name_flags              ;get name_flags
2502 37F8 A0 0E 00              ldy   #pblk_07_nflags
2503 37FB 97 80                 sta   [my_pblk_ptr],y          ;store it in the output param
2504 37FD
2505 37FD              ; Indicate no error and return.
2506 37FD
2507 37FD 18           done     clc   
2508 37FE 4C 82 00              jmp   main_exit
2509 3801
2510 3801
2511 3801              ; Return a parameter range error.
2512 3801
2513 3801 A9 53 00     bad_param lda   #parm_range_err
2514 3804 38                    sec   
2515 3805 4C 82 00              jmp   main_exit
2516 3808
2517 3808
2518 3808              ; Return a buffer too small error.
2519 3808
2520 3808 A9 4F 00     buf_err  lda   #buff_too_small
2521 380B 38                    sec   
2522 380C 4C 82 00              jmp   main_exit
2523 380F
2524 380F              ;--------------------------------------------------------------------------
2525 380F
2526 380F              judge_it  
2527 380F
2528 380F              ; If the name length = 0 then set the name string to "A", indicate that there
2529 380F              ; was a syntax error, then return.
2530 380F                        
2531 380F A7 98                 lda   [temp_ptr]               ;is the name length = 0?
2532 3811 D0 13                 bne   @got_name                ;no - so we have a name
2533 3813 A9 01 00     @nameIsNull lda   #1
2534 3816 87 98                 sta   [temp_ptr]               ;set name length to 1
2535 3818 A0 02 00              ldy   #2
2536 381B A9 41 00              lda   #'A'
2537 381E 97 98                 sta   [temp_ptr],y             ;set name string to "A"
2538 3820 A9 00 20              lda   #$2000                   ;set bit 13 of name_flags to indicate
2539 3823 04 9C                 tsb   <name_flags              ;that there was a syntax error
2540 3825 60                    rts                            ;and return
2541 3826              @got_name  
2542 3826
2543 3826              ; We have a name to judge.
2544 3826
2545 3826              *** added 14-Apr-91 DAL -- call StringToText in the Misc Tools
2546 3826              if CallStringToText=1 then  
2547 3826 48                    pha                            ;space for StringToText result flags
2548 3827 48                    pha                            ;space for StringToText result length
2549 3828 F4 00 60              pea   $6000                    ;flags: force "English", allow expansion
2550 382B A6 9A                 ldx   temp_ptr+2               ;push [temp_ptr]+2 -- input text
2551 382D A5 98                 lda   temp_ptr
2552 382F 18                    clc   
2553 3830 69 02 00              adc   #2
2554 3833 90 01                 bcc   @ok
2555 3835 E8                    inx   
2556 3836 DA           @ok      phx   
2557 3837 48                    pha   
2558 3838 A7 98                 lda   [temp_ptr]
2559 383A 48                    pha                            ;push input string length
2560 383B A6 9A                 ldx   temp_ptr+2               ;push [temp_ptr]-2 -- result buffer
2561 383D A5 98                 lda   temp_ptr
2562 383F 38                    sec   
2563 3840 E9 02 00              sbc   #2
2564 3843 B0 01                 bcs   @ok2
2565 3845 CA                    dex   
2566 3846 DA           @ok2     phx   
2567 3847 48                    pha   
2568 3848 A2 03 3B              ldx   #$3b03
2569 384B 22 00 00 E1           jsl   $e10000
2570 384F              ;	_StringToText
2571 384F 68                    pla                            ;printable length (ignore)
2572 3850 68                    pla                            ;result flags
2573 3851 10 05                 bpl   @noChange
2574 3853 A9 00 80              lda   #$8000                   ;set bit 15 = illegal characters
2575 3856 04 9C                 tsb   <name_flags
2576 3858              @noChange  
2577 3858              endif     
2578 3858              *** end of 14-Apr-91 DAL
2579 3858
2580 3858              ; Set bit 14 of name_flags if the name is too long.
2581 3858              ; Note - we have to do this now because the name length may change. 
2582 3858
2583 3858 A7 98                 lda   [temp_ptr]               ;get name length
2584 385A              *** added 29-Apr-91 DAL
2585 385A F0 B7                 beq   @nameIsNull
2586 385C              *** end of 29-Apr-91 DAL
2587 385C C9 10 00              cmp   #max_len+1               ;is it too long?
2588 385F 90 05                 bcc   @len_ok                  ;no
2589 3861 A9 00 40              lda   #$4000                   ;yes - so set bit 14 of name_flags 
2590 3864 04 9C                 tsb   <name_flags              ;to indicate name was too long
2591 3866              @len_ok   
2592 3866
2593 3866              ; Convert all illegal characters to NULs. They'll be converted to periods later.
2594 3866                        
2595 3866 A7 98                 lda   [temp_ptr]               ;get length of pathname
2596 3868 1A                    inc   a                        ;adjust for extra length byte
2597 3869 A8                    tay   
2598 386A
2599 386A A2 00 00              ldx   #0                       ;init to 0
2600 386D
2601 386D                       longa off                      ;set 8 bit A
2602 386D E2 20                 sep   #$20
2603 386F
2604 386F B7 98        loop1    lda   [temp_ptr],y             ;get byte
2605 3871
2606 3871 C9 61                 cmp   #'a'
2607 3873 90 06                 bcc   @check_upper
2608 3875 C9 7B                 cmp   #'z'+1
2609 3877 B0 1A                 bcs   @bad_char
2610 3879 80 1F                 bra   @ok                      ;it's a lower-case letter
2611 387B
2612 387B C9 41        @check_upper cmp   #'A'
2613 387D 90 06                 bcc   @check_num
2614 387F C9 5B                 cmp   #'Z'+1
2615 3881 B0 10                 bcs   @bad_char
2616 3883 80 15                 bra   @ok                      ;it's an upper-case letter
2617 3885
2618 3885 C9 30        @check_num cmp   #'0'
2619 3887 90 06                 bcc   @check_period
2620 3889 C9 3A                 cmp   #'9'+1
2621 388B B0 06                 bcs   @bad_char
2622 388D 80 0B                 bra   @ok                      ;it's a number
2623 388F
2624 388F C9 2E        @check_period cmp   #'.'
2625 3891 F0 07                 beq   @ok                      ;it's a period
2626 3893
2627 3893              if AllowLCPeriods then                  ;added 7-Aug-91 DAL
2628 3893                       cmp   #' '                     ;it's a blank
2629 3893                       beq   @ok
2630 3893              endif                                   ;end 7-Aug-91 DAL
2631 3893
2632 3893 A9 00        @bad_char lda   #$00                    ;it's an illegal character so
2633 3895 97 98                 sta   [temp_ptr],y             ;replace char with a NUL
2634 3897 A2 00 80              ldx   #$8000                   ;indicate illegal character found
2635 389A 88           @ok      dey                            ;decrement offset
2636 389B C0 01 00              cpy   #1
2637 389E D0 CF                 bne   loop1                    ;loop until done
2638 38A0
2639 38A0                       longa on                       ;set 16 bit A
2640 38A0 C2 20                 rep   #$20
2641 38A2
2642 38A2 8A                    txa                            ;set bit 15 if an illegal
2643 38A3 04 9C                 tsb   <name_flags              ;character was found
2644 38A5
2645 38A5              ; If the name doesn't begin with a letter, then indicate that there was a syntax error.
2646 38A5              ; Note - we have to check this now because if the first character is illegal, it will 
2647 38A5              ;        be removed by the next section of code. 
2648 38A5
2649 38A5 A0 02 00              ldy   #2
2650 38A8 B7 98                 lda   [temp_ptr],y             ;get first 2 chars
2651 38AA 29 FF 00              and   #$00ff                   ;only want first char
2652 38AD C9 41 00              cmp   #'A'                     ;is it a letter?
2653 38B0 B0 05                 bcs   @syntax_ok               ;yes - so we're ok
2654 38B2 A9 00 20              lda   #$2000                   ;set bit 13 to indicate that
2655 38B5 04 9C                 tsb   <name_flags              ;there was a syntax error
2656 38B7              @syntax_ok  
2657 38B7
2658 38B7              ; Replace runs of 2 or more NULs with a single period.
2659 38B7              ; All leading and trailing NULs will be removed.
2660 38B7              ; Note - if no illegal characters were found, then skip this section. 
2661 38B7
2662 38B7 A5 9C                 lda   <name_flags              ;were there any illegal characters?
2663 38B9 10 3F                 bpl   skip_it                  ;no - so skip this section
2664 38BB
2665 38BB A7 98                 lda   [temp_ptr]               ;get name length
2666 38BD 1A                    inc   a                        ;add 2 to account for the length bytes
2667 38BE 1A                    inc   a
2668 38BF 85 A0                 sta   <temp_val                ;and save
2669 38C1
2670 38C1                       longa off
2671 38C1 E2 20                 sep   #$20                     ;set 8 bit A
2672 38C3
2673 38C3 A2 02 00              ldx   #2                       ;init offsets
2674 38C6 DA                    phx   
2675 38C7 86 A2                 stx   <nul_flag                ;init flag to indicate we've seen a NUL
2676 38C9
2677 38C9 7A           loop2    ply                            ;get offset
2678 38CA C4 A0                 cpy   <temp_val                ;are we done?
2679 38CC B0 1B                 bcs   loop2_done               ;yes
2680 38CE B7 98                 lda   [temp_ptr],y             ;no - so read next character
2681 38D0 C8                    iny                            ;adjust offset 
2682 38D1 5A                    phy                            ;and save
2683 38D2 C9 00                 cmp   #$00                     ;is the char a NUL?
2684 38D4 D0 0A                 bne   @not_nul                 ;no - so branch
2685 38D6 A4 A2                 ldy   <nul_flag                ;was the last character a NUL?
2686 38D8 D0 EF                 bne   loop2                    ;yes - so loop
2687 38DA E6 A2                 inc   <nul_flag                ;no - so indicate we've seen a NUL
2688 38DC A9 2E                 lda   #'.'                     ;convert the NUL into a period
2689 38DE 80 02                 bra   @store_char              ;and store the period
2690 38E0
2691 38E0 64 A2        @not_nul stz   <nul_flag                ;indicate we've seen a non-NUL
2692 38E2 9B           @store_char txy   
2693 38E3 97 98                 sta   [temp_ptr],y             ;store the character
2694 38E5 BB                    tyx   
2695 38E6 E8                    inx                            ;adjust offset
2696 38E7 80 E0                 bra   loop2                    ;and loop
2697 38E9
2698 38E9 A5 A2        loop2_done lda   <nul_flag              ;was the last char read a NUL?
2699 38EB F0 06                 beq   @ok                      ;no
2700 38ED E0 02 00              cpx   #2                       ;yes - was it stored?
2701 38F0 F0 01                 beq   @ok                      ;no 
2702 38F2 CA                    dex                            ;yes - so don't count it
2703 38F3              @ok       
2704 38F3                       longa on
2705 38F3 C2 20                 rep   #$20                     ;set 16 bit A
2706 38F5
2707 38F5 8A                    txa                            ;determine new name length
2708 38F6 3A                    dec   a
2709 38F7 3A                    dec   a
2710 38F8 87 98                 sta   [temp_ptr]               ;and store
2711 38FA              skip_it   
2712 38FA
2713 38FA              ; If the name doesn't begin with a letter, insert an 'A' as the first character.
2714 38FA              ; If the buffer has no extra space, then lose the last character.
2715 38FA              ; Note - we need to check for a zero-length name in case all chars were illegal.
2716 38FA
2717 38FA A7 98                 lda   [temp_ptr]               ;get name length
2718 38FC D0 05                 bne   @not_zero                ;branch if it's > 0
2719 38FE 1A                    inc   a                        ;name length is 0 so
2720 38FF 87 98                 sta   [temp_ptr]               ;set length to 1
2721 3901 80 27                 bra   stuff_a                  ;and insert the 'A'
2722 3903              @not_zero  
2723 3903 A0 02 00              ldy   #2
2724 3906 B7 98                 lda   [temp_ptr],y             ;get first 2 chars
2725 3908 29 FF 00              and   #$00ff                   ;only want first char
2726 390B C9 41 00              cmp   #'A'                     ;is it a letter?
2727 390E B0 25                 bcs   char1_ok                 ;yes - so we're ok
2728 3910
2729 3910 A7 98                 lda   [temp_ptr]               ;get name length
2730 3912 A8                    tay                            ;and save
2731 3913 18                    clc   
2732 3914 69 04 00              adc   #4
2733 3917 C5 9E                 cmp   <buf_size                ;does the buffer have any unused space?
2734 3919 B0 04                 bcs   @lose_last               ;no - so lose last char
2735 391B C8                    iny                            ;yes - so save last char
2736 391C 98                    tya   
2737 391D 87 98                 sta   [temp_ptr]               ;add 1 to name length
2738 391F              @lose_last  
2739 391F B7 98        loop3    lda   [temp_ptr],y             ;move all chars over by 1
2740 3921 EB                    xba   
2741 3922 97 98                 sta   [temp_ptr],y
2742 3924 88                    dey   
2743 3925 C0 01 00              cpy   #1
2744 3928 D0 F5                 bne   loop3
2745 392A
2746 392A                       longa off
2747 392A E2 20        stuff_a  sep   #$20                     ;set 8 bit A
2748 392C
2749 392C A0 02 00              ldy   #2
2750 392F A9 41                 lda   #'A'
2751 3931 97 98                 sta   [temp_ptr],y             ;stuff an 'A' in as first char
2752 3933
2753 3933                       longa on
2754 3933 C2 20                 rep   #$20                     ;set 16 bit A
2755 3935              char1_ok  
2756 3935
2757 3935              ; If the name is too long then keep the first 7 chars, insert '..', keep the last 6 chars.
2758 3935                        
2759 3935 A7 98                 lda   [temp_ptr]               ;get name length
2760 3937 C9 10 00              cmp   #max_len+1               ;is it too long?
2761 393A 90 2A                 bcc   length_ok                ;no
2762 393C                        
2763 393C A0 09 00              ldy   #9                       ;get offset to 8th char
2764 393F A9 2E 2E              lda   #'..'
2765 3942 97 98                 sta   [temp_ptr],y             ;insert the '..'
2766 3944
2767 3944 A7 98                 lda   [temp_ptr]               ;get length of name
2768 3946 38                    sec   
2769 3947 E9 04 00              sbc   #4                       ;subtract 4 to get offset
2770 394A 48                    pha                            ;to last part of name to keep
2771 394B
2772 394B                       longa off                      ;set 8 bit A
2773 394B E2 20                 sep   #$20
2774 394D
2775 394D A2 0B 00              ldx   #11                      ;set offset after the '..' (10th char)
2776 3950 7A           loop4    ply   
2777 3951 B7 98                 lda   [temp_ptr],y             ;move the last 6 characters
2778 3953 C8                    iny                            ;so they are after the '..'
2779 3954 5A                    phy   
2780 3955 9B                    txy   
2781 3956 97 98                 sta   [temp_ptr],y
2782 3958 E8                    inx   
2783 3959 E0 11 00              cpx   #17                      ;are we done?
2784 395C D0 F2                 bne   loop4                    ;no - so loop
2785 395E 7A                    ply                            ;clean up stack
2786 395F
2787 395F                       longa on                       ;set 16 bit A
2788 395F C2 20                 rep   #$20
2789 3961
2790 3961 A9 0F 00              lda   #max_len                 ;adjust the name length
2791 3964 87 98                 sta   [temp_ptr]
2792 3966              length_ok  
2793 3966
2794 3966              ; Done with name.
2795 3966
2796 3966 60                    rts   
2797 3967
2798 3967                       ENDP 
2799 3967
2800 3967              ;==========================================================================
2801 3967              ;Volume:        This routine will return the volume information on a disk
2802 3967              ;
2803 3967              ;Note:          This routine will now store the volume name in the user's
2804 3967              ;               buffer if a "duplicate volume" error is being returned.
2805 3967              ;               1/22/91 CAE
2806 3967              ;
2807 3967              ;Created:       may 24, 1987
2808 3967              ;Modified:      may 24, 1987
2809 3967              ;Author:        Rob Turner
2810 3967              ;
2811 3967              ;Enter:         jml
2812 3967              ;
2813 3967              ;Input:         A = undefined
2814 3967              ;               X = call number times 2
2815 3967              ;               Y = class times 2
2816 3967              ;               P = nvmxdizc
2817 3967              ;                   ..000...
2818 3967              ;               b = k
2819 3967              ;
2820 3967              ;Output:        A = error code if carry set
2821 3967              ;               X = undefined
2822 3967              ;               Y = undefined
2823 3967              ;               P = nvmxdizc
2824 3967              ;                   ..000..1 = error
2825 3967              ;                          0 = no error
2826 3967              ;               b = k
2827 3967              ;
2828 3967              ;Uses:          All registers
2829 3967              ;               fill_io_buf
2830 3967              ;
2831 3967              ;Call Format:
2832 3967              ;
2833 3967              ;Class 0        Device Name Pointer     (4 Bytes)
2834 3967              ;               Volume Name Pointer     (4 Bytes)
2835 3967              ;               Total Blocks            (4 Bytes)
2836 3967              ;               Free Blocks             (4 Bytes)
2837 3967              ;               File System ID          (2 Bytes)
2838 3967              ;
2839 3967              ;Class 1        PCount                  (2 Bytes)
2840 3967              ;               Device Name Pointer     (4 Bytes)
2841 3967              ;               Volume Name Pointer     (4 Bytes)
2842 3967              ;               Total Blocks            (4 Bytes)
2843 3967              ;               Free Blocks             (4 Bytes)
2844 3967              ;               File System ID          (2 Bytes)
2845 3967              ;               Block Size              (2 Bytes)
2846 3967              ;
2847 3967              ;==========================================================================
2848 3967                       longa on
2849 3967                       longi on
2850 3967
2851 3967                       EXPORT volume
2852 3967              volume   PROC 
2853 3967
2854 3967              ;==========================================================================
2855 3967              ;Call setup routine.  This routine will verify input parameters like
2856 3967              ;                     call class, max pcount and span.  It will also setup
2857 3967              ;                     any pointers that are used.
2858 3967              ;
2859 3967              ;The routine loads the class of the call as the last instruction before RTS
2860 3967              ;==========================================================================
2861 3967
2862 3967 20 9E 0E              jsr   setup_params
2863 396A
2864 396A              ;==========================================================================
2865 396A              ;Now lets go and and ID that puppy.  The device number to ID is on ZP
2866 396A              ;==========================================================================
2867 396A
2868 396A A9 02 80              lda   #in_cache                ;force block two into the cache
2869 396D 85 1A                 sta   drvr_cache
2870 396F
2871 396F 9C 8A 39              stz   dup_vol_flag             ;init flag word to 0
2872 3972 A5 36                 lda   dev_num
2873 3974 20 D9 1C              jsr   id_disk                  ;go see if it belongs to me
2874 3977 20 FC 10              jsr   set_user_cache           ;set cache back to default
2875 397A 90 10                 bcc   its_my_puppy
2876 397C C9 57 00              cmp   #dup_volume              ;got an error - is it 'duplicate volume'?
2877 397F 38                    sec                            ;make sure carry is still set
2878 3980 D0 05                 bne   vol_exit                 ;no - so exit with error
2879 3982 8D 8A 39              sta   dup_vol_flag             ;yes - so store error code in flag word
2880 3985 80 05                 bra   its_my_puppy             ;and continue
2881 3987
2882 3987 4C 82 00     vol_exit jmp   main_exit
2883 398A
2884 398A 00 00        dup_vol_flag DS B:2                     ;non-zero if we've got a duplicate volume
2885 398C
2886 398C
2887 398C              ;==========================================================================
2888 398C              ;move the name into the user's buffer.
2889 398C              ;==========================================================================
2890 398C
2891 398C              its_my_puppy  
2892 398C A0 04 00              ldy   #pblk_08_vol
2893 398F
2894 398F B7 80                 lda   [my_pblk_ptr],y
2895 3991 85 98                 sta   temp_ptr
2896 3993 AA                    tax   
2897 3994 C8                    iny   
2898 3995 C8                    iny   
2899 3996 B7 80                 lda   [my_pblk_ptr],y
2900 3998 85 9A                 sta   temp_ptr+2
2901 399A
2902 399A 9C 0F 03              stz   case_bits                ;all upper case please
2903 399D
2904 399D AD 0E 00              lda   fst_attr                 ;if the high bit is set skip Upper/Lower stuff
2905 39A0 30 0B                 bmi   @no_case_change
2906 39A2
2907 39A2 A0 16 00              ldy   #create_index-2          ;save the case bits please
2908 39A5 B7 04                 lda   [drvr_buf_ptr],y
2909 39A7 10 04                 bpl   @no_case_change
2910 39A9 0A                    asl   a                        ;remove the case ON/OFF bit
2911 39AA 8D 0F 03              sta   case_bits
2912 39AD              @no_case_change  
2913 39AD
2914 39AD AD B7 05              lda   pcount
2915 39B0 D0 42                 bne   class1
2916 39B2
2917 39B2              ;==========================================================================
2918 39B2              ;before we send the name we have to add in the damn leading slash.
2919 39B2              ;==========================================================================
2920 39B2
2921 39B2 A7 04                 lda   [drvr_buf_ptr]
2922 39B4 29 0F 00              and   #$000F
2923 39B7 85 AC                 sta   math_temp                ;save the length of the name
2924 39B9 1A                    inc   a
2925 39BA 87 98                 sta   [temp_ptr]               ;length of the name
2926 39BC E6 98                 inc   temp_ptr
2927 39BE D0 02                 bne   class0_name
2928 39C0 E6 9A                 inc   temp_ptr+2
2929 39C2
2930 39C2              class0_name  
2931 39C2 A0 01 00              ldy   #$0001                   ;start at the beginning
2932 39C5                       longa off
2933 39C5 E2 20                 sep   #$20                     ;8 bit moves please
2934 39C7 A9 2F                 lda   #'/'
2935 39C9 87 98                 sta   [temp_ptr]               ;store the leading slash
2936 39CB              class0_loop                             ;
2937 39CB B7 04                 lda   [drvr_buf_ptr],y
2938 39CD C2 20                 rep   #$20
2939 39CF 2E 0F 03              rol   case_bits                ;see if this char is lower case
2940 39D2 E2 20                 sep   #$20
2941 39D4 90 02                 bcc   @its_upper
2942 39D6
2943 39D6              if AllowLCPeriods then                  ;added 7-Aug-91 DAL
2944 39D6                       cmp   #'.'
2945 39D6                       bne   @not_lc_period
2946 39D6                       lda   #0                       ;let it ORA our 0 into a $20 (blank!)
2947 39D6              @not_lc_period  
2948 39D6              endif                                   ;end 7-Aug-91 DAL
2949 39D6
2950 39D6 09 20                 ora   #$20                     ;set the lower case bit please
2951 39D8              @its_upper  
2952 39D8 97 98                 sta   [temp_ptr],y
2953 39DA C4 AC                 cpy   math_temp
2954 39DC F0 03                 beq   @were_done
2955 39DE C8                    iny   
2956 39DF 80 EA                 bra   class0_loop
2957 39E1              @were_done  
2958 39E1                       longa on
2959 39E1 C2 20                 rep   #$20
2960 39E3
2961 39E3              ;If dup_vol_flag is non-zero then we don't want to send the rest of the output
2962 39E3              ;parameters so just exit with the "duplicate volume" error.
2963 39E3
2964 39E3 AD 8A 39              lda   dup_vol_flag             ;check the flag
2965 39E6 F0 04                 beq   @no_error                ;it's 0 so continue
2966 39E8 38                    sec                            ;we've got a duplicate volume so set carry
2967 39E9 82 9B FF              brl   vol_exit                 ;and exit with the error
2968 39EC              @no_error  
2969 39EC
2970 39EC              ;==========================================================================
2971 39EC              ;Since this is a class zero call lets set the pcount to three so all the
2972 39EC              ;parameters will be returned to the caller.
2973 39EC              ;==========================================================================
2974 39EC
2975 39EC A9 03 00              lda   #$0003                   ;setup pcount
2976 39EF 8D B7 05              sta   pcount
2977 39F2 80 70                 bra   do_bitmap
2978 39F4
2979 39F4              class1    
2980 39F4
2981 39F4              ;==========================================================================
2982 39F4              ;If we get here we need to verify that the buffer is large enought to hold
2983 39F4              ;the volume name.
2984 39F4              ;
2985 39F4              ;diagram
2986 39F4              ;                ______________
2987 39F4              ;               | Buffer size  | W
2988 39F4              ;               |--------------|
2989 39F4              ;               | Name Length  | W
2990 39F4              ;               |--------------|
2991 39F4              ;               | Leading '/'  | B
2992 39F4              ;               |--------------|
2993 39F4              ;               |     THE      |
2994 39F4              ;               |   REST OF    | 'n'
2995 39F4              ;               |  THE  NAME   |
2996 39F4              ;               |______________|
2997 39F4              ;
2998 39F4              ;==========================================================================
2999 39F4
3000 39F4 A7 04                 lda   [drvr_buf_ptr]
3001 39F6 29 0F 00              and   #$000F
3002 39F9 AA                    tax   
3003 39FA 1A                    inc   a
3004 39FB 85 AC                 sta   math_temp                ;save the size of the name + slash.
3005 39FD
3006 39FD 38                    sec   
3007 39FE A7 98                 lda   [temp_ptr]
3008 3A00 E9 04 00              sbc   #$0004                   ;minus overhead
3009 3A03 30 0D                 bmi   too_small                ;get out of here!
3010 3A05 C5 AC                 cmp   math_temp
3011 3A07 F0 10                 beq   size_ok
3012 3A09 B0 0E                 bcs   size_ok
3013 3A0B
3014 3A0B A0 02 00              ldy   #$0002
3015 3A0E A5 AC                 lda   math_temp
3016 3A10 97 98                 sta   [temp_ptr],y             ;store the length of the name
3017 3A12
3018 3A12              too_small                               ;
3019 3A12 38                    sec   
3020 3A13 A9 4F 00              lda   #buff_too_small          ;return the error
3021 3A16 82 6E FF     back_to_exit brl   vol_exit
3022 3A19
3023 3A19              size_ok                                 ;
3024 3A19
3025 3A19              ;==========================================================================
3026 3A19              ;now move the name to the user's buffer.
3027 3A19              ;==========================================================================
3028 3A19
3029 3A19 A0 02 00              ldy   #$0002                   ;index to the length result
3030 3A1C A5 AC                 lda   math_temp
3031 3A1E 97 98                 sta   [temp_ptr],y
3032 3A20 C8                    iny   
3033 3A21 C8                    iny   
3034 3A22 A9 3A 3A              lda   #delimiter+(delimiter*$100)
3035 3A25 97 98                 sta   [temp_ptr],y
3036 3A27
3037 3A27              ;==========================================================================
3038 3A27              ;adjust the pointer to point to the beginning of the name buffer.
3039 3A27              ;==========================================================================
3040 3A27 DA                    phx   
3041 3A28 98                    tya   
3042 3A29 18                    clc   
3043 3A2A 65 98                 adc   temp_ptr
3044 3A2C 85 98                 sta   temp_ptr
3045 3A2E A9 00 00              lda   #$0000
3046 3A31 65 9A                 adc   temp_ptr+2
3047 3A33 85 9A                 sta   temp_ptr+2
3048 3A35
3049 3A35 7A                    ply   
3050 3A36 84 AC                 sty   math_temp
3051 3A38 A0 01 00              ldy   #$0001
3052 3A3B                       longa off
3053 3A3B E2 20                 sep   #$20
3054 3A3D              class1_loop  
3055 3A3D
3056 3A3D B7 04                 lda   [drvr_buf_ptr],y
3057 3A3F C2 20                 rep   #$20
3058 3A41 2E 0F 03              rol   case_bits                ;see if this char is lower case
3059 3A44 E2 20                 sep   #$20
3060 3A46 90 02                 bcc   @its_upper
3061 3A48
3062 3A48              if AllowLCPeriods then                  ;added 7-Aug-91 DAL
3063 3A48                       cmp   #'.'
3064 3A48                       bne   @not_lc_period
3065 3A48                       lda   #0                       ;let it ORA our 0 into a $20 (blank)
3066 3A48              @not_lc_period  
3067 3A48              endif                                   ;end 7-Aug-91 DAL
3068 3A48
3069 3A48 09 20                 ora   #$20                     ;set the lower case bit please
3070 3A4A              @its_upper  
3071 3A4A 97 98                 sta   [temp_ptr],y
3072 3A4C C4 AC                 cpy   math_temp                ;are we done?
3073 3A4E F0 03                 beq   @were_done
3074 3A50 C8                    iny   
3075 3A51 80 EA                 bra   class1_loop
3076 3A53              @were_done  
3077 3A53                       longa on
3078 3A53 C2 20                 rep   #$20
3079 3A55
3080 3A55              ;If dup_vol_flag is non-zero then we don't want to send the rest of the output
3081 3A55              ;parameters so just exit with the "duplicate volume" error.
3082 3A55
3083 3A55 AD 8A 39              lda   dup_vol_flag             ;check the flag
3084 3A58 F0 04                 beq   @no_error                ;it's 0 so continue
3085 3A5A 38                    sec                            ;we've got a duplicate volume so set carry
3086 3A5B 82 29 FF              brl   vol_exit                 ;and exit with the error
3087 3A5E              @no_error  
3088 3A5E
3089 3A5E              ;==========================================================================
3090 3A5E              ;adjust the pcount to reflect the number of parameters that the user still
3091 3A5E              ;wants.
3092 3A5E              ;==========================================================================
3093 3A5E
3094 3A5E CE B7 05              dec   pcount
3095 3A61 CE B7 05              dec   pcount
3096 3A64
3097 3A64              do_bitmap                               ;
3098 3A64
3099 3A64              ;==========================================================================
3100 3A64              ;now lets see if the caller wants the total blocks on the volume
3101 3A64              ;==========================================================================
3102 3A64
3103 3A64 CE B7 05              dec   pcount
3104 3A67 10 04                 bpl   send_tot_blks
3105 3A69 18           end_volume clc   
3106 3A6A 82 1A FF     backup2  brl   vol_exit
3107 3A6D
3108 3A6D              send_tot_blks                           ;
3109 3A6D A0 15 00              ldy   #vol_total_blks
3110 3A70 B7 88                 lda   [prodos_vcr_ptr],y
3111 3A72 A0 08 00              ldy   #pblk_08_tot
3112 3A75 97 80                 sta   [my_pblk_Ptr],y
3113 3A77 C8                    iny   
3114 3A78 C8                    iny   
3115 3A79 A9 00 00              lda   #$0000
3116 3A7C 97 80                 sta   [my_pblk_ptr],y
3117 3A7E
3118 3A7E              ;==========================================================================
3119 3A7E              ;see if the caller wants the number of free blocks.  We call calc_free_blks
3120 3A7E              ;to calculate the number of free blocks.  The routine returns the TOTAL
3121 3A7E              ;number of blocks available in the 'A' register.
3122 3A7E              ;==========================================================================
3123 3A7E CE B7 05              dec   pcount
3124 3A81 30 E6                 bmi   end_volume
3125 3A83
3126 3A83 20 4E 0C              jsr   calc_free_blks
3127 3A86 B0 E2                 bcs   backup2                  ;some major error occured
3128 3A88
3129 3A88 A0 0C 00              ldy   #pblk_08_free
3130 3A8B 97 80                 sta   [my_pblk_ptr],y
3131 3A8D C8                    iny   
3132 3A8E C8                    iny   
3133 3A8F A9 00 00              lda   #$0000
3134 3A92 97 80                 sta   [my_pblk_ptr],y
3135 3A94
3136 3A94              ;==========================================================================
3137 3A94              ;do they want the file system ID?
3138 3A94              ;==========================================================================
3139 3A94
3140 3A94 CE B7 05              dec   pcount
3141 3A97 30 D0                 bmi   end_volume               ;no they do not!
3142 3A99
3143 3A99 A9 01 00              lda   #pro_id
3144 3A9C A0 10 00              ldy   #pblk_08_id
3145 3A9F 97 80                 sta   [my_pblk_ptr],y
3146 3AA1
3147 3AA1              ;==========================================================================
3148 3AA1              ;do they want to know my block size?
3149 3AA1              ;==========================================================================
3150 3AA1
3151 3AA1 CE B7 05              dec   pcount
3152 3AA4 30 C3                 bmi   end_volume               ;no they do not!
3153 3AA6
3154 3AA6 A9 00 02              lda   #blk_size
3155 3AA9 A0 12 00              ldy   #pblk_08_size
3156 3AAC 97 80                 sta   [my_pblk_ptr],y
3157 3AAE 80 B9                 bra   end_volume
3158 3AB0
3159 3AB0                       ENDP 
3160 3AB0              ;==========================================================================
3161 3AB0              ;Clear_backup:  This routine will clear the backup bit for a file.
3162 3AB0              ;
3163 3AB0              ;Created:       may 27, 1987
3164 3AB0              ;Modified:      may 27, 1987
3165 3AB0              ;Author:        Rob Turner
3166 3AB0              ;
3167 3AB0              ;Enter:         jml
3168 3AB0              ;
3169 3AB0              ;Input:         A = undefined
3170 3AB0              ;               X = call number times 2
3171 3AB0              ;               Y = class times 2
3172 3AB0              ;               P = nvmxdizc
3173 3AB0              ;                   ..000...
3174 3AB0              ;               b = k
3175 3AB0              ;
3176 3AB0              ;Output:        A = error code if carry set
3177 3AB0              ;               X = undefined
3178 3AB0              ;               Y = undefined
3179 3AB0              ;               P = nvmxdizc
3180 3AB0              ;                   ..000..1 = error
3181 3AB0              ;                          0 = no error
3182 3AB0              ;               b = k
3183 3AB0              ;
3184 3AB0              ;Uses:          All registers
3185 3AB0              ;               find_file
3186 3AB0              ;
3187 3AB0              ;Call Format:
3188 3AB0              ;
3189 3AB0              ;Class 0        Pathname pointer        (4 Bytes)
3190 3AB0              ;
3191 3AB0              ;Class 1        PCount                  (2 Bytes)
3192 3AB0              ;               Pathname pointer        (4 Bytes)
3193 3AB0              ;
3194 3AB0              ;==========================================================================
3195 3AB0                       longa on
3196 3AB0                       longi on
3197 3AB0
3198 3AB0                       EXPORT clear_backup
3199 3AB0              clear_backup PROC 
3200 3AB0
3201 3AB0              ;==========================================================================
3202 3AB0              ;Setup the general parameters.
3203 3AB0              ;==========================================================================
3204 3AB0
3205 3AB0 20 9E 0E              jsr   setup_params
3206 3AB3
3207 3AB3              ;==========================================================================
3208 3AB3              ;Process the file name and locate it.  On exit 'drvr_buf_ptr' points to the
3209 3AB3              ;file entry that we are suppose to act on.
3210 3AB3              ;==========================================================================
3211 3AB3
3212 3AB3 20 23 10              jsr   process_path
3213 3AB6 90 03                 bcc   good
3214 3AB8              clear_exit   
3215 3AB8 4C 82 00              jmp   main_exit
3216 3ABB
3217 3ABB              good      
3218 3ABB 20 9B 13              jsr   chk_disk_protect
3219 3ABE
3220 3ABE A0 1E 00              ldy   #access_index
3221 3AC1                       longa off
3222 3AC1 E2 20                 sep   #$20
3223 3AC3
3224 3AC3              ;==========================================================================
3225 3AC3              ;Clear the backup bit for the file/directory
3226 3AC3              ;==========================================================================
3227 3AC3
3228 3AC3 B7 04                 lda   [drvr_buf_ptr],y
3229 3AC5 29 DF                 and   #backup_off              ;clear the backup bit
3230 3AC7 97 04                 sta   [drvr_buf_ptr],y
3231 3AC9
3232 3AC9              ; If we're dealing with a volume directory then we need to clear the backup bit
3233 3AC9              ; in the VCR also so that the disk and VCR match.       4/5/91 CAE
3234 3AC9
3235 3AC9 A7 04                 lda   [drvr_buf_ptr]           ;get storage type
3236 3ACB 29 F0                 and   #$F0                     ;only want hi nibble
3237 3ACD C9 F0                 cmp   #volume_header           ;is this a volume directory?
3238 3ACF D0 09                 bne   @not_vol                 ;no - so branch
3239 3AD1 A0 0E 00              ldy   #vol_access
3240 3AD4 B7 88                 lda   [prodos_vcr_ptr],y
3241 3AD6 29 DF                 and   #backup_off              ;clear the backup bit in the vcr
3242 3AD8 97 88                 sta   [prodos_vcr_ptr],y
3243 3ADA              @not_vol  
3244 3ADA                       longa on
3245 3ADA C2 20                 rep   #$20
3246 3ADC
3247 3ADC              ;==========================================================================
3248 3ADC              ;Reset the I/O buffer pointer to the beginning of the buffer.
3249 3ADC              ;The request count and all that stuff is still correct from the find file
3250 3ADC              ;==========================================================================
3251 3ADC
3252 3ADC AD EB 02              lda   gbuf_addr
3253 3ADF 85 04                 sta   drvr_buf_ptr
3254 3AE1 AD ED 02              lda   gbuf_addr+2
3255 3AE4 85 06                 sta   drvr_buf_ptr+2
3256 3AE6 20 9A 17              jsr   write_with_cache
3257 3AE9 80 CD                 bra   clear_exit
3258 3AEB
3259 3AEB                       ENDP 
3260 3AEB              ;======================================================================
3261 3AEB              ;Open:          This file contains code that is used to open a file on
3262 3AEB              ;               disk. 
3263 3AEB              ;
3264 3AEB              ;Created:       Apr 13, 1987
3265 3AEB              ;Modified:      Apr 16, 1988
3266 3AEB              ;Author:        Rob Turner
3267 3AEB              ;
3268 3AEB              ;Enter:         From GS/OS jmp table
3269 3AEB              ;
3270 3AEB              ;Input:         A = undefined
3271 3AEB              ;               X = (call number * 2)
3272 3AEB              ;               Y = (class number * 2)
3273 3AEB              ;               P = nvmxdizc
3274 3AEB              ;                   ..000...
3275 3AEB              ;               b = k
3276 3AEB              ;
3277 3AEB              ;Output:        A = error code if carry set (exit via system exit routine)
3278 3AEB              ;               X = undefined
3279 3AEB              ;               Y = undefined
3280 3AEB              ;               P = nvmxdizc
3281 3AEB              ;                   ..000..1 = error
3282 3AEB              ;                          0 = no error
3283 3AEB              ;               b = k
3284 3AEB              ;
3285 3AEB              ;Uses:          All registers
3286 3AEB              ;               Device Dispatcher       (subroutine)
3287 3AEB              ;               General I/O Buffer      (1K buffer, I read 512 bytes)
3288 3AEB              ;               find_file               (subroutine)
3289 3AEB              ;
3290 3AEB              ;Call Format:
3291 3AEB              ;
3292 3AEB              ;Class 0        Reference Number        (2 Bytes)
3293 3AEB              ;               Pathname Pointer        (4 Bytes)
3294 3AEB              ;               Reserved                (4 Bytes)
3295 3AEB              ;
3296 3AEB              ;Class 1        PCount                  (2 Bytes)
3297 3AEB              ;               Reference Number        (2 Bytes)
3298 3AEB              ;               Pathname Pointer        (4 Bytes)
3299 3AEB              ;               Request Access          (2 Bytes: New Format)
3300 3AEB              ;               Resource Number         (2 Bytes)
3301 3AEB              ;               (Returned Info)
3302 3AEB              ;               Access                  (2 Bytes)
3303 3AEB              ;               File Type               (2 Bytes)
3304 3AEB              ;               Aux Type                (4 Bytes)
3305 3AEB              ;               Storage Type            (2 Bytes)
3306 3AEB              ;               Create Date/Time        (8 Bytes: Misc. Tools Format)
3307 3AEB              ;               Mod Date/Time           (8 Bytes: Misc. Tools Format)
3308 3AEB              ;               Option List Pointer     (4 Bytes)
3309 3AEB              ;               EOF Data Fork           (4 Bytes)
3310 3AEB              ;               Blocks Used Data Fork   (4 Bytes)
3311 3AEB              ;               EOF Resource Fork       (4 Bytes)
3312 3AEB              ;               Blocks Used Res. Fork   (4 Bytes)
3313 3AEB              ;
3314 3AEB              ;======================================================================
3315 3AEB                       longa on
3316 3AEB                       longi on
3317 3AEB
3318 3AEB                       EXPORT open
3319 3AEB              open     PROC 
3320 3AEB
3321 3AEB              ;==========================================================================
3322 3AEB              ;Setup the defaults for the open call.
3323 3AEB              ;The defaults are set to OPEN resource number $0000(main data) and open file
3324 3AEB              ;as permitted. 
3325 3AEB              ;========================================================================== 
3326 3AEB
3327 3AEB 9C B9 05              stz   resource_num             ;set resource to main data fork
3328 3AEE 9C BB 05              stz   access                   ;set users access to 'as permitted'
3329 3AF1 9C D7 05              stz   users_access             ;set the users access please.
3330 3AF4
3331 3AF4 20 9E 0E              jsr   setup_params
3332 3AF7 F0 08                 beq   class0
3333 3AF9
3334 3AF9 20 0B 3C              jsr   get_access               ;get the user's access byte if avail
3335 3AFC B0 03                 bcs   class0                   ;branch if no access provided 
3336 3AFE 20 F5 3B              jsr   get_res_num              ;get the user's resource num if avail
3337 3B01
3338 3B01              class0                                  ;
3339 3B01              ;==========================================================================
3340 3B01              ;Now go and find the file we need.  If the disk is not ProDOS then we
3341 3B01              ;never return from the call.  It will automatically exit thru 'SYS_EXIT'
3342 3B01              ;==========================================================================
3343 3B01
3344 3B01 20 23 10              jsr   process_path
3345 3B04
3346 3B04              ;==========================================================================
3347 3B04              ;We get here when we have found the file and are ready to open it.
3348 3B04              ;This section of code expects 'drvr_buf_ptr' to point to the file name to open
3349 3B04              ;==========================================================================
3350 3B04
3351 3B04              open_the_file                           ;
3352 3B04 20 09 3E              jsr   move_dir_entry           ;put the disk entry in a common place
3353 3B07
3354 3B07 20 69 3B              jsr   verify_storage           ;make sure I can deal with the file
3355 3B0A B0 26                 bcs   open_exit                ;sorry bud
3356 3B0C 20 8B 3D              jsr   check_dup                ;see if this is a duplicate open
3357 3B0F B0 21                 bcs   open_exit                ;yes this is a duplicate open
3358 3B11 20 6A 3C              jsr   build_the_fcr            ;build the file control record
3359 3B14 B0 1C                 bcs   open_exit
3360 3B16
3361 3B16              ;==========================================================================
3362 3B16              ;Now that we have setup the entrire FCR we need to send back any info
3363 3B16              ;that the user requested.
3364 3B16              ;==========================================================================
3365 3B16
3366 3B16 A0 00 00              ldy   #$0000                   ;default = Class zero type call
3367 3B19 A5 30                 lda   call_number              ;determine class
3368 3B1B 29 00 E0              and   #class_mask
3369 3B1E F0 03                 beq   class0_call
3370 3B20 A0 02 00              ldy   #$0002                   ;index to ref field for new class calls
3371 3B23
3372 3B23              ;==========================================================================
3373 3B23              ;Return the file reference number to the caller.
3374 3B23              ;==========================================================================
3375 3B23
3376 3B23              class0_call                             ;
3377 3B23 A7 8C                 lda   [my_fcr_ptr]
3378 3B25 97 32                 sta   [param_blk_ptr],y
3379 3B27
3380 3B27 20 35 3B              jsr   send_open_parms
3381 3B2A 90 06                 bcc   open_exit
3382 3B2C 48                    pha   
3383 3B2D 20 78 0E              jsr   remove_fcr               ;remove this puppy
3384 3B30 68                    pla   
3385 3B31 38                    sec   
3386 3B32              open_exit  
3387 3B32 4C 82 00              jmp   main_exit
3388 3B35
3389 3B35
3390 3B35              ;==========================================================================
3391 3B35              ;==========================================================================
3392 3B35              ;====== MAIN END OF OPEN CALL  ============================================
3393 3B35              ;==========================================================================
3394 3B35              ;==========================================================================
3395 3B35
3396 3B35              ;==========================================================================
3397 3B35              ;no see how many paremters the user would like with the open call.
3398 3B35              ;
3399 3B35              ;Enter:         jsr
3400 3B35              ;
3401 3B35              ;Input:         A = undefined
3402 3B35              ;               X = undefined
3403 3B35              ;               Y = undefined
3404 3B35              ;               P = nvmxdizc
3405 3B35              ;                   ..000...
3406 3B35              ;               b = k
3407 3B35              ;
3408 3B35              ;Output:        A = undefined
3409 3B35              ;               X = undefined
3410 3B35              ;               Y = undefined
3411 3B35              ;               P = nvmxdizc
3412 3B35              ;                   ..000..1 = error
3413 3B35              ;                          0 = no error
3414 3B35              ;               b = k
3415 3B35              ; 
3416 3B35              ;==========================================================================
3417 3B35
3418 3B35              send_open_parms                         ;
3419 3B35 AD B7 05              lda   pcount
3420 3B38 C9 05 00              cmp   #pcount5                 ;see if there is more then 4 params
3421 3B3B 90 2B                 bcc   end_send                 ;no additional parameters needed
3422 3B3D E9 04 00              sbc   #pcount5-1
3423 3B40 48                    pha   
3424 3B41
3425 3B41              ;==========================================================================
3426 3B41              ;If we fall thru to here then we know the user wants to receive additional
3427 3B41              ;information with the open.  So we start sending the number of field
3428 3B41              ;the user wants.  The routine that sends the info expects the following:
3429 3B41              ;
3430 3B41              ;               A = number of fields to send
3431 3B41              ;               X = low word address of where to start storing the info
3432 3B41              ;               Y = high word address ...
3433 3B41              ;               one_entry  = the entry from the disk
3434 3B41              ;               drvr_buf_ptr = ptr to resource header block
3435 3B41              ;==========================================================================
3436 3B41
3437 3B41 18                    clc                            ;make a pointer to data start
3438 3B42 A5 80                 lda   my_pblk_ptr
3439 3B44 69 0A 00              adc   #$000A
3440 3B47 AA                    tax   
3441 3B48 A5 82                 lda   my_pblk_ptr+2
3442 3B4A 69 00 00              adc   #$0000
3443 3B4D A8                    tay   
3444 3B4E
3445 3B4E AD EB 02              lda   gbuf_addr                ;set up pointer to resource header
3446 3B51 85 04                 sta   drvr_buf_ptr
3447 3B53 AD ED 02              lda   gbuf_addr+2
3448 3B56 85 06                 sta   drvr_buf_ptr+2
3449 3B58
3450 3B58 AD 41 05              lda   one_entry
3451 3B5B 29 0F FF              and   #$FF0F                   ;clear garbage
3452 3B5E 0D 3C 05              ora   entry_sto_type           ;add in entry type from dir entry
3453 3B61 8D 41 05              sta   one_entry
3454 3B64
3455 3B64 68                    pla                            ;recall number of params wanted
3456 3B65 20 04 11              jsr   send_info
3457 3B68              end_send  
3458 3B68 60                    rts   
3459 3B69
3460 3B69              ;=============================================================================
3461 3B69              ;Now we check the storage type.  The only storage types that I know about are:
3462 3B69              ;
3463 3B69              ;(1) seedling   ($0010)
3464 3B69              ;(2) sapling    ($0020)
3465 3B69              ;(3) tree       ($0030)
3466 3B69              ;(4) pascal area        (Access not allowed to pascal area)
3467 3B69              ;(5) resource   ($0050)
3468 3B69              ;(6) purge_dir          (access not allowed to purged directory)
3469 3B69              ;(7) subdir     ($00D0)
3470 3B69              ;(8) subdir H           (access not allowed to header entry)
3471 3B69              ;(9) vol header ($00F0)
3472 3B69              ;
3473 3B69              ;Enter:         jsr
3474 3B69              ;
3475 3B69              ;Input:         A = undefined
3476 3B69              ;               X = undefined
3477 3B69              ;               Y = undefined
3478 3B69              ;               P = nvmxdizc
3479 3B69              ;                   ..000...
3480 3B69              ;               b = k
3481 3B69              ;
3482 3B69              ;Output:        A = error code if carry set
3483 3B69              ;               X = undefined
3484 3B69              ;               Y = undefined
3485 3B69              ;               P = nvmxdizc
3486 3B69              ;                   ..000..1 = error
3487 3B69              ;                          0 = no error
3488 3B69              ;               b = k
3489 3B69              ; 
3490 3B69              ;=============================================================================
3491 3B69
3492 3B69              verify_storage                          ;
3493 3B69 AD 3E 05              lda   storage_type
3494 3B6C 8D 3C 05              sta   entry_sto_type
3495 3B6F
3496 3B6F C9 50 00              cmp   #resource_type
3497 3B72 F0 30                 beq   setup_access
3498 3B74
3499 3B74 AE B9 05              ldx   resource_num             ;make sure the resource number is zero
3500 3B77 D0 6D                 bne   bad_resource
3501 3B79
3502 3B79 C9 30 00              cmp   #tree_type
3503 3B7C F0 26                 beq   setup_access
3504 3B7E C9 20 00              cmp   #sapling_type
3505 3B81 F0 21                 beq   setup_access
3506 3B83 C9 10 00              cmp   #seedling_type
3507 3B86 F0 1C                 beq   setup_access
3508 3B88 C9 D0 00              cmp   #subdir_type
3509 3B8B F0 05                 beq   dir_access
3510 3B8D C9 F0 00              cmp   #volume_header
3511 3B90 D0 5E                 bne   bad_storage
3512 3B92
3513 3B92              ;=============================================================================
3514 3B92              ;If the file is a directory then we must set the access to read only
3515 3B92              ;=============================================================================
3516 3B92              dir_access                              ;
3517 3B92 AD BB 05              lda   access                   ;make sure user wants read only
3518 3B95 F0 05                 beq   force_read_only          ;He wants as permitted, so force read
3519 3B97 C9 02 00              cmp   #write_access
3520 3B9A B0 4F                 bcs   bad_access
3521 3B9C
3522 3B9C              force_read_only                         ;
3523 3B9C A9 01 00              lda   #read_access
3524 3B9F 8D BB 05              sta   access
3525 3BA2 18                    clc   
3526 3BA3 60                    rts   
3527 3BA4
3528 3BA4              ;==========================================================================
3529 3BA4              ;Now we need to check the access.  If the access is 'as_permitted' then we
3530 3BA4              ;must convert the disk access to one of our types (read only, read write, etc) 
3531 3BA4              ;==========================================================================
3532 3BA4
3533 3BA4              setup_access                            ;
3534 3BA4 AD BB 05              lda   access
3535 3BA7 D0 1C                 bne   verify_access
3536 3BA9
3537 3BA9              ;==========================================================================
3538 3BA9              ;Load the disk based access byte 
3539 3BA9              ;==========================================================================
3540 3BA9
3541 3BA9 AD 5F 05              lda   one_entry+access_index
3542 3BAC 29 03 00              and   #read_access+write_access
3543 3BAF F0 3A                 beq   bad_access               ;read/write disabled?
3544 3BB1
3545 3BB1 A2 02 00              ldx   #write_access
3546 3BB4 4A                    lsr   a
3547 3BB5 90 09                 bcc   set_access               ;force write only access
3548 3BB7 A2 01 00              ldx   #read_access
3549 3BBA 4A                    lsr   a
3550 3BBB 90 03                 bcc   set_access               ;force read only access
3551 3BBD A2 03 00              ldx   #read_access+write_access
3552 3BC0              set_access                              ;
3553 3BC0 8E BB 05              stx   access                   ;access now set from disk 
3554 3BC3              exit_access                             ;
3555 3BC3 18                    clc   
3556 3BC4 60                    rts   
3557 3BC5
3558 3BC5              ;==========================================================================
3559 3BC5              ;make sure the user's access agrees with the disk based access.
3560 3BC5              ;==========================================================================
3561 3BC5              verify_access                           ;
3562 3BC5 AE 5F 05              ldx   one_entry+access_index
3563 3BC8 4A                    lsr   a
3564 3BC9 90 07                 bcc   no_read                  ;user does not want read access
3565 3BCB A8                    tay                            ;temp save
3566 3BCC 20 DC 3B              jsr   chk_read
3567 3BCF F0 1A                 beq   bad_access               ;sorry bud
3568 3BD1 98                    tya   
3569 3BD2
3570 3BD2              no_read                                 ;
3571 3BD2 4A                    lsr   a                        ;does the user want write access?
3572 3BD3 90 EE                 bcc   exit_access              ;no
3573 3BD5 20 E1 3B              jsr   chk_write
3574 3BD8 F0 11                 beq   bad_access               ;write access not allowed
3575 3BDA 18                    clc   
3576 3BDB 60                    rts   
3577 3BDC
3578 3BDC              chk_read                                ;
3579 3BDC 8A                    txa                            ;access byte from the disk
3580 3BDD 29 01 00              and   #$0001                   ;isolate read bit
3581 3BE0 60                    rts   
3582 3BE1              chk_write                               ;
3583 3BE1 8A                    txa                            ;access byte from disk
3584 3BE2 29 02 00              and   #$0002
3585 3BE5 60                    rts   
3586 3BE6
3587 3BE6
3588 3BE6              bad_resource                            ;
3589 3BE6 A9 63 00              lda   #res_not_found
3590 3BE9 38                    sec   
3591 3BEA 60                    rts   
3592 3BEB
3593 3BEB              bad_access                              ;
3594 3BEB A9 4E 00              lda   #invalid_access
3595 3BEE 38                    sec   
3596 3BEF 60                    rts   
3597 3BF0
3598 3BF0 A9 4B 00     bad_storage lda   #bad_store_type
3599 3BF3 38                    sec   
3600 3BF4 60                    rts   
3601 3BF5
3602 3BF5              ;==========================================================================
3603 3BF5              ;see if the user provided resource number.
3604 3BF5              ;
3605 3BF5              ;Enter:         jsr
3606 3BF5              ;
3607 3BF5              ;Input:         A = undefined
3608 3BF5              ;               X = undefined
3609 3BF5              ;               Y = undefined
3610 3BF5              ;               P = nvmxdizc
3611 3BF5              ;                   ..000...
3612 3BF5              ;               b = k
3613 3BF5              ;
3614 3BF5              ;Output:        A = error code if carry set
3615 3BF5              ;               X = undefined
3616 3BF5              ;               Y = undefined
3617 3BF5              ;               P = nvmxdizc
3618 3BF5              ;                   ..000..1 = error
3619 3BF5              ;                          0 = no error
3620 3BF5              ;               b = k
3621 3BF5              ; 
3622 3BF5              ;==========================================================================
3623 3BF5              get_res_num                             ;
3624 3BF5 AD B7 05              lda   pcount
3625 3BF8 C9 04 00              cmp   #$0004
3626 3BFB 90 0D                 bcc   end_res                  ;no resource number provided
3627 3BFD
3628 3BFD A0 08 00              ldy   #$0008
3629 3C00 B7 80                 lda   [my_pblk_ptr],y
3630 3C02 F0 06                 beq   end_res                  ;default resource number so exit
3631 3C04 8D B9 05              sta   resource_num             ;save the resource. must be zero
3632 3C07 3A                    dec   a
3633 3C08 D0 1B                 bne   not_in_range             ;not even close.
3634 3C0A
3635 3C0A              end_res                                 ;
3636 3C0A 60                    rts   
3637 3C0B
3638 3C0B              ;==========================================================================
3639 3C0B              ;get_access     This routine will load the user's access byte if available
3640 3C0B              ;
3641 3C0B              ;
3642 3C0B              ;Enter:         jsr
3643 3C0B              ;
3644 3C0B              ;Input:         A = undefined
3645 3C0B              ;               X = undefined
3646 3C0B              ;               Y = undefined
3647 3C0B              ;               P = nvmxdizc
3648 3C0B              ;                   ..000...
3649 3C0B              ;               b = k
3650 3C0B              ;
3651 3C0B              ;Output:        A = undefined
3652 3C0B              ;               X = undefined
3653 3C0B              ;               Y = undefined
3654 3C0B              ;               P = nvmxdizc
3655 3C0B              ;                   ..000..1 = no more parameters
3656 3C0B              ;                          0 = more paramters may follow
3657 3C0B              ;               b = k
3658 3C0B              ;
3659 3C0B              ;==========================================================================
3660 3C0B
3661 3C0B              get_access  
3662 3C0B AD B7 05              lda   pcount
3663 3C0E C9 03 00              cmp   #$0003
3664 3C11 90 18                 bcc   no_params                ;there is no parameters
3665 3C13
3666 3C13 A0 06 00              ldy   #$0006
3667 3C16 B7 80                 lda   [my_pblk_ptr],y
3668 3C18 8D D7 05              sta   users_access             ;save the user's access please.
3669 3C1B F0 10                 beq   end_access               ;same as default access so exit
3670 3C1D
3671 3C1D              ;==========================================================================
3672 3C1D              ;access:
3673 3C1D              ;               00 = open as permitted  ;default value for open call
3674 3C1D              ;               01 = open for reading only
3675 3C1D              ;               02 = open for writing only
3676 3C1D              ;               03 = open for reading and writing
3677 3C1D              ;========================================================================== 
3678 3C1D
3679 3C1D 8D BB 05              sta   access                   ;save user's choice
3680 3C20 C9 04 00              cmp   #read_write_acc+1
3681 3C23 90 08                 bcc   end_access
3682 3C25
3683 3C25              not_in_range                            ;
3684 3C25 A9 53 00              lda   #parm_range_err          ;I don't know what to do with this
3685 3C28 4C 81 00              jmp   error_exit               ;sorry bud
3686 3C2B
3687 3C2B              no_params                               ;
3688 3C2B 38                    sec   
3689 3C2C 60                    rts   
3690 3C2D
3691 3C2D              end_access                              ;
3692 3C2D 18                    clc   
3693 3C2E 60                    rts   
3694 3C2F
3695 3C2F
3696 3C2F              ;==========================================================================
3697 3C2F              ;Calculate the size of the root directory.  This is a pain but we cannot
3698 3C2F              ;assume that the root directory will be four blocks long. So we might as
3699 3C2F              ;well put the directory blocks in the cache while we are at it
3700 3C2F              ;
3701 3C2F              ;Enter:         jsr
3702 3C2F              ;
3703 3C2F              ;Input:         A = undefined
3704 3C2F              ;               X = undefined
3705 3C2F              ;               Y = undefined
3706 3C2F              ;               P = nvmxdizc
3707 3C2F              ;                   ..000...
3708 3C2F              ;               b = k
3709 3C2F              ;
3710 3C2F              ;Output:        A = undefined
3711 3C2F              ;               X = undefined
3712 3C2F              ;               Y = undefined
3713 3C2F              ;               P = nvmxdizc
3714 3C2F              ;                   ..000..1 = no more parameters
3715 3C2F              ;                          0 = more paramters may follow
3716 3C2F              ;               b = k
3717 3C2F              ;==========================================================================
3718 3C2F
3719 3C2F                       EXPORT vol_file_size
3720 3C2F              vol_file_size  
3721 3C2F 9C 57 05              stz   one_entry+eof_index+1
3722 3C32
3723 3C32
3724 3C32 AD EB 02              lda   gbuf_addr
3725 3C35 85 04                 sta   drvr_buf_ptr
3726 3C37 AD ED 02              lda   gbuf_addr+2
3727 3C3A 85 06                 sta   drvr_buf_ptr+2
3728 3C3C
3729 3C3C 64 AC                 stz   math_temp                ;used to count the number of blocks
3730 3C3E
3731 3C3E 64 12                 stz   drvr_blk_num+2
3732 3C40 A9 02 00              lda   #vol_dir_start
3733 3C43
3734 3C43              block_loop   
3735 3C43 85 10                 sta   drvr_blk_num
3736 3C45 20 95 17              jsr   read_with_cache
3737 3C48 90 09                 bcc   cont_blk
3738 3C4A 48                    pha                            ;save the error code
3739 3C4B 20 78 0E              jsr   remove_fcr
3740 3C4E 68                    pla   
3741 3C4F 38                    sec   
3742 3C50 4C 82 00              jmp   main_exit
3743 3C53
3744 3C53              cont_blk   
3745 3C53 E6 AC                 inc   math_temp
3746 3C55 A0 02 00              ldy   #$0002
3747 3C58 B7 04                 lda   [drvr_buf_ptr],y
3748 3C5A D0 E7                 bne   block_loop
3749 3C5C
3750 3C5C              end_blk_cnt                             ;
3751 3C5C A5 AC                 lda   math_temp
3752 3C5E 8D 54 05              sta   one_entry+blks_used_index
3753 3C61 EB                    xba   
3754 3C62 0A                    asl   a                        ;times two for EOF
3755 3C63 8D 56 05              sta   one_entry+eof_index
3756 3C66 20 FC 10              jsr   set_user_cache
3757 3C69 60                    rts   
3758 3C6A                       ENDP 
3759 3C6A
3760 3C6A              ;==========================================================================
3761 3C6A              ;This routine will build the FCR.
3762 3C6A              ;
3763 3C6A              ;Enter:         jsr
3764 3C6A              ;
3765 3C6A              ;Input:         A = undefined
3766 3C6A              ;               X = undefined
3767 3C6A              ;               Y = undefined
3768 3C6A              ;               P = nvmxdizc
3769 3C6A              ;                   ..000...
3770 3C6A              ;               b = k
3771 3C6A              ;
3772 3C6A              ;Output:        A = error code if carry set
3773 3C6A              ;               X = undefined
3774 3C6A              ;               Y = undefined
3775 3C6A              ;               P = nvmxdizc
3776 3C6A              ;                   ..000..1 = error
3777 3C6A              ;                          0 = no error
3778 3C6A              ;               b = k
3779 3C6A              ; 
3780 3C6A              ;==========================================================================
3781 3C6A
3782 3C6A                       EXPORT build_the_fcr
3783 3C6A              build_the_fcr PROC 
3784 3C6A
3785 3C6A              ;==========================================================================
3786 3C6A              ;allocation size:
3787 3C6A              ;
3788 3C6A              ;directories            2 blocks
3789 3C6A              ;read/write files       3 blocks
3790 3C6A              ;read seedling          1 block
3791 3C6A              ;read sapling           2 block
3792 3C6A              ;read tree              3 blocks
3793 3C6A              ;
3794 3C6A              ;==========================================================================
3795 3C6A
3796 3C6A A0 00 60              ldy   #data_active+index_active
3797 3C6D A9 53 04              lda   #fcr_index_size          ;two block I/O buffer for directories
3798 3C70 AE 3E 05              ldx   storage_type
3799 3C73 E0 D0 00              cpx   #subdir_type
3800 3C76 B0 24                 bcs   alloc_the_fcr
3801 3C78
3802 3C78 AD BB 05              lda   access                   ;see if the file is open for read only
3803 3C7B C9 01 00              cmp   #read_access
3804 3C7E D0 16                 bne   norm_io_buf              ;allocate a large I/O buffer
3805 3C80
3806 3C80 A0 00 40              ldy   #data_active
3807 3C83 A9 53 02              lda   #fcr_data_size
3808 3C86 E0 10 00              cpx   #seedling_type           ;one block buffer for seedling files
3809 3C89 F0 11                 beq   alloc_the_fcr
3810 3C8B
3811 3C8B A0 00 60              ldy   #data_active+index_active
3812 3C8E A9 53 04              lda   #fcr_index_size
3813 3C91 E0 20 00              cpx   #sapling_type            ;two blocks for a sapling file
3814 3C94 F0 06                 beq   alloc_the_fcr
3815 3C96
3816 3C96              norm_io_buf                             ;
3817 3C96 A0 00 70              ldy   #data_active+index_active+master_active
3818 3C99 A9 53 06              lda   #fcr_master_size         ;allocate three blocks for I/O buffer
3819 3C9C
3820 3C9C              ;==========================================================================
3821 3C9C              ;when we get here A = number of bytes wanted
3822 3C9C              ;==========================================================================
3823 3C9C
3824 3C9C              alloc_the_fcr                           ;
3825 3C9C 5A                    phy   
3826 3C9D 48                    pha   
3827 3C9E
3828 3C9E              ;	jsr	entry_to_gstr	;convert to a gstring for mike
3829 3C9E              ;
3830 3C9E
3831 3C9E A0 02 00              ldy   #vcr_name                ;pass in the name of the Volume please
3832 3CA1 B7 84                 lda   [my_vcr_ptr],y           ;get the VP please
3833 3CA3 AA                    tax   
3834 3CA4 C8                    iny   
3835 3CA5 C8                    iny   
3836 3CA6 B7 84                 lda   [my_vcr_ptr],y
3837 3CA8 A8                    tay                            ;High word of the VP
3838 3CA9 22 38 FC 01           jsl   deref                    ;convert the VP to a real pointer
3839 3CAD                                                      ;return X&Y pointer to the name
3840 3CAD
3841 3CAD D4 98                 pei   temp_ptr                 ;save the pointer I am going to use
3842 3CAF D4 9A                 pei   temp_ptr+2
3843 3CB1
3844 3CB1 86 98                 stx   temp_ptr                 ;save the address of the string
3845 3CB3 84 9A                 sty   temp_ptr+2
3846 3CB5
3847 3CB5 A7 98                 lda   [temp_ptr]               ;get the length word please
3848 3CB7 A8                    tay                            ;save the count
3849 3CB8 1A                    inc   a                        ;add one for the :
3850 3CB9 8D 0F 05              sta   gstring                  ;save the count
3851 3CBC A9 3A 3A              lda   #'::'
3852 3CBF 8D 11 05              sta   gstring+2                ;save the seperator
3853 3CC2
3854 3CC2 E6 98                 inc   temp_ptr
3855 3CC4 D0 02                 bne   @01
3856 3CC6 E6 9A                 inc   temp_ptr+2
3857 3CC8              @01       
3858 3CC8 B7 98                 lda   [temp_ptr],y             ;get a char please
3859 3CCA 99 11 05              sta   gstring+2,y
3860 3CCD 88                    dey   
3861 3CCE D0 F8                 bne   @01
3862 3CD0
3863 3CD0 68                    pla   
3864 3CD1 85 9A                 sta   temp_ptr+2               ;restore the pointer I used
3865 3CD3 68                    pla   
3866 3CD4 85 98                 sta   temp_ptr
3867 3CD6
3868 3CD6 A2 0F 05              ldx   #gstring                 ;pointer to the file name or Volume Name to Open
3869 3CD9 A0 02 00              ldy   #^gstring                ;high word
3870 3CDC 68                    pla                            ;restore I/O buffer size
3871 3CDD 38                    sec                            ;better clear the buffer
3872 3CDE 22 2C FC 01           jsl   alloc_fcr                ;build a new fcr for file
3873 3CE2 90 02                 bcc   success
3874 3CE4 7A                    ply   
3875 3CE5 60                    rts                            ;return with the error
3876 3CE6
3877 3CE6              success                                 ;
3878 3CE6 22 38 FC 01           jsl   deref                    ;convert VP to RP
3879 3CEA 86 8C                 stx   my_fcr_ptr
3880 3CEC 84 8E                 sty   my_fcr_ptr+2
3881 3CEE
3882 3CEE 20 A3 15              jsr   setup_my_fcr             ;build a pointer to local data
3883 3CF1 86 90                 stx   pro_fcr_ptr
3884 3CF3 84 92                 sty   pro_fcr_ptr+2            ;save pointer to my structure
3885 3CF5
3886 3CF5 A0 08 00              ldy   #vcr_open_cnt            ;advance the open count please by one
3887 3CF8 B7 84                 lda   [my_vcr_ptr],y
3888 3CFA 1A                    inc   a
3889 3CFB 97 84                 sta   [my_vcr_ptr],y
3890 3CFD
3891 3CFD A0 1F 00              ldy   #fcr_status
3892 3D00 A9 00 00              lda   #$0000                   ;zero the status word
3893 3D03 97 90                 sta   [pro_fcr_ptr],y
3894 3D05
3895 3D05 68                    pla                            ;restore the I/O buffer active bits
3896 3D06 20 F2 3E              jsr   set_fcr_status
3897 3D09
3898 3D09 AD BB 05              lda   access                   ;save the user's access
3899 3D0C A0 14 00              ldy   #fcr_access
3900 3D0F 09 00 80              ora   #set_global_clean
3901 3D12 AE B9 05              ldx   resource_num             ;does the file contain a resource fork?
3902 3D15 F0 03                 beq   @store_access
3903 3D17 09 00 40              ora   #set_access_res          ;set the access resource bit please
3904 3D1A              @store_access  
3905 3D1A 97 8C                 sta   [my_fcr_ptr],y
3906 3D1C
3907 3D1C A0 08 00              ldy   #fcr_vol_id
3908 3D1F A7 84                 lda   [my_vcr_ptr]             ;get the volume ID from the VCR
3909 3D21 97 8C                 sta   [my_fcr_ptr],y           ;and save it in the new FCR
3910 3D23
3911 3D23 A0 06 00              ldy   #fcr_fst_id
3912 3D26 A9 01 00              lda   #pro_id                  ;save the ownership id word
3913 3D29 97 8C                 sta   [my_fcr_ptr],y
3914 3D2B
3915 3D2B              ;==========================================================================
3916 3D2B              ;Now start saving data into my local data segment
3917 3D2B              ;==========================================================================
3918 3D2B
3919 3D2B AD B9 05              lda   resource_num             ;save the resource number of the file
3920 3D2E 87 90                 sta   [pro_fcr_ptr]
3921 3D30
3922 3D30 A0 04 00              ldy   #fcr_entry_type
3923 3D33 AD 3C 05              lda   entry_sto_type           ;save the storage type from dir entry
3924 3D36 97 90                 sta   [pro_fcr_ptr],y
3925 3D38
3926 3D38 A0 02 00              ldy   #fcr_storage
3927 3D3B AD 3E 05              lda   storage_type             ;save the storage type
3928 3D3E 97 90                 sta   [pro_fcr_ptr],y
3929 3D40
3930 3D40 C9 F0 00              cmp   #volume_header           ;if file is a volume then calc EOF
3931 3D43 D0 03                 bne   no_adjust2
3932 3D45
3933 3D45 20 2F 3C              jsr   vol_file_size            ;calculate the EOF for the root vol
3934 3D48
3935 3D48              no_adjust2                              ;
3936 3D48
3937 3D48 A0 2F 00              ldy   #fcr_curr_eof            ;save the current EOF
3938 3D4B AD 56 05              lda   one_entry+eof_index
3939 3D4E 97 90                 sta   [pro_fcr_ptr],y
3940 3D50 C8                    iny   
3941 3D51 AD 57 05              lda   one_entry+eof_index+1
3942 3D54 97 90                 sta   [pro_fcr_ptr],y
3943 3D56
3944 3D56 A0 0B 00              ldy   #fcr_blks_used           ;save the number of blocks used
3945 3D59 AD 54 05              lda   one_entry+blks_used_index
3946 3D5C 97 90                 sta   [pro_fcr_ptr],y
3947 3D5E
3948 3D5E A0 33 00              ldy   #fcr_parent
3949 3D61 AD 79 05              lda   parent_blk               ;save address of parent block number
3950 3D64 97 90                 sta   [pro_fcr_ptr],y
3951 3D66
3952 3D66 A0 35 00              ldy   #fcr_entry_offs
3953 3D69 AD 7B 05              lda   entry_offset             ;save offset to entry within parent blk
3954 3D6C 97 90                 sta   [pro_fcr_ptr],y
3955 3D6E
3956 3D6E A0 08 00              ldy   #fcr_file_type           ;move the directory entry into the FCR
3957 3D71
3958 3D71 B9 49 05     entry_loop lda   one_entry-fcr_file_type+$10,y
3959 3D74 97 90                 sta   [pro_fcr_ptr],y
3960 3D76 C8                    iny   
3961 3D77 C0 1E 00              cpy   #fcr_header_ptr+1
3962 3D7A D0 F5                 bne   entry_loop
3963 3D7C
3964 3D7C 20 B1 15              jsr   setup_io_ptrs            ;build pointers to data structures
3965 3D7F 20 49 3E              jsr   setup_io_buf
3966 3D82 90 06                 bcc   no_prob
3967 3D84 48                    pha   
3968 3D85 20 78 0E              jsr   remove_fcr               ;remove this puppy
3969 3D88 68                    pla   
3970 3D89 38                    sec   
3971 3D8A              no_prob                                 ;
3972 3D8A 60                    rts   
3973 3D8B                       ENDP 
3974 3D8B              ;======================================================================
3975 3D8B              ;check_dup:     This routine will check for duplicate file entries.
3976 3D8B              ;               To do this I look to see if the starting block of
3977 3D8B              ;               the FCR is equal to the starting block of the file I am
3978 3D8B              ;               trying to open. 
3979 3D8B              ;
3980 3D8B              ;Created:       may 04, 1987
3981 3D8B              ;Modified:      may 06, 1987
3982 3D8B              ;Author:        Rob Turner
3983 3D8B              ;
3984 3D8B              ;
3985 3D8B              ;Enter:         from open call
3986 3D8B              ;
3987 3D8B              ;Input:         A = undefined
3988 3D8B              ;               X = undefined
3989 3D8B              ;               Y = undefined
3990 3D8B              ;               P = nvmxdizc
3991 3D8B              ;                   ..000...
3992 3D8B              ;               b = k
3993 3D8B              ;
3994 3D8B              ;               one_entry               (39 byte entry from disk) 
3995 3D8B              ;               access                  (requested access for open)
3996 3D8B              ; 
3997 3D8B              ;Output:        A = error code if carry set. (duplicate error)
3998 3D8B              ;               X = undefined
3999 3D8B              ;               Y = undefined
4000 3D8B              ;               P = nvmxdizc
4001 3D8B              ;                   ..000..1 = error
4002 3D8B              ;                          0 = no error
4003 3D8B              ;               b = k
4004 3D8B              ;
4005 3D8B              ;Uses:          All registers
4006 3D8B              ;               General I/O Buffer      (1K buffer, I read 512 bytes)
4007 3D8B              ;               find_fcr                (system routine to find a fcr
4008 3D8B              ;               my_fcr_ptr
4009 3D8B              ;               pro_fcr_ptr
4010 3D8B              ;               access
4011 3D8B              ;               resource_num
4012 3D8B              ; 
4013 3D8B              ;======================================================================
4014 3D8B                       longa on
4015 3D8B                       longi on
4016 3D8B
4017 3D8B                       EXPORT check_dup
4018 3D8B              check_dup PROC 
4019 3D8B
4020 3D8B 9C 36 05              stz   fcr_wanted               ;reset for get_next_fcr
4021 3D8E
4022 3D8E AD 52 05              lda   one_entry+key_blk_index
4023 3D91 8D 38 05              sta   key_block
4024 3D94
4025 3D94              next_loop                               ;
4026 3D94 20 E1 3D              jsr   get_next_fcr
4027 3D97 B0 46                 bcs   done
4028 3D99
4029 3D99 A0 08 00              ldy   #fcr_vol_id
4030 3D9C B7 8C                 lda   [my_fcr_ptr],y           ;get the Volume ID so we can make sure the file is on
4031 3D9E C7 84                 cmp   [my_vcr_ptr]             ;the same volume.
4032 3DA0 D0 F2                 bne   next_loop                ;File is on another volume
4033 3DA2
4034 3DA2 A0 06 00              ldy   #fcr_file_id             ;index to key block of this file
4035 3DA5 B7 90                 lda   [pro_fcr_ptr],y
4036 3DA7 CD 38 05              cmp   key_block                ;is this the same block?
4037 3DAA D0 E8                 bne   next_loop                ;no problem with this file
4038 3DAC
4039 3DAC              ;==========================================================================
4040 3DAC              ;Now we need to see if the resource numbers are different.
4041 3DAC              ;==========================================================================
4042 3DAC
4043 3DAC A7 90                 lda   [pro_fcr_ptr]
4044 3DAE CD B9 05              cmp   resource_num
4045 3DB1 D0 E1                 bne   next_loop                ;not the same resource
4046 3DB3
4047 3DB3 A0 08 00              ldy   #fcr_vol_id              ;see if the file is on another volume
4048 3DB6 B7 8C                 lda   [my_fcr_ptr],y
4049 3DB8 C7 84                 cmp   [my_vcr_ptr]
4050 3DBA D0 D8                 bne   next_loop
4051 3DBC
4052 3DBC A0 14 00              ldy   #fcr_access              ;see if this file was open for writing
4053 3DBF B7 8C                 lda   [my_fcr_ptr],y
4054 3DC1 29 FF 3F              and   #ClrAllButAccess
4055 3DC4 C9 02 00              cmp   #write_access
4056 3DC7 B0 0B                 bcs   file_is_busy             ;sorry this file is busy right now
4057 3DC9
4058 3DC9              ;==========================================================================
4059 3DC9              ;If we get here we know that the current file is the same and that it is
4060 3DC9              ;open for read only.  Therefore we must check the requested access of the
4061 3DC9              ;file that we are currently opening.  If the user wants read only access
4062 3DC9              ;then there is no problem.
4063 3DC9              ;==========================================================================
4064 3DC9
4065 3DC9 AD D7 05              lda   users_access             ;did the user want "open_as_permitted"
4066 3DCC F0 0B                 beq   open_as_perm             ;user request open as permitted. 
4067 3DCE C9 02 00              cmp   #write_access
4068 3DD1 B0 01                 bcs   file_is_busy
4069 3DD3 60                    rts                            ;return carry clear indicating no dup 
4070 3DD4
4071 3DD4              file_is_busy   
4072 3DD4 A9 50 00              lda   #file_busy
4073 3DD7 38                    sec   
4074 3DD8 60                    rts                            ;error out to caller 
4075 3DD9
4076 3DD9              open_as_perm   
4077 3DD9              ;	ldy	#fcr_disk_acc
4078 3DD9              ;	lda	[pro_fcr_ptr],y	;check disk assigned access.
4079 3DD9              ;	and	#write_enabled	;is the file write enabled?
4080 3DD9              ;	bne	file_is_busy	;yes it is, so die
4081 3DD9
4082 3DD9 A9 01 00              lda   #read_access
4083 3DDC 8D BB 05              sta   access                   ;change the user's access to Read Only.
4084 3DDF
4085 3DDF 18           done     clc                            ;indicate no problem
4086 3DE0 60                    rts   
4087 3DE1                       ENDP 
4088 3DE1
4089 3DE1              ;======================================================================
4090 3DE1              ;get_next_fcr:  This routine will load find the next FCR that belongs
4091 3DE1              ;               to ProDOS.
4092 3DE1              ;
4093 3DE1              ;Created:       may 23, 1987
4094 3DE1              ;Modified:      may 23, 1987
4095 3DE1              ;Author:        Rob Turner
4096 3DE1              ;
4097 3DE1              ;
4098 3DE1              ;Enter:         from open call
4099 3DE1              ;
4100 3DE1              ;Input:         A = undefined
4101 3DE1              ;               X = undefined
4102 3DE1              ;               Y = undefined
4103 3DE1              ;               P = nvmxdizc
4104 3DE1              ;                   ..000...
4105 3DE1              ;               b = k
4106 3DE1              ;
4107 3DE1              ;               fcr_wanted              (counter for FCR, reset by caller!)
4108 3DE1              ; 
4109 3DE1              ;Output:        A = undefiend
4110 3DE1              ;               X = undefined
4111 3DE1              ;               Y = undefined
4112 3DE1              ;               P = nvmxdizc
4113 3DE1              ;                   ..000..1 = error    (end of FCRs)
4114 3DE1              ;                          0 = no error
4115 3DE1              ;               b = k
4116 3DE1              ;
4117 3DE1              ;               pro_fcr_ptr
4118 3DE1              ;               my_fcr_ptr              (points to the found FCR)
4119 3DE1              ;
4120 3DE1              ;Uses:          All registers
4121 3DE1              ;               system_routines
4122 3DE1              ;
4123 3DE1              ;======================================================================
4124 3DE1                       longa on
4125 3DE1                       longi on
4126 3DE1
4127 3DE1                       EXPORT get_next_fcr
4128 3DE1              get_next_fcr PROC 
4129 3DE1
4130 3DE1              loop      
4131 3DE1 AD 36 05              lda   fcr_wanted
4132 3DE4 1A                    inc   a
4133 3DE5 8D 36 05              sta   fcr_wanted
4134 3DE8 22 64 FC 01           jsl   get_fcr                  ;see if this is a fcr
4135 3DEC B0 1A                 bcs   done
4136 3DEE
4137 3DEE 22 38 FC 01           jsl   deref                    ;convert VP to RP
4138 3DF2 86 8C                 stx   my_fcr_Ptr
4139 3DF4 84 8E                 sty   my_fcr_ptr+2
4140 3DF6
4141 3DF6 A0 06 00              ldy   #fcr_fst_id              ;see if this one is mine
4142 3DF9 B7 8C                 lda   [my_fcr_ptr],y
4143 3DFB C9 01 00              cmp   #pro_id
4144 3DFE D0 E1                 bne   loop                     ;not mine so who cares
4145 3E00
4146 3E00 20 A3 15              jsr   setup_my_fcr
4147 3E03 86 90                 stx   pro_fcr_ptr
4148 3E05 84 92                 sty   pro_fcr_ptr+2
4149 3E07
4150 3E07 18                    clc   
4151 3E08              done      
4152 3E08 60                    rts   
4153 3E09
4154 3E09
4155 3E09                       ENDP 
4156 3E09
4157 3E09              ;======================================================================
4158 3E09              ;move_dir_entry This routine will move the 39 byte entry pointed to by
4159 3E09              ;               drvr_buf_ptr to one_entry.  If the entry pointed to
4160 3E09              ;               is a volume header then I will simulate a normal 39
4161 3E09              ;               byte entry. 
4162 3E09              ;
4163 3E09              ;Created:       may 05, 1987
4164 3E09              ;Modified:      may 05, 1987
4165 3E09              ;Author:        Rob Turner
4166 3E09              ;
4167 3E09              ;
4168 3E09              ;Enter:         from open call
4169 3E09              ;
4170 3E09              ;Input:         A = undefined
4171 3E09              ;               X = undefined
4172 3E09              ;               Y = undefined
4173 3E09              ;               P = nvmxdizc
4174 3E09              ;                   ..000...
4175 3E09              ;               b = k
4176 3E09              ;
4177 3E09              ;               drvr_buf_ptr            (points to the 39 byte entry from disk) 
4178 3E09              ;               storage_type            (original storage type of entry)
4179 3E09              ; 
4180 3E09              ;Output:        A = undefiend
4181 3E09              ;               X = undefined
4182 3E09              ;               Y = undefined
4183 3E09              ;               P = nvmxdizc
4184 3E09              ;                   ..000..1 = error
4185 3E09              ;                          0 = no error
4186 3E09              ;               b = k
4187 3E09              ;
4188 3E09              ;               one_entry               (contains a 39 byte entry)
4189 3E09              ; 
4190 3E09              ;Uses:          All registers
4191 3E09              ;               General I/O Buffer      (1K buffer, I read 512 bytes)
4192 3E09              ;               drvr_buf_ptr
4193 3E09              ;
4194 3E09              ;======================================================================
4195 3E09                       longa on
4196 3E09                       longi on
4197 3E09
4198 3E09                       EXPORT move_dir_entry
4199 3E09              move_dir_entry PROC 
4200 3E09
4201 3E09 A7 04                 lda   [drvr_buf_ptr]           ;get the storage type
4202 3E0B 29 F0 00              and   #$00F0
4203 3E0E 8D 3E 05              sta   storage_type
4204 3E11 C9 F0 00              cmp   #volume_header
4205 3E14 F0 17                 beq   simulate_entry           ;simulate a reg. file entry
4206 3E16
4207 3E16                       EXPORT move_vol_entry
4208 3E16              move_vol_entry                          ;
4209 3E16
4210 3E16 A0 26 00     start_move ldy   #entry_length-1        ;just move a normal file entry
4211 3E19 B7 04        move_loop lda   [drvr_buf_ptr],y
4212 3E1B 99 41 05              sta   one_entry,y
4213 3E1E 88                    dey   
4214 3E1F 88                    dey   
4215 3E20 10 F7                 bpl   move_loop
4216 3E22 AD 40 05              lda   alloc_entry
4217 3E25 29 00 0F              and   #$0F00                   ;clear all but the storage type
4218 3E28 EB                    xba   
4219 3E29 8D 40 05              sta   alloc_entry              ;convert length byte to word
4220 3E2C 60                    rts   
4221 3E2D
4222 3E2D              simulate_entry                          ;
4223 3E2D 20 16 3E              jsr   start_move               ;move the basic entry
4224 3E30
4225 3E30              ;==========================================================================
4226 3E30              ;below we setup the volume directory as a subdirectory.  To do this
4227 3E30              ;we setup the following fields:
4228 3E30              ;==========================================================================
4229 3E30              ; File_type     := $0F                  (directory File)
4230 3E30              ; Key_pointer   := vol_dir_start        (starting block for directory = 2)
4231 3E30              ; Blocks_used   := (Calculated from disk)
4232 3E30              ; EOF           := (Calculated from disk)
4233 3E30              ; AUX Type      := $0000                (zero the aux field)
4234 3E30              ; Last_mod      := $00000000            (don't have this info)
4235 3E30              ; Header Ptr    := $0002                (Starting block of owning directory)
4236 3E30              ;==========================================================================
4237 3E30
4238 3E30              ;==========================================================================
4239 3E30              ;Now setup the file type as a subdirectory entry
4240 3E30              ;==========================================================================
4241 3E30
4242 3E30 A9 0F 00              lda   #dir_file_type
4243 3E33 8D 51 05              sta   one_entry+file_type_index
4244 3E36
4245 3E36              ;==========================================================================
4246 3E36              ;Now setup Key block pointer and header_ptr
4247 3E36              ;==========================================================================
4248 3E36
4249 3E36 A9 02 00              lda   #vol_dir_start
4250 3E39 8D 52 05              sta   one_entry+key_blk_index
4251 3E3C 8D 66 05              sta   one_entry+header_ptr_index
4252 3E3F
4253 3E3F              ;==========================================================================
4254 3E3F              ;Zero the aux type and mod_date
4255 3E3F              ;==========================================================================
4256 3E3F
4257 3E3F 9C 60 05              stz   one_entry+aux_type_index 
4258 3E42 9C 62 05              stz   one_entry+last_mod_index
4259 3E45 9C 64 05              stz   one_entry+2+last_mod_index
4260 3E48 60                    rts   
4261 3E49                       ENDP 
4262 3E49
4263 3E49              ;========================================================================== 
4264 3E49              ;setup_io_buf   This routine will fill the I/O buffer with the correct
4265 3E49              ;               data
4266 3E49              ;
4267 3E49              ;Input:         A = undefined
4268 3E49              ;               X = undefined
4269 3E49              ;               Y = undefined
4270 3E49              ;               P = nvmxdizc
4271 3E49              ;                   ..000...
4272 3E49              ;               b = k
4273 3E49              ;
4274 3E49              ;               one_entry               (39 byte entry from disk) 
4275 3E49              ;               FCR                     (setup)
4276 3E49              ;
4277 3E49              ;Output:        A = error code if carry set.
4278 3E49              ;               X = undefined
4279 3E49              ;               Y = undefined
4280 3E49              ;               P = nvmxdizc
4281 3E49              ;                   ..000..1 = error
4282 3E49              ;                          0 = no error
4283 3E49              ;               b = k
4284 3E49              ;
4285 3E49              ;Uses:          All registers
4286 3E49              ;
4287 3E49              ;==========================================================================
4288 3E49
4289 3E49                       EXPORT setup_io_buf
4290 3E49              setup_io_buf PROC 
4291 3E49
4292 3E49 A0 09 00              ldy   #fcr_key_blk             ;key block of the resource
4293 3E4C B7 90                 lda   [pro_fcr_ptr],y
4294 3E4E 85 10                 sta   drvr_blk_num
4295 3E50 A0 06 00              ldy   #fcr_file_id
4296 3E53 97 90                 sta   [pro_fcr_ptr],y          ;save file id for duplicate checks
4297 3E55
4298 3E55 A0 04 00              ldy   #fcr_entry_type
4299 3E58 B7 90                 lda   [pro_fcr_ptr],y          ;see if this is a resource file
4300 3E5A C9 50 00              cmp   #resource_type
4301 3E5D D0 06                 bne   not_resource             ;must be a standard file
4302 3E5F
4303 3E5F 20 FA 3E              jsr   find_resource
4304 3E62 90 24                 bcc   standard_file
4305 3E64
4306 3E64              nuke_it                                 ;
4307 3E64 60                    rts   
4308 3E65
4309 3E65              not_resource                            ;
4310 3E65 C9 D0 00              cmp   #subdir_type
4311 3E68 90 1E                 bcc   standard_file
4312 3E6A
4313 3E6A A9 02 80              lda   #in_cache
4314 3E6D 85 1A                 sta   drvr_cache
4315 3E6F
4316 3E6F A0 09 00              ldy   #fcr_key_blk             ;key block of the file
4317 3E72 B7 90                 lda   [pro_fcr_ptr],y
4318 3E74 85 10                 sta   drvr_blk_num
4319 3E76
4320 3E76 A6 B0                 ldx   data_ptr
4321 3E78 A4 B2                 ldy   data_ptr+2
4322 3E7A 20 DD 3E              jsr   load_io_blk              ;store one block into the I/O buffer
4323 3E7D B0 E5                 bcs   nuke_it
4324 3E7F
4325 3E7F A0 37 00              ldy   #data_blk_num
4326 3E82 A5 10                 lda   drvr_blk_num
4327 3E84 97 90                 sta   [pro_fcr_ptr],y
4328 3E86 18                    clc   
4329 3E87 60                    rts   
4330 3E88
4331 3E88              standard_file                           ;
4332 3E88 A0 09 00              ldy   #fcr_key_blk
4333 3E8B B7 90                 lda   [pro_fcr_ptr],y
4334 3E8D 85 10                 sta   drvr_blk_num
4335 3E8F
4336 3E8F AD 3E 05              lda   storage_type
4337 3E92 C9 30 00              cmp   #tree_type
4338 3E95 D0 18                 bne   chk_sapling
4339 3E97
4340 3E97 A6 B8                 ldx   master_ptr
4341 3E99 A4 BA                 ldy   master_ptr+2
4342 3E9B 20 DD 3E              jsr   load_io_blk
4343 3E9E 90 01                 bcc   master_loaded
4344 3EA0 60                    rts   
4345 3EA1
4346 3EA1              master_loaded                           ;
4347 3EA1 A0 3B 00              ldy   #master_blk_num
4348 3EA4 A5 10                 lda   drvr_blk_num             ;save the block num of the master block
4349 3EA6 97 90                 sta   [pro_fcr_ptr],y
4350 3EA8 20 E5 3E              jsr   get_first_index          ;load the address of the first index blk
4351 3EAB 85 10                 sta   drvr_blk_num
4352 3EAD 80 05                 bra   load_index
4353 3EAF
4354 3EAF              chk_sapling                             ;
4355 3EAF C9 20 00              cmp   #sapling_type
4356 3EB2 D0 16                 bne   do_seedling
4357 3EB4
4358 3EB4              load_index                              ;
4359 3EB4 A6 B4                 ldx   index_ptr
4360 3EB6 A4 B6                 ldy   index_ptr+2
4361 3EB8 20 DD 3E              jsr   load_io_blk              ;load in the index block
4362 3EBB 90 01                 bcc   cont_index
4363 3EBD 60                    rts   
4364 3EBE
4365 3EBE              cont_index                              ;
4366 3EBE A0 39 00              ldy   #index_blk_num
4367 3EC1 A5 10                 lda   drvr_blk_num             ;save the block num of the index block
4368 3EC3 97 90                 sta   [pro_fcr_ptr],y
4369 3EC5 20 E5 3E              jsr   get_first_index          ;load the address of the first index blk
4370 3EC8 85 10                 sta   drvr_blk_num
4371 3ECA
4372 3ECA              do_seedling                             ;
4373 3ECA A6 B0                 ldx   data_ptr
4374 3ECC A4 B2                 ldy   data_ptr+2
4375 3ECE 20 DD 3E              jsr   load_io_blk              ;load in the seedling block
4376 3ED1 90 01                 bcc   cont_data
4377 3ED3 60                    rts   
4378 3ED4
4379 3ED4              cont_data                               ;
4380 3ED4 A0 37 00              ldy   #data_blk_num
4381 3ED7 A5 10                 lda   drvr_blk_num
4382 3ED9 97 90                 sta   [pro_fcr_ptr],y
4383 3EDB 18                    clc   
4384 3EDC 60                    rts                            ;return to user in happy camper mode
4385 3EDD
4386 3EDD              ;==========================================================================
4387 3EDD              ;this routine will read into the buffer pointed to by X and Y the block
4388 3EDD              ;number countained in drvr_blk_num.
4389 3EDD              ;==========================================================================
4390 3EDD
4391 3EDD              load_io_blk   
4392 3EDD 86 04                 stx   drvr_buf_ptr
4393 3EDF 84 06                 sty   drvr_buf_ptr+2           ;save the pointer to the buffer
4394 3EE1 20 95 17              jsr   read_with_cache
4395 3EE4 60                    rts   
4396 3EE5
4397 3EE5              ;==========================================================================
4398 3EE5              ;This routine will load into the accumulator the first block address from
4399 3EE5              ;an index block.
4400 3EE5              ;==========================================================================
4401 3EE5              get_first_index  
4402 3EE5                       longa off
4403 3EE5 E2 20                 sep   #$20
4404 3EE7 A0 00 01              ldy   #blk_size/2
4405 3EEA B7 04                 lda   [drvr_buf_ptr],y
4406 3EEC EB                    xba   
4407 3EED A7 04                 lda   [drvr_buf_ptr]
4408 3EEF                       longa on
4409 3EEF C2 20                 rep   #$20
4410 3EF1 60                    rts   
4411 3EF2
4412 3EF2                       ENDP 
4413 3EF2
4414 3EF2
4415 3EF2
4416 3EF2              ;==========================================================================
4417 3EF2              ;set_fcr_status This routine will set bits in the FCR pointed to by
4418 3EF2              ;               'pro_fcr_ptr'
4419 3EF2              ;
4420 3EF2              ;Input:         A = ORA Mask
4421 3EF2              ;
4422 3EF2              ;OutPut:        Operation complete
4423 3EF2              ;
4424 3EF2              ;Uses:          A and Y registers
4425 3EF2              ;==========================================================================
4426 3EF2
4427 3EF2                       EXPORT set_fcr_status
4428 3EF2              set_fcr_status PROC 
4429 3EF2
4430 3EF2 A0 1F 00              ldy   #fcr_status
4431 3EF5 17 90                 ora   [pro_fcr_ptr],y
4432 3EF7 97 90                 sta   [pro_fcr_ptr],y
4433 3EF9 60                    rts   
4434 3EFA                       ENDP 
4435 3EFA
4436 3EFA              ;========================================================================== 
4437 3EFA              ;find_resource: This routine will read in the key block of a resource file
4438 3EFA              ;               and locate the resource fork.  If the resource is available
4439 3EFA              ;               then this routine will replace the following fields in the fcr:
4440 3EFA              ;
4441 3EFA              ;                       1) fst_key_blk  := Key block of the resource
4442 3EFA              ;                       2) blocks used  := blocks used by the resource
4443 3EFA              ;                       3) fst_eof      := eof of resource
4444 3EFA              ;                       4) storage_type := storage type of the resource
4445 3EFA              ;
4446 3EFA              ;Input:         drvr_blk_num = key block of resource file
4447 3EFA              ;
4448 3EFA              ;Output:        Carry Set if error otherwise clear
4449 3EFA              ; 
4450 3EFA              ;========================================================================== 
4451 3EFA
4452 3EFA                       EXPORT find_resource
4453 3EFA              find_resource PROC 
4454 3EFA
4455 3EFA              ;==========================================================================
4456 3EFA              ;Setup the system buffer as our temp work area
4457 3EFA              ;==========================================================================
4458 3EFA
4459 3EFA AD EB 02              lda   gbuf_addr                ;address of systems work buffer
4460 3EFD 85 04                 sta   drvr_buf_ptr
4461 3EFF AD ED 02              lda   gbuf_addr+2
4462 3F02 85 06                 sta   drvr_buf_ptr+2
4463 3F04
4464 3F04 A9 02 80              lda   #in_cache                ;go ahead and store this block in cache
4465 3F07 85 1A                 sta   drvr_cache
4466 3F09 20 D0 17              jsr   device_call
4467 3F0C 20 FC 10              jsr   set_user_cache           ;restore user's cache value
4468 3F0F 90 01                 bcc   got_res_header
4469 3F11 60                    rts                            ;return error to caller
4470 3F12
4471 3F12              got_res_header                          ;
4472 3F12
4473 3F12              ;==========================================================================
4474 3F12              ;open the correct fork.
4475 3F12              ;==========================================================================
4476 3F12
4477 3F12 AD B9 05              lda   resource_num             ;calculate the resource
4478 3F15 EB                    xba                            ;convert $0000 or $0001 into
4479 3F16 A8                    tay                            ;$0000 or $0100
4480 3F17
4481 3F17              ;==========================================================================
4482 3F17              ;Now we load the storage type, key block and eof
4483 3F17              ;==========================================================================
4484 3F17
4485 3F17 B7 04                 lda   [drvr_buf_ptr],y 
4486 3F19 29 03 00              and   #$0003                   ;clear resource bits
4487 3F1C F0 05                 beq   bad_resource
4488 3F1E C9 04 00              cmp   #(tree_type/$10)+1
4489 3F21 90 05                 bcc   get_key_blk              ;storage type ok
4490 3F23
4491 3F23              bad_resource                            ;
4492 3F23 A9 63 00              lda   #res_not_found           ;the file is damaged
4493 3F26 38                    sec   
4494 3F27 60                    rts   
4495 3F28
4496 3F28              get_key_blk                             ;
4497 3F28 0A                    asl   a                        ;convert $1,$2,$3 to $10,$20,$30
4498 3F29 0A                    asl   a
4499 3F2A 0A                    asl   a
4500 3F2B 0A                    asl   a
4501 3F2C 8D 3E 05              sta   storage_type
4502 3F2F
4503 3F2F C8                    iny                            ;now get the key block
4504 3F30 B7 04                 lda   [drvr_buf_ptr],y
4505 3F32 F0 EF                 beq   bad_resource
4506 3F34 8D 69 05              sta   files_key_block
4507 3F37 C8                    iny   
4508 3F38 C8                    iny   
4509 3F39
4510 3F39              ;==========================================================================
4511 3F39              ;Now get the total blocks used field
4512 3F39              ;==========================================================================
4513 3F39
4514 3F39 B7 04                 lda   [drvr_buf_ptr],y
4515 3F3B 8D 54 05              sta   one_entry+blks_used_index
4516 3F3E BB                    tyx   
4517 3F3F A0 0B 00              ldy   #fcr_blks_used
4518 3F42 97 90                 sta   [pro_fcr_ptr],y
4519 3F44 A0 2D 00              ldy   #fcr_blks_alloc
4520 3F47 97 90                 sta   [pro_fcr_ptr],y
4521 3F49 9B                    txy   
4522 3F4A C8                    iny   
4523 3F4B C8                    iny   
4524 3F4C
4525 3F4C              ;==========================================================================
4526 3F4C              ;Now load the new EOF for the resource. (EOF = three bytes)
4527 3F4C              ;==========================================================================
4528 3F4C
4529 3F4C B7 04                 lda   [drvr_buf_ptr],y 
4530 3F4E 8D 56 05              sta   one_entry+eof_index
4531 3F51 AA                    tax                            ;low order 16 bits of resource
4532 3F52 C8                    iny   
4533 3F53 B7 04                 lda   [drvr_buf_ptr],y
4534 3F55 8D 57 05              sta   one_entry+eof_index+1
4535 3F58
4536 3F58              ;==========================================================================
4537 3F58              ;Now save the new EOF for this resource.
4538 3F58              ;==========================================================================
4539 3F58
4540 3F58 A0 0E 00              ldy   #fcr_eof+1
4541 3F5B 97 90                 sta   [pro_fcr_ptr],y
4542 3F5D A0 30 00              ldy   #fcr_curr_eof+1
4543 3F60
4544 3F60 97 90                 sta   [pro_fcr_ptr],y
4545 3F62 8A                    txa                            ;store low order 16 bits
4546 3F63 A0 0D 00              ldy   #fcr_eof
4547 3F66 97 90                 sta   [pro_fcr_ptr],y
4548 3F68 A0 2F 00              ldy   #fcr_curr_eof
4549 3F6B 97 90                 sta   [pro_fcr_ptr],y
4550 3F6D
4551 3F6D A0 02 00              ldy   #fcr_storage
4552 3F70 AD 3E 05              lda   storage_type
4553 3F73 97 90                 sta   [pro_fcr_ptr],y
4554 3F75
4555 3F75 A0 09 00              ldy   #fcr_key_blk
4556 3F78 AD 69 05              lda   files_key_block
4557 3F7B 97 90                 sta   [pro_fcr_ptr],y          ;save the key block as well
4558 3F7D
4559 3F7D 18                    clc   
4560 3F7E 60                    rts                            ;exit all happy now!!!
4561 3F7F
4562 3F7F                       ENDP 
4563 3F7F
4564 3F7F              ;======================================================================
4565 3F7F              ;check_vcr_first: This routine trys to find a vcr from the device number
4566 3F7F              ;               in 'A'.  If a vcr is found the no error is reported.
4567 3F7F              ;               otherwise the error is returned. 
4568 3F7F              ;
4569 3F7F              ;Created:       may 08, 1987
4570 3F7F              ;Modified:      may 08, 1987
4571 3F7F              ;Author:        Rob Turner
4572 3F7F              ;
4573 3F7F              ;
4574 3F7F              ;Enter:         from open call
4575 3F7F              ;
4576 3F7F              ;Input:         A = device number to find
4577 3F7F              ;               X = undefined
4578 3F7F              ;               Y = undefined
4579 3F7F              ;               P = nvmxdizc
4580 3F7F              ;                   ..000...
4581 3F7F              ;               b = k
4582 3F7F              ;
4583 3F7F              ;               dev_num                 ;device number we are looking for
4584 3F7F              ;
4585 3F7F              ;Output:        A = error code if carry set.
4586 3F7F              ;               X = undefined
4587 3F7F              ;               Y = undefined
4588 3F7F              ;               P = nvmxdizc
4589 3F7F              ;                   ..000..1 = error
4590 3F7F              ;                          0 = no error
4591 3F7F              ;               b = k
4592 3F7F              ;
4593 3F7F              ;Uses:          All registers
4594 3F7F              ;               find_vcr
4595 3F7F              ;               math_temp
4596 3F7F              ;               my_vcr_ptr
4597 3F7F              ;
4598 3F7F              ;======================================================================
4599 3F7F                       longa on
4600 3F7F                       longi on
4601 3F7F
4602 3F7F                       EXPORT check_vcr_first
4603 3F7F              check_vcr_first PROC 
4604 3F7F
4605 3F7F 64 AC                 stz   math_temp
4606 3F81              search_loop                             ;
4607 3F81 A5 AC                 lda   math_temp
4608 3F83 1A                    inc   a
4609 3F84 85 AC                 sta   math_temp
4610 3F86 22 60 FC 01           jsl   get_vcr
4611 3F8A 90 01                 bcc   good
4612 3F8C 60                    rts   
4613 3F8D
4614 3F8D              ;==========================================================================
4615 3F8D              ;If we find a vcr then make sure that I own it.
4616 3F8D              ;==========================================================================
4617 3F8D
4618 3F8D              good                                    ;
4619 3F8D 22 38 FC 01           jsl   deref
4620 3F91 86 84                 stx   my_vcr_ptr
4621 3F93 84 86                 sty   my_vcr_ptr+2
4622 3F95 A0 0A 00              ldy   #vcr_fst_id
4623 3F98 B7 84                 lda   [my_vcr_ptr],y
4624 3F9A C9 01 00              cmp   #pro_id
4625 3F9D D0 E2                 bne   search_loop
4626 3F9F
4627 3F9F A0 0C 00              ldy   #vcr_dev                 ;is this the correct device
4628 3FA2 B7 84                 lda   [my_vcr_ptr],y
4629 3FA4 C5 36                 cmp   dev_num
4630 3FA6 D0 D9                 bne   search_loop
4631 3FA8
4632 3FA8 A0 06 00              ldy   #vcr_status
4633 3FAB B7 84                 lda   [my_vcr_ptr],y
4634 3FAD 29 00 40              and   #vcr_swapped
4635 3FB0 D0 02                 bne   do_mount
4636 3FB2 18                    clc                            ;this is it.
4637 3FB3 60                    rts   
4638 3FB4
4639 3FB4              do_mount                                ;
4640 3FB4 20 2E 14              jsr   mount_volume
4641 3FB7 60                    rts   
4642 3FB8
4643 3FB8                       ENDP 
4644 3FB8              ;==========================================================================
4645 3FB8              ;Read:          This file contains code used to read data from a file.
4646 3FB8              ;               The types of files supported are:
4647 3FB8              ;
4648 3FB8              ;                       1) seedling
4649 3FB8              ;                       2) sapling
4650 3FB8              ;                       3) tree
4651 3FB8              ;                       4) directory
4652 3FB8              ;
4653 3FB8              ;Created:       May 16, 1987
4654 3FB8              ;Modified:      Apr 16, 1988
4655 3FB8              ;Author:        Rob Turner
4656 3FB8              ;
4657 3FB8              ;Enter:         jml
4658 3FB8              ;
4659 3FB8              ;Input:         A = undefined
4660 3FB8              ;               X = call number times 2
4661 3FB8              ;               Y = class times 2
4662 3FB8              ;               P = nvmxdizc
4663 3FB8              ;                   ..000...
4664 3FB8              ;               b = k
4665 3FB8              ;
4666 3FB8              ;Output:        A = error code if carry set
4667 3FB8              ;               X = undefined
4668 3FB8              ;               Y = undefined
4669 3FB8              ;               P = nvmxdizc
4670 3FB8              ;                   ..000..1 = error
4671 3FB8              ;                          0 = no error
4672 3FB8              ;               b = k
4673 3FB8              ;
4674 3FB8              ;Uses:          All registers
4675 3FB8              ;               Device Dispatcher  (subroutine)
4676 3FB8              ;               General I/O Buffer (1K buffer, I read 512 bytes)
4677 3FB8              ;               and lots of other stuff to.
4678 3FB8              ;
4679 3FB8              ;Call Format:
4680 3FB8              ;
4681 3FB8              ;Class 0        Reference Number        (2 Bytes)
4682 3FB8              ;               Pointer to Data Buffer  (4 Bytes)
4683 3FB8              ;               Request Count           (4 Bytes)
4684 3FB8              ;               Transfer Count          (4 Bytes)
4685 3FB8              ;
4686 3FB8              ;Class 1        PCount                  (2 Bytes)
4687 3FB8              ;               Reference Number        (2 Bytes)
4688 3FB8              ;               Pointer to Data Buffer  (4 Bytes)
4689 3FB8              ;               Request Count           (4 Bytes)
4690 3FB8              ;               Transfer Count          (4 Bytes)
4691 3FB8              ;               Cache Priority          (2 Bytes)
4692 3FB8              ;
4693 3FB8              ;==========================================================================
4694 3FB8                       longa on
4695 3FB8                       longi on
4696 3FB8
4697 3FB8                       EXPORT read
4698 3FB8              read     PROC 
4699 3FB8
4700 3FB8 A9 02 00              lda   #drvr_read               ;setup for device read
4701 3FBB 85 02                 sta   drvr_call_num
4702 3FBD
4703 3FBD              ;==========================================================================
4704 3FBD              ;sets up parameters from GS/OS call block, and verifies class and max pcnt
4705 3FBD              ;
4706 3FBD              ;setup params returns the class in the Accumulator.  It also does the
4707 3FBD              ;load as the last instruction before the 'RTS'
4708 3FBD              ;==========================================================================
4709 3FBD
4710 3FBD 20 9E 0E              jsr   setup_params
4711 3FC0 20 5A 16              jsr   read_write_setup
4712 3FC3
4713 3FC3              ;==========================================================================
4714 3FC3              ;Go and get the newline length from the FCR and save it on zero page.
4715 3FC3              ;==========================================================================
4716 3FC3 9C 7F 05              stz   newline_len              ;disable newline mode please
4717 3FC6
4718 3FC6              ;==========================================================================
4719 3FC6              ;We need to get the mask as well as the newline list pointer
4720 3FC6              ;==========================================================================
4721 3FC6 A0 12 00              ldy   #fcr_mask
4722 3FC9 B7 8C                 lda   [my_fcr_ptr],y
4723 3FCB 8D 81 05              sta   newline_mask
4724 3FCE F0 1D                 beq   no_newline
4725 3FD0
4726 3FD0 A0 10 00              ldy   #fcr_newline_len
4727 3FD3 B7 8C                 lda   [my_fcr_ptr],y
4728 3FD5 8D 7F 05              sta   newline_len
4729 3FD8 F0 13                 beq   no_newline               ;ok I like this read
4730 3FDA
4731 3FDA              ;==========================================================================
4732 3FDA              ;Since newline is enabled we must dereference the newline VP and save it
4733 3FDA              ;==========================================================================
4734 3FDA
4735 3FDA A0 0C 00              ldy   #fcr_newline
4736 3FDD B7 8C                 lda   [my_fcr_ptr],y
4737 3FDF AA                    tax   
4738 3FE0 C8                    iny   
4739 3FE1 C8                    iny   
4740 3FE2 B7 8C                 lda   [my_fcr_ptr],y
4741 3FE4 A8                    tay   
4742 3FE5 22 38 FC 01           jsl   deref
4743 3FE9 86 C8                 stx   newline_ptr
4744 3FEB 84 CA                 sty   newline_ptr+2
4745 3FED
4746 3FED              ;==========================================================================
4747 3FED              ;When we finally get here we are thru with setting up the newline list
4748 3FED              ;==========================================================================
4749 3FED
4750 3FED              no_newline                              ;
4751 3FED A0 0C 00              ldy   #vcr_dev
4752 3FF0 B7 84                 lda   [my_vcr_ptr],y
4753 3FF2 85 00                 sta   drvr_dev_num
4754 3FF4
4755 3FF4              ;==========================================================================
4756 3FF4              ;Just to be complete I guess I should check if the file is read enabled.
4757 3FF4              ;==========================================================================
4758 3FF4
4759 3FF4 A0 14 00              ldy   #fcr_access              ;check the user's access privs.
4760 3FF7 B7 8C                 lda   [my_fcr_ptr],y
4761 3FF9 29 FF 3F              and   #ClrAllButAccess
4762 3FFC C9 02 00              cmp   #write_access            ;does the file have write only access?
4763 3FFF D0 07                 bne   i_can_read               ;read is allowed
4764 4001
4765 4001 A9 4E 00              lda   #invalid_access
4766 4004              error_out                               ;
4767 4004 38                    sec   
4768 4005 4C 82 00              jmp   main_exit
4769 4008
4770 4008
4771 4008              I_can_read                              ;
4772 4008
4773 4008              ;==========================================================================
4774 4008              ;Now we need to move some variables from the FCR to zero page.
4775 4008              ;We do this just to make it easy to get to the variables.
4776 4008              ;
4777 4008              ;First lets move the current file marker and EOF to direct page
4778 4008              ;==========================================================================
4779 4008
4780 4008 20 97 45              jsr   setup_curr_mark
4781 400B 20 A7 45              jsr   setup_curr_eof
4782 400E
4783 400E              ;==========================================================================
4784 400E              ;Now lets see if we are at the end of the file.
4785 400E              ;IF curr_mark = EOF THEN return EOF error
4786 400E              ;==========================================================================
4787 400E
4788 400E AD C1 05              lda   curr_mark+2
4789 4011 CD C5 05              cmp   curr_eof+2
4790 4014 90 0D                 bcc   not_eof
4791 4016 AD BF 05              lda   curr_mark
4792 4019 CD C3 05              cmp   curr_eof
4793 401C D0 05                 bne   not_eof
4794 401E
4795 401E A9 4C 00              lda   #end_of_file             ;sorry no more bytes to read
4796 4021 80 E1                 bra   error_out
4797 4023
4798 4023              not_eof                                 ;
4799 4023
4800 4023              ;==========================================================================
4801 4023              ;OK go and get the storage type for the file
4802 4023              ;We use this field to determine how to read the file.
4803 4023              ;==========================================================================
4804 4023
4805 4023 A0 02 00              ldy   #fcr_storage
4806 4026 B7 90                 lda   [pro_fcr_ptr],y
4807 4028 8D 3E 05              sta   storage_type
4808 402B
4809 402B 20 A7 1C              jsr   chk_swapped              ;mount the volume if needed
4810 402E 90 03                 bcc   disk_online
4811 4030 4C 82 00              jmp   main_exit
4812 4033              disk_online                             ;
4813 4033
4814 4033              ;==========================================================================
4815 4033              ;when we get here we have found the lost volume.  So we must reset our
4816 4033              ;flags and change our device number, in both the VCR and FCR
4817 4033              ;==========================================================================
4818 4033
4819 4033 A5 00                 lda   drvr_dev_num             ;new device number
4820 4035 A0 0C 00              ldy   #vcr_dev
4821 4038 97 84                 sta   [my_vcr_ptr],y           ;update VCR
4822 403A
4823 403A A0 06 00              ldy   #vcr_status
4824 403D B7 84                 lda   [my_vcr_ptr],y
4825 403F 29 FF BF              and   #vcr_swapped_in          ;set 'disk in' flag
4826 4042 97 84                 sta   [my_vcr_ptr],y
4827 4044
4828 4044              ;==========================================================================
4829 4044              ;Now the disk is ready to be talked to
4830 4044              ;==========================================================================
4831 4044
4832 4044              disk_in                                 ;
4833 4044
4834 4044              ;==========================================================================
4835 4044              ;Now we need to compare req_cnt to EOF.
4836 4044              ;
4837 4044              ;IF (req_count + curr_mark) > EOF THEN
4838 4044              ;    req_cnt := (EOF-curr_mark)
4839 4044              ;
4840 4044              ;NOTE: carry must be clear when we get here.
4841 4044              ;==========================================================================
4842 4044
4843 4044 AD BF 05              lda   curr_mark
4844 4047 6D CB 05              adc   user_req_cnt
4845 404A 85 AC                 sta   math_temp
4846 404C AD C1 05              lda   curr_mark+2
4847 404F 6D CD 05              adc   user_req_cnt+2
4848 4052
4849 4052 CD C5 05              cmp   curr_eof+2
4850 4055 90 1E                 bcc   not_greater              ;no problem with request count
4851 4057 D0 09                 bne   too_large
4852 4059 A5 AC                 lda   math_temp
4853 405B CD C3 05              cmp   curr_eof                 ;check lower 16 bits
4854 405E 90 15                 bcc   not_greater
4855 4060 F0 13                 beq   not_greater
4856 4062
4857 4062              too_large                               ;
4858 4062
4859 4062              ;==========================================================================
4860 4062              ;If the request is too large then we need to adjust the request count.
4861 4062              ;==========================================================================
4862 4062
4863 4062 38                    sec   
4864 4063 AD C3 05              lda   curr_eof
4865 4066 ED BF 05              sbc   curr_mark
4866 4069 8D CB 05              sta   user_req_cnt
4867 406C AD C5 05              lda   curr_eof+2
4868 406F ED C1 05              sbc   curr_mark+2
4869 4072 8D CD 05              sta   user_req_cnt+2
4870 4075
4871 4075              not_greater                             ;
4872 4075
4873 4075              ;==========================================================================
4874 4075              ;Lets stop here and take a brief look at the current file marker.
4875 4075              ;
4876 4075              ;Diagram:                  (A)            (B)            (C)
4877 4075              ;
4878 4075              ;     |               | $00 to $7F  | $00  to  $FF  | $000  to  $1FF  |
4879 4075              ;     |               |             |               |                 |
4880 4075              ;     | MUST BE ZERO  |<- master  ->|<-   index   ->|<- Byte index  ->|
4881 4075              ;     |_______________|_____________|_______________|_________________|
4882 4075              ;     | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | | |
4883 4075              ;     |_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|_|
4884 4075              ;     |               |               |               |               |
4885 4075              ;    3 2             2 4             1 6             0 8             0 0
4886 4075              ;
4887 4075              ;               (A) = Index into the master index block:
4888 4075              ;                       This value goes upto 127. This means that the total
4889 4075              ;                       number of index blocks that a file can contain is
4890 4075              ;                       127.
4891 4075              ;
4892 4075              ;               (B) = Index into the index block:
4893 4075              ;                       This value goes upto 255.  This means that there
4894 4075              ;                       can be upto 255 data blocks per index block.
4895 4075              ;
4896 4075              ;               (C) = index into the data block:
4897 4075              ;                       This value goes upto 512.  This means that there
4898 4075              ;                       can be upto 512 bytes of data in the data block.
4899 4075              ;
4900 4075              ;==========================================================================
4901 4075
4902 4075
4903 4075              ;==========================================================================
4904 4075              ;see if newline is enabled.  If it is not then call the fast routines.
4905 4075              ;otherwise fall into snell mode.
4906 4075              ;==========================================================================
4907 4075
4908 4075 AD 7F 05              lda   newline_len
4909 4078 F0 0B                 beq   fast_read                ;runs like a bat out of hell!
4910 407A 3A                    dec   a                        ;see if this is a single char newline
4911 407B D0 08                 bne   fast_read
4912 407D A7 C8                 lda   [newline_ptr]
4913 407F 29 FF 00              and   #$00FF                   ;clear garbage byte
4914 4082 8D 83 05              sta   newline_char
4915 4085
4916 4085                       EXPORT fast_read
4917 4085              fast_read                               ;
4918 4085
4919 4085              ;==========================================================================
4920 4085              ;If we get here we know that newline is disabled so we do not have to check
4921 4085              ;each character that we read.  This means that multiple blocks can be moved
4922 4085              ;into the user's buffer directly without having to go into the I/O buffer.
4923 4085              ;Note however that the last block is moved into the I/O buffer.
4924 4085              ;
4925 4085              ;before we can start sending multiply blocks we must empty the current
4926 4085              ;data block that is in our buffer.  If there are enough bytes to satisfy
4927 4085              ;the read request we just send the bytes and exit.
4928 4085              ;==========================================================================
4929 4085
4930 4085              single_block                            ;
4931 4085
4932 4085 20 37 41              jsr   send_partial
4933 4088 90 04                 bcc   fast_loop
4934 408A 18                    clc   
4935 408B 82 4F 00              brl   end_read_write           ;all done with read.
4936 408E
4937 408E              ;==========================================================================
4938 408E              ;First lets calculate how many bytes are left in this block.
4939 408E              ;==========================================================================
4940 408E
4941 408E              fast_loop                               ;
4942 408E AD CD 05              lda   user_req_cnt+2
4943 4091 D0 0B                 bne   do_seq_blks
4944 4093 AD CB 05              lda   user_req_cnt
4945 4096 C9 01 02              cmp   #blk_size+1
4946 4099 B0 03                 bcs   do_seq_blks
4947 409B
4948 409B 4C D9 40              jmp   send_last                ;we have less then 512 bytes left
4949 409E
4950 409E              do_seq_blks                             ;
4951 409E
4952 409E              ;==========================================================================
4953 409E              ;We know that the user still has more then 512 bytes to go before the read
4954 409E              ;request is satisfied.  So lets go and see if there are any sequential
4955 409E              ;blocks that we can read.  If there are no sequential blocks then we must
4956 409E              ;get the block address our selves and issue a read of one block.  This
4957 409E              ;of course makes mister happy face very sad since he will have to double
4958 409E              ;buffer.
4959 409E              ;==========================================================================
4960 409E AD 3E 05              lda   storage_type
4961 40A1 C9 D0 00              cmp   #subdir_type
4962 40A4 B0 DF                 bcs   single_block
4963 40A6
4964 40A6 20 1B 45              jsr   num_seq_blks             ;see if there are any sequential blks
4965 40A9 F0 DA                 beq   single_block
4966 40AB
4967 40AB              seq_avail                               ;
4968 40AB
4969 40AB              ;==========================================================================
4970 40AB              ;when we get here we know that there are some sequential blocks that can
4971 40AB              ;be read.  But we must see if the number of sequential blocks is less then
4972 40AB              ;the number of blocks wanted.
4973 40AB              ;==========================================================================
4974 40AB
4975 40AB 86 10                 stx   drvr_blk_num             ;save block number for read
4976 40AD 1A                    inc   a
4977 40AE 85 AC                 sta   math_temp                ;number of sequential blocks avail.
4978 40B0
4979 40B0 64 08                 stz   drvr_req_cnt
4980 40B2 64 0A                 stz   drvr_req_cnt+2
4981 40B4 64 12                 stz   drvr_blk_num+2
4982 40B6
4983 40B6 AD CC 05              lda   user_req_cnt+1           ;first convert bytes wanted to blocks
4984 40B9 4A                    lsr   a
4985 40BA C5 AC                 cmp   math_temp
4986 40BC 90 02                 bcc   use_users_size
4987 40BE A5 AC                 lda   math_temp                ;use ALL sequential blocks.
4988 40C0
4989 40C0              use_users_size                          ;
4990 40C0
4991 40C0 0A                    asl   a                        ;convert block count to bytes
4992 40C1 85 09                 sta   drvr_req_cnt+1
4993 40C3
4994 40C3              ;==========================================================================
4995 40C3              ;Now setup the buffer pointer to point to the user's buffer.
4996 40C3              ;==========================================================================
4997 40C3
4998 40C3 A5 C0                 lda   users_buf_ptr
4999 40C5 85 04                 sta   drvr_buf_ptr
5000 40C7 A5 C2                 lda   users_buf_ptr+2
5001 40C9 85 06                 sta   drvr_buf_ptr+2
5002 40CB
5003 40CB 20 87 17              jsr   read_with_mount
5004 40CE 90 03                 bcc   cont001                  ;good.
5005 40D0 4C DD 40              jmp   end_read_write
5006 40D3
5007 40D3              cont001                                 ;
5008 40D3 20 BF 16              jsr   rw_adjust                ;adjust the following:
5009 40D6              ;                                       ;(1) user_buf_ptr
5010 40D6              ;                                       ;(2) tran_cnt
5011 40D6              ;                                       ;(3) curr_mark
5012 40D6              ;                                       ;(4) user_req_cnt
5013 40D6
5014 40D6 4C 8E 40              jmp   fast_loop
5015 40D9
5016 40D9              ;==========================================================================
5017 40D9              ;
5018 40D9              ;==========================================================================
5019 40D9
5020 40D9              send_last                               ;
5021 40D9 20 37 41              jsr   send_partial
5022 40DC 18                    clc   
5023 40DD
5024 40DD              ;==========================================================================
5025 40DD              ;===== END of READ call.  We save the processor status and error code =====
5026 40DD              ;=====                    We then send back the number of bytes that  =====
5027 40DD              ;=====                    were read successfully.  Then we restore any=====
5028 40DD              ;=====                    error condition and exit thru sys_exit.     =====
5029 40DD              ;==========================================================================
5030 40DD
5031 40DD                       EXPORT end_read_write
5032 40DD              end_read_write                          ;               ;common exit for read and write
5033 40DD 08                    php   
5034 40DE 48                    pha   
5035 40DF
5036 40DF A0 0A 00              ldy   #pblk_12_tran
5037 40E2 AD C7 05              lda   tran_cnt
5038 40E5 97 80                 sta   [my_pblk_ptr],y
5039 40E7 C8                    iny   
5040 40E8 C8                    iny   
5041 40E9 AD C9 05              lda   tran_cnt+2
5042 40EC 97 80                 sta   [my_pblk_ptr],y
5043 40EE
5044 40EE              ;==========================================================================
5045 40EE              ;Save the current file marker after the read call completes.
5046 40EE              ;==========================================================================
5047 40EE 20 B7 45              jsr   save_curr_mark
5048 40F1
5049 40F1 68                    pla   
5050 40F2 28                    plp   
5051 40F3 4C 82 00              jmp   main_exit
5052 40F6
5053 40F6              ;==========================================================================
5054 40F6              ;bump_mark      This routine will adjust the following fields:
5055 40F6              ;
5056 40F6              ;               1) users_buf_ptr        := users_buf_ptr + bytes_sent
5057 40F6              ;               2) curr_mark            := curr_mark + bytes_sent
5058 40F6              ;               3) user_req_cnt         := user_req_cnt - bytes_sent
5059 40F6              ;               4) tran_cnt             := tran_cnt+bytes_sent
5060 40F6              ;input:
5061 40F6              ;               A = number of bytes to bump fields by.
5062 40F6              ;
5063 40F6              ;Uses:          math_temp
5064 40F6              ;==========================================================================
5065 40F6
5066 40F6                       EXPORT bump_mark
5067 40F6              bump_mark                               ;
5068 40F6 85 AC                 sta   math_temp
5069 40F8 18                    clc   
5070 40F9 A5 C0                 lda   users_buf_ptr
5071 40FB 65 AC                 adc   math_temp
5072 40FD 85 C0                 sta   users_buf_ptr
5073 40FF
5074 40FF 90 03                 bcc   do_mark
5075 4101 E6 C2                 inc   users_buf_ptr+2
5076 4103 18                    clc   
5077 4104              do_mark                                 ;
5078 4104
5079 4104              ;==========================================================================
5080 4104              ;IMPORTANT NOTES:
5081 4104              ;
5082 4104              ;               users_buf_ptr is always =< $00FFFFFF
5083 4104              ;
5084 4104              ;WARNING! --> CARRY must be clear when we get here!
5085 4104              ;==========================================================================
5086 4104
5087 4104 AD BF 05              lda   curr_mark
5088 4107 65 AC                 adc   math_temp
5089 4109 8D BF 05              sta   curr_mark
5090 410C 90 04                 bcc   do_tran
5091 410E EE C1 05              inc   curr_mark+2
5092 4111 18                    clc   
5093 4112              do_tran                                 ;
5094 4112
5095 4112              ;==========================================================================
5096 4112              ;IMPORTANT NOTES:
5097 4112              ;
5098 4112              ;               curr_mark+math_temp is always less the $00FFFFFF
5099 4112              ;
5100 4112              ;WARNING! --> CARRY must be clear when we get here!
5101 4112              ;==========================================================================
5102 4112
5103 4112 AD C7 05              lda   tran_cnt
5104 4115 65 AC                 adc   math_temp
5105 4117 8D C7 05              sta   tran_cnt
5106 411A 90 03                 bcc   do_req_cnt
5107 411C EE C9 05              inc   tran_cnt+2
5108 411F
5109 411F              do_req_cnt                              ;
5110 411F 38                    sec   
5111 4120 AD CB 05              lda   user_req_cnt
5112 4123 E5 AC                 sbc   math_temp
5113 4125 8D CB 05              sta   user_req_cnt
5114 4128 B0 03                 bcs   end_bump
5115 412A CE CD 05              dec   user_req_cnt+2
5116 412D
5117 412D 60           end_bump rts   
5118 412E
5119 412E
5120 412E              ;==========================================================================
5121 412E              ;Set_users_buf  This routine moves the users buffer pointer into
5122 412E              ;               drvr_buf_ptr.  This allows block read from a device driver
5123 412E              ;               to go directly to the users buffer.
5124 412E              ;==========================================================================
5125 412E
5126 412E              set_users_buf                           ;
5127 412E A5 C0                 lda   users_buf_ptr            ;bypass my I/O buffer
5128 4130 85 04                 sta   drvr_buf_ptr
5129 4132 A5 C2                 lda   users_buf_ptr+2
5130 4134 85 06                 sta   drvr_buf_ptr+2
5131 4136 60                    rts   
5132 4137                       ENDP 
5133 4137
5134 4137              ;==========================================================================
5135 4137              ;send_partial   This routine will send data from the current file marker to
5136 4137              ;               the end of the data buffer.
5137 4137              ;
5138 4137              ;Input:         A = undefined
5139 4137              ;               X = indefined
5140 4137              ;               Y = undefined
5141 4137              ;               P = nvmxdizc
5142 4137              ;                   ..000...
5143 4137              ;               b = k
5144 4137              ;
5145 4137              ;               curr_mark               (must be correct)
5146 4137              ;
5147 4137              ;Output:        A = undefined
5148 4137              ;               X = undefined
5149 4137              ;               Y = undefined
5150 4137              ;               P = nvmxdizc
5151 4137              ;                   ..000..1 = data transfer complete
5152 4137              ;                          0 = no error
5153 4137              ;               b = k
5154 4137              ;
5155 4137              ;Uses:          All registers
5156 4137              ;               move_block
5157 4137              ;==========================================================================
5158 4137
5159 4137                       EXPORT send_partial
5160 4137              send_partial PROC 
5161 4137
5162 4137              ;==========================================================================
5163 4137              ;first make sure the I/O buffer is filled to the brim.
5164 4137              ;==========================================================================
5165 4137
5166 4137 20 50 42              jsr   fill_io_buf
5167 413A 90 03                 bcc   filled_up                ;buffer is now ok
5168 413C 4C DD 40              jmp   end_read_write
5169 413F
5170 413F              ;==========================================================================
5171 413F              ;lets see how many bytes are left in the currently loaded data block.
5172 413F              ;==========================================================================
5173 413F
5174 413F              filled_up                               ;
5175 413F AD BF 05              lda   curr_mark
5176 4142 29 FF 01              and   #$01FF
5177 4145 85 AC                 sta   math_temp
5178 4147 38                    sec   
5179 4148 A9 00 02              lda   #blk_size                ;Bytes_left := buf_size-curr_position
5180 414B E5 AC                 sbc   math_temp
5181 414D
5182 414D 85 AC                 sta   math_temp                ;number of bytes left in buffer.
5183 414F
5184 414F              ;==========================================================================
5185 414F              ;now lets calculate how many bytes we need to send to the user
5186 414F              ;==========================================================================
5187 414F
5188 414F AE CD 05              ldx   user_req_cnt+2
5189 4152 D0 0A                 bne   send_all_bytes           ;he wants as many as I can give
5190 4154 CD CB 05              cmp   user_req_cnt
5191 4157 F0 05                 beq   send_all_bytes
5192 4159 90 03                 bcc   send_all_bytes
5193 415B
5194 415B AD CB 05              lda   user_req_cnt             ;the user wants less then I have
5195 415E
5196 415E              send_all_bytes                          ;
5197 415E 85 AC                 sta   math_temp
5198 4160 A8                    tay   
5199 4161
5200 4161              ;==========================================================================
5201 4161              ;If newline is enabled then we have to do processing on each character
5202 4161              ;so we avoid the block move routine.
5203 4161              ;==========================================================================
5204 4161
5205 4161 AD 7F 05              lda   newline_len
5206 4164 D0 71                 bne   check_newline
5207 4166
5208 4166              ;==========================================================================
5209 4166              ;If we get here then newline is disabled so use the block move instruction
5210 4166              ;==========================================================================
5211 4166
5212 4166 18                    clc   
5213 4167 AD BF 05              lda   curr_mark                ;adjust the starting position
5214 416A 29 FF 01              and   #$01FF
5215 416D 65 B0                 adc   data_ptr
5216 416F AA                    tax                            ;save low address of buf pointer
5217 4170 A9 00 00              lda   #$0000
5218 4173 65 B2                 adc   data_ptr+2
5219 4175
5220 4175 C0 21 00              cpy   #min_send_cnt            ;minimum bytes needed to use blk move
5221 4178 90 13                 bcc   send_small
5222 417A
5223 417A 48                    pha                            ;push high word of buffer pointer
5224 417B DA                    phx                            ;push low word of buffer pointer
5225 417C
5226 417C D4 C2                 pei   users_buf_ptr+2          ;destination address
5227 417E D4 C0                 pei   users_buf_ptr
5228 4180 F4 00 00              pea   $0000                    ;high word of count
5229 4183 5A                    phy                            ;number of bytes to send
5230 4184 F4 05 08              pea   move_sinc_dinc
5231 4187 22 70 FC 01           jsl   move_info
5232 418B 80 27                 bra   end_partial
5233 418D
5234 418D              ;==========================================================================
5235 418D              ;This routine will transfer a request count of less than $20 characters to
5236 418D              ;the user's buffer.  We do this to speed things up.
5237 418D              ;==========================================================================
5238 418D
5239 418D              send_small                              ;
5240 418D 86 98                 stx   temp_ptr
5241 418F 85 9A                 sta   temp_ptr+2               ;pointer to the user's buffer
5242 4191 88                    dey   
5243 4192 98                    tya   
5244 4193 30 1F                 bmi   end_partial              ;zero bytes to move?
5245 4195 C9 02 00              cmp   #$0002                   ;are we moving less then two bytes?
5246 4198 90 0F                 bcc   send_8_bit
5247 419A 3A                    dec   a                        ;second decrement for word check
5248 419B 6A                    ror   a                        ;is it an even transfer?
5249 419C B0 0B                 bcs   send_8_bit
5250 419E 88                    dey   
5251 419F              loop_16                                 ;
5252 419F B7 98                 lda   [temp_ptr],y
5253 41A1 97 C0                 sta   [users_buf_ptr],y
5254 41A3 88                    dey   
5255 41A4 88                    dey   
5256 41A5 10 F8                 bpl   loop_16
5257 41A7 80 0B                 bra   end_partial
5258 41A9
5259 41A9              send_8_bit                              ;
5260 41A9 E2 20                 sep   #$20                     ;8 bit accum
5261 41AB              loop_8                                  ;
5262 41AB B7 98                 lda   [temp_ptr],y
5263 41AD 97 C0                 sta   [users_buf_ptr],y
5264 41AF 88                    dey   
5265 41B0 10 F9                 bpl   loop_8
5266 41B2 C2 20                 rep   #$20
5267 41B4
5268 41B4              ;==========================================================================
5269 41B4              ;Now that we have send the data adjust the pointers etc.
5270 41B4              ;==========================================================================
5271 41B4
5272 41B4              end_partial   
5273 41B4 A5 AC                 lda   math_temp
5274 41B6 20 F6 40              jsr   bump_mark
5275 41B9 AD CB 05              lda   user_req_cnt
5276 41BC 0D CD 05              ora   user_req_cnt+2
5277 41BF F0 14                 beq   all_done                 ;request count satisfied
5278 41C1
5279 41C1 A0 1F 00              ldy   #fcr_status              ;we are going to read another block so make sure
5280 41C4 B7 90                 lda   [pro_fcr_ptr],y          ;the I/O buffer is clean
5281 41C6 29 00 80              and   #file_dirty
5282 41C9 F0 08                 beq   @not_dirty
5283 41CB 20 6E 18              jsr   flush_io_buffer          ;write the dirty blocks to disk
5284 41CE 90 03                 bcc   @not_dirty
5285 41D0 4C 82 00              jmp   main_exit
5286 41D3
5287 41D3              @not_dirty   
5288 41D3 18                    clc   
5289 41D4 60                    rts   
5290 41D5
5291 41D5              all_done   
5292 41D5 38                    sec   
5293 41D6 60                    rts   
5294 41D7
5295 41D7              ;==========================================================================
5296 41D7              ;Below is the code used to handle the newline checking.  For this code we
5297 41D7              ;set the accumulator into 8 bit mode so we do not overflow the user's
5298 41D7              ;buffer.
5299 41D7              ;==========================================================================
5300 41D7
5301 41D7              check_newline                           ;
5302 41D7 AA                    tax                            ;save newline length for a second
5303 41D8
5304 41D8 AD BF 05              lda   curr_mark                ;isolate block index
5305 41DB 29 FF 01              and   #$01FF
5306 41DE A8                    tay   
5307 41DF
5308 41DF 8D CF 05              sta   entries_checked
5309 41E2 38                    sec   
5310 41E3 A5 C0                 lda   users_buf_ptr
5311 41E5 ED CF 05              sbc   entries_checked
5312 41E8 85 98                 sta   temp_ptr
5313 41EA A5 C2                 lda   users_buf_ptr+2
5314 41EC E9 00 00              sbc   #$0000
5315 41EF 85 9A                 sta   temp_ptr+2
5316 41F1
5317 41F1 18                    clc   
5318 41F2 98                    tya   
5319 41F3 65 AC                 adc   math_temp                ;calculate the last byte address
5320 41F5 8D CF 05              sta   entries_checked
5321 41F8
5322 41F8
5323 41F8 CA                    dex                            ;see if this is a special case
5324 41F9 D0 31                 bne   slow_read
5325 41FB 08                    php                            ;save the mode please
5326 41FC                       longa off
5327 41FC E2 20                 sep   #$20                     ;short accumulator
5328 41FE
5329 41FE              fast_newline                            ;
5330 41FE B7 B0                 lda   [data_ptr],y
5331 4200 97 98                 sta   [temp_ptr],y
5332 4202 2D 81 05              and   newline_mask
5333 4205 CD 83 05              cmp   newline_char
5334 4208 F0 09                 beq   found_newline
5335 420A C8                    iny   
5336 420B CC CF 05              cpy   entries_checked          ;are we done yet
5337 420E D0 EE                 bne   fast_newline
5338 4210 28                    plp                            ;be nice and restore last mode please.
5339 4211 80 A1                 bra   end_partial
5340 4213
5341 4213              found_newline                           ;
5342 4213 28                    plp                            ;restore last mode please
5343 4214                       longa on
5344 4214
5345 4214              ;==========================================================================
5346 4214              ;Number of bytes := Ending position minus starting position
5347 4214              ;               Y = ending position
5348 4214              ;       curr_mark = starting position
5349 4214              ;==========================================================================
5350 4214
5351 4214 AD BF 05              lda   curr_mark
5352 4217 29 FF 01              and   #$01FF
5353 421A 85 AC                 sta   math_temp
5354 421C 38                    sec   
5355 421D 98                    tya   
5356 421E E5 AC                 sbc   math_temp
5357 4220 1A                    inc   a
5358 4221 20 F6 40              jsr   bump_mark                ;adjust the pointers etc
5359 4224 9C CB 05              stz   user_req_cnt
5360 4227 9C CD 05              stz   user_req_cnt+2
5361 422A 38                    sec   
5362 422B 60                    rts   
5363 422C
5364 422C              ;==========================================================================
5365 422C              ;This routine is called when there is more then one newline character to
5366 422C              ;check.  This routine is slower then the above newline read since I have
5367 422C              ;to scan all newline characters against a list
5368 422C              ;==========================================================================
5369 422C
5370 422C              slow_read                               ; 
5371 422C
5372 422C              ;==========================================================================
5373 422C              ;newline_len := newline_len-1  So I can use it as an index into the newline
5374 422C              ;list.
5375 422C              ;==========================================================================
5376 422C
5377 422C              *** removed 13-Jul-92 DAL to make multi-character newline mode keep working across blocks
5378 422C              *** (newline_len was getting decremented farther and farther on each block...ouch!)
5379 422C              ;;;	dec	newline_len
5380 422C              *** end 13-Jul-92, part 1 of 2
5381 422C
5382 422C 08                    php   
5383 422D                       longa off
5384 422D E2 20                 sep   #$20
5385 422F
5386 422F              slow_newline                            ;
5387 422F B7 B0                 lda   [data_ptr],y
5388 4231 97 98                 sta   [temp_ptr],y
5389 4233 2D 81 05              and   newline_mask
5390 4236 BB                    tyx                            ;save index first
5391 4237 AC 7F 05              ldy   newline_len
5392 423A              *** added 13-Jul-92 DAL, because I took out a dec newline_len a few lines above
5393 423A 88                    dey   
5394 423B              *** end 13-Jul-92, part 2 of 2
5395 423B
5396 423B              next_newline                            ;
5397 423B D7 C8                 cmp   [newline_ptr],y
5398 423D F0 0E                 beq   found_one
5399 423F 88                    dey   
5400 4240 10 F9                 bpl   next_newline
5401 4242
5402 4242 9B                    txy                            ;restore index first
5403 4243 C8                    iny   
5404 4244 CC CF 05              cpy   entries_checked          ;are we done yet
5405 4247 D0 E6                 bne   slow_newline
5406 4249 28                    plp                            ;be nice and restore last mode please.
5407 424A 82 67 FF              brl   end_partial
5408 424D
5409 424D              found_one                               ;
5410 424D 9B                    txy                            ;restore Index first
5411 424E 80 C3                 bra   found_newline
5412 4250
5413 4250                       ENDP 
5414 4250
5415 4250
5416 4250              ;==========================================================================
5417 4250              ;fill_io_buf:   This routine will load into the I/O buffer the correct
5418 4250              ;               index and data blocks.  It will also adjust the FCR data
5419 4250              ;
5420 4250              ;               WARNING: curr_mark must not point beyond the current
5421 4250              ;               structure of the file, even though that mark may be within
5422 4250              ;               the file's EOF. This could happen if a file has a trailing
5423 4250              ;               portion which is all sparse from a position <128K to a
5424 4250              ;               position >128K. In this case the file is stored as a
5425 4250              ;               sapling, not a tree, but owns a sparse area that is
5426 4250              ;               logically within the "tree" range. In such a case,curr_mark
5427 4250              ;               must never be in that range when entering this routine.
5428 4250              ;
5429 4250              ;Input:         A = undefined
5430 4250              ;               X = indefined
5431 4250              ;               Y = undefined
5432 4250              ;               P = nvmxdizc
5433 4250              ;                   ..000...
5434 4250              ;               b = k
5435 4250              ;
5436 4250              ;               curr_mark               (must be correct)
5437 4250              ;               master_ptr              (must pointer to master index block)
5438 4250              ;               index_ptr               (must point to the correct index block)
5439 4250              ;               data_ptr
5440 4250              ;               pro_fcr_ptr             (points to prodos data in FCR)
5441 4250              ;
5442 4250              ;Output:        A = error code if carry set
5443 4250              ;               X = undefined
5444 4250              ;               Y = undefined
5445 4250              ;               P = nvmxdizc
5446 4250              ;                   ..000..1 = error
5447 4250              ;                          0 = no error
5448 4250              ;               b = k
5449 4250              ;
5450 4250              ;Uses:          All registers
5451 4250              ;               drvr_blk_num
5452 4250              ;               drvr_call_num
5453 4250              ;               drvr_buf_ptr
5454 4250              ;               drvr_req_cnt
5455 4250              ;               device_dispatcher
5456 4250              ;
5457 4250              ;
5458 4250              ;==========================================================================
5459 4250                       longa on
5460 4250                       longi on
5461 4250
5462 4250                       EXPORT fill_io_buf
5463 4250              fill_io_buf PROC 
5464 4250
5465 4250 9C 08 45              stz   data_flag                ;flag says load data block
5466 4253 80 06                 bra   fill_up
5467 4255
5468 4255                       EXPORT load_indexes
5469 4255              load_indexes                            ;
5470 4255 A9 FF FF              lda   #$FFFF                   ;flag says do not load data block
5471 4258 8D 08 45              sta   data_flag
5472 425B
5473 425B              fill_up                                 ;
5474 425B 9C 9D 05              stz   mark_changed
5475 425E 20 A7 45              jsr   setup_curr_eof
5476 4261
5477 4261 AD BF 05              lda   curr_mark                ;is the mark zero?
5478 4264 0D C1 05              ora   curr_mark+2
5479 4267 F0 22                 beq   mark_ok                  ;yes so don't subtract one
5480 4269
5481 4269 AD C1 05              lda   curr_mark+2
5482 426C CD C5 05              cmp   curr_eof+2               ;see if current mark = eof
5483 426F 90 1A                 bcc   mark_ok
5484 4271 AD BF 05              lda   curr_mark
5485 4274 CD C3 05              cmp   curr_eof
5486 4277 90 12                 bcc   mark_ok                  ;no problem
5487 4279
5488 4279 E9 01 00              sbc   #$0001                   ;curr_mark := curr_mark-1
5489 427C 8D BF 05              sta   curr_mark
5490 427F
5491 427F AD C1 05              lda   curr_mark+2
5492 4282 E9 00 00              sbc   #$0000
5493 4285 8D C1 05              sta   curr_mark+2
5494 4288
5495 4288 CE 9D 05              dec   mark_changed
5496 428B
5497 428B              mark_ok                                 ;
5498 428B 20 8D 15              jsr   standard_req             ;read 512 bytes only
5499 428E A0 02 00              ldy   #fcr_storage             ;see if this is a subdirectory.
5500 4291 B7 90                 lda   [pro_fcr_ptr],y
5501 4293 C9 D0 00              cmp   #subdir_type
5502 4296 90 07                 bcc   standard_file            ;File is not a directory
5503 4298 20 6D 44              jsr   fill_directory           ;fill it up bud!
5504 429B 20 B5 42              jsr   restore_mark             ;fix it if it was changed!
5505 429E 60                    rts                            ;return to caller
5506 429F
5507 429F
5508 429F              standard_file                           ;
5509 429F 20 C7 42              jsr   fill_index               ;fill up the index block
5510 42A2 90 01                 bcc   chk_data
5511 42A4 60                    rts                            ;major error
5512 42A5
5513 42A5              chk_data                                ;
5514 42A5 2C 08 45              bit   data_flag                ;'-' = fill index block only
5515 42A8 10 04                 bpl   do_data
5516 42AA 20 B5 42              jsr   restore_mark
5517 42AD 60                    rts   
5518 42AE
5519 42AE              do_data                                 ;
5520 42AE 20 AC 43              jsr   fill_data                ;fill the data buffer
5521 42B1 20 B5 42              jsr   restore_mark
5522 42B4 60                    rts                            ;exit
5523 42B5
5524 42B5              restore_mark                            ;
5525 42B5 08                    php                            ;save error flag
5526 42B6 48                    pha                            ;save error code
5527 42B7 2C 9D 05              bit   mark_changed
5528 42BA 10 08                 bpl   no_change
5529 42BC EE BF 05              inc   curr_mark
5530 42BF D0 03                 bne   no_change
5531 42C1 EE C1 05              inc   curr_mark+2
5532 42C4              no_change                               ;
5533 42C4 68                    pla   
5534 42C5 28                    plp   
5535 42C6 60                    rts   
5536 42C7
5537 42C7              ;==========================================================================
5538 42C7              ;Fill_index:    This routine will fill up the index block if it can.
5539 42C7              ;
5540 42C7              ;Below is pascal type segment which indicates how fill_index works.
5541 42C7              ;
5542 42C7              ;IF master = defined THEN
5543 42C7              ;   BEGIN
5544 42C7              ;     blk_num := get_blk_address(curr_mark) ; {Get block address from index blk}
5545 42C7              ;     IF blk_num = $0000 THEN
5546 42C7              ;        sparse_blk(index_buffer) ;      {Fill Index buffer with zeros}
5547 42C7              ;        ELSE
5548 42C7              ;         IF curr_blk <> blk_to_read THEN
5549 42C7              ;            read_blk(index_buffer) ;       {Load index block from disk}
5550 42C7              ;   END
5551 42C7              ;    ELSE                               {master undefined}
5552 42C7              ;     IF curr_mark > $20000 THEN
5553 42C7              ;        BEGIN
5554 42C7              ;          IF sapling = defined THEN
5555 42C7              ;             sparse_blk(index_buffer)  {fill index block to zeros}
5556 42C7              ;               ELSE
5557 42C7              ;                BEGIN
5558 42C7              ;                 sparse_blk(data_buffer) ; {force data block to zeros}
5559 42C7              ;                 data_flag := data_flag-1 {This forces the calling routine
5560 42C7              ;                                           to exit without loading the data
5561 42C7              ;                                           block, since I have already loaded
5562 42C7              ;                                           the blocks with zeros}
5563 42C7              ;                END
5564 42C7              ;        END
5565 42C7              ;
5566 42C7              ;               WARNING: curr_mark must not point beyond the current
5567 42C7              ;               structure of the file, even though that mark may be within
5568 42C7              ;               the file's EOF. This could happen if a file has a trailing
5569 42C7              ;               portion which is all sparse from a position <128K to a
5570 42C7              ;               position >128K. In this case the file is stored as a
5571 42C7              ;               sapling, not a tree, but owns a sparse area that is
5572 42C7              ;               logically within the "tree" range. In such a case,curr_mark
5573 42C7              ;               must never be in that range when entering this routine.
5574 42C7              ;
5575 42C7              ;==========================================================================
5576 42C7
5577 42C7              fill_index                              ; 
5578 42C7
5579 42C7 A0 1F 00              ldy   #fcr_status              ;see if the master index block is
5580 42CA B7 90                 lda   [pro_fcr_ptr],y          ;active
5581 42CC 29 00 10              and   #master_active
5582 42CF F0 7D                 beq   no_master                ;the master block is not defined
5583 42D1
5584 42D1 AD C1 05              lda   curr_mark+2              ;make an index into the index block
5585 42D4 4A                    lsr   a
5586 42D5 29 7F 00              and   #$007F
5587 42D8 A8                    tay   
5588 42D9 09 00 01              ora   #$0100                   ;build index for upper half of buffer
5589 42DC AA                    tax   
5590 42DD
5591 42DD B7 B8                 lda   [master_ptr],y
5592 42DF 85 10                 sta   drvr_blk_num
5593 42E1 9B                    txy   
5594 42E2 B7 B8                 lda   [master_ptr],y
5595 42E4 85 11                 sta   drvr_blk_num+1           ;save the block number to read
5596 42E6 64 12                 stz   drvr_blk_num+2
5597 42E8
5598 42E8 A5 10                 lda   drvr_blk_num             ;see if blk_num = $0000
5599 42EA F0 09                 beq   sparse_index
5600 42EC
5601 42EC A0 39 00              ldy   #index_blk_num           ;see if the block is already loaded
5602 42EF D7 90                 cmp   [pro_fcr_ptr],y
5603 42F1 D0 3F                 bne   load_index
5604 42F3 18                    clc   
5605 42F4 60                    rts                            ;no problem here
5606 42F5
5607 42F5              ;==========================================================================
5608 42F5              ;If Y=$0100 then we know that the master index block is not really active
5609 42F5              ;If it were active then there would be a real index block.  If this is the
5610 42F5              ;case then we should load in the index block if there is one available.
5611 42F5              ;==========================================================================
5612 42F5
5613 42F5              sparse_index                            ; 
5614 42F5 C0 00 01              cpy   #$0100                   ;If non-first index is sparse then
5615 42F8 D0 1A                 bne   zero_index               ;zero the index block
5616 42FA
5617 42FA A0 02 00              ldy   #fcr_storage             ;is there an index block to load?
5618 42FD B7 90                 lda   [pro_fcr_ptr],y
5619 42FF C9 20 00              cmp   #sapling_type
5620 4302 D0 2C                 bne   index_sparse             ;just exit no index to load
5621 4304
5622 4304 A0 09 00              ldy   #fcr_key_blk
5623 4307 B7 90                 lda   [pro_fcr_ptr],y
5624 4309 A0 39 00              ldy   #index_blk_num           ;see if the block is already loaded
5625 430C D7 90                 cmp   [pro_fcr_ptr],y
5626 430E F0 20                 beq   index_sparse             ;just exit since the block is loaded
5627 4310 85 10                 sta   drvr_blk_num
5628 4312 80 1E                 bra   load_index
5629 4314
5630 4314              zero_index                              ; 
5631 4314 20 8C 43              jsr   chk_index_clean          ;make sure the current block is not dirty
5632 4317 90 01                 bcc   @no_problem
5633 4319 60                    rts   
5634 431A              @no_problem  
5635 431A A0 39 00              ldy   #index_blk_num           ;see if the index block is sparse
5636 431D B7 90                 lda   [pro_fcr_ptr],y
5637 431F F0 0F                 beq   index_sparse             ;block is already sparse
5638 4321
5639 4321 A6 B4                 ldx   index_ptr
5640 4323 A4 B6                 ldy   index_ptr+2
5641 4325 20 0A 45              jsr   send_sparse_blk
5642 4328
5643 4328 A0 39 00              ldy   #index_blk_num
5644 432B A9 00 00              lda   #$0000
5645 432E 97 90                 sta   [pro_fcr_ptr],y          ;indicate index block loaded is sparse
5646 4330
5647 4330              index_sparse                            ; 
5648 4330 18                    clc   
5649 4331 60                    rts   
5650 4332
5651 4332              load_index                              ; 
5652 4332 20 8C 43              jsr   chk_index_clean          ;make sure the current block is not dirty
5653 4335 90 01                 bcc   @no_problem
5654 4337 60                    rts   
5655 4338              @no_problem  
5656 4338 A5 B4                 lda   index_ptr
5657 433A 85 04                 sta   drvr_buf_ptr
5658 433C A5 B6                 lda   index_ptr+2
5659 433E 85 06                 sta   drvr_buf_ptr+2
5660 4340 20 95 17              jsr   read_with_cache          ;read in the block please
5661 4343 90 01                 bcc   index_loaded
5662 4345 60                    rts   
5663 4346
5664 4346              index_loaded  
5665 4346 A0 39 00              ldy   #index_blk_num
5666 4349 A5 10                 lda   drvr_blk_num
5667 434B 97 90                 sta   [pro_fcr_ptr],y          ;update the loaded block number field
5668 434D 60                    rts   
5669 434E
5670 434E              ;==========================================================================
5671 434E              ;If we get here we know that there is no master index block defined.
5672 434E              ;==========================================================================
5673 434E              no_master   
5674 434E AD C1 05              lda   curr_mark+2              ;see if the mark > $20000
5675 4351 4A                    lsr   a
5676 4352 29 7F 00              and   #$007F
5677 4355 D0 02                 bne   index_pain
5678 4357 18                    clc   
5679 4358 60                    rts   
5680 4359
5681 4359              index_pain                              ;see if the index block is defined
5682 4359 64 10                 stz   drvr_blk_num
5683 435B 20 8C 43              jsr   chk_index_clean
5684 435E 90 01                 bcc   @its_clean
5685 4360 60                    rts                            ;return the error
5686 4361              @its_clean  
5687 4361 A0 1F 00              ldy   #fcr_status
5688 4364 B7 90                 lda   [pro_fcr_ptr],y
5689 4366 29 00 20              and   #index_active
5690 4369 D0 8A                 bne   sparse_index             ;make the index block all zeros
5691 436B
5692 436B              sparse_data  
5693 436B 20 4D 44              jsr   chk_data_clean           ;make sure the data block is OK 
5694 436E 90 01                 bcc   @good_data
5695 4370 60                    rts   
5696 4371              @good_data  
5697 4371 A0 37 00              ldy   #data_blk_num            ;see if the block is already sparse
5698 4374 B7 90                 lda   [pro_fcr_ptr],y
5699 4376 F0 0F                 beq   data_sparse              ;data block is alreay sparse
5700 4378
5701 4378 A6 B0                 ldx   data_ptr
5702 437A A4 B2                 ldy   data_ptr+2
5703 437C
5704 437C 20 0A 45              jsr   send_sparse_blk          ;make the data block sparse
5705 437F
5706 437F A0 37 00              ldy   #data_blk_num            ;see if the block is already sparse
5707 4382 A9 00 00              lda   #$0000                   ;indicate block is sparse
5708 4385 97 90                 sta   [pro_fcr_ptr],y
5709 4387
5710 4387              data_sparse                             ; 
5711 4387 CE 08 45              dec   data_flag                ;indicate to the main routine that the
5712 438A 18                    clc                            ;data block does not need checking
5713 438B 60                    rts   
5714 438C
5715 438C              ;==========================================================================
5716 438C              ;Chk_index_clean will determine if the current index block needs to be 
5717 438C              ;written to disk before the new block is loaded and will write it out if
5718 438C              ;necessary.
5719 438C              ;==========================================================================
5720 438C              chk_index_clean  
5721 438C 5A                    phy   
5722 438D A0 1F 00              ldy   #fcr_status              ;we are going to read another block so make sure
5723 4390 B7 90                 lda   [pro_fcr_ptr],y          ;the I/O buffer is clean
5724 4392 29 02 00              and   #index_dirty
5725 4395 F0 12                 beq   @not_dirty               ;easy case.
5726 4397
5727 4397 A5 10                 lda   drvr_blk_num             ;get the block number we want to load
5728 4399 A0 39 00              ldy   #index_blk_num           ;see if the block is already loaded
5729 439C D7 90                 cmp   [pro_fcr_ptr],y
5730 439E F0 09                 beq   @not_dirty               ;another easy case.
5731 43A0
5732 43A0 48                    pha                            ;save the driver block number
5733 43A1 20 B8 19              jsr   flush_index              ;save the data to disk
5734 43A4 FA                    plx                            ;get the drvr_blk_number back please
5735 43A5 86 10                 stx   drvr_blk_num
5736 43A7 7A                    ply   
5737 43A8 60                    rts                            ;carry will return any error
5738 43A9
5739 43A9              @not_dirty  
5740 43A9 7A                    ply   
5741 43AA 18                    clc   
5742 43AB 60                    rts   
5743 43AC
5744 43AC              ;==========================================================================
5745 43AC              ;Fill_data:     This routine will fill up the data block if it can.
5746 43AC              ;
5747 43AC              ;Below is pascal type segment which indicates how Fill_data works.
5748 43AC              ;
5749 43AC              ;IF index = defined THEN
5750 43AC              ;   BEGIN
5751 43AC              ;     blk_num := get_blk_address(curr_mark) ; {Get block address from index blk}
5752 43AC              ;     IF blk_num = $0000 THEN
5753 43AC              ;        sparse_blk(data_buffer) ;       {Fill Index buffer with zeros}
5754 43AC              ;        ELSE
5755 43AC              ;         IF curr_blk <> blk_to_read THEN
5756 43AC              ;            read_blk(index_buffer) ;    {Load index block from disk}
5757 43AC              ;    END
5758 43AC              ;     ELSE
5759 43AC              ;      IF curr_mark > $200 THEN
5760 43AC              ;         sparse_blk(data_buffer) ;      {Clear the data buffer}
5761 43AC              ;         ELSE
5762 43AC              ;           read_blk(key_block) ;        {main block for file}
5763 43AC              ;
5764 43AC              ;==========================================================================
5765 43AC
5766 43AC              fill_data                               ;
5767 43AC A0 1F 00              ldy   #fcr_status
5768 43AF B7 90                 lda   [pro_fcr_ptr],y
5769 43B1 29 00 20              and   #index_active
5770 43B4 F0 4D                 beq   no_index                 ;there is no index buffer
5771 43B6
5772 43B6 20 35 44              jsr   get_data_num             ;setup drvr_blk_num from index blk
5773 43B9
5774 43B9 A5 10                 lda   drvr_blk_num
5775 43BB D0 1F                 bne   not_sparse               ;make the data block sparse
5776 43BD C0 00 01              cpy   #$0100                   ;was it the 1st entry
5777 43C0 D0 A9                 bne   sparse_data              ;make data block sparse
5778 43C2
5779 43C2 AD C1 05              lda   curr_mark+2              ;see if the master index is zero
5780 43C5 4A                    lsr   a
5781 43C6 29 7F 00              and   #$007F
5782 43C9 D0 A0                 bne   sparse_data
5783 43CB
5784 43CB A0 02 00              ldy   #fcr_storage             ;is there an index block to load?
5785 43CE B7 90                 lda   [pro_fcr_ptr],y
5786 43D0 C9 10 00              cmp   #seedling_type
5787 43D3 D0 96                 bne   sparse_data              ;make block sparse please
5788 43D5 A0 09 00              ldy   #fcr_key_blk             ;this is a seedling so load the block
5789 43D8 B7 90                 lda   [pro_fcr_ptr],y
5790 43DA 85 10                 sta   drvr_blk_num
5791 43DC
5792 43DC              not_sparse                              ;
5793 43DC 20 4D 44              jsr   chk_data_clean           ;make sure the data buffer is OK
5794 43DF 90 01                 bcc   @still_ok
5795 43E1 60                    rts   
5796 43E2              @still_ok  
5797 43E2 A5 10                 lda   drvr_blk_num
5798 43E4 A0 37 00              ldy   #data_blk_num            ;see if the block is already loaded
5799 43E7 D7 90                 cmp   [pro_fcr_ptr],y
5800 43E9 D0 02                 bne   load_data
5801 43EB              exit_fill_data                          ;
5802 43EB 18                    clc   
5803 43EC 60                    rts                            ;no problem here
5804 43ED
5805 43ED              load_data                               ;
5806 43ED A5 B0                 lda   data_ptr
5807 43EF 85 04                 sta   drvr_buf_ptr
5808 43F1 A5 B2                 lda   data_ptr+2
5809 43F3 85 06                 sta   drvr_buf_ptr+2
5810 43F5 20 87 17              jsr   read_with_mount          ;read in the block please
5811 43F8 90 01                 bcc   store_data_num
5812 43FA 60                    rts   
5813 43FB
5814 43FB              store_data_num                          ;
5815 43FB A0 37 00              ldy   #data_blk_num            ;update current block loaded field
5816 43FE A5 10                 lda   drvr_blk_num
5817 4400 97 90                 sta   [pro_fcr_ptr],y
5818 4402 60                    rts   
5819 4403
5820 4403              ;==========================================================================
5821 4403              ;If we get here we know that there is no index block loaded
5822 4403              ;==========================================================================
5823 4403
5824 4403              no_index                                ;
5825 4403 AD C0 05              lda   curr_mark+1
5826 4406 4A                    lsr   a
5827 4407 29 FF 00              and   #$00FF
5828 440A F0 03                 beq   @need_long
5829 440C 82 5C FF              brl   sparse_data              ;make the data block sparse if needed
5830 440F              @need_long  
5831 440F A0 09 00              ldy   #fcr_key_blk
5832 4412 B7 90                 lda   [pro_fcr_ptr],y
5833 4414 A0 37 00              ldy   #data_blk_num            ;current block that is loaded
5834 4417 D7 90                 cmp   [pro_fcr_ptr],y
5835 4419 D0 02                 bne   reload_data
5836 441B 18                    clc   
5837 441C 60                    rts                            ;block is already loaded
5838 441D
5839 441D              reload_data                             ;
5840 441D 85 10                 sta   drvr_blk_num
5841 441F A5 B0                 lda   data_ptr
5842 4421 85 04                 sta   drvr_buf_ptr
5843 4423 A5 B2                 lda   data_ptr+2
5844 4425 85 06                 sta   drvr_buf_ptr+2
5845 4427 20 87 17              jsr   read_with_mount
5846 442A 90 01                 bcc   data_read
5847 442C 60                    rts   
5848 442D
5849 442D              data_read                               ;
5850 442D A0 37 00              ldy   #data_blk_num
5851 4430 A5 10                 lda   drvr_blk_num             ;update the current block loaded
5852 4432 97 90                 sta   [pro_fcr_ptr],y
5853 4434 60                    rts   
5854 4435
5855 4435              ;==========================================================================
5856 4435                       EXPORT get_data_num
5857 4435              get_data_num                            ;
5858 4435 AD C0 05              lda   curr_mark+1
5859 4438 4A                    lsr   a
5860 4439 29 FF 00              and   #$00FF
5861 443C A8                    tay   
5862 443D 09 00 01              ora   #$0100
5863 4440 AA                    tax   
5864 4441
5865 4441 B7 B4                 lda   [index_ptr],y            ;setup the block number
5866 4443 85 10                 sta   drvr_blk_num
5867 4445 9B                    txy   
5868 4446 B7 B4                 lda   [index_ptr],y
5869 4448 85 11                 sta   drvr_blk_num+1
5870 444A 64 12                 stz   drvr_blk_num+2
5871 444C 60                    rts   
5872 444D
5873 444D              ;==========================================================================
5874 444D              ;Chk_data_clean will determine if the current data block needs to be 
5875 444D              ;written to disk before the new block is loaded
5876 444D              ;==========================================================================
5877 444D              chk_data_clean  
5878 444D 5A                    phy   
5879 444E A0 1F 00              ldy   #fcr_status              ;we are going to read another block so make sure
5880 4451 B7 90                 lda   [pro_fcr_ptr],y          ;the I/O buffer is clean
5881 4453 29 04 00              and   #data_dirty
5882 4456 F0 12                 beq   @not_dirty               ;easy case.
5883 4458
5884 4458 A5 10                 lda   drvr_blk_num             ;get the block number we want to load
5885 445A A0 37 00              ldy   #data_blk_num            ;see if the block is already loaded
5886 445D D7 90                 cmp   [pro_fcr_ptr],y
5887 445F F0 09                 beq   @not_dirty               ;another easy case.
5888 4461
5889 4461 48                    pha                            ;save the driver block number
5890 4462 20 D2 19              jsr   flush_data_blk           ;save the data to disk
5891 4465 FA                    plx                            ;get the drvr_blk_number back please
5892 4466 86 10                 stx   drvr_blk_num
5893 4468 7A                    ply   
5894 4469 60                    rts                            ;carry will return any error
5895 446A
5896 446A              @not_dirty  
5897 446A 7A                    ply   
5898 446B 18                    clc   
5899 446C 60                    rts   
5900 446D
5901 446D
5902 446D              fill_directory                          ;
5903 446D
5904 446D              ;==========================================================================
5905 446D              ;OK this file is a directory so lets handle this pain in the butt case.
5906 446D              ;
5907 446D              ;The way it works:
5908 446D              ;
5909 446D              ;               The master index field contains the current block number
5910 446D              ;               that is loaded into the data buffer.  So when I'm called
5911 446D              ;               with the current mark I calculate the block number that
5912 446D              ;               that is needed.   If the block number is less then the
5913 446D              ;               current block number then I walk the backward links till
5914 446D              ;               I find the block needed.  If the block wanted is greater
5915 446D              ;               then the current block I walk the links forward till I
5916 446D              ;               find the correct block, and at the end I update the FCR.
5917 446D              ;
5918 446D              ;==========================================================================
5919 446D
5920 446D A9 02 80              lda   #in_cache
5921 4470 85 1A                 sta   drvr_cache
5922 4472
5923 4472 A5 B0                 lda   data_ptr                 ;setup buffer pointer to data buffer
5924 4474 85 04                 sta   drvr_buf_ptr
5925 4476 A5 B2                 lda   data_ptr+2
5926 4478 85 06                 sta   drvr_buf_ptr+2
5927 447A
5928 447A AD C0 05              lda   curr_mark+1
5929 447D 4A                    lsr   a                        ;bytes to blocks
5930 447E 85 AC                 sta   math_temp
5931 4480
5932 4480 A0 37 00              ldy   #data_blk_num
5933 4483 B7 90                 lda   [pro_fcr_ptr],y
5934 4485 8D B1 05              sta   entries_blk_num
5935 4488
5936 4488 A0 3B 00              ldy   #master_blk_num
5937 448B B7 90                 lda   [pro_fcr_ptr],y
5938 448D C5 AC                 cmp   math_temp
5939 448F D0 02                 bne   have_to_look
5940 4491 18                    clc   
5941 4492 60                    rts   
5942 4493
5943 4493              have_to_look                            ;
5944 4493 8D DD 04              sta   last_blk
5945 4496 B0 36                 bcs   look_backward            ;IF current > wanted THEN go backward
5946 4498
5947 4498              ;==========================================================================
5948 4498              ;Of we get here we walk thru the forward links till we find the right blk
5949 4498              ;==========================================================================
5950 4498
5951 4498              forward_loop                            ;
5952 4498 A0 02 00              ldy   #$0002
5953 449B B7 B0                 lda   [data_ptr],y
5954 449D F0 5B                 beq   bad_dir_blk              ;This should NEVER happen!!!!!
5955 449F 85 10                 sta   drvr_blk_num
5956 44A1 20 01 45              jsr   go_get_block             ;go read the block
5957 44A4 90 01                 bcc   ar16
5958 44A6 60                    rts                            ;return the error
5959 44A7
5960 44A7              ar16                                    ;
5961 44A7 A7 B0                 lda   [data_ptr]               ;verify backward links please
5962 44A9 CD B1 05              cmp   entries_blk_num
5963 44AC F0 05                 beq   cont16
5964 44AE A9 51 00              lda   #dir_error
5965 44B1 80 4A                 bra   dir_bad
5966 44B3
5967 44B3              cont16                                  ;
5968 44B3 A0 37 00              ldy   #data_blk_num
5969 44B6 A5 10                 lda   drvr_blk_num
5970 44B8 97 90                 sta   [pro_fcr_ptr],y
5971 44BA 8D B1 05              sta   entries_blk_num          ;update both the FCR and Link verify
5972 44BD
5973 44BD EE DD 04              inc   last_blk                 ;advance the block counter
5974 44C0 AD DD 04              lda   last_blk
5975 44C3 C5 AC                 cmp   math_temp                ;See if this the right bloc number
5976 44C5 D0 D1                 bne   forward_loop             ;go and get the next block
5977 44C7
5978 44C7 A0 3B 00     end_links ldy   #master_blk_num         ;update the current block
5979 44CA 97 90                 sta   [pro_fcr_ptr],y
5980 44CC 18                    clc   
5981 44CD 60                    rts   
5982 44CE
5983 44CE              ;==========================================================================
5984 44CE              ;We need to set the mark backward. So we need to walk the links backward
5985 44CE              ;==========================================================================
5986 44CE
5987 44CE              look_backward                           ;
5988 44CE A7 B0                 lda   [data_ptr]
5989 44D0 F0 28                 beq   bad_dir_blk              ;This should NEVER happen!!!!!
5990 44D2 85 10                 sta   drvr_blk_num
5991 44D4 20 01 45              jsr   go_get_block             ;go read the block
5992 44D7 90 01                 bcc   ar18
5993 44D9 60                    rts                            ;return the error
5994 44DA
5995 44DA              ar18                                    ;
5996 44DA A0 02 00              ldy   #$0002
5997 44DD B7 B0                 lda   [data_ptr],y
5998 44DF CD B1 05              cmp   entries_blk_num
5999 44E2 D0 19                 bne   dir_bad
6000 44E4
6001 44E4 A5 10                 lda   drvr_blk_num
6002 44E6 A0 37 00              ldy   #data_blk_num
6003 44E9 97 90                 sta   [pro_fcr_ptr],y
6004 44EB 8D B1 05              sta   entries_blk_num
6005 44EE
6006 44EE CE DD 04              dec   last_blk                 ;advance the block counter
6007 44F1 AD DD 04              lda   last_blk
6008 44F4 C5 AC                 cmp   math_temp                ;See if this the right bloc number
6009 44F6 D0 D6                 bne   look_backward            ;go and get the next block
6010 44F8 80 CD                 bra   end_links                ;we are done
6011 44FA
6012 44FA              ;==========================================================================
6013 44FA
6014 44FA              bad_dir_blk                             ;
6015 44FA A9 53 00              lda   #parm_range_err
6016 44FD              dir_bad                                 ;
6017 44FD 38                    sec   
6018 44FE 4C 82 00              jmp   main_exit
6019 4501
6020 4501              ;==========================================================================
6021 4501
6022 4501              go_get_block                            ;
6023 4501 20 8D 15              jsr   standard_req
6024 4504 20 95 17              jsr   read_with_cache          ;issue the read call
6025 4507 60                    rts   
6026 4508
6027 4508 00 00        data_flag DC W:00
6028 450A
6029 450A                       ENDP 
6030 450A
6031 450A
6032 450A              ;==========================================================================
6033 450A              ;send_sparse_blk: This routine will zero out 512 bytes of memory.
6034 450A              ;
6035 450A              ;Input:         A = undefined
6036 450A              ;               X = low word pointer to buffer
6037 450A              ;               Y = high word pointer to buffer
6038 450A              ;               P = nvmxdizc
6039 450A              ;                   ..000...
6040 450A              ;               b = k
6041 450A              ;
6042 450A              ;
6043 450A              ;Output:        A = undefined
6044 450A              ;               X = undefined
6045 450A              ;               Y = undefined
6046 450A              ;               P = nvmxdizc
6047 450A              ;                   ..000...
6048 450A              ;               b = k
6049 450A              ;
6050 450A              ;Uses:          All registers
6051 450A              ;
6052 450A              ;==========================================================================
6053 450A                       longa on
6054 450A                       longi on
6055 450A
6056 450A                       EXPORT send_sparse_blk
6057 450A              send_sparse_blk PROC 
6058 450A
6059 450A 86 C4                 stx   sparse_ptr
6060 450C 84 C6                 sty   sparse_ptr+2
6061 450E A0 FE 01              ldy   #$01FE                   ;starting index
6062 4511 A9 00 00              lda   #$0000
6063 4514              sparse_loop                             ;
6064 4514 97 C4                 sta   [sparse_ptr],y
6065 4516 88                    dey   
6066 4517 88                    dey   
6067 4518 10 FA                 bpl   sparse_loop
6068 451A 60                    rts   
6069 451B                       ENDP 
6070 451B
6071 451B
6072 451B
6073 451B              ;==========================================================================
6074 451B              ;calc_seg_blks: This routine will calculate the number of sequential
6075 451B              ;               blocks in an index block.  This routine will NOT calculate
6076 451B              ;               across index blocks.
6077 451B              ;
6078 451B              ;Input:         A = undefined
6079 451B              ;               X = undefined
6080 451B              ;               Y = undefined
6081 451B              ;               P = nvmxdizc
6082 451B              ;                   ..000...
6083 451B              ;               b = k
6084 451B              ;
6085 451B              ;               index_ptr               (points to the index pointer)
6086 451B              ;               curr_mark               (curr_mark must be on block boundary!)
6087 451B              ;
6088 451B              ;Output:        A = number of blocks that are sequential
6089 451B              ;               X = undefined
6090 451B              ;               Y = undefined
6091 451B              ;               P = nvmxdizc
6092 451B              ;                   ..000...
6093 451B              ;               b = k
6094 451B              ;
6095 451B              ;Uses:          All registers
6096 451B              ;               math_temp               (just a temp counter)
6097 451B              ;               comp_temp  = and_mask
6098 451B              ;               check_blk  = entries_checked
6099 451B              ;==========================================================================
6100 451B                       longa on
6101 451B                       longi on
6102 451B
6103 451B                       EXPORT num_seq_blks
6104 451B              num_seq_blks PROC 
6105 451B
6106 451B              ;==========================================================================
6107 451B              ;Local equates for this routine
6108 451B              ;==========================================================================
6109 451B
6110 451B              comp_temp equ   and_mask                ;(same ZP location different name)
6111 451B              check_blk equ   entries_checked         ;(same ZP location different name)
6112 451B
6113 451B              ;==========================================================================
6114 451B              ;Zero the counter and save the current file marker
6115 451B              ;==========================================================================
6116 451B
6117 451B 64 AC                 stz   math_temp
6118 451D AD BF 05              lda   curr_mark
6119 4520 48                    pha   
6120 4521 AD C1 05              lda   curr_mark+2
6121 4524 48                    pha   
6122 4525
6123 4525              ;==========================================================================
6124 4525              ;first make sure the index blocks are loaded correctly
6125 4525              ;==========================================================================
6126 4525
6127 4525 20 55 42              jsr   load_indexes
6128 4528
6129 4528              ;==========================================================================
6130 4528              ;No go and get the first block from the Index block buffer.
6131 4528              ;==========================================================================
6132 4528
6133 4528 20 60 45              jsr   get_blk_num
6134 452B 8D CF 05              sta   check_blk
6135 452E 48                    pha                            ;save starting block number
6136 452F
6137 452F AD 3E 05              lda   storage_type
6138 4532 C9 D0 00              cmp   #subdir_type
6139 4535 B0 1D                 bcs   seq_exit                 ;always return zero for a directory
6140 4537 AD 7F 05              lda   newline_len
6141 453A D0 18                 bne   seq_exit                 ;always return zero if newline enabled
6142 453C
6143 453C              calc_loop                               ;
6144 453C
6145 453C              ;==========================================================================
6146 453C              ;Calculate the index to the next block number.
6147 453C              ;==========================================================================
6148 453C
6149 453C 20 60 45              jsr   get_blk_num
6150 453F B0 13                 bcs   seq_exit                 ;we have looked at the entire block
6151 4541 3A                    dec   a                        ;subtract one from the block
6152 4542 C9 FF FF              cmp   #$FFFF                   ;see if this block is sparse
6153 4545 F0 0D                 beq   seq_exit                 ;this must be a sparse block!
6154 4547 CD CF 05              cmp   check_blk
6155 454A D0 08                 bne   seq_exit
6156 454C 1A                    inc   a                        ;restore the block number
6157 454D 8D CF 05              sta   check_blk                ;setup for next compare
6158 4550 E6 AC                 inc   math_temp
6159 4552 80 E8                 bra   calc_loop
6160 4554
6161 4554              seq_exit                                ;
6162 4554
6163 4554              ;==========================================================================
6164 4554              ;restore the current marker and return the number of sequential blocks.
6165 4554              ;==========================================================================
6166 4554
6167 4554 FA                    plx                            ;load X with starting block
6168 4555 68                    pla   
6169 4556 8D C1 05              sta   curr_mark+2
6170 4559 68                    pla   
6171 455A 8D BF 05              sta   curr_mark
6172 455D
6173 455D A5 AC                 lda   math_temp                ;return number of sequential blocks
6174 455F 60                    rts   
6175 4560
6176 4560
6177 4560              ;==========================================================================
6178 4560              ;get_blk_num:   This routine will return the block number out of the index
6179 4560              ;               block based on the current file marker.  It will also
6180 4560              ;               advance the file marker by 512 bytes.
6181 4560              ;
6182 4560              ;Input:         curr_mark
6183 4560              ;
6184 4560              ;Output:        carry set = end of block
6185 4560              ;               A = block number
6186 4560              ;==========================================================================
6187 4560
6188 4560              get_blk_num                             ; 
6189 4560
6190 4560 AD C0 05              lda   curr_mark+1
6191 4563 4A                    lsr   a
6192 4564 29 FF 00              and   #$00FF
6193 4567 48                    pha   
6194 4568 A8                    tay   
6195 4569 09 00 01              ora   #$0100
6196 456C AA                    tax   
6197 456D
6198 456D B7 B4                 lda   [index_ptr],y
6199 456F 29 FF 00              and   #$00FF
6200 4572 8D BD 05              sta   comp_temp
6201 4575 9B                    txy   
6202 4576 B7 B4                 lda   [index_ptr],y
6203 4578 29 FF 00              and   #$00FF
6204 457B EB                    xba   
6205 457C 0D BD 05              ora   comp_temp
6206 457F AA                    tax   
6207 4580
6208 4580 18                    clc   
6209 4581 AD BF 05              lda   curr_mark
6210 4584 69 00 02              adc   #blk_size
6211 4587 8D BF 05              sta   curr_mark
6212 458A 90 04                 bcc   ar11
6213 458C EE C1 05              inc   curr_mark+2
6214 458F 18                    clc   
6215 4590              ar11                                    ; 
6216 4590 8A                    txa                            ;block number
6217 4591 FA                    plx                            ;get the first index value
6218 4592 F0 01                 beq   end_seq                  ;just set the carry
6219 4594
6220 4594              ;==========================================================================
6221 4594              ;WARNING!! --> Carry must be clear when we get here.
6222 4594              ;==========================================================================
6223 4594
6224 4594 60                    rts   
6225 4595
6226 4595              end_seq                                 ; 
6227 4595 38                    sec   
6228 4596 60                    rts   
6229 4597
6230 4597                       ENDP 
6231 4597
6232 4597              ;==========================================================================
6233 4597              ;setup_curr_mark This routine will load the current file marker out of the
6234 4597              ;               FCR and store it in curr_mark
6235 4597              ;
6236 4597              ;Input:         A = undefined
6237 4597              ;               X = undefined
6238 4597              ;               Y = undefined
6239 4597              ;               P = nvmxdizc
6240 4597              ;                   ..000...
6241 4597              ;               b = k
6242 4597              ;
6243 4597              ;               pro_fcr_ptr             (points to my FCR data)
6244 4597              ;
6245 4597              ;Output:        A = undefined
6246 4597              ;               X = undefined
6247 4597              ;               Y = undefined
6248 4597              ;               P = nvmxdizc
6249 4597              ;                   ..000...
6250 4597              ;               b = k
6251 4597              ;
6252 4597              ;               curr_mark               (contains current file marker)
6253 4597              ;
6254 4597              ;Uses:          All registers
6255 4597              ;==========================================================================
6256 4597                       longa on
6257 4597                       longi on
6258 4597
6259 4597                       EXPORT setup_curr_mark
6260 4597              setup_curr_mark PROC 
6261 4597
6262 4597 A0 29 00              ldy   #fcr_curr_mark
6263 459A B7 90                 lda   [pro_fcr_ptr],y
6264 459C 8D BF 05              sta   curr_mark
6265 459F C8                    iny   
6266 45A0 C8                    iny   
6267 45A1 B7 90                 lda   [pro_fcr_ptr],y
6268 45A3 8D C1 05              sta   curr_mark+2
6269 45A6 60                    rts   
6270 45A7                       ENDP 
6271 45A7
6272 45A7              ;==========================================================================
6273 45A7              ;setup_curr_eof This routine will load the current end of file out of the
6274 45A7              ;               FCR and store it in curr_eof
6275 45A7              ;
6276 45A7              ;Input:         A = undefined
6277 45A7              ;               X = undefined
6278 45A7              ;               Y = undefined
6279 45A7              ;               P = nvmxdizc
6280 45A7              ;                   ..000...
6281 45A7              ;               b = k
6282 45A7              ;
6283 45A7              ;               pro_fcr_ptr             (points to my FCR data)
6284 45A7              ;
6285 45A7              ;Output:        A = undefined
6286 45A7              ;               X = undefined
6287 45A7              ;               Y = undefined
6288 45A7              ;               P = nvmxdizc
6289 45A7              ;                   ..000...
6290 45A7              ;               b = k
6291 45A7              ;
6292 45A7              ;               curr_eof                (contains current end fo file)
6293 45A7              ;
6294 45A7              ;Uses:          All registers
6295 45A7              ;==========================================================================
6296 45A7                       longa on
6297 45A7                       longi on
6298 45A7
6299 45A7                       EXPORT setup_curr_eof
6300 45A7              setup_curr_eof PROC 
6301 45A7
6302 45A7 A0 2F 00              ldy   #fcr_curr_eof
6303 45AA B7 90                 lda   [pro_fcr_ptr],y
6304 45AC 8D C3 05              sta   curr_eof
6305 45AF C8                    iny   
6306 45B0 C8                    iny   
6307 45B1 B7 90                 lda   [pro_fcr_ptr],y
6308 45B3 8D C5 05              sta   curr_eof+2
6309 45B6 60                    rts   
6310 45B7                       ENDP 
6311 45B7
6312 45B7              ;==========================================================================
6313 45B7              ;save_curr_mark This routine will save the current end of file into the
6314 45B7              ;               FCR.
6315 45B7              ;
6316 45B7              ;Input:         A = undefined
6317 45B7              ;               X = undefined
6318 45B7              ;               Y = undefined
6319 45B7              ;               P = nvmxdizc
6320 45B7              ;                   ..000...
6321 45B7              ;               b = k
6322 45B7              ;
6323 45B7              ;               pro_fcr_ptr             (points to my FCR data)
6324 45B7              ;               curr_mark
6325 45B7              ;
6326 45B7              ;Output:        A = undefined
6327 45B7              ;               X = undefined
6328 45B7              ;               Y = undefined
6329 45B7              ;               P = nvmxdizc
6330 45B7              ;                   ..000...
6331 45B7              ;               b = k
6332 45B7              ;
6333 45B7              ;
6334 45B7              ;Uses:          A and Y  registers
6335 45B7              ;==========================================================================
6336 45B7                       longa on
6337 45B7                       longi on
6338 45B7
6339 45B7                       EXPORT save_curr_mark
6340 45B7              save_curr_mark PROC 
6341 45B7
6342 45B7 A0 29 00              ldy   #fcr_curr_mark
6343 45BA AD BF 05              lda   curr_mark
6344 45BD 97 90                 sta   [pro_fcr_ptr],y
6345 45BF C8                    iny   
6346 45C0 C8                    iny   
6347 45C1 AD C1 05              lda   curr_mark+2
6348 45C4 97 90                 sta   [pro_fcr_ptr],y
6349 45C6 60                    rts   
6350 45C7                       ENDP 
6351 45C7              ;==========================================================================
6352 45C7              ;Write:         This file contains code used to write data to a file.
6353 45C7              ;               The types of files supported are:
6354 45C7              ;
6355 45C7              ;                       1) seedling
6356 45C7              ;                       2) sapling
6357 45C7              ;                       3) tree
6358 45C7              ;
6359 45C7              ;Created:       oct 06, 1987
6360 45C7              ;Modified:      oct 15, 1987
6361 45C7              ;Author:        Rob Turner
6362 45C7              ;
6363 45C7              ;Enter:         jml
6364 45C7              ;
6365 45C7              ;Input:         A = undefined
6366 45C7
6367 45C7              ;               X = call number times 2
6368 45C7              ;               Y = class times 2
6369 45C7              ;               P = nvmxdizc
6370 45C7              ;                   ..000...
6371 45C7              ;               b = k
6372 45C7              ;
6373 45C7              ;Output:        A = error code if carry set
6374 45C7              ;               X = undefined
6375 45C7              ;               Y = undefined
6376 45C7              ;               P = nvmxdizc
6377 45C7              ;                   ..000..1 = error
6378 45C7              ;                          0 = no error
6379 45C7              ;               b = k
6380 45C7              ;
6381 45C7              ;Uses:          All registers
6382 45C7              ;               Device Dispatcher  (subroutine)
6383 45C7              ;               General I/O Buffer (1K buffer, I read 512 bytes)
6384 45C7              ;               and lots of other stuff.
6385 45C7              ;
6386 45C7              ;Call Format:
6387 45C7              ;
6388 45C7              ;Class 0        Reference Number        (2 Bytes)
6389 45C7              ;               Pointer to Data Buffer  (4 Bytes)
6390 45C7              ;               Request Count           (4 Bytes)
6391 45C7              ;               Transfer Count          (4 Bytes)
6392 45C7              ;
6393 45C7              ;Class 1        PCount                  (2 Bytes)
6394 45C7              ;               Reference Number        (2 Bytes)
6395 45C7              ;               Pointer to Data Buffer  (4 Bytes)
6396 45C7              ;               Request Count           (4 Bytes)
6397 45C7              ;               Transfer Count          (4 Bytes)
6398 45C7              ;               Cache Priority          (2 Bytes)
6399 45C7              ;
6400 45C7              ;==========================================================================
6401 45C7                       longa on
6402 45C7                       longi on
6403 45C7
6404 45C7                       EXPORT write
6405 45C7              write    PROC 
6406 45C7
6407 45C7 9C D7 04              stz   seq_write_cnt            ;reset sequential block counter
6408 45CA 20 9E 0E              jsr   setup_params             ;setup standard parameters
6409 45CD
6410 45CD A0 14 00              ldy   #fcr_access              ;see if the file is write protected
6411 45D0 B7 8C                 lda   [my_fcr_ptr],y
6412 45D2 29 FF 3F              and   #ClrAllButAccess
6413 45D5 C9 02 00              cmp   #write_access
6414 45D8 B0 07                 bcs   write_ok                 ;write access is enabled.
6415 45DA
6416 45DA              bad_access                              ; ;user cannot write to this file.
6417 45DA A9 4E 00              lda   #invalid_access
6418 45DD 38                    sec   
6419 45DE 4C 82 00              jmp   main_exit
6420 45E1
6421 45E1              write_ok                                ;
6422 45E1 A0 0C 00              ldy   #vcr_dev                 ;last known location of volume
6423 45E4 B7 84                 lda   [my_vcr_ptr],y
6424 45E6 85 00                 sta   drvr_dev_num             ;I hope that the disk is still here.
6425 45E8
6426 45E8 20 9B 13              jsr   chk_disk_protect
6427 45EB
6428 45EB              not_protected                           ;
6429 45EB 20 5A 16              jsr   read_write_setup
6430 45EE 20 97 45              jsr   setup_curr_mark
6431 45F1 20 A7 45              jsr   setup_curr_eof
6432 45F4
6433 45F4 20 B1 15              jsr   setup_io_ptrs            ;setup pointers to I/O buffer
6434 45F7 20 A7 1C              jsr   chk_swapped              ;mount the volume if needed
6435 45FA 90 03                 bcc   vol_online
6436 45FC 4C 82 00              jmp   main_exit
6437 45FF
6438 45FF              ;==========================================================================
6439 45FF              ; IF curr_mark NOT block_aligned THEN
6440 45FF              ;==========================================================================
6441 45FF              vol_online                              ;
6442 45FF 20 18 48              jsr   users_to_drvrs           ;move user's pointer to driver's ptr
6443 4602 20 0F 48              jsr   user_to_temp             ;temp_ptr := user_buf_ptr
6444 4605
6445 4605              block_loop                              ;
6446 4605 AD BF 05              lda   curr_mark                ;see if we are block aligned
6447 4608 29 FF 01              and   #$01FF
6448 460B F0 07                 beq   block_aligned            ;yes we are block aligned
6449 460D 20 DE 46              jsr   partial_write            ;write until data is block aligned.
6450 4610 B0 29                 bcs   write_exit               ;major problem
6451 4612 80 19                 bra   next_block
6452 4614
6453 4614              block_aligned                           ;
6454 4614 AD CD 05              lda   user_req_cnt+2           ;is req_cnt >= 512?
6455 4617 D0 08                 bne   more_then_512
6456 4619 AD CB 05              lda   user_req_cnt
6457 461C C9 00 02              cmp   #blk_size
6458 461F 90 07                 bcc   less_then_512
6459 4621              more_then_512                           ;
6460 4621 20 8E 46              jsr   full_write               ;transfer full 512 bytes.
6461 4624 B0 15                 bcs   write_exit
6462 4626 80 05                 bra   next_block               ;go to the next block please
6463 4628
6464 4628              ;==========================================================================
6465 4628              ;Less_then_512. we have less then 512 bytes to write.
6466 4628              ;==========================================================================
6467 4628              less_then_512                           ;
6468 4628 20 DE 46              jsr   partial_write            ;write the partial block to disk
6469 462B B0 0E                 bcs   write_exit               ;major problem.
6470 462D
6471 462D              next_block                              ;
6472 462D 20 BF 16              jsr   rw_adjust                ;adjust the following:
6473 4630              ;                                       ;(1) user_buf_ptr
6474 4630              ;                                       ;(2) tran_cnt
6475 4630              ;                                       ;(3) curr_mark
6476 4630              ;                                       ;(4) user_req_cnt
6477 4630 AD CD 05              lda   user_req_cnt+2           ;see if we are done yet
6478 4633 D0 D0                 bne   block_loop
6479 4635 AD CB 05              lda   user_req_cnt
6480 4638 D0 CB                 bne   block_loop
6481 463A 18                    clc   
6482 463B
6483 463B              write_exit  
6484 463B
6485 463B 08                    php   
6486 463C 48                    pha   
6487 463D 90 03                 bcc   @10                      ;there is no error so skip flush
6488 463F
6489 463F 20 64 18              jsr   flush_file               ;try to save the world
6490 4642              @10       
6491 4642 20 9A 48              jsr   update_mark_eof          ;make sure the mark is OK
6492 4645
6493 4645 A0 2F 00              ldy   #fcr_curr_eof            ;update the current end of file please
6494 4648 AD C3 05              lda   curr_eof
6495 464B 97 90                 sta   [pro_fcr_ptr],y
6496 464D C8                    iny   
6497 464E C8                    iny   
6498 464F AD C5 05              lda   curr_eof+2
6499 4652 97 90                 sta   [pro_fcr_ptr],y
6500 4654
6501 4654 A9 00 80              lda   #file_dirty
6502 4657 20 F2 3E              jsr   set_fcr_status           ;indicate that something changed.
6503 465A 20 8D 15              jsr   standard_req             ;make sure we write 512 bytes only
6504 465D
6505 465D 20 E0 47              jsr   flush_blocks             ;flush any blocks to disk.
6506 4660 B0 26                 bcs   write_failed             ;bad news we cannot complete the flush!!!
6507 4662              ;
6508 4662              ;We know that the mark actually points to one past where the last byte is so
6509 4662              ;lets reduce the mark by one please
6510 4662              ;v00.06 a06
6511 4662              ;
6512 4662 AD BF 05              lda   curr_mark
6513 4665 D0 03                 bne   @no_high
6514 4667 CE C1 05              dec   curr_mark+2
6515 466A              @no_high  
6516 466A CE BF 05              dec   curr_mark
6517 466D
6518 466D 18                    clc   
6519 466E 20 C3 48              jsr   get_write_blk            ;make sure I/O buffer is OK
6520 4671 B0 15                 bcs   write_failed
6521 4673 8A                    txa                            ;block to load
6522 4674 F0 05                 beq   holy_cow                 ;I hope not
6523 4676 20 EF 49              jsr   load_data                ;load the data buffer please
6524 4679 B0 0D                 bcs   write_failed
6525 467B              holy_cow                                ;
6526 467B EE BF 05              inc   curr_mark
6527 467E D0 03                 bne   @low_only
6528 4680 EE C1 05              inc   curr_mark+2
6529 4683              @low_only  
6530 4683
6531 4683 68                    pla                            ;restore error code
6532 4684 28                    plp   
6533 4685 4C DD 40              jmp   end_read_write           ;exit thru wonder code in read file
6534 4688
6535 4688              write_failed  
6536 4688 FA                    plx                            ;kill the old exit code
6537 4689 28                    plp                            ;kill the old processor flag
6538 468A 38                    sec                            ;make sure the error is set
6539 468B 4C DD 40              jmp   end_read_write           ;exit please.
6540 468E
6541 468E              ;==========================================================================
6542 468E              ;Write blocks of 512 to disk
6543 468E              ;==========================================================================
6544 468E
6545 468E              full_write  
6546 468E A9 00 02              lda   #blk_size
6547 4691 20 48 47              jsr   range_chk_eof            ;see if we overrun the EOF
6548 4694 B0 43                 bcs   eof_error                ;sorry we have an eof error
6549 4696                        
6550 4696 20 8D 15              jsr   standard_req             ;transfer of 512 bytes
6551 4699 A0 1F 00              ldy   #fcr_status              ;see if the data block is dirty
6552 469C B7 90                 lda   [pro_fcr_ptr],y
6553 469E 29 04 00              and   #data_dirty
6554 46A1 F0 05                 beq   clean_blk                ;no flush needed
6555 46A3 20 D2 19              jsr   flush_data_blk           ;write the data block to disk
6556 46A6 B0 93                 bcs   write_exit               ;get out of here with the error code
6557 46A8
6558 46A8              clean_blk                               ;
6559 46A8 20 0F 48              jsr   user_to_temp             ;temp_ptr := user_buf_ptr
6560 46AB 18                    clc   
6561 46AC 20 C3 48              jsr   get_write_blk            ;is there a current block allocated?
6562 46AF D0 12                 bne   block_allocated          ;yes there is a block allocated.
6563 46B1
6564 46B1 20 65 48              jsr   chk_sparse               ;is the user's data sparse?
6565 46B4 90 16                 bcc   do_flush                 ;data sparse so flush queued data blocks
6566 46B6              ;	sec
6567 46B6 20 C3 48              jsr   get_write_blk            ;allocate a block please
6568 46B9 90 03                 bcc   @no_error
6569 46BB 82 7D FF              brl   write_exit               ;cannot allocate a new block?
6570 46BE              @no_error  
6571 46BE 48                    pha   
6572 46BF 20 0F 48              jsr   user_to_temp             ;point to user's buffer
6573 46C2 68                    pla   
6574 46C3              block_allocated                         ;
6575 46C3 85 10                 sta   drvr_blk_num             ;save the block number to write.
6576 46C5 20 D0 46              jsr   user_to_data             ;move user's data to data buffer
6577 46C8 20 5B 47              jsr   write_data_blk           ;write the data block to disk.
6578 46CB 60                    rts   
6579 46CC
6580 46CC              do_flush                                ;
6581 46CC 20 E0 47              jsr   flush_blocks             ;issue the flush command
6582 46CF 60                    rts   
6583 46D0
6584 46D0              user_to_data                            ;
6585 46D0 A5 C0                 lda   users_buf_ptr            ;setup driver buffer pointer to
6586 46D2 85 04                 sta   drvr_buf_ptr             ;point to the user's data!
6587 46D4 A5 C2                 lda   users_buf_ptr+2
6588 46D6 85 06                 sta   drvr_buf_ptr+2
6589 46D8 60                    rts   
6590 46D9
6591 46D9              eof_error  
6592 46D9 A9 4D 00              lda   #out_of_range            ;you have pushed me too far!!!
6593 46DC 38                    sec   
6594 46DD 60                    rts   
6595 46DE
6596 46DE
6597 46DE
6598 46DE
6599 46DE              ;               ldy     #$01FE          ;move 512 bytes please
6600 46DE              ;user_loop      anop
6601 46DE              ;               lda     [drvr_buf_ptr],y
6602 46DE              ;               sta     [data_ptr],y
6603 46DE              ;               dey
6604 46DE              ;               dey
6605 46DE              ;               bpl     user_loop
6606 46DE              ;               rts
6607 46DE
6608 46DE              ;==========================================================================
6609 46DE              ;partial_write: This routine will handle reading/writing a partial block
6610 46DE              ;
6611 46DE              ;Input:         A = undefined
6612 46DE              ;               X = undefined
6613 46DE              ;               Y = undefined
6614 46DE              ;               P = nvmxdizc
6615 46DE              ;                   ..000...
6616 46DE              ;               b = k
6617 46DE              ;
6618 46DE              ;Output:        A = error code if carry set
6619 46DE              ;               X = undefined
6620 46DE              ;               Y = undefined
6621 46DE              ;               P = nvmxdizc
6622 46DE              ;                   ..000..1 = error
6623 46DE              ;                          0 = no error
6624 46DE              ;               b = k
6625 46DE              ;
6626 46DE              ;Uses:          All registers
6627 46DE              ;==========================================================================
6628 46DE
6629 46DE              partial_write                           ;
6630 46DE 20 7E 48              jsr   build_index              ;simulate a disk write
6631 46E1 20 48 47              jsr   range_chk_eof            ;see if we overrun the EOF
6632 46E4 B0 F3                 bcs   eof_error                ;sorry we have an eof error
6633 46E6
6634 46E6 20 8D 15              jsr   standard_req             ;we can only write 512 bytes!
6635 46E9 20 E0 47              jsr   flush_blocks             ;write any left over seq. blocks
6636 46EC B0 59                 bcs   end_partial              ;error condition
6637 46EE 18                    clc   
6638 46EF 20 C3 48              jsr   get_write_blk            ;is there a current block allocated?
6639 46F2 D0 13                 bne   block_is_avail           ;there is a block allocated.
6640 46F4
6641 46F4              ; we know that the block is not allocated so check the data
6642 46F4
6643 46F4 20 65 48              jsr   chk_sparse               ;AND (data NOT sparse)
6644 46F7 90 21                 bcc   is_sparse                ;... (data IS sparse)
6645 46F9 20 C3 48              jsr   get_write_blk            ;allocate a block for the new data
6646 46FC B0 49                 bcs   end_partial
6647 46FE 48                    pha                            ;save the block number
6648 46FF A6 B0                 ldx   data_ptr                 ;clear the new data block
6649 4701 A4 B2                 ldy   data_ptr+2
6650 4703 20 B5 4B              jsr   clear_index
6651 4706 68                    pla   
6652 4707              block_is_avail                          ;
6653 4707 20 EF 49              jsr   load_data                ;load in the data block
6654 470A B0 3B                 bcs   end_partial
6655 470C 20 0F 48              jsr   user_to_temp
6656 470F 20 21 48              jsr   merge_data               ;add data to current block!
6657 4712 A9 04 80              lda   #file_dirty+data_dirty
6658 4715 20 F2 3E              jsr   set_fcr_status           ;indicate that something changed.
6659 4718 18                    clc   
6660 4719 60                    rts   
6661 471A
6662 471A              is_sparse                               ;
6663 471A A0 37 00              ldy   #data_blk_num
6664 471D B7 90                 lda   [pro_fcr_ptr],y          ;is block already loaded?
6665 471F F0 1E                 beq   @sparse_loaded
6666 4721
6667 4721 A0 1F 00              ldy   #fcr_status
6668 4724 B7 90                 lda   [pro_fcr_ptr],y
6669 4726 29 04 00              and   #data_dirty
6670 4729 F0 05                 beq   @just_clear_buf          ;no need to update the data block
6671 472B
6672 472B 20 D2 19              jsr   flush_data_blk
6673 472E B0 17                 bcs   end_partial
6674 4730              @just_clear_buf  
6675 4730 A6 B0                 ldx   data_ptr                 ;clear the new data block
6676 4732 A4 B2                 ldy   data_ptr+2
6677 4734 20 B5 4B              jsr   clear_index
6678 4737
6679 4737 A0 37 00              ldy   #data_blk_num
6680 473A A9 00 00              lda   #$0000
6681 473D 97 90                 sta   [pro_fcr_ptr],y          ;is block already loaded?
6682 473F
6683 473F              @sparse_loaded  
6684 473F 20 7E 48              jsr   build_index              ;simulate a disk write
6685 4742 85 08                 sta   drvr_req_cnt
6686 4744 64 0A                 stz   drvr_req_cnt+2
6687 4746 18                    clc   
6688 4747              end_partial                             ;
6689 4747 60                    rts   
6690 4748              ;==========================================================================
6691 4748              ;Range_chk_eof  This routine will make sure the write call will work with
6692 4748              ;               the three byte eof.
6693 4748              ;
6694 4748              ;Input:         A = write_count
6695 4748              ;               X = undefined
6696 4748              ;               Y = undefined
6697 4748              ;               P = nvmxdizc
6698 4748              ;                   ..000...
6699 4748              ;               b = k
6700 4748              ;
6701 4748              ;               curr_eof        ;the current eof
6702 4748              ;
6703 4748              ;
6704 4748              ;Output:        A = undefined
6705 4748              ;               X = undefined
6706 4748              ;               Y = undefined
6707 4748              ;               P = nvmxdizc
6708 4748              ;                   ..000..1 = error
6709 4748              ;                          0 = no error
6710 4748              ;               b = k
6711 4748              ;
6712 4748              ;Uses:          All registers
6713 4748              ;==========================================================================
6714 4748              range_chk_eof  
6715 4748 18                    clc   
6716 4749 6D BF 05              adc   curr_mark
6717 474C A9 00 00              lda   #0000
6718 474F 6D C1 05              adc   curr_mark+2              ;check the high word
6719 4752 29 00 FF              and   #$FF00                   ;clear the result
6720 4755 D0 02                 bne   range_err
6721 4757 18                    clc   
6722 4758 60                    rts   
6723 4759              range_err  
6724 4759 38                    sec   
6725 475A 60                    rts   
6726 475B
6727 475B
6728 475B              ;==========================================================================
6729 475B              ;write_data_blk This routine will write data blocks to disk. The code will
6730 475B              ;               determine if we can hold off writing to disk so we can
6731 475B              ;               gain performance by doing a multi-block transfer call.
6732 475B              ;
6733 475B              ;Input:         A = undefined
6734 475B              ;               X = undefined
6735 475B              ;               Y = undefined
6736 475B              ;               P = nvmxdizc
6737 475B              ;                   ..000...
6738 475B              ;               b = k
6739 475B              ;
6740 475B              ;               drvr_blk_num            ;block number to write
6741 475B              ;               drvr_buf_ptr            ;pointer to the data
6742 475B              ;
6743 475B              ;
6744 475B              ;Output:        A = error code if carry set otherwise undefined
6745 475B              ;               X = undefined
6746 475B              ;               Y = undefined
6747 475B              ;               P = nvmxdizc
6748 475B              ;                   ..000..1 = error
6749 475B              ;                          0 = no error
6750 475B              ;               b = k
6751 475B              ;
6752 475B              ;Uses:          All registers
6753 475B              ;==========================================================================
6754 475B
6755 475B              write_data_blk                          ;
6756 475B AD D7 04              lda   seq_write_cnt            ;do we have anything to write?
6757 475E F0 22                 beq   new_block                ;no
6758 4760 A5 10                 lda   drvr_blk_num             ;is this a sequential block write?
6759 4762 3A                    dec   a
6760 4763 CD D9 04              cmp   seq_write_blk
6761 4766 F0 3A                 beq   bump_seq                 ;bump the sequential counter
6762 4768
6763 4768 A5 10                 lda   drvr_blk_num             ;save block number to write
6764 476A 48                    pha   
6765 476B A5 04                 lda   drvr_buf_ptr
6766 476D 48                    pha   
6767 476E A5 06                 lda   drvr_buf_ptr+2
6768 4770 48                    pha   
6769 4771 20 E0 47              jsr   flush_blocks             ;write any seq. blocks to disk
6770 4774 FA                    plx   
6771 4775 86 06                 stx   drvr_buf_ptr+2
6772 4777 FA                    plx   
6773 4778 86 04                 stx   drvr_buf_ptr
6774 477A FA                    plx   
6775 477B 86 10                 stx   drvr_blk_num
6776 477D 9C D7 04              stz   seq_write_cnt
6777 4780 B0 15                 bcs   end_write_data           ;error
6778 4782
6779 4782              new_block                               ;
6780 4782 EE D7 04              inc   seq_write_cnt            ;advance the number of sequential blks
6781 4785 A5 10                 lda   drvr_blk_num
6782 4787 8D D9 04              sta   seq_write_blk            ;starting block for write call
6783 478A
6784 478A 20 C3 47              jsr   move_to_data_buf
6785 478D
6786 478D A5 04                 lda   drvr_buf_ptr
6787 478F 8D D3 04              sta   seq_write_start
6788 4792 A5 06                 lda   drvr_buf_ptr+2
6789 4794 8D D5 04              sta   seq_write_start+2
6790 4797              end_write_data   
6791 4797 A9 FB FF              lda   #data_clean              ;indicate that we have written block.
6792 479A 20 C0 1A              jsr   clr_fcr_status
6793 479D 20 8D 15              jsr   standard_req             ;set drvr_req_cnt to 512 bytes.
6794 47A0 18                    clc                            ;exit
6795 47A1 60                    rts   
6796 47A2
6797 47A2              bump_seq   
6798 47A2 EE D7 04              inc   seq_write_cnt            ;advance the block counter
6799 47A5 EE D9 04              inc   seq_write_blk            ;update new last sequential block
6800 47A8 AD CD 05              lda   user_req_cnt+2
6801 47AB D0 EA                 bne   end_write_data
6802 47AD AD CB 05              lda   user_req_cnt
6803 47B0 C9 00 04              cmp   #blk_size*2
6804 47B3 B0 E2                 bcs   end_write_data
6805 47B5
6806 47B5 A0 37 00              ldy   #data_blk_num
6807 47B8 A5 10                 lda   drvr_blk_num
6808 47BA D7 90                 cmp   [pro_fcr_ptr],y          ;Should I Copy the data to the buffer
6809 47BC D0 D9                 bne   end_write_data           ;Do not move the data.
6810 47BE
6811 47BE 20 CA 47              jsr   do_data_update
6812 47C1 80 D4                 bra   end_write_data
6813 47C3              ;
6814 47C3              ;This routine copies the user's data to the I/O Buffer
6815 47C3              ;
6816 47C3              ;input: A = block number
6817 47C3              ;
6818 47C3              move_to_data_buf  
6819 47C3 A0 37 00              ldy   #data_blk_num
6820 47C6 D7 90                 cmp   [pro_fcr_ptr],y          ;is block already loaded?
6821 47C8 D0 15                 bne   io_buf_ok                ;don't worry about I/O buffer update
6822 47CA              do_data_update  
6823 47CA D4 06                 pei   drvr_buf_ptr+2           ;address of user's data
6824 47CC D4 04                 pei   drvr_buf_ptr
6825 47CE
6826 47CE D4 B2                 pei   data_ptr+2               ;destination address
6827 47D0 D4 B0                 pei   data_ptr
6828 47D2 F4 00 00              pea   $0000                    ;high word of count
6829 47D5 F4 00 02              pea   blk_size                 ;number of bytes to send
6830 47D8 F4 05 08              pea   move_sinc_dinc
6831 47DB 22 70 FC 01           jsl   move_info
6832 47DF 60           io_buf_ok rts   
6833 47E0
6834 47E0              ;==========================================================================
6835 47E0              ;flush_blocks:  This routine will write out any data blocks that have not
6836 47E0              ;               been written to disk.  If will also make sure that the I/O
6837 47E0              ;               buffer contains valid data.
6838 47E0              ;
6839 47E0              ;Input:         A = undefined
6840 47E0              ;               X = undefined
6841 47E0              ;               Y = undefined
6842 47E0              ;               P = nvmxdizc
6843 47E0              ;                   ..000...
6844 47E0              ;               b = k
6845 47E0              ;
6846 47E0              ;
6847 47E0              ;Output:        A = error code if carry set otherwise undefined
6848 47E0              ;               X = undefined
6849 47E0              ;               Y = undefined
6850 47E0              ;               P = nvmxdizc
6851 47E0              ;                   ..000..1 = error
6852 47E0              ;                          0 = no error
6853 47E0              ;               b = k
6854 47E0              ;
6855 47E0              ;Uses:          All registers
6856 47E0              ;==========================================================================
6857 47E0                       EXPORT flush_blocks
6858 47E0              flush_blocks                            ;
6859 47E0 AD D7 04              lda   seq_write_cnt            ;is there anything to write?
6860 47E3 D0 02                 bne   must_write
6861 47E5 18                    clc   
6862 47E6 60                    rts   
6863 47E7
6864 47E7              must_write                              ;
6865 47E7 9C D7 04              stz   seq_write_cnt            ;reset the sequential block counter
6866 47EA 64 08                 stz   drvr_req_cnt             ;setup the write count
6867 47EC 0A                    asl   a                        ;convert blocks to bytes
6868 47ED 85 09                 sta   drvr_req_cnt+1
6869 47EF 4A                    lsr   a                        ;now get the starting block
6870 47F0 3A                    dec   a                        ;subtract one please
6871 47F1 48                    pha   
6872 47F2 38                    sec   
6873 47F3 AD D9 04              lda   seq_write_blk
6874 47F6 E3 01                 sbc   1,s
6875 47F8 85 10                 sta   drvr_blk_num             ;starting block number
6876 47FA 68                    pla                            ;fix the stack
6877 47FB
6878 47FB AD D3 04              lda   seq_write_start
6879 47FE 85 04                 sta   drvr_buf_ptr
6880 4800 AD D5 04              lda   seq_write_start+2
6881 4803 85 06                 sta   drvr_buf_ptr+2           ;pointer to the data
6882 4805 20 8C 17              jsr   write_with_mount
6883 4808 B0 04                 bcs   flush_error
6884 480A 20 8D 15              jsr   standard_req
6885 480D 18                    clc   
6886 480E              flush_error                             ;
6887 480E 60                    rts   
6888 480F
6889 480F
6890 480F
6891 480F              ;==========================================================================
6892 480F              ;Set temp_ptr to the user's buffer pointer
6893 480F              ;==========================================================================
6894 480F
6895 480F              user_to_temp                            ;
6896 480F A5 C0                 lda   users_buf_ptr
6897 4811 85 98                 sta   temp_ptr                 ;set pointer to head of data
6898 4813 A5 C2                 lda   users_buf_ptr+2
6899 4815 85 9A                 sta   temp_ptr+2
6900 4817 60                    rts   
6901 4818
6902 4818              users_to_drvrs                          ;
6903 4818 A5 C0                 lda   users_buf_ptr
6904 481A 85 04                 sta   drvr_buf_ptr             ;set pointer to head of data
6905 481C A5 C2                 lda   users_buf_ptr+2
6906 481E 85 06                 sta   drvr_buf_ptr+2
6907 4820 60                    rts   
6908 4821
6909 4821
6910 4821              ;==========================================================================
6911 4821              ;merge_data:    This routine will add in the user's data into the I/O
6912 4821              ;               buffer.
6913 4821              ;
6914 4821              ;Input:         A = undefined
6915 4821              ;               X = undefined
6916 4821              ;               Y = undefined
6917 4821              ;               P = nvmxdizc
6918 4821              ;                   ..000...
6919 4821              ;               b = k
6920 4821              ;
6921 4821              ;               curr_mark               ;current file marker
6922 4821              ;               pro_fcr_ptr             ;points to file control record
6923 4821              ;               data_ptr                ;points to data block in I/O buffer.
6924 4821              ;               temp_ptr                ;points to user data
6925 4821              ;               user_req_cnt            ;used by build_index
6926 4821              ;
6927 4821              ;Output:        A = undefined
6928 4821              ;               X = undefined
6929 4821              ;               Y = undefined
6930 4821              ;               P = nvmxdizc
6931 4821              ;                   ..000...
6932 4821              ;
6933 4821              ;               b = k
6934 4821              ;
6935 4821              ;               drvr_req_cnt            ;equals bytes moved
6936 4821              ;
6937 4821              ;
6938 4821              ;uses:          all registers
6939 4821              ;               math_temp
6940 4821              ;==========================================================================
6941 4821              merge_data                              ;
6942 4821 20 7E 48              jsr   build_index              ;'A' = 1 to $1FF
6943 4824 85 AC                 sta   math_temp                ;save count
6944 4826 85 08                 sta   drvr_req_cnt             ;simulate a write to disk.
6945 4828
6946 4828 3A                    dec   a                        ;A,X,Y perserved by 'update..' routine
6947 4829 48                    pha   
6948 482A A8                    tay                            ;'Y' = 0 to $1FE (move count)
6949 482B 18                    clc   
6950 482C AD BF 05              lda   curr_mark
6951 482F 29 FF 01              and   #$01FF
6952 4832 63 01                 adc   1,s                      ;make index from END of buffer
6953 4834 AA                    tax                            ;index into data buffer
6954 4835 68                    pla                            ;fix the stack
6955 4836
6956 4836                       longa off                      ;block after the merge
6957 4836 E2 20                 sep   #$20
6958 4838
6959 4838              merge_loop                              ;
6960 4838 B7 98                 lda   [temp_ptr],y             ;pointer to user's data
6961 483A 5A                    phy                            ;save user index
6962 483B 9B                    txy   
6963 483C 97 B0                 sta   [data_ptr],y             ;store in the I/O buffer
6964 483E CA                    dex   
6965 483F 7A                    ply   
6966 4840 88                    dey   
6967 4841 10 F5                 bpl   merge_loop               ;I/O buffer updated.
6968 4843
6969 4843                       longa on
6970 4843 C2 20                 rep   #$20
6971 4845
6972 4845 18                    clc   
6973 4846 AD BF 05              lda   curr_mark                ;save the mark
6974 4849 48                    pha   
6975 484A 65 AC                 adc   math_temp
6976 484C 8D BF 05              sta   curr_mark
6977 484F AD C1 05              lda   curr_mark+2
6978 4852 48                    pha   
6979 4853 69 00 00              adc   #$0000
6980 4856 8D C1 05              sta   curr_mark+2
6981 4859
6982 4859 20 7B 4C              jsr   clr_to_boundary          ;Clear to blk boundary
6983 485C
6984 485C 68                    pla   
6985 485D 8D C1 05              sta   curr_mark+2
6986 4860 68                    pla   
6987 4861 8D BF 05              sta   curr_mark
6988 4864
6989 4864 60                    rts   
6990 4865
6991 4865
6992 4865              ;==========================================================================
6993 4865              ;See if we have to deal with a sparse block.
6994 4865              ;
6995 4865              ;Input:         A = undefined
6996 4865              ;               X = undefined
6997 4865              ;               Y = undefined
6998 4865              ;               P = nvmxdizc
6999 4865              ;                   ..000...
7000 4865              ;               b = k
7001 4865              ;
7002 4865              ;               curr_mark               ;current file marker
7003 4865              ;               pro_fcr_ptr             ;pointer to file control record
7004 4865              ;               temp_ptr                ;pointer to user's data buffer
7005 4865              ;
7006 4865              ;Output:        A = undefined
7007 4865              ;               X = undefined
7008 4865              ;               Y = undefined
7009 4865              ;               P = nvmxdizc
7010 4865              ;                   ..000..1 = sparse
7011 4865              ;                          0 = not sparse
7012 4865              ;               b = k
7013 4865              ;
7014 4865              ;uses:          all registers
7015 4865              ;               math_temp
7016 4865              ;
7017 4865              ;FUNCTION sparse():boolean ;
7018 4865              ; BEGIN
7019 4865              ;  index := (curr_mark MOD 512) ;
7020 4865              ;  sparse := true ;
7021 4865              ;  While (index < block_size) and (index < user_req) and (sparse = true) DO
7022 4865              ;        BEGIN
7023 4865              ;           IF data[index] <> 0 THEN
7024 4865              ;              sparse := flase
7025 4865              ;           index := index + 1 ;
7026 4865              ;        END
7027 4865              ; END
7028 4865              ;==========================================================================
7029 4865              chk_sparse                              ; 
7030 4865 20 0F 48              jsr   user_to_temp             ;temp_ptr := user_buf_ptr
7031 4868 20 7E 48              jsr   build_index
7032 486B A8                    tay                            ;number of bytes to scan
7033 486C 88                    dey                            ;force 1 to $0200 to 0 to $01FF
7034 486D                       longa off
7035 486D E2 20                 sep   #$20                     ;short accum for test
7036 486F              scan_loop                               ; 
7037 486F B7 98                 lda   [temp_ptr],y             ;pointer to user's data
7038 4871 D0 07                 bne   non_sparse
7039 4873 88                    dey   
7040 4874 10 F9                 bpl   scan_loop
7041 4876                       longa on
7042 4876 C2 20                 rep   #$20                     ;restore 16 bit mode
7043 4878 18                    clc   
7044 4879 60                    rts                            ;user data is all sparse
7045 487A
7046 487A              non_sparse                              ; 
7047 487A                       longa on
7048 487A C2 20                 rep   #$20                     ;restore 16 bit mode
7049 487C 38                    sec   
7050 487D 60                    rts   
7051 487E
7052 487E              build_index                             ; 
7053 487E AD BF 05              lda   curr_mark                ;number of bytes to check in user buf.
7054 4881 29 FF 01              and   #$01FF                   ;0 to $1FF
7055 4884 48                    pha   
7056 4885 38                    sec   
7057 4886 A9 00 02              lda   #blk_size                ;calc number of bytes to scan
7058 4889 E3 01                 sbc   1,s                      ;range $0001 to $0200
7059 488B 7A                    ply                            ;fix the stack
7060 488C
7061 488C AC CD 05              ldy   user_req_cnt+2           ;how many bytes do we need to write?
7062 488F D0 08                 bne   full_scan
7063 4891
7064 4891 CD CB 05              cmp   user_req_cnt
7065 4894 90 03                 bcc   full_scan
7066 4896 AD CB 05              lda   user_req_cnt
7067 4899
7068 4899              full_scan                               ; 
7069 4899 60                    rts   
7070 489A
7071 489A                       ENDP 
7072 489A
7073 489A              ;==========================================================================
7074 489A              ;update_mark_eof:
7075 489A              ;
7076 489A              ;Input:         A = undefined
7077 489A              ;               X = undefined
7078 489A              ;               Y = undefined
7079 489A              ;               P = nvmxdizc
7080 489A              ;                   ..000...
7081 489A              ;               b = k
7082 489A              ;
7083 489A              ;               curr_mark               ;current file marker
7084 489A              ;               curr_eof                ;current end of file
7085 489A              ;               pro_fcr_ptr             ;pointer to file control record
7086 489A              ;
7087 489A              ;Output:        A = restored
7088 489A              ;               X = restored
7089 489A              ;               Y = restored
7090 489A              ;               P = nvmxdizc
7091 489A              ;                   ..000...
7092 489A              ;
7093 489A              ;               b = k
7094 489A              ;==========================================================================
7095 489A                       EXPORT update_mark_eof
7096 489A              update_mark_eof PROC 
7097 489A
7098 489A 48                    pha   
7099 489B DA                    phx   
7100 489C 5A                    phy   
7101 489D
7102 489D AD C1 05              lda   curr_mark+2
7103 48A0 CD C5 05              cmp   curr_eof+2
7104 48A3 90 1A                 bcc   end_update               ;EOF still OK
7105 48A5 F0 02                 beq   chk_low_eof
7106 48A7 80 0A                 bra   update_the_eof
7107 48A9
7108 48A9              chk_low_eof                             ;
7109 48A9 AD BF 05              lda   curr_mark
7110 48AC CD C3 05              cmp   curr_eof
7111 48AF F0 0E                 beq   end_update
7112 48B1 90 0C                 bcc   end_update               ;EOF still OK
7113 48B3
7114 48B3              update_the_eof                          ;
7115 48B3 AD C1 05              lda   curr_mark+2
7116 48B6 8D C5 05              sta   curr_eof+2               ;save the high byte
7117 48B9 AD BF 05              lda   curr_mark
7118 48BC 8D C3 05              sta   curr_eof                 ;save the low byte
7119 48BF
7120 48BF              end_update                              ;
7121 48BF 7A                    ply   
7122 48C0 FA                    plx   
7123 48C1 68                    pla   
7124 48C2 60                    rts   
7125 48C3                       ENDP 
7126 48C3
7127 48C3
7128 48C3              ;==========================================================================
7129 48C3              ;get_write_blk: This routine will return the block number for the new data.
7130 48C3              ;               If the file has a block allocated then that block number
7131 48C3              ;               is returned otherwise a new block is allocated for the file.
7132 48C3              ;               If the file needs to be expanded then it will be.
7133 48C3              ;
7134 48C3              ;Input:         A = undefined
7135 48C3              ;               X = undefined
7136 48C3              ;               Y = undefined
7137 48C3              ;               P = nvmxdizc
7138 48C3              ;                   ..000..1 = allocate a new block if block not allocated
7139 48C3              ;                          0 = just return current block number. (0 or blk num)
7140 48C3              ;               b = k
7141 48C3              ;
7142 48C3              ;               curr_mark               ;current file marker
7143 48C3              ;               pro_fcr_ptr             ;points to file control record
7144 48C3              ;
7145 48C3              ;Output:        A = block number of error code if carry set
7146 48C3              ;               X = undefined
7147 48C3              ;               Y = undefined
7148 48C3              ;               P = nvmxdizc
7149 48C3              ;                   ..000..1 = error
7150 48C3              ;                          0 = no error
7151 48C3              ;               b = k
7152 48C3              ;
7153 48C3              ;
7154 48C3              ;uses:          all registers
7155 48C3              ;               math_temp
7156 48C3              ;==========================================================================
7157 48C3
7158 48C3                       EXPORT get_write_blk
7159 48C3              get_write_blk PROC 
7160 48C3
7161 48C3 08                    php                            ;save check flag.
7162 48C4 08                    php   
7163 48C5 68                    pla   
7164 48C6 8D D1 04              sta   alloc_chk_flag
7165 48C9 4A                    lsr   a                        ;are we looking for a
7166 48CA B0 04                 bcs   do_allocation
7167 48CC 20 EB 4B              jsr   chk_allocation
7168 48CF 60                    rts   
7169 48D0              ;
7170 48D0              ;If here then we need to allocate or return the current block.
7171 48D0              ;
7172 48D0              do_allocation                           ;
7173 48D0 18                    clc   
7174 48D1 AD BF 05              lda   curr_mark
7175 48D4 69 01 00              adc   #$0001
7176 48D7 8D 6D 05              sta   data_eof
7177 48DA AD C1 05              lda   curr_mark+2
7178 48DD 69 00 00              adc   #$0000
7179 48E0 8D 6F 05              sta   data_eof+2
7180 48E3 20 FB 27              jsr   eof_to_blks              ;convert current position to blks.
7181 48E6
7182 48E6 AD F1 04              lda   data_storage             ;storage type needed (seed,sapling,tree)
7183 48E9 C9 10 00              cmp   #seedling_type
7184 48EC D0 03                 bne   sapling_case
7185 48EE 82 49 00              brl   add_new_block            ;just go and get the block please
7186 48F1
7187 48F1              sapling_case                            ;
7188 48F1 C9 20 00              cmp   #sapling_type
7189 48F4 D0 10                 bne   tree_case
7190 48F6              ;
7191 48F6              ;IF new_type = sapling THEN
7192 48F6              ;   IF old_type = seedling THEN
7193 48F6              ;      seedling_to_sapling
7194 48F6              ;   ELSE
7195 48F6              ;      add_index
7196 48F6              ;
7197 48F6              ;
7198 48F6 A0 02 00              ldy   #fcr_storage             ;current storage type
7199 48F9 B7 90                 lda   [pro_fcr_ptr],y
7200 48FB C9 10 00              cmp   #seedling_type
7201 48FE D0 3A                 bne   add_new_block
7202 4900 20 81 4A              jsr   seed_to_sap              ;convert a seedling to a sapling
7203 4903 90 35                 bcc   add_new_block
7204 4905 60                    rts   
7205 4906
7206 4906              ;
7207 4906              ;IF new_type = tree THEN
7208 4906              ;   IF old_type = seedling THEN
7209 4906              ;      BEGIN
7210 4906              ;          seedling_to_sapling
7211 4906              ;          sapling_to_tree
7212 4906              ;      END
7213 4906              ;   ELSE
7214 4906              ;      IF old_type = sapling THEN
7215 4906              ;         sapling_to_tree
7216 4906              ;      ELSE
7217 4906              ;         IF old_type = tree THEN
7218 4906              ;            BEGIN
7219 4906              ;              IF master_index[curr_mark] = nil THEN
7220 4906              ;                 add_master_index
7221 4906              ;              add_index
7222 4906              ;            END
7223 4906              ;
7224 4906
7225 4906              tree_case                               ; 
7226 4906 A0 02 00              ldy   #fcr_storage             ;current storage type
7227 4909 B7 90                 lda   [pro_fcr_ptr],y
7228 490B C9 10 00              cmp   #seedling_type
7229 490E D0 0B                 bne   not_seed
7230 4910 20 81 4A              jsr   seed_to_sap              ;convert seedling to a sapling
7231 4913 B0 05                 bcs   abort_tree
7232 4915 20 27 4B              jsr   sapling_to_tree          ;convert a sapling to a tree
7233 4918 90 20                 bcc   add_new_block
7234 491A 60           abort_tree rts   
7235 491B
7236 491B              not_seed                                ; 
7237 491B C9 20 00              cmp   #sapling_type            ;is this a sapling file
7238 491E D0 07                 bne   not_sapling
7239 4920 20 27 4B              jsr   sapling_to_tree          ;convert a sapling to a tree
7240 4923 B0 F5                 bcs   abort_tree
7241 4925 80 13                 bra   add_new_block
7242 4927
7243 4927              not_sapling                             ; 
7244 4927 AD C1 05              lda   curr_mark+2              ;see if the index block is allocated
7245 492A 4A                    lsr   a
7246 492B A6 B8                 ldx   master_ptr
7247 492D A4 BA                 ldy   master_ptr+2
7248 492F 20 6D 4A              jsr   get_index_blk            ;get the index block out of master blk
7249 4932 AA                    tax   
7250 4933 D0 05                 bne   add_new_block            ;we do not need to add an index block
7251 4935 20 63 4B              jsr   tree_to_tree             ;add a new index block
7252 4938 B0 E0                 bcs   abort_tree
7253 493A
7254 493A              ;==========================================================================
7255 493A              ;Now lets see if we need to add a new block or return the current block.
7256 493A              ;==========================================================================
7257 493A              add_new_block                           ; 
7258 493A 20 4E 0C              jsr   calc_free_blks           ;make sure that we have a block avail.
7259 493D B0 DB                 bcs   abort_tree               ;just exit
7260 493F AA                    tax   
7261 4940 D0 03                 bne   we_have_room
7262 4942 82 DD 01              brl   out_of_room
7263 4945
7264 4945              we_have_room                            ;
7265 4945 A0 3B 00              ldy   #master_blk_num          ;see if we should even have looked at
7266 4948 B7 90                 lda   [pro_fcr_ptr],y
7267 494A F0 5D                 beq   no_master                ;there is no master block for this file
7268 494C
7269 494C AD C1 05              lda   curr_mark+2              ;see if we need the master index block
7270 494F 4A                    lsr   a
7271 4950 A6 B8                 ldx   master_ptr               ;get the block number from index block
7272 4952 A4 BA                 ldy   master_ptr+2
7273 4954 20 6D 4A              jsr   get_index_blk            ;A = block number
7274 4957 AA                    tax   
7275 4958 D0 30                 bne   cont01                   ;there is an index block
7276 495A
7277 495A A0 1F 00              ldy   #fcr_status              ;see if old index needs to be flushed
7278 495D B7 90                 lda   [pro_fcr_ptr],y
7279 495F 29 02 00              and   #index_dirty
7280 4962 F0 05                 beq   no_index_flush
7281 4964 20 B8 19              jsr   flush_index
7282 4967 B0 B1                 bcs   abort_tree               ;exit
7283 4969
7284 4969              no_index_flush                          ; 
7285 4969 A6 B8                 ldx   master_ptr
7286 496B A4 BA                 ldy   master_ptr+2
7287 496D AD C1 05              lda   curr_mark+2
7288 4970 4A                    lsr   a                        ;now build a new index block
7289 4971 20 26 4A              jsr   new_block
7290 4974 B0 A4                 bcs   abort_tree               ;sorry major problem
7291 4976 48                    pha                            ;save the block number
7292 4977 A9 03 80              lda   #master_dirty+index_dirty+file_dirty
7293 497A 20 F2 3E              jsr   set_fcr_status           ;indicate master block dirty
7294 497D A6 B4                 ldx   index_ptr                ;clear the new buffer
7295 497F A4 B6                 ldy   index_ptr+2
7296 4981 20 B5 4B              jsr   clear_index
7297 4984 68                    pla   
7298 4985 A0 39 00              ldy   #index_blk_num
7299 4988 97 90                 sta   [pro_fcr_ptr],y
7300 498A
7301 498A              cont01                                  ; 
7302 498A A0 39 00              ldy   #index_blk_num
7303 498D D7 90                 cmp   [pro_fcr_ptr],y          ;is the block loaded?
7304 498F F0 18                 beq   no_master                ;no problem
7305 4991 8D 38 05              sta   key_block                ;save the block wanted.
7306 4994 20 B8 19              jsr   flush_index              ;write any dirty blocks to disk
7307 4997 B0 55                 bcs   end_write_blk            ;major problems
7308 4999
7309 4999 AD 38 05              lda   key_block                ;load in the index block please
7310 499C 48                    pha   
7311 499D 20 68 4C              jsr   load_index
7312 49A0 FA                    plx                            ;restore block number
7313 49A1 B0 4B                 bcs   end_write_blk
7314 49A3 8A                    txa   
7315 49A4 A0 39 00              ldy   #index_blk_num
7316 49A7 97 90                 sta   [pro_fcr_ptr],y
7317 49A9
7318 49A9              no_master                               ; 
7319 49A9 AD C0 05              lda   curr_mark+1
7320 49AC 4A                    lsr   a
7321 49AD 29 FF 00              and   #$00FF
7322 49B0 A6 B4                 ldx   index_ptr                ;get the block number from index block
7323 49B2 A4 B6                 ldy   index_ptr+2
7324 49B4 20 6D 4A              jsr   get_index_blk            ;A = block number
7325 49B7 AA                    tax   
7326 49B8 D0 2C                 bne   have_blk
7327 49BA
7328 49BA A0 1F 00              ldy   #fcr_status              ;see if data block needs to be written
7329 49BD B7 90                 lda   [pro_fcr_ptr],y
7330 49BF 29 04 00              and   #data_dirty
7331 49C2 F0 05                 beq   data1_clean
7332 49C4 20 D2 19              jsr   flush_data_blk
7333 49C7 B0 25                 bcs   end_write_blk
7334 49C9
7335 49C9              data1_clean                             ;
7336 49C9 A6 B4                 ldx   index_ptr
7337 49CB A4 B6                 ldy   index_ptr+2
7338 49CD AD C0 05              lda   curr_mark+1
7339 49D0 4A                    lsr   a                        ;now build a new index block
7340 49D1 29 FF 00              and   #$00FF
7341 49D4 20 26 4A              jsr   new_block
7342 49D7 B0 15                 bcs   end_write_blk            ;sorry major problem
7343 49D9 48                    pha                            ;save the block number
7344 49DA A0 37 00              ldy   #data_blk_num
7345 49DD 97 90                 sta   [pro_fcr_ptr],y          ;save the new block number
7346 49DF A9 06 80              lda   #index_dirty+file_dirty+data_dirty
7347 49E2 20 F2 3E              jsr   set_fcr_status           ;indicate master block dirty
7348 49E5 68                    pla   
7349 49E6              have_blk                                ; 
7350 49E6 20 EF 49              jsr   load_data
7351 49E9 B0 03                 bcs   end_write_blk
7352 49EB A5 10                 lda   drvr_blk_num
7353 49ED 18                    clc   
7354 49EE              end_write_blk                           ; 
7355 49EE 60                    rts   
7356 49EF
7357 49EF
7358 49EF                       EXPORT load_data
7359 49EF              load_data                               ;               ;input A= block to load
7360 49EF A0 37 00              ldy   #data_blk_num
7361 49F2 D7 90                 cmp   [pro_fcr_ptr],y          ;is block already loaded?
7362 49F4 F0 29                 beq   exit_load_data
7363 49F6
7364 49F6 48                    pha                            ;save the block to load
7365 49F7 A0 1F 00              ldy   #fcr_status
7366 49FA B7 90                 lda   [pro_fcr_ptr],y
7367 49FC 29 04 00              and   #data_dirty
7368 49FF F0 05                 beq   dont_update
7369 4A01
7370 4A01 20 D2 19              jsr   flush_data_blk
7371 4A04 B0 1D                 bcs   end_load_data
7372 4A06              dont_update                             ; 
7373 4A06 A5 B0                 lda   data_ptr
7374 4A08 85 04                 sta   drvr_buf_ptr
7375 4A0A A5 B2                 lda   data_ptr+2
7376 4A0C 85 06                 sta   drvr_buf_ptr+2
7377 4A0E A3 01                 lda   1,s                      ;get the block number to load
7378 4A10 85 10                 sta   drvr_blk_num
7379 4A12 20 87 17              jsr   read_with_mount          ;read in the new data block
7380 4A15 B0 0C                 bcs   end_load_data
7381 4A17
7382 4A17 A0 37 00              ldy   #data_blk_num            ;update current loaded block
7383 4A1A A5 10                 lda   drvr_blk_num
7384 4A1C 97 90                 sta   [pro_fcr_ptr],y
7385 4A1E 68                    pla   
7386 4A1F              exit_load_data                          ; 
7387 4A1F 18                    clc   
7388 4A20 85 10                 sta   drvr_blk_num
7389 4A22 60                    rts   
7390 4A23
7391 4A23              end_load_data                           ; 
7392 4A23 FA                    plx                            ;fix the stack please
7393 4A24 38                    sec   
7394 4A25 60                    rts   
7395 4A26
7396 4A26              ;==========================================================================
7397 4A26              ;new_block:     This routine will allocate a new block from the system
7398 4A26              ;               and add the block number in the index block pointed to
7399 4A26              ;               by the X and Y registers.
7400 4A26              ;
7401 4A26              ;Input:         A = index
7402 4A26              ;               X = low word pointer to index block
7403 4A26              ;               Y = high word pointer to index block
7404 4A26              ;               P = nvmxdizc
7405 4A26              ;                   ..000...
7406 4A26              ;               b = k
7407 4A26              ;
7408 4A26              ;
7409 4A26              ;Output:        A = block number allocated or error code
7410 4A26              ;               X = undefined
7411 4A26              ;               Y = undefined
7412 4A26              ;               P = nvmxdizc
7413 4A26              ;                   ..000..1 = error
7414 4A26              ;                          0 = no error
7415 4A26              ;               b = k
7416 4A26              ;
7417 4A26              ;
7418 4A26              ;uses:          all registers
7419 4A26              ;               temp4_ptr
7420 4A26              ;==========================================================================
7421 4A26              new_block                               ; 
7422 4A26 86 A4                 stx   temp4_ptr                ;pointer to the index block
7423 4A28 84 A6                 sty   temp4_ptr+2
7424 4A2A 48                    pha                            ;save the index
7425 4A2B 20 4E 0C              jsr   calc_free_blks           ;make sure that we a free block
7426 4A2E B0 28                 bcs   add_failed
7427 4A30 AA                    tax   
7428 4A31 F0 27                 beq   to_no_room
7429 4A33 A9 01 00              lda   #$0001                   ;allocate one block
7430 4A36 A2 00 00              ldx   #$0000                   ;start at block zero
7431 4A39 20 40 0D              jsr   find_free_blks
7432 4A3C B0 1A                 bcs   add_failed
7433 4A3E DA                    phx                            ;save the block number
7434 4A3F 20 5E 4A              jsr   bump_blks_used
7435 4A42 A3 03                 lda   3,s                      ;get the index please
7436 4A44 A8                    tay                            ;save the low index
7437 4A45 09 00 01              ora   #$0100
7438 4A48 AA                    tax                            ;save the high index
7439 4A49 68                    pla   
7440 4A4A                       longa off
7441 4A4A E2 20                 sep   #$20                     ;8 bit mode
7442 4A4C 97 A4                 sta   [temp4_ptr],y
7443 4A4E EB                    xba   
7444 4A4F 9B                    txy   
7445 4A50 97 A4                 sta   [temp4_ptr],y
7446 4A52                       longa on
7447 4A52 C2 20                 rep   #$20                     ;16 bit mode
7448 4A54 EB                    xba   
7449 4A55 FA                    plx                            ;fix the stack
7450 4A56 18                    clc   
7451 4A57 60                    rts   
7452 4A58
7453 4A58 FA           add_failed plx                          ;fix the stack
7454 4A59 60                    rts   
7455 4A5A
7456 4A5A 68           to_no_room pla                          ;fix the stack
7457 4A5B 82 C4 00              brl   out_of_room
7458 4A5E
7459 4A5E
7460 4A5E              bump_blks_used                          ; 
7461 4A5E A0 0B 00              ldy   #fcr_blks_used
7462 4A61 B7 90                 lda   [pro_fcr_ptr],y
7463 4A63 1A                    inc   a                        ;advance the blocks used count
7464 4A64 97 90                 sta   [pro_fcr_ptr],y
7465 4A66 A9 08 00              lda   #dirEntry_dirty          ;the directory entry needs updating when flushed
7466 4A69 20 F2 3E              jsr   set_fcr_status
7467 4A6C 60                    rts   
7468 4A6D
7469 4A6D              ;==========================================================================
7470 4A6D              ;get_index_blk: This routine will load a block number out of an index block
7471 4A6D              ;
7472 4A6D              ;Input:         A = index
7473 4A6D              ;               X = low word pointer to index block
7474 4A6D              ;               Y = high word pointer to index block
7475 4A6D              ;               P = nvmxdizc
7476 4A6D              ;                   ..000...
7477 4A6D              ;               b = k
7478 4A6D              ;
7479 4A6D              ;
7480 4A6D              ;Output:        A = block number
7481 4A6D              ;               X = undefined
7482 4A6D              ;               Y = undefined
7483 4A6D              ;               P = nvmxdizc
7484 4A6D              ;                   ..000...
7485 4A6D              ;               b = k
7486 4A6D              ;
7487 4A6D              ;
7488 4A6D              ;uses:          all registers
7489 4A6D              ;               temp_ptr
7490 4A6D              ;==========================================================================
7491 4A6D
7492 4A6D                       EXPORT get_index_blk
7493 4A6D              get_index_blk                           ;
7494 4A6D 86 98                 stx   temp_ptr
7495 4A6F 84 9A                 sty   temp_ptr+2
7496 4A71 AA                    tax                            ;low word index
7497 4A72 09 00 01              ora   #$0100                   ;high word index
7498 4A75 A8                    tay   
7499 4A76                       longa off
7500 4A76 E2 20                 sep   #$20                     ;8 bit accum
7501 4A78 B7 98                 lda   [temp_ptr],y             ;get the high word block number
7502 4A7A EB                    xba   
7503 4A7B 9B                    txy   
7504 4A7C B7 98                 lda   [temp_ptr],y             ;get the low word block number
7505 4A7E                       longa on
7506 4A7E C2 20                 rep   #$20                     ;16 bit accum
7507 4A80 60                    rts   
7508 4A81
7509 4A81              ;==========================================================================
7510 4A81              ;Convert a seedling file into a sapling file.
7511 4A81              ;==========================================================================
7512 4A81              seed_to_sap                             ; 
7513 4A81 20 E0 47              jsr   flush_blocks             ;flush anydata still around
7514 4A84 90 01                 bcc   do_sap
7515 4A86 60                    rts   
7516 4A87              do_sap                                  ; 
7517 4A87 20 4E 0C              jsr   calc_free_blks           ;see how many blocks we have
7518 4A8A AA                    tax   
7519 4A8B D0 03                 bne   lots_of_room
7520 4A8D 82 92 00              brl   out_of_room              ;sorry bud not today
7521 4A90
7522 4A90              lots_of_room                            ; 
7523 4A90 A9 01 00              lda   #$0001                   ;go get me a new block
7524 4A93 A2 00 00              ldx   #$0000                   ;start looking at block zero
7525 4A96 20 40 0D              jsr   find_free_blks
7526 4A99 B0 34                 bcs   end_to_sap
7527 4A9B 8A                    txa                            ;new key block
7528 4A9C 48                    pha   
7529 4A9D
7530 4A9D A4 B4                 ldy   index_ptr
7531 4A9F 84 A4                 sty   temp4_ptr
7532 4AA1 A4 B6                 ldy   index_ptr+2
7533 4AA3 84 A6                 sty   temp4_ptr+2
7534 4AA5
7535 4AA5 3A                    dec   a                        ;see if we should flip data and index
7536 4AA6 A0 09 00              ldy   #fcr_key_blk             ;
7537 4AA9 D7 90                 cmp   [pro_fcr_ptr],y
7538 4AAB F0 23                 beq   do_flip
7539 4AAD
7540 4AAD 8A                    txa   
7541 4AAE A0 39 00              ldy   #index_blk_num
7542 4AB1 97 90                 sta   [pro_fcr_ptr],y          ;save the new index block number
7543 4AB3 20 5E 4A              jsr   bump_blks_used
7544 4AB6
7545 4AB6 A0 09 00              ldy   #fcr_key_blk             ;data block address
7546 4AB9 B7 90                 lda   [pro_fcr_ptr],y
7547 4ABB A0 00 00              ldy   #$0000                   ;store as first entry in index block
7548 4ABE 20 E3 27              jsr   add_index
7549 4AC1
7550 4AC1 A9 02 A0              lda   #index_active+index_dirty+file_dirty
7551 4AC4 20 F2 3E              jsr   set_fcr_status           ;mark index block active
7552 4AC7 68                    pla                            ;restore key block
7553 4AC8 A2 20 00              ldx   #sapling_type
7554 4ACB 20 C6 4B              jsr   update_new_type
7555 4ACE 60                    rts   
7556 4ACF
7557 4ACF              end_to_sap                              ; 
7558 4ACF 60                    rts   
7559 4AD0
7560 4AD0              do_flip                                 ; 
7561 4AD0 A0 1F 00              ldy   #fcr_status              ;see if the data block is dirty
7562 4AD3 B7 90                 lda   [pro_fcr_ptr],y
7563 4AD5 29 04 00              and   #data_dirty
7564 4AD8 F0 07                 beq   onward
7565 4ADA 20 D2 19              jsr   flush_data_blk
7566 4ADD 90 02                 bcc   onward
7567 4ADF FA                    plx                            ;fix the stack!!!!
7568 4AE0 60                    rts   
7569 4AE1
7570 4AE1              onward                                  ; 
7571 4AE1 A0 09 00              ldy   #fcr_key_blk             ;load in the data block
7572 4AE4 B7 90                 lda   [pro_fcr_ptr],y
7573 4AE6 85 10                 sta   drvr_blk_num
7574 4AE8 A0 37 00              ldy   #data_blk_num
7575 4AEB 97 90                 sta   [pro_fcr_ptr],y          ;update current data block
7576 4AED
7577 4AED A5 B0                 lda   data_ptr
7578 4AEF 85 04                 sta   drvr_buf_ptr
7579 4AF1 A5 B2                 lda   data_ptr+2
7580 4AF3 85 06                 sta   drvr_buf_ptr+2
7581 4AF5 20 87 17              jsr   read_with_mount          ;read in the data block
7582 4AF8 90 02                 bcc   onward2
7583 4AFA FA                    plx                            ;fix the stack
7584 4AFB 60                    rts   
7585 4AFC
7586 4AFC              onward2                                 ; 
7587 4AFC 68                    pla                            ;get the new block number
7588 4AFD A0 37 00              ldy   #data_blk_num
7589 4B00 97 90                 sta   [pro_fcr_ptr],y          ;now the data block has changed
7590 4B02 A0 00 00              ldy   #$0000                   ;store as first entry in index block
7591 4B05 20 E3 27              jsr   add_index
7592 4B08
7593 4B08 A9 06 A0              lda   #index_active+index_dirty+file_dirty+data_dirty
7594 4B0B 20 F2 3E              jsr   set_fcr_status           ;mark index block active
7595 4B0E 20 5E 4A              jsr   bump_blks_used
7596 4B11
7597 4B11 A0 09 00              ldy   #fcr_key_blk
7598 4B14 B7 90                 lda   [pro_fcr_ptr],y
7599 4B16 A0 39 00              ldy   #index_blk_num
7600 4B19 97 90                 sta   [pro_fcr_ptr],y          ;now the index is new
7601 4B1B A2 20 00              ldx   #sapling_type
7602 4B1E 20 C6 4B              jsr   update_new_type
7603 4B21 60                    rts   
7604 4B22
7605 4B22              out_of_room                             ; 
7606 4B22 A9 48 00              lda   #volume_full
7607 4B25 38                    sec   
7608 4B26 60                    rts   
7609 4B27
7610 4B27              sapling_to_tree                         ; 
7611 4B27 20 4E 0C              jsr   calc_free_blks           ;see how many blocks we have
7612 4B2A AA                    tax   
7613 4B2B F0 F5                 beq   out_of_room              ;sorry bud not today
7614 4B2D A9 01 00              lda   #$0001                   ;go get me a new block
7615 4B30 A2 00 00              ldx   #$0000                   ;start looking at block zero
7616 4B33 20 40 0D              jsr   find_free_blks
7617 4B36 B0 2A                 bcs   end_to_tree
7618 4B38 8A                    txa                            ;new key block
7619 4B39 48                    pha   
7620 4B3A A0 3B 00              ldy   #master_blk_num
7621 4B3D 97 90                 sta   [pro_fcr_ptr],y          ;save the master index blk num
7622 4B3F 20 5E 4A              jsr   bump_blks_used
7623 4B42
7624 4B42 A5 B8                 lda   master_ptr
7625 4B44 85 A4                 sta   temp4_ptr
7626 4B46 A5 BA                 lda   master_ptr+2
7627 4B48 85 A6                 sta   temp4_ptr+2
7628 4B4A
7629 4B4A A0 09 00              ldy   #fcr_key_blk             ;current data block
7630 4B4D B7 90                 lda   [pro_fcr_ptr],y
7631 4B4F A0 00 00              ldy   #$0000                   ;store as first entry in index block
7632 4B52 20 E3 27              jsr   add_index
7633 4B55 A9 01 90              lda   #master_active+master_dirty+file_dirty
7634 4B58 20 F2 3E              jsr   set_fcr_status           ;mark index block active
7635 4B5B 68                    pla                            ;restore key block
7636 4B5C A2 30 00              ldx   #tree_type
7637 4B5F 20 C6 4B              jsr   update_new_type
7638 4B62              end_to_tree                             ;
7639 4B62 60                    rts   
7640 4B63
7641 4B63              tree_to_tree                            ;
7642 4B63 20 4E 0C              jsr   calc_free_blks           ;see how many blocks we have
7643 4B66 AA                    tax   
7644 4B67
7645 4B67 F0 B9                 beq   out_of_room              ;sorry bud not today
7646 4B69 A9 01 00              lda   #$0001                   ;go get me a new block
7647 4B6C A2 00 00              ldx   #$0000                   ;start looking at block zero
7648 4B6F 20 40 0D              jsr   find_free_blks
7649 4B72 B0 EE                 bcs   end_to_tree
7650 4B74 DA                    phx                            ;save the block number
7651 4B75
7652 4B75 A5 B8                 lda   master_ptr
7653 4B77 85 A4                 sta   temp4_ptr
7654 4B79 A5 BA                 lda   master_ptr+2
7655 4B7B 85 A6                 sta   temp4_ptr+2
7656 4B7D 20 5E 4A              jsr   bump_blks_used           ;must not use X register
7657 4B80
7658 4B80 AD C1 05              lda   curr_mark+2
7659 4B83 4A                    lsr   a
7660 4B84 A8                    tay                            ;index into master block
7661 4B85 8A                    txa                            ;new index block
7662 4B86
7663 4B86 20 E3 27              jsr   add_index
7664 4B89 A9 01 80              lda   #master_dirty+file_dirty
7665 4B8C 20 F2 3E              jsr   set_fcr_status           ;indicate master index block is dirty
7666 4B8F A0 1F 00              ldy   #fcr_status              ;see if current index block is dirty
7667 4B92 B7 90                 lda   [pro_fcr_ptr],y
7668 4B94 29 02 00              and   #index_dirty
7669 4B97 F0 07                 beq   mister_clean
7670 4B99 20 B8 19              jsr   flush_index
7671 4B9C 90 02                 bcc   mister_clean
7672 4B9E FA                    plx                            ;fix the stack
7673 4B9F 60                    rts   
7674 4BA0              mister_clean                            ;
7675 4BA0 A0 39 00              ldy   #index_blk_num           ;the current index block
7676 4BA3 68                    pla                            ;restore new index block number
7677 4BA4 97 90                 sta   [pro_fcr_ptr],y
7678 4BA6 A9 02 80              lda   #index_dirty+file_dirty
7679 4BA9 20 F2 3E              jsr   set_fcr_status           ;indicate that this block is dirty
7680 4BAC A6 B4                 ldx   index_ptr
7681 4BAE A4 B6                 ldy   index_ptr+2              ;clear the current index
7682 4BB0 20 B5 4B              jsr   clear_index
7683 4BB3 18                    clc   
7684 4BB4 60                    rts   
7685 4BB5
7686 4BB5                       EXPORT clear_index
7687 4BB5              clear_index                             ;
7688 4BB5 86 A4                 stx   temp4_ptr                ;zero out the buffer pointed to by
7689 4BB7 84 A6                 sty   temp4_ptr+2              ;X and Y
7690 4BB9 A0 FE 01              ldy   #$01FE
7691 4BBC A9 00 00              lda   #$0000
7692 4BBF 97 A4        clr_index sta   [temp4_ptr],y
7693 4BC1 88                    dey   
7694 4BC2 88                    dey   
7695 4BC3 10 FA                 bpl   clr_index
7696 4BC5 60                    rts   
7697 4BC6
7698 4BC6              ;==========================================================================
7699 4BC6              ;update_new_type:
7700 4BC6              ;               This routine will update the FCR to reflect the new storage
7701 4BC6              ;               type, and key block for a file
7702 4BC6              ;
7703 4BC6              ;Input:         A = new key block
7704 4BC6              ;               X = new storage type
7705 4BC6              ;               Y = undefined
7706 4BC6              ;               P = nvmxdizc
7707 4BC6              ;                   ..000...
7708 4BC6              ;               b = k
7709 4BC6              ;
7710 4BC6              ;               pro_fcr_ptr             ;points to file control record
7711 4BC6              ;
7712 4BC6              ;Output:        A = undefined
7713 4BC6              ;               X = undefined
7714 4BC6              ;               Y = undefined
7715 4BC6              ;               P = nvmxdizc
7716 4BC6              ;                   ..000...
7717 4BC6              ;               b = k
7718 4BC6              ;
7719 4BC6              ;
7720 4BC6              ;uses:          all registers
7721 4BC6              ;==========================================================================
7722 4BC6
7723 4BC6              update_new_type                         ; 
7724 4BC6 48                    pha                            ;save new key block
7725 4BC7 A0 09 00              ldy   #fcr_key_blk
7726 4BCA 97 90                 sta   [pro_fcr_ptr],y
7727 4BCC A0 04 00              ldy   #fcr_entry_type
7728 4BCF B7 90                 lda   [pro_fcr_ptr],y          ;is this a resource type?
7729 4BD1 C9 50 00              cmp   #resource_type
7730 4BD4 F0 0A                 beq   is_resource
7731 4BD6
7732 4BD6 8A                    txa                            ;save the new storage type
7733 4BD7 97 90                 sta   [pro_fcr_ptr],y
7734 4BD9 A3 01                 lda   1,s                      ;save the new key block
7735 4BDB A0 06 00              ldy   #fcr_file_id
7736 4BDE 97 90                 sta   [pro_fcr_ptr],y
7737 4BE0
7738 4BE0              is_resource                             ; 
7739 4BE0 68                    pla                            ;fix the stack
7740 4BE1 A0 02 00              ldy   #fcr_storage             ;store the new storage type
7741 4BE4 8A                    txa   
7742 4BE5 97 90                 sta   [pro_fcr_ptr],y
7743 4BE7 20 64 18              jsr   flush_file               ;force directory update.
7744 4BEA 60                    rts   
7745 4BEB                       ENDP 
7746 4BEB
7747 4BEB              ;==========================================================================
7748 4BEB              ;chk_allocation:
7749 4BEB              ;               This routine will return the block number of a data block
7750 4BEB              ;               if the file contains a data block
7751 4BEB              ;
7752 4BEB              ;Input:         A = undefined
7753 4BEB              ;               X = undefin
7754 4BEB              ;               Y = undefined
7755 4BEB              ;               P = nvmxdizc
7756 4BEB              ;                   ..000...
7757 4BEB              ;               b = k
7758 4BEB              ;
7759 4BEB              ;               pro_fcr_ptr             ;points to file control record
7760 4BEB              ;
7761 4BEB              ;Output:        A = block number if 'z' = 0
7762 4BEB              ;               X = undefined
7763 4BEB              ;               Y = undefined
7764 4BEB              ;               P = nvmxdizc
7765 4BEB              ;                   ..000..1 = error
7766 4BEB              ;                          0 = no error and 'z' flag valid
7767 4BEB              ;                         1  = no block allocated
7768 4BEB              ;                         0  = A = block number
7769 4BEB              ;               b = k
7770 4BEB              ;
7771 4BEB              ;
7772 4BEB              ;uses:          all registers
7773 4BEB              ;==========================================================================
7774 4BEB
7775 4BEB              ;==========================================================================
7776 4BEB              ;IF (curr_mark = tree) AND (storage <> tree) THEN
7777 4BEB              ;   no_block allocated
7778 4BEB              ;
7779 4BEB              ;==========================================================================
7780 4BEB
7781 4BEB                       EXPORT chk_allocation
7782 4BEB              chk_allocation PROC                     ;see if there is block allocated.
7783 4BEB
7784 4BEB AD C1 05              lda   curr_mark+2              ;see if we need the master index block
7785 4BEE 4A                    lsr   a
7786 4BEF A6 B8                 ldx   master_ptr               ;get the block number from index block
7787 4BF1 A4 BA                 ldy   master_ptr+2
7788 4BF3 20 6D 4A              jsr   get_index_blk            ;A = block number
7789 4BF6 AA                    tax   
7790 4BF7 D0 14                 bne   cont01                   ;there is an index block
7791 4BF9              ;
7792 4BF9              ;IF (type = tree) AND (index = sparse) THEN block_not_allocated
7793 4BF9              ;
7794 4BF9              chk_tree                                ;
7795 4BF9 A0 02 00              ldy   #fcr_storage
7796 4BFC B7 90                 lda   [pro_fcr_ptr],y
7797 4BFE C9 30 00              cmp   #tree_type               ;does this puppy even have a master blk?>
7798 4C01 D0 02                 bne   chk_sapling              ;there is no master index block
7799 4C03 18                    clc   
7800 4C04 60                    rts   
7801 4C05
7802 4C05              ;
7803 4C05              ;IF (type <> tree) AND (curr_mark = tree) THEN block_not_allocated
7804 4C05              ;
7805 4C05              chk_sapling                             ;
7806 4C05 AD C1 05              lda   curr_mark+2              ;is the mark in tree range
7807 4C08 4A                    lsr   a
7808 4C09 F0 27                 beq   index_loaded             ;mark not in tree range
7809 4C0B 80 4C                 bra   no_block
7810 4C0D
7811 4C0D              cont01                                  ;
7812 4C0D A0 39 00              ldy   #index_blk_num
7813 4C10 D7 90                 cmp   [pro_fcr_ptr],y          ;is the block already loaded?
7814 4C12 F0 1E                 beq   index_loaded
7815 4C14 48                    pha                            ;save the block number
7816 4C15 A0 1F 00              ldy   #fcr_status
7817 4C18 B7 90                 lda   [pro_fcr_ptr],y
7818 4C1A 29 02 00              and   #index_dirty             ;is the current index dirty?
7819 4C1D F0 07                 beq   index1_clean
7820 4C1F 20 B8 19              jsr   flush_index
7821 4C22 90 02                 bcc   index1_clean
7822 4C24 FA                    plx   
7823 4C25 60                    rts   
7824 4C26              index1_clean                            ; 
7825 4C26 68                    pla                            ;retore block number
7826 4C27 A0 39 00              ldy   #index_blk_num
7827 4C2A 97 90                 sta   [pro_fcr_ptr],y          ;save the new block please
7828 4C2C 20 68 4C              jsr   load_index
7829 4C2F 90 01                 bcc   index_loaded
7830 4C31 60                    rts   
7831 4C32
7832 4C32              index_loaded                            ; 
7833 4C32 AD C0 05              lda   curr_mark+1
7834 4C35 4A                    lsr   a
7835 4C36 29 FF 00              and   #$00FF
7836 4C39 A6 B4                 ldx   index_ptr                ;get the block number from index block
7837 4C3B A4 B6                 ldy   index_ptr+2
7838 4C3D 20 6D 4A              jsr   get_index_blk            ;A = block number
7839 4C40 AA                    tax   
7840 4C41 D0 0B                 bne   exit_chk_alloc
7841 4C43              ;
7842 4C43              ;IF (type = sapling) AND (data = sparse) THEN block_not_allocated
7843 4C43              ;
7844 4C43 A0 02 00              ldy   #fcr_storage
7845 4C46 B7 90                 lda   [pro_fcr_ptr],y
7846 4C48 C9 20 00              cmp   #sapling_type            ;does this puppy even have an index blk
7847 4C4B 90 03                 bcc   chk_seedling             ;there is no index block
7848 4C4D 8A                    txa                            ;reset the flag please
7849 4C4E
7850 4C4E              exit_chk_alloc                          ; 
7851 4C4E 18                    clc   
7852 4C4F 60                    rts   
7853 4C50
7854 4C50              chk_seedling  
7855 4C50 AD C0 05              lda   curr_mark+1
7856 4C53 4A                    lsr   a
7857 4C54 29 FF 00              and   #$00FF
7858 4C57 F0 07                 beq   get_key_blk              ;mark < 512
7859 4C59              no_block  
7860 4C59 A2 00 00              ldx   #$0000
7861 4C5C E2 02                 sep   #$02                     ;set the 'Z' flag
7862 4C5E 18                    clc   
7863 4C5F 60                    rts   
7864 4C60
7865 4C60              get_key_blk                             ; 
7866 4C60 A0 09 00              ldy   #fcr_key_blk
7867 4C63 B7 90                 lda   [pro_fcr_ptr],y
7868 4C65 AA                    tax                            ;setup the x register with the block number
7869 4C66 18                    clc   
7870 4C67 60                    rts   
7871 4C68
7872 4C68                       EXPORT load_index
7873 4C68              load_index  
7874 4C68              ;enter with A = block number
7875 4C68
7876 4C68              ;next 3 lines added 8/6/90 by Monte Benaresh
7877 4C68 48                    pha                            ;save block # for a moment
7878 4C69 20 8D 15              jsr   standard_req             ;set drvr_req_cnt to $200
7879 4C6C 68                    pla                            ;restore block number
7880 4C6D
7881 4C6D 85 10                 sta   drvr_blk_num
7882 4C6F A5 B4                 lda   index_ptr
7883 4C71 85 04                 sta   drvr_buf_ptr
7884 4C73 A5 B6                 lda   index_ptr+2
7885 4C75 85 06                 sta   drvr_buf_ptr+2
7886 4C77 20 95 17              jsr   read_with_cache
7887 4C7A 60                    rts   
7888 4C7B
7889 4C7B                       ENDP 
7890 4C7B
7891 4C7B              ;==========================================================================
7892 4C7B              ;Clr_to_boundary        This routine will clear data from the current EOF
7893 4C7B              ;                       to the end of the block.
7894 4C7B              ;
7895 4C7B              ;Input:         A = undefined
7896 4C7B              ;               X = undefined
7897 4C7B              ;               Y = undefined
7898 4C7B              ;               P = nvmxdizc
7899 4C7B              ;                   ..000...
7900 4C7B              ;               b = k
7901 4C7B              ;
7902 4C7B              ;               curr_mark               ;current file marker
7903 4C7B              ;               curr_eof                ;current end of file
7904 4C7B              ;               pro_fcr_ptr             ;points to file control record
7905 4C7B              ;               data_ptr                ;points to data block in I/O buffer.
7906 4C7B              ;
7907 4C7B              ;Output:        A = undefined
7908 4C7B              ;               X = undefined
7909 4C7B              ;               Y = undefined
7910 4C7B              ;               P = nvmxdizc
7911 4C7B              ;                   ..000...
7912 4C7B              ;
7913 4C7B              ;               b = k
7914 4C7B              ;
7915 4C7B              ;
7916 4C7B              ; IF (eof >= (curr_mark AND $FE00 + 512)) THEN
7917 4C7B              ;    EXIT(clr_to_boundary)
7918 4C7B              ; IF eof > curr_mark THEN
7919 4C7B              ;    clear_index := eof
7920 4C7B              ; ELSE
7921 4C7B              ;    clear_index := curr_mark
7922 4C7B              ; clear_block
7923 4C7B              ;==========================================================================
7924 4C7B                       longa on
7925 4C7B                       longi on
7926 4C7B
7927 4C7B                       EXPORT clr_to_boundary
7928 4C7B              clr_to_boundary PROC 
7929 4C7B
7930 4C7B AD C3 05              lda   curr_eof
7931 4C7E 48                    pha   
7932 4C7F AD C5 05              lda   curr_eof+2               ;save the current end of file
7933 4C82 48                    pha   
7934 4C83
7935 4C83 AD BF 05              lda   curr_mark
7936 4C86 48                    pha                            ;save the current mark
7937 4C87 AD C1 05              lda   curr_mark+2
7938 4C8A 48                    pha   
7939 4C8B
7940 4C8B AD BF 05              lda   curr_mark                ;if block aligned then exit
7941 4C8E 29 FF 01              and   #$01FF
7942 4C91 D0 03                 bne   not_aligned
7943 4C93 82 96 00              brl   exit_clr                 ;we do not have to clear anything
7944 4C96
7945 4C96              not_aligned  
7946 4C96
7947 4C96              ;
7948 4C96              ;curr_mark := ((curr_mark and $FE00) + 512) ;
7949 4C96              ;
7950 4C96 18                    clc   
7951 4C97 AD BF 05              lda   curr_mark                ;move to a block boundary
7952 4C9A 29 00 FE              and   #$FE00
7953 4C9D 69 00 02              adc   #blk_size                ;add in 512 bytes
7954 4CA0 8D BF 05              sta   curr_mark
7955 4CA3 AD C1 05              lda   curr_mark+2
7956 4CA6 69 00 00              adc   #$0000
7957 4CA9 8D C1 05              sta   curr_mark+2
7958 4CAC              ;
7959 4CAC              ; IF (eof >= (curr_mark AND $FE00 + 512)) THEN
7960 4CAC              ;    EXIT(clr_to_boundary)
7961 4CAC              ;
7962 4CAC AD C5 05              lda   curr_eof+2
7963 4CAF CD C1 05              cmp   curr_mark+2
7964 4CB2 F0 04                 beq   chk_low
7965 4CB4 B0 76                 bcs   exit_clr                 ;EOF not in this block
7966 4CB6 90 08                 bcc   second_if                ;continue process
7967 4CB8              chk_low                                 ;
7968 4CB8 AD C3 05              lda   curr_eof
7969 4CBB CD BF 05              cmp   curr_mark
7970 4CBE B0 6C                 bcs   exit_clr                 ;EOF not in this block
7971 4CC0
7972 4CC0              ;
7973 4CC0              ; IF EOF < curr_mark AND $FE00 THEN
7974 4CC0              ;    clear_index := curr_mark
7975 4CC0              ;
7976 4CC0              second_if                               ; 
7977 4CC0 A3 03                 lda   3,s                      ;get the low word of the mark
7978 4CC2 29 00 FE              and   #$FE00
7979 4CC5 8D BF 05              sta   curr_mark
7980 4CC8
7981 4CC8 AD C5 05              lda   curr_eof+2
7982 4CCB C3 01                 cmp   1,s                      ;check high word
7983 4CCD F0 04                 beq   second_low
7984 4CCF B0 0C                 bcs   third_if                 ;EOF is in this block
7985 4CD1 90 1C                 bcc   use_mark                 ;EOF not in this block
7986 4CD3              second_low                              ; 
7987 4CD3 AD C3 05              lda   curr_eof
7988 4CD6 CD BF 05              cmp   curr_mark
7989 4CD9 B0 02                 bcs   third_if                 ;EOF is in the block
7990 4CDB 90 12                 bcc   use_mark                 ;EOF not in this block
7991 4CDD
7992 4CDD              ;
7993 4CDD              ; IF eof > curr_mark THEN
7994 4CDD              ;    clear_index := eof
7995 4CDD              ;
7996 4CDD              third_if                                ;
7997 4CDD AD C5 05              lda   curr_eof+2               ;is eof > curr_mark
7998 4CE0 C3 01                 cmp   1,s                      ;high word of curr_mark
7999 4CE2 F0 04                 beq   third_low
8000 4CE4 B0 12                 bcs   use_eof                  ;clear from EOF
8001 4CE6 90 07                 bcc   use_mark                 ;clear from current mark
8002 4CE8              third_low                               ;
8003 4CE8 AD C3 05              lda   curr_eof
8004 4CEB C3 03                 cmp   3,s
8005 4CED B0 09                 bcs   use_eof                  ;use the eof as the value
8006 4CEF
8007 4CEF              use_mark                                ; 
8008 4CEF A3 03                 lda   3,s                      ;get the low word of current mark
8009 4CF1 29 FF 01              and   #$01FF                   ;clear garbage
8010 4CF4 F0 36                 beq   exit_clr                 ;do not clear the buffer
8011 4CF6 80 08                 bra   do_clear
8012 4CF8
8013 4CF8              use_eof                                 ; 
8014 4CF8 AD C3 05              lda   curr_eof
8015 4CFB 29 FF 01              and   #$01FF
8016 4CFE F0 2C                 beq   exit_clr                 ;do not clear the buffer
8017 4D00
8018 4D00              do_clear  
8019 4D00 A8                    tay                            ;make an index into block
8020 4D01 C8                    iny   
8021 4D02 C0 00 02              cpy   #blk_size
8022 4D05 F0 25                 beq   exit_clr
8023 4D07 98                    tya                            ;can we clear the block fast
8024 4D08 4A                    lsr   a
8025 4D09 90 13                 bcc   clear_it_fast
8026 4D0B
8027 4D0B A9 00 00              lda   #$0000                   ;clear value
8028 4D0E                       longa off
8029 4D0E E2 20                 sep   #$20                     ;8 bit mode
8030 4D10 80 03                 bra   enter                    ;start the loop
8031 4D12              clear_it  
8032 4D12 97 B0                 sta   [data_ptr],y
8033 4D14 C8                    iny   
8034 4D15              enter     
8035 4D15 C0 00 02              cpy   #blk_size                ;are we done
8036 4D18 90 F8                 bcc   clear_it
8037 4D1A                       longa on
8038 4D1A C2 20                 rep   #$20
8039 4D1C 80 0E                 bra   exit_clr
8040 4D1E
8041 4D1E              clear_it_fast  
8042 4D1E A9 00 00              lda   #$0000
8043 4D21 80 04                 bra   enter_fast
8044 4D23              fast_loop  
8045 4D23 97 B0                 sta   [data_ptr],y
8046 4D25 C8                    iny   
8047 4D26 C8                    iny   
8048 4D27              enter_fast  
8049 4D27 C0 00 02              cpy   #$0200                   ;are we done
8050 4D2A 90 F7                 bcc   fast_loop
8051 4D2C
8052 4D2C
8053 4D2C              exit_clr                                ; 
8054 4D2C 68                    pla                            ;restore the curr_mark
8055 4D2D 8D C1 05              sta   curr_mark+2
8056 4D30 68                    pla   
8057 4D31 8D BF 05              sta   curr_mark
8058 4D34
8059 4D34 68                    pla   
8060 4D35 8D C5 05              sta   curr_eof+2               ;restore the current end of file
8061 4D38 68                    pla   
8062 4D39 8D C3 05              sta   curr_eof
8063 4D3C A9 04 80              lda   #data_dirty+file_dirty
8064 4D3F 20 F2 3E              jsr   set_fcr_status
8065 4D42 60                    rts   
8066 4D43                       ENDP 
8067 4D43              ;==========================================================================
8068 4D43              ;Close:         This routine will close a file.
8069 4D43              ;
8070 4D43              ;Created:       aug 04, 1987
8071 4D43              ;Modified:      aug 04, 1987
8072 4D43              ;Author:        Rob Turner
8073 4D43              ;
8074 4D43              ;Enter:         jml
8075 4D43              ;
8076 4D43              ;Input:         A = undefined
8077 4D43              ;               X = call number times 2
8078 4D43              ;               Y = class times 2
8079 4D43              ;               P = nvmxdizc
8080 4D43              ;                   ..000...
8081 4D43              ;               b = k
8082 4D43              ;
8083 4D43              ;Output:        A = error code if carry set
8084 4D43              ;               X = undefined
8085 4D43              ;               Y = undefined
8086 4D43              ;               P = nvmxdizc
8087 4D43              ;                   ..000..1 = error
8088 4D43              ;                          0 = no error
8089 4D43              ;               b = k
8090 4D43              ;
8091 4D43              ;Uses:          All registers
8092 4D43              ;               fill_io_buf
8093 4D43              ;
8094 4D43              ;Call Format:
8095 4D43              ;
8096 4D43              ;Class 0        Reference Number        (2 Bytes)
8097 4D43              ;
8098 4D43              ;Class 1        PCount                  (2 Bytes)
8099 4D43              ;               Reference Number        (2 Bytes)
8100 4D43              ;
8101 4D43              ;==========================================================================
8102 4D43                       longa on
8103 4D43                       longi on
8104 4D43
8105 4D43                       EXPORT close
8106 4D43              close    PROC 
8107 4D43
8108 4D43              ;==========================================================================
8109 4D43              ;First preprocess the call to setup the needed parameters.
8110 4D43              ;==========================================================================
8111 4D43
8112 4D43 20 9E 0E              jsr   setup_params
8113 4D46 CE 1F 03              dec   close_flag               ;call slug ripple please
8114 4D49 20 64 18              jsr   flush_file               ;force data to the disk
8115 4D4C 90 03                 bcc   flushed
8116 4D4E 4C 82 00              jmp   main_exit
8117 4D51
8118 4D51              flushed                                 ; 
8119 4D51 20 78 0E              jsr   remove_fcr
8120 4D54 4C 82 00              jmp   main_exit
8121 4D57
8122 4D57                       ENDP 
8123 4D57              ;==========================================================================
8124 4D57              ;flush:         This routine will flush a file.
8125 4D57              ;
8126 4D57              ;Created:       aug 04, 1987
8127 4D57              ;Modified:      aug 04, 1987
8128 4D57              ;Author:        Rob Turner
8129 4D57              ;
8130 4D57              ;Enter:         jml
8131 4D57              ;
8132 4D57              ;Input:         A = undefined
8133 4D57              ;               X = call number times 2
8134 4D57              ;               Y = class times 2
8135 4D57              ;               P = nvmxdizc
8136 4D57              ;                   ..000...
8137 4D57              ;               b = k
8138 4D57              ;
8139 4D57              ;Output:        A = error code if carry set
8140 4D57              ;               X = undefined
8141 4D57              ;               Y = undefined
8142 4D57              ;               P = nvmxdizc
8143 4D57              ;                   ..000..1 = error
8144 4D57              ;                          0 = no error
8145 4D57              ;               b = k
8146 4D57              ;
8147 4D57              ;Uses:          All registers
8148 4D57              ;               fill_io_buf
8149 4D57              ;
8150 4D57              ;Call Format:
8151 4D57              ;
8152 4D57              ;Class 0        Reference Number        (2 Bytes)
8153 4D57              ;
8154 4D57              ;Class 1        PCount                  (2 Bytes)
8155 4D57              ;               Reference Number        (2 Bytes)
8156 4D57              ;
8157 4D57              ;==========================================================================
8158 4D57                       longa on
8159 4D57                       longi on
8160 4D57
8161 4D57                       EXPORT flush
8162 4D57              flush    PROC 
8163 4D57
8164 4D57              ;==========================================================================
8165 4D57              ;First preprocess the call to setup the needed parameters.
8166 4D57              ;==========================================================================
8167 4D57
8168 4D57 20 9E 0E              jsr   setup_params
8169 4D5A CE 1F 03              dec   close_flag               ;call slug_ripple please
8170 4D5D
8171 4D5D              ;       New code added March 27, 1990 to support fast/slow flush,
8172 4D5D              ;       by Monte Benaresh, based on Andy Stadler's proposed
8173 4D5D              ;       changes.
8174 4D5D
8175 4D5D AD B7 05              lda   pcount                   ;check number of params given by caller
8176 4D60 C9 02 00              cmp   #2                       ;did he specify type of flush?
8177 4D63 90 15                 bcc   slow_flush               ;too few, default to full flush
8178 4D65
8179 4D65              choose_flush                            ;caller specified type of flush
8180 4D65              ;               valid flush types are:
8181 4D65              ;                       $0000 = full flush, data and directory blocks
8182 4D65              ;                       $8000 = fast flush, data blocks only
8183 4D65
8184 4D65 A0 04 00              ldy   #4                       ;offset to flush type in param block
8185 4D68 B7 32                 lda   [param_blk_ptr],y        ;get flush type
8186 4D6A
8187 4D6A 0A                    asl   a                        ;get high bit
8188 4D6B F0 06                 beq   flush_type_ok            ;low bits must be 0!
8189 4D6D
8190 4D6D              bad_flush_type                          ;invalid value for flush type
8191 4D6D A9 53 00              lda   #parm_range_err
8192 4D70 38                    sec   
8193 4D71 80 0A                 bra   flush_done               ;return with error
8194 4D73
8195 4D73              flush_type_ok                           ;get here with high bit of flush type in carry
8196 4D73 90 05                 bcc   slow_flush               ;flush type was $0000
8197 4D75
8198 4D75              fast_flush                              ;flush type was $8000
8199 4D75 20 69 18              jsr   do_fast_flush            ;write out all dirty data blocks, dirty
8200 4D78              ;                                        bitmap blocks, and the directory entry
8201 4D78              ;                                        only if it's been changed (mod date doesn't count!)
8202 4D78 80 03                 bra   flush_done               ;handle error elsewhere
8203 4D7A              slow_flush  
8204 4D7A 20 64 18              jsr   flush_file               ;force data to the disk
8205 4D7D
8206 4D7D              flush_done  
8207 4D7D 4C 82 00              jmp   main_exit
8208 4D80
8209 4D80                       ENDP 
8210 4D80              ;==========================================================================
8211 4D80              ;Set_mark:      This routine will set a file position marker.
8212 4D80              ;
8213 4D80              ;Created:       may 23, 1987
8214 4D80              ;Modified:      may 23, 1987
8215 4D80              ;Author:        Rob Turner
8216 4D80              ;
8217 4D80              ;Enter:         jml
8218 4D80              ;
8219 4D80              ;Input:         A = undefined
8220 4D80              ;               X = call number times 2
8221 4D80              ;               Y = class times 2
8222 4D80              ;               P = nvmxdizc
8223 4D80              ;                   ..000...
8224 4D80              ;               b = k
8225 4D80              ;
8226 4D80              ;Output:        A = error code if carry set
8227 4D80              ;               X = undefined
8228 4D80              ;               Y = undefined
8229 4D80              ;               P = nvmxdizc
8230 4D80              ;                   ..000..1 = error
8231 4D80              ;                          0 = no error
8232 4D80              ;               b = k
8233 4D80              ;
8234 4D80              ;Uses:          All registers
8235 4D80              ;               fill_io_buf
8236 4D80              ;
8237 4D80              ;Call Format:
8238 4D80              ;
8239 4D80              ;Class 0        Reference Number        (2 Bytes)
8240 4D80              ;               File Position           (4 Bytes)
8241 4D80              ;
8242 4D80              ;Class 1        PCount                  (2 Bytes)
8243 4D80              ;               Reference Number        (2 Bytes)
8244 4D80              ;               Base                    (2 Bytes)
8245 4D80              ;                       00 = Absolute
8246 4D80              ;                       01 = Backward From EOF
8247 4D80              ;                       02 = Forward From Current Mark
8248 4D80              ;                       03 = Backward From Current Mark
8249 4D80              ;               Displacement            (4 Bytes)
8250 4D80              ;
8251 4D80              ;==========================================================================
8252 4D80                       longa on
8253 4D80                       longi on
8254 4D80
8255 4D80                       EXPORT set_mark
8256 4D80              set_mark PROC 
8257 4D80
8258 4D80              ;==========================================================================
8259 4D80              ;First preprocess the call to setup the needed parameters.
8260 4D80              ;==========================================================================
8261 4D80 9C 85 05              stz   base
8262 4D83 20 9E 0E              jsr   setup_params
8263 4D86 F0 0B                 beq   class0
8264 4D88
8265 4D88              ;==========================================================================
8266 4D88              ;Fall thru if this is a class1 call
8267 4D88              ;==========================================================================
8268 4D88 A0 02 00              ldy   #pblk_16_base
8269 4D8B 20 B8 4D              jsr   check_base
8270 4D8E A0 04 00              ldy   #pblk_16_disp
8271 4D91 80 03                 bra   main_entry
8272 4D93
8273 4D93              class0                                  ;
8274 4D93
8275 4D93              ;==========================================================================
8276 4D93              ;If this is a class zero call then setup an index to the file position
8277 4D93              ;and continue on.
8278 4D93              ;==========================================================================
8279 4D93 A0 02 00              ldy   #$0002                   ;index to displacement
8280 4D96
8281 4D96              main_entry                              ;
8282 4D96
8283 4D96              ;==========================================================================
8284 4D96              ;Save the user's requested displacement
8285 4D96              ;==========================================================================
8286 4D96
8287 4D96 B7 80                 lda   [my_pblk_ptr],y
8288 4D98 8D 87 05              sta   displacement
8289 4D9B C8                    iny   
8290 4D9C C8                    iny   
8291 4D9D B7 80                 lda   [my_pblk_ptr],y
8292 4D9F
8293 4D9F 8D 89 05              sta   displacement+2
8294 4DA2
8295 4DA2              ;==========================================================================
8296 4DA2              ;Setup 'curr_eof' and 'curr_mark'
8297 4DA2              ;
8298 4DA2              ;               IF (curr_mark < 00) or (curr_mark > EOF) THEN
8299 4DA2              ;                  BEGIN
8300 4DA2              ;                     Error:= position_out_of_range_error
8301 4DA2              ;                     EXIT(Set_Mark)
8302 4DA2              ;                  END
8303 4DA2              ;==========================================================================
8304 4DA2
8305 4DA2 20 C9 4D              jsr   calc_curr_mark
8306 4DA5 90 06                 bcc   set_the_mark
8307 4DA7 A9 4D 00              lda   #out_of_range
8308 4DAA
8309 4DAA              set_mark_exit   
8310 4DAA 4C 82 00              jmp   main_exit
8311 4DAD
8312 4DAD              set_the_mark  
8313 4DAD              ;==========================================================================
8314 4DAD              ;refill I/O buffer with the new data blocks needed.
8315 4DAD              ;==========================================================================
8316 4DAD
8317 4DAD 20 50 42              jsr   fill_io_buf
8318 4DB0 B0 F8                 bcs   set_mark_exit
8319 4DB2
8320 4DB2              ;==========================================================================
8321 4DB2              ;go and update the FCR with the new curr_mark.
8322 4DB2              ;==========================================================================
8323 4DB2
8324 4DB2 20 B7 45              jsr   save_curr_mark
8325 4DB5 18                    clc   
8326 4DB6
8327 4DB6              ;==========================================================================
8328 4DB6              ;Exit all happy since the call was successful
8329 4DB6              ;==========================================================================
8330 4DB6
8331 4DB6 80 F2                 bra   set_mark_exit
8332 4DB8
8333 4DB8                       ENDP 
8334 4DB8
8335 4DB8              ;==========================================================================
8336 4DB8              ;check_base     This routine will verify that the base is within range
8337 4DB8              ;
8338 4DB8              ;Created:       may 23, 1987
8339 4DB8              ;Modified:      may 23, 1987
8340 4DB8              ;Author:        Rob Turner
8341 4DB8              ;
8342 4DB8              ;
8343 4DB8              ;Enter:         jsr
8344 4DB8              ;
8345 4DB8              ;Input:         A = undefined
8346 4DB8              ;               X = undefined
8347 4DB8              ;               Y = offset to base field
8348 4DB8              ;               P = nvmxdizc
8349 4DB8              ;                   ..000...
8350 4DB8              ;               b = k
8351 4DB8              ;
8352 4DB8              ;
8353 4DB8              ;Output:        A = undefined
8354 4DB8              ;               X = undefined
8355 4DB8              ;               Y = undefined
8356 4DB8              ;               P = nvmxdizc
8357 4DB8              ;                   ..000..1 = error
8358 4DB8              ;                          0 = no error
8359 4DB8              ;               b = k
8360 4DB8              ;
8361 4DB8              ;               BASE                    (contains value of the base)
8362 4DB8              ;
8363 4DB8              ;Uses:          All registers
8364 4DB8              ;
8365 4DB8              ;==========================================================================
8366 4DB8                       longa on
8367 4DB8                       longi on
8368 4DB8
8369 4DB8                       EXPORT check_base
8370 4DB8              check_base PROC 
8371 4DB8
8372 4DB8 B7 80                 lda   [my_pblk_ptr],y
8373 4DBA C9 04 00              cmp   #max_base+1
8374 4DBD B0 04                 bcs   range_error
8375 4DBF 8D 85 05              sta   base
8376 4DC2 60                    rts   
8377 4DC3
8378 4DC3                       EXPORT range_error
8379 4DC3              range_error                             ;
8380 4DC3 A9 53 00              lda   #parm_range_err
8381 4DC6 4C 82 00              jmp   main_exit
8382 4DC9                       ENDP 
8383 4DC9
8384 4DC9              ;==========================================================================
8385 4DC9              ;calc_curr_mark This routine will calculate the current mark for a file
8386 4DC9              ;               given BASE and DISPLACEMENT as input.
8387 4DC9              ;
8388 4DC9              ;Created:       may 23, 1987
8389 4DC9              ;Modified:      may 23, 1987
8390 4DC9              ;Author:        Rob Turner
8391 4DC9              ;
8392 4DC9              ;
8393 4DC9              ;Enter:         jsr
8394 4DC9              ;
8395 4DC9              ;Input:         A = undefined
8396 4DC9              ;               X = undefined
8397 4DC9              ;               Y = undefined
8398 4DC9              ;               P = nvmxdizc
8399 4DC9              ;                   ..000...
8400 4DC9              ;               b = k
8401 4DC9              ;
8402 4DC9              ;               BASE                    (base from param block)
8403 4DC9              ;                       $00 = Absolute
8404 4DC9              ;                       $01 = Backward From EOF
8405 4DC9              ;                       $02 = Forward From Current Mark
8406 4DC9              ;                       $03 = Backward From Current Mark
8407 4DC9              ;
8408 4DC9              ;               DISPLACEMENT            (displacement from param block)
8409 4DC9              ;               pro_fcr_ptr             (pointer to my data in FCR
8410 4DC9              ;
8411 4DC9              ;Output:        A = undefined
8412 4DC9              ;               X = undefined
8413 4DC9              ;               Y = undefined
8414 4DC9              ;               P = nvmxdizc
8415 4DC9              ;                   .<<000..1 = error if out of range
8416 4DC9              ;                    |     0 = no error
8417 4DC9              ;                    |
8418 4DC9              ;                    |__   1 = error out of range any cases
8419 4DC9              ;                          0 = result greater then current EOF
8420 4DC9              ;
8421 4DC9              ;               b = k
8422 4DC9              ;
8423 4DC9              ;               curr_mark               (contains correct position for mark)
8424 4DC9              ;
8425 4DC9              ;Uses:          All registers
8426 4DC9              ;
8427 4DC9              ;==========================================================================
8428 4DC9                       longa on
8429 4DC9                       longi on
8430 4DC9
8431 4DC9                       EXPORT calc_curr_mark
8432 4DC9              calc_curr_mark PROC 
8433 4DC9
8434 4DC9              ;==========================================================================
8435 4DC9              ;Setup the current EOF
8436 4DC9              ;==========================================================================
8437 4DC9 20 A7 45              jsr   setup_curr_eof
8438 4DCC
8439 4DCC              ;==========================================================================
8440 4DCC              ;Setup the current file marker.
8441 4DCC              ;==========================================================================
8442 4DCC 20 97 45              jsr   setup_curr_mark
8443 4DCF
8444 4DCF              ;==========================================================================
8445 4DCF              ;Now we need to decide which way we need to move the mark.
8446 4DCF              ;==========================================================================
8447 4DCF
8448 4DCF AD 85 05              lda   base
8449 4DD2 F0 4C                 beq   absolute
8450 4DD4 3A                    dec   a
8451 4DD5 F0 1B                 beq   back_from_eof
8452 4DD7 3A                  